/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.rasp.install;

import com.baidu.rasp.RaspError;
import com.baidu.rasp.install.Installer;
import java.io.File;

public abstract class InstallerFactory {
    protected static final String TOMCAT = "Tomcat";
    protected static final String JBOSS = "JBoss 4-6";
    protected static final String RESIN = "Resin";

    protected abstract Installer getInstaller(String var1, String var2);

    public Installer getInstaller(File serverRoot) throws RaspError {
        if (!serverRoot.exists()) {
            throw new RaspError(RaspError.E10002 + serverRoot.getPath());
        }
        String serverName = InstallerFactory.detectServerName(serverRoot.getAbsolutePath());
        if (serverName == null) {
            System.out.println("List of currently supported servers are:");
            System.out.println("- Tomcat");
            System.out.println("- Resin");
            System.out.println("- JBoss 4-6\n");
            throw new RaspError(RaspError.E10004 + serverRoot.getPath());
        }
        System.out.println("Detected application server type: " + serverName);
        return this.getInstaller(serverName, serverRoot.getAbsolutePath());
    }

    public static String detectServerName(String serverRoot) {
        if (new File(serverRoot, "bin/catalina.sh").exists() || new File(serverRoot, "bin/catalina.bat").exists()) {
            return TOMCAT;
        }
        if (new File(serverRoot, "bin/probe.sh").exists() || new File(serverRoot, "bin/probe.bat").exists() || new File(serverRoot, "bin/twiddle.sh").exists() || new File(serverRoot, "bin/twiddle.bat").exists()) {
            return JBOSS;
        }
        if (new File(serverRoot, "bin/httpd.sh").exists() || new File(serverRoot, "bin/resin.sh").exists()) {
            return RESIN;
        }
        return null;
    }
}

