/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.rasp.install;

import com.baidu.rasp.RaspError;
import com.baidu.rasp.install.Installer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public abstract class BaseStandardInstaller
implements Installer {
    private String serverName;
    private String serverRoot;
    public static String resinPath;
    public static int NOTFOUND;
    public static int FOUND;
    public static int DONE;
    public static String LINE_SEP;

    public BaseStandardInstaller(String serverName, String serverRoot) {
        this.serverName = serverName;
        this.serverRoot = serverRoot;
        resinPath = serverRoot;
    }

    @Override
    public void install() throws RaspError, IOException {
        File script;
        String jarPath = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        File srcDir = new File(new File(jarPath).getParent() + File.separator + "rasp");
        if (!srcDir.exists() || !srcDir.isDirectory()) {
            srcDir = new File("rasp");
        }
        File installDir = new File(this.getInstallPath(this.serverRoot));
        if (!srcDir.getCanonicalPath().equals(installDir.getCanonicalPath())) {
            System.out.println("Duplicating \"rasp\" directory\n- " + installDir.getCanonicalPath());
            FileUtils.copyDirectory(srcDir, installDir);
        }
        System.out.println("Make \"rasp\" directory writable\n");
        BaseStandardInstaller.modifyFolerPermission(installDir.getCanonicalPath());
        if (!this.generateConfig(installDir.getPath())) {
            System.exit(1);
        }
        if (!(script = new File(this.getScript(installDir.getPath()))).exists()) {
            throw new RaspError(RaspError.E10003 + script.getAbsolutePath());
        }
        System.out.println("Updating startup script\n- " + script.getCanonicalPath());
        String original = BaseStandardInstaller.read(script);
        String modified = this.modifyStartScript(original);
        BaseStandardInstaller.write(script, modified);
        System.out.println("\nInstallation completed without errors.\nPlease restart application server to take effect.");
    }

    private boolean generateConfig(String dir) {
        try {
            String sep = File.separator;
            File target = new File(dir + sep + "conf" + sep + "rasp.properties");
            System.out.println("Generating \"rasp.properties\"\n- " + target.getAbsolutePath());
            if (target.exists()) {
                System.out.println("- Already exists, continuing ..");
                return true;
            }
            System.out.println("- Create " + target.getAbsolutePath());
            target.getParentFile().mkdir();
            target.createNewFile();
            FileWriter writer = new FileWriter(target);
            InputStream is = this.getClass().getResourceAsStream("/rasp.properties");
            IOUtils.copy(is, (Writer)writer, "UTF-8");
            is.close();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String read(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        byte[] data = new byte[(int)file.length()];
        fis.read(data);
        fis.close();
        return new String(data);
    }

    public static void write(File file, String content) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        writer.write(content);
        writer.close();
    }

    public static String runCommand(String[] args) {
        try {
            String line;
            Process p = Runtime.getRuntime().exec(args);
            BufferedReader buffer = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = buffer.readLine()) != null) {
                sb.append(line).append("\n");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    public static void modifyFolerPermission(String folderPath) {
        if (System.getProperty("os.name").startsWith("Windows")) {
            String string = BaseStandardInstaller.runCommand(new String[]{"cmd", "/c", "echo Y|%SYSTEMROOT%\\System32\\cacls \"" + folderPath + "\" /G everyone:F"});
        } else if (System.getProperty("user.name").equals("root")) {
            BaseStandardInstaller.runCommand(new String[]{"chmod", "-R", "o+w", folderPath});
        }
    }

    protected abstract String getInstallPath(String var1);

    protected abstract String getScript(String var1);

    protected abstract String modifyStartScript(String var1) throws RaspError;

    static {
        NOTFOUND = 0;
        FOUND = 1;
        DONE = 2;
        LINE_SEP = System.getProperty("line.separator");
    }
}

