/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.rasp;

import com.baidu.rasp.install.Installer;
import com.baidu.rasp.install.InstallerFactory;
import com.baidu.rasp.install.linux.LinuxInstallerFactory;
import com.baidu.rasp.install.windows.WindowsInstallerFactory;
import com.baidu.rasp.uninstall.Uninstaller;
import com.baidu.rasp.uninstall.UninstallerFactory;
import com.baidu.rasp.uninstall.linux.LinuxUninstallerFactory;
import com.baidu.rasp.uninstall.windows.WindowsUninstallerFactory;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;

public class App {
    private static InstallerFactory newInstallerFactory() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return new WindowsInstallerFactory();
        }
        return new LinuxInstallerFactory();
    }

    private static UninstallerFactory newUninstallerFactory() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return new WindowsUninstallerFactory();
        }
        return new LinuxUninstallerFactory();
    }

    private static void showBanner() {
        String banner = "OpenRASP Installer for Java app servers - Copyright \u00a92017 Baidu Inc.\nFor more details visit: https://rasp.baidu.com/doc/install/software.html\n";
        System.out.println(banner);
    }

    private static void showHelp() {
        String helpMsg = "Usage:\njava -jar RaspInstall.jar <path/to/server_home>";
        System.out.println(helpMsg);
    }

    private static void showArgs() {
        String helpMsg = "Usage:\nargs error<install or uninstall> ";
        System.out.println(helpMsg);
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        App.showBanner();
        if (args.length < 2) {
            App.showHelp();
            return;
        }
        try {
            if ("-install".equals(args[0])) {
                File serverRoot = new File(args[1]);
                InstallerFactory factory = App.newInstallerFactory();
                Installer installer = factory.getInstaller(serverRoot);
                installer.install();
            } else if ("-uninstall".equals(args[0])) {
                File serverRoot = new File(args[1]);
                UninstallerFactory factory = App.newUninstallerFactory();
                Uninstaller uninstaller = factory.getUninstaller(serverRoot);
                uninstaller.uninstall();
            } else {
                App.showArgs();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage() + "\n");
        }
    }
}

