/* =========================================================
 * bootstrap-timepicker.js
 * http://www.github.com/jdewit/bootstrap-timepicker
 * =========================================================
 * Copyright 2012
 *
 * Created By:
 * Joris de Wit @joris_dewit
 *
 * Contributions By:
 * Gilbert @mindeavor
 * Koen Punt info@koenpunt.nl
 * Nek
 * Chris Martin
 * Dominic Barnes contact@dominicbarnes.us
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ========================================================= */!function(e){"use strict";var t=function(t,n){this.$element=e(t);this.options=e.extend({},e.fn.timepicker.defaults,n,this.$element.data());this.minuteStep=this.options.minuteStep||this.minuteStep;this.secondStep=this.options.secondStep||this.secondStep;this.showMeridian=this.options.showMeridian||this.showMeridian;this.showSeconds=this.options.showSeconds||this.showSeconds;this.showInputs=this.options.showInputs||this.showInputs;this.disableFocus=this.options.disableFocus||this.disableFocus;this.template=this.options.template||this.template;this.modalBackdrop=this.options.modalBackdrop||this.modalBackdrop;this.defaultTime=this.options.defaultTime||this.defaultTime;this.open=!1;this.init()};t.prototype={constructor:t,init:function(){if(this.$element.parent().hasClass("input-append")){this.$element.parent(".input-append").find(".add-on").on("click",e.proxy(this.showWidget,this));this.$element.on({focus:e.proxy(this.highlightUnit,this),click:e.proxy(this.highlightUnit,this),keypress:e.proxy(this.elementKeypress,this),blur:e.proxy(this.blurElement,this)})}else this.template?this.$element.on({focus:e.proxy(this.showWidget,this),click:e.proxy(this.showWidget,this),blur:e.proxy(this.blurElement,this)}):this.$element.on({focus:e.proxy(this.highlightUnit,this),click:e.proxy(this.highlightUnit,this),keypress:e.proxy(this.elementKeypress,this),blur:e.proxy(this.blurElement,this)});this.$widget=e(this.getTemplate()).appendTo("body");this.$widget.on("click",e.proxy(this.widgetClick,this));this.showInputs&&this.$widget.find("input").on({click:function(){this.select()},keypress:e.proxy(this.widgetKeypress,this),change:e.proxy(this.updateFromWidgetInputs,this)});this.setDefaultTime(this.defaultTime)},showWidget:function(t){t.stopPropagation();t.preventDefault();if(this.open)return;this.$element.trigger("show");this.disableFocus&&this.$element.blur();var n=e.extend({},this.$element.offset(),{height:this.$element[0].offsetHeight});this.updateFromElementVal();e("html").trigger("click.timepicker.data-api").one("click.timepicker.data-api",e.proxy(this.hideWidget,this));if(this.template==="modal")this.$widget.modal("show").on("hidden",e.proxy(this.hideWidget,this));else{this.$widget.css({top:n.top+n.height,left:n.left});this.open||this.$widget.addClass("open")}this.open=!0;this.$element.trigger("shown")},hideWidget:function(){this.$element.trigger("hide");this.template==="modal"?this.$widget.modal("hide"):this.$widget.removeClass("open");this.open=!1;this.$element.trigger("hidden")},widgetClick:function(t){t.stopPropagation();t.preventDefault();var n=e(t.target).closest("a").data("action");if(n){this[n]();this.update()}},widgetKeypress:function(t){var n=e(t.target).closest("input").attr("name");switch(t.keyCode){case 9:this.showMeridian?n=="meridian"&&this.hideWidget():this.showSeconds?n=="second"&&this.hideWidget():n=="minute"&&this.hideWidget();break;case 27:this.hideWidget();break;case 38:switch(n){case"hour":this.incrementHour();break;case"minute":this.incrementMinute();break;case"second":this.incrementSecond();break;case"meridian":this.toggleMeridian()}this.update();break;case 40:switch(n){case"hour":this.decrementHour();break;case"minute":this.decrementMinute();break;case"second":this.decrementSecond();break;case"meridian":this.toggleMeridian()}this.update()}},elementKeypress:function(e){var t=this.$element.get(0);switch(e.keyCode){case 0:break;case 9:this.updateFromElementVal();if(this.showMeridian){if(this.highlightedUnit!="meridian"){e.preventDefault();this.highlightNextUnit()}}else if(this.showSeconds){if(this.highlightedUnit!="second"){e.preventDefault();this.highlightNextUnit()}}else if(this.highlightedUnit!="minute"){e.preventDefault();this.highlightNextUnit()}break;case 27:this.updateFromElementVal();break;case 37:this.updateFromElementVal();this.highlightPrevUnit();break;case 38:switch(this.highlightedUnit){case"hour":this.incrementHour();break;case"minute":this.incrementMinute();break;case"second":this.incrementSecond();break;case"meridian":this.toggleMeridian()}this.updateElement();break;case 39:this.updateFromElementVal();this.highlightNextUnit();break;case 40:switch(this.highlightedUnit){case"hour":this.decrementHour();break;case"minute":this.decrementMinute();break;case"second":this.decrementSecond();break;case"meridian":this.toggleMeridian()}this.updateElement()}e.keyCode!==0&&e.keyCode!==8&&e.keyCode!==9&&e.keyCode!==46&&e.preventDefault()},setValues:function(e){if(this.showMeridian){var t=e.split(" "),n=t[0].split(":");this.meridian=t[1]}else var n=e.split(":");this.hour=parseInt(n[0],10);this.minute=parseInt(n[1],10);this.second=parseInt(n[2],10);isNaN(this.hour)&&(this.hour=0);isNaN(this.minute)&&(this.minute=0);if(this.showMeridian){this.hour>12?this.hour=12:this.hour<1&&(this.hour=1);if(this.meridian=="am"||this.meridian=="a")this.meridian="AM";else if(this.meridian=="pm"||this.meridian=="p")this.meridian="PM";this.meridian!="AM"&&this.meridian!="PM"&&(this.meridian="AM")}else this.hour>=24?this.hour=23:this.hour<0&&(this.hour=0);this.minute<0?this.minute=0:this.minute>=60&&(this.minute=59);this.showSeconds&&(isNaN(this.second)?this.second=0:this.second<0?this.second=0:this.second>=60&&(this.second=59));this.$element.val()!=""&&this.updateElement();this.updateWidget()},setMeridian:function(e){e=="a"||e=="am"||e=="AM"?this.meridian="AM":e=="p"||e=="pm"||e=="PM"?this.meridian="PM":this.updateWidget();this.updateElement()},setDefaultTime:function(e){if(e){if(e==="current"){var t=new Date,n=t.getHours(),r=Math.floor(t.getMinutes()/this.minuteStep)*this.minuteStep,i=Math.floor(t.getSeconds()/this.secondStep)*this.secondStep,s="AM";if(this.showMeridian)if(n===0)n=12;else if(n>=12){n>12&&(n-=12);s="PM"}else s="AM";this.hour=n;this.minute=r;this.second=i;this.meridian=s}else e==="value"?this.setValues(this.$element.val()):this.setValues(e);this.$element.val()!=""&&this.updateElement();this.updateWidget()}else{this.hour=0;this.minute=0;this.second=0}},formatTime:function(e,t,n,r){e=e<10?"0"+e:e;t=t<10?"0"+t:t;n=n<10?"0"+n:n;return e+":"+t+(this.showSeconds?":"+n:"")+(this.showMeridian?" "+r:"")},getTime:function(){return this.formatTime(this.hour,this.minute,this.second,this.meridian)},setTime:function(e){this.setValues(e);this.update()},update:function(){this.updateElement();this.updateWidget()},blurElement:function(){this.highlightedUnit=undefined;this.updateFromElementVal()},updateElement:function(){var e=this.getTime();this.$element.val(e).change();switch(this.highlightedUnit){case"hour":this.highlightHour();break;case"minute":this.highlightMinute();break;case"second":this.highlightSecond();break;case"meridian":this.highlightMeridian()}},updateWidget:function(){if(this.showInputs){this.$widget.find("input.bootstrap-timepicker-hour").val(this.hour<10?"0"+this.hour:this.hour);this.$widget.find("input.bootstrap-timepicker-minute").val(this.minute<10?"0"+this.minute:this.minute);this.showSeconds&&this.$widget.find("input.bootstrap-timepicker-second").val(this.second<10?"0"+this.second:this.second);this.showMeridian&&this.$widget.find("input.bootstrap-timepicker-meridian").val(this.meridian)}else{this.$widget.find("span.bootstrap-timepicker-hour").text(this.hour);this.$widget.find("span.bootstrap-timepicker-minute").text(this.minute<10?"0"+this.minute:this.minute);this.showSeconds&&this.$widget.find("span.bootstrap-timepicker-second").text(this.second<10?"0"+this.second:this.second);this.showMeridian&&this.$widget.find("span.bootstrap-timepicker-meridian").text(this.meridian)}},updateFromElementVal:function(e){var t=this.$element.val();if(t){this.setValues(t);this.updateWidget()}},updateFromWidgetInputs:function(){var t=e("input.bootstrap-timepicker-hour",this.$widget).val()+":"+e("input.bootstrap-timepicker-minute",this.$widget).val()+(this.showSeconds?":"+e("input.bootstrap-timepicker-second",this.$widget).val():"")+(this.showMeridian?" "+e("input.bootstrap-timepicker-meridian",this.$widget).val():"");this.setValues(t)},getCursorPosition:function(){var e=this.$element.get(0);if("selectionStart"in e)return e.selectionStart;if(document.selection){e.focus();var t=document.selection.createRange(),n=document.selection.createRange().text.length;t.moveStart("character",-e.value.length);return t.text.length-n}},highlightUnit:function(){var e=this.$element.get(0);this.position=this.getCursorPosition();this.position>=0&&this.position<=2?this.highlightHour():this.position>=3&&this.position<=5?this.highlightMinute():this.position>=6&&this.position<=8?this.showSeconds?this.highlightSecond():this.highlightMeridian():this.position>=9&&this.position<=11&&this.highlightMeridian()},highlightNextUnit:function(){switch(this.highlightedUnit){case"hour":this.highlightMinute();break;case"minute":this.showSeconds?this.highlightSecond():this.highlightMeridian();break;case"second":this.highlightMeridian();break;case"meridian":this.highlightHour()}},highlightPrevUnit:function(){switch(this.highlightedUnit){case"hour":this.highlightMeridian();break;case"minute":this.highlightHour();break;case"second":this.highlightMinute();break;case"meridian":this.showSeconds?this.highlightSecond():this.highlightMinute()}},highlightHour:function(){this.highlightedUnit="hour";this.$element.get(0).setSelectionRange(0,2)},highlightMinute:function(){this.highlightedUnit="minute";this.$element.get(0).setSelectionRange(3,5)},highlightSecond:function(){this.highlightedUnit="second";this.$element.get(0).setSelectionRange(6,8)},highlightMeridian:function(){this.highlightedUnit="meridian";this.showSeconds?this.$element.get(0).setSelectionRange(9,11):this.$element.get(0).setSelectionRange(6,8)},incrementHour:function(){if(this.showMeridian)if(this.hour===11)this.toggleMeridian();else if(this.hour===12)return this.hour=1;if(this.hour===23)return this.hour=0;this.hour=this.hour+1},decrementHour:function(){if(this.showMeridian){if(this.hour===1)return this.hour=12;this.hour===12&&this.toggleMeridian()}if(this.hour===0)return this.hour=23;this.hour=this.hour-1},incrementMinute:function(){var e=this.minute+this.minuteStep-this.minute%this.minuteStep;if(e>59){this.incrementHour();this.minute=e-60}else this.minute=e},decrementMinute:function(){var e=this.minute-this.minuteStep;if(e<0){this.decrementHour();this.minute=e+60}else this.minute=e},incrementSecond:function(){var e=this.second+this.secondStep-this.second%this.secondStep;if(e>59){this.incrementMinute();this.second=e-60}else this.second=e},decrementSecond:function(){var e=this.second-this.secondStep;if(e<0){this.decrementMinute();this.second=e+60}else this.second=e},toggleMeridian:function(){this.meridian=this.meridian==="AM"?"PM":"AM";this.update()},getTemplate:function(){if(this.options.templates[this.options.template])return this.options.templates[this.options.template];if(this.showInputs)var e='<input type="text" name="hour" class="bootstrap-timepicker-hour" maxlength="2"/>',t='<input type="text" name="minute" class="bootstrap-timepicker-minute" maxlength="2"/>',n='<input type="text" name="second" class="bootstrap-timepicker-second" maxlength="2"/>',r='<input type="text" name="meridian" class="bootstrap-timepicker-meridian" maxlength="2"/>';else var e='<span class="bootstrap-timepicker-hour"></span>',t='<span class="bootstrap-timepicker-minute"></span>',n='<span class="bootstrap-timepicker-second"></span>',r='<span class="bootstrap-timepicker-meridian"></span>';var i='<table class="'+(this.showSeconds?"show-seconds":"")+" "+(this.showMeridian?"show-meridian":"")+'">'+"<tr>"+'<td><a href="#" data-action="incrementHour"><i class="fa fa-chevron-up"></i></a></td>'+'<td class="separator">&nbsp;</td>'+'<td><a href="#" data-action="incrementMinute"><i class="fa fa-chevron-up"></i></a></td>'+(this.showSeconds?'<td class="separator">&nbsp;</td><td><a href="#" data-action="incrementSecond"><i class="fa fa-chevron-up"></i></a></td>':"")+(this.showMeridian?'<td class="separator">&nbsp;</td><td class="meridian-column"><a href="#" data-action="toggleMeridian"><i class="fa fa-chevron-up"></i></a></td>':"")+"</tr>"+"<tr>"+"<td>"+e+"</td> "+'<td class="separator">:</td>'+"<td>"+t+"</td> "+(this.showSeconds?'<td class="separator">:</td><td>'+n+"</td>":"")+(this.showMeridian?'<td class="separator">&nbsp;</td><td>'+r+"</td>":"")+"</tr>"+"<tr>"+'<td><a href="#" data-action="decrementHour"><i class="fa fa-chevron-down"></i></a></td>'+'<td class="separator"></td>'+'<td><a href="#" data-action="decrementMinute"><i class="fa fa-chevron-down"></i></a></td>'+(this.showSeconds?'<td class="separator">&nbsp;</td><td><a href="#" data-action="decrementSecond"><i class="fa fa-chevron-down"></i></a></td>':"")+(this.showMeridian?'<td class="separator">&nbsp;</td><td><a href="#" data-action="toggleMeridian"><i class="fa fa-chevron-down"></i></a></td>':"")+"</tr>"+"</table>",s;switch(this.options.template){case"modal":s='<div class="bootstrap-timepicker modal hide fade in" style="top: 30%; margin-top: 0; width: 200px; margin-left: -100px;" data-backdrop="'+(this.modalBackdrop?"true":"false")+'">'+'<div class="modal-header">'+'<a href="#" class="close" data-dismiss="modal">×</a>'+"<h3>Pick a Time</h3>"+"</div>"+'<div class="modal-content">'+i+"</div>"+'<div class="modal-footer">'+'<a href="#" class="btn btn-primary" data-dismiss="modal">Ok</a>'+"</div>"+"</div>";break;case"dropdown":s='<div class="bootstrap-timepicker dropdown-menu">'+i+"</div>"}return s}};e.fn.timepicker=function(n){return this.each(function(){var r=e(this),i=r.data("timepicker"),s=typeof n=="object"&&n;i||r.data("timepicker",i=new t(this,s));typeof n=="string"&&i[n]()})};e.fn.timepicker.defaults={minuteStep:15,secondStep:15,disableFocus:!1,defaultTime:"current",showSeconds:!1,showInputs:!0,showMeridian:!0,template:"dropdown",modalBackdrop:!1,templates:{}};e.fn.timepicker.Constructor=t}(window.jQuery);