# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2018-06-06 18:55
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Collection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('enabled', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=40, verbose_name='Solr index name pointing to')),
                ('label', models.CharField(max_length=100, verbose_name='Friendlier name in UI')),
                ('is_core_only', models.BooleanField(default=False)),
                ('cores', models.TextField(default='{}', help_text='Solr json', verbose_name='Collection with cores data')),
                ('properties', models.TextField(default='{}', help_text='Hue properties (e.g. results by pages number)', verbose_name='Properties')),
            ],
        ),
        migrations.CreateModel(
            name='Facet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('enabled', models.BooleanField(default=True)),
                ('data', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='Result',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('data', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='Sorting',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('data', models.TextField()),
            ],
        ),
        migrations.AddField(
            model_name='collection',
            name='facets',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='search.Facet'),
        ),
        migrations.AddField(
            model_name='collection',
            name='owner',
            field=models.ForeignKey(default=None, help_text='User who created the job.', null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Owner'),
        ),
        migrations.AddField(
            model_name='collection',
            name='result',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='search.Result'),
        ),
        migrations.AddField(
            model_name='collection',
            name='sorting',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='search.Sorting'),
        ),
    ]
