# Gutencopy Guidelines

## Longer Text
Guidelines for writing multi-line/step instructions or narrative introductions/orientation to pages or features.

This will obviously vary quite a lot depending on the context, but here are some general tips:

#### ONE: Contractions are your friends!
They’re more conversational, and a simple way to make text sound friendlier and less formal. (And they save a bit of space as well: a win-win.)

#### TWO: Cut phrases that inflate your word count without actually adding meaning. 
This happens frequently in two specific instances. First, when writing in the passive voice:

> This block can be used to display single images.

Any time you see phrases like “can be” or “is used”: halt. You’re writing in the passive voice. Try going active for a snappier (and shorter) sentence:

> This block displays single images.

Second, this happens when we hedge instead of making declarative statements:

> The gallery block can help you display multiple images in an elegant layout.

Does it or doesn’t it? We’re making this software: we’re allowed to be declarative about what it is and does:

> The gallery block displays multiple images in an elegant layout.

We also all do this a lot with the phrase “allows you to.” 

> Preformatted text allows you to keep your tabs and line breaks.

Features don’t allow anyone to do anything; they’re just tools that do specific things to achieve an end. Just say what they do:

> Preformatted text preserves your tabs and line breaks.

The more direct sentences are almost always clearer. Scan your copy for the words “can,” “be,” “might,” “allows you to,” and “helps” -- they’re the most common culprits, and looking for those words specifically is a way to locate phrasing you can tighten up. 

#### THREE: Beware of “simple,” “easy,” and “just.” 
It is not for us to decide what is simple: it’s for the user to decide. If we say something is easy and the user doesn’t have an easy experience, it undermines their trust in us and what we’re building. Same goes for “just” -- many of us know to avoid “simple,” but still use “just” all the time. “Just click here.” “Just enter your username.” It’s the same thing: it implies that something will be no big deal, but we can’t know what the user will find to be a big deal.

It’s also safer and more helpful to be specific. “Easy” and “simple” are shorthand for explanations that we haven’t written; whenever you see them, take a minute to think about what they’re standing in for. Maybe “It’s easy to add a block by hitting ‘enter’” really means “You can add more content to the page without taking your hands off the keyboard.” Great! Say the specific thing instead of relying on “easy.”

This isn’t to say that you should banish these words from your vocabulary. You might want to write a tooltip describing how the cover image block now requires less configuration, or an email about how we’re building a tool for quick creation of custom blocks, and you could legitimately say that the cover image block has been simplified or that we’re working to make custom block creation easier -- there, the terms are descriptive and relative. But be on the lookout for ways you might be using (or overusing) them to make absolute claims that something is easy or simple, and use those as opportunities to be more specific and clear.

#### FOUR: Look out for “we.”
Any time text or instructions uses “we” a lot, it means the focus of the text is on the people behind the software and not the people using the software. Sometimes that’s what you actually want -- but it’s usually not. The focus should typically be on the user, what they need, and how they benefit rather than “what we did” or “what we want.” 

We’re the only ones that care about what we did or want; the user just wants software that works. If you see a lot of “we”s, think about whether you should reframe what you’re writing to focus on the benefits to and successes of the user.

## Bulleted Lists
Guidelines for (duh) writing bulleted lists.

#### ONE: Keep sentence structures parallel across all bullets.
Parallel structure makes lists easier to read quickly -- their predictability takes some cognitive load off the reader.	

GOOD:
What can you do with this block? Lots of things!
* Add a quote.
* Highlight a link.
* Display multiple images.
* Create a bulleted list.

Every bullet is a full sentence, and ends with a period. (If your list is a bunch of one- or two-word items, those can often just turn into a single regular sentence -- easier to read, and space-saving.) Every line begins with a verb that tells the user what the block can do. The subject of the sentence is always the user. 

A user can absorb this list quickly because once they read the first item, they understand how to read the rest and know what information they’ll find.

LESS GOOD:
What can you do with this block? Lots of things!
* You can add a quote.
* Highlighting a link you love.
* It displays multiple images. Nice for galleries!
* Bulleted lists

Here, every line has different phrasing (some start with a verb, some with a noun) and the subject of the sentence changes (sometimes it’s you, sometimes it’s the block). Some lines have added description, some don't. There’s an incomplete sentence, and punctuation is inconsistent.

Reading this list takes more work because the reader has to parse each bullet anew. They can’t assume each bullet will contain similar information.

Note: this doesn't mean every bullet has to be super short and start with an action verb! “Predicable” doesn’t have to mean “simple.” It just means that each bullet should have the same sentence structure. This list would also be fine:

What can you do with this block? Lots of things!
* Try adding a quote. Sometimes someone else said things best!
* Use it to highlight a link you love -- sharing links is the currency of the internet.
* Create a gallery that displays multiple images, and show off your best photos.

Here, each bullet starts with a more user-focused verb and includes a piece of supplemental information for more interest. The punctuation varies a bit, which keeps the lines from feeling too formulaic, but since the basic structure of each is the same, they remain easy to read.

#### TWO: When in doubt, start with a verb. (But not always the same verb.)
Do you have to start with a verb? No. But if you’re at a loss, you usually can’t go wrong with a verb (especially since bulleted lists are often describing a series of actions or possible actions).

In a simple list that’s meant to be purely instructional (e.g., in UI copy where you just need the user to make a decision), it might be fine to start every bullet with the same verb:

To continue, choose an action:
Add a simple text block.
Add a pullquote block.
Add an image block.

If your list is more persuasive (e.g., trying to convince someone to use a feature by listing its benefits) or includes multi-step instructions, you’ll want to vary your verbs to keep the reader engaged with more interesting language, as in the example above:

What can you do with this block? Lots of things!
* Try adding a quote. Sometimes someone else said things best!
* Use it to highlight a link you love -- sharing links is the currency of the internet.
* Create a gallery that displays multiple images, and show off your best photos.

These aren’t hard-and-fast rules -- you might choose the use the same verb in a persuasive list to be more focused and powerful, for example. But they’re good starting places for solid lists. 

#### THREE: When something's clearly a list, you don't have to tell us it's a list.

GOOD:
What can you do with this block? Lots of things!
* Add a quote.
* Highlight a link you love.
* Display multiple images.

LESS GOOD:
What can you do with this block? Lots of things! Here are some examples of ways you can use it.
* You can add a quote.
* Highlighting a link you love.
* It displays multiple images. Nice for galleries!

Find the balance between being as clear as possible and trusting a user. On one hand, we know that people don’t always read instructions; on the other, redundancy can make the user feel like we think they’re stupid.

#### FOUR: Bold is sometimes your friend.
Use it to focus readers on the key information in a bulleted list. This is especially useful when your bullets include some supplemental but ultimately secondary information. 

“Key information” is, well, key: bold draws the eye, so stick to the most vital piece of information in a given bullet:

What can you do with this block? Lots of things!
* Try adding a quote. Sometimes someone else said things best!
* Use it to highlight a link you love -- sharing links is the currency of the internet.
* Create a gallery that displays multiple images, and show off your best photos.

On the flipside, bolding too many things creates visual confusion:

What can you do with this block? Lots of things!
* Try adding a quote. Sometimes someone else said things best!
* Use it to highlight a link you love -- sharing links is the currency of the internet.
* Create a gallery that displays multiple images, and show off your best photos.

When lists are short and basic, don't bother -- bolding just adds busy-ness. 

What can you do with this block? Lots of things!
* Add a quote.
* Highlight a link.
* Display multiple images.

The lack of words creates its own focus; you don't have to add any more.

## UI Descriptions
Guidelines for writing one-line feature descriptions, or short descriptions to clarify options.

#### ONE: Clarity above all! 
If the user doesn't understand what using a particular option will result in, it doesn't matter how clever your pun is. Wordplay and idioms are frequently unclear, and easily misunderstood. If you use them at all, they should be as supplemental information -- never to explain the main idea -- and they should be something you’re fairly certain will be understandable to a pretty wide range of people.

#### TWO: Refer back to section one, and look out for those bulk-adding phrases.
Active voice is typically the better way to go, and cutting out the bulky phrasing is particularly important when you’ve got limited space and you need people to be able to make decisions and act. 

Another, UI instruction-particular phrase you can often tighten:

“When you click X, Y happens.” > “Click X do to Y.”
“When you click the “settings” button, the pop-up will display the advanced settings that are available.” VS.
“Click “settings” to access the advanced settings.”

We sometimes think that adding the extra words helps the user feel like they’re being walked through the product, but most of the time, they really are just extra words. 

Similar are “Once you do X…” or “If you want to do X.” Sometimes there are decision points where “If you want to do X” is entirely appropriate and needed because there are different paths the user can take based on their goal, but we often use it to mean “Here is a thing you can do,” which you can express more simply with something like “To do X…”

#### THREE: Be specific.
When an action depends on the user having completed some prior action, be specific about what’s required and what happens next. We often default to “when you’re ready.”
Ready for what? Be specific about whatever the prerequisites are.

“When you’re ready” can mean:

“When you want to add another block”
“When you’re satisfied with your post”
“After you’ve finished proofreading your post”
“When you’d like to add a featured image”
“After you’ve configured all the settings”

And when something means everything, it actually means nothing. The more specific instructions are, the more useful they are, and the more trust the person following them will have in the product.

#### FOUR: This is still writing. It should have personality and interest.
Clarity above all, yes, and space is often limited here -- but UI text can still be interesting to read.

Single lines of description can still be complete sentences. 

List. Numbered or bulleted.

vs.

Add a list, either numbered or bulleted.

You can still use contractions. 

Add a list. We will provide formatting options.

vs.

Add a bulleted list -- we’ll give you some formatting options.

You can still use punctuation -- em dashes, colons, semicolons -- to control the flow of your words, link ideas, and create pauses. 

List. Numbered or bulleted.

vs.

Add a list -- numbered or bulleted. Your choice!

You can still try to avoid jargon in favor of plain language.

Add unordered or ordered list.

vs.

Add a list, either numbered or bulleted.

(And because it bears repeating: no wordplay, please! “Personality” can -- and in UI instructions, should -- be subtle. We’re talking about text that sounds like it was said by a human being, not forced attempts at whimsy.)

#### FIVE: Pay attention to capitalization.
When it comes to headlines and subheads, there are two ways to capitalize:

In Title Case, the First Letter of Almost Every Word Is Capitalized

In sentence case, only the first letter of the line is capitalized

Feature names and dashboard sections typically use title case (think “Site Stats” or “Recently Published”), whereas feature labels typically use sentence case (like “Show buttons on” or “Comment Likes are,” where “Likes” is capitalized because it’s the feature name, but the overall label is using sentence case).

When you’re looking at a full page of UI copy, make sure you’re being consistent across all of it, and that all similar kinds of copy -- headlines, tooltips, buttons, etc. -- are using the same case.

## Error Messaging
Guidelines for writing error messages that are understandable and useful.

#### ONE: Don’t ignore voice/tone in error messaging -- they communicate a lot.
Voice and tone can say as much as the individual words themselves. Error messages have to convey a significant amount of information and usually need to be fairly short, but try not to sacrifice tone, or to go too far in either a negative or positive direction.

Let’s say someone’s trying to publish a post, but their user role doesn’t allow them to do that. Here are some ways we could -- but should not -- communicate that:

> Your user role is incorrect.
> Here, we sound distant and uncaring.

> Stop! You do not have permission to do this.
> Here, we sound unnecessarily alarmist and stern.

> Oopsie, we can’t let you do that!
> Here, we sound too cute.

We can stay direct, positive, and friendly, even in error messages. How? With tips two through four!

#### TWO: Whenever possible, offer a path to resolution.
A good error message doesn’t just alert someone to the fact that something is wrong.

> Your user role is incorrect.

Okay, fine. Why does that matter? What do I do about it? How does this message help me? I need to know why my user role matters, and how to get the role I need so I can complete the action I want to complete. An error message that doesn’t provide any instruction leaves the user without a path forward; they can’t avoid repeating the action that led to the error if we don’t tell them now.

#### THREE: Don’t lean on jargon to cut down on words when space is tight.

> Your user role is incorrect. Contact a site administrator.

Maybe we’re getting somewhere here: now I know there’s something I can do about things, which is good.

Then again, maybe we’re not: I still don’t know what my role is, or why it matters. Also, now I’m also not sure what a site administrator is, who mine is, or how to contact them.

All the information in this error message is technically entirely correct, but that doesn’t mean it communicates anything useful. If the goal is understanding and resolution, technical accuracy doesn’t always get us there.

“Your account does not have permission to publish posts” doesn’t use the language of the user roles UI, but it does explain what’s gone wrong and I can understand it even if I don’t know what a user role is. And since I understand, I’m also better placed to understand the resolution, even if the message ended here: I can see that I need to get permission.

Consistency with existing UI language is great, but not when it gets in the way of understanding.

#### FOUR: Don’t assume people understand where the error came from.

> Your user role is incorrect.

It might seem obvious to us that the user got this message when they tried to publish something or change a setting that they don’t have permission for. It might not be so obvious to the user: people click around a lot, especially when we’re unsure how to do something, and we don’t always remember what page or setting we were just looking at (or why!).

A good error message also includes some context that orients the user. “Your account does not have permission to publish posts” reminds them that they were trying to publish a post, and that that’s the particular stumbling block that caused the error.
