macro(_find_file_in_dirs VAR NAME DIRS)
    find_path(${VAR} ${NAME} ${DIRS} NO_DEFAULT_PATH)
    set(${VAR} ${${VAR}}/${NAME})
    unset(${VAR} CACHE)
endmacro()

if(${the_module}_WITH_BLAS)
    set(_bp ${the_module}_BLAS) #prefix for blas variables
    set(BLAS_CBLAS_H "cblas.h")
    set(HAVE_BLAS "")

    if(NOT HAVE_BLAS) #check custom BLAS from user input
        if(${_bp}_INCLUDE_DIR AND ${_bp}_LIBRARIES AND ${_bp}_CBLAS_H)
            set(HAVE_BLAS "Custom")
        endif()
    endif()
    if(NOT HAVE_BLAS)
        include(cmake/OpenCVFindMKL.cmake)
        if(HAVE_MKL)
            set(BLAS_INCLUDE_DIR    ${MKL_INCLUDE_DIRS})
            set(BLAS_LIBRARIES      ${MKL_LIBRARIES}   )
            set(BLAS_CBLAS_H        "mkl_cblas.h"      )
            set(HAVE_BLAS "MKL")
        endif()
    endif()
    if(NOT HAVE_BLAS)
        include(cmake/FindOpenBLAS.cmake)
        if(OpenBLAS_FOUND)
            set(BLAS_INCLUDE_DIR    ${OpenBLAS_INCLUDE_DIR} )
            set(BLAS_LIBRARIES      ${OpenBLAS_LIB}         )
            set(HAVE_BLAS "OpenBLAS")
        endif()
    endif()
    if(NOT HAVE_BLAS AND UNIX)
        include(cmake/FindAtlas.cmake)
        if(ATLAS_FOUND)
            set(BLAS_INCLUDE_DIR    ${Atlas_INCLUDE_DIR})
            set(BLAS_LIBRARIES      ${Atlas_LIBRARIES}  )
            set(HAVE_BLAS "Atlas")
        endif()
    endif()

    if(NOT HAVE_BLAS OR NOT (HAVE_BLAS STREQUAL "Custom"))
        set(${_bp}_INCLUDE_DIR  ${BLAS_INCLUDE_DIR} CACHE PATH      "Path to BLAS include dir" FORCE)
        set(${_bp}_CBLAS_H      ${BLAS_CBLAS_H}     CACHE STRING    "Alternative name of cblas.h" FORCE)
        set(${_bp}_LIBRARIES    ${BLAS_LIBRARIES}   CACHE FILEPATH  "Path to BLAS libraries that will be linked with ${the_module} module" FORCE)
        set(${_bp}_BINARIES     ${BLAS_BINARIES}    CACHE FILEPATH  "Path to BLAS binaries (.so, .dll) that will be installed with ${the_module} module" FORCE)
    endif()

    if(HAVE_BLAS) #adding proxy cblas.h header
        _find_file_in_dirs(CBLAS_H_PATH ${${_bp}_CBLAS_H} ${${_bp}_INCLUDE_DIR})
        if(NOT CBLAS_H_PATH)
            message(WARNING "CBLAS header '${${_bp}_CBLAS_H}' not found into '${${_bp}_INCLUDE_DIR}'")
        endif()

        set(CBLAS_H_PROXY_PATH ${CMAKE_CURRENT_BINARY_DIR}/opencv_cblas.hpp)
        set(_include_str "\#include \"${CBLAS_H_PATH}\"")
        file(WRITE ${CBLAS_H_PROXY_PATH} ${_include_str})
    endif()
endif()