/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package v1alpha1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-generated-swagger-docs.sh

// AUTO-GENERATED FUNCTIONS START HERE
var map_AdmissionReview = map[string]string{
	"":       "AdmissionReview describes an admission request.",
	"spec":   "Spec describes the attributes for the admission request. Since this admission controller is non-mutating the webhook should avoid setting this in its response to avoid the cost of deserializing it.",
	"status": "Status is filled in by the webhook and indicates whether the admission request should be permitted.",
}

func (AdmissionReview) SwaggerDoc() map[string]string {
	return map_AdmissionReview
}

var map_AdmissionReviewSpec = map[string]string{
	"":            "AdmissionReviewSpec describes the admission.Attributes for the admission request.",
	"kind":        "Kind is the type of object being manipulated.  For example: Pod",
	"object":      "Object is the object from the incoming request prior to default values being applied",
	"oldObject":   "OldObject is the existing object. Only populated for UPDATE requests.",
	"operation":   "Operation is the operation being performed",
	"name":        "Name is the name of the object as presented in the request.  On a CREATE operation, the client may omit name and rely on the server to generate the name.  If that is the case, this method will return the empty string.",
	"namespace":   "Namespace is the namespace associated with the request (if any).",
	"resource":    "Resource is the name of the resource being requested.  This is not the kind.  For example: pods",
	"subResource": "SubResource is the name of the subresource being requested.  This is a different resource, scoped to the parent resource, but it may have a different kind. For instance, /pods has the resource \"pods\" and the kind \"Pod\", while /pods/foo/status has the resource \"pods\", the sub resource \"status\", and the kind \"Pod\" (because status operates on pods). The binding resource for a pod though may be /pods/foo/binding, which has resource \"pods\", subresource \"binding\", and kind \"Binding\".",
	"userInfo":    "UserInfo is information about the requesting user",
}

func (AdmissionReviewSpec) SwaggerDoc() map[string]string {
	return map_AdmissionReviewSpec
}

var map_AdmissionReviewStatus = map[string]string{
	"":        "AdmissionReviewStatus describes the status of the admission request.",
	"allowed": "Allowed indicates whether or not the admission request was permitted.",
	"status":  "Result contains extra details into why an admission request was denied. This field IS NOT consulted in any way if \"Allowed\" is \"true\".",
}

func (AdmissionReviewStatus) SwaggerDoc() map[string]string {
	return map_AdmissionReviewStatus
}

// AUTO-GENERATED FUNCTIONS END HERE
