# Every Contribution Makes a Difference

Think of open-source development as free training with a visible outcome.
Exploring new technologies is easier than in commercial environments,
where development effort is more focused on immediate results.

We welcome contributions of any kind including pull requests, ideas, bug reports,
testing, writing documentation, tutorials and blog posts. If you help with development,
you have the opportunity to learn Docker, Go, TensorFlow and much more.

## Questions?

Follow us on [Twitter](https://twitter.com/browseyourlife) to receive regular project updates, 
get in contact with other contributors and discuss your ideas. Don't be afraid to ask stupid questions.

Of all the tools we tested, it works best to get and give continuous feedback. 
Especially polls are amazing for product development.

## Roadmap ##

Our vision is to provide the most user-friendly solution for browsing, organizing and sharing your personal photo collection.
The [roadmap](https://github.com/photoprism/photoprism/projects/5) shows what tasks are in progress, 
what needs testing, and which feature requests are going to be implemented next.

Please give ideas you like a thumbs-up 👍  , so that we know what is most popular.
Ideas backed by one or more eligible [sponsors](SPONSORS.md) will be prioritized as well.

You are welcome to add specific feature requests directly to our [GitHub issue tracker](https://github.com/photoprism/photoprism/issues)
if no similar [idea](https://github.com/photoprism/photoprism/labels/idea)
or [todo](https://github.com/photoprism/photoprism/labels/todo) already exists.
Please don't use the issue tracker to ask general questions.

## Reporting Bugs ##

Please use the [GitHub issue tracker](https://github.com/photoprism/photoprism/issues) to report clearly identified bugs and impediments to us.
If you're not sure, start by asking in our [community chat](https://gitter.im/browseyourlife/community) or [contact us via email](mailto:help@photoprism.app).
When reporting an issue, please provide the version in use and information about your environment like browser, operating system, installed memory, and processor type.

## Pull Requests

Issues labeled [help wanted](https://github.com/photoprism/photoprism/labels/help%20wanted) /
[easy](https://github.com/photoprism/photoprism/labels/easy) can be good (first) contributions.
The Developer Guide contains all information necessary to get you started.

Our [step-by-step guide](https://docs.photoprism.org/developer-guide/pull-requests/) explains how to submit new features, bugfixes and documentation.