// +build ignore

// This generates countries.go by running "go generate"
package main

import (
	"encoding/json"
	"io/ioutil"
	"os"
	"strings"
	"text/template"
)

type Country struct {
	Code string
	Name string
}

var countries []Country

func main() {
	rawData, err := ioutil.ReadFile("./countries.json")

	if err != nil {
		panic(err)
	}

	err = json.Unmarshal(rawData, &countries)

	if err != nil {
		panic(err)
	}

	f, err := os.Create("countries.go")

	if err != nil {
		panic(err)
	}

	defer f.Close()

	for i, v := range countries {
		countries[i].Code = strings.ToLower(v.Code)
	}

	packageTemplate.Execute(f, struct {
		Countries []Country
	}{
		Countries: countries,
	})
}

var packageTemplate = template.Must(template.New("").Parse(`// Code generated by go generate; DO NOT EDIT.
package maps

var CountryNames = map[string]string{
{{- range .Countries }}
	{{ printf "%q" .Code }}: {{ printf "%q" .Name }},
{{- end }}
}`))
