package config

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestConfig_FFmpegEncoder(t *testing.T) {
	c := NewConfig(CliTestContext())
	assert.Equal(t, "libx264", c.FFmpegEncoder())

	c.options.FFmpegEncoder = "testEncoder"
	assert.Equal(t, "testEncoder", c.FFmpegEncoder())
}

func TestConfig_FFmpegBuffers(t *testing.T) {
	c := NewConfig(CliTestContext())
	assert.Equal(t, 8, c.FFmpegBuffers())

	c.options.FFmpegBuffers = 3300
	assert.Equal(t, 2048, c.FFmpegBuffers())

	c.options.FFmpegBuffers = 589
	assert.Equal(t, 589, c.FFmpegBuffers())
}

func TestConfig_FFmpegBitrate(t *testing.T) {
	c := NewConfig(CliTestContext())
	assert.Equal(t, 50, c.FFmpegBitrate())

	c.options.FFmpegBitrate = 1000
	assert.Equal(t, 960, c.FFmpegBitrate())

	c.options.FFmpegBitrate = -5
	assert.Equal(t, 50, c.FFmpegBitrate())

	c.options.FFmpegBitrate = 800
	assert.Equal(t, 800, c.FFmpegBitrate())
}
