/*
 * Azure Blockchain Workbench REST API
 * The Azure Blockchain Workbench REST API is a Workbench extensibility point, which allows developers to create and manage blockchain applications, manage users and organizations within a consortium, integrate blockchain applications into services and platforms, perform transactions on a blockchain, and retrieve transactional and contract data from a blockchain.
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * WorkflowStateTransition
 */

public class WorkflowStateTransition {
  @SerializedName("id")
  private Integer id = null;

  @SerializedName("workflowFunctionId")
  private Integer workflowFunctionId = null;

  @SerializedName("currStateId")
  private Integer currStateId = null;

  @SerializedName("allowedRoles")
  private List<String> allowedRoles = null;

  @SerializedName("allowedInstanceRoles")
  private List<String> allowedInstanceRoles = null;

  @SerializedName("description")
  private String description = null;

  @SerializedName("function")
  private String function = null;

  @SerializedName("currentState")
  private String currentState = null;

  @SerializedName("displayName")
  private String displayName = null;

  public WorkflowStateTransition id(Integer id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(value = "")
  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public WorkflowStateTransition workflowFunctionId(Integer workflowFunctionId) {
    this.workflowFunctionId = workflowFunctionId;
    return this;
  }

   /**
   * Get workflowFunctionId
   * @return workflowFunctionId
  **/
  @ApiModelProperty(value = "")
  public Integer getWorkflowFunctionId() {
    return workflowFunctionId;
  }

  public void setWorkflowFunctionId(Integer workflowFunctionId) {
    this.workflowFunctionId = workflowFunctionId;
  }

  public WorkflowStateTransition currStateId(Integer currStateId) {
    this.currStateId = currStateId;
    return this;
  }

   /**
   * Get currStateId
   * @return currStateId
  **/
  @ApiModelProperty(value = "")
  public Integer getCurrStateId() {
    return currStateId;
  }

  public void setCurrStateId(Integer currStateId) {
    this.currStateId = currStateId;
  }

  public WorkflowStateTransition allowedRoles(List<String> allowedRoles) {
    this.allowedRoles = allowedRoles;
    return this;
  }

  public WorkflowStateTransition addAllowedRolesItem(String allowedRolesItem) {
    if (this.allowedRoles == null) {
      this.allowedRoles = new ArrayList<String>();
    }
    this.allowedRoles.add(allowedRolesItem);
    return this;
  }

   /**
   * Get allowedRoles
   * @return allowedRoles
  **/
  @ApiModelProperty(value = "")
  public List<String> getAllowedRoles() {
    return allowedRoles;
  }

  public void setAllowedRoles(List<String> allowedRoles) {
    this.allowedRoles = allowedRoles;
  }

  public WorkflowStateTransition allowedInstanceRoles(List<String> allowedInstanceRoles) {
    this.allowedInstanceRoles = allowedInstanceRoles;
    return this;
  }

  public WorkflowStateTransition addAllowedInstanceRolesItem(String allowedInstanceRolesItem) {
    if (this.allowedInstanceRoles == null) {
      this.allowedInstanceRoles = new ArrayList<String>();
    }
    this.allowedInstanceRoles.add(allowedInstanceRolesItem);
    return this;
  }

   /**
   * Get allowedInstanceRoles
   * @return allowedInstanceRoles
  **/
  @ApiModelProperty(value = "")
  public List<String> getAllowedInstanceRoles() {
    return allowedInstanceRoles;
  }

  public void setAllowedInstanceRoles(List<String> allowedInstanceRoles) {
    this.allowedInstanceRoles = allowedInstanceRoles;
  }

  public WorkflowStateTransition description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @ApiModelProperty(value = "")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public WorkflowStateTransition function(String function) {
    this.function = function;
    return this;
  }

   /**
   * Get function
   * @return function
  **/
  @ApiModelProperty(value = "")
  public String getFunction() {
    return function;
  }

  public void setFunction(String function) {
    this.function = function;
  }

  public WorkflowStateTransition currentState(String currentState) {
    this.currentState = currentState;
    return this;
  }

   /**
   * Get currentState
   * @return currentState
  **/
  @ApiModelProperty(value = "")
  public String getCurrentState() {
    return currentState;
  }

  public void setCurrentState(String currentState) {
    this.currentState = currentState;
  }

  public WorkflowStateTransition displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @ApiModelProperty(value = "")
  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WorkflowStateTransition workflowStateTransition = (WorkflowStateTransition) o;
    return Objects.equals(this.id, workflowStateTransition.id) &&
        Objects.equals(this.workflowFunctionId, workflowStateTransition.workflowFunctionId) &&
        Objects.equals(this.currStateId, workflowStateTransition.currStateId) &&
        Objects.equals(this.allowedRoles, workflowStateTransition.allowedRoles) &&
        Objects.equals(this.allowedInstanceRoles, workflowStateTransition.allowedInstanceRoles) &&
        Objects.equals(this.description, workflowStateTransition.description) &&
        Objects.equals(this.function, workflowStateTransition.function) &&
        Objects.equals(this.currentState, workflowStateTransition.currentState) &&
        Objects.equals(this.displayName, workflowStateTransition.displayName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, workflowFunctionId, currStateId, allowedRoles, allowedInstanceRoles, description, function, currentState, displayName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WorkflowStateTransition {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    workflowFunctionId: ").append(toIndentedString(workflowFunctionId)).append("\n");
    sb.append("    currStateId: ").append(toIndentedString(currStateId)).append("\n");
    sb.append("    allowedRoles: ").append(toIndentedString(allowedRoles)).append("\n");
    sb.append("    allowedInstanceRoles: ").append(toIndentedString(allowedInstanceRoles)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    function: ").append(toIndentedString(function)).append("\n");
    sb.append("    currentState: ").append(toIndentedString(currentState)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

