# coding: utf-8

"""
    Azure Blockchain Workbench REST API

    The Azure Blockchain Workbench REST API is a Workbench extensibility point, which allows developers to create and manage blockchain applications, manage users and organizations within a consortium, integrate blockchain applications into services and platforms, perform transactions on a blockchain, and retrieve transactional and contract data from a blockchain.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class ApplicationsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def application_delete(self, application_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Deletes the specified blockchain application. This method can only be performed by users who are              Workbench administrators. NOTE: Currently not implemented.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.application_delete(application_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str application_id: The id of the application. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.application_delete_with_http_info(application_id, **kwargs)  # noqa: E501
        else:
            (data) = self.application_delete_with_http_info(application_id, **kwargs)  # noqa: E501
            return data

    def application_delete_with_http_info(self, application_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Deletes the specified blockchain application. This method can only be performed by users who are              Workbench administrators. NOTE: Currently not implemented.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.application_delete_with_http_info(application_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str application_id: The id of the application. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application_id' is set
        if ('application_id' not in params or
                params['application_id'] is None):
            raise ValueError("Missing the required parameter `application_id` when calling `application_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application_id' in params:
            path_params['applicationID'] = params['application_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{applicationID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_disable(self, application_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Disables the specified blockchain application. This method can only be performed by users who are              Workbench administrators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.application_disable(application_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the application. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.application_disable_with_http_info(application_id, **kwargs)  # noqa: E501
        else:
            (data) = self.application_disable_with_http_info(application_id, **kwargs)  # noqa: E501
            return data

    def application_disable_with_http_info(self, application_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Disables the specified blockchain application. This method can only be performed by users who are              Workbench administrators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.application_disable_with_http_info(application_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the application. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_disable" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application_id' is set
        if ('application_id' not in params or
                params['application_id'] is None):
            raise ValueError("Missing the required parameter `application_id` when calling `application_disable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application_id' in params:
            path_params['applicationId'] = params['application_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{applicationID}/disable', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_enable(self, application_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Enables the specified blockchain application. This method can only be performed by users who are              Workbench administrators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.application_enable(application_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the application. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.application_enable_with_http_info(application_id, **kwargs)  # noqa: E501
        else:
            (data) = self.application_enable_with_http_info(application_id, **kwargs)  # noqa: E501
            return data

    def application_enable_with_http_info(self, application_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Enables the specified blockchain application. This method can only be performed by users who are              Workbench administrators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.application_enable_with_http_info(application_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the application. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_enable" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application_id' is set
        if ('application_id' not in params or
                params['application_id'] is None):
            raise ValueError("Missing the required parameter `application_id` when calling `application_enable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application_id' in params:
            path_params['applicationId'] = params['application_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{applicationID}/enable', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def application_get(self, application_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Gets the blockchain application matching a specific application ID. Users who are Workbench administrators get              the blockchain application. Non-Workbench administrators get the blockchain application if they have at least one associated              application role or is associated with a smart contract instance role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.application_get(application_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the application. (required)
        :return: Application
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.application_get_with_http_info(application_id, **kwargs)  # noqa: E501
        else:
            (data) = self.application_get_with_http_info(application_id, **kwargs)  # noqa: E501
            return data

    def application_get_with_http_info(self, application_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Gets the blockchain application matching a specific application ID. Users who are Workbench administrators get              the blockchain application. Non-Workbench administrators get the blockchain application if they have at least one associated              application role or is associated with a smart contract instance role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.application_get_with_http_info(application_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the application. (required)
        :return: Application
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method application_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application_id' is set
        if ('application_id' not in params or
                params['application_id'] is None):
            raise ValueError("Missing the required parameter `application_id` when calling `application_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application_id' in params:
            path_params['applicationId'] = params['application_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{applicationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Application',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def applications_get(self, **kwargs):  # noqa: E501
        """  # noqa: E501

        Lists all blockchain applications to which a user has access in Workbench. Users who are Workbench administrators get              all blockchain applications. Non-Workbench administrators get all blockchain applications for which they have at least one              associated application role or an associated smart contract instance role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.applications_get(async=True)
        >>> result = thread.get()

        :param async bool
        :param int top: The maximum number of entries to return in the result set.
        :param int skip: The number of entries to skip in the result set.
        :param bool enabled: A Boolean for whether to filter the result set to only enabled applications.
        :return: ApplicationList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.applications_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.applications_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def applications_get_with_http_info(self, **kwargs):  # noqa: E501
        """  # noqa: E501

        Lists all blockchain applications to which a user has access in Workbench. Users who are Workbench administrators get              all blockchain applications. Non-Workbench administrators get all blockchain applications for which they have at least one              associated application role or an associated smart contract instance role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.applications_get_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param int top: The maximum number of entries to return in the result set.
        :param int skip: The number of entries to skip in the result set.
        :param bool enabled: A Boolean for whether to filter the result set to only enabled applications.
        :return: ApplicationList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['top', 'skip', 'enabled']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method applications_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'top' in params:
            query_params.append(('top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501
        if 'enabled' in params:
            query_params.append(('enabled', params['enabled']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationList',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def applications_post(self, file, **kwargs):  # noqa: E501
        """  # noqa: E501

        Creates a new blockchain application. This method can only be performed by users who are              Workbench administrators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.applications_post(file, async=True)
        >>> result = thread.get()

        :param async bool
        :param file file: Upload File (required)
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.applications_post_with_http_info(file, **kwargs)  # noqa: E501
        else:
            (data) = self.applications_post_with_http_info(file, **kwargs)  # noqa: E501
            return data

    def applications_post_with_http_info(self, file, **kwargs):  # noqa: E501
        """  # noqa: E501

        Creates a new blockchain application. This method can only be performed by users who are              Workbench administrators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.applications_post_with_http_info(file, async=True)
        >>> result = thread.get()

        :param async bool
        :param file file: Upload File (required)
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method applications_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `applications_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def contract_code_delete(self, contract_code_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Deletes the specified blockchain smart contract implementation of a specific blockchain application.              This method can only be performed by users who are Workbench administrators.              NOTE: not currently implemented  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contract_code_delete(contract_code_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int contract_code_id: The id of the contract code (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.contract_code_delete_with_http_info(contract_code_id, **kwargs)  # noqa: E501
        else:
            (data) = self.contract_code_delete_with_http_info(contract_code_id, **kwargs)  # noqa: E501
            return data

    def contract_code_delete_with_http_info(self, contract_code_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Deletes the specified blockchain smart contract implementation of a specific blockchain application.              This method can only be performed by users who are Workbench administrators.              NOTE: not currently implemented  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contract_code_delete_with_http_info(contract_code_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int contract_code_id: The id of the contract code (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contract_code_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method contract_code_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'contract_code_id' is set
        if ('contract_code_id' not in params or
                params['contract_code_id'] is None):
            raise ValueError("Missing the required parameter `contract_code_id` when calling `contract_code_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'contract_code_id' in params:
            path_params['contractCodeId'] = params['contract_code_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/contractCode/{contractCodeId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def contract_code_get(self, contract_code_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Get the blockchain smart contract implementation matching a specific              ledger implementation ID. Users who are Workbench administrators get the specified smart contract implementation.              Non-Workbench administrators get the smart contract implementation if they have at least one associated application              role or is associated with a smart contract instance role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contract_code_get(contract_code_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int contract_code_id: The id of the contract code (required)
        :return: FileStreamResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.contract_code_get_with_http_info(contract_code_id, **kwargs)  # noqa: E501
        else:
            (data) = self.contract_code_get_with_http_info(contract_code_id, **kwargs)  # noqa: E501
            return data

    def contract_code_get_with_http_info(self, contract_code_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Get the blockchain smart contract implementation matching a specific              ledger implementation ID. Users who are Workbench administrators get the specified smart contract implementation.              Non-Workbench administrators get the smart contract implementation if they have at least one associated application              role or is associated with a smart contract instance role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contract_code_get_with_http_info(contract_code_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int contract_code_id: The id of the contract code (required)
        :return: FileStreamResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contract_code_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method contract_code_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'contract_code_id' is set
        if ('contract_code_id' not in params or
                params['contract_code_id'] is None):
            raise ValueError("Missing the required parameter `contract_code_id` when calling `contract_code_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'contract_code_id' in params:
            path_params['contractCodeId'] = params['contract_code_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/contractCode/{contractCodeId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileStreamResult',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def contract_code_post(self, application_id, file, **kwargs):  # noqa: E501
        """  # noqa: E501

        Uploads one or more smart contracts (ex. .sol or .zip), representing the implementation of the specified blockchain              application. This method can only be performed by users who are Workbench administrators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contract_code_post(application_id, file, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the application (required)
        :param file file: Upload File (required)
        :param int ledger_id: The index of the ledger
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.contract_code_post_with_http_info(application_id, file, **kwargs)  # noqa: E501
        else:
            (data) = self.contract_code_post_with_http_info(application_id, file, **kwargs)  # noqa: E501
            return data

    def contract_code_post_with_http_info(self, application_id, file, **kwargs):  # noqa: E501
        """  # noqa: E501

        Uploads one or more smart contracts (ex. .sol or .zip), representing the implementation of the specified blockchain              application. This method can only be performed by users who are Workbench administrators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contract_code_post_with_http_info(application_id, file, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the application (required)
        :param file file: Upload File (required)
        :param int ledger_id: The index of the ledger
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application_id', 'file', 'ledger_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method contract_code_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application_id' is set
        if ('application_id' not in params or
                params['application_id'] is None):
            raise ValueError("Missing the required parameter `application_id` when calling `contract_code_post`")  # noqa: E501
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `contract_code_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application_id' in params:
            path_params['applicationId'] = params['application_id']  # noqa: E501

        query_params = []
        if 'ledger_id' in params:
            query_params.append(('ledgerId', params['ledger_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{applicationId}/contractCode', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def contract_codes_get(self, application_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        List all blockchain smart contract implementations of the specified blockchain application.              Users who are Workbench administrators get all smart contract implementations. Non-Workbench administrators get all              smart contract implementations for which they have at least one associated application role or is associated with a              smart contract instance role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contract_codes_get(application_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the application (required)
        :param int ledger_id: The index of the chain type
        :param int top: The maximum number of items to return
        :param int skip: The number of items to skip before returning
        :return: ContractCodeList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.contract_codes_get_with_http_info(application_id, **kwargs)  # noqa: E501
        else:
            (data) = self.contract_codes_get_with_http_info(application_id, **kwargs)  # noqa: E501
            return data

    def contract_codes_get_with_http_info(self, application_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        List all blockchain smart contract implementations of the specified blockchain application.              Users who are Workbench administrators get all smart contract implementations. Non-Workbench administrators get all              smart contract implementations for which they have at least one associated application role or is associated with a              smart contract instance role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contract_codes_get_with_http_info(application_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the application (required)
        :param int ledger_id: The index of the chain type
        :param int top: The maximum number of items to return
        :param int skip: The number of items to skip before returning
        :return: ContractCodeList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application_id', 'ledger_id', 'top', 'skip']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method contract_codes_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application_id' is set
        if ('application_id' not in params or
                params['application_id'] is None):
            raise ValueError("Missing the required parameter `application_id` when calling `contract_codes_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application_id' in params:
            path_params['applicationId'] = params['application_id']  # noqa: E501

        query_params = []
        if 'ledger_id' in params:
            query_params.append(('ledgerId', params['ledger_id']))  # noqa: E501
        if 'top' in params:
            query_params.append(('top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{applicationID}/contractCode', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContractCodeList',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def role_assignment_delete(self, application_id, role_assignment_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Deletes the specified role assignment. This method can only be performed by users who are              Workbench administrators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.role_assignment_delete(application_id, role_assignment_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the application (required)
        :param int role_assignment_id: The id of the role assignment (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.role_assignment_delete_with_http_info(application_id, role_assignment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.role_assignment_delete_with_http_info(application_id, role_assignment_id, **kwargs)  # noqa: E501
            return data

    def role_assignment_delete_with_http_info(self, application_id, role_assignment_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Deletes the specified role assignment. This method can only be performed by users who are              Workbench administrators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.role_assignment_delete_with_http_info(application_id, role_assignment_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the application (required)
        :param int role_assignment_id: The id of the role assignment (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application_id', 'role_assignment_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method role_assignment_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application_id' is set
        if ('application_id' not in params or
                params['application_id'] is None):
            raise ValueError("Missing the required parameter `application_id` when calling `role_assignment_delete`")  # noqa: E501
        # verify the required parameter 'role_assignment_id' is set
        if ('role_assignment_id' not in params or
                params['role_assignment_id'] is None):
            raise ValueError("Missing the required parameter `role_assignment_id` when calling `role_assignment_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application_id' in params:
            path_params['applicationId'] = params['application_id']  # noqa: E501
        if 'role_assignment_id' in params:
            path_params['roleAssignmentId'] = params['role_assignment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{applicationId}/roleAssignments/{roleAssignmentId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def role_assignment_get(self, application_id, role_assignment_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Get a role assignment of the specified blockchain application matching a specific user role assignment ID.              Users who are Workbench administrators get the role assignment. Non-Workbench administrators get the role assignment              if they are associated in the application.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.role_assignment_get(application_id, role_assignment_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the configuration (required)
        :param int role_assignment_id: The id of the role assignment (required)
        :return: RoleAssignment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.role_assignment_get_with_http_info(application_id, role_assignment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.role_assignment_get_with_http_info(application_id, role_assignment_id, **kwargs)  # noqa: E501
            return data

    def role_assignment_get_with_http_info(self, application_id, role_assignment_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Get a role assignment of the specified blockchain application matching a specific user role assignment ID.              Users who are Workbench administrators get the role assignment. Non-Workbench administrators get the role assignment              if they are associated in the application.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.role_assignment_get_with_http_info(application_id, role_assignment_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the configuration (required)
        :param int role_assignment_id: The id of the role assignment (required)
        :return: RoleAssignment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application_id', 'role_assignment_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method role_assignment_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application_id' is set
        if ('application_id' not in params or
                params['application_id'] is None):
            raise ValueError("Missing the required parameter `application_id` when calling `role_assignment_get`")  # noqa: E501
        # verify the required parameter 'role_assignment_id' is set
        if ('role_assignment_id' not in params or
                params['role_assignment_id'] is None):
            raise ValueError("Missing the required parameter `role_assignment_id` when calling `role_assignment_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application_id' in params:
            path_params['applicationId'] = params['application_id']  # noqa: E501
        if 'role_assignment_id' in params:
            path_params['roleAssignmentId'] = params['role_assignment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{applicationId}/roleAssignments/{roleAssignmentId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleAssignment',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def role_assignments_get(self, application_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        List all role assignments of the specified blockchain application. Users who are Workbench administrators              get all role assignments. Non-Workbench administrators get all their role assignments. Roles are specified              in the Workbench application configuration and can be retrieved from GET /applications/{applicationID}.              Also, user information can be retrieved from GET /users/{userID}.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.role_assignments_get(application_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the configuration (required)
        :param int application_role_id: The id of the application role
        :param int top: The maximum number of entries to return in the result set.
        :param int skip: The number of entries to skip in the result set.
        :return: RoleAssignmentList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.role_assignments_get_with_http_info(application_id, **kwargs)  # noqa: E501
        else:
            (data) = self.role_assignments_get_with_http_info(application_id, **kwargs)  # noqa: E501
            return data

    def role_assignments_get_with_http_info(self, application_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        List all role assignments of the specified blockchain application. Users who are Workbench administrators              get all role assignments. Non-Workbench administrators get all their role assignments. Roles are specified              in the Workbench application configuration and can be retrieved from GET /applications/{applicationID}.              Also, user information can be retrieved from GET /users/{userID}.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.role_assignments_get_with_http_info(application_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the configuration (required)
        :param int application_role_id: The id of the application role
        :param int top: The maximum number of entries to return in the result set.
        :param int skip: The number of entries to skip in the result set.
        :return: RoleAssignmentList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application_id', 'application_role_id', 'top', 'skip']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method role_assignments_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application_id' is set
        if ('application_id' not in params or
                params['application_id'] is None):
            raise ValueError("Missing the required parameter `application_id` when calling `role_assignments_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application_id' in params:
            path_params['applicationId'] = params['application_id']  # noqa: E501

        query_params = []
        if 'application_role_id' in params:
            query_params.append(('applicationRoleId', params['application_role_id']))  # noqa: E501
        if 'top' in params:
            query_params.append(('top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{applicationId}/roleAssignments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleAssignmentList',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def role_assignments_post(self, application_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Creates a user-to-role mapping in the specified blockchain application. This method can only be performed by              users who are Workbench administrators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.role_assignments_post(application_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the configuration. (required)
        :param RoleAssignmentInput role_assignment: New user-to-role mapping.
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.role_assignments_post_with_http_info(application_id, **kwargs)  # noqa: E501
        else:
            (data) = self.role_assignments_post_with_http_info(application_id, **kwargs)  # noqa: E501
            return data

    def role_assignments_post_with_http_info(self, application_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Creates a user-to-role mapping in the specified blockchain application. This method can only be performed by              users who are Workbench administrators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.role_assignments_post_with_http_info(application_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the configuration. (required)
        :param RoleAssignmentInput role_assignment: New user-to-role mapping.
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application_id', 'role_assignment']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method role_assignments_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application_id' is set
        if ('application_id' not in params or
                params['application_id'] is None):
            raise ValueError("Missing the required parameter `application_id` when calling `role_assignments_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application_id' in params:
            path_params['applicationId'] = params['application_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'role_assignment' in params:
            body_params = params['role_assignment']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{applicationId}/roleAssignments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def workflow_get(self, workflow_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Get a workflow matching a specific workflow ID.              Users who are Workbench administrators get the workflow. Non-Workbench administrators get the workflow if they              have at least one associated application role or is associated with a smart contract instance role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.workflow_get(workflow_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int workflow_id: The id of the workflow (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.workflow_get_with_http_info(workflow_id, **kwargs)  # noqa: E501
        else:
            (data) = self.workflow_get_with_http_info(workflow_id, **kwargs)  # noqa: E501
            return data

    def workflow_get_with_http_info(self, workflow_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Get a workflow matching a specific workflow ID.              Users who are Workbench administrators get the workflow. Non-Workbench administrators get the workflow if they              have at least one associated application role or is associated with a smart contract instance role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.workflow_get_with_http_info(workflow_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int workflow_id: The id of the workflow (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method workflow_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params or
                params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `workflow_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/workflows/{workflowId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def workflows_get(self, application_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        List all workflows of the specified blockchain application. Users who are Workbench administrators get all              workflows. Non-Workbench administrators get all workflows for which they have at least one associated application role              or is associated with a smart contract instance role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.workflows_get(application_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the application (required)
        :param int top: The maximum number of items to return
        :param int skip: The number of items to skip before returning
        :return: WorkflowList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.workflows_get_with_http_info(application_id, **kwargs)  # noqa: E501
        else:
            (data) = self.workflows_get_with_http_info(application_id, **kwargs)  # noqa: E501
            return data

    def workflows_get_with_http_info(self, application_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        List all workflows of the specified blockchain application. Users who are Workbench administrators get all              workflows. Non-Workbench administrators get all workflows for which they have at least one associated application role              or is associated with a smart contract instance role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.workflows_get_with_http_info(application_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int application_id: The id of the application (required)
        :param int top: The maximum number of items to return
        :param int skip: The number of items to skip before returning
        :return: WorkflowList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application_id', 'top', 'skip']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method workflows_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application_id' is set
        if ('application_id' not in params or
                params['application_id'] is None):
            raise ValueError("Missing the required parameter `application_id` when calling `workflows_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'application_id' in params:
            path_params['applicationId'] = params['application_id']  # noqa: E501

        query_params = []
        if 'top' in params:
            query_params.append(('top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/applications/{applicationId}/workflows', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowList',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
