# swagger-client
The Azure Blockchain Workbench REST API is a Workbench extensibility point, which allows developers to create and manage blockchain applications, manage users and organizations within a consortium, integrate blockchain applications into services and platforms, perform transactions on a blockchain, and retrieve transactional and contract data from a blockchain.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v1
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen

The generated source was augmented in two ways - 

The generated Workflow type included a self import that caused challenges and was remediated.

Microsoft's ADAL library was added to support for Python to provide authenticated access to the API using the following code.

    context = adal.AuthenticationContext(authority_url,api_version=None)
    token = context.acquire_token_with_client_credentials(client_id,client_id,client_secret)
    api_client = ApiClient();
    bearer_token = "Bearer "+token['accessToken']
    api_client.set_default_header('Authorization',bearer_token)
    api_user = swagger_client.UsersApi(api_client)
    me = api_user.me_get()
    pprint(me)


## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint
# create an instance of the API class
api_instance = swagger_client.ApplicationsApi()
application_id = 'application_id_example' # str | The id of the application.

try:
    # 
    api_instance.application_delete(application_id)
except ApiException as e:
    print("Exception when calling ApplicationsApi->application_delete: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApplicationsApi* | [**application_delete**](docs/ApplicationsApi.md#application_delete) | **DELETE** /api/v1/applications/{applicationID} | 
*ApplicationsApi* | [**application_disable**](docs/ApplicationsApi.md#application_disable) | **PATCH** /api/v1/applications/{applicationID}/disable | 
*ApplicationsApi* | [**application_enable**](docs/ApplicationsApi.md#application_enable) | **PATCH** /api/v1/applications/{applicationID}/enable | 
*ApplicationsApi* | [**application_get**](docs/ApplicationsApi.md#application_get) | **GET** /api/v1/applications/{applicationId} | 
*ApplicationsApi* | [**applications_get**](docs/ApplicationsApi.md#applications_get) | **GET** /api/v1/applications | 
*ApplicationsApi* | [**applications_post**](docs/ApplicationsApi.md#applications_post) | **POST** /api/v1/applications | 
*ApplicationsApi* | [**contract_code_delete**](docs/ApplicationsApi.md#contract_code_delete) | **DELETE** /api/v1/applications/contractCode/{contractCodeId} | 
*ApplicationsApi* | [**contract_code_get**](docs/ApplicationsApi.md#contract_code_get) | **GET** /api/v1/applications/contractCode/{contractCodeId} | 
*ApplicationsApi* | [**contract_code_post**](docs/ApplicationsApi.md#contract_code_post) | **POST** /api/v1/applications/{applicationId}/contractCode | 
*ApplicationsApi* | [**contract_codes_get**](docs/ApplicationsApi.md#contract_codes_get) | **GET** /api/v1/applications/{applicationID}/contractCode | 
*ApplicationsApi* | [**role_assignment_delete**](docs/ApplicationsApi.md#role_assignment_delete) | **DELETE** /api/v1/applications/{applicationId}/roleAssignments/{roleAssignmentId} | 
*ApplicationsApi* | [**role_assignment_get**](docs/ApplicationsApi.md#role_assignment_get) | **GET** /api/v1/applications/{applicationId}/roleAssignments/{roleAssignmentId} | 
*ApplicationsApi* | [**role_assignments_get**](docs/ApplicationsApi.md#role_assignments_get) | **GET** /api/v1/applications/{applicationId}/roleAssignments | 
*ApplicationsApi* | [**role_assignments_post**](docs/ApplicationsApi.md#role_assignments_post) | **POST** /api/v1/applications/{applicationId}/roleAssignments | 
*ApplicationsApi* | [**workflow_get**](docs/ApplicationsApi.md#workflow_get) | **GET** /api/v1/applications/workflows/{workflowId} | 
*ApplicationsApi* | [**workflows_get**](docs/ApplicationsApi.md#workflows_get) | **GET** /api/v1/applications/{applicationId}/workflows | 
*CapabilitiesApi* | [**can_create_contract**](docs/CapabilitiesApi.md#can_create_contract) | **GET** /api/v1/capabilities/canCreateContract/{workflowId} | 
*CapabilitiesApi* | [**capabilities_get**](docs/CapabilitiesApi.md#capabilities_get) | **GET** /api/v1/capabilities | 
*CheckersApi* | [**check_application_post**](docs/CheckersApi.md#check_application_post) | **POST** /api/v1/checkers/checkApplication | Check validity of application configuration for Workbench
*CheckersApi* | [**check_contract_code_post**](docs/CheckersApi.md#check_contract_code_post) | **POST** /api/v1/checkers/checkContractCode | Check validity of application ledger implementation for Workbench
*ConnectionsApi* | [**block_get**](docs/ConnectionsApi.md#block_get) | **GET** /api/v1/ledgers/connections/{connectionId}/blocks/{blockId} | 
*ConnectionsApi* | [**blocks_get**](docs/ConnectionsApi.md#blocks_get) | **GET** /api/v1/ledgers/connections/{connectionId}/blocks | 
*ConnectionsApi* | [**connection_get**](docs/ConnectionsApi.md#connection_get) | **GET** /api/v1/ledgers/connections/{connectionId} | 
*ConnectionsApi* | [**connections_get**](docs/ConnectionsApi.md#connections_get) | **GET** /api/v1/ledgers/connections | 
*ConnectionsApi* | [**transaction_get**](docs/ConnectionsApi.md#transaction_get) | **GET** /api/v1/ledgers/connections/{connectionId}/transactions/{transactionId} | 
*ConnectionsApi* | [**transactions_get**](docs/ConnectionsApi.md#transactions_get) | **GET** /api/v1/ledgers/connections/{connectionId}/transactions | 
*ContractsApi* | [**contract_action_get**](docs/ContractsApi.md#contract_action_get) | **GET** /api/v1/contracts/{contractId}/actions/{actionId} | 
*ContractsApi* | [**contract_action_post**](docs/ContractsApi.md#contract_action_post) | **POST** /api/v1/contracts/{contractId}/actions | 
*ContractsApi* | [**contract_actions_get**](docs/ContractsApi.md#contract_actions_get) | **GET** /api/v1/contracts/{contractId}/actions | 
*ContractsApi* | [**contract_get**](docs/ContractsApi.md#contract_get) | **GET** /api/v1/contracts/{contractId} | 
*ContractsApi* | [**contract_post**](docs/ContractsApi.md#contract_post) | **POST** /api/v1/contracts | 
*ContractsApi* | [**contracts_get**](docs/ContractsApi.md#contracts_get) | **GET** /api/v1/contracts | 
*GraphProxyApi* | [**graph_proxy_users_get**](docs/GraphProxyApi.md#graph_proxy_users_get) | **GET** /api/v1/graph-proxy/{version}/users | Get Users from AAD Graph
*LedgersApi* | [**ledgers_get**](docs/LedgersApi.md#ledgers_get) | **GET** /api/v1/ledgers | 
*UsersApi* | [**me_get**](docs/UsersApi.md#me_get) | **GET** /api/v1/users/me | 
*UsersApi* | [**user_delete**](docs/UsersApi.md#user_delete) | **DELETE** /api/v1/users/{userID} | 
*UsersApi* | [**user_get**](docs/UsersApi.md#user_get) | **GET** /api/v1/users/{userID} | 
*UsersApi* | [**users_get**](docs/UsersApi.md#users_get) | **GET** /api/v1/users | Get Users
*UsersApi* | [**users_post**](docs/UsersApi.md#users_post) | **POST** /api/v1/users | 


## Documentation For Models

 - [Application](docs/Application.md)
 - [ApplicationList](docs/ApplicationList.md)
 - [ApplicationRole](docs/ApplicationRole.md)
 - [Block](docs/Block.md)
 - [BlockList](docs/BlockList.md)
 - [Capabilities](docs/Capabilities.md)
 - [Connection](docs/Connection.md)
 - [ConnectionList](docs/ConnectionList.md)
 - [ContentResult](docs/ContentResult.md)
 - [Contract](docs/Contract.md)
 - [ContractAction](docs/ContractAction.md)
 - [ContractActionParameter](docs/ContractActionParameter.md)
 - [ContractCode](docs/ContractCode.md)
 - [ContractCodeList](docs/ContractCodeList.md)
 - [ContractList](docs/ContractList.md)
 - [ContractProperty](docs/ContractProperty.md)
 - [EntityTagHeaderValue](docs/EntityTagHeaderValue.md)
 - [FileStreamResult](docs/FileStreamResult.md)
 - [IFormFile](docs/IFormFile.md)
 - [Ledger](docs/Ledger.md)
 - [LedgerActionOutput](docs/LedgerActionOutput.md)
 - [LedgerList](docs/LedgerList.md)
 - [Me](docs/Me.md)
 - [RoleAssignment](docs/RoleAssignment.md)
 - [RoleAssignmentInput](docs/RoleAssignmentInput.md)
 - [RoleAssignmentList](docs/RoleAssignmentList.md)
 - [Stream](docs/Stream.md)
 - [StringSegment](docs/StringSegment.md)
 - [Transaction](docs/Transaction.md)
 - [TransactionList](docs/TransactionList.md)
 - [User](docs/User.md)
 - [UserChainMapping](docs/UserChainMapping.md)
 - [UserInput](docs/UserInput.md)
 - [UserList](docs/UserList.md)
 - [Workflow](docs/Workflow.md)
 - [WorkflowActionInput](docs/WorkflowActionInput.md)
 - [WorkflowDataType](docs/WorkflowDataType.md)
 - [WorkflowFunction](docs/WorkflowFunction.md)
 - [WorkflowFunctionParameter](docs/WorkflowFunctionParameter.md)
 - [WorkflowList](docs/WorkflowList.md)
 - [WorkflowProperty](docs/WorkflowProperty.md)
 - [WorkflowState](docs/WorkflowState.md)
 - [WorkflowStateTransition](docs/WorkflowStateTransition.md)
 - [WorkflowStateTransitionList](docs/WorkflowStateTransitionList.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author



