/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.Contract;
import io.swagger.client.model.ContractList;
import io.swagger.client.model.LedgerActionOutput;
import io.swagger.client.model.WorkflowActionInput;
import io.swagger.client.model.WorkflowStateTransition;
import io.swagger.client.model.WorkflowStateTransitionList;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ContractsApi {
    private ApiClient apiClient;

    public ContractsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ContractsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call contractActionGetCall(Integer contractId, Integer actionId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/contracts/{contractId}/actions/{actionId}".replaceAll("\\{contractId\\}", this.apiClient.escapeString(contractId.toString())).replaceAll("\\{actionId\\}", this.apiClient.escapeString(actionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call contractActionGetValidateBeforeCall(Integer contractId, Integer actionId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractId == null) {
            throw new ApiException("Missing the required parameter 'contractId' when calling contractActionGet(Async)");
        }
        if (actionId == null) {
            throw new ApiException("Missing the required parameter 'actionId' when calling contractActionGet(Async)");
        }
        Call call = this.contractActionGetCall(contractId, actionId, progressListener, progressRequestListener);
        return call;
    }

    public WorkflowStateTransition contractActionGet(Integer contractId, Integer actionId) throws ApiException {
        ApiResponse<WorkflowStateTransition> resp = this.contractActionGetWithHttpInfo(contractId, actionId);
        return resp.getData();
    }

    public ApiResponse<WorkflowStateTransition> contractActionGetWithHttpInfo(Integer contractId, Integer actionId) throws ApiException {
        Call call = this.contractActionGetValidateBeforeCall(contractId, actionId, null, null);
        Type localVarReturnType = new TypeToken<WorkflowStateTransition>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call contractActionGetAsync(Integer contractId, Integer actionId, final ApiCallback<WorkflowStateTransition> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.contractActionGetValidateBeforeCall(contractId, actionId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WorkflowStateTransition>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call contractActionPostCall(Integer contractId, WorkflowActionInput actionInformation, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        WorkflowActionInput localVarPostBody = actionInformation;
        String localVarPath = "/api/v1/contracts/{contractId}/actions".replaceAll("\\{contractId\\}", this.apiClient.escapeString(contractId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call contractActionPostValidateBeforeCall(Integer contractId, WorkflowActionInput actionInformation, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractId == null) {
            throw new ApiException("Missing the required parameter 'contractId' when calling contractActionPost(Async)");
        }
        Call call = this.contractActionPostCall(contractId, actionInformation, progressListener, progressRequestListener);
        return call;
    }

    public LedgerActionOutput contractActionPost(Integer contractId, WorkflowActionInput actionInformation) throws ApiException {
        ApiResponse<LedgerActionOutput> resp = this.contractActionPostWithHttpInfo(contractId, actionInformation);
        return resp.getData();
    }

    public ApiResponse<LedgerActionOutput> contractActionPostWithHttpInfo(Integer contractId, WorkflowActionInput actionInformation) throws ApiException {
        Call call = this.contractActionPostValidateBeforeCall(contractId, actionInformation, null, null);
        Type localVarReturnType = new TypeToken<LedgerActionOutput>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call contractActionPostAsync(Integer contractId, WorkflowActionInput actionInformation, final ApiCallback<LedgerActionOutput> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.contractActionPostValidateBeforeCall(contractId, actionInformation, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LedgerActionOutput>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call contractActionsGetCall(Integer contractId, Integer top, Integer skip, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/contracts/{contractId}/actions".replaceAll("\\{contractId\\}", this.apiClient.escapeString(contractId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (top != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("top", top));
        }
        if (skip != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("skip", skip));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call contractActionsGetValidateBeforeCall(Integer contractId, Integer top, Integer skip, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractId == null) {
            throw new ApiException("Missing the required parameter 'contractId' when calling contractActionsGet(Async)");
        }
        Call call = this.contractActionsGetCall(contractId, top, skip, progressListener, progressRequestListener);
        return call;
    }

    public WorkflowStateTransitionList contractActionsGet(Integer contractId, Integer top, Integer skip) throws ApiException {
        ApiResponse<WorkflowStateTransitionList> resp = this.contractActionsGetWithHttpInfo(contractId, top, skip);
        return resp.getData();
    }

    public ApiResponse<WorkflowStateTransitionList> contractActionsGetWithHttpInfo(Integer contractId, Integer top, Integer skip) throws ApiException {
        Call call = this.contractActionsGetValidateBeforeCall(contractId, top, skip, null, null);
        Type localVarReturnType = new TypeToken<WorkflowStateTransitionList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call contractActionsGetAsync(Integer contractId, Integer top, Integer skip, final ApiCallback<WorkflowStateTransitionList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.contractActionsGetValidateBeforeCall(contractId, top, skip, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WorkflowStateTransitionList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call contractGetCall(Integer contractId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/contracts/{contractId}".replaceAll("\\{contractId\\}", this.apiClient.escapeString(contractId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call contractGetValidateBeforeCall(Integer contractId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractId == null) {
            throw new ApiException("Missing the required parameter 'contractId' when calling contractGet(Async)");
        }
        Call call = this.contractGetCall(contractId, progressListener, progressRequestListener);
        return call;
    }

    public Contract contractGet(Integer contractId) throws ApiException {
        ApiResponse<Contract> resp = this.contractGetWithHttpInfo(contractId);
        return resp.getData();
    }

    public ApiResponse<Contract> contractGetWithHttpInfo(Integer contractId) throws ApiException {
        Call call = this.contractGetValidateBeforeCall(contractId, null, null);
        Type localVarReturnType = new TypeToken<Contract>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call contractGetAsync(Integer contractId, final ApiCallback<Contract> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.contractGetValidateBeforeCall(contractId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Contract>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call contractPostCall(WorkflowActionInput workflowActionInput, Integer workflowId, Integer contractCodeId, Integer connectionId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        WorkflowActionInput localVarPostBody = workflowActionInput;
        String localVarPath = "/api/v1/contracts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (workflowId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("workflowId", workflowId));
        }
        if (contractCodeId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("contractCodeId", contractCodeId));
        }
        if (connectionId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("connectionId", connectionId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call contractPostValidateBeforeCall(WorkflowActionInput workflowActionInput, Integer workflowId, Integer contractCodeId, Integer connectionId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.contractPostCall(workflowActionInput, workflowId, contractCodeId, connectionId, progressListener, progressRequestListener);
        return call;
    }

    public WorkflowActionInput contractPost(WorkflowActionInput workflowActionInput, Integer workflowId, Integer contractCodeId, Integer connectionId) throws ApiException {
        ApiResponse<WorkflowActionInput> resp = this.contractPostWithHttpInfo(workflowActionInput, workflowId, contractCodeId, connectionId);
        return resp.getData();
    }

    public ApiResponse<WorkflowActionInput> contractPostWithHttpInfo(WorkflowActionInput workflowActionInput, Integer workflowId, Integer contractCodeId, Integer connectionId) throws ApiException {
        Call call = this.contractPostValidateBeforeCall(workflowActionInput, workflowId, contractCodeId, connectionId, null, null);
        Type localVarReturnType = new TypeToken<WorkflowActionInput>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call contractPostAsync(WorkflowActionInput workflowActionInput, Integer workflowId, Integer contractCodeId, Integer connectionId, final ApiCallback<WorkflowActionInput> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.contractPostValidateBeforeCall(workflowActionInput, workflowId, contractCodeId, connectionId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WorkflowActionInput>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call contractsGetCall(Integer top, Integer skip, Integer workflowId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/contracts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (top != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("top", top));
        }
        if (skip != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("skip", skip));
        }
        if (workflowId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("workflowId", workflowId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call contractsGetValidateBeforeCall(Integer top, Integer skip, Integer workflowId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.contractsGetCall(top, skip, workflowId, progressListener, progressRequestListener);
        return call;
    }

    public ContractList contractsGet(Integer top, Integer skip, Integer workflowId) throws ApiException {
        ApiResponse<ContractList> resp = this.contractsGetWithHttpInfo(top, skip, workflowId);
        return resp.getData();
    }

    public ApiResponse<ContractList> contractsGetWithHttpInfo(Integer top, Integer skip, Integer workflowId) throws ApiException {
        Call call = this.contractsGetValidateBeforeCall(top, skip, workflowId, null, null);
        Type localVarReturnType = new TypeToken<ContractList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call contractsGetAsync(Integer top, Integer skip, Integer workflowId, final ApiCallback<ContractList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.contractsGetValidateBeforeCall(top, skip, workflowId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContractList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

