/*
 * Azure Blockchain Workbench REST API
 * The Azure Blockchain Workbench REST API is a Workbench extensibility point, which allows developers to create and manage blockchain applications, manage users and organizations within a consortium, integrate blockchain applications into services and platforms, perform transactions on a blockchain, and retrieve transactional and contract data from a blockchain.
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.api;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.swagger.client.model.Block;
import io.swagger.client.model.BlockList;
import io.swagger.client.model.Connection;
import io.swagger.client.model.ConnectionList;
import io.swagger.client.model.Transaction;
import io.swagger.client.model.TransactionList;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConnectionsApi {
    private ApiClient apiClient;

    public ConnectionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ConnectionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for blockGet
     * @param connectionId The connectionId of the block (required)
     * @param blockId The id of the block (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call blockGetCall(Integer connectionId, Integer blockId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/ledgers/connections/{connectionId}/blocks/{blockId}"
            .replaceAll("\\{" + "connectionId" + "\\}", apiClient.escapeString(connectionId.toString()))
            .replaceAll("\\{" + "blockId" + "\\}", apiClient.escapeString(blockId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call blockGetValidateBeforeCall(Integer connectionId, Integer blockId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'connectionId' is set
        if (connectionId == null) {
            throw new ApiException("Missing the required parameter 'connectionId' when calling blockGet(Async)");
        }
        
        // verify the required parameter 'blockId' is set
        if (blockId == null) {
            throw new ApiException("Missing the required parameter 'blockId' when calling blockGet(Async)");
        }
        

        com.squareup.okhttp.Call call = blockGetCall(connectionId, blockId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * 
     * Gets the block matching a specific block ID.
     * @param connectionId The connectionId of the block (required)
     * @param blockId The id of the block (required)
     * @return Block
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Block blockGet(Integer connectionId, Integer blockId) throws ApiException {
        ApiResponse<Block> resp = blockGetWithHttpInfo(connectionId, blockId);
        return resp.getData();
    }

    /**
     * 
     * Gets the block matching a specific block ID.
     * @param connectionId The connectionId of the block (required)
     * @param blockId The id of the block (required)
     * @return ApiResponse&lt;Block&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Block> blockGetWithHttpInfo(Integer connectionId, Integer blockId) throws ApiException {
        com.squareup.okhttp.Call call = blockGetValidateBeforeCall(connectionId, blockId, null, null);
        Type localVarReturnType = new TypeToken<Block>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Gets the block matching a specific block ID.
     * @param connectionId The connectionId of the block (required)
     * @param blockId The id of the block (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call blockGetAsync(Integer connectionId, Integer blockId, final ApiCallback<Block> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = blockGetValidateBeforeCall(connectionId, blockId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Block>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for blocksGet
     * @param connectionID The id of the connection (required)
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call blocksGetCall(Integer connectionID, Integer top, Integer skip, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/ledgers/connections/{connectionId}/blocks"
            .replaceAll("\\{" + "connectionID" + "\\}", apiClient.escapeString(connectionID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (top != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("top", top));
        if (skip != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("skip", skip));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call blocksGetValidateBeforeCall(Integer connectionID, Integer top, Integer skip, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'connectionID' is set
        if (connectionID == null) {
            throw new ApiException("Missing the required parameter 'connectionID' when calling blocksGet(Async)");
        }
        

        com.squareup.okhttp.Call call = blocksGetCall(connectionID, top, skip, progressListener, progressRequestListener);
        return call;

    }

    /**
     * 
     * Lists the blocks for a connected blockchain network.
     * @param connectionID The id of the connection (required)
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @return BlockList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public BlockList blocksGet(Integer connectionID, Integer top, Integer skip) throws ApiException {
        ApiResponse<BlockList> resp = blocksGetWithHttpInfo(connectionID, top, skip);
        return resp.getData();
    }

    /**
     * 
     * Lists the blocks for a connected blockchain network.
     * @param connectionID The id of the connection (required)
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @return ApiResponse&lt;BlockList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<BlockList> blocksGetWithHttpInfo(Integer connectionID, Integer top, Integer skip) throws ApiException {
        com.squareup.okhttp.Call call = blocksGetValidateBeforeCall(connectionID, top, skip, null, null);
        Type localVarReturnType = new TypeToken<BlockList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Lists the blocks for a connected blockchain network.
     * @param connectionID The id of the connection (required)
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call blocksGetAsync(Integer connectionID, Integer top, Integer skip, final ApiCallback<BlockList> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = blocksGetValidateBeforeCall(connectionID, top, skip, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BlockList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for connectionGet
     * @param connectionID The id of the connection (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call connectionGetCall(Integer connectionID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/ledgers/connections/{connectionId}"
            .replaceAll("\\{" + "connectionID" + "\\}", apiClient.escapeString(connectionID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call connectionGetValidateBeforeCall(Integer connectionID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'connectionID' is set
        if (connectionID == null) {
            throw new ApiException("Missing the required parameter 'connectionID' when calling connectionGet(Async)");
        }
        

        com.squareup.okhttp.Call call = connectionGetCall(connectionID, progressListener, progressRequestListener);
        return call;

    }

    /**
     * 
     * Gets the connected blockchain network matching a specific chain instance ID.
     * @param connectionID The id of the connection (required)
     * @return Connection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Connection connectionGet(Integer connectionID) throws ApiException {
        ApiResponse<Connection> resp = connectionGetWithHttpInfo(connectionID);
        return resp.getData();
    }

    /**
     * 
     * Gets the connected blockchain network matching a specific chain instance ID.
     * @param connectionID The id of the connection (required)
     * @return ApiResponse&lt;Connection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Connection> connectionGetWithHttpInfo(Integer connectionID) throws ApiException {
        com.squareup.okhttp.Call call = connectionGetValidateBeforeCall(connectionID, null, null);
        Type localVarReturnType = new TypeToken<Connection>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Gets the connected blockchain network matching a specific chain instance ID.
     * @param connectionID The id of the connection (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call connectionGetAsync(Integer connectionID, final ApiCallback<Connection> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = connectionGetValidateBeforeCall(connectionID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Connection>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for connectionsGet
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call connectionsGetCall(Integer top, Integer skip, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/ledgers/connections";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (top != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("top", top));
        if (skip != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("skip", skip));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call connectionsGetValidateBeforeCall(Integer top, Integer skip, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = connectionsGetCall(top, skip, progressListener, progressRequestListener);
        return call;

    }

    /**
     * 
     * Lists the connected blockchain networks.
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @return ConnectionList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ConnectionList connectionsGet(Integer top, Integer skip) throws ApiException {
        ApiResponse<ConnectionList> resp = connectionsGetWithHttpInfo(top, skip);
        return resp.getData();
    }

    /**
     * 
     * Lists the connected blockchain networks.
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @return ApiResponse&lt;ConnectionList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ConnectionList> connectionsGetWithHttpInfo(Integer top, Integer skip) throws ApiException {
        com.squareup.okhttp.Call call = connectionsGetValidateBeforeCall(top, skip, null, null);
        Type localVarReturnType = new TypeToken<ConnectionList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Lists the connected blockchain networks.
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call connectionsGetAsync(Integer top, Integer skip, final ApiCallback<ConnectionList> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = connectionsGetValidateBeforeCall(top, skip, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ConnectionList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for transactionGet
     * @param connectionId The connectionId of the transaction (required)
     * @param transactionId The id of the transaction (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call transactionGetCall(Integer connectionId, Integer transactionId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/ledgers/connections/{connectionId}/transactions/{transactionId}"
            .replaceAll("\\{" + "connectionId" + "\\}", apiClient.escapeString(connectionId.toString()))
            .replaceAll("\\{" + "transactionId" + "\\}", apiClient.escapeString(transactionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call transactionGetValidateBeforeCall(Integer connectionId, Integer transactionId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'connectionId' is set
        if (connectionId == null) {
            throw new ApiException("Missing the required parameter 'connectionId' when calling transactionGet(Async)");
        }
        
        // verify the required parameter 'transactionId' is set
        if (transactionId == null) {
            throw new ApiException("Missing the required parameter 'transactionId' when calling transactionGet(Async)");
        }
        

        com.squareup.okhttp.Call call = transactionGetCall(connectionId, transactionId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * 
     * Gets the transaction matching a specific transaction ID.
     * @param connectionId The connectionId of the transaction (required)
     * @param transactionId The id of the transaction (required)
     * @return Transaction
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Transaction transactionGet(Integer connectionId, Integer transactionId) throws ApiException {
        ApiResponse<Transaction> resp = transactionGetWithHttpInfo(connectionId, transactionId);
        return resp.getData();
    }

    /**
     * 
     * Gets the transaction matching a specific transaction ID.
     * @param connectionId The connectionId of the transaction (required)
     * @param transactionId The id of the transaction (required)
     * @return ApiResponse&lt;Transaction&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Transaction> transactionGetWithHttpInfo(Integer connectionId, Integer transactionId) throws ApiException {
        com.squareup.okhttp.Call call = transactionGetValidateBeforeCall(connectionId, transactionId, null, null);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Gets the transaction matching a specific transaction ID.
     * @param connectionId The connectionId of the transaction (required)
     * @param transactionId The id of the transaction (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call transactionGetAsync(Integer connectionId, Integer transactionId, final ApiCallback<Transaction> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = transactionGetValidateBeforeCall(connectionId, transactionId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for transactionsGet
     * @param connectionId The id of the connection (required)
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call transactionsGetCall(Integer connectionId, Integer top, Integer skip, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/ledgers/connections/{connectionId}/transactions"
            .replaceAll("\\{" + "connectionId" + "\\}", apiClient.escapeString(connectionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (top != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("top", top));
        if (skip != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("skip", skip));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call transactionsGetValidateBeforeCall(Integer connectionId, Integer top, Integer skip, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'connectionId' is set
        if (connectionId == null) {
            throw new ApiException("Missing the required parameter 'connectionId' when calling transactionsGet(Async)");
        }
        

        com.squareup.okhttp.Call call = transactionsGetCall(connectionId, top, skip, progressListener, progressRequestListener);
        return call;

    }

    /**
     * 
     * Lists the transactions for a connected blockchain network.
     * @param connectionId The id of the connection (required)
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @return List&lt;TransactionList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<TransactionList> transactionsGet(Integer connectionId, Integer top, Integer skip) throws ApiException {
        ApiResponse<List<TransactionList>> resp = transactionsGetWithHttpInfo(connectionId, top, skip);
        return resp.getData();
    }

    /**
     * 
     * Lists the transactions for a connected blockchain network.
     * @param connectionId The id of the connection (required)
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @return ApiResponse&lt;List&lt;TransactionList&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<TransactionList>> transactionsGetWithHttpInfo(Integer connectionId, Integer top, Integer skip) throws ApiException {
        com.squareup.okhttp.Call call = transactionsGetValidateBeforeCall(connectionId, top, skip, null, null);
        Type localVarReturnType = new TypeToken<List<TransactionList>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Lists the transactions for a connected blockchain network.
     * @param connectionId The id of the connection (required)
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call transactionsGetAsync(Integer connectionId, Integer top, Integer skip, final ApiCallback<List<TransactionList>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = transactionsGetValidateBeforeCall(connectionId, top, skip, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<TransactionList>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
