# coding: utf-8

"""
    Azure Blockchain Workbench REST API

    The Azure Blockchain Workbench REST API is a Workbench extensibility point, which allows developers to create and manage blockchain applications, manage users and organizations within a consortium, integrate blockchain applications into services and platforms, perform transactions on a blockchain, and retrieve transactional and contract data from a blockchain.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from swagger_client.models.user_chain_mapping import UserChainMapping  # noqa: F401,E501


class User(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'user_id': 'int',
        'provisioning_status': 'int',
        'external_id': 'str',
        'first_name': 'str',
        'last_name': 'str',
        'email_address': 'str',
        'user_chain_mappings': 'list[UserChainMapping]'
    }

    attribute_map = {
        'user_id': 'userID',
        'provisioning_status': 'provisioningStatus',
        'external_id': 'externalID',
        'first_name': 'firstName',
        'last_name': 'lastName',
        'email_address': 'emailAddress',
        'user_chain_mappings': 'userChainMappings'
    }

    def __init__(self, user_id=None, provisioning_status=None, external_id=None, first_name=None, last_name=None, email_address=None, user_chain_mappings=None):  # noqa: E501
        """User - a model defined in Swagger"""  # noqa: E501

        self._user_id = None
        self._provisioning_status = None
        self._external_id = None
        self._first_name = None
        self._last_name = None
        self._email_address = None
        self._user_chain_mappings = None
        self.discriminator = None

        if user_id is not None:
            self.user_id = user_id
        if provisioning_status is not None:
            self.provisioning_status = provisioning_status
        if external_id is not None:
            self.external_id = external_id
        if first_name is not None:
            self.first_name = first_name
        if last_name is not None:
            self.last_name = last_name
        if email_address is not None:
            self.email_address = email_address
        if user_chain_mappings is not None:
            self.user_chain_mappings = user_chain_mappings

    @property
    def user_id(self):
        """Gets the user_id of this User.  # noqa: E501


        :return: The user_id of this User.  # noqa: E501
        :rtype: int
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this User.


        :param user_id: The user_id of this User.  # noqa: E501
        :type: int
        """

        self._user_id = user_id

    @property
    def provisioning_status(self):
        """Gets the provisioning_status of this User.  # noqa: E501


        :return: The provisioning_status of this User.  # noqa: E501
        :rtype: int
        """
        return self._provisioning_status

    @provisioning_status.setter
    def provisioning_status(self, provisioning_status):
        """Sets the provisioning_status of this User.


        :param provisioning_status: The provisioning_status of this User.  # noqa: E501
        :type: int
        """

        self._provisioning_status = provisioning_status

    @property
    def external_id(self):
        """Gets the external_id of this User.  # noqa: E501


        :return: The external_id of this User.  # noqa: E501
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """Sets the external_id of this User.


        :param external_id: The external_id of this User.  # noqa: E501
        :type: str
        """

        self._external_id = external_id

    @property
    def first_name(self):
        """Gets the first_name of this User.  # noqa: E501


        :return: The first_name of this User.  # noqa: E501
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """Sets the first_name of this User.


        :param first_name: The first_name of this User.  # noqa: E501
        :type: str
        """

        self._first_name = first_name

    @property
    def last_name(self):
        """Gets the last_name of this User.  # noqa: E501


        :return: The last_name of this User.  # noqa: E501
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """Sets the last_name of this User.


        :param last_name: The last_name of this User.  # noqa: E501
        :type: str
        """

        self._last_name = last_name

    @property
    def email_address(self):
        """Gets the email_address of this User.  # noqa: E501


        :return: The email_address of this User.  # noqa: E501
        :rtype: str
        """
        return self._email_address

    @email_address.setter
    def email_address(self, email_address):
        """Sets the email_address of this User.


        :param email_address: The email_address of this User.  # noqa: E501
        :type: str
        """

        self._email_address = email_address

    @property
    def user_chain_mappings(self):
        """Gets the user_chain_mappings of this User.  # noqa: E501


        :return: The user_chain_mappings of this User.  # noqa: E501
        :rtype: list[UserChainMapping]
        """
        return self._user_chain_mappings

    @user_chain_mappings.setter
    def user_chain_mappings(self, user_chain_mappings):
        """Sets the user_chain_mappings of this User.


        :param user_chain_mappings: The user_chain_mappings of this User.  # noqa: E501
        :type: list[UserChainMapping]
        """

        self._user_chain_mappings = user_chain_mappings

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, User):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
