# coding: utf-8

"""
    Azure Blockchain Workbench REST API

    The Azure Blockchain Workbench REST API is a Workbench extensibility point, which allows developers to create and manage blockchain applications, manage users and organizations within a consortium, integrate blockchain applications into services and platforms, perform transactions on a blockchain, and retrieve transactional and contract data from a blockchain.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class ConnectionsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def block_get(self, connection_id, block_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Gets the block matching a specific block ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.block_get(connection_id, block_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int connection_id: The connectionId of the block (required)
        :param int block_id: The id of the block (required)
        :return: Block
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.block_get_with_http_info(connection_id, block_id, **kwargs)  # noqa: E501
        else:
            (data) = self.block_get_with_http_info(connection_id, block_id, **kwargs)  # noqa: E501
            return data

    def block_get_with_http_info(self, connection_id, block_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Gets the block matching a specific block ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.block_get_with_http_info(connection_id, block_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int connection_id: The connectionId of the block (required)
        :param int block_id: The id of the block (required)
        :return: Block
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['connection_id', 'block_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method block_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'connection_id' is set
        if ('connection_id' not in params or
                params['connection_id'] is None):
            raise ValueError("Missing the required parameter `connection_id` when calling `block_get`")  # noqa: E501
        # verify the required parameter 'block_id' is set
        if ('block_id' not in params or
                params['block_id'] is None):
            raise ValueError("Missing the required parameter `block_id` when calling `block_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'connection_id' in params:
            path_params['connectionId'] = params['connection_id']  # noqa: E501
        if 'block_id' in params:
            path_params['blockId'] = params['block_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/ledgers/connections/{connectionId}/blocks/{blockId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Block',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def blocks_get(self, connection_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Lists the blocks for a connected blockchain network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.blocks_get(connection_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int connection_id: The id of the connection (required)
        :param int top: The maximum number of items to return
        :param int skip: The number of items to skip before returning
        :return: BlockList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.blocks_get_with_http_info(connection_id, **kwargs)  # noqa: E501
        else:
            (data) = self.blocks_get_with_http_info(connection_id, **kwargs)  # noqa: E501
            return data

    def blocks_get_with_http_info(self, connection_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Lists the blocks for a connected blockchain network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.blocks_get_with_http_info(connection_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int connection_id: The id of the connection (required)
        :param int top: The maximum number of items to return
        :param int skip: The number of items to skip before returning
        :return: BlockList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['connection_id', 'top', 'skip']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blocks_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'connection_id' is set
        if ('connection_id' not in params or
                params['connection_id'] is None):
            raise ValueError("Missing the required parameter `connection_id` when calling `blocks_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'connection_id' in params:
            path_params['connectionID'] = params['connection_id']  # noqa: E501

        query_params = []
        if 'top' in params:
            query_params.append(('top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/ledgers/connections/{connectionId}/blocks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BlockList',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def connection_get(self, connection_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Gets the connected blockchain network matching a specific chain instance ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.connection_get(connection_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int connection_id: The id of the connection (required)
        :return: Connection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.connection_get_with_http_info(connection_id, **kwargs)  # noqa: E501
        else:
            (data) = self.connection_get_with_http_info(connection_id, **kwargs)  # noqa: E501
            return data

    def connection_get_with_http_info(self, connection_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Gets the connected blockchain network matching a specific chain instance ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.connection_get_with_http_info(connection_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int connection_id: The id of the connection (required)
        :return: Connection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['connection_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connection_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'connection_id' is set
        if ('connection_id' not in params or
                params['connection_id'] is None):
            raise ValueError("Missing the required parameter `connection_id` when calling `connection_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'connection_id' in params:
            path_params['connectionID'] = params['connection_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/ledgers/connections/{connectionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Connection',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def connections_get(self, **kwargs):  # noqa: E501
        """  # noqa: E501

        Lists the connected blockchain networks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.connections_get(async=True)
        >>> result = thread.get()

        :param async bool
        :param int top: The maximum number of items to return
        :param int skip: The number of items to skip before returning
        :return: ConnectionList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.connections_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.connections_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def connections_get_with_http_info(self, **kwargs):  # noqa: E501
        """  # noqa: E501

        Lists the connected blockchain networks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.connections_get_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param int top: The maximum number of items to return
        :param int skip: The number of items to skip before returning
        :return: ConnectionList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['top', 'skip']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connections_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'top' in params:
            query_params.append(('top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/ledgers/connections', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConnectionList',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def transaction_get(self, connection_id, transaction_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Gets the transaction matching a specific transaction ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.transaction_get(connection_id, transaction_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int connection_id: The connectionId of the transaction (required)
        :param int transaction_id: The id of the transaction (required)
        :return: Transaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.transaction_get_with_http_info(connection_id, transaction_id, **kwargs)  # noqa: E501
        else:
            (data) = self.transaction_get_with_http_info(connection_id, transaction_id, **kwargs)  # noqa: E501
            return data

    def transaction_get_with_http_info(self, connection_id, transaction_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Gets the transaction matching a specific transaction ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.transaction_get_with_http_info(connection_id, transaction_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int connection_id: The connectionId of the transaction (required)
        :param int transaction_id: The id of the transaction (required)
        :return: Transaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['connection_id', 'transaction_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method transaction_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'connection_id' is set
        if ('connection_id' not in params or
                params['connection_id'] is None):
            raise ValueError("Missing the required parameter `connection_id` when calling `transaction_get`")  # noqa: E501
        # verify the required parameter 'transaction_id' is set
        if ('transaction_id' not in params or
                params['transaction_id'] is None):
            raise ValueError("Missing the required parameter `transaction_id` when calling `transaction_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'connection_id' in params:
            path_params['connectionId'] = params['connection_id']  # noqa: E501
        if 'transaction_id' in params:
            path_params['transactionId'] = params['transaction_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/ledgers/connections/{connectionId}/transactions/{transactionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Transaction',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def transactions_get(self, connection_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Lists the transactions for a connected blockchain network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.transactions_get(connection_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int connection_id: The id of the connection (required)
        :param int top: The maximum number of items to return
        :param int skip: The number of items to skip before returning
        :return: list[TransactionList]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.transactions_get_with_http_info(connection_id, **kwargs)  # noqa: E501
        else:
            (data) = self.transactions_get_with_http_info(connection_id, **kwargs)  # noqa: E501
            return data

    def transactions_get_with_http_info(self, connection_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Lists the transactions for a connected blockchain network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.transactions_get_with_http_info(connection_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int connection_id: The id of the connection (required)
        :param int top: The maximum number of items to return
        :param int skip: The number of items to skip before returning
        :return: list[TransactionList]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['connection_id', 'top', 'skip']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method transactions_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'connection_id' is set
        if ('connection_id' not in params or
                params['connection_id'] is None):
            raise ValueError("Missing the required parameter `connection_id` when calling `transactions_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'connection_id' in params:
            path_params['connectionId'] = params['connection_id']  # noqa: E501

        query_params = []
        if 'top' in params:
            query_params.append(('top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/ledgers/connections/{connectionId}/transactions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TransactionList]',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
