# coding: utf-8

"""
    Azure Blockchain Workbench REST API

    The Azure Blockchain Workbench REST API is a Workbench extensibility point, which allows developers to create and manage blockchain applications, manage users and organizations within a consortium, integrate blockchain applications into services and platforms, perform transactions on a blockchain, and retrieve transactional and contract data from a blockchain.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class ContractsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def contract_action_get(self, contract_id, action_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Gets the action matching the specified action ID. Users get the action if the user can take the action              given the current state of the specified smart contract instance and the user's associated application role or smart              contract instance role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contract_action_get(contract_id, action_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int contract_id: The id of the contract (required)
        :param int action_id: The id of the action (required)
        :return: WorkflowStateTransition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.contract_action_get_with_http_info(contract_id, action_id, **kwargs)  # noqa: E501
        else:
            (data) = self.contract_action_get_with_http_info(contract_id, action_id, **kwargs)  # noqa: E501
            return data

    def contract_action_get_with_http_info(self, contract_id, action_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Gets the action matching the specified action ID. Users get the action if the user can take the action              given the current state of the specified smart contract instance and the user's associated application role or smart              contract instance role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contract_action_get_with_http_info(contract_id, action_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int contract_id: The id of the contract (required)
        :param int action_id: The id of the action (required)
        :return: WorkflowStateTransition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contract_id', 'action_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method contract_action_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'contract_id' is set
        if ('contract_id' not in params or
                params['contract_id'] is None):
            raise ValueError("Missing the required parameter `contract_id` when calling `contract_action_get`")  # noqa: E501
        # verify the required parameter 'action_id' is set
        if ('action_id' not in params or
                params['action_id'] is None):
            raise ValueError("Missing the required parameter `action_id` when calling `contract_action_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'contract_id' in params:
            path_params['contractId'] = params['contract_id']  # noqa: E501
        if 'action_id' in params:
            path_params['actionId'] = params['action_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/contracts/{contractId}/actions/{actionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowStateTransition',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def contract_action_post(self, contract_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Executes an action for the specified smart contract instance and action ID. Users are only able to execute              the action given the current state of the specified smart contract instance and the user's associated application role              or smart contract instance role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contract_action_post(contract_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int contract_id: The id of the workflow instance (required)
        :param WorkflowActionInput action_information: Parameters for a particular action
        :return: LedgerActionOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.contract_action_post_with_http_info(contract_id, **kwargs)  # noqa: E501
        else:
            (data) = self.contract_action_post_with_http_info(contract_id, **kwargs)  # noqa: E501
            return data

    def contract_action_post_with_http_info(self, contract_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Executes an action for the specified smart contract instance and action ID. Users are only able to execute              the action given the current state of the specified smart contract instance and the user's associated application role              or smart contract instance role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contract_action_post_with_http_info(contract_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int contract_id: The id of the workflow instance (required)
        :param WorkflowActionInput action_information: Parameters for a particular action
        :return: LedgerActionOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contract_id', 'action_information']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method contract_action_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'contract_id' is set
        if ('contract_id' not in params or
                params['contract_id'] is None):
            raise ValueError("Missing the required parameter `contract_id` when calling `contract_action_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'contract_id' in params:
            path_params['contractId'] = params['contract_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'action_information' in params:
            body_params = params['action_information']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/contracts/{contractId}/actions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LedgerActionOutput',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def contract_actions_get(self, contract_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Lists all actions, which can be taken by the given user and current state of the specified smart contract              instance. Users get all applicable actions if the user has an associated application role or is associated with a smart              contract instance role for the current state of the specified smart contract instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contract_actions_get(contract_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int contract_id: The id of the contract (required)
        :param int top: The maximum number of items to return
        :param int skip: The number of items to skip before returning
        :return: WorkflowStateTransitionList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.contract_actions_get_with_http_info(contract_id, **kwargs)  # noqa: E501
        else:
            (data) = self.contract_actions_get_with_http_info(contract_id, **kwargs)  # noqa: E501
            return data

    def contract_actions_get_with_http_info(self, contract_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Lists all actions, which can be taken by the given user and current state of the specified smart contract              instance. Users get all applicable actions if the user has an associated application role or is associated with a smart              contract instance role for the current state of the specified smart contract instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contract_actions_get_with_http_info(contract_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int contract_id: The id of the contract (required)
        :param int top: The maximum number of items to return
        :param int skip: The number of items to skip before returning
        :return: WorkflowStateTransitionList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contract_id', 'top', 'skip']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method contract_actions_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'contract_id' is set
        if ('contract_id' not in params or
                params['contract_id'] is None):
            raise ValueError("Missing the required parameter `contract_id` when calling `contract_actions_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'contract_id' in params:
            path_params['contractId'] = params['contract_id']  # noqa: E501

        query_params = []
        if 'top' in params:
            query_params.append(('top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/contracts/{contractId}/actions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowStateTransitionList',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def contract_get(self, contract_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Creates and deploys a new smart contract instance by adding the instance to the Workbench database and              sending a transaction to the blockchain. This method can only be performed by users who are specified within the              Initiators collection of the workflow within the Workbench application configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contract_get(contract_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int contract_id: The id of the contract (required)
        :return: Contract
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.contract_get_with_http_info(contract_id, **kwargs)  # noqa: E501
        else:
            (data) = self.contract_get_with_http_info(contract_id, **kwargs)  # noqa: E501
            return data

    def contract_get_with_http_info(self, contract_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Creates and deploys a new smart contract instance by adding the instance to the Workbench database and              sending a transaction to the blockchain. This method can only be performed by users who are specified within the              Initiators collection of the workflow within the Workbench application configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contract_get_with_http_info(contract_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int contract_id: The id of the contract (required)
        :return: Contract
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contract_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method contract_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'contract_id' is set
        if ('contract_id' not in params or
                params['contract_id'] is None):
            raise ValueError("Missing the required parameter `contract_id` when calling `contract_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'contract_id' in params:
            path_params['contractId'] = params['contract_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/contracts/{contractId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Contract',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def contract_post(self, **kwargs):  # noqa: E501
        """  # noqa: E501

        Gets the smart contract instance matching a specific workflow instance ID. Users who are Workbench              administrators get the smart contract instance. Non-Workbench administrators get the smart contract instance              if they have at least one associated application role or is associated with the smart contract instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contract_post(async=True)
        >>> result = thread.get()

        :param async bool
        :param WorkflowActionInput workflow_action_input: The set of all contract action parameters.
        :param int workflow_id: The ID of the workflow.
        :param int contract_code_id: The ID of the ledger implementation.
        :param int connection_id: The ID of chain instance running on the ledger.
        :return: WorkflowActionInput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.contract_post_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.contract_post_with_http_info(**kwargs)  # noqa: E501
            return data

    def contract_post_with_http_info(self, **kwargs):  # noqa: E501
        """  # noqa: E501

        Gets the smart contract instance matching a specific workflow instance ID. Users who are Workbench              administrators get the smart contract instance. Non-Workbench administrators get the smart contract instance              if they have at least one associated application role or is associated with the smart contract instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contract_post_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param WorkflowActionInput workflow_action_input: The set of all contract action parameters.
        :param int workflow_id: The ID of the workflow.
        :param int contract_code_id: The ID of the ledger implementation.
        :param int connection_id: The ID of chain instance running on the ledger.
        :return: WorkflowActionInput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_action_input', 'workflow_id', 'contract_code_id', 'connection_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method contract_post" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'workflow_id' in params:
            query_params.append(('workflowId', params['workflow_id']))  # noqa: E501
        if 'contract_code_id' in params:
            query_params.append(('contractCodeId', params['contract_code_id']))  # noqa: E501
        if 'connection_id' in params:
            query_params.append(('connectionId', params['connection_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'workflow_action_input' in params:
            body_params = params['workflow_action_input']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/contracts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowActionInput',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def contracts_get(self, **kwargs):  # noqa: E501
        """  # noqa: E501

        Lists the smart contract instances of the specified workflow. Users who are Workbench administrators get all              smart contract instances. Non-Workbench administrators get all smart contract instances for which they have at least              one associated application role or is associated with a smart contract instance role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contracts_get(async=True)
        >>> result = thread.get()

        :param async bool
        :param int top: The maximum number of items to return
        :param int skip: The number of items to skip before returning
        :param int workflow_id: The ID of the associated workflow
        :return: ContractList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.contracts_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.contracts_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def contracts_get_with_http_info(self, **kwargs):  # noqa: E501
        """  # noqa: E501

        Lists the smart contract instances of the specified workflow. Users who are Workbench administrators get all              smart contract instances. Non-Workbench administrators get all smart contract instances for which they have at least              one associated application role or is associated with a smart contract instance role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.contracts_get_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param int top: The maximum number of items to return
        :param int skip: The number of items to skip before returning
        :param int workflow_id: The ID of the associated workflow
        :return: ContractList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['top', 'skip', 'workflow_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method contracts_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'top' in params:
            query_params.append(('top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501
        if 'workflow_id' in params:
            query_params.append(('workflowId', params['workflow_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/contracts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContractList',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
