/*
 * Azure Blockchain Workbench REST API
 * The Azure Blockchain Workbench REST API is a Workbench extensibility point, which allows developers to create and manage blockchain applications, manage users and organizations within a consortium, integrate blockchain applications into services and platforms, perform transactions on a blockchain, and retrieve transactional and contract data from a blockchain.
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.api;

import io.swagger.client.ApiException;
import io.swagger.client.model.Application;
import io.swagger.client.model.ApplicationList;
import io.swagger.client.model.ContractCodeList;
import java.io.File;
import io.swagger.client.model.FileStreamResult;
import io.swagger.client.model.RoleAssignment;
import io.swagger.client.model.RoleAssignmentInput;
import io.swagger.client.model.RoleAssignmentList;
import io.swagger.client.model.Workflow;
import io.swagger.client.model.WorkflowList;
import org.junit.Test;
import org.junit.Ignore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * API tests for ApplicationsApi
 */
@Ignore
public class ApplicationsApiTest {

    private final ApplicationsApi api = new ApplicationsApi();

    
    /**
     * 
     *
     * Deletes the specified blockchain application. This method can only be performed by users who are              Workbench administrators. NOTE: Currently not implemented.
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void applicationDeleteTest() throws ApiException {
        String applicationID = null;
        api.applicationDelete(applicationID);

        // TODO: test validations
    }
    
    /**
     * 
     *
     * Disables the specified blockchain application. This method can only be performed by users who are              Workbench administrators.
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void applicationDisableTest() throws ApiException {
        Integer applicationId = null;
        api.applicationDisable(applicationId);

        // TODO: test validations
    }
    
    /**
     * 
     *
     * Enables the specified blockchain application. This method can only be performed by users who are              Workbench administrators.
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void applicationEnableTest() throws ApiException {
        Integer applicationId = null;
        api.applicationEnable(applicationId);

        // TODO: test validations
    }
    
    /**
     * 
     *
     * Gets the blockchain application matching a specific application ID. Users who are Workbench administrators get              the blockchain application. Non-Workbench administrators get the blockchain application if they have at least one associated              application role or is associated with a smart contract instance role.
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void applicationGetTest() throws ApiException {
        Integer applicationId = null;
        Application response = api.applicationGet(applicationId);

        // TODO: test validations
    }
    
    /**
     * 
     *
     * Lists all blockchain applications to which a user has access in Workbench. Users who are Workbench administrators get              all blockchain applications. Non-Workbench administrators get all blockchain applications for which they have at least one              associated application role or an associated smart contract instance role.
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void applicationsGetTest() throws ApiException {
        Integer top = null;
        Integer skip = null;
        Boolean enabled = null;
        ApplicationList response = api.applicationsGet(top, skip, enabled);

        // TODO: test validations
    }
    
    /**
     * 
     *
     * Creates a new blockchain application. This method can only be performed by users who are              Workbench administrators.
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void applicationsPostTest() throws ApiException {
        File file = null;
        Integer response = api.applicationsPost(file);

        // TODO: test validations
    }
    
    /**
     * 
     *
     * Deletes the specified blockchain smart contract implementation of a specific blockchain application.              This method can only be performed by users who are Workbench administrators.              NOTE: not currently implemented
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void contractCodeDeleteTest() throws ApiException {
        Integer contractCodeId = null;
        api.contractCodeDelete(contractCodeId);

        // TODO: test validations
    }
    
    /**
     * 
     *
     * Get the blockchain smart contract implementation matching a specific              ledger implementation ID. Users who are Workbench administrators get the specified smart contract implementation.              Non-Workbench administrators get the smart contract implementation if they have at least one associated application              role or is associated with a smart contract instance role.
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void contractCodeGetTest() throws ApiException {
        Integer contractCodeId = null;
        FileStreamResult response = api.contractCodeGet(contractCodeId);

        // TODO: test validations
    }
    
    /**
     * 
     *
     * Uploads one or more smart contracts (ex. .sol or .zip), representing the implementation of the specified blockchain              application. This method can only be performed by users who are Workbench administrators.
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void contractCodePostTest() throws ApiException {
        Integer applicationId = null;
        File file = null;
        Integer ledgerId = null;
        Integer response = api.contractCodePost(applicationId, file, ledgerId);

        // TODO: test validations
    }
    
    /**
     * 
     *
     * List all blockchain smart contract implementations of the specified blockchain application.              Users who are Workbench administrators get all smart contract implementations. Non-Workbench administrators get all              smart contract implementations for which they have at least one associated application role or is associated with a              smart contract instance role.
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void contractCodesGetTest() throws ApiException {
        Integer applicationId = null;
        Integer ledgerId = null;
        Integer top = null;
        Integer skip = null;
        ContractCodeList response = api.contractCodesGet(applicationId, ledgerId, top, skip);

        // TODO: test validations
    }
    
    /**
     * 
     *
     * Deletes the specified role assignment. This method can only be performed by users who are              Workbench administrators.
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void roleAssignmentDeleteTest() throws ApiException {
        Integer applicationId = null;
        Integer roleAssignmentId = null;
        api.roleAssignmentDelete(applicationId, roleAssignmentId);

        // TODO: test validations
    }
    
    /**
     * 
     *
     * Get a role assignment of the specified blockchain application matching a specific user role assignment ID.              Users who are Workbench administrators get the role assignment. Non-Workbench administrators get the role assignment              if they are associated in the application.
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void roleAssignmentGetTest() throws ApiException {
        Integer applicationId = null;
        Integer roleAssignmentId = null;
        RoleAssignment response = api.roleAssignmentGet(applicationId, roleAssignmentId);

        // TODO: test validations
    }
    
    /**
     * 
     *
     * List all role assignments of the specified blockchain application. Users who are Workbench administrators              get all role assignments. Non-Workbench administrators get all their role assignments. Roles are specified              in the Workbench application configuration and can be retrieved from GET /applications/{applicationID}.              Also, user information can be retrieved from GET /users/{userID}.
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void roleAssignmentsGetTest() throws ApiException {
        Integer applicationId = null;
        Integer applicationRoleId = null;
        Integer top = null;
        Integer skip = null;
        RoleAssignmentList response = api.roleAssignmentsGet(applicationId, applicationRoleId, top, skip);

        // TODO: test validations
    }
    
    /**
     * 
     *
     * Creates a user-to-role mapping in the specified blockchain application. This method can only be performed by              users who are Workbench administrators.
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void roleAssignmentsPostTest() throws ApiException {
        Integer applicationId = null;
        RoleAssignmentInput roleAssignment = null;
        Integer response = api.roleAssignmentsPost(applicationId, roleAssignment);

        // TODO: test validations
    }
    
    /**
     * 
     *
     * Get a workflow matching a specific workflow ID.              Users who are Workbench administrators get the workflow. Non-Workbench administrators get the workflow if they              have at least one associated application role or is associated with a smart contract instance role.
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void workflowGetTest() throws ApiException {
        Integer workflowId = null;
        Workflow response = api.workflowGet(workflowId);

        // TODO: test validations
    }
    
    /**
     * 
     *
     * List all workflows of the specified blockchain application. Users who are Workbench administrators get all              workflows. Non-Workbench administrators get all workflows for which they have at least one associated application role              or is associated with a smart contract instance role.
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void workflowsGetTest() throws ApiException {
        Integer applicationId = null;
        Integer top = null;
        Integer skip = null;
        WorkflowList response = api.workflowsGet(applicationId, top, skip);

        // TODO: test validations
    }
    
}
