/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.Block;
import io.swagger.client.model.BlockList;
import io.swagger.client.model.Connection;
import io.swagger.client.model.ConnectionList;
import io.swagger.client.model.Transaction;
import io.swagger.client.model.TransactionList;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ConnectionsApi {
    private ApiClient apiClient;

    public ConnectionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ConnectionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call blockGetCall(Integer connectionId, Integer blockId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/ledgers/connections/{connectionId}/blocks/{blockId}".replaceAll("\\{connectionId\\}", this.apiClient.escapeString(connectionId.toString())).replaceAll("\\{blockId\\}", this.apiClient.escapeString(blockId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call blockGetValidateBeforeCall(Integer connectionId, Integer blockId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (connectionId == null) {
            throw new ApiException("Missing the required parameter 'connectionId' when calling blockGet(Async)");
        }
        if (blockId == null) {
            throw new ApiException("Missing the required parameter 'blockId' when calling blockGet(Async)");
        }
        Call call = this.blockGetCall(connectionId, blockId, progressListener, progressRequestListener);
        return call;
    }

    public Block blockGet(Integer connectionId, Integer blockId) throws ApiException {
        ApiResponse<Block> resp = this.blockGetWithHttpInfo(connectionId, blockId);
        return resp.getData();
    }

    public ApiResponse<Block> blockGetWithHttpInfo(Integer connectionId, Integer blockId) throws ApiException {
        Call call = this.blockGetValidateBeforeCall(connectionId, blockId, null, null);
        Type localVarReturnType = new TypeToken<Block>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call blockGetAsync(Integer connectionId, Integer blockId, final ApiCallback<Block> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.blockGetValidateBeforeCall(connectionId, blockId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Block>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call blocksGetCall(Integer connectionID, Integer top, Integer skip, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/ledgers/connections/{connectionId}/blocks".replaceAll("\\{connectionID\\}", this.apiClient.escapeString(connectionID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (top != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("top", top));
        }
        if (skip != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("skip", skip));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call blocksGetValidateBeforeCall(Integer connectionID, Integer top, Integer skip, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (connectionID == null) {
            throw new ApiException("Missing the required parameter 'connectionID' when calling blocksGet(Async)");
        }
        Call call = this.blocksGetCall(connectionID, top, skip, progressListener, progressRequestListener);
        return call;
    }

    public BlockList blocksGet(Integer connectionID, Integer top, Integer skip) throws ApiException {
        ApiResponse<BlockList> resp = this.blocksGetWithHttpInfo(connectionID, top, skip);
        return resp.getData();
    }

    public ApiResponse<BlockList> blocksGetWithHttpInfo(Integer connectionID, Integer top, Integer skip) throws ApiException {
        Call call = this.blocksGetValidateBeforeCall(connectionID, top, skip, null, null);
        Type localVarReturnType = new TypeToken<BlockList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call blocksGetAsync(Integer connectionID, Integer top, Integer skip, final ApiCallback<BlockList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.blocksGetValidateBeforeCall(connectionID, top, skip, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BlockList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call connectionGetCall(Integer connectionID, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/ledgers/connections/{connectionId}".replaceAll("\\{connectionID\\}", this.apiClient.escapeString(connectionID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call connectionGetValidateBeforeCall(Integer connectionID, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (connectionID == null) {
            throw new ApiException("Missing the required parameter 'connectionID' when calling connectionGet(Async)");
        }
        Call call = this.connectionGetCall(connectionID, progressListener, progressRequestListener);
        return call;
    }

    public Connection connectionGet(Integer connectionID) throws ApiException {
        ApiResponse<Connection> resp = this.connectionGetWithHttpInfo(connectionID);
        return resp.getData();
    }

    public ApiResponse<Connection> connectionGetWithHttpInfo(Integer connectionID) throws ApiException {
        Call call = this.connectionGetValidateBeforeCall(connectionID, null, null);
        Type localVarReturnType = new TypeToken<Connection>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call connectionGetAsync(Integer connectionID, final ApiCallback<Connection> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.connectionGetValidateBeforeCall(connectionID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Connection>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call connectionsGetCall(Integer top, Integer skip, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/ledgers/connections";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (top != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("top", top));
        }
        if (skip != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("skip", skip));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call connectionsGetValidateBeforeCall(Integer top, Integer skip, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.connectionsGetCall(top, skip, progressListener, progressRequestListener);
        return call;
    }

    public ConnectionList connectionsGet(Integer top, Integer skip) throws ApiException {
        ApiResponse<ConnectionList> resp = this.connectionsGetWithHttpInfo(top, skip);
        return resp.getData();
    }

    public ApiResponse<ConnectionList> connectionsGetWithHttpInfo(Integer top, Integer skip) throws ApiException {
        Call call = this.connectionsGetValidateBeforeCall(top, skip, null, null);
        Type localVarReturnType = new TypeToken<ConnectionList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call connectionsGetAsync(Integer top, Integer skip, final ApiCallback<ConnectionList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.connectionsGetValidateBeforeCall(top, skip, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ConnectionList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call transactionGetCall(Integer connectionId, Integer transactionId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/ledgers/connections/{connectionId}/transactions/{transactionId}".replaceAll("\\{connectionId\\}", this.apiClient.escapeString(connectionId.toString())).replaceAll("\\{transactionId\\}", this.apiClient.escapeString(transactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call transactionGetValidateBeforeCall(Integer connectionId, Integer transactionId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (connectionId == null) {
            throw new ApiException("Missing the required parameter 'connectionId' when calling transactionGet(Async)");
        }
        if (transactionId == null) {
            throw new ApiException("Missing the required parameter 'transactionId' when calling transactionGet(Async)");
        }
        Call call = this.transactionGetCall(connectionId, transactionId, progressListener, progressRequestListener);
        return call;
    }

    public Transaction transactionGet(Integer connectionId, Integer transactionId) throws ApiException {
        ApiResponse<Transaction> resp = this.transactionGetWithHttpInfo(connectionId, transactionId);
        return resp.getData();
    }

    public ApiResponse<Transaction> transactionGetWithHttpInfo(Integer connectionId, Integer transactionId) throws ApiException {
        Call call = this.transactionGetValidateBeforeCall(connectionId, transactionId, null, null);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call transactionGetAsync(Integer connectionId, Integer transactionId, final ApiCallback<Transaction> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.transactionGetValidateBeforeCall(connectionId, transactionId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call transactionsGetCall(Integer connectionId, Integer top, Integer skip, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/ledgers/connections/{connectionId}/transactions".replaceAll("\\{connectionId\\}", this.apiClient.escapeString(connectionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (top != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("top", top));
        }
        if (skip != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("skip", skip));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call transactionsGetValidateBeforeCall(Integer connectionId, Integer top, Integer skip, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (connectionId == null) {
            throw new ApiException("Missing the required parameter 'connectionId' when calling transactionsGet(Async)");
        }
        Call call = this.transactionsGetCall(connectionId, top, skip, progressListener, progressRequestListener);
        return call;
    }

    public List<TransactionList> transactionsGet(Integer connectionId, Integer top, Integer skip) throws ApiException {
        ApiResponse<List<TransactionList>> resp = this.transactionsGetWithHttpInfo(connectionId, top, skip);
        return resp.getData();
    }

    public ApiResponse<List<TransactionList>> transactionsGetWithHttpInfo(Integer connectionId, Integer top, Integer skip) throws ApiException {
        Call call = this.transactionsGetValidateBeforeCall(connectionId, top, skip, null, null);
        Type localVarReturnType = new TypeToken<List<TransactionList>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call transactionsGetAsync(Integer connectionId, Integer top, Integer skip, final ApiCallback<List<TransactionList>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.transactionsGetValidateBeforeCall(connectionId, top, skip, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<TransactionList>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

