/*
 * Azure Blockchain Workbench REST API
 * The Azure Blockchain Workbench REST API is a Workbench extensibility point, which allows developers to create and manage blockchain applications, manage users and organizations within a consortium, integrate blockchain applications into services and platforms, perform transactions on a blockchain, and retrieve transactional and contract data from a blockchain.
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.ApplicationRole;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

/**
 * Application
 */

public class Application {
  @SerializedName("id")
  private Integer id = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("description")
  private String description = null;

  @SerializedName("displayName")
  private String displayName = null;

  @SerializedName("createdByUserId")
  private Integer createdByUserId = null;

  @SerializedName("createdDtTm")
  private DateTime createdDtTm = null;

  @SerializedName("enabled")
  private Boolean enabled = null;

  @SerializedName("applicationRoles")
  private List<ApplicationRole> applicationRoles = null;

  public Application id(Integer id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(value = "")
  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public Application name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @ApiModelProperty(value = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Application description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @ApiModelProperty(value = "")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Application displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @ApiModelProperty(value = "")
  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public Application createdByUserId(Integer createdByUserId) {
    this.createdByUserId = createdByUserId;
    return this;
  }

   /**
   * Get createdByUserId
   * @return createdByUserId
  **/
  @ApiModelProperty(value = "")
  public Integer getCreatedByUserId() {
    return createdByUserId;
  }

  public void setCreatedByUserId(Integer createdByUserId) {
    this.createdByUserId = createdByUserId;
  }

  public Application createdDtTm(DateTime createdDtTm) {
    this.createdDtTm = createdDtTm;
    return this;
  }

   /**
   * Get createdDtTm
   * @return createdDtTm
  **/
  @ApiModelProperty(value = "")
  public DateTime getCreatedDtTm() {
    return createdDtTm;
  }

  public void setCreatedDtTm(DateTime createdDtTm) {
    this.createdDtTm = createdDtTm;
  }

  public Application enabled(Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

   /**
   * Get enabled
   * @return enabled
  **/
  @ApiModelProperty(value = "")
  public Boolean isEnabled() {
    return enabled;
  }

  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }

  public Application applicationRoles(List<ApplicationRole> applicationRoles) {
    this.applicationRoles = applicationRoles;
    return this;
  }

  public Application addApplicationRolesItem(ApplicationRole applicationRolesItem) {
    if (this.applicationRoles == null) {
      this.applicationRoles = new ArrayList<ApplicationRole>();
    }
    this.applicationRoles.add(applicationRolesItem);
    return this;
  }

   /**
   * Get applicationRoles
   * @return applicationRoles
  **/
  @ApiModelProperty(value = "")
  public List<ApplicationRole> getApplicationRoles() {
    return applicationRoles;
  }

  public void setApplicationRoles(List<ApplicationRole> applicationRoles) {
    this.applicationRoles = applicationRoles;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Application application = (Application) o;
    return Objects.equals(this.id, application.id) &&
        Objects.equals(this.name, application.name) &&
        Objects.equals(this.description, application.description) &&
        Objects.equals(this.displayName, application.displayName) &&
        Objects.equals(this.createdByUserId, application.createdByUserId) &&
        Objects.equals(this.createdDtTm, application.createdDtTm) &&
        Objects.equals(this.enabled, application.enabled) &&
        Objects.equals(this.applicationRoles, application.applicationRoles);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, description, displayName, createdByUserId, createdDtTm, enabled, applicationRoles);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Application {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    createdByUserId: ").append(toIndentedString(createdByUserId)).append("\n");
    sb.append("    createdDtTm: ").append(toIndentedString(createdDtTm)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    applicationRoles: ").append(toIndentedString(applicationRoles)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

