/*
 * Azure Blockchain Workbench REST API
 * The Azure Blockchain Workbench REST API is a Workbench extensibility point, which allows developers to create and manage blockchain applications, manage users and organizations within a consortium, integrate blockchain applications into services and platforms, perform transactions on a blockchain, and retrieve transactional and contract data from a blockchain.
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.api;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.swagger.client.model.Contract;
import io.swagger.client.model.ContractList;
import io.swagger.client.model.LedgerActionOutput;
import io.swagger.client.model.WorkflowActionInput;
import io.swagger.client.model.WorkflowStateTransition;
import io.swagger.client.model.WorkflowStateTransitionList;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContractsApi {
    private ApiClient apiClient;

    public ContractsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ContractsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for contractActionGet
     * @param contractId The id of the contract (required)
     * @param actionId The id of the action (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call contractActionGetCall(Integer contractId, Integer actionId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/contracts/{contractId}/actions/{actionId}"
            .replaceAll("\\{" + "contractId" + "\\}", apiClient.escapeString(contractId.toString()))
            .replaceAll("\\{" + "actionId" + "\\}", apiClient.escapeString(actionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call contractActionGetValidateBeforeCall(Integer contractId, Integer actionId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'contractId' is set
        if (contractId == null) {
            throw new ApiException("Missing the required parameter 'contractId' when calling contractActionGet(Async)");
        }
        
        // verify the required parameter 'actionId' is set
        if (actionId == null) {
            throw new ApiException("Missing the required parameter 'actionId' when calling contractActionGet(Async)");
        }
        

        com.squareup.okhttp.Call call = contractActionGetCall(contractId, actionId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * 
     * Gets the action matching the specified action ID. Users get the action if the user can take the action              given the current state of the specified smart contract instance and the user&#39;s associated application role or smart              contract instance role.
     * @param contractId The id of the contract (required)
     * @param actionId The id of the action (required)
     * @return WorkflowStateTransition
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public WorkflowStateTransition contractActionGet(Integer contractId, Integer actionId) throws ApiException {
        ApiResponse<WorkflowStateTransition> resp = contractActionGetWithHttpInfo(contractId, actionId);
        return resp.getData();
    }

    /**
     * 
     * Gets the action matching the specified action ID. Users get the action if the user can take the action              given the current state of the specified smart contract instance and the user&#39;s associated application role or smart              contract instance role.
     * @param contractId The id of the contract (required)
     * @param actionId The id of the action (required)
     * @return ApiResponse&lt;WorkflowStateTransition&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<WorkflowStateTransition> contractActionGetWithHttpInfo(Integer contractId, Integer actionId) throws ApiException {
        com.squareup.okhttp.Call call = contractActionGetValidateBeforeCall(contractId, actionId, null, null);
        Type localVarReturnType = new TypeToken<WorkflowStateTransition>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Gets the action matching the specified action ID. Users get the action if the user can take the action              given the current state of the specified smart contract instance and the user&#39;s associated application role or smart              contract instance role.
     * @param contractId The id of the contract (required)
     * @param actionId The id of the action (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call contractActionGetAsync(Integer contractId, Integer actionId, final ApiCallback<WorkflowStateTransition> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = contractActionGetValidateBeforeCall(contractId, actionId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WorkflowStateTransition>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for contractActionPost
     * @param contractId The id of the workflow instance (required)
     * @param actionInformation Parameters for a particular action (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call contractActionPostCall(Integer contractId, WorkflowActionInput actionInformation, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = actionInformation;

        // create path and map variables
        String localVarPath = "/api/v1/contracts/{contractId}/actions"
            .replaceAll("\\{" + "contractId" + "\\}", apiClient.escapeString(contractId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call contractActionPostValidateBeforeCall(Integer contractId, WorkflowActionInput actionInformation, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'contractId' is set
        if (contractId == null) {
            throw new ApiException("Missing the required parameter 'contractId' when calling contractActionPost(Async)");
        }
        

        com.squareup.okhttp.Call call = contractActionPostCall(contractId, actionInformation, progressListener, progressRequestListener);
        return call;

    }

    /**
     * 
     * Executes an action for the specified smart contract instance and action ID. Users are only able to execute              the action given the current state of the specified smart contract instance and the user&#39;s associated application role              or smart contract instance role.
     * @param contractId The id of the workflow instance (required)
     * @param actionInformation Parameters for a particular action (optional)
     * @return LedgerActionOutput
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public LedgerActionOutput contractActionPost(Integer contractId, WorkflowActionInput actionInformation) throws ApiException {
        ApiResponse<LedgerActionOutput> resp = contractActionPostWithHttpInfo(contractId, actionInformation);
        return resp.getData();
    }

    /**
     * 
     * Executes an action for the specified smart contract instance and action ID. Users are only able to execute              the action given the current state of the specified smart contract instance and the user&#39;s associated application role              or smart contract instance role.
     * @param contractId The id of the workflow instance (required)
     * @param actionInformation Parameters for a particular action (optional)
     * @return ApiResponse&lt;LedgerActionOutput&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<LedgerActionOutput> contractActionPostWithHttpInfo(Integer contractId, WorkflowActionInput actionInformation) throws ApiException {
        com.squareup.okhttp.Call call = contractActionPostValidateBeforeCall(contractId, actionInformation, null, null);
        Type localVarReturnType = new TypeToken<LedgerActionOutput>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Executes an action for the specified smart contract instance and action ID. Users are only able to execute              the action given the current state of the specified smart contract instance and the user&#39;s associated application role              or smart contract instance role.
     * @param contractId The id of the workflow instance (required)
     * @param actionInformation Parameters for a particular action (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call contractActionPostAsync(Integer contractId, WorkflowActionInput actionInformation, final ApiCallback<LedgerActionOutput> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = contractActionPostValidateBeforeCall(contractId, actionInformation, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LedgerActionOutput>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for contractActionsGet
     * @param contractId The id of the contract (required)
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call contractActionsGetCall(Integer contractId, Integer top, Integer skip, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/contracts/{contractId}/actions"
            .replaceAll("\\{" + "contractId" + "\\}", apiClient.escapeString(contractId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (top != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("top", top));
        if (skip != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("skip", skip));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call contractActionsGetValidateBeforeCall(Integer contractId, Integer top, Integer skip, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'contractId' is set
        if (contractId == null) {
            throw new ApiException("Missing the required parameter 'contractId' when calling contractActionsGet(Async)");
        }
        

        com.squareup.okhttp.Call call = contractActionsGetCall(contractId, top, skip, progressListener, progressRequestListener);
        return call;

    }

    /**
     * 
     * Lists all actions, which can be taken by the given user and current state of the specified smart contract              instance. Users get all applicable actions if the user has an associated application role or is associated with a smart              contract instance role for the current state of the specified smart contract instance.
     * @param contractId The id of the contract (required)
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @return WorkflowStateTransitionList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public WorkflowStateTransitionList contractActionsGet(Integer contractId, Integer top, Integer skip) throws ApiException {
        ApiResponse<WorkflowStateTransitionList> resp = contractActionsGetWithHttpInfo(contractId, top, skip);
        return resp.getData();
    }

    /**
     * 
     * Lists all actions, which can be taken by the given user and current state of the specified smart contract              instance. Users get all applicable actions if the user has an associated application role or is associated with a smart              contract instance role for the current state of the specified smart contract instance.
     * @param contractId The id of the contract (required)
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @return ApiResponse&lt;WorkflowStateTransitionList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<WorkflowStateTransitionList> contractActionsGetWithHttpInfo(Integer contractId, Integer top, Integer skip) throws ApiException {
        com.squareup.okhttp.Call call = contractActionsGetValidateBeforeCall(contractId, top, skip, null, null);
        Type localVarReturnType = new TypeToken<WorkflowStateTransitionList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Lists all actions, which can be taken by the given user and current state of the specified smart contract              instance. Users get all applicable actions if the user has an associated application role or is associated with a smart              contract instance role for the current state of the specified smart contract instance.
     * @param contractId The id of the contract (required)
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call contractActionsGetAsync(Integer contractId, Integer top, Integer skip, final ApiCallback<WorkflowStateTransitionList> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = contractActionsGetValidateBeforeCall(contractId, top, skip, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WorkflowStateTransitionList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for contractGet
     * @param contractId The id of the contract (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call contractGetCall(Integer contractId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/contracts/{contractId}"
            .replaceAll("\\{" + "contractId" + "\\}", apiClient.escapeString(contractId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call contractGetValidateBeforeCall(Integer contractId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'contractId' is set
        if (contractId == null) {
            throw new ApiException("Missing the required parameter 'contractId' when calling contractGet(Async)");
        }
        

        com.squareup.okhttp.Call call = contractGetCall(contractId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * 
     * Creates and deploys a new smart contract instance by adding the instance to the Workbench database and              sending a transaction to the blockchain. This method can only be performed by users who are specified within the              Initiators collection of the workflow within the Workbench application configuration.
     * @param contractId The id of the contract (required)
     * @return Contract
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Contract contractGet(Integer contractId) throws ApiException {
        ApiResponse<Contract> resp = contractGetWithHttpInfo(contractId);
        return resp.getData();
    }

    /**
     * 
     * Creates and deploys a new smart contract instance by adding the instance to the Workbench database and              sending a transaction to the blockchain. This method can only be performed by users who are specified within the              Initiators collection of the workflow within the Workbench application configuration.
     * @param contractId The id of the contract (required)
     * @return ApiResponse&lt;Contract&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Contract> contractGetWithHttpInfo(Integer contractId) throws ApiException {
        com.squareup.okhttp.Call call = contractGetValidateBeforeCall(contractId, null, null);
        Type localVarReturnType = new TypeToken<Contract>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Creates and deploys a new smart contract instance by adding the instance to the Workbench database and              sending a transaction to the blockchain. This method can only be performed by users who are specified within the              Initiators collection of the workflow within the Workbench application configuration.
     * @param contractId The id of the contract (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call contractGetAsync(Integer contractId, final ApiCallback<Contract> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = contractGetValidateBeforeCall(contractId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Contract>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for contractPost
     * @param workflowActionInput The set of all contract action parameters. (optional)
     * @param workflowId The ID of the workflow. (optional)
     * @param contractCodeId The ID of the ledger implementation. (optional)
     * @param connectionId The ID of chain instance running on the ledger. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call contractPostCall(WorkflowActionInput workflowActionInput, Integer workflowId, Integer contractCodeId, Integer connectionId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = workflowActionInput;

        // create path and map variables
        String localVarPath = "/api/v1/contracts";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (workflowId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("workflowId", workflowId));
        if (contractCodeId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("contractCodeId", contractCodeId));
        if (connectionId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("connectionId", connectionId));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call contractPostValidateBeforeCall(WorkflowActionInput workflowActionInput, Integer workflowId, Integer contractCodeId, Integer connectionId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = contractPostCall(workflowActionInput, workflowId, contractCodeId, connectionId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * 
     * Gets the smart contract instance matching a specific workflow instance ID. Users who are Workbench              administrators get the smart contract instance. Non-Workbench administrators get the smart contract instance              if they have at least one associated application role or is associated with the smart contract instance.
     * @param workflowActionInput The set of all contract action parameters. (optional)
     * @param workflowId The ID of the workflow. (optional)
     * @param contractCodeId The ID of the ledger implementation. (optional)
     * @param connectionId The ID of chain instance running on the ledger. (optional)
     * @return WorkflowActionInput
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public WorkflowActionInput contractPost(WorkflowActionInput workflowActionInput, Integer workflowId, Integer contractCodeId, Integer connectionId) throws ApiException {
        ApiResponse<WorkflowActionInput> resp = contractPostWithHttpInfo(workflowActionInput, workflowId, contractCodeId, connectionId);
        return resp.getData();
    }

    /**
     * 
     * Gets the smart contract instance matching a specific workflow instance ID. Users who are Workbench              administrators get the smart contract instance. Non-Workbench administrators get the smart contract instance              if they have at least one associated application role or is associated with the smart contract instance.
     * @param workflowActionInput The set of all contract action parameters. (optional)
     * @param workflowId The ID of the workflow. (optional)
     * @param contractCodeId The ID of the ledger implementation. (optional)
     * @param connectionId The ID of chain instance running on the ledger. (optional)
     * @return ApiResponse&lt;WorkflowActionInput&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<WorkflowActionInput> contractPostWithHttpInfo(WorkflowActionInput workflowActionInput, Integer workflowId, Integer contractCodeId, Integer connectionId) throws ApiException {
        com.squareup.okhttp.Call call = contractPostValidateBeforeCall(workflowActionInput, workflowId, contractCodeId, connectionId, null, null);
        Type localVarReturnType = new TypeToken<WorkflowActionInput>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Gets the smart contract instance matching a specific workflow instance ID. Users who are Workbench              administrators get the smart contract instance. Non-Workbench administrators get the smart contract instance              if they have at least one associated application role or is associated with the smart contract instance.
     * @param workflowActionInput The set of all contract action parameters. (optional)
     * @param workflowId The ID of the workflow. (optional)
     * @param contractCodeId The ID of the ledger implementation. (optional)
     * @param connectionId The ID of chain instance running on the ledger. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call contractPostAsync(WorkflowActionInput workflowActionInput, Integer workflowId, Integer contractCodeId, Integer connectionId, final ApiCallback<WorkflowActionInput> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = contractPostValidateBeforeCall(workflowActionInput, workflowId, contractCodeId, connectionId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WorkflowActionInput>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for contractsGet
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @param workflowId The ID of the associated workflow (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call contractsGetCall(Integer top, Integer skip, Integer workflowId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/contracts";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (top != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("top", top));
        if (skip != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("skip", skip));
        if (workflowId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("workflowId", workflowId));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call contractsGetValidateBeforeCall(Integer top, Integer skip, Integer workflowId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = contractsGetCall(top, skip, workflowId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * 
     * Lists the smart contract instances of the specified workflow. Users who are Workbench administrators get all              smart contract instances. Non-Workbench administrators get all smart contract instances for which they have at least              one associated application role or is associated with a smart contract instance role.
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @param workflowId The ID of the associated workflow (optional)
     * @return ContractList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ContractList contractsGet(Integer top, Integer skip, Integer workflowId) throws ApiException {
        ApiResponse<ContractList> resp = contractsGetWithHttpInfo(top, skip, workflowId);
        return resp.getData();
    }

    /**
     * 
     * Lists the smart contract instances of the specified workflow. Users who are Workbench administrators get all              smart contract instances. Non-Workbench administrators get all smart contract instances for which they have at least              one associated application role or is associated with a smart contract instance role.
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @param workflowId The ID of the associated workflow (optional)
     * @return ApiResponse&lt;ContractList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ContractList> contractsGetWithHttpInfo(Integer top, Integer skip, Integer workflowId) throws ApiException {
        com.squareup.okhttp.Call call = contractsGetValidateBeforeCall(top, skip, workflowId, null, null);
        Type localVarReturnType = new TypeToken<ContractList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Lists the smart contract instances of the specified workflow. Users who are Workbench administrators get all              smart contract instances. Non-Workbench administrators get all smart contract instances for which they have at least              one associated application role or is associated with a smart contract instance role.
     * @param top The maximum number of items to return (optional)
     * @param skip The number of items to skip before returning (optional)
     * @param workflowId The ID of the associated workflow (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call contractsGetAsync(Integer top, Integer skip, Integer workflowId, final ApiCallback<ContractList> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = contractsGetValidateBeforeCall(top, skip, workflowId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContractList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
