/*
 * Azure Blockchain Workbench REST API
 * The Azure Blockchain Workbench REST API is a Workbench extensibility point, which allows developers to create and manage blockchain applications, manage users and organizations within a consortium, integrate blockchain applications into services and platforms, perform transactions on a blockchain, and retrieve transactional and contract data from a blockchain.
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.ContractAction;
import io.swagger.client.model.ContractProperty;
import io.swagger.client.model.Transaction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Contract
 */

public class Contract {
  @SerializedName("id")
  private Integer id = null;

  @SerializedName("provisioningStatus")
  private Integer provisioningStatus = null;

  @SerializedName("connectionID")
  private Integer connectionID = null;

  @SerializedName("ledgerIdentifier")
  private String ledgerIdentifier = null;

  @SerializedName("deployedByUserId")
  private Integer deployedByUserId = null;

  @SerializedName("workflowId")
  private Integer workflowId = null;

  @SerializedName("contractCodeId")
  private Integer contractCodeId = null;

  @SerializedName("contractProperties")
  private List<ContractProperty> contractProperties = null;

  @SerializedName("transactions")
  private List<Transaction> transactions = null;

  @SerializedName("contractActions")
  private List<ContractAction> contractActions = null;

  public Contract id(Integer id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(value = "")
  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public Contract provisioningStatus(Integer provisioningStatus) {
    this.provisioningStatus = provisioningStatus;
    return this;
  }

   /**
   * Get provisioningStatus
   * @return provisioningStatus
  **/
  @ApiModelProperty(value = "")
  public Integer getProvisioningStatus() {
    return provisioningStatus;
  }

  public void setProvisioningStatus(Integer provisioningStatus) {
    this.provisioningStatus = provisioningStatus;
  }

  public Contract connectionID(Integer connectionID) {
    this.connectionID = connectionID;
    return this;
  }

   /**
   * Get connectionID
   * @return connectionID
  **/
  @ApiModelProperty(value = "")
  public Integer getConnectionID() {
    return connectionID;
  }

  public void setConnectionID(Integer connectionID) {
    this.connectionID = connectionID;
  }

  public Contract ledgerIdentifier(String ledgerIdentifier) {
    this.ledgerIdentifier = ledgerIdentifier;
    return this;
  }

   /**
   * Get ledgerIdentifier
   * @return ledgerIdentifier
  **/
  @ApiModelProperty(value = "")
  public String getLedgerIdentifier() {
    return ledgerIdentifier;
  }

  public void setLedgerIdentifier(String ledgerIdentifier) {
    this.ledgerIdentifier = ledgerIdentifier;
  }

  public Contract deployedByUserId(Integer deployedByUserId) {
    this.deployedByUserId = deployedByUserId;
    return this;
  }

   /**
   * Get deployedByUserId
   * @return deployedByUserId
  **/
  @ApiModelProperty(value = "")
  public Integer getDeployedByUserId() {
    return deployedByUserId;
  }

  public void setDeployedByUserId(Integer deployedByUserId) {
    this.deployedByUserId = deployedByUserId;
  }

  public Contract workflowId(Integer workflowId) {
    this.workflowId = workflowId;
    return this;
  }

   /**
   * Get workflowId
   * @return workflowId
  **/
  @ApiModelProperty(value = "")
  public Integer getWorkflowId() {
    return workflowId;
  }

  public void setWorkflowId(Integer workflowId) {
    this.workflowId = workflowId;
  }

  public Contract contractCodeId(Integer contractCodeId) {
    this.contractCodeId = contractCodeId;
    return this;
  }

   /**
   * Get contractCodeId
   * @return contractCodeId
  **/
  @ApiModelProperty(value = "")
  public Integer getContractCodeId() {
    return contractCodeId;
  }

  public void setContractCodeId(Integer contractCodeId) {
    this.contractCodeId = contractCodeId;
  }

  public Contract contractProperties(List<ContractProperty> contractProperties) {
    this.contractProperties = contractProperties;
    return this;
  }

  public Contract addContractPropertiesItem(ContractProperty contractPropertiesItem) {
    if (this.contractProperties == null) {
      this.contractProperties = new ArrayList<ContractProperty>();
    }
    this.contractProperties.add(contractPropertiesItem);
    return this;
  }

   /**
   * Get contractProperties
   * @return contractProperties
  **/
  @ApiModelProperty(value = "")
  public List<ContractProperty> getContractProperties() {
    return contractProperties;
  }

  public void setContractProperties(List<ContractProperty> contractProperties) {
    this.contractProperties = contractProperties;
  }

  public Contract transactions(List<Transaction> transactions) {
    this.transactions = transactions;
    return this;
  }

  public Contract addTransactionsItem(Transaction transactionsItem) {
    if (this.transactions == null) {
      this.transactions = new ArrayList<Transaction>();
    }
    this.transactions.add(transactionsItem);
    return this;
  }

   /**
   * Get transactions
   * @return transactions
  **/
  @ApiModelProperty(value = "")
  public List<Transaction> getTransactions() {
    return transactions;
  }

  public void setTransactions(List<Transaction> transactions) {
    this.transactions = transactions;
  }

  public Contract contractActions(List<ContractAction> contractActions) {
    this.contractActions = contractActions;
    return this;
  }

  public Contract addContractActionsItem(ContractAction contractActionsItem) {
    if (this.contractActions == null) {
      this.contractActions = new ArrayList<ContractAction>();
    }
    this.contractActions.add(contractActionsItem);
    return this;
  }

   /**
   * Get contractActions
   * @return contractActions
  **/
  @ApiModelProperty(value = "")
  public List<ContractAction> getContractActions() {
    return contractActions;
  }

  public void setContractActions(List<ContractAction> contractActions) {
    this.contractActions = contractActions;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Contract contract = (Contract) o;
    return Objects.equals(this.id, contract.id) &&
        Objects.equals(this.provisioningStatus, contract.provisioningStatus) &&
        Objects.equals(this.connectionID, contract.connectionID) &&
        Objects.equals(this.ledgerIdentifier, contract.ledgerIdentifier) &&
        Objects.equals(this.deployedByUserId, contract.deployedByUserId) &&
        Objects.equals(this.workflowId, contract.workflowId) &&
        Objects.equals(this.contractCodeId, contract.contractCodeId) &&
        Objects.equals(this.contractProperties, contract.contractProperties) &&
        Objects.equals(this.transactions, contract.transactions) &&
        Objects.equals(this.contractActions, contract.contractActions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, provisioningStatus, connectionID, ledgerIdentifier, deployedByUserId, workflowId, contractCodeId, contractProperties, transactions, contractActions);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Contract {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    provisioningStatus: ").append(toIndentedString(provisioningStatus)).append("\n");
    sb.append("    connectionID: ").append(toIndentedString(connectionID)).append("\n");
    sb.append("    ledgerIdentifier: ").append(toIndentedString(ledgerIdentifier)).append("\n");
    sb.append("    deployedByUserId: ").append(toIndentedString(deployedByUserId)).append("\n");
    sb.append("    workflowId: ").append(toIndentedString(workflowId)).append("\n");
    sb.append("    contractCodeId: ").append(toIndentedString(contractCodeId)).append("\n");
    sb.append("    contractProperties: ").append(toIndentedString(contractProperties)).append("\n");
    sb.append("    transactions: ").append(toIndentedString(transactions)).append("\n");
    sb.append("    contractActions: ").append(toIndentedString(contractActions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

