import re
import requests

def dnsdumpster(domain, colors):
    if colors:
        run = '\033[1;97m[~]\033[1;m'
    else:
        run = ''
    print ('%s Retrieving DNS related data' % run)
    response = requests.Session().get('https://dnsdumpster.com/').text
    csrf_token = re.search(r"name='csrfmiddlewaretoken' value='(.*?)'", response).group(1)

    cookies = {'csrftoken': csrf_token}
    headers = {'Referer': 'https://dnsdumpster.com/'}
    data = {'csrfmiddlewaretoken': csrf_token, 'targetip': domain}
    response = requests.Session().post('https://dnsdumpster.com/', cookies=cookies, data=data, headers=headers)

    image = requests.get('https://dnsdumpster.com/static/map/%s.png' % domain)
    with open('%s/%s.png' % (domain, domain), 'wb') as f:
        f.write(image.content)
