/*!
* BootstrapValidator (http://bootstrapvalidator.com)
* The best jQuery plugin to validate form fields. Designed to use with Bootstrap 3
*
* @version v0.5.1-dev, built on 2014-07-23 6:05:15 AM
* @author https://twitter.com/nghuuphuoc
* @copyright (c) 2013 - 2014 Nguyen Huu Phuoc
* @license MIT
*/(function($){var BootstrapValidator=function(form,options){this.$form=$(form);this.options=$.extend({},$.fn.bootstrapValidator.DEFAULT_OPTIONS,options);this.$invalidFields=$([]);this.$submitButton=null;this.STATUS_NOT_VALIDATED='NOT_VALIDATED';this.STATUS_VALIDATING='VALIDATING';this.STATUS_INVALID='INVALID';this.STATUS_VALID='VALID';var ieVersion=(function(){var v=3,div=document.createElement('div'),a=div.all||[];while(div.innerHTML='<!--[if gt IE '+(++v)+']><br><![endif]-->',a[0]){}
return v>4?v:!v;}());var el=document.createElement('div');this._changeEvent=(ieVersion===9||!('oninput'in el))?'keyup':'input';this._submitIfValid=null;this._cacheFields={};this._init();};BootstrapValidator.prototype={constructor:BootstrapValidator,_init:function(){var that=this,options={excluded:this.$form.attr('data-bv-excluded'),trigger:this.$form.attr('data-bv-trigger'),message:this.$form.attr('data-bv-message'),container:this.$form.attr('data-bv-container'),group:this.$form.attr('data-bv-group'),submitButtons:this.$form.attr('data-bv-submitbuttons'),threshold:this.$form.attr('data-bv-threshold'),live:this.$form.attr('data-bv-live'),onSuccess:this.$form.attr('data-bv-onsuccess'),onError:this.$form.attr('data-bv-onerror'),fields:{},feedbackIcons:{valid:this.$form.attr('data-bv-feedbackicons-valid'),invalid:this.$form.attr('data-bv-feedbackicons-invalid'),validating:this.$form.attr('data-bv-feedbackicons-validating')}};this.$form.attr('novalidate','novalidate').addClass(this.options.elementClass).on('submit.bv',function(e){e.preventDefault();that.validate();}).on('click.bv',this.options.submitButtons,function(){that.$submitButton=$(this);that._submitIfValid=true;}).find('[name], [data-bv-field]').each(function(){var $field=$(this),field=$field.attr('name')||$field.attr('data-bv-field'),opts=that._parseOptions($field);if(opts){$field.attr('data-bv-field',field);options.fields[field]=$.extend({},opts,options.fields[field]);}});this.options=$.extend(true,this.options,options);for(var field in this.options.fields){this._initField(field);}
this.$form.trigger($.Event('init.form.bv'),{bv:this,options:this.options});if(this.options.onSuccess){this.$form.on('success.form.bv',function(e){$.fn.bootstrapValidator.helpers.call(that.options.onSuccess,[e]);});}
if(this.options.onError){this.$form.on('error.form.bv',function(e){$.fn.bootstrapValidator.helpers.call(that.options.onError,[e]);});}},_parseOptions:function($field){var field=$field.attr('name')||$field.attr('data-bv-field'),validators={},validator,v,enabled,optionName,optionValue,html5AttrName,html5AttrMap;for(v in $.fn.bootstrapValidator.validators){validator=$.fn.bootstrapValidator.validators[v];enabled=$field.attr('data-bv-'+v.toLowerCase())+'';html5AttrMap=('function'===typeof validator.enableByHtml5)?validator.enableByHtml5($field):null;if((html5AttrMap&&enabled!=='false')||(html5AttrMap!==true&&(''===enabled||'true'===enabled)))
{validator.html5Attributes=$.extend({},{message:'message',onerror:'onError',onsuccess:'onSuccess'},validator.html5Attributes);validators[v]=$.extend({},html5AttrMap===true?{}:html5AttrMap,validators[v]);for(html5AttrName in validator.html5Attributes){optionName=validator.html5Attributes[html5AttrName];optionValue=$field.attr('data-bv-'+v.toLowerCase()+'-'+html5AttrName);if(optionValue){if('true'===optionValue){optionValue=true;}else if('false'===optionValue){optionValue=false;}
validators[v][optionName]=optionValue;}}}}
var opts={excluded:$field.attr('data-bv-excluded'),feedbackIcons:$field.attr('data-bv-feedbackicons'),trigger:$field.attr('data-bv-trigger'),message:$field.attr('data-bv-message'),container:$field.attr('data-bv-container'),group:$field.attr('data-bv-group'),selector:$field.attr('data-bv-selector'),threshold:$field.attr('data-bv-threshold'),onStatus:$field.attr('data-bv-onstatus'),onSuccess:$field.attr('data-bv-onsuccess'),onError:$field.attr('data-bv-onerror'),validators:validators},emptyOptions=$.isEmptyObject(opts),emptyValidators=$.isEmptyObject(validators);if(!emptyValidators||(!emptyOptions&&this.options.fields&&this.options.fields[field])){opts.validators=validators;return opts;}else{return null;}},_initField:function(field){var fields=$([]);switch(typeof field){case 'object':fields=field;field=field.attr('data-bv-field');break;case 'string':fields=this.getFieldElements(field);fields.attr('data-bv-field',field);break;default:break;}
if(this.options.fields[field]===null||this.options.fields[field].validators===null){return;}
if(fields.length===0){delete this.options.fields[field];return;}
var validatorName;for(validatorName in this.options.fields[field].validators){if(!$.fn.bootstrapValidator.validators[validatorName]){delete this.options.fields[field].validators[validatorName];}}
if(this.options.fields[field].enabled===null){this.options.fields[field].enabled=true;}
var that=this,total=fields.length,type=fields.attr('type'),updateAll=(total===1)||('radio'===type)||('checkbox'===type),event=('radio'===type||'checkbox'===type||'file'===type||'SELECT'===fields.eq(0).get(0).tagName)?'change':this._changeEvent,trigger=(this.options.fields[field].trigger||this.options.trigger||event).split(' '),events=$.map(trigger,function(item){return item+'.update.bv';}).join(' ');for(var i=0;i<total;i++){var $field=fields.eq(i),group=this.options.fields[field].group||this.options.group,$parent=$field.parents(group),container=this.options.fields[field].container||this.options.container,$message=(container&&container!=='tooltip'&&container!=='popover')?$(container):this._getMessageContainer($field,group);if(container&&container!=='tooltip'&&container!=='popover'){$message.addClass('has-error');}
$message.find('.help-block[data-bv-validator][data-bv-for="'+field+'"]').remove();$parent.find('i[data-bv-icon-for="'+field+'"]').remove();$field.off(events).on(events,function(){that.updateStatus($(this),that.STATUS_NOT_VALIDATED);});$field.data('bv.messages',$message);for(validatorName in this.options.fields[field].validators){$field.data('bv.result.'+validatorName,this.STATUS_NOT_VALIDATED);if(!updateAll||i===total-1){$('<small/>').css('display','none').addClass('help-block').attr('data-bv-validator',validatorName).attr('data-bv-for',field).attr('data-bv-result',this.STATUS_NOT_VALIDATED).html(this._getMessage(field,validatorName)).appendTo($message);}
if(this.options.fields[field].validators[validatorName].onSuccess){$field.on('success.validator.bv',function(e,data){$.fn.bootstrapValidator.helpers.call(that.options.fields[field].validators[validatorName].onSuccess,[e,data]);});}
if(this.options.fields[field].validators[validatorName].onError){$field.on('error.validator.bv',function(e,data){$.fn.bootstrapValidator.helpers.call(that.options.fields[field].validators[validatorName].onError,[e,data]);});}}
if(this.options.fields[field].feedbackIcons!==false&&this.options.fields[field].feedbackIcons!=='false'&&this.options.feedbackIcons&&this.options.feedbackIcons.validating&&this.options.feedbackIcons.invalid&&this.options.feedbackIcons.valid&&(!updateAll||i===total-1))
{$parent.removeClass('has-success').removeClass('has-error').addClass('has-feedback');var $icon=$('<i/>').css('display','none').addClass('form-control-feedback').attr('data-bv-icon-for',field).insertAfter(('checkbox'===type||'radio'===type)?$field.parent():$field);if($parent.find('label').length===0){$icon.css('top',0);}
if($parent.find('.input-group').length!==0){$icon.css({'top':0,'z-index':100}).insertAfter($parent.find('.input-group').eq(0));}}}
if(this.options.fields[field].onSuccess){fields.on('success.field.bv',function(e,data){$.fn.bootstrapValidator.helpers.call(that.options.fields[field].onSuccess,[e,data]);});}
if(this.options.fields[field].onError){fields.on('error.field.bv',function(e,data){$.fn.bootstrapValidator.helpers.call(that.options.fields[field].onError,[e,data]);});}
if(this.options.fields[field].onStatus){fields.on('status.field.bv',function(e,data){$.fn.bootstrapValidator.helpers.call(that.options.fields[field].onStatus,[e,data]);});}
events=$.map(trigger,function(item){return item+'.live.bv';}).join(' ');switch(this.options.live){case 'submitted':break;case 'disabled':fields.off(events);break;case 'enabled':default:fields.off(events).on(events,function(){if(that._exceedThreshold($(this))){that.validateField($(this));}});break;}
fields.trigger($.Event('init.field.bv'),{bv:this,field:field,element:fields});},_getMessage:function(field,validatorName){if(!this.options.fields[field]||!$.fn.bootstrapValidator.validators[validatorName]||!this.options.fields[field].validators||!this.options.fields[field].validators[validatorName])
{return '';}
var options=this.options.fields[field].validators[validatorName];switch(true){case(!!options.message):return options.message;case(!!this.options.fields[field].message):return this.options.fields[field].message;case(!!$.fn.bootstrapValidator.i18n[validatorName]):return $.fn.bootstrapValidator.i18n[validatorName]['default'];default:return this.options.message;}},_getMessageContainer:function($field,group){var $parent=$field.parent();if($parent.is(group)){return $parent;}
var cssClasses=$parent.attr('class');if(!cssClasses){return this._getMessageContainer($parent,group);}
cssClasses=cssClasses.split(' ');var n=cssClasses.length;for(var i=0;i<n;i++){if(/^col-(xs|sm|md|lg)-\d+$/.test(cssClasses[i])||/^col-(xs|sm|md|lg)-offset-\d+$/.test(cssClasses[i])){return $parent;}}
return this._getMessageContainer($parent,group);},_submit:function(){var isValid=this.isValid(),eventType=isValid?'success.form.bv':'error.form.bv',e=$.Event(eventType);this.$form.trigger(e);if(this.$submitButton){isValid?this._onSuccess(e):this._onError(e);}},_isExcluded:function($field){var excludedAttr=$field.attr('data-bv-excluded'),field=$field.attr('data-bv-field')||$field.attr('name');switch(true){case(!!field&&this.options.fields&&this.options.fields[field]&&(this.options.fields[field].excluded==='true'||this.options.fields[field].excluded===true)):case(excludedAttr==='true'):case(excludedAttr===''):return true;case(!!field&&this.options.fields&&this.options.fields[field]&&(this.options.fields[field].excluded==='false'||this.options.fields[field].excluded===false)):case(excludedAttr==='false'):return false;default:if(this.options.excluded){if('string'===typeof this.options.excluded){this.options.excluded=$.map(this.options.excluded.split(','),function(item){return $.trim(item);});}
var length=this.options.excluded.length;for(var i=0;i<length;i++){if(('string'===typeof this.options.excluded[i]&&$field.is(this.options.excluded[i]))||('function'===typeof this.options.excluded[i]&&this.options.excluded[i].call(this,$field,this)===true))
{return true;}}}
return false;}},_exceedThreshold:function($field){var field=$field.attr('data-bv-field'),threshold=this.options.fields[field].threshold||this.options.threshold;if(!threshold){return true;}
var cannotType=$.inArray($field.attr('type'),['button','checkbox','file','hidden','image','radio','reset','submit'])!==-1;return(cannotType||$field.val().length>=threshold);},_onError:function(e){if(e.isDefaultPrevented()){return;}
if('submitted'===this.options.live){this.options.live='enabled';var that=this;for(var field in this.options.fields){(function(f){var fields=that.getFieldElements(f);if(fields.length){var type=$(fields[0]).attr('type'),event=('radio'===type||'checkbox'===type||'file'===type||'SELECT'===$(fields[0]).get(0).tagName)?'change':that._changeEvent,trigger=that.options.fields[field].trigger||that.options.trigger||event,events=$.map(trigger.split(' '),function(item){return item+'.live.bv';}).join(' ');fields.off(events).on(events,function(){if(that._exceedThreshold($(this))){that.validateField($(this));}});}})(field);}}
var $invalidField=this.$invalidFields.eq(0);if($invalidField){var $tabPane=$invalidField.parents('.tab-pane'),tabId;if($tabPane&&(tabId=$tabPane.attr('id'))){$('a[href="#'+tabId+'"][data-toggle="tab"]').tab('show');}
$invalidField.focus();}},_onSuccess:function(e){if(e.isDefaultPrevented()){return;}
this.disableSubmitButtons(true).defaultSubmit();},_onFieldValidated:function($field,validatorName){var field=$field.attr('data-bv-field'),validators=this.options.fields[field].validators,counter={},numValidators=0,data={bv:this,field:field,element:$field,validator:validatorName};if(validatorName){switch($field.data('bv.result.'+validatorName)){case this.STATUS_INVALID:$field.trigger($.Event('error.validator.bv'),data);break;case this.STATUS_VALID:$field.trigger($.Event('success.validator.bv'),data);break;default:break;}}
counter[this.STATUS_NOT_VALIDATED]=0;counter[this.STATUS_VALIDATING]=0;counter[this.STATUS_INVALID]=0;counter[this.STATUS_VALID]=0;for(var v in validators){if(validators[v].enabled===false){continue;}
numValidators++;var result=$field.data('bv.result.'+v);if(result){counter[result]++;}}
if(counter[this.STATUS_VALID]===numValidators){this.$invalidFields=this.$invalidFields.not($field);$field.trigger($.Event('success.field.bv'),data);}
else if(counter[this.STATUS_NOT_VALIDATED]===0&&counter[this.STATUS_VALIDATING]===0&&counter[this.STATUS_INVALID]>0){this.$invalidFields=this.$invalidFields.add($field);$field.trigger($.Event('error.field.bv'),data);}},getFieldElements:function(field){if(!this._cacheFields[field]){this._cacheFields[field]=(this.options.fields[field]&&this.options.fields[field].selector)?$(this.options.fields[field].selector):this.$form.find('[name="'+field+'"]');}
return this._cacheFields[field];},disableSubmitButtons:function(disabled){if(!disabled){this.$form.find(this.options.submitButtons).removeAttr('disabled');}else if(this.options.live!=='disabled'){this.$form.find(this.options.submitButtons).attr('disabled','disabled');}
return this;},validate:function(){if(!this.options.fields){return this;}
this.disableSubmitButtons(true);for(var field in this.options.fields){this.validateField(field);}
this._submit();return this;},validateField:function(field){var fields=$([]);switch(typeof field){case 'object':fields=field;field=field.attr('data-bv-field');break;case 'string':fields=this.getFieldElements(field);break;default:break;}
if(this.options.fields[field]&&this.options.fields[field].enabled===false){return this;}
var that=this,type=fields.attr('type'),total=('radio'===type||'checkbox'===type)?1:fields.length,updateAll=('radio'===type||'checkbox'===type),validators=this.options.fields[field].validators,validatorName,validateResult;for(var i=0;i<total;i++){var $field=fields.eq(i);if(this._isExcluded($field)){continue;}
for(validatorName in validators){if($field.data('bv.dfs.'+validatorName)){$field.data('bv.dfs.'+validatorName).reject();}
var result=$field.data('bv.result.'+validatorName);if(result===this.STATUS_VALID||result===this.STATUS_INVALID||validators[validatorName].enabled===false){this._onFieldValidated($field,validatorName);continue;}
$field.data('bv.result.'+validatorName,this.STATUS_VALIDATING);validateResult=$.fn.bootstrapValidator.validators[validatorName].validate(this,$field,validators[validatorName]);if('object'===typeof validateResult&&validateResult.resolve){this.updateStatus(updateAll?field:$field,this.STATUS_VALIDATING,validatorName);$field.data('bv.dfs.'+validatorName,validateResult);validateResult.done(function($f,v,isValid,message){$f.removeData('bv.dfs.'+v);if(message){that.updateMessage($f,v,message);}
that.updateStatus(updateAll?$f.attr('data-bv-field'):$f,isValid?that.STATUS_VALID:that.STATUS_INVALID,v);if(isValid&&that._submitIfValid===true){that._submit();}});}
else if('object'===typeof validateResult&&validateResult.valid!==undefined&&validateResult.message!==undefined){this.updateMessage(updateAll?field:$field,validatorName,validateResult.message);this.updateStatus(updateAll?field:$field,validateResult.valid?this.STATUS_VALID:this.STATUS_INVALID,validatorName);}
else if('boolean'===typeof validateResult){this.updateStatus(updateAll?field:$field,validateResult?this.STATUS_VALID:this.STATUS_INVALID,validatorName);}}}
return this;},updateMessage:function(field,validator,message){var $fields=$([]);switch(typeof field){case 'object':$fields=field;field=field.attr('data-bv-field');break;case 'string':$fields=this.getFieldElements(field);break;default:break;}
$fields.each(function(){$(this).data('bv.messages').find('.help-block[data-bv-validator="'+validator+'"][data-bv-for="'+field+'"]').html(message);});},updateStatus:function(field,status,validatorName){var fields=$([]);switch(typeof field){case 'object':fields=field;field=field.attr('data-bv-field');break;case 'string':fields=this.getFieldElements(field);break;default:break;}
if(status===this.STATUS_NOT_VALIDATED){this._submitIfValid=false;}
var that=this,type=fields.attr('type'),group=this.options.fields[field].group||this.options.group,total=('radio'===type||'checkbox'===type)?1:fields.length;for(var i=0;i<total;i++){var $field=fields.eq(i);if(this._isExcluded($field)){continue;}
var $parent=$field.parents(group),$message=$field.data('bv.messages'),$allErrors=$message.find('.help-block[data-bv-validator][data-bv-for="'+field+'"]'),$errors=validatorName?$allErrors.filter('[data-bv-validator="'+validatorName+'"]'):$allErrors,$icon=$parent.find('.form-control-feedback[data-bv-icon-for="'+field+'"]'),container=this.options.fields[field].container||this.options.container,isValidField=null;if(validatorName){$field.data('bv.result.'+validatorName,status);}else{for(var v in this.options.fields[field].validators){$field.data('bv.result.'+v,status);}}
$errors.attr('data-bv-result',status);var $tabPane=$field.parents('.tab-pane'),tabId,$tab;if($tabPane&&(tabId=$tabPane.attr('id'))){$tab=$('a[href="#'+tabId+'"][data-toggle="tab"]').parent();}
switch(status){case this.STATUS_VALIDATING:isValidField=null;this.disableSubmitButtons(true);$parent.removeClass('has-success').removeClass('has-error');if($icon){$icon.removeClass(this.options.feedbackIcons.valid).removeClass(this.options.feedbackIcons.invalid).addClass(this.options.feedbackIcons.validating).show();}
if($tab){$tab.removeClass('bv-tab-success').removeClass('bv-tab-error');}
break;case this.STATUS_INVALID:isValidField=false;this.disableSubmitButtons(true);$parent.removeClass('has-success').addClass('has-error');if($icon){$icon.removeClass(this.options.feedbackIcons.valid).removeClass(this.options.feedbackIcons.validating).addClass(this.options.feedbackIcons.invalid).show();}
if($tab){$tab.removeClass('bv-tab-success').addClass('bv-tab-error');}
break;case this.STATUS_VALID:isValidField=($allErrors.filter('[data-bv-result="'+this.STATUS_NOT_VALIDATED+'"]').length===0)?($allErrors.filter('[data-bv-result="'+this.STATUS_VALID+'"]').length===$allErrors.length):null;if(isValidField!==null){this.disableSubmitButtons(this.$submitButton?!this.isValid():!isValidField);if($icon){$icon.removeClass(this.options.feedbackIcons.invalid).removeClass(this.options.feedbackIcons.validating).removeClass(this.options.feedbackIcons.valid).addClass(isValidField?this.options.feedbackIcons.valid:this.options.feedbackIcons.invalid).show();}}
$parent.removeClass('has-error has-success').addClass(this.isValidContainer($parent)?'has-success':'has-error');if($tab){$tab.removeClass('bv-tab-success').removeClass('bv-tab-error').addClass(this.isValidContainer($tabPane)?'bv-tab-success':'bv-tab-error');}
break;case this.STATUS_NOT_VALIDATED:default:isValidField=null;this.disableSubmitButtons(false);$parent.removeClass('has-success').removeClass('has-error');if($icon){$icon.removeClass(this.options.feedbackIcons.valid).removeClass(this.options.feedbackIcons.invalid).removeClass(this.options.feedbackIcons.validating).hide();}
if($tab){$tab.removeClass('bv-tab-success').removeClass('bv-tab-error');}
break;}
switch(true){case($icon&&'tooltip'===container):(isValidField===false)?$icon.css('cursor','pointer').tooltip('destroy').tooltip({html:true,placement:'top',title:$allErrors.filter('[data-bv-result="'+that.STATUS_INVALID+'"]').eq(0).html()}):$icon.css('cursor','').tooltip('destroy');break;case($icon&&'popover'===container):(isValidField===false)?$icon.css('cursor','pointer').popover('destroy').popover({content:$allErrors.filter('[data-bv-result="'+that.STATUS_INVALID+'"]').eq(0).html(),html:true,placement:'top',trigger:'hover click'}):$icon.css('cursor','').popover('destroy');break;default:(status===this.STATUS_INVALID)?$errors.show():$errors.hide();break;}
$field.trigger($.Event('status.field.bv'),{bv:this,field:field,element:$field,status:status});this._onFieldValidated($field,validatorName);}
return this;},isValid:function(){for(var field in this.options.fields){if(!this.isValidField(field)){return false;}}
return true;},isValidField:function(field){var fields=$([]);switch(typeof field){case 'object':fields=field;field=field.attr('data-bv-field');break;case 'string':fields=this.getFieldElements(field);break;default:break;}
if(fields.length===0||this.options.fields[field]===null||this.options.fields[field].enabled===false){return true;}
var type=fields.attr('type'),total=('radio'===type||'checkbox'===type)?1:fields.length,$field,validatorName,status;for(var i=0;i<total;i++){$field=fields.eq(i);if(this._isExcluded($field)){continue;}
for(validatorName in this.options.fields[field].validators){if(this.options.fields[field].validators[validatorName].enabled===false){continue;}
status=$field.data('bv.result.'+validatorName);if(status!==this.STATUS_VALID){return false;}}}
return true;},isValidContainer:function(container){var that=this,map={},$container=('string'===typeof container)?$(container):container;if($container.length===0){return true;}
$container.find('[data-bv-field]').each(function(){var $field=$(this),field=$field.attr('data-bv-field');if(!that._isExcluded($field)&&!map[field]){map[field]=$field;}});for(var field in map){var $f=map[field];if($f.data('bv.messages').find('.help-block[data-bv-validator][data-bv-for="'+field+'"]').filter(function(){var v=$(this).attr('data-bv-validator'),f=$(this).attr('data-bv-for');return(that.options.fields[f].validators[v].enabled!==false&&$f.data('bv.result.'+v)&&$f.data('bv.result.'+v)!==that.STATUS_VALID);}).length!==0)
{return false;}}
return true;},defaultSubmit:function(){if(this.$submitButton){$('<input/>').attr('type','hidden').attr('data-bv-submit-hidden','').attr('name',this.$submitButton.attr('name')).val(this.$submitButton.val()).appendTo(this.$form);}
this.$form.off('submit.bv').submit();},getInvalidFields:function(){return this.$invalidFields;},getSubmitButton:function(){return this.$submitButton;},getMessages:function(field,validator){var that=this,messages=[],$fields=$([]);switch(true){case(field&&'object'===typeof field):$fields=field;break;case(field&&'string'===typeof field):var f=this.getFieldElements(field);if(f.length>0){var type=f.attr('type');$fields=('radio'===type||'checkbox'===type)?f.eq(0):f;}
break;default:$fields=this.$invalidFields;break;}
var filter=validator?'[data-bv-validator="'+validator+'"]':'';$fields.each(function(){messages=messages.concat($(this).data('bv.messages').find('.help-block[data-bv-for="'+$(this).attr('data-bv-field')+'"][data-bv-result="'+that.STATUS_INVALID+'"]'+filter).map(function(){var v=$(this).attr('data-bv-validator'),f=$(this).attr('data-bv-for');return(that.options.fields[f].validators[v].enabled===false)?'':$(this).html();}).get());});return messages;},getOptions:function(field,validator,option){if(!field){return this.options;}
if('object'===typeof field){field=field.attr('data-bv-field');}
if(!this.options.fields[field]){return null;}
var options=this.options.fields[field];if(!validator){return options;}
if(!options.validators||!options.validators[validator]){return null;}
return option?options.validators[validator][option]:options.validators[validator];},updateOption:function(field,validator,option,value){if('object'===typeof field){field=field.attr('data-bv-field');}
if(this.options.fields[field]&&this.options.fields[field].validators[validator]){this.options.fields[field].validators[validator][option]=value;this.updateStatus(field,this.STATUS_NOT_VALIDATED,validator);}
return this;},addField:function(field,options){var fields=$([]);switch(typeof field){case 'object':fields=field;field=field.attr('data-bv-field')||field.attr('name');break;case 'string':delete this._cacheFields[field];fields=this.getFieldElements(field);break;default:break;}
fields.attr('data-bv-field',field);var type=fields.attr('type'),total=('radio'===type||'checkbox'===type)?1:fields.length;for(var i=0;i<total;i++){var $field=fields.eq(i);var opts=this._parseOptions($field);opts=(opts===null)?options:$.extend(true,options,opts);this.options.fields[field]=$.extend(true,this.options.fields[field],opts);this._cacheFields[field]=this._cacheFields[field]?this._cacheFields[field].add($field):$field;this._initField(('checkbox'===type||'radio'===type)?field:$field);}
this.disableSubmitButtons(false);this.$form.trigger($.Event('added.field.bv'),{field:field,element:fields,options:this.options.fields[field]});return this;},removeField:function(field){var fields=$([]);switch(typeof field){case 'object':fields=field;field=field.attr('data-bv-field')||field.attr('name');fields.attr('data-bv-field',field);break;case 'string':fields=this.getFieldElements(field);break;default:break;}
if(fields.length===0){return this;}
var type=fields.attr('type'),total=('radio'===type||'checkbox'===type)?1:fields.length;for(var i=0;i<total;i++){var $field=fields.eq(i);this.$invalidFields=this.$invalidFields.not($field);this._cacheFields[field]=this._cacheFields[field].not($field);}
if(!this._cacheFields[field]||this._cacheFields[field].length===0){delete this.options.fields[field];}
if('checkbox'===type||'radio'===type){this._initField(field);}
this.disableSubmitButtons(false);this.$form.trigger($.Event('removed.field.bv'),{field:field,element:fields});return this;},resetField:function(field,resetValue){var $fields=$([]);switch(typeof field){case 'object':$fields=field;field=field.attr('data-bv-field');break;case 'string':$fields=this.getFieldElements(field);break;default:break;}
var total=$fields.length;if(this.options.fields[field]){for(var i=0;i<total;i++){for(var validator in this.options.fields[field].validators){$fields.eq(i).removeData('bv.dfs.'+validator);}}}
this.updateStatus(field,this.STATUS_NOT_VALIDATED);if(resetValue){var type=$fields.attr('type');('radio'===type||'checkbox'===type)?$fields.removeAttr('checked').removeAttr('selected'):$fields.val('');}
return this;},resetForm:function(resetValue){for(var field in this.options.fields){this.resetField(field,resetValue);}
this.$invalidFields=$([]);this.$submitButton=null;this.disableSubmitButtons(false);return this;},revalidateField:function(field){this.updateStatus(field,this.STATUS_NOT_VALIDATED).validateField(field);return this;},enableFieldValidators:function(field,enabled,validatorName){var validators=this.options.fields[field].validators;if(validatorName&&validators&&validators[validatorName]&&validators[validatorName].enabled!==enabled)
{this.options.fields[field].validators[validatorName].enabled=enabled;this.updateStatus(field,this.STATUS_NOT_VALIDATED,validatorName);}
else if(!validatorName&&this.options.fields[field].enabled!==enabled){this.options.fields[field].enabled=enabled;for(var v in validators){this.enableFieldValidators(field,enabled,v);}}
return this;},getDynamicOption:function(field,option){var $field=('string'===typeof field)?this.getFieldElements(field):field,value=$field.val();if('function'===typeof option){return $.fn.bootstrapValidator.helpers.call(option,[value,this,$field]);}
else if('string'===typeof option){var $f=this.getFieldElements(option);if($f.length){return $f.val();}
else{return $.fn.bootstrapValidator.helpers.call(option,[value,this,$field]);}}
return null;},destroy:function(){var field,fields,$field,validator,$icon,container,group;for(field in this.options.fields){fields=this.getFieldElements(field);container=this.options.fields[field].container||this.options.container,group=this.options.fields[field].group||this.options.group;for(var i=0;i<fields.length;i++){$field=fields.eq(i);$field.data('bv.messages').find('.help-block[data-bv-validator][data-bv-for="'+field+'"]').remove().end().end().removeData('bv.messages').parents(group).removeClass('has-feedback has-error has-success').end().off('.bv').removeAttr('data-bv-field');$icon=$field.parents(group).find('i[data-bv-icon-for="'+field+'"]');if($icon){switch(container){case 'tooltip':$icon.tooltip('destroy').remove();break;case 'popover':$icon.popover('destroy').remove();break;default:$icon.remove();break;}}
for(validator in this.options.fields[field].validators){if($field.data('bv.dfs.'+validator)){$field.data('bv.dfs.'+validator).reject();}
$field.removeData('bv.result.'+validator).removeData('bv.dfs.'+validator);}}}
this.disableSubmitButtons(false);this.$form.removeClass(this.options.elementClass).off('.bv').removeData('bootstrapValidator').find('[data-bv-submit-hidden]').remove();}};$.fn.bootstrapValidator=function(option){var params=arguments;return this.each(function(){var $this=$(this),data=$this.data('bootstrapValidator'),options='object'===typeof option&&option;if(!data){data=new BootstrapValidator(this,options);$this.data('bootstrapValidator',data);}
if('string'===typeof option){data[option].apply(data,Array.prototype.slice.call(params,1));}});};$.fn.bootstrapValidator.DEFAULT_OPTIONS={elementClass:'bv-form',message:'This value is not valid',group:'.form-group',container:null,threshold:null,excluded:[':disabled',':hidden',':not(:visible)'],feedbackIcons:{valid:null,invalid:null,validating:null},submitButtons:'[type="submit"]',live:'enabled',fields:null};$.fn.bootstrapValidator.validators={};$.fn.bootstrapValidator.i18n={};$.fn.bootstrapValidator.Constructor=BootstrapValidator;$.fn.bootstrapValidator.helpers={call:function(functionName,args){if('function'===typeof functionName){return functionName.apply(this,args);}else if('string'===typeof functionName){if('()'===functionName.substring(functionName.length-2)){functionName=functionName.substring(0,functionName.length-2);}
var ns=functionName.split('.'),func=ns.pop(),context=window;for(var i=0;i<ns.length;i++){context=context[ns[i]];}
return context[func].apply(this,args);}},format:function(message,parameters){if(!$.isArray(parameters)){parameters=[parameters];}
for(var i in parameters){message=message.replace('%s',parameters[i]);}
return message;},date:function(year,month,day,notInFuture){if(isNaN(year)||isNaN(month)||isNaN(day)){return false;}
day=parseInt(day,10);month=parseInt(month,10);year=parseInt(year,10);if(year<1000||year>9999||month<=0||month>12){return false;}
var numDays=[31,28,31,30,31,30,31,31,30,31,30,31];if(year%400===0||(year%100!==0&&year%4===0)){numDays[1]=29;}
if(day<=0||day>numDays[month-1]){return false;}
if(notInFuture===true){var currentDate=new Date(),currentYear=currentDate.getFullYear(),currentMonth=currentDate.getMonth(),currentDay=currentDate.getDate();return(year<currentYear||(year===currentYear&&month-1<currentMonth)||(year===currentYear&&month-1===currentMonth&&day<currentDay));}
return true;},luhn:function(value){var length=value.length,mul=0,prodArr=[[0,1,2,3,4,5,6,7,8,9],[0,2,4,6,8,1,3,5,7,9]],sum=0;while(length--){sum+=prodArr[mul][parseInt(value.charAt(length),10)];mul^=1;}
return(sum%10===0&&sum>0);},mod11And10:function(value){var check=5,length=value.length;for(var i=0;i<length;i++){check=(((check||10)*2)%11+parseInt(value.charAt(i),10))%10;}
return(check===1);},mod37And36:function(value,alphabet){alphabet=alphabet||'0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';var modulus=alphabet.length,length=value.length,check=Math.floor(modulus/2);for(var i=0;i<length;i++){check=(((check||modulus)*2)%(modulus+1)+alphabet.indexOf(value.charAt(i)))%modulus;}
return(check===1);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.base64=$.extend($.fn.bootstrapValidator.i18n.base64||{},{'default':'Please enter a valid base 64 encoded'});$.fn.bootstrapValidator.validators.base64={validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
return /^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$/.test(value);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.between=$.extend($.fn.bootstrapValidator.i18n.between||{},{'default':'Please enter a value between %s and %s',notInclusive:'Please enter a value between %s and %s strictly'});$.fn.bootstrapValidator.validators.between={html5Attributes:{message:'message',min:'min',max:'max',inclusive:'inclusive'},enableByHtml5:function($field){if('range'===$field.attr('type')){return{min:$field.attr('min'),max:$field.attr('max')};}
return false;},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var min=$.isNumeric(options.min)?options.min:validator.getDynamicOption($field,options.min),max=$.isNumeric(options.max)?options.max:validator.getDynamicOption($field,options.max);value=parseFloat(value);return(options.inclusive===true||options.inclusive===undefined)?{valid:value>=min&&value<=max,message:$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.between['default'],[min,max])}:{valid:value>min&&value<max,message:$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.between.notInclusive,[min,max])};}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.callback=$.extend($.fn.bootstrapValidator.i18n.callback||{},{'default':'Please enter a valid value'});$.fn.bootstrapValidator.validators.callback={html5Attributes:{message:'message',callback:'callback'},validate:function(validator,$field,options){var value=$field.val();if(options.callback){var dfd=new $.Deferred(),response=$.fn.bootstrapValidator.helpers.call(options.callback,[value,validator,$field]);dfd.resolve($field,'callback','boolean'===typeof response?response:response.valid,'object'===typeof response&&response.message?response.message:null);return dfd;}
return true;}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.choice=$.extend($.fn.bootstrapValidator.i18n.choice||{},{'default':'Please enter a valid value',less:'Please choose %s options at minimum',more:'Please choose %s options at maximum',between:'Please choose %s - %s options'});$.fn.bootstrapValidator.validators.choice={html5Attributes:{message:'message',min:'min',max:'max'},validate:function(validator,$field,options){var numChoices=$field.is('select')?validator.getFieldElements($field.attr('data-bv-field')).find('option').filter(':selected').length:validator.getFieldElements($field.attr('data-bv-field')).filter(':checked').length,min=options.min?($.isNumeric(options.min)?options.min:validator.getDynamicOption($field,options.min)):null,max=options.max?($.isNumeric(options.max)?options.max:validator.getDynamicOption($field,options.max)):null,isValid=true,message=options.message||$.fn.bootstrapValidator.i18n.choice['default'];if((min&&numChoices<parseInt(min,10))||(max&&numChoices>parseInt(max,10))){isValid=false;}
switch(true){case(!!min&&!!max):message=$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.choice.between,[parseInt(min,10),parseInt(max,10)]);break;case(!!min):message=$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.choice.less,parseInt(min,10));break;case(!!max):message=$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.choice.more,parseInt(max,10));break;default:break;}
return{valid:isValid,message:message};}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.creditCard=$.extend($.fn.bootstrapValidator.i18n.creditCard||{},{'default':'Please enter a valid credit card number'});$.fn.bootstrapValidator.validators.creditCard={validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
if(/[^0-9-\s]+/.test(value)){return false;}
value=value.replace(/\D/g,'');if(!$.fn.bootstrapValidator.helpers.luhn(value)){return false;}
var cards={AMERICAN_EXPRESS:{length:[15],prefix:['34','37']},DINERS_CLUB:{length:[14],prefix:['300','301','302','303','304','305','36']},DINERS_CLUB_US:{length:[16],prefix:['54','55']},DISCOVER:{length:[16],prefix:['6011','622126','622127','622128','622129','62213','62214','62215','62216','62217','62218','62219','6222','6223','6224','6225','6226','6227','6228','62290','62291','622920','622921','622922','622923','622924','622925','644','645','646','647','648','649','65']},JCB:{length:[16],prefix:['3528','3529','353','354','355','356','357','358']},LASER:{length:[16,17,18,19],prefix:['6304','6706','6771','6709']},MAESTRO:{length:[12,13,14,15,16,17,18,19],prefix:['5018','5020','5038','6304','6759','6761','6762','6763','6764','6765','6766']},MASTERCARD:{length:[16],prefix:['51','52','53','54','55']},SOLO:{length:[16,18,19],prefix:['6334','6767']},UNIONPAY:{length:[16,17,18,19],prefix:['622126','622127','622128','622129','62213','62214','62215','62216','62217','62218','62219','6222','6223','6224','6225','6226','6227','6228','62290','62291','622920','622921','622922','622923','622924','622925']},VISA:{length:[16],prefix:['4']}};var type,i;for(type in cards){for(i in cards[type].prefix){if(value.substr(0,cards[type].prefix[i].length)===cards[type].prefix[i]&&$.inArray(value.length,cards[type].length)!==-1)
{return true;}}}
return false;}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.cusip=$.extend($.fn.bootstrapValidator.i18n.cusip||{},{'default':'Please enter a valid CUSIP number'});$.fn.bootstrapValidator.validators.cusip={validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
value=value.toUpperCase();if(!/^[0-9A-Z]{9}$/.test(value)){return false;}
var converted=$.map(value.split(''),function(item){var code=item.charCodeAt(0);return(code>='A'.charCodeAt(0)&&code<='Z'.charCodeAt(0))?(code-'A'.charCodeAt(0)+10):item;}),length=converted.length,sum=0;for(var i=0;i<length-1;i++){var num=parseInt(converted[i],10);if(i%2!==0){num*=2;}
if(num>9){num-=9;}
sum+=num;}
sum=(10-(sum%10))%10;return sum===converted[length-1];}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.cvv=$.extend($.fn.bootstrapValidator.i18n.cvv||{},{'default':'Please enter a valid CVV number'});$.fn.bootstrapValidator.validators.cvv={html5Attributes:{message:'message',ccfield:'creditCardField'},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
if(!/^[0-9]{3,4}$/.test(value)){return false;}
if(!options.creditCardField){return true;}
var creditCard=validator.getFieldElements(options.creditCardField).val();if(creditCard===''){return true;}
creditCard=creditCard.replace(/\D/g,'');var cards={AMERICAN_EXPRESS:{length:[15],prefix:['34','37']},DINERS_CLUB:{length:[14],prefix:['300','301','302','303','304','305','36']},DINERS_CLUB_US:{length:[16],prefix:['54','55']},DISCOVER:{length:[16],prefix:['6011','622126','622127','622128','622129','62213','62214','62215','62216','62217','62218','62219','6222','6223','6224','6225','6226','6227','6228','62290','62291','622920','622921','622922','622923','622924','622925','644','645','646','647','648','649','65']},JCB:{length:[16],prefix:['3528','3529','353','354','355','356','357','358']},LASER:{length:[16,17,18,19],prefix:['6304','6706','6771','6709']},MAESTRO:{length:[12,13,14,15,16,17,18,19],prefix:['5018','5020','5038','6304','6759','6761','6762','6763','6764','6765','6766']},MASTERCARD:{length:[16],prefix:['51','52','53','54','55']},SOLO:{length:[16,18,19],prefix:['6334','6767']},UNIONPAY:{length:[16,17,18,19],prefix:['622126','622127','622128','622129','62213','62214','62215','62216','62217','62218','62219','6222','6223','6224','6225','6226','6227','6228','62290','62291','622920','622921','622922','622923','622924','622925']},VISA:{length:[16],prefix:['4']}};var type,i,creditCardType=null;for(type in cards){for(i in cards[type].prefix){if(creditCard.substr(0,cards[type].prefix[i].length)===cards[type].prefix[i]&&$.inArray(creditCard.length,cards[type].length)!==-1)
{creditCardType=type;break;}}}
return(creditCardType===null)?false:(('AMERICAN_EXPRESS'===creditCardType)?(value.length===4):(value.length===3));}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.date=$.extend($.fn.bootstrapValidator.i18n.date||{},{'default':'Please enter a valid date'});$.fn.bootstrapValidator.validators.date={html5Attributes:{message:'message',format:'format',separator:'separator'},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
options.format=options.format||'MM/DD/YYYY';var formats=options.format.split(' '),dateFormat=formats[0],timeFormat=(formats.length>1)?formats[1]:null,amOrPm=(formats.length>2)?formats[2]:null,sections=value.split(' '),date=sections[0],time=(sections.length>1)?sections[1]:null;if(formats.length!==sections.length){return false;}
var separator=options.separator;if(!separator){separator=(date.indexOf('/')!==-1)?'/':((date.indexOf('-')!==-1)?'-':null);}
if(separator===null||date.indexOf(separator)===-1){return false;}
date=date.split(separator);dateFormat=dateFormat.split(separator);if(date.length!==dateFormat.length){return false;}
var year=date[$.inArray('YYYY',dateFormat)],month=date[$.inArray('MM',dateFormat)],day=date[$.inArray('DD',dateFormat)];if(!year||!month||!day){return false;}
var minutes=null,hours=null,seconds=null;if(timeFormat){timeFormat=timeFormat.split(':');time=time.split(':');if(timeFormat.length!==time.length){return false;}
hours=time.length>0?time[0]:null;minutes=time.length>1?time[1]:null;seconds=time.length>2?time[2]:null;if(seconds){seconds=parseInt(seconds,10);if(isNaN(seconds)||seconds<0||seconds>60){return false;}}
if(hours){hours=parseInt(hours,10);if(isNaN(hours)||hours<0||hours>=24||(amOrPm&&hours>12)){return false;}}
if(minutes){minutes=parseInt(minutes,10);if(isNaN(minutes)||minutes<0||minutes>59){return false;}}}
return $.fn.bootstrapValidator.helpers.date(year,month,day);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.different=$.extend($.fn.bootstrapValidator.i18n.different||{},{'default':'Please enter a different value'});$.fn.bootstrapValidator.validators.different={html5Attributes:{message:'message',field:'field'},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var compareWith=validator.getFieldElements(options.field);if(compareWith===null){return true;}
if(value!==compareWith.val()){validator.updateStatus(options.field,validator.STATUS_VALID,'different');return true;}else{return false;}}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.digits=$.extend($.fn.bootstrapValidator.i18n.digits||{},{'default':'Please enter only digits'});$.fn.bootstrapValidator.validators.digits={validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
return /^\d+$/.test(value);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.ean=$.extend($.fn.bootstrapValidator.i18n.ean||{},{'default':'Please enter a valid EAN number'});$.fn.bootstrapValidator.validators.ean={validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
if(!/^(\d{8}|\d{12}|\d{13})$/.test(value)){return false;}
var length=value.length,sum=0,weight=(length===8)?[3,1]:[1,3];for(var i=0;i<length-1;i++){sum+=parseInt(value.charAt(i),10)*weight[i%2];}
sum=(10-sum%10)%10;return(sum+''===value.charAt(length-1));}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.emailAddress=$.extend($.fn.bootstrapValidator.i18n.emailAddress||{},{'default':'Please enter a valid email address'});$.fn.bootstrapValidator.validators.emailAddress={enableByHtml5:function($field){return('email'===$field.attr('type'));},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var emailRegExp=/^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;return emailRegExp.test(value);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.file=$.extend($.fn.bootstrapValidator.i18n.file||{},{'default':'Please choose a valid file'});$.fn.bootstrapValidator.validators.file={html5Attributes:{extension:'extension',maxsize:'maxSize',message:'message',type:'type'},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var ext,extensions=options.extension?options.extension.toLowerCase().split(','):null,types=options.type?options.type.toLowerCase().split(','):null,html5=(window.File&&window.FileList&&window.FileReader);if(html5){var files=$field.get(0).files,total=files.length;for(var i=0;i<total;i++){if(options.maxSize&&files[i].size>parseInt(options.maxSize,10)){return false;}
ext=files[i].name.substr(files[i].name.lastIndexOf('.')+1);if(extensions&&$.inArray(ext.toLowerCase(),extensions)===-1){return false;}
if(types&&$.inArray(files[i].type.toLowerCase(),types)===-1){return false;}}}else{ext=value.substr(value.lastIndexOf('.')+1);if(extensions&&$.inArray(ext.toLowerCase(),extensions)===-1){return false;}}
return true;}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.greaterThan=$.extend($.fn.bootstrapValidator.i18n.greaterThan||{},{'default':'Please enter a value greater than or equal to %s',notInclusive:'Please enter a value greater than %s'});$.fn.bootstrapValidator.validators.greaterThan={html5Attributes:{message:'message',value:'value',inclusive:'inclusive'},enableByHtml5:function($field){var min=$field.attr('min');if(min){return{value:min};}
return false;},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var compareTo=$.isNumeric(options.value)?options.value:validator.getDynamicOption($field,options.value);value=parseFloat(value);return(options.inclusive===true||options.inclusive===undefined)?{valid:value>=compareTo,message:$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.greaterThan['default'],compareTo)}:{valid:value>compareTo,message:$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.greaterThan.notInclusive,compareTo)};}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.grid=$.extend($.fn.bootstrapValidator.i18n.grid||{},{'default':'Please enter a valid GRId number'});$.fn.bootstrapValidator.validators.grid={validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
value=value.toUpperCase();if(!/^[GRID:]*([0-9A-Z]{2})[-\s]*([0-9A-Z]{5})[-\s]*([0-9A-Z]{10})[-\s]*([0-9A-Z]{1})$/g.test(value)){return false;}
value=value.replace(/\s/g,'').replace(/-/g,'');if('GRID:'===value.substr(0,5)){value=value.substr(5);}
return $.fn.bootstrapValidator.helpers.mod37And36(value);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.hex=$.extend($.fn.bootstrapValidator.i18n.hex||{},{'default':'Please enter a valid hexadecimal number'});$.fn.bootstrapValidator.validators.hex={validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
return /^[0-9a-fA-F]+$/.test(value);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.hexColor=$.extend($.fn.bootstrapValidator.i18n.hexColor||{},{'default':'Please enter a valid hex color'});$.fn.bootstrapValidator.validators.hexColor={enableByHtml5:function($field){return('color'===$field.attr('type'));},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(value);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.iban=$.extend($.fn.bootstrapValidator.i18n.iban||{},{'default':'Please enter a valid IBAN number',countryNotSupported:'The country code %s is not supported',country:'Please enter a valid IBAN number in %s',countries:{AD:'Andorra',AE:'United Arab Emirates',AL:'Albania',AO:'Angola',AT:'Austria',AZ:'Azerbaijan',BA:'Bosnia and Herzegovina',BE:'Belgium',BF:'Burkina Faso',BG:'Bulgaria',BH:'Bahrain',BI:'Burundi',BJ:'Benin',BR:'Brazil',CH:'Switzerland',CI:'Ivory Coast',CM:'Cameroon',CR:'Costa Rica',CV:'Cape Verde',CY:'Cyprus',CZ:'Czech Republic',DE:'Germany',DK:'Denmark',DO:'Dominican Republic',DZ:'Algeria',EE:'Estonia',ES:'Spain',FI:'Finland',FO:'Faroe Islands',FR:'France',GB:'United Kingdom',GE:'Georgia',GI:'Gibraltar',GL:'Greenland',GR:'Greece',GT:'Guatemala',HR:'Croatia',HU:'Hungary',IE:'Ireland',IL:'Israel',IR:'Iran',IS:'Iceland',IT:'Italy',JO:'Jordan',KW:'Kuwait',KZ:'Kazakhstan',LB:'Lebanon',LI:'Liechtenstein',LT:'Lithuania',LU:'Luxembourg',LV:'Latvia',MC:'Monaco',MD:'Moldova',ME:'Montenegro',MG:'Madagascar',MK:'Macedonia',ML:'Mali',MR:'Mauritania',MT:'Malta',MU:'Mauritius',MZ:'Mozambique',NL:'Netherlands',NO:'Norway',PK:'Pakistan',PL:'Poland',PS:'Palestinian',PT:'Portugal',QA:'Qatar',RO:'Romania',RS:'Serbia',SA:'Saudi Arabia',SE:'Sweden',SI:'Slovenia',SK:'Slovakia',SM:'San Marino',SN:'Senegal',TN:'Tunisia',TR:'Turkey',VG:'Virgin Islands, British'}});$.fn.bootstrapValidator.validators.iban={html5Attributes:{message:'message',country:'country'},REGEX:{AD:'AD[0-9]{2}[0-9]{4}[0-9]{4}[A-Z0-9]{12}',AE:'AE[0-9]{2}[0-9]{3}[0-9]{16}',AL:'AL[0-9]{2}[0-9]{8}[A-Z0-9]{16}',AO:'AO[0-9]{2}[0-9]{21}',AT:'AT[0-9]{2}[0-9]{5}[0-9]{11}',AZ:'AZ[0-9]{2}[A-Z]{4}[A-Z0-9]{20}',BA:'BA[0-9]{2}[0-9]{3}[0-9]{3}[0-9]{8}[0-9]{2}',BE:'BE[0-9]{2}[0-9]{3}[0-9]{7}[0-9]{2}',BF:'BF[0-9]{2}[0-9]{23}',BG:'BG[0-9]{2}[A-Z]{4}[0-9]{4}[0-9]{2}[A-Z0-9]{8}',BH:'BH[0-9]{2}[A-Z]{4}[A-Z0-9]{14}',BI:'BI[0-9]{2}[0-9]{12}',BJ:'BJ[0-9]{2}[A-Z]{1}[0-9]{23}',BR:'BR[0-9]{2}[0-9]{8}[0-9]{5}[0-9]{10}[A-Z][A-Z0-9]',CH:'CH[0-9]{2}[0-9]{5}[A-Z0-9]{12}',CI:'CI[0-9]{2}[A-Z]{1}[0-9]{23}',CM:'CM[0-9]{2}[0-9]{23}',CR:'CR[0-9]{2}[0-9]{3}[0-9]{14}',CV:'CV[0-9]{2}[0-9]{21}',CY:'CY[0-9]{2}[0-9]{3}[0-9]{5}[A-Z0-9]{16}',CZ:'CZ[0-9]{2}[0-9]{20}',DE:'DE[0-9]{2}[0-9]{8}[0-9]{10}',DK:'DK[0-9]{2}[0-9]{14}',DO:'DO[0-9]{2}[A-Z0-9]{4}[0-9]{20}',DZ:'DZ[0-9]{2}[0-9]{20}',EE:'EE[0-9]{2}[0-9]{2}[0-9]{2}[0-9]{11}[0-9]{1}',ES:'ES[0-9]{2}[0-9]{4}[0-9]{4}[0-9]{1}[0-9]{1}[0-9]{10}',FI:'FI[0-9]{2}[0-9]{6}[0-9]{7}[0-9]{1}',FO:'FO[0-9]{2}[0-9]{4}[0-9]{9}[0-9]{1}',FR:'FR[0-9]{2}[0-9]{5}[0-9]{5}[A-Z0-9]{11}[0-9]{2}',GB:'GB[0-9]{2}[A-Z]{4}[0-9]{6}[0-9]{8}',GE:'GE[0-9]{2}[A-Z]{2}[0-9]{16}',GI:'GI[0-9]{2}[A-Z]{4}[A-Z0-9]{15}',GL:'GL[0-9]{2}[0-9]{4}[0-9]{9}[0-9]{1}',GR:'GR[0-9]{2}[0-9]{3}[0-9]{4}[A-Z0-9]{16}',GT:'GT[0-9]{2}[A-Z0-9]{4}[A-Z0-9]{20}',HR:'HR[0-9]{2}[0-9]{7}[0-9]{10}',HU:'HU[0-9]{2}[0-9]{3}[0-9]{4}[0-9]{1}[0-9]{15}[0-9]{1}',IE:'IE[0-9]{2}[A-Z]{4}[0-9]{6}[0-9]{8}',IL:'IL[0-9]{2}[0-9]{3}[0-9]{3}[0-9]{13}',IR:'IR[0-9]{2}[0-9]{22}',IS:'IS[0-9]{2}[0-9]{4}[0-9]{2}[0-9]{6}[0-9]{10}',IT:'IT[0-9]{2}[A-Z]{1}[0-9]{5}[0-9]{5}[A-Z0-9]{12}',JO:'JO[0-9]{2}[A-Z]{4}[0-9]{4}[0]{8}[A-Z0-9]{10}',KW:'KW[0-9]{2}[A-Z]{4}[0-9]{22}',KZ:'KZ[0-9]{2}[0-9]{3}[A-Z0-9]{13}',LB:'LB[0-9]{2}[0-9]{4}[A-Z0-9]{20}',LI:'LI[0-9]{2}[0-9]{5}[A-Z0-9]{12}',LT:'LT[0-9]{2}[0-9]{5}[0-9]{11}',LU:'LU[0-9]{2}[0-9]{3}[A-Z0-9]{13}',LV:'LV[0-9]{2}[A-Z]{4}[A-Z0-9]{13}',MC:'MC[0-9]{2}[0-9]{5}[0-9]{5}[A-Z0-9]{11}[0-9]{2}',MD:'MD[0-9]{2}[A-Z0-9]{20}',ME:'ME[0-9]{2}[0-9]{3}[0-9]{13}[0-9]{2}',MG:'MG[0-9]{2}[0-9]{23}',MK:'MK[0-9]{2}[0-9]{3}[A-Z0-9]{10}[0-9]{2}',ML:'ML[0-9]{2}[A-Z]{1}[0-9]{23}',MR:'MR13[0-9]{5}[0-9]{5}[0-9]{11}[0-9]{2}',MT:'MT[0-9]{2}[A-Z]{4}[0-9]{5}[A-Z0-9]{18}',MU:'MU[0-9]{2}[A-Z]{4}[0-9]{2}[0-9]{2}[0-9]{12}[0-9]{3}[A-Z]{3}',MZ:'MZ[0-9]{2}[0-9]{21}',NL:'NL[0-9]{2}[A-Z]{4}[0-9]{10}',NO:'NO[0-9]{2}[0-9]{4}[0-9]{6}[0-9]{1}',PK:'PK[0-9]{2}[A-Z]{4}[A-Z0-9]{16}',PL:'PL[0-9]{2}[0-9]{8}[0-9]{16}',PS:'PS[0-9]{2}[A-Z]{4}[A-Z0-9]{21}',PT:'PT[0-9]{2}[0-9]{4}[0-9]{4}[0-9]{11}[0-9]{2}',QA:'QA[0-9]{2}[A-Z]{4}[A-Z0-9]{21}',RO:'RO[0-9]{2}[A-Z]{4}[A-Z0-9]{16}',RS:'RS[0-9]{2}[0-9]{3}[0-9]{13}[0-9]{2}',SA:'SA[0-9]{2}[0-9]{2}[A-Z0-9]{18}',SE:'SE[0-9]{2}[0-9]{3}[0-9]{16}[0-9]{1}',SI:'SI[0-9]{2}[0-9]{5}[0-9]{8}[0-9]{2}',SK:'SK[0-9]{2}[0-9]{4}[0-9]{6}[0-9]{10}',SM:'SM[0-9]{2}[A-Z]{1}[0-9]{5}[0-9]{5}[A-Z0-9]{12}',SN:'SN[0-9]{2}[A-Z]{1}[0-9]{23}',TN:'TN59[0-9]{2}[0-9]{3}[0-9]{13}[0-9]{2}',TR:'TR[0-9]{2}[0-9]{5}[A-Z0-9]{1}[A-Z0-9]{16}',VG:'VG[0-9]{2}[A-Z]{4}[0-9]{16}'},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
value=value.replace(/[^a-zA-Z0-9]/g,'').toUpperCase();var country=options.country;if(!country){country=value.substr(0,2);}else if(typeof country!=='string'||!this.REGEX[country]){country=validator.getDynamicOption($field,country);}
if(!this.REGEX[country]){return{valid:false,message:$.fn.bootstrapValidator.helpers.format($.fn.bootstrapValidator.i18n.iban.countryNotSupported,country)};}
if(!(new RegExp('^'+this.REGEX[country]+'$')).test(value)){return{valid:false,message:$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.iban.country,$.fn.bootstrapValidator.i18n.iban.countries[country])};}
value=value.substr(4)+value.substr(0,4);value=$.map(value.split(''),function(n){var code=n.charCodeAt(0);return(code>='A'.charCodeAt(0)&&code<='Z'.charCodeAt(0))?(code-'A'.charCodeAt(0)+10):n;});value=value.join('');var temp=parseInt(value.substr(0,1),10),length=value.length;for(var i=1;i<length;++i){temp=(temp*10+parseInt(value.substr(i,1),10))%97;}
return{valid:(temp===1),message:$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.iban.country,$.fn.bootstrapValidator.i18n.iban.countries[country])};}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.id=$.extend($.fn.bootstrapValidator.i18n.id||{},{'default':'Please enter a valid identification number',countryNotSupported:'The country code %s is not supported',country:'Please enter a valid %s identification number',countries:{BA:'Bosnia and Herzegovina',BG:'Bulgarian',BR:'Brazilian',CH:'Swiss',CL:'Chilean',CZ:'Czech',DK:'Danish',EE:'Estonian',ES:'Spanish',FI:'Finnish',HR:'Croatian',IE:'Irish',IS:'Iceland',LT:'Lithuanian',LV:'Latvian',ME:'Montenegro',MK:'Macedonian',NL:'Dutch',RO:'Romanian',RS:'Serbian',SE:'Swedish',SI:'Slovenian',SK:'Slovak',SM:'San Marino',ZA:'South African'}});$.fn.bootstrapValidator.validators.id={html5Attributes:{message:'message',country:'country'},COUNTRY_CODES:['BA','BG','BR','CH','CL','CZ','DK','EE','ES','FI','HR','IE','IS','LT','LV','ME','MK','NL','RO','RS','SE','SI','SK','SM','ZA'],validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var country=options.country;if(!country){country=value.substr(0,2);}else if(typeof country!=='string'||$.inArray(country.toUpperCase(),this.COUNTRY_CODES)===-1){country=validator.getDynamicOption($field,country);}
if($.inArray(country,this.COUNTRY_CODES)===-1){return{valid:false,message:$.fn.bootstrapValidator.helpers.format($.fn.bootstrapValidator.i18n.id.countryNotSupported,country)};}
var method=['_',country.toLowerCase()].join('');return this[method](value)?true:{valid:false,message:$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.id.country,$.fn.bootstrapValidator.i18n.id.countries[country.toUpperCase()])};},_validateJMBG:function(value,countryCode){if(!/^\d{13}$/.test(value)){return false;}
var day=parseInt(value.substr(0,2),10),month=parseInt(value.substr(2,2),10),year=parseInt(value.substr(4,3),10),rr=parseInt(value.substr(7,2),10),k=parseInt(value.substr(12,1),10);if(day>31||month>12){return false;}
var sum=0;for(var i=0;i<6;i++){sum+=(7-i)*(parseInt(value.charAt(i),10)+parseInt(value.charAt(i+6),10));}
sum=11-sum%11;if(sum===10||sum===11){sum=0;}
if(sum!==k){return false;}
switch(countryCode.toUpperCase()){case 'BA':return(10<=rr&&rr<=19);case 'MK':return(41<=rr&&rr<=49);case 'ME':return(20<=rr&&rr<=29);case 'RS':return(70<=rr&&rr<=99);case 'SI':return(50<=rr&&rr<=59);default:return true;}},_ba:function(value){return this._validateJMBG(value,'BA');},_mk:function(value){return this._validateJMBG(value,'MK');},_me:function(value){return this._validateJMBG(value,'ME');},_rs:function(value){return this._validateJMBG(value,'RS');},_si:function(value){return this._validateJMBG(value,'SI');},_bg:function(value){if(!/^\d{10}$/.test(value)&&!/^\d{6}\s\d{3}\s\d{1}$/.test(value)){return false;}
value=value.replace(/\s/g,'');var year=parseInt(value.substr(0,2),10)+1900,month=parseInt(value.substr(2,2),10),day=parseInt(value.substr(4,2),10);if(month>40){year+=100;month-=40;}else if(month>20){year-=100;month-=20;}
if(!$.fn.bootstrapValidator.helpers.date(year,month,day)){return false;}
var sum=0,weight=[2,4,8,5,10,9,7,3,6];for(var i=0;i<9;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=(sum%11)%10;return(sum+''===value.substr(9,1));},_br:function(value){if(/^1{11}|2{11}|3{11}|4{11}|5{11}|6{11}|7{11}|8{11}|9{11}|0{11}$/.test(value)){return false;}
if(!/^\d{11}$/.test(value)&&!/^\d{3}\.\d{3}\.\d{3}-\d{2}$/.test(value)){return false;}
value=value.replace(/\./g,'').replace(/-/g,'');var d1=0;for(var i=0;i<9;i++){d1+=(10-i)*parseInt(value.charAt(i),10);}
d1=11-d1%11;if(d1===10||d1===11){d1=0;}
if(d1+''!==value.charAt(9)){return false;}
var d2=0;for(i=0;i<10;i++){d2+=(11-i)*parseInt(value.charAt(i),10);}
d2=11-d2%11;if(d2===10||d2===11){d2=0;}
return(d2+''===value.charAt(10));},_ch:function(value){if(!/^756[\.]{0,1}[0-9]{4}[\.]{0,1}[0-9]{4}[\.]{0,1}[0-9]{2}$/.test(value)){return false;}
value=value.replace(/\D/g,'').substr(3);var length=value.length,sum=0,weight=(length===8)?[3,1]:[1,3];for(var i=0;i<length-1;i++){sum+=parseInt(value.charAt(i),10)*weight[i%2];}
sum=10-sum%10;return(sum+''===value.charAt(length-1));},_cl:function(value){if(!/^\d{7,8}[-]{0,1}[0-9K]$/i.test(value)){return false;}
value=value.replace(/\-/g,'');while(value.length<9){value='0'+value;}
var sum=0,weight=[3,2,7,6,5,4,3,2];for(var i=0;i<8;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=11-sum%11;if(sum===11){sum=0;}else if(sum===10){sum='K';}
return sum+''===value.charAt(8).toUpperCase();},_cz:function(value){if(!/^\d{9,10}$/.test(value)){return false;}
var year=1900+parseInt(value.substr(0,2),10),month=parseInt(value.substr(2,2),10)%50%20,day=parseInt(value.substr(4,2),10);if(value.length===9){if(year>=1980){year-=100;}
if(year>1953){return false;}}else if(year<1954){year+=100;}
if(!$.fn.bootstrapValidator.helpers.date(year,month,day)){return false;}
if(value.length===10){var check=parseInt(value.substr(0,9),10)%11;if(year<1985){check=check%10;}
return(check+''===value.substr(9,1));}
return true;},_dk:function(value){if(!/^[0-9]{6}[-]{0,1}[0-9]{4}$/.test(value)){return false;}
value=value.replace(/-/g,'');var day=parseInt(value.substr(0,2),10),month=parseInt(value.substr(2,2),10),year=parseInt(value.substr(4,2),10);switch(true){case('5678'.indexOf(value.charAt(6))!==-1&&year>=58):year+=1800;break;case('0123'.indexOf(value.charAt(6))!==-1):case('49'.indexOf(value.charAt(6))!==-1&&year>=37):year+=1900;break;default:year+=2000;break;}
return $.fn.bootstrapValidator.helpers.date(year,month,day);},_ee:function(value){return this._lt(value);},_es:function(value){if(!/^[0-9A-Z]{8}[-]{0,1}[0-9A-Z]$/.test(value)&&!/^[XYZ][-]{0,1}[0-9]{7}[-]{0,1}[0-9A-Z]$/.test(value)){return false;}
value=value.replace(/-/g,'');var index='XYZ'.indexOf(value.charAt(0));if(index!==-1){value=index+value.substr(1)+'';}
var check=parseInt(value.substr(0,8),10);check='TRWAGMYFPDXBNJZSQVHLCKE'[check%23];return(check===value.substr(8,1));},_fi:function(value){if(!/^[0-9]{6}[-+A][0-9]{3}[0-9ABCDEFHJKLMNPRSTUVWXY]$/.test(value)){return false;}
var day=parseInt(value.substr(0,2),10),month=parseInt(value.substr(2,2),10),year=parseInt(value.substr(4,2),10),centuries={'+':1800,'-':1900,'A':2000};year=centuries[value.charAt(6)]+year;if(!$.fn.bootstrapValidator.helpers.date(year,month,day)){return false;}
var individual=parseInt(value.substr(7,3),10);if(individual<2){return false;}
var n=value.substr(0,6)+value.substr(7,3)+'';n=parseInt(n,10);return '0123456789ABCDEFHJKLMNPRSTUVWXY'.charAt(n%31)===value.charAt(10);},_hr:function(value){if(!/^[0-9]{11}$/.test(value)){return false;}
return $.fn.bootstrapValidator.helpers.mod11And10(value);},_ie:function(value){if(!/^\d{7}[A-W][AHWTX]?$/.test(value)){return false;}
var getCheckDigit=function(value){while(value.length<7){value='0'+value;}
var alphabet='WABCDEFGHIJKLMNOPQRSTUV',sum=0;for(var i=0;i<7;i++){sum+=parseInt(value.charAt(i),10)*(8-i);}
sum+=9*alphabet.indexOf(value.substr(7));return alphabet[sum%23];};if(value.length===9&&('A'===value.charAt(8)||'H'===value.charAt(8))){return value.charAt(7)===getCheckDigit(value.substr(0,7)+value.substr(8)+'');}
else{return value.charAt(7)===getCheckDigit(value.substr(0,7));}},_is:function(value){if(!/^[0-9]{6}[-]{0,1}[0-9]{4}$/.test(value)){return false;}
value=value.replace(/-/g,'');var day=parseInt(value.substr(0,2),10),month=parseInt(value.substr(2,2),10),year=parseInt(value.substr(4,2),10),century=parseInt(value.charAt(9),10);year=(century===9)?(1900+year):((20+century)*100+year);if(!$.fn.bootstrapValidator.helpers.date(year,month,day,true)){return false;}
var sum=0,weight=[3,2,7,6,5,4,3,2];for(var i=0;i<8;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=11-sum%11;return(sum+''===value.charAt(8));},_lt:function(value){if(!/^[0-9]{11}$/.test(value)){return false;}
var gender=parseInt(value.charAt(0),10),year=parseInt(value.substr(1,2),10),month=parseInt(value.substr(3,2),10),day=parseInt(value.substr(5,2),10),century=(gender%2===0)?(17+gender/2):(17+(gender+1)/2);year=century*100+year;if(!$.fn.bootstrapValidator.helpers.date(year,month,day,true)){return false;}
var sum=0,weight=[1,2,3,4,5,6,7,8,9,1];for(var i=0;i<10;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=sum%11;if(sum!==10){return sum+''===value.charAt(10);}
sum=0;weight=[3,4,5,6,7,8,9,1,2,3];for(i=0;i<10;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=sum%11;if(sum===10){sum=0;}
return(sum+''===value.charAt(10));},_lv:function(value){if(!/^[0-9]{6}[-]{0,1}[0-9]{5}$/.test(value)){return false;}
value=value.replace(/\D/g,'');var day=parseInt(value.substr(0,2),10),month=parseInt(value.substr(2,2),10),year=parseInt(value.substr(4,2),10);year=year+1800+parseInt(value.charAt(6),10)*100;if(!$.fn.bootstrapValidator.helpers.date(year,month,day,true)){return false;}
var sum=0,weight=[10,5,8,4,2,1,6,3,7,9];for(var i=0;i<10;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=(sum+1)%11%10;return(sum+''===value.charAt(10));},_nl:function(value){while(value.length<9){value='0'+value;}
if(!/^[0-9]{4}[.]{0,1}[0-9]{2}[.]{0,1}[0-9]{3}$/.test(value)){return false;}
value=value.replace(/\./g,'');if(parseInt(value,10)===0){return false;}
var sum=0,length=value.length;for(var i=0;i<length-1;i++){sum+=(9-i)*parseInt(value.charAt(i),10);}
sum=sum%11;if(sum===10){sum=0;}
return(sum+''===value.charAt(length-1));},_ro:function(value){if(!/^[0-9]{13}$/.test(value)){return false;}
var gender=parseInt(value.charAt(0),10);if(gender===0||gender===7||gender===8){return false;}
var year=parseInt(value.substr(1,2),10),month=parseInt(value.substr(3,2),10),day=parseInt(value.substr(5,2),10),centuries={'1':1900,'2':1900,'3':1800,'4':1800,'5':2000,'6':2000};if(day>31&&month>12){return false;}
if(gender!==9){year=centuries[gender+'']+year;if(!$.fn.bootstrapValidator.helpers.date(year,month,day)){return false;}}
var sum=0,weight=[2,7,9,1,4,6,3,5,8,2,7,9],length=value.length;for(var i=0;i<length-1;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=sum%11;if(sum===10){sum=1;}
return(sum+''===value.charAt(length-1));},_se:function(value){if(!/^[0-9]{10}$/.test(value)&&!/^[0-9]{6}[-|+][0-9]{4}$/.test(value)){return false;}
value=value.replace(/[^0-9]/g,'');var year=parseInt(value.substr(0,2),10)+1900,month=parseInt(value.substr(2,2),10),day=parseInt(value.substr(4,2),10);if(!$.fn.bootstrapValidator.helpers.date(year,month,day)){return false;}
return $.fn.bootstrapValidator.helpers.luhn(value);},_sk:function(value){return this._cz(value);},_sm:function(value){return /^\d{5}$/.test(value);},_za:function(value){if(!/^[0-9]{10}[0|1][8|9][0-9]$/.test(value)){return false;}
var year=parseInt(value.substr(0,2),10),currentYear=new Date().getFullYear()%100,month=parseInt(value.substr(2,2),10),day=parseInt(value.substr(4,2),10);year=(year>=currentYear)?(year+1900):(year+2000);if(!$.fn.bootstrapValidator.helpers.date(year,month,day)){return false;}
return $.fn.bootstrapValidator.helpers.luhn(value);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.identical=$.extend($.fn.bootstrapValidator.i18n.identical||{},{'default':'Please enter the same value'});$.fn.bootstrapValidator.validators.identical={html5Attributes:{message:'message',field:'field'},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var compareWith=validator.getFieldElements(options.field);if(compareWith===null){return true;}
if(value===compareWith.val()){validator.updateStatus(options.field,validator.STATUS_VALID,'identical');return true;}else{return false;}}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.imei=$.extend($.fn.bootstrapValidator.i18n.imei||{},{'default':'Please enter a valid IMEI number'});$.fn.bootstrapValidator.validators.imei={validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
switch(true){case /^\d{15}$/.test(value):case /^\d{2}-\d{6}-\d{6}-\d{1}$/.test(value):case /^\d{2}\s\d{6}\s\d{6}\s\d{1}$/.test(value):value=value.replace(/[^0-9]/g,'');return $.fn.bootstrapValidator.helpers.luhn(value);case /^\d{14}$/.test(value):case /^\d{16}$/.test(value):case /^\d{2}-\d{6}-\d{6}(|-\d{2})$/.test(value):case /^\d{2}\s\d{6}\s\d{6}(|\s\d{2})$/.test(value):return true;default:return false;}}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.imo=$.extend($.fn.bootstrapValidator.i18n.imo||{},{'default':'Please enter a valid IMO number'});$.fn.bootstrapValidator.validators.imo={validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
if(!/^IMO \d{7}$/i.test(value)){return false;}
var sum=0,digits=value.replace(/^.*(\d{7})$/,'$1');for(var i=6;i>=1;i--){sum+=(digits.slice((6-i),-i)*(i+1));}
return sum%10===parseInt(digits.charAt(6),10);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.integer=$.extend($.fn.bootstrapValidator.i18n.integer||{},{'default':'Please enter a valid number'});$.fn.bootstrapValidator.validators.integer={enableByHtml5:function($field){return('number'===$field.attr('type'))&&($field.attr('step')===undefined||$field.attr('step')%1===0);},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
return /^(?:-?(?:0|[1-9][0-9]*))$/.test(value);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.ip=$.extend($.fn.bootstrapValidator.i18n.ip||{},{'default':'Please enter a valid IP address',ipv4:'Please enter a valid IPv4 address',ipv6:'Please enter a valid IPv6 address'});$.fn.bootstrapValidator.validators.ip={html5Attributes:{message:'message',ipv4:'ipv4',ipv6:'ipv6'},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
options=$.extend({},{ipv4:true,ipv6:true},options);var ipv4Regex=/^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/,ipv6Regex=/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/,valid=false,message;switch(true){case(options.ipv4&&!options.ipv6):valid=ipv4Regex.test(value);message=options.message||$.fn.bootstrapValidator.i18n.ip.ipv4;break;case(!options.ipv4&&options.ipv6):valid=ipv6Regex.test(value);message=options.message||$.fn.bootstrapValidator.i18n.ip.ipv6;break;case(options.ipv4&&options.ipv6):default:valid=ipv4Regex.test(value)&&ipv6Regex.test(value);message=options.message||$.fn.bootstrapValidator.i18n.ip.default;break;}
return{valid:valid,message:message};}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.isbn=$.extend($.fn.bootstrapValidator.i18n.isbn||{},{'default':'Please enter a valid ISBN number'});$.fn.bootstrapValidator.validators.isbn={validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var type;switch(true){case /^\d{9}[\dX]$/.test(value):case(value.length===13&&/^(\d+)-(\d+)-(\d+)-([\dX])$/.test(value)):case(value.length===13&&/^(\d+)\s(\d+)\s(\d+)\s([\dX])$/.test(value)):type='ISBN10';break;case /^(978|979)\d{9}[\dX]$/.test(value):case(value.length===17&&/^(978|979)-(\d+)-(\d+)-(\d+)-([\dX])$/.test(value)):case(value.length===17&&/^(978|979)\s(\d+)\s(\d+)\s(\d+)\s([\dX])$/.test(value)):type='ISBN13';break;default:return false;}
value=value.replace(/[^0-9X]/gi,'');var chars=value.split(''),length=chars.length,sum=0,i,checksum;switch(type){case 'ISBN10':sum=0;for(i=0;i<length-1;i++){sum+=parseInt(chars[i],10)*(10-i);}
checksum=11-(sum%11);if(checksum===11){checksum=0;}else if(checksum===10){checksum='X';}
return(checksum+''===chars[length-1]);case 'ISBN13':sum=0;for(i=0;i<length-1;i++){sum+=((i%2===0)?parseInt(chars[i],10):(parseInt(chars[i],10)*3));}
checksum=10-(sum%10);if(checksum===10){checksum='0';}
return(checksum+''===chars[length-1]);default:return false;}}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.isin=$.extend($.fn.bootstrapValidator.i18n.isin||{},{'default':'Please enter a valid ISIN number'});$.fn.bootstrapValidator.validators.isin={COUNTRY_CODES:'AF|AX|AL|DZ|AS|AD|AO|AI|AQ|AG|AR|AM|AW|AU|AT|AZ|BS|BH|BD|BB|BY|BE|BZ|BJ|BM|BT|BO|BQ|BA|BW|BV|BR|IO|BN|BG|BF|BI|KH|CM|CA|CV|KY|CF|TD|CL|CN|CX|CC|CO|KM|CG|CD|CK|CR|CI|HR|CU|CW|CY|CZ|DK|DJ|DM|DO|EC|EG|SV|GQ|ER|EE|ET|FK|FO|FJ|FI|FR|GF|PF|TF|GA|GM|GE|DE|GH|GI|GR|GL|GD|GP|GU|GT|GG|GN|GW|GY|HT|HM|VA|HN|HK|HU|IS|IN|ID|IR|IQ|IE|IM|IL|IT|JM|JP|JE|JO|KZ|KE|KI|KP|KR|KW|KG|LA|LV|LB|LS|LR|LY|LI|LT|LU|MO|MK|MG|MW|MY|MV|ML|MT|MH|MQ|MR|MU|YT|MX|FM|MD|MC|MN|ME|MS|MA|MZ|MM|NA|NR|NP|NL|NC|NZ|NI|NE|NG|NU|NF|MP|NO|OM|PK|PW|PS|PA|PG|PY|PE|PH|PN|PL|PT|PR|QA|RE|RO|RU|RW|BL|SH|KN|LC|MF|PM|VC|WS|SM|ST|SA|SN|RS|SC|SL|SG|SX|SK|SI|SB|SO|ZA|GS|SS|ES|LK|SD|SR|SJ|SZ|SE|CH|SY|TW|TJ|TZ|TH|TL|TG|TK|TO|TT|TN|TR|TM|TC|TV|UG|UA|AE|GB|US|UM|UY|UZ|VU|VE|VN|VG|VI|WF|EH|YE|ZM|ZW',validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
value=value.toUpperCase();var regex=new RegExp('^('+this.COUNTRY_CODES+')[0-9A-Z]{10}$');if(!regex.test(value)){return false;}
var converted='',length=value.length;for(var i=0;i<length-1;i++){var c=value.charCodeAt(i);converted+=((c>57)?(c-55).toString():value.charAt(i));}
var digits='',n=converted.length,group=(n%2!==0)?0:1;for(i=0;i<n;i++){digits+=(parseInt(converted[i],10)*((i%2)===group?2:1)+'');}
var sum=0;for(i=0;i<digits.length;i++){sum+=parseInt(digits.charAt(i),10);}
sum=(10-(sum%10))%10;return sum+''===value.charAt(length-1);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.ismn=$.extend($.fn.bootstrapValidator.i18n.ismn||{},{'default':'Please enter a valid ISMN number'});$.fn.bootstrapValidator.validators.ismn={validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var type;switch(true){case /^M\d{9}$/.test(value):case /^M-\d{4}-\d{4}-\d{1}$/.test(value):case /^M\s\d{4}\s\d{4}\s\d{1}$/.test(value):type='ISMN10';break;case /^9790\d{9}$/.test(value):case /^979-0-\d{4}-\d{4}-\d{1}$/.test(value):case /^979\s0\s\d{4}\s\d{4}\s\d{1}$/.test(value):type='ISMN13';break;default:return false;}
if('ISMN10'===type){value='9790'+value.substr(1);}
value=value.replace(/[^0-9]/gi,'');var length=value.length,sum=0,weight=[1,3];for(var i=0;i<length-1;i++){sum+=parseInt(value.charAt(i),10)*weight[i%2];}
sum=10-sum%10;return(sum+''===value.charAt(length-1));}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.issn=$.extend($.fn.bootstrapValidator.i18n.issn||{},{'default':'Please enter a valid ISSN number'});$.fn.bootstrapValidator.validators.issn={validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
if(!/^\d{4}\-\d{3}[\dX]$/.test(value)){return false;}
value=value.replace(/[^0-9X]/gi,'');var chars=value.split(''),length=chars.length,sum=0;if(chars[7]==='X'){chars[7]=10;}
for(var i=0;i<length;i++){sum+=parseInt(chars[i],10)*(8-i);}
return(sum%11===0);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.lessThan=$.extend($.fn.bootstrapValidator.i18n.lessThan||{},{'default':'Please enter a value less than or equal to %s',notInclusive:'Please enter a value less than %s'});$.fn.bootstrapValidator.validators.lessThan={html5Attributes:{message:'message',value:'value',inclusive:'inclusive'},enableByHtml5:function($field){var max=$field.attr('max');if(max){return{value:max};}
return false;},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var compareTo=$.isNumeric(options.value)?options.value:validator.getDynamicOption($field,options.value);value=parseFloat(value);return(options.inclusive===true||options.inclusive===undefined)?{valid:value<=compareTo,message:$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.lessThan['default'],compareTo)}:{valid:value<compareTo,message:$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.lessThan.notInclusive,compareTo)};}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.mac=$.extend($.fn.bootstrapValidator.i18n.mac||{},{'default':'Please enter a valid MAC address'});$.fn.bootstrapValidator.validators.mac={validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
return /^([0-9A-F]{2}[:-]){5}([0-9A-F]{2})$/.test(value);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.meid=$.extend($.fn.bootstrapValidator.i18n.meid||{},{'default':'Please enter a valid MEID number'});$.fn.bootstrapValidator.validators.meid={validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
switch(true){case /^[0-9A-F]{15}$/i.test(value):case /^[0-9A-F]{2}[- ][0-9A-F]{6}[- ][0-9A-F]{6}[- ][0-9A-F]$/i.test(value):case /^\d{19}$/.test(value):case /^\d{5}[- ]\d{5}[- ]\d{4}[- ]\d{4}[- ]\d$/.test(value):var cd=value.charAt(value.length-1);value=value.replace(/[- ]/g,'');if(value.match(/^\d*$/i)){return $.fn.bootstrapValidator.helpers.luhn(value);}
value=value.slice(0,-1);var cdCalc='';for(var i=1;i<=13;i+=2){cdCalc+=(parseInt(value.charAt(i),16)*2).toString(16);}
var sum=0;for(i=0;i<cdCalc.length;i++){sum+=parseInt(cdCalc.charAt(i),16);}
return(sum%10===0)?(cd==='0'):(cd===((Math.floor((sum+10)/10)*10-sum)*2).toString(16));case /^[0-9A-F]{14}$/i.test(value):case /^[0-9A-F]{2}[- ][0-9A-F]{6}[- ][0-9A-F]{6}$/i.test(value):case /^\d{18}$/.test(value):case /^\d{5}[- ]\d{5}[- ]\d{4}[- ]\d{4}$/.test(value):return true;default:return false;}}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.notEmpty=$.extend($.fn.bootstrapValidator.i18n.notEmpty||{},{'default':'Please enter a value'});$.fn.bootstrapValidator.validators.notEmpty={enableByHtml5:function($field){var required=$field.attr('required')+'';return('required'===required||'true'===required);},validate:function(validator,$field,options){var type=$field.attr('type');if('radio'===type||'checkbox'===type){return validator.getFieldElements($field.attr('data-bv-field')).filter(':checked').length>0;}
return $.trim($field.val())!=='';}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.numeric=$.extend($.fn.bootstrapValidator.i18n.numeric||{},{'default':'Please enter a valid float number'});$.fn.bootstrapValidator.validators.numeric={html5Attributes:{message:'message',separator:'separator'},enableByHtml5:function($field){return('number'===$field.attr('type'))&&($field.attr('step')!==undefined)&&($field.attr('step')%1!==0);},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var separator=options.separator||'.';if(separator!=='.'){value=value.replace(separator,'.');}
return!isNaN(parseFloat(value))&&isFinite(value);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.phone=$.extend($.fn.bootstrapValidator.i18n.phone||{},{'default':'Please enter a valid phone number',countryNotSupported:'The country code %s is not supported',country:'Please enter a valid phone number in %s',countries:{ES:'Spain',FR:'France',GB:'United Kingdom',US:'USA'}});$.fn.bootstrapValidator.validators.phone={html5Attributes:{message:'message',country:'country'},COUNTRY_CODES:['ES','FR','GB','US'],validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var country=options.country;if(typeof country!=='string'||$.inArray(country,this.COUNTRY_CODES)===-1){country=validator.getDynamicOption($field,country);}
if(!country||$.inArray(country.toUpperCase(),this.COUNTRY_CODES)===-1){return{valid:false,message:$.fn.bootstrapValidator.helpers.format($.fn.bootstrapValidator.i18n.phone.countryNotSupported,country)};}
var isValid=true;switch(country.toUpperCase()){case 'ES':value=$.trim(value);isValid=(/^(?:(?:(?:\+|00)34\D?))?(?:9|6)(?:\d\D?){8}$/).test(value);break;case 'FR':value=$.trim(value);isValid=(/^(?:(?:(?:\+|00)33\D?(?:\D?\(0\)\D?)?)|0){1}[1-9]{1}(?:\D?\d{2}){4}$/).test(value);break;case 'GB':value=$.trim(value);isValid=(/^\(?(?:(?:0(?:0|11)\)?[\s-]?\(?|\+)44\)?[\s-]?\(?(?:0\)?[\s-]?\(?)?|0)(?:\d{2}\)?[\s-]?\d{4}[\s-]?\d{4}|\d{3}\)?[\s-]?\d{3}[\s-]?\d{3,4}|\d{4}\)?[\s-]?(?:\d{5}|\d{3}[\s-]?\d{3})|\d{5}\)?[\s-]?\d{4,5}|8(?:00[\s-]?11[\s-]?11|45[\s-]?46[\s-]?4\d))(?:(?:[\s-]?(?:x|ext\.?\s?|\#)\d+)?)$/).test(value);break;case 'US':default:value=value.replace(/\D/g,'');isValid=(/^(?:(1\-?)|(\+1 ?))?\(?(\d{3})[\)\-\.]?(\d{3})[\-\.]?(\d{4})$/).test(value)&&(value.length===10);break;}
return{valid:isValid,message:$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.phone.country,$.fn.bootstrapValidator.i18n.phone.countries[country])};}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.regexp=$.extend($.fn.bootstrapValidator.i18n.regexp||{},{'default':'Please enter a value matching the pattern'});$.fn.bootstrapValidator.validators.regexp={html5Attributes:{message:'message',regexp:'regexp'},enableByHtml5:function($field){var pattern=$field.attr('pattern');if(pattern){return{regexp:pattern};}
return false;},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var regexp=('string'===typeof options.regexp)?new RegExp(options.regexp):options.regexp;return regexp.test(value);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.remote=$.extend($.fn.bootstrapValidator.i18n.remote||{},{'default':'Please enter a valid value'});$.fn.bootstrapValidator.validators.remote={html5Attributes:{message:'message',url:'url',name:'name'},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var name=$field.attr('data-bv-field'),data=options.data||{},url=options.url,type=options.type||'POST';if('function'===typeof data){data=data.call(this,validator);}
if('function'===typeof url){url=url.call(this,validator);}
data[options.name||name]=value;var dfd=new $.Deferred();var xhr=$.ajax({type:type,url:url,dataType:'json',data:data});xhr.then(function(response){dfd.resolve($field,'remote',response.valid===true||response.valid==='true',response.message?response.message:null);});dfd.fail(function(){xhr.abort();});return dfd;}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.rtn=$.extend($.fn.bootstrapValidator.i18n.rtn||{},{'default':'Please enter a valid RTN number'});$.fn.bootstrapValidator.validators.rtn={validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
if(!/^\d{9}$/.test(value)){return false;}
var sum=0;for(var i=0;i<value.length;i+=3){sum+=parseInt(value.charAt(i),10)*3
+parseInt(value.charAt(i+1),10)*7
+parseInt(value.charAt(i+2),10);}
return(sum!==0&&sum%10===0);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.sedol=$.extend($.fn.bootstrapValidator.i18n.sedol||{},{'default':'Please enter a valid SEDOL number'});$.fn.bootstrapValidator.validators.sedol={validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
value=value.toUpperCase();if(!/^[0-9A-Z]{7}$/.test(value)){return false;}
var sum=0,weight=[1,3,1,7,3,9,1],length=value.length;for(var i=0;i<length-1;i++){sum+=weight[i]*parseInt(value.charAt(i),36);}
sum=(10-sum%10)%10;return sum+''===value.charAt(length-1);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.siren=$.extend($.fn.bootstrapValidator.i18n.siren||{},{'default':'Please enter a valid SIREN number'});$.fn.bootstrapValidator.validators.siren={validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
if(!/^\d{9}$/.test(value)){return false;}
return $.fn.bootstrapValidator.helpers.luhn(value);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.siret=$.extend($.fn.bootstrapValidator.i18n.siret||{},{'default':'Please enter a valid SIRET number'});$.fn.bootstrapValidator.validators.siret={validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var sum=0,length=value.length,tmp;for(var i=0;i<length;i++){tmp=parseInt(value.charAt(i),10);if((i%2)===0){tmp=tmp*2;if(tmp>9){tmp-=9;}}
sum+=tmp;}
return(sum%10===0);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.step=$.extend($.fn.bootstrapValidator.i18n.step||{},{'default':'Please enter a valid step of %s'});$.fn.bootstrapValidator.validators.step={html5Attributes:{message:'message',base:'baseValue',step:'step'},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
options=$.extend({},{baseValue:0,step:1},options);value=parseFloat(value);if(!$.isNumeric(value)){return false;}
var round=function(x,precision){var m=Math.pow(10,precision);x=x*m;var sign=(x>0)|-(x<0),isHalf=(x%1===0.5*sign);if(isHalf){return(Math.floor(x)+(sign>0))/m;}else{return Math.round(x)/m;}},floatMod=function(x,y){if(y===0.0){return 1.0;}
var dotX=(x+'').split('.'),dotY=(y+'').split('.'),precision=((dotX.length===1)?0:dotX[1].length)+((dotY.length===1)?0:dotY[1].length);return round(x-y*Math.floor(x/y),precision);};var mod=floatMod(value-options.baseValue,options.step);return{valid:mod===0.0||mod===options.step,message:$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.step['default'],[options.step])};}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.stringCase=$.extend($.fn.bootstrapValidator.i18n.stringCase||{},{'default':'Please enter only lowercase characters',upper:'Please enter only uppercase characters'});$.fn.bootstrapValidator.validators.stringCase={html5Attributes:{message:'message','case':'case'},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var stringCase=(options['case']||'lower').toLowerCase();return{valid:('upper'===stringCase)?value===value.toUpperCase():value===value.toLowerCase(),message:options.message||(('upper'===stringCase)?$.fn.bootstrapValidator.i18n.stringCase.upper:$.fn.bootstrapValidator.i18n.stringCase['default'])};}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.stringLength=$.extend($.fn.bootstrapValidator.i18n.stringLength||{},{'default':'Please enter a value with valid length',less:'Please enter less than %s characters',more:'Please enter more than %s characters',between:'Please enter value between %s and %s characters long'});$.fn.bootstrapValidator.validators.stringLength={html5Attributes:{message:'message',min:'min',max:'max'},enableByHtml5:function($field){var maxLength=$field.attr('maxlength');if(maxLength){return{max:parseInt(maxLength,10)};}
return false;},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var min=$.isNumeric(options.min)?options.min:validator.getDynamicOption($field,options.min),max=$.isNumeric(options.max)?options.max:validator.getDynamicOption($field,options.max),length=value.length,isValid=true,message=options.message||$.fn.bootstrapValidator.i18n.stringLength['default'];if((min&&length<parseInt(min,10))||(max&&length>parseInt(max,10))){isValid=false;}
switch(true){case(!!min&&!!max):message=$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.stringLength.between,[parseInt(min,10),parseInt(max,10)]);break;case(!!min):message=$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.stringLength.more,parseInt(min,10));break;case(!!max):message=$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.stringLength.less,parseInt(max,10));break;default:break;}
return{valid:isValid,message:message};}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.uri=$.extend($.fn.bootstrapValidator.i18n.uri||{},{'default':'Please enter a valid URI'});$.fn.bootstrapValidator.validators.uri={html5Attributes:{message:'message',allowlocal:'allowLocal'},enableByHtml5:function($field){return('url'===$field.attr('type'));},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var allowLocal=options.allowLocal===true||options.allowLocal==='true',urlExp=new RegExp("^"+
"(?:(?:https?|ftp)://)"+
"(?:\\S+(?::\\S*)?@)?"+
"(?:"+
(allowLocal?'':("(?!(?:10|127)(?:\\.\\d{1,3}){3})"+
"(?!(?:169\\.254|192\\.168)(?:\\.\\d{1,3}){2})"+
"(?!172\\.(?:1[6-9]|2\\d|3[0-1])(?:\\.\\d{1,3}){2})"))+
"(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])"+
"(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}"+
"(?:\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))"+
"|"+
"(?:(?:[a-z\\u00a1-\\uffff0-9]+-?)*[a-z\\u00a1-\\uffff0-9]+)"+
"(?:\\.(?:[a-z\\u00a1-\\uffff0-9]+-?)*[a-z\\u00a1-\\uffff0-9]+)*"+
"(?:\\.(?:[a-z\\u00a1-\\uffff]{2,}))"+
(allowLocal?'?':'')+
")"+
"(?::\\d{2,5})?"+
"(?:/[^\\s]*)?"+
"$","i");return urlExp.test(value);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.uuid=$.extend($.fn.bootstrapValidator.i18n.uuid||{},{'default':'Please enter a valid UUID number',version:'Please enter a valid UUID version %s number'});$.fn.bootstrapValidator.validators.uuid={html5Attributes:{message:'message',version:'version'},validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var patterns={'3':/^[0-9A-F]{8}-[0-9A-F]{4}-3[0-9A-F]{3}-[0-9A-F]{4}-[0-9A-F]{12}$/i,'4':/^[0-9A-F]{8}-[0-9A-F]{4}-4[0-9A-F]{3}-[89AB][0-9A-F]{3}-[0-9A-F]{12}$/i,'5':/^[0-9A-F]{8}-[0-9A-F]{4}-5[0-9A-F]{3}-[89AB][0-9A-F]{3}-[0-9A-F]{12}$/i,all:/^[0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12}$/i},version=options.version?(options.version+''):'all';return{valid:(null===patterns[version])?true:patterns[version].test(value),message:options.version?$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.uuid.version,options.version):(options.message||$.fn.bootstrapValidator.i18n.uuid['default'])};}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.vat=$.extend($.fn.bootstrapValidator.i18n.vat||{},{'default':'Please enter a valid VAT number',countryNotSupported:'The country code %s is not supported',country:'Please enter a valid %s VAT number',countries:{AT:'Austrian',BE:'Belgian',BG:'Bulgarian',CH:'Swiss',CY:'Cypriot',CZ:'Czech',DE:'German',DK:'Danish',EE:'Estonian',ES:'Spanish',FI:'Finnish',FR:'French',GB:'United Kingdom',GR:'Greek',EL:'Greek',HU:'Hungarian',HR:'Croatian',IE:'Irish',IT:'Italian',LT:'Lithuanian',LU:'Luxembourg',LV:'Latvian',MT:'Maltese',NL:'Dutch',NO:'Norwegian',PL:'Polish',PT:'Portuguese',RO:'Romanian',RU:'Russian',RS:'Serbian',SE:'Swedish',SI:'Slovenian',SK:'Slovak'}});$.fn.bootstrapValidator.validators.vat={html5Attributes:{message:'message',country:'country'},COUNTRY_CODES:['AT','BE','BG','HR','CY','CZ','DK','EE','FI','FR','DE','GR','EL','HU','IE','IT','LV','LT','LU','MT','NL','NO','PL','PT','RO','RU','RS','SK','SI','ES','SE','CH','GB'],validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
var country=options.country;if(!country){country=value.substr(0,2);}else if(typeof country!=='string'||$.inArray(country.toUpperCase(),this.COUNTRY_CODES)===-1){country=validator.getDynamicOption($field,country);}
if($.inArray(country,this.COUNTRY_CODES)===-1){return{valid:false,message:$.fn.bootstrapValidator.helpers.format($.fn.bootstrapValidator.i18n.vat.countryNotSupported,country)};}
var method=['_',country.toLowerCase()].join('');return this[method](value)?true:{valid:false,message:$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.vat.country,$.fn.bootstrapValidator.i18n.vat.countries[country.toUpperCase()])};},_at:function(value){if(!/^ATU[0-9]{8}$/.test(value)){return false;}
value=value.substr(3);var sum=0,weight=[1,2,1,2,1,2,1],temp=0;for(var i=0;i<7;i++){temp=parseInt(value.charAt(i),10)*weight[i];if(temp>9){temp=Math.floor(temp/10)+temp%10;}
sum+=temp;}
sum=10-(sum+4)%10;if(sum===10){sum=0;}
return(sum+''===value.substr(7,1));},_be:function(value){if(!/^BE[0]{0,1}[0-9]{9}$/.test(value)){return false;}
value=value.substr(2);if(value.length===9){value='0'+value;}
if(value.substr(1,1)==='0'){return false;}
var sum=parseInt(value.substr(0,8),10)+parseInt(value.substr(8,2),10);return(sum%97===0);},_bg:function(value){if(!/^BG[0-9]{9,10}$/.test(value)){return false;}
value=value.substr(2);var sum=0,i=0;if(value.length===9){for(i=0;i<8;i++){sum+=parseInt(value.charAt(i),10)*(i+1);}
sum=sum%11;if(sum===10){sum=0;for(i=0;i<8;i++){sum+=parseInt(value.charAt(i),10)*(i+3);}}
sum=sum%10;return(sum+''===value.substr(8));}
else if(value.length===10){var egn=function(value){var year=parseInt(value.substr(0,2),10)+1900,month=parseInt(value.substr(2,2),10),day=parseInt(value.substr(4,2),10);if(month>40){year+=100;month-=40;}else if(month>20){year-=100;month-=20;}
if(!$.fn.bootstrapValidator.helpers.date(year,month,day)){return false;}
var sum=0,weight=[2,4,8,5,10,9,7,3,6];for(var i=0;i<9;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=(sum%11)%10;return(sum+''===value.substr(9,1));},pnf=function(value){var sum=0,weight=[21,19,17,13,11,9,7,3,1];for(var i=0;i<9;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=sum%10;return(sum+''===value.substr(9,1));},vat=function(value){var sum=0,weight=[4,3,2,7,6,5,4,3,2];for(var i=0;i<9;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=11-sum%11;if(sum===10){return false;}
if(sum===11){sum=0;}
return(sum+''===value.substr(9,1));};return(egn(value)||pnf(value)||vat(value));}
return false;},_ch:function(value){if(!/^CHE[0-9]{9}(MWST)?$/.test(value)){return false;}
value=value.substr(3);var sum=0,weight=[5,4,3,2,7,6,5,4];for(var i=0;i<8;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=11-sum%11;if(sum===10){return false;}
if(sum===11){sum=0;}
return(sum+''===value.substr(8,1));},_cy:function(value){if(!/^CY[0-5|9]{1}[0-9]{7}[A-Z]{1}$/.test(value)){return false;}
value=value.substr(2);if(value.substr(0,2)==='12'){return false;}
var sum=0,translation={'0':1,'1':0,'2':5,'3':7,'4':9,'5':13,'6':15,'7':17,'8':19,'9':21};for(var i=0;i<8;i++){var temp=parseInt(value.charAt(i),10);if(i%2===0){temp=translation[temp+''];}
sum+=temp;}
sum='ABCDEFGHIJKLMNOPQRSTUVWXYZ'[sum%26];return(sum+''===value.substr(8,1));},_cz:function(value){if(!/^CZ[0-9]{8,10}$/.test(value)){return false;}
value=value.substr(2);var sum=0,i=0;if(value.length===8){if(value.charAt(0)+''==='9'){return false;}
sum=0;for(i=0;i<7;i++){sum+=parseInt(value.charAt(i),10)*(8-i);}
sum=11-sum%11;if(sum===10){sum=0;}
if(sum===11){sum=1;}
return(sum+''===value.substr(7,1));}else if(value.length===9&&(value.charAt(0)+''==='6')){sum=0;for(i=0;i<7;i++){sum+=parseInt(value.charAt(i+1),10)*(8-i);}
sum=11-sum%11;if(sum===10){sum=0;}
if(sum===11){sum=1;}
sum=[8,7,6,5,4,3,2,1,0,9,10][sum-1];return(sum+''===value.substr(8,1));}else if(value.length===9||value.length===10){var year=1900+parseInt(value.substr(0,2),10),month=parseInt(value.substr(2,2),10)%50%20,day=parseInt(value.substr(4,2),10);if(value.length===9){if(year>=1980){year-=100;}
if(year>1953){return false;}}else if(year<1954){year+=100;}
if(!$.fn.bootstrapValidator.helpers.date(year,month,day)){return false;}
if(value.length===10){var check=parseInt(value.substr(0,9),10)%11;if(year<1985){check=check%10;}
return(check+''===value.substr(9,1));}
return true;}
return false;},_de:function(value){if(!/^DE[0-9]{9}$/.test(value)){return false;}
value=value.substr(2);return $.fn.bootstrapValidator.helpers.mod11And10(value);},_dk:function(value){if(!/^DK[0-9]{8}$/.test(value)){return false;}
value=value.substr(2);var sum=0,weight=[2,7,6,5,4,3,2,1];for(var i=0;i<8;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
return(sum%11===0);},_ee:function(value){if(!/^EE[0-9]{9}$/.test(value)){return false;}
value=value.substr(2);var sum=0,weight=[3,7,1,3,7,1,3,7,1];for(var i=0;i<9;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
return(sum%10===0);},_es:function(value){if(!/^ES[0-9A-Z][0-9]{7}[0-9A-Z]$/.test(value)){return false;}
value=value.substr(2);var dni=function(value){var check=parseInt(value.substr(0,8),10);check='TRWAGMYFPDXBNJZSQVHLCKE'[check%23];return(check+''===value.substr(8,1));},nie=function(value){var check=['XYZ'.indexOf(value.charAt(0)),value.substr(1)].join('');check=parseInt(check,10);check='TRWAGMYFPDXBNJZSQVHLCKE'[check%23];return(check+''===value.substr(8,1));},cif=function(value){var first=value.charAt(0),check;if('KLM'.indexOf(first)!==-1){check=parseInt(value.substr(1,8),10);check='TRWAGMYFPDXBNJZSQVHLCKE'[check%23];return(check+''===value.substr(8,1));}else if('ABCDEFGHJNPQRSUVW'.indexOf(first)!==-1){var sum=0,weight=[2,1,2,1,2,1,2],temp=0;for(var i=0;i<7;i++){temp=parseInt(value.charAt(i+1),10)*weight[i];if(temp>9){temp=Math.floor(temp/10)+temp%10;}
sum+=temp;}
sum=10-sum%10;return(sum+''===value.substr(8,1)||'JABCDEFGHI'[sum]===value.substr(8,1));}
return false;};var first=value.charAt(0);if(/^[0-9]$/.test(first)){return dni(value);}else if(/^[XYZ]$/.test(first)){return nie(value);}else{return cif(value);}},_fi:function(value){if(!/^FI[0-9]{8}$/.test(value)){return false;}
value=value.substr(2);var sum=0,weight=[7,9,10,5,8,4,2,1];for(var i=0;i<8;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
return(sum%11===0);},_fr:function(value){if(!/^FR[0-9A-Z]{2}[0-9]{9}$/.test(value)){return false;}
value=value.substr(2);if(!$.fn.bootstrapValidator.helpers.luhn(value.substr(2))){return false;}
if(/^[0-9]{2}$/.test(value.substr(0,2))){return value.substr(0,2)===(parseInt(value.substr(2)+'12',10)%97+'');}else{var alphabet='0123456789ABCDEFGHJKLMNPQRSTUVWXYZ',check;if(/^[0-9]{1}$/.test(value.charAt(0))){check=alphabet.indexOf(value.charAt(0))*24+alphabet.indexOf(value.charAt(1))-10;}else{check=alphabet.indexOf(value.charAt(0))*34+alphabet.indexOf(value.charAt(1))-100;}
return((parseInt(value.substr(2),10)+1+Math.floor(check/11))%11)===(check%11);}},_gb:function(value){if(!/^GB[0-9]{9}$/.test(value)&&!/^GB[0-9]{12}$/.test(value)&&!/^GBGD[0-9]{3}$/.test(value)&&!/^GBHA[0-9]{3}$/.test(value)&&!/^GB(GD|HA)8888[0-9]{5}$/.test(value))
{return false;}
value=value.substr(2);var length=value.length;if(length===5){var firstTwo=value.substr(0,2),lastThree=parseInt(value.substr(2),10);return('GD'===firstTwo&&lastThree<500)||('HA'===firstTwo&&lastThree>=500);}else if(length===11&&('GD8888'===value.substr(0,6)||'HA8888'===value.substr(0,6))){if(('GD'===value.substr(0,2)&&parseInt(value.substr(6,3),10)>=500)||('HA'===value.substr(0,2)&&parseInt(value.substr(6,3),10)<500))
{return false;}
return(parseInt(value.substr(6,3),10)%97===parseInt(value.substr(9,2),10));}else if(length===9||length===12){var sum=0,weight=[8,7,6,5,4,3,2,10,1];for(var i=0;i<9;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=sum%97;if(parseInt(value.substr(0,3),10)>=100){return(sum===0||sum===42||sum===55);}else{return(sum===0);}}
return true;},_gr:function(value){if(!/^GR[0-9]{9}$/.test(value)){return false;}
value=value.substr(2);if(value.length===8){value='0'+value;}
var sum=0,weight=[256,128,64,32,16,8,4,2];for(var i=0;i<8;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=(sum%11)%10;return(sum+''===value.substr(8,1));},_el:function(value){if(!/^EL[0-9]{9}$/.test(value)){return false;}
value='GR'+value.substr(2);return this._gr(value);},_hu:function(value){if(!/^HU[0-9]{8}$/.test(value)){return false;}
value=value.substr(2);var sum=0,weight=[9,7,3,1,9,7,3,1];for(var i=0;i<8;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
return(sum%10===0);},_hr:function(value){if(!/^HR[0-9]{11}$/.test(value)){return false;}
value=value.substr(2);return $.fn.bootstrapValidator.helpers.mod11And10(value);},_ie:function(value){if(!/^IE[0-9]{1}[0-9A-Z\*\+]{1}[0-9]{5}[A-Z]{1,2}$/.test(value)){return false;}
value=value.substr(2);var getCheckDigit=function(value){while(value.length<7){value='0'+value;}
var alphabet='WABCDEFGHIJKLMNOPQRSTUV',sum=0;for(var i=0;i<7;i++){sum+=parseInt(value.charAt(i),10)*(8-i);}
sum+=9*alphabet.indexOf(value.substr(7));return alphabet[sum%23];};if(/^[0-9]+$/.test(value.substr(0,7))){return value.charAt(7)===getCheckDigit(value.substr(0,7)+value.substr(8)+'');}else if('ABCDEFGHIJKLMNOPQRSTUVWXYZ+*'.indexOf(value.charAt(1))!==-1){return value.charAt(7)===getCheckDigit(value.substr(2,5)+value.substr(0,1)+'');}
return true;},_it:function(value){if(!/^IT[0-9]{11}$/.test(value)){return false;}
value=value.substr(2);if(parseInt(value.substr(0,7),10)===0){return false;}
var lastThree=parseInt(value.substr(7,3),10);if((lastThree<1)||(lastThree>201)&&lastThree!==999&&lastThree!==888){return false;}
return $.fn.bootstrapValidator.helpers.luhn(value);},_lt:function(value){if(!/^LT([0-9]{7}1[0-9]{1}|[0-9]{10}1[0-9]{1})$/.test(value)){return false;}
value=value.substr(2);var length=value.length,sum=0,i;for(i=0;i<length-1;i++){sum+=parseInt(value.charAt(i),10)*(1+i%9);}
var check=sum%11;if(check===10){sum=0;for(i=0;i<length-1;i++){sum+=parseInt(value.charAt(i),10)*(1+(i+2)%9);}}
check=check%11%10;return(check+''===value.charAt(length-1));},_lu:function(value){if(!/^LU[0-9]{8}$/.test(value)){return false;}
value=value.substr(2);return((parseInt(value.substr(0,6),10)%89)+''===value.substr(6,2));},_lv:function(value){if(!/^LV[0-9]{11}$/.test(value)){return false;}
value=value.substr(2);var first=parseInt(value.charAt(0),10),sum=0,weight=[],i,length=value.length;if(first>3){sum=0;weight=[9,1,4,8,3,10,2,5,7,6,1];for(i=0;i<length;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=sum%11;return(sum===3);}else{var day=parseInt(value.substr(0,2),10),month=parseInt(value.substr(2,2),10),year=parseInt(value.substr(4,2),10);year=year+1800+parseInt(value.charAt(6),10)*100;if(!$.fn.bootstrapValidator.helpers.date(year,month,day)){return false;}
sum=0;weight=[10,5,8,4,2,1,6,3,7,9];for(i=0;i<length-1;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=(sum+1)%11%10;return(sum+''===value.charAt(length-1));}},_mt:function(value){if(!/^MT[0-9]{8}$/.test(value)){return false;}
value=value.substr(2);var sum=0,weight=[3,4,6,7,8,9,10,1];for(var i=0;i<8;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
return(sum%37===0);},_nl:function(value){if(!/^NL[0-9]{9}B[0-9]{2}$/.test(value)){return false;}
value=value.substr(2);var sum=0,weight=[9,8,7,6,5,4,3,2];for(var i=0;i<8;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=sum%11;if(sum>9){sum=0;}
return(sum+''===value.substr(8,1));},_no:function(value){if(!/^NO[0-9]{9}$/.test(value)){return false;}
value=value.substr(2);var sum=0,weight=[3,2,7,6,5,4,3,2];for(var i=0;i<8;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=11-sum%11;if(sum===11){sum=0;}
return(sum+''===value.substr(8,1));},_pl:function(value){if(!/^PL[0-9]{10}$/.test(value)){return false;}
value=value.substr(2);var sum=0,weight=[6,5,7,2,3,4,5,6,7,-1];for(var i=0;i<10;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
return(sum%11===0);},_pt:function(value){if(!/^PT[0-9]{9}$/.test(value)){return false;}
value=value.substr(2);var sum=0,weight=[9,8,7,6,5,4,3,2];for(var i=0;i<8;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=11-sum%11;if(sum>9){sum=0;}
return(sum+''===value.substr(8,1));},_ro:function(value){if(!/^RO[1-9][0-9]{1,9}$/.test(value)){return false;}
value=value.substr(2);var length=value.length,weight=[7,5,3,2,1,7,5,3,2].slice(10-length),sum=0;for(var i=0;i<length-1;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=(10*sum)%11%10;return(sum+''===value.substr(length-1,1));},_ru:function(value){if(!/^RU([0-9]{9}|[0-9]{12})$/.test(value)){return false;}
value=value.substr(2);var i=0;if(value.length===10){var sum=0,weight=[2,4,10,3,5,9,4,6,8,0];for(i=0;i<10;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=sum%11;if(sum>9){sum=sum%10;}
return(sum+''===value.substr(9,1));}else if(value.length===12){var sum1=0,weight1=[7,2,4,10,3,5,9,4,6,8,0],sum2=0,weight2=[3,7,2,4,10,3,5,9,4,6,8,0];for(i=0;i<11;i++){sum1+=parseInt(value.charAt(i),10)*weight1[i];sum2+=parseInt(value.charAt(i),10)*weight2[i];}
sum1=sum1%11;if(sum1>9){sum1=sum1%10;}
sum2=sum2%11;if(sum2>9){sum2=sum2%10;}
return(sum1+''===value.substr(10,1)&&sum2+''===value.substr(11,1));}
return false;},_rs:function(value){if(!/^RS[0-9]{9}$/.test(value)){return false;}
value=value.substr(2);var sum=10,temp=0;for(var i=0;i<8;i++){temp=(parseInt(value.charAt(i),10)+sum)%10;if(temp===0){temp=10;}
sum=(2*temp)%11;}
return((sum+parseInt(value.substr(8,1),10))%10===1);},_se:function(value){if(!/^SE[0-9]{10}01$/.test(value)){return false;}
value=value.substr(2,10);return $.fn.bootstrapValidator.helpers.luhn(value);},_si:function(value){if(!/^SI[0-9]{8}$/.test(value)){return false;}
value=value.substr(2);var sum=0,weight=[8,7,6,5,4,3,2];for(var i=0;i<7;i++){sum+=parseInt(value.charAt(i),10)*weight[i];}
sum=11-sum%11;if(sum===10){sum=0;}
return(sum+''===value.substr(7,1));},_sk:function(value){if(!/^SK[1-9][0-9][(2-4)|(6-9)][0-9]{7}$/.test(value)){return false;}
return(parseInt(value.substr(2),10)%11===0);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.vin=$.extend($.fn.bootstrapValidator.i18n.vin||{},{'default':'Please enter a valid VIN number'});$.fn.bootstrapValidator.validators.vin={validate:function(validator,$field,options){var value=$field.val();if(value===''){return true;}
if(!/^[a-hj-npr-z0-9]{8}[0-9xX][a-hj-npr-z0-9]{8}$/i.test(value)){return false;}
value=value.toUpperCase();var chars={A:1,B:2,C:3,D:4,E:5,F:6,G:7,H:8,J:1,K:2,L:3,M:4,N:5,P:7,R:9,S:2,T:3,U:4,V:5,W:6,X:7,Y:8,Z:9,'1':1,'2':2,'3':3,'4':4,'5':5,'6':6,'7':7,'8':8,'9':9,'0':0},weights=[8,7,6,5,4,3,2,10,0,9,8,7,6,5,4,3,2],sum=0,length=value.length;for(var i=0;i<length;i++){sum+=chars[value.charAt(i)+'']*weights[i];}
var reminder=sum%11;if(reminder===10){reminder='X';}
return(reminder+'')===value.charAt(8);}};}(window.jQuery));;(function($){$.fn.bootstrapValidator.i18n.zipCode=$.extend($.fn.bootstrapValidator.i18n.zipCode||{},{'default':'Please enter a valid zip code',countryNotSupported:'The country code %s is not supported',country:'Please enter a valid %s',countries:{CA:'Canadian postal code',DK:'Danish postal code',GB:'United Kingdom postal code',IT:'Italian postal code',NL:'Dutch postal code',SE:'Swiss postal code',SG:'Singapore postal code',US:'US zip code'}});$.fn.bootstrapValidator.validators.zipCode={html5Attributes:{message:'message',country:'country'},COUNTRY_CODES:['CA','DK','GB','IT','NL','SE','SG','US'],validate:function(validator,$field,options){var value=$field.val();if(value===''||!options.country){return true;}
var country=options.country;if(typeof country!=='string'||$.inArray(country,this.COUNTRY_CODES)===-1){country=validator.getDynamicOption($field,country);}
if(!country||$.inArray(country.toUpperCase(),this.COUNTRY_CODES)===-1){return{valid:false,message:$.fn.bootstrapValidator.helpers.format($.fn.bootstrapValidator.i18n.zipCode.countryNotSupported,country)};}
var isValid=false;country=country.toUpperCase();switch(country){case 'CA':isValid=/^(?:A|B|C|E|G|H|J|K|L|M|N|P|R|S|T|V|X|Y){1}[0-9]{1}(?:A|B|C|E|G|H|J|K|L|M|N|P|R|S|T|V|W|X|Y|Z){1}\s?[0-9]{1}(?:A|B|C|E|G|H|J|K|L|M|N|P|R|S|T|V|W|X|Y|Z){1}[0-9]{1}$/i.test(value);break;case 'DK':isValid=/^(DK(-|\s)?)?\d{4}$/i.test(value);break;case 'GB':isValid=this._gb(value);break;case 'IT':isValid=/^(I-|IT-)?\d{5}$/i.test(value);break;case 'NL':isValid=/^[1-9][0-9]{3} ?(?!sa|sd|ss)[a-z]{2}$/i.test(value);break;case 'SE':isValid=/^(S-)?\d{3}\s?\d{2}$/i.test(value);break;case 'SG':isValid=/^([0][1-9]|[1-6][0-9]|[7]([0-3]|[5-9])|[8][0-2])(\d{4})$/i.test(value);break;case 'US':default:isValid=/^\d{4,5}([\-]?\d{4})?$/.test(value);break;}
return{valid:isValid,message:$.fn.bootstrapValidator.helpers.format(options.message||$.fn.bootstrapValidator.i18n.zipCode.country,$.fn.bootstrapValidator.i18n.zipCode.countries[country])};},_gb:function(value){var firstChar='[ABCDEFGHIJKLMNOPRSTUWYZ]',secondChar='[ABCDEFGHKLMNOPQRSTUVWXY]',thirdChar='[ABCDEFGHJKPMNRSTUVWXY]',fourthChar='[ABEHMNPRVWXY]',fifthChar='[ABDEFGHJLNPQRSTUWXYZ]',regexps=[new RegExp('^('+firstChar+'{1}'+secondChar+'?[0-9]{1,2})(\\s*)([0-9]{1}'+fifthChar+'{2})$','i'),new RegExp('^('+firstChar+'{1}[0-9]{1}'+thirdChar+'{1})(\\s*)([0-9]{1}'+fifthChar+'{2})$','i'),new RegExp('^('+firstChar+'{1}'+secondChar+'{1}?[0-9]{1}'+fourthChar+'{1})(\\s*)([0-9]{1}'+fifthChar+'{2})$','i'),new RegExp('^(BF1)(\\s*)([0-6]{1}[ABDEFGHJLNPQRST]{1}[ABDEFGHJLNPQRSTUWZYZ]{1})$','i'),/^(GIR)(\s*)(0AA)$/i,/^(BFPO)(\s*)([0-9]{1,4})$/i,/^(BFPO)(\s*)(c\/o\s*[0-9]{1,3})$/i,/^([A-Z]{4})(\s*)(1ZZ)$/i,/^(AI-2640)$/i];for(var i=0;i<regexps.length;i++){if(regexps[i].test(value)){return true;}}
return false;}};}(window.jQuery));