# Deep Learning accuracy validation framework

#### Usage

You may test your installation and get familiar with accuracy checker by running [sample][sample-readme].

Once you installed accuracy checker you can evaluate your configurations with:

```python
python3 accuracy_check.py -c path/to/configuration_file -m /path/to/models -s /path/to/source/data -a /path/to/annotation
```

All relative paths in config files will be prefixed with values specified in command line:

- `-c, --config` path to configuration file.
- `-m, --models` specifies directory in which models and weights declared in config file will be searched.
- `-s, --source` specifies directory in which input images will be searched.
- `-a, --annotations` specifies directory in which annotation and meta files will be searched.

You may refer to `-h, --help` to full list of command line options. Some optional arguments are:

- `-e, --extensions` directory with InferenceEngine extensions.
- `-b, --bitstreams` directory with bitstream (for Inference Engine with fpga plugin).
- `-C, '--converted_models` directory to store Model Optimizer converted models (used for DLSDK launcher only).
- `-tf, --target_framework` framework for infer.
- `-td, --target_devices` devices for infer. You can specify several devices using space as a delimiter.

#### Configuration

There is config file which declares validation process.
Every validated model has to have its entry in `models` list
with distinct `name` and other properties described below.

There is also definitions file, which declares global options shared across all models.
Config file has priority over definitions file.

example:

```yaml
models:
- name: model_name
  launchers:
    - framework: caffe
      model:   public/alexnet/caffe/bvlc_alexnet.prototxt
      weights: public/alexnet/caffe/bvlc_alexnet.caffemodel
      adapter: classification
      batch: 128
  datasets:
    - name: dataset_name
```

### Launchers

Launcher is a description of how your model should be executed.
Each launcher configuration starts with setting `framework` name. Currently *caffe* and *dlsdk* supported. Launcher description can have differences.

Please view:

- [how to configure Caffe launcher][caffe-launcher-configuration].
- [how to configure DLSDK launcher][dlsdk-launcher-configuration].

### Datasets

Dataset entry describes data on which model should be evaluated,
all required preprocessing and postprocessing/filtering steps,
and metrics that will be used for evaluation.

If your dataset data is a well-known competition problem (COCO, Pascal VOC, ...) and/or can be potentially reused for other models
it is reasonable to declare it in some global configuration file (*definition* file). This way in your local configuration file you can provide only
`name` and all required steps will be picked from global one. To pass path to this global configuration use `--definition` argument of CLI.

Each dataset must have:

- `name` - unique identifier of your model/topology.
- `data_source`: path to directory where input data is stored.
- `metrics`: list of metrics that should be computed.

And optionally:
- `preprocessing`: list of preprocessing steps applied to input data. If you want calculated metrics to match reported, you must reproduce preprocessing from canonical paper of your topology or ask topology author about required steps if it is ICV topology.
- `postprocessing`: list of postprocessing steps.
- `reader`: approach for data reading. You can specify: `opencv_imread` or `pillow_imread` for reading images and `opencv_capture` for reading frames from video. Default reader is `opencv_imread`.

Also it must contain data related to annotation.
You can convert annotation inplace using:
- `annotation_conversion`: parameters for annotation conversion


or use existing annotation file and dataset meta: 
- `annotation` - path to annotation file, you must **convert annotation to representation of dataset problem first**, you may choose one of the converters from *annotation-converters* if there is already converter for your dataset or write your own.
- `dataset_meta`: path to metadata file (generated by converter).
More detailed information about annotation conversion you can find [here][converters]

example of dataset definition:

```yaml
- name: dataset_name
  annotation: annotation.pickle
  data_source: images_folder

  preprocessing:
    - type: resize
      dst_width: 256
      dst_height: 256

    - type: normalization
      mean: imagenet

    - type: crop
      dst_width: 227
      dst_height: 227

  metrics:
    - type: accuracy
```

### Preprocessing, Metrics, Postprocessing

Each entry of preprocessing, metrics, postprocessing must have `type` field,
other options are specific to type. If you do not provide any other option, then it
will be picked from *definitions* file.

You can find useful following instructions:

- [how to use preprocessings][preprocessors].
- [how to use postprocessings][postprocessors].
- [how to use metrics][metrics].

You may optionally provide `reference` field for metric, if you want calculated metric
tested against specific value (i.e. reported in canonical paper).

Some metrics support providing vector results ( e. g. mAP is able to return average precision for each detection class).  You can change view mode for metric results using `presenter` (e.g. `print_vector`, `print_scalar`).

example:

```yaml
metrics:
- type: accuracy
  top_k: 5
  reference: 86.43
  threshold: 0.005
```

### Testing new models

Typical workflow for testing new model include:

1. Convert annotation of your dataset. Use one of the converters from annotation-converters, or write your own if there is no converter for your dataset. You can find detailed instruction how to use converters [here][converters].

```bash
python3 convert_annotation.py converter --converter_specific_parameter --output_dir data/annotations
```

1. Choose one of *adapters* or write your own. Adapter converts raw output produced by framework to high level problem specific representation (e.g. *ClassificationPrediction*, *DetectionPrediction*, etc).
1. Reproduce preprocessing, metrics and postprocessing from canonical paper.
1. Create entry in config file and execute.

[sample-readme]: ./tools/accuracy_checker/sample/README.md
[preprocessors]: ./tools/accuracy_checker/accuracy_checker/preprocessor/README.md
[postprocessors]: ./tools/accuracy_checker/accuracy_checker/postprocessor/README.md
[metrics]: ./tools/accuracy_checker/accuracy_checker/metrics/README.md
[converters]: ./tools/accuracy_checker/accuracy_checker/annotation_converters/README.md
[caffe-launcher-configuration]: ./tools/accuracy_checker/accuracy_checker/launcher/caffe_launcher_readme.md
[dlsdk-launcher-configuration]: ./tools/accuracy_checker/accuracy_checker/launcher/dlsdk_launcher_readme.md
