// Copyright (C) 2018-2019 Intel Corporation
// SPDX-License-Identifier: Apache-2.0
//

#pragma once

#include <string>

#include <vpu/vpu_plugin_config.hpp>

namespace InferenceEngine {
namespace VPUConfigParams {

//
// Main options
//

DECLARE_VPU_CONFIG_KEY(NUMBER_OF_SHAVES);
DECLARE_VPU_CONFIG_KEY(NUMBER_OF_CMX_SLICES);

DECLARE_VPU_CONFIG_KEY(HW_ADAPTIVE_MODE);

DECLARE_VPU_CONFIG_KEY(WATCHDOG);

DECLARE_VPU_CONFIG_KEY(PERF_REPORT_MODE);
DECLARE_VPU_CONFIG_VALUE(PER_LAYER);
DECLARE_VPU_CONFIG_VALUE(PER_STAGE);

//
// Optimizations
//

DECLARE_VPU_CONFIG_KEY(COPY_OPTIMIZATION);
DECLARE_VPU_CONFIG_KEY(HW_INJECT_STAGES);
DECLARE_VPU_CONFIG_KEY(HW_POOL_CONV_MERGE);
DECLARE_VPU_CONFIG_KEY(PACK_DATA_IN_CMX);

//
// Debug options
//

DECLARE_VPU_CONFIG_KEY(DETECT_NETWORK_BATCH);

DECLARE_VPU_CONFIG_KEY(ALLOW_FP32_MODELS);

DECLARE_VPU_CONFIG_KEY(HW_WHITE_LIST);
DECLARE_VPU_CONFIG_KEY(HW_BLACK_LIST);

DECLARE_VPU_CONFIG_KEY(NONE_LAYERS);

DECLARE_VPU_CONFIG_KEY(IGNORE_UNKNOWN_LAYERS);

}  // namespace VPUConfigParams
}  // namespace InferenceEngine
