/*
// Copyright (c) 2016 Intel Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
*/

///////////////////////////////////////////////////////////////////////////////////////////////////
#pragma once
#include "api/CPP/lrn.hpp"
#include "primitive_inst.h"

namespace cldnn
{

using lrn_node = typed_program_node<lrn>;

template <>
class typed_primitive_inst<lrn> : public typed_primitive_inst_base<lrn>
{
    using parent = typed_primitive_inst_base<lrn>;

public:
    static layout calc_output_layout(lrn_node const& node);
    static std::string to_string(lrn_node const& node);

public:
    typed_primitive_inst(network_impl& network, lrn_node const& node);
};

using lrn_inst = typed_primitive_inst<lrn>;

}
