/*
// Copyright (c) 2018 Intel Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
*/

#include "auto_tuner.h"
#include "auto_tuner_offline.h"
namespace kernel_selector 
{
    // SKL GT4e
    void tuning_cache_193B_B1_B16(tuning_data& td)
    {
        td.td.insert({
            { "11207257238719531888", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "12348135936862667024", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "1540041682425757361", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "6949539207944972855", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4197617702037834389", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "13898284586432291433", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3715177305271762194", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "481328129206881674", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "10001963042016663554", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "15471470494305051299", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "14716719350966652036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "13404888565084206853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "1249137685908951501", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "4840004190985490064", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5120466856097219243", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4701832665603867798", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "6181272224000872375", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "2030309697153345387", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "11207257238719531888", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "12348135936862667024", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "1540041682425757361", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "6949539207944972855", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4197617702037834389", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "13898284586432291433", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3715177305271762194", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "481328129206881674", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "10001963042016663554", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "15471470494305051299", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "14716719350966652036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "13404888565084206853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "1249137685908951501", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "4840004190985490064", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5120466856097219243", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4701832665603867798", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "6181272224000872375", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "2030309697153345387", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "10728212277329722684", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "877436308867220589", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18375125668176498051", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14907097142953816744", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2525260242689556544", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 375) },
            { "13328449155966085543", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 373) },
            { "11856266545854830143", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15993427814066246646", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2100891581797371600", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 275) },
            { "12242618640422208652", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6133592828563353516", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 304) },
            { "18232278892738147217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "11992625045241269569", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 298) },
            { "12601126285773042005", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "5079055505117153635", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 195) },
            { "7457899998356343871", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 291) },
            { "6343888265369366589", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 296) },
            { "10791067159964399241", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 309) },
            { "11327097771110264965", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "5245308722062496788", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "10792503079194374004", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 178) },
            { "4818231379191523896", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 288) },
            { "2198278382394812839", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "3800011935243649447", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 298) },
            { "9631545863582097486", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "7777333052643961206", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "1779941298820543013", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "3621930417735246405", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "14435120971846098308", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "2893564501191050837", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "8108843303778211282", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "3682813162987778705", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "15494543914974994991", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "7565221050911842393", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 93) },
            { "5629670679897666607", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "11754316727756881612", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 96) },
            { "10990741293315393791", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "17024388383581997032", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "10302338806536775954", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "7915318733663535312", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "13702692566238948173", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "2909728331855309274", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "13071545223094862275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "9631481972809246378", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "13540002981450186147", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7076937538747704750", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "10290107543739998181", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "6767245864232675168", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9287404618748313247", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8728178019712933221", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "18251360413872841969", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "18271689282126907793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "954796765467489259", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "13597240991532942069", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 178) },
            { "4135003545872878882", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 296) },
            { "11883485911218628865", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "2242915551775617989", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 291) },
            { "10556089809203693400", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "3727142736386026852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "1622880009460832832", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "4437258459981739942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 296) },
            { "14691372262153587653", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "12181607120522804433", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "3159681096461848644", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "6729785110495533200", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "15322019609805777935", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "7024495439434892956", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "10416622008071151225", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 173) },
            { "5796500397424307442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "15702382940521972117", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "6093575518270471235", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "5805383505505929391", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "1801731858063091191", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "1559798212423183813", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 176) },
            { "5594180958505308003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "4766071144928072260", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 177) },
            { "8650948093564284852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "3883845471211207871", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "4366168099274266975", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 171) },
            { "578703329577922869", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "16863960779539003201", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "15450609897480659306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 178) },
            { "8203550467004532364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "7431849514656037251", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "14484890926084856480", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "4424217045094988504", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "7994179151788368291", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "15192024816519005250", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "4747159205186229582", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "5485971317082563152", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "18128162750557822655", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 91) },
            { "12421707187947291166", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "792684262493086891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "941626985322260281", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "11868551452004726281", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "14352303529756685990", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "10702234389482091891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "3895088069642140043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "5334566325056222430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "8306337702797456793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "15720507574336564201", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "3277243911383750280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "18150429561058646714", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "11169292427557543138", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "13933912937625580405", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "1375156980278317418", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13455881643467418059", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12788968383428254917", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "13131740479277027362", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "3390014193205017427", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "1270467775674221667", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14462744723628661203", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "8203171222962341018", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9795194069954915563", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13369603621524676979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "13575423234109624706", std::make_tuple("fully_connected_gpu_yxfb_ref", -1) },
            { "10721885719016335538", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "14567947256029724271", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "10749263296616139689", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "11717348577195224554", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9275303306340702111", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12245096462203481681", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "4999505377862312410", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "15272426400992401555", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "9325097933807426691", std::make_tuple("fully_connected_gpu_bs_f_bsv16_b1", -1) },
            { "18238669114790278675", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "6664482192233202590", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7454366978268164047", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "16135569134646688251", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "10572945270796129630", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "17495198214524203238", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "5221108094913859739", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "1092633914190498221", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "2738256633362038820", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16689586259416414782", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1525652349412826502", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17683302016987200208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 315) },
            { "5615525527388396983", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "3992735701291817771", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13208739898218342989", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "9536348721941264933", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "12803521018213865796", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8854783036772473804", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "6766480740724769248", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "768423629375648579", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "4044100281521441011", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 143) },
            { "873240542570331563", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "12875236165672036211", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "12008819728839685704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "2486645741683554648", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "368578589584714524", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 133) },
            { "301201776306602054", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "13152181652632422771", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "10311747599696543062", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "11258322449556590366", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14095734330183410835", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "14910223536998380801", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "3352689317181436056", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15832740972576959202", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "14732184525012592889", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "8421045774757048067", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 4) },
            { "941232110069825628", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "8975333906619899020", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14800592533315327674", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11816277809167487786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "957781751038897330", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10498289589469975939", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12970943403831707924", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1300292367195167745", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3399837016486623477", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16740871614208968868", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "71587235425438167", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "12717047049023783979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 347) },
            { "10478482486372389470", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6056581247196718403", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3780320160034246719", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "2819320453491169732", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16976464773806576190", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "13321672741246923341", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 264) },
            { "15140532227060261467", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "9400755775406101904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "10292585962794261197", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "13048561902713182858", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "3658425022428447440", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "16947830954662293793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "8397584983137442239", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "1071169341660439058", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "5326247361632903583", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6214194654733781771", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "10025839973092358719", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "16711955423531846725", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "2915165824085219545", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "17108987360340581555", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11972097635078477347", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "16926950874716567095", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "1212319037405620223", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12397280593466519809", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "2609454334520044465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1336940384521633733", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15271783562528081169", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "9533360488591027707", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "6930697835136176263", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "14444423571297570985", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "12643423612381102003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 79) },
            { "18423051691107460439", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 99) },
            { "15381833359831622179", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12040626513219974957", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10647227605517025377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "8127570953237266335", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "12876112384009608387", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "12663860560275361463", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "12352923639732112511", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 79) },
            { "708452703070938673", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "394778201589371681", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2477849395789783501", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11637325834858582585", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1485662490111767875", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "4300306345092124175", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "3402183863499902145", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "3217246278485567748", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 111) },
            { "15713964605078748923", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12293786134765875615", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "16043683538361975370", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10670103699537731664", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "17854578307286932628", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11443268857010762276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "4479117540570599742", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11726298758004767743", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "2968031010495399536", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3797957937905580811", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "1474271081523145413", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8526484907799590618", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "13723543003759101485", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11728824117049687850", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "13268525255152984893", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "14397348576352573007", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "8616686489737649890", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "13176385389367548697", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "14990645740260870030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "7472330881076141262", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "10892456883214928095", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "9522661528867955338", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "17856816245251319111", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "14872992823083730615", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3106591708459602370", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "11609821372586026178", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "7678457226823073886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "10118395047539851751", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "5389189982064081933", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "1742897526168249500", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "15331103261044247142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "6644418194983229139", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "12478309735214802531", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "18012549942299450620", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "11873734271080160669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "10424278617647597641", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "9553032671453999824", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "3860603464276263676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "1207026216972160297", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "9519623751582710696", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "10328182165125764988", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "2231648183489019418", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "17599383258252980421", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "16208488491972128275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "13379165253894817165", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "2566302789609970663", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "1478419046264331178", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "3087801652564627458", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "16103943009195163681", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "14230385851791760020", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15293727142789007900", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "13973179950424276578", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "713121569924250372", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7947870656736319919", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "1663285216972929652", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "14767888121198814523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "2124033349728954551", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "8762901342272872498", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "17006133396401462698", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "10783981060353445280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15110359240685619357", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7875272450497189442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "3281207855459771997", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "11932770338770247767", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15860915170591763391", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "11716771904412649891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "1095495157025479260", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "8402692278765063674", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "509781001842353609", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "3255465741612432300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "13439896617880328331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7134654288295280046", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "6769243149577568817", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "3480732841490521799", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "18269685060032395235", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "15649927926091502215", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "69439315851965666", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "156456996459945842", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "3012566432840424198", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "16431165572426232677", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "6324565723045697080", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "5390559917122707732", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "5469227748156438008", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "17163158934005653629", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "2307310127637739872", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "1999979442136861875", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "2527189070714658176", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "8329846097322076175", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "16783619135298589974", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "12214162812589030126", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "9216608098626790565", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "5179760459095053114", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "2452226948562393335", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "4499586349553581439", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "12668149981216388765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "2287356884312581209", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "11115684531624462986", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "6483208845600234755", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "3752171257634205726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "1774158624592967937", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "16881283637687482989", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "14749947225382670869", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "7351733901977025859", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "435888248913413834", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "13713406612642090169", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "16582132711225619740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "10436819182310112786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "14546281065004619074", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "12558716383635737426", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "12609361477548272638", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "8107447526839063293", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "10995907213890714701", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "4871907623235871050", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "7394217382008802567", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "3880189981766119529", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "3759057398165607194", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "4561874206785244358", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "488298169768725160", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "12956726277674279950", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "7177837234452118325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 2) },
            { "15031155621982459860", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15223164574152266895", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "4834446692898125871", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "14766477690417085350", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "4461989328775275994", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "10141927023849730720", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "10837496380266058422", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "5012013738970489338", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "16839741351990811959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "7846384623429362522", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "9193880745263317167", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "2863465257341735941", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "10447947790216991304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "12024817951074673335", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "13474805373264874144", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "671453551040072499", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "87031578643428011", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "14034525799882831106", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "10864011008000364415", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "5115007207028125638", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "2866656294663853474", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "7913076120244203725", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "15187035463799513424", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "17778091287904736965", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "9562527071055150197", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "10645625090439446714", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "9955939178447682108", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "7450417963648518926", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "6648876837655776653", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "1520529227443340435", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "4455369117448405874", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "2920840796593281126", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "16341722570340169855", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "15289152041466330689", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "14362876471450307424", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "10330180429524641331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "12046017161414846599", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "17228810554159747400", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "14835309921389262864", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "11263540528012919947", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "16139615240471264488", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "3820661057776133570", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "17515847111676784130", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "4252157815622916471", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "4819131094439732065", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "17264010982688979937", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "11277866878590984477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "11324651029379152442", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "13425251102263428554", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "4571404165794634411", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "12279771749366327372", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "5754396201681434378", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "9809458159478958866", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "5459463503840817402", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "6484375582324852109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "7005509036795164602", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "10785966734346479177", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "15363606233048272809", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "4890043345392707202", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "345043289576587800", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "4804533178560338520", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "13328911884191551889", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "13302687772426736346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "15231987838322151865", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "17214254645087272557", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "4849343880559509889", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "851057218719456209", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "331661172067077796", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "3017824560305532066", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "13596876807637507229", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "2242602888499888844", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "13264617841270329349", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "11604794601689380990", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "7770000755097925765", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "5008350851224686853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "12166852830214895457", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "17672785701483179117", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "2439993891369206440", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "15822546325822628634", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "3056212889689424946", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "12712071520541638451", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "6217542346826403576", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "6290584630172122012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "1245259979364728404", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "13006774775034887171", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "3725013268198063198", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "1359720957005310113", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "1354647381212852890", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "10480527638577674825", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "10883992248631603006", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "18255227391100087860", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "13565691057064774487", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7954972694876158422", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "5118467701668427545", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2339864165283480961", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "490931535580183607", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "150132162949295379", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "14795618530175274538", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14126906427006602775", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "905526102343710614", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3385797925880519845", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "16238415425814188039", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7107677063657303327", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "4098191685457418125", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2936333406928424760", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "5539793555189956907", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10106454449619141260", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "5346898505346646714", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11807282628372660280", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "12375919467924385618", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11705756153433897198", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "6651389480007764007", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16911464046178654033", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "12495003066477974474", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7650862961269327235", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "10709828018763273371", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5044721291675005144", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "18427056032084727710", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1390379098099686972", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "12054200116003751590", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9500850790449116723", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 41) },
            { "9057036344533510776", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5093049998173715787", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13761566845514364807", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "1594612401422787491", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14603590053512154268", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "10136369729388564720", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17050675313067213312", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "14221578799010900252", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11723735945517472199", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "13810995219720233595", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2704063557078535883", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "10384537928514123040", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "17427036330773218054", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "9796621763733208035", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "14046114605615338907", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5763440554939527411", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "12892693137085610062", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 355) },
            { "17775705003104146872", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "14878347463243157447", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "7368916076070115064", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "3499109651698979012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "190530884420224257", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "4202645222013675478", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11324851661119942609", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "6232363902828992968", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4299492266819967844", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "9481675228591993785", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11772741918108731396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "18419183012101393192", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17832542092610191859", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "11771014003680394135", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "9192665896782282996", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "9763310312421884308", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 355) },
            { "11430400968543668873", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "3430266954211750407", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7172604084103519563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "10306542963828398049", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "5235375820995365354", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "5091558853871982858", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "12914986936318857086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "2265784112305305260", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "9019388470685749691", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "12427258337646070422", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15884763176333003771", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "7211355951470869591", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15399245700982979379", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "12644942072153919043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "5876880412336151866", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "13775529405693629438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "9048522050692986204", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "10642327923162019888", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "6410682026872155392", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "9454954846682513038", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "16463823433924519300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "7279393739634103483", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "13358283026528078900", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "8032685176029570383", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "949330876419581703", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "17713034180977313726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "472454322186482185", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "2727219457659794468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "7852745450437172519", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "6065819201836017182", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15984885011101717258", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "14811022197918391667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "16146350476627599543", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "16173557782125372935", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "296142385116663420", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "12655099960717366198", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "7937870623766562191", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "9367157746678824712", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "18062849937960759210", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "11919129623429545762", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "10522649794540845800", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "1104489643524273315", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "5419775002149092646", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "9226912483632588371", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "4958222070605478947", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "4479979951990338510", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "12022152681602871455", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "5740738339752793113", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "12087141795291232248", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "17825280904760131680", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "3974589991022739479", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "1838534101161814609", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "10046663998164493552", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "2305461098719675735", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "16504962609450876148", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "6345550009198921347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "11239754372812258455", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "4347816192417741558", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 83) },
            { "17809920600993699808", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "16710010075465723498", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 83) },
            { "17729546848373991614", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "16998508915819714690", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "12952980509662451384", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "2683507674615735878", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "13059207969254830451", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "16295660312557315941", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "14089893422771228191", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "18034648276860485300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "17739868787095417856", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "10880081193716628051", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15916505622570323098", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "9101018613418825655", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "15650839696475698676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "15628121900226431719", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "14554225625951128811", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "3134489458855347772", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "5627834277145735283", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "10729288973933590396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 83) },
            { "10869005786136023160", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "5597908143491399643", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "577182964135927041", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "16947969669087411530", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "861419637283812778", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "3643250372952944907", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "17977676737774695825", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "10309504812060596568", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "8866736221671835567", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "2133849627845285277", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 1) },
            { "13902214851539825156", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "669771152920944125", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16921939234324970069", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "7649413902932043811", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5658664813683907476", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "10071449674652717890", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13352000946213986936", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "5291011077679733990", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1458615259705605525", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "543472136359161929", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4644580321919256401", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "12946531140050029900", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5010119207726811326", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "3308770992373192529", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "16913004986170202203", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4079026972040047969", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "2683304757433993300", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3141886504884887200", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "14444475853714164129", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10747988576436391912", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "2722124265986526212", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "8856888761246057127", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "1902656726461670148", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "3337625924046561031", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "10280619408766255552", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "9695024256541464964", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "6733731409232284409", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "15805087418686802636", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "7056030150365552588", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "13038533272699602337", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "3737576893817599311", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "8761283252495354972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "17549411807772646930", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "13124342334495538095", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "8576733135863336233", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "1082586642383386489", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "3217574161785059951", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "18357544235608006954", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "13954821927253849036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "16158139166784964096", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13558687084677943158", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "13809898858049445969", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16862145184923128012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "693883892843558363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5393510569127725391", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "4533786844080178561", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10128143628088846123", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "5295693108687178880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16425665058951535484", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "1398177377739338750", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7407975398526425554", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "8614534946699754256", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7372956570616880244", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "13676654389512816868", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9043982883185435219", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "1626430741965136732", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15295951849706930711", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "1075027491444288875", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16084700435355748612", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "16698547937652264447", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16729849855476690294", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "14171139920084409181", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4264284648458489052", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "8866716292621164810", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11828175723996627443", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 155) },
            { "11164519756679631743", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5558136691773431495", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "11031569203645035546", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4084026445911476156", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "3819990462129075757", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10055549084854766170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "11657946392097042544", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16768797136991242472", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "12107262410635772120", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "938222258370511187", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "11727227430687227444", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1040650352205493707", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "1563987925712579649", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3870539490799697188", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "13170441257780067955", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17490471699618303993", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "13993548620104010490", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15728009639807698634", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "10991423760161409883", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7242013296950669829", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "11744368351982723504", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7314288062932060863", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "9299299311101549958", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4138968242532400395", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "4135068756462147853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "16247399911710810038", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "6020017927557041768", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "11265472910579659280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "12512751736409465214", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "17015328096102652908", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "14147460733160099960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "10811837819834149164", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "2173867324489962689", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "11198301748997371475", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "9741607635826869269", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "3860667078458481972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "13590444711975157776", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "1551596771935253711", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "632116056424249698", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "3499645386058307669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "10471519687597963116", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 102) },
            { "4429109491655891299", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "9439431829175743345", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "70580716590540876", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "577844026691991089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "3873183249402084406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "15799159401545270696", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "18154019240019929225", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "1569043950563130463", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "4491380839102267034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "9243949750444156746", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "4772696293208603817", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "4927360358387344983", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "5770286476124511234", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "17084977396231597605", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "16800575429414554907", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 10) },
            { "12793908914872030220", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15947699374684516369", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4660288622381620227", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "15914512645931208899", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7460672405409009037", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "1541754036637209097", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "89439319782574517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "14088382963493477342", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "18203935818408469865", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "13191096881934434519", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "7918742312252115870", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "15641537661939240413", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "157805434489791310", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "7941729567451949422", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "10628725059172743408", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "4492673409319122180", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "15857087373591747006", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "13793441296561946357", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "5172712078329324967", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "8780604510524622314", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "1760690277175249985", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "13649894122307008732", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "17546566148752689536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "12675313398314286884", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "14621327324047759584", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "14136097914489095982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "7638626850074132214", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "9399994156762372761", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "18068050257421269408", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "11830297960718214360", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "14959566236432790882", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "16884396694505987920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "17947818179123182001", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "9381304526221508530", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "13932662890258900896", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "8268533335852735248", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "17419874083634480896", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "12773693193167844110", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "5157249499936659040", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "4282661608732125403", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "3159147743553063163", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "1706927777850488363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "9839670675413379092", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "6780215829176686721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "12972634653821069685", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "16129296588866116913", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "18202222342562516071", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "15426960908024585800", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "17026284168840448378", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "18118237182023167949", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "11113256687741667688", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "10555597973766215754", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "17517495652165026573", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "1832310305089212990", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "13855438905855887272", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "15349944413643626251", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "4738743763536059708", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "16611452077660879545", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "8101977280003030465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "2012181953284568566", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "2969389503332309296", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "14515066741400300669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "9373353053843326128", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "10023279637210292010", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "1103204698908514224", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "18092842590142527927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "12174571114411168588", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "14431607479949498164", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "10279778381617181802", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "4237276338897143680", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "8083672466967374860", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "16705621644424684055", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "5352861363832390974", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "16945184617367657570", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "2995134938466176198", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "11706378390483804857", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "7958459862276998225", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "11703557271443535142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "5020788604681810984", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "15217183882858251099", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "10650698451740924172", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "706370730287471796", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "18199526506796726885", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "9269175963143039426", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "3691705516240577130", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "13472532612464340803", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "12388375914105990324", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "11582534256623549131", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "1653274345637156919", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "5893940382830835820", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "17700958439420868719", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "12730339458081890990", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "6631816968511312100", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "7000524935770116969", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "386749666417295495", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "7162575953766465459", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "11398019086259011063", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "3041612155708729812", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "4274801141127703532", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "4865023158176874622", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "18424912460022156378", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "10408322429232132983", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "5277400567128489977", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "6848989271874647093", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "10085059621136526248", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "12962552332511702682", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "751912075185318190", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "4505008254511324231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "4191326605459754690", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "9824678205469832038", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "18245935804520236353", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "12309132521191764927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "12843671306854567956", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "8275277322582733101", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "13698389420396031586", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "12949204491386872217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "7370273921473161914", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "941829593638869991", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "16206791915939407806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "1500571771538985941", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "2095802691829304676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "17542414935564676110", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "12380856644683171627", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "1451466106918423837", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "8071957466247137919", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "11661208196482963286", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "6635217802203685464", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "265124365266629363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "9513032457323269513", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "11814740669468421049", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "5221320470007950766", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "14359530849521980269", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "6181651715051152713", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "1450888744802985214", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "2842103889477438816", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "14006248791647711759", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "7072606962946873975", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "3599823735065658574", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "11311859068168414878", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "17525531790109748810", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "16749148369456398030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "17556238490521153146", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "6067904130482758510", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "1791615587935799399", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "12985650543127289023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "6714886136800883594", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "220326805056361171", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "6777045876155144709", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "9454512817077883797", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "14011124615649605281", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "994489782629179836", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "4338023436590582323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "1152693503778768433", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "5994204139128667921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "17243576882981097341", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "5524218746051008792", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "2669822154816760632", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "7179714714302073459", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "13002363400738122017", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "17006095064160484022", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "13733327241591630239", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 1) },
            { "11942736969933408358", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7869779894480025247", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5735608687257018419", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "4346591404756288097", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "805131056816361237", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "16910952799476896905", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17512961503976896701", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "4773077837537775324", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12193395770362986433", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "5740745357953479527", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9040145293899470160", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "12755692101476964677", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "12467673564660108244", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "7432142107544210174", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "7232326270078161768", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17238880534517721334", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "7235358742317442134", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7548031489690889629", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "5040095338370816349", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "3816674884393241704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "13919204232414535363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "15589007878875898942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "17711453305763476458", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "3501882025888946886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "1171681987783013074", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "17585206779958265260", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "17046662043776372746", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "9208964785762052001", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "4435224497850514394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "16728762255357411770", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "2968439898708528834", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "11845189428639322474", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "16616945998593626851", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "16490405739040977260", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "4974320417566990034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "6428098122005804378", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "17281826959243966826", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "7369903937189508744", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "9111988592015450418", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "9119618606914671839", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "1711220333751274603", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "597650904461183283", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "16888412539296862194", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "3350601287664242323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "9702618600245321109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "17649961873981897621", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "3244675355773468991", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "9340159617983543624", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "10570285542015420072", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "15968821946892330559", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "5509395737020858006", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "3806131437010910920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "4523064418696274869", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "12004552919019936392", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "18313088176414428990", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "5649150695527000655", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "14985755375924972050", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "9441060601228656341", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "11421180829679625737", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "15770767768674603174", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "12055647521556218046", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "17908444616754154471", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "5568753513029409478", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "12417253210787537988", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "4046830923427667342", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "8108933468437926367", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "84595904778810418", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "11756650366229979428", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "1617135706549276688", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "3011188207492335920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "12450814729547235386", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "1157947252370351851", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "5374664689223295796", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "18215430801133520364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "12936220888307335332", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "8746621720912032145", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "12003323477818208825", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "17170858505976681742", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "16566128345135114558", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "15690161340392005765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "60267878504897170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 155) },
            { "3501667344669686338", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "8690196189594920365", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "1930929857644673460", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "9671459469252116568", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "3266557807508325807", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "18041177945345031826", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "18267428053198215471", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "18417288692814472127", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "14031009077471784948", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "11666250400445971335", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "1367483816197881270", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "14248239982355212178", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "15820359925623438341", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "15216108478837665623", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "17489680436564779197", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "14117801387057507639", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "12831123539633580270", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "11337525286386930242", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "8431759922045602848", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "9601412379897937608", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "9152433123828445089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "3118602494449249177", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "5159738930501638535", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "5060012838564094182", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "1905758333157310570", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "6870942166356599956", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "18067291256808591467", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "2826762745628486040", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "11841034668170849494", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "3034482898462686729", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "15838113905712517735", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "9407646138658641974", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15636128989267984459", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "8409488188696700816", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5720964268093705079", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "5922142661777925178", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12900949103593247293", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "13483088320871913126", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13960388312976163971", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "1843555260471832708", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15739278428190392018", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "3868149953087814447", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6845814820599174031", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "6203765709597125063", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12871555773123368130", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "1237920404306733800", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7669403041163460089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "6791806088355877039", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8561261337239934159", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "9580986168276580598", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 268) },
            { "4708035980731751007", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "13734043898517059207", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "3177304125602972370", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "15727611564408173858", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "1632416005093914709", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "12253049204822930675", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "15078168059698267650", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "12522495848240087966", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5074273865983613482", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "11936530628363072904", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7870154008378361670", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "3774285301357006334", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "4848143712599565301", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "10316451248440741901", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "733956743303342862", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "16677044352793659175", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7075659071934895087", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "8803037667261582905", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "12421204749289937399", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "7330202944390548890", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 268) },
            { "10753540518493641553", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "9999425239167488495", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "14001406016806064079", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "7565867291827884997", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "5941298590926032148", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "10130171279527667782", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "17344974951998490453", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "5550969016335082071", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 268) },
            { "3398322619007806698", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "11356842300444410831", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 50) },
            { "2623687018437195679", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "14077148976508649021", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "8272823732258536202", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "2451712485584835395", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "8057302050645780813", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "7430073011895298582", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "5095827462645341808", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15129834325410878425", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "9660812093766156608", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15781622938833984014", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "1089679781525023551", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "6129602738379919488", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "5287076386757143976", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "16076153317792960383", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "2108296560864415762", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "17006655627343469372", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "9404677451270692749", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "1372939511728986224", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "5311718276151327830", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "529543453251381109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15591167992985613695", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15026219694198820614", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "8258382025812748961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "14810839157236175179", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "16117738994809548007", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "659846949368492111", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "5211191663202250117", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "13418701036204748812", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "9714764457768279762", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "17310332946322628458", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15975964562807570772", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "13447028922679236865", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "8337820318779061494", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "18136765667969393174", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "14821616804286068969", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "18386376129938707290", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "16609136488331186895", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "1996860183441418841", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "6491244517639245276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "16312223896859176991", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "17833517350994024381", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "4226968857681929488", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "5141753233513623264", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "6860503758000008398", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "16489624657475712467", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "7862815466573236157", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "10679760989906275129", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "852092858392507925", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "6996376303337512293", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "10978173291465325823", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "6670327979947471550", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "11318913630213187720", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "123251351612308092", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "10784073615329190425", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "2261453441277654139", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "2937907409658060025", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "7852144838267007144", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "4408772370026995920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15411474884532403722", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "9462315044265139531", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "6419580456182610836", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "12277470820821378855", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "16865879032845300007", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "2862999234347597091", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "15447513376965243034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "14420809655798184553", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "12954154886708228545", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "7575634241190730697", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "2344498602308448450", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "4304041922043496030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "10971070835319242371", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "4862529593282936100", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "5312140481706133684", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "15522785615618973614", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "17798636687709019154", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "1938086876393565238", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "11897113890115321056", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "14363654136811880073", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "3928266232090746643", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "15882969506682501496", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 83) },
            { "16426179645101678763", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "18174857480705846286", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "598390166442977699", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "5522698342845820411", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "11559360678008060513", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "13184662326021747000", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "16037141448095945650", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "15094664469997373662", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "822162932339827810", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "2597453794298356435", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15851356529373376076", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "7966454753124154534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "7311120574972466702", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "16461809076899645037", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 1) },
            { "1591199515536783245", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "338716975932676215", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "12165079289914715018", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "348058686961206025", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "17635171685500922207", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "9643408025778914022", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 155) },
            { "5145853681977610916", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "15155676074658242659", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "5269172622193124300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "17037462814585846902", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "10100237101982273901", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "15322609677356616580", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "3399406641489305996", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "10187930930336324253", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "17252589865292797082", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "17922279129043570176", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "6323083153920795679", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "9277176009071334860", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "4313392430539923574", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "10883341041912056319", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "17310409067211414565", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "863057075064640334", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "9131235538209388787", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "12868739680413736657", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "15901724303713479611", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16944335478353845609", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "14025235562200209723", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6556424924189200804", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "14398854364550406668", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6577505360421510286", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "14098811155652990436", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15530407024531326375", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "4466647043226271996", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4121109463284708890", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "7916244303189113815", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12309955719964788034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "10133054058562198093", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6294240435687565243", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "10178145641713631806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7585184325339753737", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "9222744127882324405", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "9542325095876448686", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "8155268141318893606", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "8541982562061181756", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "13472577372534605883", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "15980348884716629349", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "9737565171095493297", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "3622409603053918029", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "5657471280535146301", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "17025324057045572535", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "818998169319147148", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "1680468564927032670", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "14466032674083938714", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "73865742350616903", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "13833960927635646899", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "2783577080556699089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "3563872903821081702", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "4387041763614917736", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "9714508918051740792", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "15412447128995361859", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "5965451243366505522", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "13856271274572142709", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "5156033406916344703", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "1018687388655376483", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "3779229442395464456", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 102) },
            { "13448845356783404653", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "15578456771467281881", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "18302892230881285207", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "9737833587413114584", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "467975197394411990", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "994842991399671507", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "778476198101178556", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "4769003637955328938", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "4914474312076193952", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "4091702228990140696", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "7602222004475424358", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "14544219140091420262", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "4279062247055842367", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 268) },
            { "6603778920476932267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "4959403414256988744", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 226) },
            { "1425953627379976115", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "13477548641580029772", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "1963081583851864291", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "16393176054374397767", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "11132679855317294753", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "16000753982895054944", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "2727175120437582536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "2921118493468368908", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "11626398907755088688", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "3224352307778512793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "7780140599533242850", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "1270307036687208396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "5911282942658469852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "8809017515482311843", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 10) },
            { "11655994466278963438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "6981537186704688907", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "7903891232234389925", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "4229105529069729944", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "12796777049340516563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "14289048840489035546", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "4239133538073498792", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "5103094815475470596", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "8560635685184432720", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "16264774056719724826", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "2571882179292959757", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "16758962840329202004", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "4550028191070279999", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15661322183507404821", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "14650567822254940018", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "3755253206085028904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "8751016391945753900", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "288853243482418538", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "5047419871737940985", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "8819268903800581706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "3746573775462003750", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "16286085532892593349", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "16547425454653232058", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "8195881973746570408", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "7712831597869354170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "17035903590837750750", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "1907439276166837309", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "3036808833459559381", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "17928043901784474130", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "14667209474639064623", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "1701609125136907870", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "2140514316203117958", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "9366201112659847392", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "7808544677773370430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "2251029128552117936", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "9529614587861271730", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "16811402686462277562", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "10554266898346470422", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "7817036102984218692", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "6329618009202266591", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "16936366288366370882", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "8025053805734757314", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "534032316469702287", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "3963106895592011725", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "17994361454416813294", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "14902389080201926109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "3796274347773622633", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "1306339989221885682", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "10900880512948479338", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "287386909600391846", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "17542176922797334839", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "1081962464388501987", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "5831419373611158773", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "3179874645565098825", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "14906458674793172507", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "1934379409955686502", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "10178951466584845110", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "12693511427898130707", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "18137106379929135901", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "11619548409913646265", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "13317417676446624018", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "16710651492402564794", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "10967218651864700933", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "5381578460674280089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "13026555349791486777", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 364) },
            { "11913020016435860608", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "8260130048649729185", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "14133958262039763609", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "5585398540591396124", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "16442107352245114876", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "423221712829930726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "13550435052563656432", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "2440366541074371090", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "8300655194765375060", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "13163146272900339330", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "5406129421969383274", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "15118142492742177336", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "10727592780669452048", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "1076005730007872492", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "13699740641705514374", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "13054405729329143152", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "13503608041359512", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "14385185911482960528", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "11215217005872946038", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "4099859307693687554", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "4408600136502382976", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "3037042229494600258", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "1155389358857780776", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "11461581290174106570", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "16896833230469488924", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "11469881811044037340", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "3003526572122876385", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "14251848023416168295", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "17248756229500447131", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "929378940515745198", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "12962558681443556219", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "4481903208484313806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "13558618754911056302", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "11455518069358829249", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "15890473622821659630", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "6942622405269419082", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "13890118723041457532", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "11292995457386147494", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "5077214229434392730", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "17774424004510360936", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "10412588668458621135", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 1) },
            { "10771803503544737080", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "142650579335909103", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "14116800584981026541", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "12995903177757437362", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "6143200133853000387", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "11893541520830049036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 155) },
            { "6310724136390087834", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "6391201577234440562", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "12058759356433220258", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "17152614235879767116", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "2111669705686676421", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "7333511810266504718", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "7397341452130124383", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "2939605281692583169", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "1644335606100150388", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "2394023805427701338", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "12531580106484042446", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "15586047342916704364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "15779837958180258409", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "14123081378489325832", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "7818381040882768404", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "12510951219501865365", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "6156831095718536092", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "3568514382399560386", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "12065769091972094756", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "5321698540631249776", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "378801963103874857", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "2149582237161177965", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "2770397466252831892", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "3039528482572243879", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "12577421746159122264", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "13553263424160050064", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "4021558014531645922", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "59356084516953804", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "1170380397764345558", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13094402291968806996", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "6713985030102340818", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8354579049246302728", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "13815395589135469450", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13558656230312558247", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "11666226259183201584", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11451740938287179908", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "273242667845386507", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16587061389996963349", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "7119182041840303390", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16292848987976256449", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "16437124655147660375", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2495655464941634884", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "10294610483561043024", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14403132596827435096", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "85050336704401597", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4450409744922989123", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "15528692642731712121", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16661843849495077745", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "852015206582470545", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9813748068195103720", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "10544034939133448916", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "226601879759378771", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "16432425079146486467", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7274179284676568361", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "5184121466994451498", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3538679039078582272", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "9920155432685318259", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8859895010324601937", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "14026537760442360645", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "14349625788399542568", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "15065019229949449623", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "14115742296883450319", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "16748662918272106932", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "2273992727647793692", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "3190494353583341446", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "8837721075413149240", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "2817919813339364130", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "14263790627243107300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "12866217660635921034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "290134020607738418", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "17207560805775399864", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "5245526691775741296", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "4933831571091731212", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "3872151366780051246", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "3541538046227217664", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "16182470664818268848", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "8519354640245415816", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "6222595759158615206", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "7201521533301617290", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "15497797842820949408", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "3219408878901707426", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "2188101366183302888", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "14079654309452583394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "9250410390663336388", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "8787438180071123604", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "11799179287124317845", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 268) },
            { "14206076551739831333", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "9468684953949274635", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "8543619733732987550", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "14159596290442764023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "4378422094110940766", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "8505040075968411726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "10914921540144371519", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "3515437649977762166", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "18035673326929466074", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "9390478179772073718", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "6254141935545262078", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "5955575949957198434", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "5600128039063009632", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "14114380593731243715", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 10) },
            { "10728212277329722684", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "877436308867220589", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18375125668176498051", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6767245864232675168", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9287404618748313247", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8728178019712933221", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "18251360413872841969", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "18271689282126907793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "954796765467489259", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "13597240991532942069", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "5079055505117153635", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "4135003545872878882", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "11883485911218628865", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "2242915551775617989", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "10556089809203693400", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "3727142736386026852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "1622880009460832832", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "4437258459981739942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "14691372262153587653", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "12181607120522804433", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "3159681096461848644", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 287) },
            { "6729785110495533200", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 286) },
            { "15322019609805777935", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "7024495439434892956", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "10416622008071151225", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "5796500397424307442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "15702382940521972117", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "6093575518270471235", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "5805383505505929391", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "1801731858063091191", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "1559798212423183813", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "5594180958505308003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "4766071144928072260", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "8650948093564284852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "3883845471211207871", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "4366168099274266975", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 173) },
            { "578703329577922869", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "16863960779539003201", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "15450609897480659306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "8203550467004532364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "7431849514656037251", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "14484890926084856480", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "7777333052643961206", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "4424217045094988504", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "7994179151788368291", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "15192024816519005250", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "4747159205186229582", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 93) },
            { "5485971317082563152", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "18128162750557822655", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "12421707187947291166", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "792684262493086891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "941626985322260281", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "11868551452004726281", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "14352303529756685990", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "10702234389482091891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "3895088069642140043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "5334566325056222430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "8306337702797456793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "15720507574336564201", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "3277243911383750280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "18150429561058646714", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "11169292427557543138", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "13933912937625580405", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "8792010676469476740", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13190888313721073437", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "9477562342190423343", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "1202292109713947702", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8640150341228170279", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "12757611260347801001", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "7183578232279711009", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8984436655107983227", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16397733032387984819", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16364494883229084045", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "11800783548769329949", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "16065744898134487748", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "15800447082078291243", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "10090036431487700311", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14045927407431718832", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2162882863309264684", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16579057939215877904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "3988024997010367546", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "2066731703492755469", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "13781423818051299677", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5211831143687501130", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6863331059471727622", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6403698142681887543", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7481256533438761028", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "14091610802555875119", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12024143207855886580", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10170577772376890221", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "721174714308243785", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15809639778580769565", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16667887002111125871", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12790570304622911607", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 185) },
            { "8567667881970262923", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "10576856554114055028", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2777318471329665162", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "937159502066696999", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "11087413527078604815", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18186615266760475767", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "3833510944499257797", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "1218323229202187514", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7683334381958571864", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16773645387243701837", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16958329690837977102", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9452470718398027950", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 185) },
            { "16511393582666965704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "3216793152416217495", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18416908414174464784", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5498839261395459224", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12198263593657033426", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "10014448860206587805", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13330734840729670622", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12676167240795292217", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4850497746076450913", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10016815108730511683", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17948637243158994878", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12259844988981080505", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "15078590909693331731", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11988285441493553006", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13851240591038949807", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "16588325081458426169", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8642107585829380438", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6219075471508685758", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10546430708947911124", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "2613462626256090659", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "8295126647635181949", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14213516751025324346", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16509472637458153234", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 166) },
            { "16589607587365212240", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6988674007771237080", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "3448477246688526708", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "8507854696766492454", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "8906588133431586825", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "654122557966242717", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "10196332102593337214", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15831600396403741571", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "17808913959977434594", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "15548971488532746290", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "13468713306678453952", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "13613399861925108148", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 44) },
            { "17802514063213000148", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "13093429681061786539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "12247991248100147706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "14491949194619001237", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 165) },
            { "7590767013583950613", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "13210604117940125947", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 120) },
            { "4670443882075998209", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "2857337999074313592", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "16036386660666696362", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "755414184406250882", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 63) },
            { "12190841837604350271", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "10292243973236220688", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "17793292063552633023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "7605139219344415117", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "787363431787954804", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 120) },
            { "7000486794832106857", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "13608239208821071914", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "17281202179589913619", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "16985912104363932350", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "14744368497944610864", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "3737552767159920174", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 120) },
            { "3792945601873900927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "1364546124782880196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "3689722043202617487", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "2632535010129224704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "10968768803038046390", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "5353552956675518468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "7866128397931438774", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "18233660940545931789", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "11670430946096342056", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "2627779045483019709", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "11066913713501760080", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2552187713769926425", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 41) },
            { "654821507679356726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "7606728651572102823", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "7549378486471456156", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "15410074937424854348", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "15114370307779942381", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2040762223425679479", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "4803370483104261655", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10415046594066474634", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "3441335188113424896", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "9277610800970567810", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17179609670678746034", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8251544171504007740", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1353170363915443814", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14540578324750869319", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13471752029049484143", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9062774198518904260", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17917978116807564183", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3017411837779243878", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12992061224471212714", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13161997040644039778", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "11724225282274130518", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "12822126914959112382", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "9423958333298993923", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "7307271009495440764", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "17746215841755337461", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "3976736548270395981", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "1192279884248226739", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "5538883245745495145", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "1173986078589662704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "11031358859656806724", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 363) },
            { "4238885454989272754", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "8943913562339525413", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "6931953332823066530", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "7799984350284425885", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "14204609663091442879", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "9091110033424983286", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "15829095120243431195", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "3239033622277917802", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 363) },
            { "7578177053220150569", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 363) },
            { "1089944493540593798", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "15529757761327002288", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "18082422341304348326", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "17219920118109316867", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "12026482841341343242", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "3070859615622845671", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "1778345646142852816", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "15188570678726970998", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "4750513665628842598", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "3372770576629463160", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 268) },
            { "2983038203471784211", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "6673966852801136416", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 268) },
            { "8792202318168046223", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "16441830491664937048", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "1419073145594317633", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "17525564757769958678", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "13468081302022888489", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15914058104244750036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 270) },
            { "13760645810144930270", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 219) },
            { "5963901433137582265", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "14668725050395069435", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "12112853999307505628", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "4161612746310931789", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3388752887767453958", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14046990030104971367", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 162) },
            { "16230621843665445228", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "9274179337770060652", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 280) },
            { "5115134711994944288", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "13898821685774165645", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "3007637520820789085", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 109) },
            { "16294825599850364701", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "14681717813022425567", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "4915831715914920982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "12894240573737168362", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "5448537627319798272", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 148) },
            { "14389915292223442327", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "14274685812676150168", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7732899312577293959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "11956435900037329302", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "9263063714383940562", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "5824801192141531089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "5608133987357542077", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "15392077168521832549", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "16446533347502650316", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "14762599606783897222", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "709835724029986012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "1572991986657256775", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "7398196853452900099", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "8140094412609934765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "2659031931257084418", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "4640028527711211109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "18172711677056449158", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "5183231560876991543", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "6821855018718422278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "13237050834496100264", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "7164580481046523192", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 123) },
            { "2490155559809645659", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "15430549683839591544", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "4553409514380460123", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "3041752019114501584", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "4161001033681779582", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "4764776977138392550", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "6882621854468565774", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "8881135571874888085", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "14038261392627717712", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "628191607060767879", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "3511588484597779204", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "6904130543085920483", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 41) },
            { "7924408980408826942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "9416186718345824095", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "14719421757340260468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "11936419502418995274", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "16601702334097258697", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "4800587664660105589", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "12501619443242354860", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7104309382120208659", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2321148334382088982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "4914435717288687793", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "4104562704039821482", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "13308187548669026714", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "3603187029740446600", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7338229552985076723", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2161052921317193579", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6104380778870471127", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "13710319251108632115", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "8096131027165540886", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11823205954749139338", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13403161389559730", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "998876398773540321", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "9280431727790048190", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "1152691534728260611", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "9101903304994333336", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 363) },
            { "142270860894725256", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "621915374938805401", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "15746620724134970969", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "503369896500284129", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "7585785802379042424", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "10486348549691280032", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "5758133252959371492", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "15117880293418979489", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "9120377367517042357", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "4278280309700908015", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "9144487908815767824", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "17408275657360833363", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "11820789223587555410", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "9232653317479846765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "18184621367843960190", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "15059549186302099880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "16765994345605657100", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "9869959062341950047", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "14343008518525689150", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "3202085450628781999", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "17224104246148265328", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7322472892320910654", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "12480527132372884168", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "1008476023750261156", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "12589440296742583335", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "12604104383683210104", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "12782932626966309185", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12946540633035976364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "18221867262301937903", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "10171373375072694210", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "17791024851737594885", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "959260710517842876", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "16988275131627316108", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15048584393463312977", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17381516856910544374", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "5336120047683197088", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15897477855246170861", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9780938731831129283", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1473214668483422172", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17515573322312447679", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "18356980026934328781", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "18077281411861416889", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "2543041530639980505", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 281) },
            { "16370218798911151331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 280) },
            { "17316626950179740845", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "10414903047695486119", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 143) },
            { "2809950092498355574", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 138) },
            { "12011982029561277581", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "11267742746905371769", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "12534001599784153836", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 281) },
            { "1882052795393187384", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 281) },
            { "419783127503173016", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "14211903923555028634", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 138) },
            { "10892706534058849825", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 286) },
            { "2345023488044002149", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "5754844816339228920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 280) },
            { "17015791782274123780", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 280) },
            { "3706994659266083979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "13324157125165576832", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 138) },
            { "12014527187730671229", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "5170245731599664670", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "6854611304056079417", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "1954052357826969119", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "17824431042110985323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "3603706453982734995", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "11992353959766718397", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "15163327502374403643", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "16758697697363920520", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "10930115765550856328", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "14418429155823196539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "1628593159980574595", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 172) },
            { "15675968397825708285", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "9594594523961285945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "6634330132674952638", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "8434794604559592624", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "3150231129728961455", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "12545558125736154584", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "15485701086886851362", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "18005721959893562716", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "490233152678323691", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "4073467095502162430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "5801429077171542466", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "14841539539334726292", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "9404953235624894187", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "17995371099806008878", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "8961138963663532667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "425744529089575241", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "1316444335300814745", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "761169277744593430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "3325727286860556323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "2526832080529662683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "15470013032930986062", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "12255528292506999241", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "13119479079474639169", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "12813978452097969536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "4991419288164762786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "18210370419559876426", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "1616603916015535857", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "9748307611165615848", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11147573971701279689", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "10865695385270390803", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 270) },
            { "11999246609107242706", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4118073384938355655", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "12134858519320245809", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "2930898141522848681", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "4190912926126844643", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "2929190644951986399", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1126499865206906037", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 114) },
            { "13483175684542464385", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "1920070013712913772", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "10787747981914307179", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "7715649642603303319", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "5581428998642936688", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "7532088618116521936", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18126685473408206840", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 114) },
            { "2878824076934639346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "6548949901446632697", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "13609660900720370993", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "883436333317162926", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "16293465561256937726", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4759671642533786591", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "4903592553439092472", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "2581414750854621875", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 171) },
            { "11627532066884923848", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "17983556812075120553", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "9099720270958987421", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "8106738346643994005", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2554991397391195611", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "13121297281694293907", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "8220168481755031959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "14502856487639608696", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "16871004845988227014", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "12015336418727455195", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "1984152634309440563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "14312549767853703411", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "403634422724914329", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "10751536136794650334", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "10135458965276110244", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "2008424849669196225", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "13735180250757239202", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "12351866693978844266", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "6788311046557489996", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "14578867494693499627", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "11158789938857558596", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "9616636708366808604", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 107) },
            { "11069983292783104310", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "708747442142592697", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "2780423409483867058", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "3160543867929843861", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "11305232900158601613", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "12339692995143159283", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "9316082753126682958", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15991460001131903561", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17647962002015093887", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "4897448054295474302", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14184895905338394239", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15112599407339712681", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "10486000767830001094", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "14999920879568237166", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "14799579913711096584", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "6450532136308941035", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "14962768577232034246", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "1452597292381229708", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7104756264011682902", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "7744787957569714828", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "13503688893307029975", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "9133263538092913983", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "1383899865465106141", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "11829442945690098558", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "12394049027081208902", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "12159582810513550491", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "17738299860390552088", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "797387385159110695", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "8757900457181374694", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "6048964584602891448", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "17882819773586674851", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "17829148383265978140", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "14711697456265712456", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "724953082687879224", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "805221045541170643", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "8241070786700614317", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "9191832520273617003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "12408889192918919210", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "4885944395876887711", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "2651385050387738902", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "6303682540621797774", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "905780459938651623", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "4476928353532757380", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "13681462437496627948", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "17243648226968859637", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "11192356850081328892", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "9323825370872655346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "10000618285883395700", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "6418327009347170687", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "8528750110601691390", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "8061914949376516780", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "12992194515157698316", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "17870874477143985774", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "16234606052818596502", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "9148379585489720669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "9270950131920019932", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "17001502418583498926", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "11163107409437069532", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "11465965972527519631", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2534408579674556441", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "18109284647478027063", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9849272539053219052", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "17382660912493284320", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17764033613416389758", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18431306649860116380", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3699344686791530101", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14151747022287993729", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "826850797666395121", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13486084204140096478", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2114599010013594942", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13251091004269229867", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5240706676373148280", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17490188677223978661", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17854208422879910606", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8767817856303586064", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "10672380526821947133", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 342) },
            { "10730222715353420212", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "16683169947375504066", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "2964705957088952872", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "14885031472057965707", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "11308583200952256245", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 336) },
            { "7208008921815475393", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7113777272518482528", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "6334639534663495263", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "10151922632636937118", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "11560634267092054110", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 363) },
            { "15914107501176673997", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "18218755616248669884", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "9987415314864002460", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "7667898603371717971", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "4403753181729432604", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "1040030752340209480", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "760687670112194844", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "9803492989444302959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "216603198215625772", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "10899110544832584656", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "14447191095937730964", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "11130439225010714550", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "4325081100430903742", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "4216958486055161753", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4400247897123856252", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "2294800960010879540", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "5195511638783481084", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "9545968464906009869", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "12932635875905153141", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "16925721317097534009", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "4398371999113956082", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16347412180100581330", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "7877332346656934022", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 289) },
            { "6323026044750482867", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "9761573038170759563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "12098146032672599222", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "1403617451623027879", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "9058996149754556268", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "5864250949922222051", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 287) },
            { "15847413004526420496", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 286) },
            { "3199841714087553410", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "4957638663977636791", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9437794960375526230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "9475130054420979752", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "13312514874803986753", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 304) },
            { "15997754881872769378", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "1941341635794709702", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "10157866834809927320", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "12308359047798183133", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "2986189945936592561", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "6928835003016610382", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "10084794570892043447", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "15417738436777481469", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "18377298651236993830", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7354234812009979811", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "8656468860180713379", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 93) },
            { "14472187692485966933", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "397770940444464146", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "14258499419905714808", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "17599396373608265826", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "12935563359569230797", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "4892959859293355837", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "2802810524370514276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "10290107543739998181", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11587239927319376658", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9076758673133996959", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10432365444137108781", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "13092232276822302626", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "14896875712028630045", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "3236003754884728510", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 286) },
            { "12181889163404078773", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "4856470441452830056", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10022487076451608714", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14811603003184578943", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11565861421381730304", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16577611471466452776", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14616969385577243225", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "17921973525603585874", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4617809377006148936", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "12641170321047008726", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5940337324384948573", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5738835498104275267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "3499106702307464480", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6942016672941874829", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2173720698351153121", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17201365233492366678", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "2877521658768725103", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7689320135952025041", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12031180482028822765", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4717620775314557374", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 268) },
            { "13800760323805415740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "946479876892100082", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "5039037192630609823", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 219) },
            { "13839116996827687373", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17037416417174266088", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2321767794934000238", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "14907097142953816744", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2525260242689556544", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 357) },
            { "13328449155966085543", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 357) },
            { "11856266545854830143", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15993427814066246646", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2100891581797371600", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 370) },
            { "12242618640422208652", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6133592828563353516", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "18232278892738147217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 283) },
            { "11992625045241269569", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 289) },
            { "12601126285773042005", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 289) },
            { "7457899998356343871", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "6343888265369366589", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "10791067159964399241", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11327097771110264965", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "5245308722062496788", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 296) },
            { "10792503079194374004", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "4818231379191523896", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "2198278382394812839", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "3800011935243649447", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "9631545863582097486", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "1779941298820543013", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "3621930417735246405", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "14435120971846098308", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "2893564501191050837", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "8108843303778211282", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "3682813162987778705", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "15494543914974994991", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "7565221050911842393", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "5629670679897666607", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "11754316727756881612", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "10990741293315393791", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "17024388383581997032", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "10302338806536775954", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "7915318733663535312", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "13702692566238948173", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "2909728331855309274", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "13071545223094862275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "9631481972809246378", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13540002981450186147", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "7076937538747704750", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "2041212737963974230", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5308128387928804050", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "8619526128410675593", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "4792351255949877935", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17759505449240263390", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "9584652777232392944", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "9999955037598579164", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "15961487889420208188", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 197) },
            { "541817615957967731", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "13853630125050609175", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "4137755981477177003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "16949056117405140365", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "16014822406751503249", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "7700321970687976931", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "7056293586529818253", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "3814584042139408454", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "16992405636352406660", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17442105631503326136", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9606639214735570069", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7940369586324090841", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 270) },
            { "8444259010311137762", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 269) },
            { "15489746763312425915", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6800893510381991731", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "4156384238797998294", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 185) },
            { "11645116728396933125", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10912495395422146386", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "875400109066360897", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16475247464223458061", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12700372241799686527", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11640225461345567929", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "13183380647506951324", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5242271874488296527", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9488453013746383896", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9726913113016874092", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "15979956159651515122", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "9947449295659685973", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "14230493618724018658", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "1704404203639481753", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10404725818204494388", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9767294641786972359", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "4282668574670785584", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18043340998699622388", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "7148542290597073512", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9040046051053703359", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1077773457856682663", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 143) },
            { "4716188972902735458", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "17343050785312683560", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 219) },
            { "5687802882700097624", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "3524531620118359828", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "5688478347124565305", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "5504757952698692953", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "13800387305792597325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "6574971185849732667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 299) },
            { "10573920781439771673", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 143) },
            { "4992668316921598993", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "15778834188130183853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "3062101811226530720", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "428659495445490820", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "956022649859563080", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "13410850301164057911", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "17423645390621980919", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 288) },
            { "7802311886554362782", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "1172103288112689821", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "17353894529222574441", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "16431857516454692096", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "9100044555742394133", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 170) },
            { "13115589642140732066", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "16190949264253468961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "7026575758396092435", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 173) },
            { "16761856644242716357", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 167) },
            { "6341197991729122563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "17087740929472936216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "10795104632256101599", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "13327653786981478088", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "1096671695414716274", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "10774528268153772208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "9525853014023664813", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "10632020369698615114", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "3234107167862677811", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "8708643228914766202", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "12415368596357091523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "1028160614515220430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "5927467766675317093", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "17742192339816511494", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "11931568365395665142", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "731825454731954517", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15989894214714907271", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "13478984039708550410", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "15773157615731010456", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16772854836230971016", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "2934519615045138808", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "4880150897829846031", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "17889864541794448203", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "11768117585574496387", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17906607354577138153", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 198) },
            { "18270587701371596297", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "18142462471803295391", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "4815047491742617397", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "4513063773753763458", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "2984726467649419856", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "11795826875463204296", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "15675903059949404837", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "15817443774186015593", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "14558572801374416278", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15555083739490354527", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "3854114166348568039", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "3216877571075556066", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "739676584505475609", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 173) },
            { "8303211644727914658", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "12908594497114706897", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "9918371346247634545", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 173) },
            { "10893432143734884603", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "5339985303398206057", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "5941852872160795604", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 108) },
            { "17634966178519099371", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "18299254635579957284", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "13357365044448426880", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "18135307303959376082", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14764715930784496165", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "10979362792894404338", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "15006321421735686121", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "12370729327673204804", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "10722677916294015259", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 219) },
            { "13454265023861566476", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "7995820969034996638", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "5275016494706355806", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "10947686124973711385", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "3349519148124496343", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "4003433148846544263", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "14973431782875808802", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11948858355027908365", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "17951403431757222177", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "6586872365879203192", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "11718418772370938734", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "989564341557094953", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "6942049339361951275", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14555883089089918919", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "14808895254077106198", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13830605041347009953", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "11955992313739654625", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "16921026268702574340", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "15320845027635796583", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4014667229872705228", std::make_tuple("convolution_gpu_bfyx_3x3_dw_opt", 69) },
            { "2438374917504708831", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12391792381149655331", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12864558900883069118", std::make_tuple("convolution_gpu_bfyx_3x3_dw_opt", 69) },
            { "7209217811135076623", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3272017687600371031", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16067605128297748820", std::make_tuple("convolution_gpu_bfyx_3x3_dw_opt", 69) },
            { "14150012830816329527", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16218339663410630711", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2089730611490367290", std::make_tuple("convolution_gpu_bfyx_3x3_dw_opt", 69) },
            { "8907982643256296667", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "804195263636995800", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11528417522960871233", std::make_tuple("convolution_gpu_bfyx_3x3_dw_opt", 69) },
            { "15378025640603637387", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12860222041026638681", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11597391933877736800", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5042176052323856983", std::make_tuple("convolution_gpu_bfyx_3x3_dw_opt", 69) },
            { "17010172246526353957", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "938848188161536107", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "12725647706191463348", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12553441041059632729", std::make_tuple("convolution_gpu_bfyx_3x3_dw_opt", 69) },
            { "12782191856884962803", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15824189967727245909", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16027853590391209100", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5352061583962489055", std::make_tuple("convolution_gpu_bfyx_3x3_dw_opt", 69) },
            { "2294318010381635693", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11055049031355432623", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2349007644347065353", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 111) },
            { "6146876760962332928", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17434429579652310107", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9447458159095730492", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "8655883535274781128", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7272538316511343863", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 225) },
            { "17564338309805484464", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 107) },
            { "7881187047171099732", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15579919505002150556", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "11583017348580874022", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 107) },
            { "17915846724151945664", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "5319668297345215520", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "17208186152576814861", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "3633858263279042265", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "13853056718266488510", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "14759179293743468995", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "16995873636564597028", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "9438739171104456179", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "14429081455612806819", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "9819596940685093690", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "9426665763007611385", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 155) },
            { "794499287296495726", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "4980217316169616839", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "16105073808368936420", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "9530116228032101908", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "8527193566719173253", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16566214123371867456", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 191) },
            { "1470933384474984858", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "10706267011822108376", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "16081386644309102158", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3571959174116404960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "12566041126392848976", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "7603872175048237237", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "18235209540858013173", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "14316077757957132678", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "10816637153861630723", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 226) },
            { "9175450649281374948", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 106) },
            { "17370158297470557151", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "12051595062513871723", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "2967481531952454828", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 108) },
            { "12085348936192462321", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11951606039079763598", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8769060267707904998", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17104611871050967957", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "2103882464623009432", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "2659712601063515059", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "9759380701896779097", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "13842309033760176194", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "2418288192668085805", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14994322266840011040", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16402312692470500253", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16955653765071712611", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "17830290099875088207", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "603883331897298932", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "9731370183088819573", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "2296581485980163665", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "15133468875250992696", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "12972798847556569913", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "17446505012657609153", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "7223801044761006523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "16511749893955141055", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "9485825829394109934", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8130920994920685157", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "3573490922300056520", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "5479761740065152589", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9480653639044390919", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "8739347545059610410", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13459514533473657102", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "7824524940405130010", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17796310681498690253", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14823616678465136590", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "13816104794723484993", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "846088275031979661", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "18125732229366977468", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "8464582977975377118", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "6290317420155851465", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "12696412964119109465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "4994591211723226974", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "1036010477232750453", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "13786357802945430475", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "1003101267609305257", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "14991602704357959545", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "7840653268996892538", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15488340031228619748", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "5003718302026277632", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "7693459946348737411", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "10536316961655703500", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 196) },
            { "10765280349477640969", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "7447163906170805189", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 195) },
            { "9319254979377483709", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7843508201826629532", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16395067736440127496", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13820498543284008286", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12071914115316550349", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "12727541507197887360", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17364712285968437405", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16120988958246503683", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7375461241315602473", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13282951481330978659", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "6181308879301978465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "15488550074426713959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "4062706195708729345", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "11604111639041106489", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 269) },
            { "10512507780534402341", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2128612971571865547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "8594644182487917002", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "15881381297320383917", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "6040286126398028933", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "13926122593957480821", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "6213386558868267629", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4456004887590847716", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9642229389394495047", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "18259656768460999562", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "4983880246908724272", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "7881579844586294503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "5331173521406046122", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "3285520504090196295", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "7143510787416483146", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "18103534417093702556", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "9328223957245552723", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11706446082856895571", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12625112690264223217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2114232149447438823", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13883044928774243663", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "17636500109629107732", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "6192955702438301372", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "13970935346154374605", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "9692654253261175490", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "2116913943188857359", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "12802517759474139810", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "13611054146745413536", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13814086981499638596", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "3106922888635965020", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "10509933181132310969", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "17318287523550546026", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "11806402239500046867", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "12353956380178079089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "875296362957469305", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "14912119584313592912", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12494969618927201911", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "6344802942015047824", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "1692411934657235774", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "615341695338735013", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "10601835610089648700", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "13262672660175739705", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "16522364268583242080", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "18253784177599134876", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 189) },
            { "12319073009094248232", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "9954050478761346921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "4640696923527766618", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "1436052878894538927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "16011429608661242565", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "4381329435655511217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "13972357557211413688", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "13104509059416300615", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "10090923790949378407", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3429844423226609965", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "706049518431331645", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17193614571243427089", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3621424752591567930", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11066930104187448422", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "209732971447020989", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16044646335477470657", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "2172121470071868949", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3392693938352572136", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5495063314176654751", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14553856088069405595", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "4967444801764057340", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "12160764253455777655", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "17723621158215826108", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "2171768477223405739", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12672995204641007004", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 232) },
            { "5622089373755094139", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2129726780118554358", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "4160656836528944651", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11052732052072367261", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "18432787283148809023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "16172528828198474326", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 232) },
            { "16327433707667075261", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2797723586312707948", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "8451212914744825089", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7025975403069487257", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "8913950860101596091", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 357) },
            { "15308578014507211237", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "13132804928635689780", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "4465781406991476376", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 287) },
            { "16266491618150971928", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "181006047500375768", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 286) },
            { "18140951659547259039", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "272730229972987861", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "14898892437285105327", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "17252449599613270108", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "13436376034548670107", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 219) },
            { "13787436604877398090", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 286) },
            { "8873614802459592665", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "13663893159182636270", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "1361159591875955678", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "5912303851874077576", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "16245760498096322525", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "9928406318940388716", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "3036512701943687724", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "5334291640387922287", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "3002986032379998259", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 149) },
            { "16469788155263456039", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8709632541892447149", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9524303276541517389", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9354818521586974021", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16781127329510211966", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6351572488552853754", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "907036267078333137", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11855070245618904113", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "4544242784357021697", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18218631037214746168", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "178353385245384751", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17658152048177750315", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "11636129433022017868", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "2622434279674583815", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14335074487552883436", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11175955260573469979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "2732519635571994212", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 238) },
            { "13893789954946953427", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "4355933224673863178", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18037918102910297531", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "16071723603031305677", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "1697248235682953135", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "7843498978148810586", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 237) },
            { "6767159196241633301", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "5097818987523855112", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6623182990939010641", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6711878663358611849", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "8671491767142900139", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "12164298124869114517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "17089801601582809764", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "75742659105146536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "4652136280940317116", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "9751582946441607796", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "16706244336960642883", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "12581879452540858313", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "17443356777503458523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "939718260623752240", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 280) },
            { "14131851237755716991", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "7474639594232203854", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "14152716242882609401", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "7998930863626763670", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 336) },
            { "10323345824599612614", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 336) },
            { "30229601562833524", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17788367809717898285", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "1509728225855233852", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13139625572508441980", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "16491532291908469567", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "6355395905401306995", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2096779676054335057", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4217179485243909459", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17101789600628162503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "6139574161497189424", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "16559140502701231107", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "11459784003592366395", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "7869916853707978306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            //{ "3889519976910355277", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "12081835728078383819", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "14923692894655929923", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "12794369485239257709", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13338594271376045657", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "677249604491773387", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2668729552208169959", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13011676362747785816", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4678607855896512523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "4356817283284529593", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1885075753696445410", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "17806712457019493207", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "11862259122805366807", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "15201438563802430490", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "8132521728369930959", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16108573960501496757", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11086699387784339943", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 119) },
            { "4013707396889204359", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "11850332373794932468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "14763982961176216679", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 93) },
            { "8207349115037232863", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 93) },
            { "3273748387141431306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "580936360000782237", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "10682918518101379579", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "13178480813522103091", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "17109520309574369561", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13754408679115174221", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "16717713360264747483", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1045854873741563331", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16767392067294252396", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6114241186364821679", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "11241838709529552265", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "15192230303376521834", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "5374969798377773063", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "592245952014430043", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "3114869763557037270", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "11254635684957519432", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "16816222375242496370", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "12809199739984715013", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "5040730152867713388", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "10429613013253088132", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15451919862187018297", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7546586420552408243", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "14487682847898298214", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "3106710091841093202", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "6458124573210430792", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "9182897385081081193", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14462438074931673266", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "18133334552107213128", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "38736266675995457", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "13654816209891478730", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "6263019986730305851", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "12929981792125924963", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "3138374672801504481", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "4465701487417893814", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12977678792503377525", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "10879218241103462088", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2221145174704245189", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4635570915184713874", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16075006181495932250", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3863816884636503247", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5440983284868981549", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15428591250165788477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "16567638487719493784", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "18059267466971880386", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "10808909442136736629", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 363) },
            { "5682190700442712936", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "712165731154577189", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "7469127846325904854", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "5926747396493954633", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "3477539135137665170", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16235115911229280717", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 269) },
            { "17009318615658405230", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9421643783312790618", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "2294026590516781945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 190) },
            { "2940027113687311893", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6090625728451718945", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "5643908654122573882", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 190) },
            { "9065894438656900887", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "11185156002426041243", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "14670068483447729857", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4623542918584461522", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "1143214652021653634", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "1434535531617424039", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "17025268985366223779", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11507538232733291666", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6149673627320838019", std::make_tuple("fully_connected_gpu_bs_f_bsv16_b1", -1) },
            { "16243196137456624852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8059328623525062913", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3662747857062156477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "314054598858070952", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14122213471825630433", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14985236276429954162", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3265415000818832667", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "856877003890134554", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "14805540705424073865", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3788462090984291082", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "2715447739580688669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "7171904645566467208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "10308431308942416781", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8712136292276123857", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "8700574100180128776", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "17147293671640396193", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "16474284418841532356", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12461575861709234385", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "192209423643075326", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "15490478608105402679", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "3491333679577961640", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8176012042686275874", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 109) },
            { "4282198629458668761", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "689445825453914111", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 357) },
            { "969746749329671447", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "16833026567865627676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "13046322179198317310", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "6902644989079870993", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "10987953316324712538", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "12515465135362865565", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "10049571207493913006", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "3926585856863002495", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "11275109735493317886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "12238674883388043717", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "101401523793806394", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11007944497812650617", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "3240102173773280414", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "14883438809987378616", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "13320675959188615441", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11975047184326016230", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2608363732937932266", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15943141845766932879", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "15486917753097743853", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "8317673282128335201", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "10635659193402005820", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "11450378244355788918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "2625969259447793593", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "12207503176295152756", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "4625107584562815965", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "1997392406402548974", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 226) },
            { "2524029454785583409", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "4615708568396290002", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "5349415632630235233", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "16108759090923335184", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11756881293845417212", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "17839839336294937155", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4703107905652287491", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18180820925685532104", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 191) },
            { "3835286851569826052", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7807983899017500046", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "10294185397756053636", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "5519535335798045279", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "8701248964531180496", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "291868903926685441", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "15239764240622554314", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "15963038745470172423", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "11428599290755097395", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "3180320769716158201", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "583303098958523195", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 269) },
            { "3509487327001107638", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2649192407401044065", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7706714181281908433", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15914342421266687768", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1497560475414454618", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13485300684443803732", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "14571022040013651253", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2832268621630415376", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "9383182168277796969", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "16487774205195979355", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "2226745622763268469", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "13809330759308309353", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "11634932044447867039", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "318377908569897093", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7353563160591978243", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "2582625260054352916", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5609922876429907954", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12557015880639217508", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "11528310408333718862", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "1471837664358450291", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7351401242363888463", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "953306082374100275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "15759530339367380982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "13300022131572486202", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15689502054035168040", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "16969463538496570528", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "10237524128771958432", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7969848911698660033", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "7130694811424715594", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "8578747191812631883", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "5197105253412476591", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3120553928584920777", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "4750894407873652809", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "12667014405537239093", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "13644681270630373984", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 364) },
            { "15602218079503030465", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3950738240651133849", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 357) },
            { "9101334153142718004", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15695415285791951018", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15493488989417521388", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "3391032227732782982", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8951040603784899163", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "13804221028705631415", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1351033666248868977", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "11330591026581463934", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6142707387281700290", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16117448559783537844", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "4531222427159927606", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3116068331849795558", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14389719202147508599", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "17053671692908867872", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "17025182465337728023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "15035800097152337587", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16770615142634470903", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "9378269524012289175", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6727930402459775131", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16362857896338778056", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "7187734276051878356", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13253775441326432265", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "14733510474010040334", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3336303478756453360", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16352331970945217438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "13484950419220835364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "4674416595144505741", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14559308665571750465", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4542143431130171516", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "13189392239349392492", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "7009735776703529573", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "4220826666482500445", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14792528369891965810", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "15287650965861631130", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "10308175009371219583", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 166) },
            { "2903605246599054308", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "9213563311267466388", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "5019077257951332016", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "2497756607567197523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "9285566577169147378", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3432296808755992670", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "7688176479120305539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 163) },
            { "8818070832398055086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "8787816339967963727", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 120) },
            { "863952266514375915", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "5835634465164771899", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "15101680837342453931", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "1116274074896622552", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "12790788016297794214", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "13538051178827008933", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "16403423801823379909", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "3723613341885592267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "3830703844770425343", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "40704767167309552", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "13973028408397200796", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "16561224775421968533", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 1) },
            { "11243840588602365090", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "14103112843209793966", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "10483664832302187567", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "8100595788531468781", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "6620782733027313312", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "13526488884846845330", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3534971503826416049", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "10425889533411573166", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5214654427283761256", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13569941893504840630", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "1318571118468536310", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17724604495865223459", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12229574562535756991", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7264274394359484318", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15069906408448814772", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 270) },
            { "11857037689248685487", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "7977195117668583981", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15678385128478075284", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13025361884606488732", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16723478941106779069", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 269) },
            { "726985753660756762", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "586947787345351152", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11418379777288974452", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2575631797904040925", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "6288489890578212082", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5649082203775427830", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8036474422877454869", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 187) },
            { "3711525118850629466", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1875764913306932583", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "548663565933738403", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "17329287216741045059", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11848462434662954749", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "7581174843529024536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "11334122788337402526", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "7868973874302246233", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 109) },
            { "17209528805596238905", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7878605163588288309", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "5941092474669713339", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 109) },
            { "13738760763969959522", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 90) },
            { "11988546375476924356", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 52) },
            { "13680926356824317761", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 41) },
            { "2530317332900569142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "2891736961665476908", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 53) },
            { "18008552719153887303", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 5) },
            { "1299545313185409227", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "17907223570737272640", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "6949539207944972855", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11207257238719531888", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "13898284586432291433", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5120466856097219243", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4197617702037834389", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "1249137685908951501", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "14716719350966652036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "4840004190985490064", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1540041682425757361", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "3715177305271762194", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 120) },
            { "10001963042016663554", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "481328129206881674", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "13404888565084206853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 120) },
            { "12348135936862667024", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "15471470494305051299", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "6181272224000872375", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "4701832665603867798", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "2030309697153345387", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 363) },
            { "15643135666029727865", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18180655791734632264", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12990527753120735255", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5303970743736042689", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1596353239542510685", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "8040001390872143271", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12052207771201936228", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9942099207256025216", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "60509335250891515", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11499219760597131534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 363) },
            { "6726099352298108756", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "597073780328219388", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10783630257421062891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 363) },
            { "6988492019664525206", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 363) },
            { "7132328255408635227", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "4006884370026272807", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13938466156916423478", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 363) },
            { "8689206546467098603", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "5644068493155655611", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4867937397499803072", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "2702144517025248597", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3304589333915676807", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12894625941923144893", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "11649407835105973949", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "4897991181236908768", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "12179581684777023804", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2806529556090896246", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "11327228813412934262", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "5485749317130402302", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3499243120652875549", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "10916647716124396856", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "5749536453225343663", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "789359733867650915", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "12626014184575881530", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "1201692134690347847", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "15249442550355454201", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2598267743388306204", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "7181154048972884375", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10930640103080573253", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "8458082326743351141", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "584086621952390547", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4754967381316623440", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4353842547963164546", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "6131481289104111211", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "517997325935712670", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "5600807544955072308", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "973966345068677905", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "8532217744217419503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "14614844213016502202", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "4126895998426674411", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "9700808806849459216", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "2438261005924916746", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "4056971751486746551", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "8929453032482114162", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "7662200927459001757", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "11473442921040533207", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "388828310152538138", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "1643241486250690844", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "11806105193035393795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8843585527713905568", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "13248567106128518549", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13708979487306970634", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "14406070210216948643", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "15352245788978088971", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "1435153323458789173", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17638692805430115529", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14068780861332616363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "6656593119788274992", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "14695781272831602408", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "15696910741835640150", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15315327794058441258", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7545013298074733778", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "4026686872534942904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "6553736978928374036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "12129572274423886770", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "9723314434598141024", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "11031625790234068916", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "1138439260035360722", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "8323445733669842657", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "54019631544204590", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "8971115542951085891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "4584970211859494304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "9321208819255762521", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "12617625046664709483", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "8264178890341675354", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "5334190564423375247", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "14746359019867963124", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "2044363708106765326", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "5132761922124425835", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "8141428150264829362", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "276407276027553756", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11878734040194151073", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11622925573287101001", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3192332625020432602", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "9785114056964539323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "9410978119783758141", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "12523676912856063091", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5912451559447635837", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "10264913782610095832", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 143) },
            { "10309083227104422150", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "8500148569566077929", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 123) },
            { "6578908625437515675", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "13762042713029963144", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "1561225943337590599", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "10917498758625273194", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "14335423820860953927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "875142032423622622", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 120) },
            { "8965747921518186477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 3) },
            { "4428101657497677982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "5779388310240896974", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11092828091552833150", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 43) },
            { "10295330953350618042", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 5) },
            { "15901675909820977223", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "4894227264080887361", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 1) },
            { "381149736509958403", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 5) },
            { "7962991673727743706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "12725675221990905186", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17961702508543961900", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "7082007579524697455", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1867337342417952506", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8931169575495985034", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16542318967217020315", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10626341369865893888", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9090828337597312855", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13621339501067135142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "13754540732991287617", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "6669808855737023569", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "17640725195881101275", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6928136130626403937", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15047676717402283805", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "1082574490068006980", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "6557428245898292304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "9440117898128288296", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4672441137336208890", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14289082888174784976", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 198) },
            { "5056859994174498686", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "16574710115918192418", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15839295895890205274", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "16307464696265537356", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11910735867274493498", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14671212883301405408", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12028665820838352309", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4773123925616969670", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13602140021189675477", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7708321360699824256", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8609939102588915855", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10782611933832492335", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "8857763129101380288", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1230262279011217327", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14424566003632608852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5497751772699578150", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9541630719145326121", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "10724501418439612080", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "187352687850707150", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3438296636411972401", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4165036357594592683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15106614232165315070", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17477062954520561609", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6664432489777052771", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "3341302541468955849", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11626402549863483301", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "3522383297921565178", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "8651641584737798174", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "12473600360154597915", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "13296242326766100583", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 143) },
            { "12068797674575015662", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "6297802534570892679", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "10037086825900566930", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 143) },
            { "17216583849049249733", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "1287490919205560806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 138) },
            { "738850098651678143", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "7139714914586273766", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 141) },
            { "14050124896329573468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "5429130923188159806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 98) },
            { "7953255701516490034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "6195916781434462809", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "11025471731438443683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 5) },
            { "4622514167765722873", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "14680730265621679042", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "12141300895511301068", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 140) },
            { "17106086048442658788", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12707946849050970702", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 143) },
            { "17154337492545826355", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "10109431802089940590", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "9428176632140441528", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "52089503050497755", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "12297371032753209816", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "659150305191479097", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "2065752819810364738", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "13583166868754499339", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "13991205023798493715", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "8939683514448064461", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "18337160891834020517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "1154228007901031779", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "15156525717629023944", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "7757331094141318304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "16779678846332091086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5409924335138540834", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "4149728557142033774", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "6443517114667332732", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "5419041493176804960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "15948383678216076358", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "9604982746455852556", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "15739274921308457528", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "4642234334824303290", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "13200151444914751729", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "16894871557229780934", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "9933958860597451711", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "17094948685292534952", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "9762182215179534181", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "18273537339378756543", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "7720939595094113814", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "5865480930796299143", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "10058165874008941852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "17309326904418811234", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "5592428580503282095", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "16348402367953880206", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "13607830451968188080", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "9311802150474489673", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "5159470523468873105", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "7975810844103449438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "11455843788148231615", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "1410630713443793537", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "17303408650780384587", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "12069726772532946193", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "6204183474669103812", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "12874626654611400042", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "13546876216568825877", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 122) },
            { "2973436171295280783", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 41) },
            { "1908809004094565452", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "2322559721899919275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 167) },
            { "5766507688771440170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 22) },
            { "16626226341188424071", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "11709992724966310174", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "17222005830854879661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "14224121742920800990", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "1071007164550012186", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6719302427415173754", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 44) },
            { "10482582307328548806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 5) },
            { "407189201971322683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "6531171505861182429", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 4) },
            { "879005904827468163", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 0) },
            { "8460847842045253466", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "10488269059469838160", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "11359409533744011242", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14813178380338948912", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "6307939332939714967", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "10894058425957901202", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "16610284927818475574", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3221469860582147955", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6423785822515265784", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "742689192890486807", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7349880498513046830", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "2369451367723962073", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "11690533591656807605", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9205978149692979955", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2728938624042183713", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2781309272856442321", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "579781312141502576", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "12564687330941036772", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8421388456873652700", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12177387334053203378", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11239541755868028928", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "12776081190690731910", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 170) },
            { "5648658688155716974", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "12213354854947437262", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "5680236635030250712", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "5751283221740229986", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3646228701104397128", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 171) },
            { "13776178598632392721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 172) },
            { "13364676690016875118", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "3141773224039276177", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "16384186388687043048", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 172) },
            { "14421898375873029115", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "8922929126299811091", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "10256831975351722184", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12590922530749026871", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15209909241815414156", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8791285622784082122", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7474592508575297101", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "12068974703657294908", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "10682300249493137042", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "1788455099959676873", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "15225354446874994535", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "3226193790517362610", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "15814015810740458605", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "4129722446574108695", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "18094205332383644037", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "11120846960057008937", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "9195732599757736182", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 140) },
            { "9939234037869927090", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5898740235388207878", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "16694984452720336415", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "4889188980319017094", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "14412158605670555579", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "3463959257726925426", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "15726902746983125797", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "8463615810239412362", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "16531824466148265247", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "3374410641320310726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "9589942627115344216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 101) },
            { "12864204111424196179", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "840202264034382558", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 41) },
            { "16386955278777720573", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "16267682394077585279", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10544411879329675593", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "9835739612255048978", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 6) },
            { "6293403765897901528", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17596685300497748803", std::make_tuple("convolution_gpu_bfyx_3x3_dw_opt", 69) },
            { "2150326211917340956", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1587501521145162454", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7561096442572829049", std::make_tuple("convolution_gpu_bfyx_3x3_dw_opt", 69) },
            { "15078262396281327048", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16383540667048742064", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16820082917500285799", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6820284286806022849", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17285815901490707654", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "994182747184593564", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "6642767323474835034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "3215659303601163167", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "54975980454651672", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "11529876081402974396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "10308113903347312964", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6712698149192186833", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14930789530046665855", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2204178900998688268", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17174919737114915467", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15154700439767512396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "14916625550370402883", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "7650375560336513366", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "9999553425206328238", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "14026570177552137240", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11686670048744589243", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6678796313875454849", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "641417817126876622", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9622546530872848323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9194788897910888066", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "522181557896569275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "3332334993503432420", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16131448347558322280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "15924916465272239832", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11669828823444745889", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "7243917162812988891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "17891499682354369344", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14532519639619315651", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3635446784873718932", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "18275601715050791851", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6997971129340865650", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10722782762733112118", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "6585223640997887253", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6205240287062600210", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 238) },
            { "17522452942286240233", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6571438978296387721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "15511138074959300404", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11107930597263802755", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10320711719466983961", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16884228931101540030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "8253823502854784432", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "6025872155179042054", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "10173283505468233128", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "16094174852600023296", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "11077876432364512822", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "10586018593856542117", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "18436249934780056991", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10179916356323479080", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "1760391741350091665", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "1418595171949196661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "15967614281807823696", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "15329680728165965773", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "8794896449397768269", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "12151068022697708126", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15959543980008442942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "10861769381993948050", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "3316798708399098230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "4734389463002799056", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6911215749850066204", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "18267175011323462494", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "3109104171383198425", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "18136135457402651842", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "11834683513280095384", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4806571630436601566", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14849108908297747749", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "8490260671996115530", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 347) },
            { "2929715823970060874", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "15924583510704449214", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "14331658870024759698", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "6340128090694375876", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "1120455113299469776", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "17268201530818712998", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "3644282167178264526", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "360872770877634346", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16720108310653948550", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14353390922580547467", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9868561386826862471", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17465517455679097501", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "5570311824197099845", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7524311370696987092", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "14070988879848388270", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "8296551195150971668", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14352796912241296357", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9840495023131952174", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4720851194954041037", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "17515064188391421150", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10437367877444543776", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "4362304842016958728", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "383721620126444793", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "138379779469699309", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3759515057574218101", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2856601829807186494", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3286330985102373533", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "8159303545761286685", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "4056979460327024961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "17823133607491820214", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "7969441643457570812", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "970768445746568749", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "13852065717057446998", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4342360467977736802", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16336482874764861478", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6075691042233712335", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7570346182940928159", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12971822824884826169", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3033264172690274208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "17301887391757619741", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "15790005937034794347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "15464327246951632247", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5659168916726488798", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "8079376692609682448", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "15160738482264643601", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "537074122417021898", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "3336076058264596420", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 238) },
            { "1982176363226079588", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "15052577143485630617", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "9314293064351558241", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4958835037528182801", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "6817494598328071314", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14387756025635589673", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "17536308070854915513", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "16027456210394993913", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8655315308767111198", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "4447065688824381344", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6843617687528352801", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17900257435531434807", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16789135236017252073", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13224814158106791463", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5078905972285278557", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4196367396954155354", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7009873605945341897", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7199295899520406795", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16833854122884184025", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 347) },
            { "14599780481362761532", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 348) },
            { "2572395498687401679", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "11810221946429451169", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "18084635102736402756", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "59739211822469868", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "5240181393417899912", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "15962137123591591534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "10989937450490049763", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9798585825695496550", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2362092095402043749", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4444730303823507621", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "487214150851213303", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "745009493367761775", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3806761527342944195", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14458851250685872417", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "7106362077449435105", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "5853697372844744672", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "7603319690872333930", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "4628748977913534701", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "10565371760124443824", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "1972879521448306536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "13893808009363736870", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6584960721513702502", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9220830217525628783", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2235210915304938149", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 190) },
            { "3930314908786112883", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1334070221835422461", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "6681818065741882453", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 189) },
            { "6980201892073961793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "11530101016435264783", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "4801117903303888658", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "5782934278345953016", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "13951717514084457087", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "2721793280965260548", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "8124736388338424498", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "12223993560805441284", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9860570706348640782", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "991586070509079617", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 192) },
            { "7060804814325505165", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "787203599734115483", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "6193161166790398003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "12806934028210472719", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 189) },
            { "7465681710653503161", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "7958443549125799229", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "15548847099740441551", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "16986610822918634530", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "438528596970898721", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15109847707903824859", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "7121708962074176240", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "16789245987103323406", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6318228858846223186", std::make_tuple("convolution_gpu_bfyx_1x1", -1) },
            { "14043770215999952932", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15277856047844308598", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8048617952947915835", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11446745541571732900", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17422822627612865758", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "13954144830230671601", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "11198908896401597838", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 109) },
            { "5582896843095691256", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 109) },
            { "8133587696326295326", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 109) },
            { "2007192658799516915", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "9492402787848610840", std::make_tuple("fully_connected_gpu_bs_f_bsv16_b1", -1) },
            { "10515519878978734341", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "8747430148550634190", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16986358655784856534", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6109013751635776331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9585113116232600562", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "3503893875515897267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "13144385730409574259", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "743941460026466526", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "4492332228252010118", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "1920042803083729276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "16436006771518788093", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "17567504672169904482", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "1989849521691057108", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "16706121580364790904", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5495776091407365966", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16430562172386510259", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5673972310424776040", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8797843396807284399", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1698321314111848001", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "5762290464889692462", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "3218248162832023196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "12988961529988078346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "4232250144427804891", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "11683680166617045816", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "6252429564537528709", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "13145474177271090694", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1208161922424418734", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "2762489653422414995", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "12937333118472722002", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "12917241193304093727", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "11020315012951440351", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "1518270620354036926", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "2567046336192437734", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "16409729623371222748", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "1044978617045366709", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "8473037597903277214", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "14398366949002972908", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "7334966010680206302", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "4161141078006269526", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 226) },
            { "6522575549211855712", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "5629373398445592781", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 315) },
            { "13374993751390784382", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 315) },
            { "12976499206227689731", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "9882204352209412039", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "5041111302824362529", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "13869716373706247686", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6438522646185979880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "2406816735581074778", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "8881150100883636392", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "593712935037568960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 317) },
            { "11970881115757095265", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 319) },
            { "5584432943673435454", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 317) },
            { "4560479630843098090", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15374625876485618845", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 348) },
            { "13102754309439605192", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "17912189681971987483", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "8153567933591966877", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "1604661321386793876", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "8990561333549136048", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "12278364834477923930", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3122997634505472500", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "15669490019428002270", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 270) },
            { "116291934148608396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 270) },
            { "14729854278671832528", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "10591379189397010097", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 237) },
            { "11929531534620071758", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 239) },
            { "1819720745131968914", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10607904718265020949", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "913496537924971856", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 187) },
            { "916389941321470163", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "1411786954276574458", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 357) },
            { "2730604806511016352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 107) },
            { "5843679089588930933", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "7304346312452588844", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "2423754482456771339", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "3653156933813711765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "11149782181562145291", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2653651564133701304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "3526580286148537369", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3985659568982275663", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 371) },
            { "13642146548740074992", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 371) },
            { "5219399418946822456", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14217181622713951411", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "13025323039227543550", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "6114147683777615071", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "2355214244972870639", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 140) },
            { "3167336012388169649", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "12218337369633748663", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 141) },
            { "7264756313770306662", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "10492056481694320580", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "14281201038135286621", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "8127190765748950828", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "142486914279119363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "1532263118203058517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5482851829165191681", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 270) },
            { "10548792624072794724", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "4239415134522959352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "9028970753877215614", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 122) },
            { "2324120381399737261", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "10267260789603562117", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "9988801796928462423", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "12516911293946682547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "9213886570531053949", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 55) },
            { "385046297070779752", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "12541834857357563605", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "475043738497218394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 136) },
            { "6351347283201596793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 93) },
            { "16290626406346691996", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 23) },
            { "4569338575782832784", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7575675354187625951", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "5795073619189010837", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "15123868617509445149", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "5601435819039968726", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14104238386345631681", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17377293745073971167", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "12134712464763856064", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "5524215233998361104", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1103228955716492167", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "8618835732380720921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15908673392788376468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "8482147530539941792", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 299) },
            { "9069334144391048686", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "12493863403516600413", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "16692569816843207989", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 265) },
            { "3438116423688595487", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "15602863681196390535", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "18277685132620834972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "16541722316343690197", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "3067806959725855130", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 136) },
            { "17791773192152464021", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 57) },
            { "13603318842632052764", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 1) },
            { "879896719155824868", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5219048275475447369", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8707189142909022305", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "5948701218437980356", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17050143605017295447", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "8906185843274300447", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "8321769923556905957", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "10433541468308381909", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "10405183426600618231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "14885109535362957947", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "72444706264681262", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 219) },
            { "16818714747882774917", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "16236397968499692493", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "700717277178942679", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "482564204402769504", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "3221221905804708596", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "16467987800266816984", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "11599932445375240727", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "5057534502588100071", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "15640202505592598653", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "3355259926747524578", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "9226443907548972870", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "8104309105061227444", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 138) },
            { "18384657372655350144", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 219) },
            { "13739257060165119132", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 155) },
            { "9810904714798127155", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "15609627722687211129", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "14738573151275130683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "9421927854269492263", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "15962533525948221648", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 138) },
            { "15856268902838573812", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "4085450203909854919", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 194) },
            { "2370837049876630969", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "13464226348405628455", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "12228963567837353733", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "10377729875228238588", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "16362139250976572928", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "5420766967862917815", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 194) },
            { "14578291812739325465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 155) },
            { "18310667924071639899", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "16853250891250756537", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "12990341489637414845", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "14630499010941056793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "878892264408839067", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "9259437778054905599", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 195) },
            { "14974730512607138726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 193) },
            { "3600066510593746268", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "3140230065585683313", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "15891662883560480723", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "11284755586130392759", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "2281119269283845320", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "12246408434917478929", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "13283842370311517843", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 193) },
            { "13753473508578037346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "17123153447808465303", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "10700011669103135203", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "9979259596137305973", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "17225578855755054959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "6471563320494376693", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "8146945902795164796", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "18372284940315010254", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "2194607895573544953", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "1332624116953483870", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "158222105675022402", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "6830387121684699972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "11077503608116183709", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "17847109385592002207", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "13384754476437374504", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "11462462742322068863", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "4265693151382066296", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "11070620435959083971", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "6982733543386888622", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "3563614453014995411", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "3498490999014554104", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "15595549493819416194", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 99) },
            { "14532844474906286088", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "9562291747339451180", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "6772239376357727149", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "10690972785852373520", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 49) },
            { "4488336106517889531", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "10058614204420018541", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 5) },
            { "13865227850818392065", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "14100870590396726248", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "10848277915422577656", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "8121179472578287280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 5) },
            { "2502125887857336825", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 5) },
            { "13192808619929896995", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 4) },
            { "5115661026367632863", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 5) },
            { "12812685418923919055", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 5) },
            { "13131740479277027362", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "15334195300678132907", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "2038505773698938555", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "12090536142661253835", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "4999505377862312410", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "3934290309368153435", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "5951936376654416075", std::make_tuple("fully_connected_gpu_bs_f_bsv16_b1", -1) },
            { "13204120207726209723", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "17108987360340581555", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "4795705973706796563", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "4084106758501882407", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "8127570953237266335", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "7500192998744460131", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "2379484884827231127", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "13933912937625580405", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "2040762223425679479", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "4800587664660105589", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "1616603916015535857", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "10290107543739998181", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "5927467766675317093", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "3349519148124496343", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "13477416097954638887", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "6942049339361951275", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "5303170164698694791", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "12494969618927201911", std::make_tuple("fully_connected_gpu_yxfb_ref", -1) },
            { "7875724726741958520", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "13835908664998757647", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "6407471972820516685", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "5385316497510064491", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "17377315194963069204", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "3889519976910355277", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "12081835728078383819", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14923692894655929923", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "580936360000782237", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "10682918518101379579", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "13178480813522103091", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "6149673627320838019", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11077876432364512822", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "6062246008880097669", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "4806571630436601566", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "2458592904274981909", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "2007192658799516915", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "1051506168926530904", std::make_tuple("fully_connected_gpu_bs_f_bsv16_b1", -1) },
            { "4163359403543480821", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "4232250144427804891", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "5415319660821122528", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "3286629188347536485", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "13575423234109624706", std::make_tuple("fully_connected_gpu_yxfb_ref", -1) },
            { "1841155673858789206", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "6708349666663292171", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "5083163738120585821", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "10572945270796129630", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "4436244774193918646", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "12985942652866621579", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "775538461106687677", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "9533360488591027707", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "8913823292181409151", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "11583985978586657985", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "1485662490111767875", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "11872464450773754851", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "5364060938737428149", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "2613462626256090659", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "14668725050395069435", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "17381516856910544374", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "6450532136308941035", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "2321767794934000238", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "7995820969034996638", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "17951403431757222177", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "1074748462756364699", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "11955992313739654625", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "11939914680143672459", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "17806712457019493207", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "11862259122805366807", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "15201438563802430490", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "5374969798377773063", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "592245952014430043", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "3114869763557037270", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "17147293671640396193", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "6911215749850066204", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "2814805887448339818", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "1120455113299469776", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "8002233052700666718", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "16436006771518788093", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "11083993858285515074", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "4133424990380177132", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "1044978617045366709", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "952318454591754214", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "5762878778443755104", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            });
    }
}