/*
// Copyright (c) 2018 Intel Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
*/

#include "auto_tuner.h"
#include "auto_tuner_offline.h"
namespace kernel_selector 
{
    // KBL GT3e
    void tuning_cache_5927_B1(tuning_data& td)
    {
        td.td.insert({
            { "1375156980278317418", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13455881643467418059", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "12788968383428254917", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13131740479277027362", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "3390014193205017427", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "1270467775674221667", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14462744723628661203", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "8203171222962341018", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9795194069954915563", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13369603621524676979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13575423234109624706", std::make_tuple("fully_connected_gpu_yxfb_ref", -1) },
            { "10721885719016335538", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "14567947256029724271", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "10749263296616139689", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "11717348577195224554", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9275303306340702111", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12245096462203481681", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 138) },
            { "4999505377862312410", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "15272426400992401555", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "9325097933807426691", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "18238669114790278675", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "6664482192233202590", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "7454366978268164047", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "16135569134646688251", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "10572945270796129630", std::make_tuple("fully_connected_gpu_yxfb_ref", -1) },
            { "17495198214524203238", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "5221108094913859739", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "1092633914190498221", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "2738256633362038820", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16689586259416414782", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1525652349412826502", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17683302016987200208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 219) },
            { "5615525527388396983", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "3992735701291817771", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13208739898218342989", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "9536348721941264933", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "12803521018213865796", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "8854783036772473804", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 149) },
            { "6766480740724769248", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 225) },
            { "768423629375648579", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "4044100281521441011", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "873240542570331563", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "12875236165672036211", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "12008819728839685704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "2486645741683554648", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "368578589584714524", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "301201776306602054", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "13152181652632422771", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "10311747599696543062", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "11258322449556590366", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14095734330183410835", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "14910223536998380801", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "3352689317181436056", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "15832740972576959202", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 285) },
            { "14732184525012592889", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 131) },
            { "8421045774757048067", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 3) },
            { "941232110069825628", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "8975333906619899020", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14800592533315327674", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 350) },
            { "11816277809167487786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 350) },
            { "957781751038897330", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10498289589469975939", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12970943403831707924", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 350) },
            { "1300292367195167745", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 350) },
            { "3399837016486623477", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16740871614208968868", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "71587235425438167", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12717047049023783979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 351) },
            { "10478482486372389470", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "6056581247196718403", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3780320160034246719", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "2819320453491169732", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16976464773806576190", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 250) },
            { "13321672741246923341", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "15140532227060261467", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 275) },
            { "9400755775406101904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 250) },
            { "10292585962794261197", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "13048561902713182858", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "3658425022428447440", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 272) },
            { "16947830954662293793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "8397584983137442239", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "1071169341660439058", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 132) },
            { "5326247361632903583", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6214194654733781771", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 340) },
            { "10025839973092358719", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16711955423531846725", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2915165824085219545", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17108987360340581555", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11972097635078477347", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "16926950874716567095", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "1212319037405620223", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12397280593466519809", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "2609454334520044465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "1336940384521633733", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "15271783562528081169", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9533360488591027707", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "6930697835136176263", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "14444423571297570985", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "12643423612381102003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 79) },
            { "18423051691107460439", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "15381833359831622179", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12040626513219974957", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10647227605517025377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8127570953237266335", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "12876112384009608387", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "12663860560275361463", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "12352923639732112511", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 76) },
            { "708452703070938673", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3217246278485567748", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15713964605078748923", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12293786134765875615", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 221) },
            { "16043683538361975370", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10670103699537731664", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "17854578307286932628", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11443268857010762276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 218) },
            { "4479117540570599742", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11726298758004767743", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "2968031010495399536", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3797957937905580811", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 221) },
            { "1474271081523145413", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8526484907799590618", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "13723543003759101485", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11728824117049687850", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "13268525255152984893", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "14397348576352573007", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "8616686489737649890", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 173) },
            { "13176385389367548697", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "14990645740260870030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "7472330881076141262", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "10892456883214928095", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 173) },
            { "9522661528867955338", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "17856816245251319111", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 171) },
            { "14872992823083730615", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "3106591708459602370", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 171) },
            { "11609821372586026178", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "7678457226823073886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "10118395047539851751", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "5389189982064081933", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "1742897526168249500", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "15331103261044247142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 173) },
            { "6644418194983229139", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "12478309735214802531", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 172) },
            { "18012549942299450620", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "11873734271080160669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 172) },
            { "10424278617647597641", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "9553032671453999824", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "3860603464276263676", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1207026216972160297", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "9519623751582710696", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "10328182165125764988", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "2231648183489019418", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "17599383258252980421", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "16208488491972128275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "13379165253894817165", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "2566302789609970663", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "1478419046264331178", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "3087801652564627458", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "16103943009195163681", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "14230385851791760020", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "15293727142789007900", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "13973179950424276578", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "713121569924250372", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "7947870656736319919", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "1663285216972929652", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "14767888121198814523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "2124033349728954551", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "8762901342272872498", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "17006133396401462698", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "10783981060353445280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "15110359240685619357", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "7875272450497189442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "3281207855459771997", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "11932770338770247767", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "15860915170591763391", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "11716771904412649891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "1095495157025479260", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "8402692278765063674", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "509781001842353609", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "3255465741612432300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "13439896617880328331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "7134654288295280046", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "6769243149577568817", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "3480732841490521799", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "18269685060032395235", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "15649927926091502215", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "69439315851965666", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "156456996459945842", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "3012566432840424198", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "16431165572426232677", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "6324565723045697080", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "5390559917122707732", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "5469227748156438008", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "17163158934005653629", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "2307310127637739872", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "1999979442136861875", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "2527189070714658176", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "8329846097322076175", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "16783619135298589974", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "12214162812589030126", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "9216608098626790565", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "5179760459095053114", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "2452226948562393335", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "4499586349553581439", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "12668149981216388765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "2287356884312581209", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "11115684531624462986", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "6483208845600234755", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "3752171257634205726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "1774158624592967937", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "16881283637687482989", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "14749947225382670869", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "7351733901977025859", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "435888248913413834", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "13713406612642090169", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "16582132711225619740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "10436819182310112786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "14546281065004619074", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "12558716383635737426", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "12609361477548272638", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "8107447526839063293", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "10995907213890714701", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "4871907623235871050", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "7394217382008802567", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "3880189981766119529", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "3759057398165607194", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "4561874206785244358", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "488298169768725160", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "12956726277674279950", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "7177837234452118325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 8) },
            { "9057036344533510776", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5093049998173715787", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13761566845514364807", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "1594612401422787491", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14603590053512154268", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "10136369729388564720", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17050675313067213312", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "14221578799010900252", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 309) },
            { "11723735945517472199", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "13810995219720233595", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "2704063557078535883", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "10384537928514123040", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 310) },
            { "17427036330773218054", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "9796621763733208035", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "14046114605615338907", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 373) },
            { "5763440554939527411", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "12892693137085610062", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 373) },
            { "17775705003104146872", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "14878347463243157447", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "7368916076070115064", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "3499109651698979012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 373) },
            { "190530884420224257", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "4202645222013675478", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 374) },
            { "11324851661119942609", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "6232363902828992968", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "4299492266819967844", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "9481675228591993785", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 374) },
            { "11772741918108731396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "18419183012101393192", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 375) },
            { "17832542092610191859", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "11771014003680394135", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "9192665896782282996", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "9763310312421884308", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 375) },
            { "11430400968543668873", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "3430266954211750407", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "7172604084103519563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "10306542963828398049", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "5235375820995365354", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "5091558853871982858", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 374) },
            { "12914986936318857086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "2265784112305305260", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 122) },
            { "9019388470685749691", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "12427258337646070422", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "15884763176333003771", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "7211355951470869591", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "15399245700982979379", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "12644942072153919043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "5876880412336151866", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "13775529405693629438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "9048522050692986204", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "10642327923162019888", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "6410682026872155392", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "9454954846682513038", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "16463823433924519300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "7279393739634103483", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "13358283026528078900", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "8032685176029570383", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "949330876419581703", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "17713034180977313726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "472454322186482185", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "2727219457659794468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "7852745450437172519", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "6065819201836017182", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "15984885011101717258", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "14811022197918391667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "16146350476627599543", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "16173557782125372935", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "296142385116663420", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "12655099960717366198", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "7937870623766562191", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "9367157746678824712", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "18062849937960759210", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "11919129623429545762", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "10522649794540845800", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "1104489643524273315", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "5419775002149092646", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "9226912483632588371", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "4958222070605478947", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "4479979951990338510", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 123) },
            { "12022152681602871455", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "5740738339752793113", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "12087141795291232248", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "17825280904760131680", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "3974589991022739479", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "1838534101161814609", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "10046663998164493552", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "2305461098719675735", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "16504962609450876148", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 374) },
            { "6345550009198921347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "11239754372812258455", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "4347816192417741558", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "17809920600993699808", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "16710010075465723498", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "17729546848373991614", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "16998508915819714690", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "12952980509662451384", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "2683507674615735878", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "13059207969254830451", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "16295660312557315941", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "14089893422771228191", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "18034648276860485300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "17739868787095417856", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "10880081193716628051", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "15916505622570323098", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "9101018613418825655", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "15650839696475698676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "15628121900226431719", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "14554225625951128811", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "3134489458855347772", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "5627834277145735283", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "10729288973933590396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "10869005786136023160", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "5597908143491399643", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "577182964135927041", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "16947969669087411530", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "861419637283812778", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "3643250372952944907", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "17977676737774695825", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "10309504812060596568", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "8866736221671835567", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "2133849627845285277", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "12793908914872030220", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15947699374684516369", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4660288622381620227", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "15914512645931208899", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7460672405409009037", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "1541754036637209097", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "89439319782574517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 315) },
            { "14088382963493477342", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "18203935818408469865", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "13191096881934434519", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 374) },
            { "7918742312252115870", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "15641537661939240413", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "157805434489791310", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 315) },
            { "7941729567451949422", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "10628725059172743408", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4492673409319122180", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "15857087373591747006", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 374) },
            { "13793441296561946357", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "5172712078329324967", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "8780604510524622314", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "1760690277175249985", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 373) },
            { "13649894122307008732", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17546566148752689536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 373) },
            { "12675313398314286884", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "14621327324047759584", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "14136097914489095982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7638626850074132214", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "9399994156762372761", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "18068050257421269408", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "11830297960718214360", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "14959566236432790882", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "16884396694505987920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "17947818179123182001", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 374) },
            { "9381304526221508530", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "13932662890258900896", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "8268533335852735248", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17419874083634480896", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 374) },
            { "12773693193167844110", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "5157249499936659040", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "4282661608732125403", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "3159147743553063163", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "1706927777850488363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "9839670675413379092", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "6780215829176686721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "12972634653821069685", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "16129296588866116913", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "18202222342562516071", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "15426960908024585800", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "17026284168840448378", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "18118237182023167949", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "11113256687741667688", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "10555597973766215754", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "17517495652165026573", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "1832310305089212990", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "13855438905855887272", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "15349944413643626251", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "4738743763536059708", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "16611452077660879545", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "8101977280003030465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "2012181953284568566", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "2969389503332309296", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "14515066741400300669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "9373353053843326128", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "10023279637210292010", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "1103204698908514224", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "18092842590142527927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "12174571114411168588", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "14431607479949498164", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "10279778381617181802", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "4237276338897143680", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "8083672466967374860", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "16705621644424684055", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "5352861363832390974", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "16945184617367657570", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "2995134938466176198", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "11706378390483804857", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "7958459862276998225", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "11703557271443535142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "5020788604681810984", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "15217183882858251099", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "10650698451740924172", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "706370730287471796", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "18199526506796726885", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "9269175963143039426", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "3691705516240577130", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "13472532612464340803", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "12388375914105990324", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "11582534256623549131", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "1653274345637156919", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "5893940382830835820", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "17700958439420868719", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "12730339458081890990", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "6631816968511312100", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "7000524935770116969", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "386749666417295495", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7162575953766465459", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "11398019086259011063", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "3041612155708729812", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "4274801141127703532", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "4865023158176874622", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "18424912460022156378", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "10408322429232132983", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "5277400567128489977", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "6848989271874647093", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "10085059621136526248", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "12962552332511702682", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "751912075185318190", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "4505008254511324231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4191326605459754690", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "9824678205469832038", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "18245935804520236353", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "12309132521191764927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 374) },
            { "12843671306854567956", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "8275277322582733101", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "13698389420396031586", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "12949204491386872217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "7370273921473161914", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "941829593638869991", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "16206791915939407806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "1500571771538985941", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 83) },
            { "2095802691829304676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "17542414935564676110", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "12380856644683171627", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "1451466106918423837", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "8071957466247137919", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "11661208196482963286", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "6635217802203685464", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "265124365266629363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "9513032457323269513", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "11814740669468421049", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "5221320470007950766", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "14359530849521980269", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "6181651715051152713", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "1450888744802985214", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "2842103889477438816", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "14006248791647711759", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "7072606962946873975", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "3599823735065658574", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "11311859068168414878", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "17525531790109748810", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "16749148369456398030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "17556238490521153146", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "6067904130482758510", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "1791615587935799399", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "12985650543127289023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "6714886136800883594", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "220326805056361171", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "6777045876155144709", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "9454512817077883797", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "14011124615649605281", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "994489782629179836", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "4338023436590582323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "1152693503778768433", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "5994204139128667921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "17243576882981097341", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "5524218746051008792", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "2669822154816760632", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "7179714714302073459", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 83) },
            { "13002363400738122017", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "17006095064160484022", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "13733327241591630239", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "2623687018437195679", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "14077148976508649021", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 123) },
            { "8272823732258536202", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "2451712485584835395", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "8057302050645780813", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "7430073011895298582", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "5095827462645341808", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "15129834325410878425", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "9660812093766156608", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "15781622938833984014", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 123) },
            { "1089679781525023551", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "6129602738379919488", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "5287076386757143976", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 122) },
            { "16076153317792960383", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "2108296560864415762", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "17006655627343469372", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "9404677451270692749", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 122) },
            { "1372939511728986224", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "5311718276151327830", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "529543453251381109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 122) },
            { "15591167992985613695", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 122) },
            { "15026219694198820614", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "8258382025812748961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 123) },
            { "14810839157236175179", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "16117738994809548007", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "659846949368492111", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "5211191663202250117", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "13418701036204748812", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "9714764457768279762", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "17310332946322628458", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "15975964562807570772", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "13447028922679236865", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "8337820318779061494", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "18136765667969393174", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "14821616804286068969", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "18386376129938707290", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "16609136488331186895", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "1996860183441418841", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "6491244517639245276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "16312223896859176991", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "17833517350994024381", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "4226968857681929488", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "5141753233513623264", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "6860503758000008398", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "16489624657475712467", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "7862815466573236157", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "10679760989906275129", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "852092858392507925", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "6996376303337512293", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "10978173291465325823", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "6670327979947471550", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "11318913630213187720", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "123251351612308092", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "10784073615329190425", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "2261453441277654139", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "2937907409658060025", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "7852144838267007144", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "4408772370026995920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "15411474884532403722", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "9462315044265139531", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "6419580456182610836", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "12277470820821378855", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "16865879032845300007", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "2862999234347597091", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "15447513376965243034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "14420809655798184553", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "12954154886708228545", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "7575634241190730697", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "2344498602308448450", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "4304041922043496030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "10971070835319242371", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "4862529593282936100", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "5312140481706133684", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "15522785615618973614", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "17798636687709019154", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "1938086876393565238", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "11897113890115321056", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "14363654136811880073", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "3928266232090746643", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "15882969506682501496", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "16426179645101678763", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "18174857480705846286", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "598390166442977699", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "5522698342845820411", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "11559360678008060513", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "13184662326021747000", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "16037141448095945650", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "15094664469997373662", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "822162932339827810", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "2597453794298356435", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "15851356529373376076", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "7966454753124154534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "7311120574972466702", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "16461809076899645037", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 2) },
            { "11655994466278963438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "6981537186704688907", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "7903891232234389925", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "4229105529069729944", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "12796777049340516563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "14289048840489035546", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "4239133538073498792", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "5103094815475470596", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "8560635685184432720", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "16264774056719724826", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "2571882179292959757", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "16758962840329202004", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "4550028191070279999", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "15661322183507404821", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "14650567822254940018", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "3755253206085028904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "8751016391945753900", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "288853243482418538", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "5047419871737940985", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "8819268903800581706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "3746573775462003750", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "16286085532892593349", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "16547425454653232058", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "8195881973746570408", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "7712831597869354170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "17035903590837750750", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "1907439276166837309", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "3036808833459559381", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "17928043901784474130", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 122) },
            { "14667209474639064623", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "1701609125136907870", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "2140514316203117958", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "9366201112659847392", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "7808544677773370430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "2251029128552117936", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "9529614587861271730", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "16811402686462277562", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "10554266898346470422", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "7817036102984218692", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "6329618009202266591", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "16936366288366370882", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "8025053805734757314", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "534032316469702287", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "3963106895592011725", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "17994361454416813294", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "14902389080201926109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "3796274347773622633", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "1306339989221885682", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "10900880512948479338", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "287386909600391846", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "17542176922797334839", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "1081962464388501987", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "5831419373611158773", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "3179874645565098825", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "14906458674793172507", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "1934379409955686502", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "10178951466584845110", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "12693511427898130707", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "18137106379929135901", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "11619548409913646265", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "13317417676446624018", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "16710651492402564794", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "10967218651864700933", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "5381578460674280089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "13026555349791486777", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "11913020016435860608", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "8260130048649729185", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "14133958262039763609", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "5585398540591396124", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "16442107352245114876", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "423221712829930726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "13550435052563656432", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "2440366541074371090", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "8300655194765375060", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "13163146272900339330", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "5406129421969383274", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "15118142492742177336", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "10727592780669452048", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "1076005730007872492", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "13699740641705514374", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "13054405729329143152", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "13503608041359512", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "14385185911482960528", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "11215217005872946038", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "4099859307693687554", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "4408600136502382976", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "3037042229494600258", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "1155389358857780776", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "11461581290174106570", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "16896833230469488924", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "11469881811044037340", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "3003526572122876385", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "14251848023416168295", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "17248756229500447131", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "929378940515745198", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "12962558681443556219", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "4481903208484313806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "13558618754911056302", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "11455518069358829249", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "15890473622821659630", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "6942622405269419082", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "13890118723041457532", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "11292995457386147494", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "5077214229434392730", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "17774424004510360936", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "10412588668458621135", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 2) },
            { "7334966010680206302", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4161141078006269526", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 278) },
            { "6522575549211855712", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5629373398445592781", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "13374993751390784382", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 317) },
            { "12976499206227689731", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "9882204352209412039", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "5041111302824362529", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "13869716373706247686", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6438522646185979880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "2406816735581074778", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "8881150100883636392", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 350) },
            { "593712935037568960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "11970881115757095265", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 318) },
            { "5584432943673435454", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 316) },
            { "4560479630843098090", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 344) },
            { "15374625876485618845", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 318) },
            { "13102754309439605192", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 350) },
            { "17912189681971987483", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 350) },
            { "8153567933591966877", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "1604661321386793876", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "8990561333549136048", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "12278364834477923930", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 300) },
            { "3122997634505472500", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "15669490019428002270", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "116291934148608396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "14729854278671832528", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "10591379189397010097", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 237) },
            { "11929531534620071758", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 300) },
            { "1819720745131968914", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 361) },
            { "10607904718265020949", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "913496537924971856", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "916389941321470163", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "1411786954276574458", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2730604806511016352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 139) },
            { "5843679089588930933", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 140) },
            { "7304346312452588844", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "2423754482456771339", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3653156933813711765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "10728212277329722684", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "877436308867220589", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18375125668176498051", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6767245864232675168", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9287404618748313247", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8728178019712933221", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "18251360413872841969", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "18271689282126907793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "954796765467489259", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "13597240991532942069", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "5079055505117153635", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 194) },
            { "4135003545872878882", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 317) },
            { "11883485911218628865", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "2242915551775617989", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "10556089809203693400", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 292) },
            { "3727142736386026852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "1622880009460832832", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "4437258459981739942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 315) },
            { "14691372262153587653", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "12181607120522804433", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "3159681096461848644", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "6729785110495533200", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 288) },
            { "15322019609805777935", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "7024495439434892956", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 197) },
            { "10416622008071151225", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 138) },
            { "5796500397424307442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "15702382940521972117", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "6093575518270471235", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "5805383505505929391", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "1801731858063091191", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "1559798212423183813", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 176) },
            { "5594180958505308003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "4766071144928072260", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "8650948093564284852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "3883845471211207871", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "4366168099274266975", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "578703329577922869", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 176) },
            { "16863960779539003201", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "15450609897480659306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "8203550467004532364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "7431849514656037251", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "14484890926084856480", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 178) },
            { "7777333052643961206", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "4424217045094988504", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "7994179151788368291", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "15192024816519005250", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "4747159205186229582", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 97) },
            { "5485971317082563152", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "18128162750557822655", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "12421707187947291166", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "792684262493086891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "941626985322260281", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "11868551452004726281", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "14352303529756685990", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "10702234389482091891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "3895088069642140043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "5334566325056222430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "8306337702797456793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "15720507574336564201", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "3277243911383750280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "18150429561058646714", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "11169292427557543138", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "13933912937625580405", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "8295126647635181949", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14213516751025324346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "16509472637458153234", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "16589607587365212240", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "6988674007771237080", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "3448477246688526708", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "8507854696766492454", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 172) },
            { "8906588133431586825", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "654122557966242717", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "10196332102593337214", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "15831600396403741571", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "17808913959977434594", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "15548971488532746290", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "13468713306678453952", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "13613399861925108148", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "17802514063213000148", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "13093429681061786539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "12247991248100147706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "14491949194619001237", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "7590767013583950613", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "13210604117940125947", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "4670443882075998209", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "2857337999074313592", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "16036386660666696362", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "755414184406250882", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 129) },
            { "12190841837604350271", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "10292243973236220688", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "17793292063552633023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "7605139219344415117", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "787363431787954804", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "7000486794832106857", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "13608239208821071914", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "17281202179589913619", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "16985912104363932350", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 131) },
            { "14744368497944610864", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "3737552767159920174", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "3792945601873900927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "1364546124782880196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "3689722043202617487", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "2632535010129224704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "10968768803038046390", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "5353552956675518468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "7866128397931438774", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "18233660940545931789", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "11670430946096342056", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "2627779045483019709", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11066913713501760080", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2552187713769926425", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "654821507679356726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "7606728651572102823", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "7549378486471456156", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "15410074937424854348", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15114370307779942381", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2040762223425679479", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "12112853999307505628", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4161612746310931789", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3388752887767453958", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "14046990030104971367", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "16230621843665445228", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "9274179337770060652", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "5115134711994944288", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "13898821685774165645", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "3007637520820789085", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "16294825599850364701", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "14681717813022425567", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "4915831715914920982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "12894240573737168362", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "5448537627319798272", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "14389915292223442327", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "14274685812676150168", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "7732899312577293959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "11956435900037329302", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "9263063714383940562", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "5824801192141531089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 131) },
            { "5608133987357542077", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "15392077168521832549", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "16446533347502650316", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "14762599606783897222", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "709835724029986012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "1572991986657256775", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "7398196853452900099", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "8140094412609934765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "2659031931257084418", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "4640028527711211109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "18172711677056449158", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "5183231560876991543", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "6821855018718422278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 132) },
            { "13237050834496100264", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "7164580481046523192", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "2490155559809645659", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "15430549683839591544", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "4553409514380460123", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3041752019114501584", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "4161001033681779582", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "4764776977138392550", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "6882621854468565774", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "8881135571874888085", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "14038261392627717712", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "628191607060767879", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3511588484597779204", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6904130543085920483", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "7924408980408826942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "9416186718345824095", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "14719421757340260468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "11936419502418995274", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16601702334097258697", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4800587664660105589", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "5336120047683197088", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15897477855246170861", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9780938731831129283", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "1473214668483422172", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17515573322312447679", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "18356980026934328781", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "18077281411861416889", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "2543041530639980505", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "16370218798911151331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 287) },
            { "17316626950179740845", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 139) },
            { "10414903047695486119", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "2809950092498355574", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 155) },
            { "12011982029561277581", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 287) },
            { "11267742746905371769", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "12534001599784153836", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "1882052795393187384", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "419783127503173016", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 139) },
            { "14211903923555028634", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 155) },
            { "10892706534058849825", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 287) },
            { "2345023488044002149", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "5754844816339228920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 292) },
            { "17015791782274123780", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 288) },
            { "3706994659266083979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 172) },
            { "13324157125165576832", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "12014527187730671229", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 143) },
            { "5170245731599664670", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "6854611304056079417", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "1954052357826969119", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "17824431042110985323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "3603706453982734995", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 178) },
            { "11992353959766718397", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 178) },
            { "15163327502374403643", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "16758697697363920520", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 172) },
            { "10930115765550856328", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "14418429155823196539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "1628593159980574595", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "15675968397825708285", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "9594594523961285945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 178) },
            { "6634330132674952638", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "8434794604559592624", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "3150231129728961455", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "12545558125736154584", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "15485701086886851362", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 178) },
            { "18005721959893562716", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 178) },
            { "490233152678323691", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "4073467095502162430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "5801429077171542466", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 93) },
            { "14841539539334726292", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "9404953235624894187", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 92) },
            { "17995371099806008878", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "8961138963663532667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "425744529089575241", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "1316444335300814745", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "761169277744593430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "3325727286860556323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "2526832080529662683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "15470013032930986062", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "12255528292506999241", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "13119479079474639169", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "12813978452097969536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "4991419288164762786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "18210370419559876426", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "1616603916015535857", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14962768577232034246", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "1452597292381229708", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7104756264011682902", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "7744787957569714828", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "13503688893307029975", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "9133263538092913983", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1383899865465106141", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "11829442945690098558", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "12394049027081208902", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "12159582810513550491", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "17738299860390552088", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "797387385159110695", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8757900457181374694", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "6048964584602891448", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "17882819773586674851", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "17829148383265978140", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "14711697456265712456", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "724953082687879224", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "805221045541170643", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "8241070786700614317", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 131) },
            { "9191832520273617003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "12408889192918919210", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "4885944395876887711", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "2651385050387738902", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "6303682540621797774", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "905780459938651623", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "4476928353532757380", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "13681462437496627948", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "17243648226968859637", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "11192356850081328892", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "9323825370872655346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "10000618285883395700", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "6418327009347170687", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "8528750110601691390", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "8061914949376516780", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "12992194515157698316", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "17870874477143985774", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "16234606052818596502", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "9148379585489720669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 98) },
            { "9270950131920019932", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "17001502418583498926", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "11163107409437069532", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "11465965972527519631", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2534408579674556441", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "18109284647478027063", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9849272539053219052", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "17382660912493284320", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7877332346656934022", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "6323026044750482867", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "9761573038170759563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "12098146032672599222", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 315) },
            { "1403617451623027879", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "9058996149754556268", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "5864250949922222051", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15847413004526420496", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 143) },
            { "3199841714087553410", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "4957638663977636791", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9437794960375526230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 319) },
            { "9475130054420979752", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "13312514874803986753", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 317) },
            { "15997754881872769378", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "1941341635794709702", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "10157866834809927320", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "12308359047798183133", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "2986189945936592561", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "6928835003016610382", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "10084794570892043447", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "15417738436777481469", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "18377298651236993830", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7354234812009979811", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 102) },
            { "8656468860180713379", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14472187692485966933", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 101) },
            { "397770940444464146", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "14258499419905714808", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "17599396373608265826", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "12935563359569230797", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "4892959859293355837", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "2802810524370514276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 225) },
            { "10290107543739998181", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14907097142953816744", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2525260242689556544", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13328449155966085543", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11856266545854830143", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15993427814066246646", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "2100891581797371600", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 221) },
            { "12242618640422208652", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "6133592828563353516", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 306) },
            { "18232278892738147217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "11992625045241269569", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 298) },
            { "12601126285773042005", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 298) },
            { "7457899998356343871", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 198) },
            { "6343888265369366589", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 315) },
            { "10791067159964399241", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 309) },
            { "11327097771110264965", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "5245308722062496788", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 312) },
            { "10792503079194374004", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "4818231379191523896", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "2198278382394812839", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "3800011935243649447", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "9631545863582097486", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "1779941298820543013", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "3621930417735246405", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "14435120971846098308", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 176) },
            { "2893564501191050837", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "8108843303778211282", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "3682813162987778705", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "15494543914974994991", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "7565221050911842393", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 90) },
            { "5629670679897666607", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "11754316727756881612", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 98) },
            { "10990741293315393791", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "17024388383581997032", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "10302338806536775954", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "7915318733663535312", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "13702692566238948173", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "2909728331855309274", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "13071545223094862275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "9631481972809246378", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "13540002981450186147", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7076937538747704750", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "18043340998699622388", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7148542290597073512", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "9040046051053703359", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1077773457856682663", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4716188972902735458", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17343050785312683560", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 218) },
            { "5687802882700097624", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3524531620118359828", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 138) },
            { "5688478347124565305", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 291) },
            { "5504757952698692953", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 288) },
            { "13800387305792597325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 288) },
            { "6574971185849732667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 155) },
            { "10573920781439771673", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "4992668316921598993", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 292) },
            { "15778834188130183853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "3062101811226530720", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 176) },
            { "428659495445490820", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "956022649859563080", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "13410850301164057911", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "17423645390621980919", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "7802311886554362782", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "1172103288112689821", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "17353894529222574441", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "16431857516454692096", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "9100044555742394133", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "13115589642140732066", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "16190949264253468961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "7026575758396092435", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "16761856644242716357", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 90) },
            { "6341197991729122563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 195) },
            { "17087740929472936216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "10795104632256101599", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "13327653786981478088", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "1096671695414716274", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "10774528268153772208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "9525853014023664813", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "10632020369698615114", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "3234107167862677811", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "8708643228914766202", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "12415368596357091523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "1028160614515220430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "5927467766675317093", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "5275016494706355806", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "10947686124973711385", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 54) },
            { "3349519148124496343", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "4003433148846544263", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "11718418772370938734", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 89) },
            { "989564341557094953", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "6942049339361951275", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14555883089089918919", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "15320845027635796583", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4014667229872705228", std::make_tuple("convolution_gpu_bfyx_3x3_dw_opt", 68) },
            { "2438374917504708831", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3272017687600371031", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16067605128297748820", std::make_tuple("convolution_gpu_bfyx_3x3_dw_opt", 69) },
            { "14150012830816329527", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "804195263636995800", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11528417522960871233", std::make_tuple("convolution_gpu_bfyx_3x3_dw_opt", 69) },
            { "15378025640603637387", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12860222041026638681", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 285) },
            { "12725647706191463348", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12553441041059632729", std::make_tuple("convolution_gpu_bfyx_3x3_dw_opt", 68) },
            { "12782191856884962803", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15824189967727245909", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11149782181562145291", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "2653651564133701304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "3526580286148537369", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3985659568982275663", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "13642146548740074992", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "2349007644347065353", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6146876760962332928", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17434429579652310107", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9447458159095730492", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "8655883535274781128", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7272538316511343863", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17564338309805484464", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "7881187047171099732", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15579919505002150556", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "11583017348580874022", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "17915846724151945664", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 221) },
            { "5319668297345215520", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 129) },
            { "17208186152576814861", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "3633858263279042265", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "13853056718266488510", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "14759179293743468995", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 226) },
            { "16995873636564597028", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9438739171104456179", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 226) },
            { "14429081455612806819", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "9819596940685093690", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12085348936192462321", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11951606039079763598", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 350) },
            { "8769060267707904998", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17104611871050967957", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "2103882464623009432", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "2659712601063515059", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "9759380701896779097", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 350) },
            { "13842309033760176194", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "2418288192668085805", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14994322266840011040", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16402312692470500253", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16955653765071712611", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 344) },
            { "8739347545059610410", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13459514533473657102", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 350) },
            { "7824524940405130010", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17796310681498690253", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14823616678465136590", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "13816104794723484993", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "846088275031979661", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "18125732229366977468", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "8464582977975377118", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "6290317420155851465", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "12696412964119109465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "4994591211723226974", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 225) },
            { "1036010477232750453", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "13786357802945430475", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "1003101267609305257", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14991602704357959545", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "6181308879301978465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "15488550074426713959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "4062706195708729345", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "8594644182487917002", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "15881381297320383917", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "6040286126398028933", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "13926122593957480821", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "6213386558868267629", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4456004887590847716", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9642229389394495047", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "18259656768460999562", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "4983880246908724272", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 344) },
            { "7881579844586294503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "5331173521406046122", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "3285520504090196295", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "7143510787416483146", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "13104509059416300615", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "10090923790949378407", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3429844423226609965", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "706049518431331645", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17193614571243427089", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3621424752591567930", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11066930104187448422", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "209732971447020989", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16044646335477470657", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "2172121470071868949", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3392693938352572136", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5495063314176654751", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14553856088069405595", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "4967444801764057340", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "12160764253455777655", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 237) },
            { "17723621158215826108", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2171768477223405739", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12672995204641007004", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5622089373755094139", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2129726780118554358", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "4160656836528944651", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "11052732052072367261", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "18432787283148809023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "16172528828198474326", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16327433707667075261", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2797723586312707948", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 355) },
            { "8451212914744825089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 370) },
            { "7025975403069487257", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "8913950860101596091", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "15308578014507211237", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "13132804928635689780", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4465781406991476376", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "16266491618150971928", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 373) },
            { "181006047500375768", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "18140951659547259039", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 375) },
            { "272730229972987861", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "14898892437285105327", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "17252449599613270108", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "13436376034548670107", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 371) },
            { "13787436604877398090", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "8873614802459592665", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 373) },
            { "13663893159182636270", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 319) },
            { "1361159591875955678", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 312) },
            { "5912303851874077576", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16245760498096322525", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "9928406318940388716", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "3036512701943687724", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "5334291640387922287", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "3002986032379998259", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "16469788155263456039", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8709632541892447149", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "9524303276541517389", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9354818521586974021", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "16781127329510211966", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "6351572488552853754", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "907036267078333137", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11855070245618904113", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "4544242784357021697", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18218631037214746168", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "178353385245384751", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 226) },
            { "17658152048177750315", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "11636129433022017868", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 216) },
            { "2622434279674583815", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 363) },
            { "14335074487552883436", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11175955260573469979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "2732519635571994212", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13893789954946953427", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 119) },
            { "4355933224673863178", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "18037918102910297531", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "16071723603031305677", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "1697248235682953135", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "7843498978148810586", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6767159196241633301", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 116) },
            { "5097818987523855112", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6623182990939010641", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6711878663358611849", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "8671491767142900139", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "12164298124869114517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "17089801601582809764", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "75742659105146536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "4652136280940317116", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "9751582946441607796", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "16706244336960642883", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12581879452540858313", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "17443356777503458523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "939718260623752240", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14131851237755716991", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 218) },
            { "7474639594232203854", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "14152716242882609401", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7998930863626763670", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "10323345824599612614", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "30229601562833524", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17788367809717898285", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "1509728225855233852", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13139625572508441980", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "16491532291908469567", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "6355395905401306995", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2096779676054335057", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4217179485243909459", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 373) },
            { "17101789600628162503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6139574161497189424", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16559140502701231107", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "11459784003592366395", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "7869916853707978306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "3889519976910355277", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "12081835728078383819", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14923692894655929923", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "8132521728369930959", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16108573960501496757", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11086699387784339943", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "4013707396889204359", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 107) },
            { "11850332373794932468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 107) },
            { "14763982961176216679", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "8207349115037232863", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "3273748387141431306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "580936360000782237", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "10682918518101379579", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "13178480813522103091", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "11254635684957519432", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "16816222375242496370", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "12809199739984715013", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "5040730152867713388", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "10429613013253088132", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15451919862187018297", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7546586420552408243", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "14487682847898298214", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "3106710091841093202", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "6458124573210430792", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "9182897385081081193", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14462438074931673266", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "18133334552107213128", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "38736266675995457", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "13654816209891478730", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "6263019986730305851", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "12929981792125924963", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "3138374672801504481", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "17009318615658405230", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9421643783312790618", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "2294026590516781945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "2940027113687311893", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6090625728451718945", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "5643908654122573882", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "9065894438656900887", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "11185156002426041243", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "14670068483447729857", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4623542918584461522", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "1143214652021653634", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1434535531617424039", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "17025268985366223779", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "11507538232733291666", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "6149673627320838019", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "16474284418841532356", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12461575861709234385", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "192209423643075326", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15490478608105402679", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 216) },
            { "3491333679577961640", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8176012042686275874", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "4282198629458668761", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "689445825453914111", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "969746749329671447", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "16833026567865627676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "13046322179198317310", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "6902644989079870993", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "10987953316324712538", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "12515465135362865565", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "10049571207493913006", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 226) },
            { "3926585856863002495", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11275109735493317886", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12238674883388043717", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "16108759090923335184", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11756881293845417212", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "17839839336294937155", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4703107905652287491", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18180820925685532104", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "3835286851569826052", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7807983899017500046", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "10294185397756053636", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "5519535335798045279", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "8701248964531180496", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "291868903926685441", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 373) },
            { "15239764240622554314", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "15963038745470172423", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "11428599290755097395", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "3180320769716158201", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "583303098958523195", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 225) },
            { "318377908569897093", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7353563160591978243", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "2582625260054352916", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5609922876429907954", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12557015880639217508", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "11528310408333718862", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "1471837664358450291", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7351401242363888463", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "953306082374100275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "15759530339367380982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "13300022131572486202", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15689502054035168040", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "16969463538496570528", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 351) },
            { "10237524128771958432", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7969848911698660033", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "7130694811424715594", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "8578747191812631883", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 351) },
            { "5197105253412476591", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3120553928584920777", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "4750894407873652809", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12667014405537239093", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "13644681270630373984", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 374) },
            { "7187734276051878356", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13253775441326432265", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "14733510474010040334", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "3336303478756453360", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16352331970945217438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "13484950419220835364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "4674416595144505741", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "14559308665571750465", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4542143431130171516", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "13189392239349392492", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "7009735776703529573", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "4220826666482500445", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "14792528369891965810", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15287650965861631130", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "10308175009371219583", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "2903605246599054308", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "9213563311267466388", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5019077257951332016", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2497756607567197523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "9285566577169147378", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3432296808755992670", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "7688176479120305539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 166) },
            { "8818070832398055086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8787816339967963727", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "863952266514375915", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 141) },
            { "5835634465164771899", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "15101680837342453931", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 16) },
            { "1116274074896622552", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "12790788016297794214", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "13538051178827008933", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "16403423801823379909", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "3723613341885592267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "3830703844770425343", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "40704767167309552", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "13973028408397200796", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "16561224775421968533", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 43) },
            { "11243840588602365090", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 3) },
            { "14103112843209793966", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 5) },
            { "10483664832302187567", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 5) },
            { "8100595788531468781", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6620782733027313312", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 2) },
            { "6949539207944972855", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11207257238719531888", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "13898284586432291433", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "5120466856097219243", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4197617702037834389", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 291) },
            { "1249137685908951501", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "14716719350966652036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4840004190985490064", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1540041682425757361", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "3715177305271762194", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "10001963042016663554", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "481328129206881674", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "13404888565084206853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "12348135936862667024", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "15471470494305051299", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "6181272224000872375", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "4701832665603867798", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "2030309697153345387", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 373) },
            { "5644068493155655611", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4867937397499803072", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "2702144517025248597", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3304589333915676807", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12894625941923144893", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 357) },
            { "11649407835105973949", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "4897991181236908768", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 191) },
            { "12179581684777023804", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2806529556090896246", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "11327228813412934262", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "5485749317130402302", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "3499243120652875549", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "10916647716124396856", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "5749536453225343663", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "789359733867650915", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "12626014184575881530", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "1201692134690347847", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "5219399418946822456", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 302) },
            { "14217181622713951411", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 300) },
            { "13025323039227543550", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "6114147683777615071", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "2355214244972870639", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 152) },
            { "3167336012388169649", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 155) },
            { "12218337369633748663", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "7264756313770306662", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "10492056481694320580", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "14281201038135286621", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "8127190765748950828", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "142486914279119363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "1532263118203058517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "5482851829165191681", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 270) },
            { "10548792624072794724", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4239415134522959352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 250) },
            { "9028970753877215614", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 131) },
            { "2324120381399737261", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "10267260789603562117", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "9988801796928462423", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "12516911293946682547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "9213886570531053949", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 53) },
            { "385046297070779752", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 155) },
            { "12541834857357563605", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "11709992724966310174", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 121) },
            { "17222005830854879661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "475043738497218394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 139) },
            { "1071007164550012186", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "6719302427415173754", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "10482582307328548806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 3) },
            { "6351347283201596793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 96) },
            { "6531171505861182429", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 4) },
            { "879005904827468163", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16290626406346691996", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "4569338575782832784", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7575675354187625951", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 350) },
            { "5795073619189010837", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "15123868617509445149", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "5601435819039968726", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14104238386345631681", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17377293745073971167", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "12134712464763856064", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "5524215233998361104", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1103228955716492167", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "8618835732380720921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 350) },
            { "15908673392788376468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 264) },
            { "8482147530539941792", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 269) },
            { "9069334144391048686", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "12493863403516600413", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "16692569816843207989", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "3438116423688595487", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "15602863681196390535", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "18277685132620834972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 152) },
            { "16541722316343690197", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "875142032423622622", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 123) },
            { "8965747921518186477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 3) },
            { "3067806959725855130", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 137) },
            { "5779388310240896974", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11092828091552833150", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "10295330953350618042", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 5) },
            { "17791773192152464021", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 96) },
            { "4894227264080887361", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 1) },
            { "381149736509958403", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 5) },
            { "13603318842632052764", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "8929453032482114162", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "7662200927459001757", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "11473442921040533207", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "388828310152538138", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "1643241486250690844", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "11806105193035393795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "8843585527713905568", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13248567106128518549", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "13708979487306970634", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "14406070210216948643", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "15352245788978088971", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "1435153323458789173", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "17638692805430115529", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "14068780861332616363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "6656593119788274992", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "14695781272831602408", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "15696910741835640150", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 348) },
            { "15315327794058441258", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "7545013298074733778", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "4026686872534942904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 140) },
            { "6553736978928374036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "12129572274423886770", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "9723314434598141024", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "11031625790234068916", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "1138439260035360722", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8323445733669842657", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "54019631544204590", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8971115542951085891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "4584970211859494304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9321208819255762521", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "12617625046664709483", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "8264178890341675354", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "5334190564423375247", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14746359019867963124", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2044363708106765326", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5132761922124425835", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "8141428150264829362", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "276407276027553756", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11878734040194151073", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11622925573287101001", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3192332625020432602", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "9785114056964539323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "9410978119783758141", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "12523676912856063091", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5912451559447635837", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 133) },
            { "10264913782610095832", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10309083227104422150", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 136) },
            { "8500148569566077929", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "6578908625437515675", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 23) },
            { "13762042713029963144", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1561225943337590599", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "10917498758625273194", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "14335423820860953927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4428101657497677982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "15901675909820977223", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "7962991673727743706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 2) },
            { "12141300895511301068", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 139) },
            { "17106086048442658788", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12707946849050970702", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17154337492545826355", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "10109431802089940590", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "9428176632140441528", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "52089503050497755", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "12297371032753209816", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "659150305191479097", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "2065752819810364738", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "13583166868754499339", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "13991205023798493715", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "8939683514448064461", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "18337160891834020517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "1154228007901031779", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "15156525717629023944", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "7757331094141318304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "16779678846332091086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "5409924335138540834", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "4149728557142033774", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "6443517114667332732", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "5419041493176804960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "15948383678216076358", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "9604982746455852556", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "15739274921308457528", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "4642234334824303290", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "13200151444914751729", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "16894871557229780934", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "9933958860597451711", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "17094948685292534952", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 178) },
            { "9762182215179534181", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "18273537339378756543", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "7720939595094113814", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "5865480930796299143", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 176) },
            { "10058165874008941852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 176) },
            { "17309326904418811234", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 176) },
            { "5592428580503282095", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "16348402367953880206", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "13607830451968188080", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 171) },
            { "9311802150474489673", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 173) },
            { "5159470523468873105", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 171) },
            { "7975810844103449438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "11455843788148231615", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "1410630713443793537", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "17303408650780384587", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 176) },
            { "12069726772532946193", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "6204183474669103812", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 136) },
            { "12874626654611400042", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "13546876216568825877", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "2973436171295280783", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "1908809004094565452", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "2322559721899919275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "5766507688771440170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 53) },
            { "16626226341188424071", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "14224121742920800990", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "407189201971322683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "8460847842045253466", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 5) },
            { "879896719155824868", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "5219048275475447369", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8707189142909022305", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "5948701218437980356", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17050143605017295447", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "8906185843274300447", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "8321769923556905957", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "10433541468308381909", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "10405183426600618231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "14885109535362957947", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 216) },
            { "72444706264681262", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "16818714747882774917", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "16236397968499692493", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "700717277178942679", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "482564204402769504", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "3221221905804708596", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "16467987800266816984", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 216) },
            { "11599932445375240727", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "5057534502588100071", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "15640202505592598653", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "3355259926747524578", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "9226443907548972870", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "8104309105061227444", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "18384657372655350144", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 218) },
            { "13739257060165119132", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "9810904714798127155", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "15609627722687211129", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "14738573151275130683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "9421927854269492263", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "15962533525948221648", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "15856268902838573812", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 195) },
            { "4085450203909854919", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 178) },
            { "2370837049876630969", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "13464226348405628455", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "12228963567837353733", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "10377729875228238588", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 197) },
            { "16362139250976572928", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 195) },
            { "5420766967862917815", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "14578291812739325465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 268) },
            { "18310667924071639899", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "16853250891250756537", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "12990341489637414845", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "14630499010941056793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "878892264408839067", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 268) },
            { "9259437778054905599", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "14974730512607138726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "3600066510593746268", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 268) },
            { "3140230065585683313", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "15891662883560480723", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "11284755586130392759", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 132) },
            { "2281119269283845320", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 196) },
            { "12246408434917478929", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "13283842370311517843", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "13753473508578037346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "17123153447808465303", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "10700011669103135203", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "9979259596137305973", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "17225578855755054959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "6471563320494376693", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "8146945902795164796", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "18372284940315010254", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "2194607895573544953", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "1332624116953483870", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "158222105675022402", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "6830387121684699972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "11077503608116183709", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "17847109385592002207", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "13384754476437374504", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "11462462742322068863", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "4265693151382066296", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "11070620435959083971", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "6982733543386888622", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3563614453014995411", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "3498490999014554104", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "15595549493819416194", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 111) },
            { "14532844474906286088", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "9562291747339451180", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "6772239376357727149", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10690972785852373520", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 166) },
            { "4488336106517889531", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "10058614204420018541", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 3) },
            { "13865227850818392065", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "14100870590396726248", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "10848277915422577656", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 43) },
            { "8121179472578287280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 5) },
            { "2502125887857336825", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "13192808619929896995", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 4) },
            { "5115661026367632863", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 5) },
            { "12812685418923919055", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 5) },
            { "6293403765897901528", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17596685300497748803", std::make_tuple("convolution_gpu_bfyx_3x3_dw_opt", 69) },
            { "2150326211917340956", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "530491406341772040", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15197248015210313435", std::make_tuple("convolution_gpu_bfyx_3x3_dw_opt", 69) },
            { "2816353973187452604", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16383540667048742064", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "16820082917500285799", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6820284286806022849", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17285815901490707654", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "994182747184593564", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "6642767323474835034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "3215659303601163167", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 350) },
            { "54975980454651672", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 350) },
            { "11529876081402974396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "14026570177552137240", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "11686670048744589243", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "6678796313875454849", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "641417817126876622", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "9622546530872848323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "9194788897910888066", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "522181557896569275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "3332334993503432420", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16131448347558322280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "6585223640997887253", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "6205240287062600210", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 238) },
            { "17522452942286240233", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6571438978296387721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 238) },
            { "15511138074959300404", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 236) },
            { "11107930597263802755", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 270) },
            { "10320711719466983961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 238) },
            { "16884228931101540030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "8253823502854784432", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "6025872155179042054", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "10173283505468233128", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "16094174852600023296", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "11077876432364512822", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "10586018593856542117", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "3109104171383198425", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "18136135457402651842", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "11834683513280095384", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4806571630436601566", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14849108908297747749", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "3644282167178264526", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "360872770877634346", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16720108310653948550", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14353390922580547467", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9868561386826862471", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17465517455679097501", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "5570311824197099845", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7524311370696987092", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "14070988879848388270", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "8296551195150971668", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14352796912241296357", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9840495023131952174", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4720851194954041037", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 347) },
            { "13852065717057446998", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4342360467977736802", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "16336482874764861478", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6075691042233712335", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7570346182940928159", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12971822824884826169", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3033264172690274208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "17301887391757619741", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "15790005937034794347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "15464327246951632247", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "5659168916726488798", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "8079376692609682448", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15160738482264643601", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17900257435531434807", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16789135236017252073", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13224814158106791463", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5078905972285278557", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4196367396954155354", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7009873605945341897", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7199295899520406795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16833854122884184025", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 336) },
            { "14599780481362761532", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2572395498687401679", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 336) },
            { "11810221946429451169", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "18084635102736402756", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "59739211822469868", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "5240181393417899912", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "15962137123591591534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "10989937450490049763", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9798585825695496550", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9220830217525628783", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "2235210915304938149", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 187) },
            { "3930314908786112883", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "1334070221835422461", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6681818065741882453", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "6980201892073961793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "11530101016435264783", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "4801117903303888658", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "5782934278345953016", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "13951717514084457087", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "2721793280965260548", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "8124736388338424498", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "12223993560805441284", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9860570706348640782", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14043770215999952932", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15277856047844308598", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8048617952947915835", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11446745541571732900", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17422822627612865758", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "13954144830230671601", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "11198908896401597838", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "5582896843095691256", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 225) },
            { "8133587696326295326", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "2007192658799516915", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "9492402787848610840", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "10515519878978734341", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "16706121580364790904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "5495776091407365966", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "16430562172386510259", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5673972310424776040", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8797843396807284399", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "1698321314111848001", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "5762290464889692462", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "3218248162832023196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "12988961529988078346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "4232250144427804891", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11683680166617045816", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "6252429564537528709", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            
            });
    }
}