# [OpenVINO™ Toolkit](https://01.org/openvinotoolkit) - Deep Learning Deployment Toolkit repository
[![Stable release](https://img.shields.io/badge/version-2018.R4-green.svg)](https://github.com/opencv/dldt/releases/tag/2018_R4)
[![Apache License Version 2.0](https://img.shields.io/badge/license-Apache_2.0-green.svg)](LICENSE)

This toolkit allows developers to deploy pre-trained deep learning models through a high-level C++ Inference Engine API integrated with application logic. 

This open source version includes two components, namely Model Optimizer and Inference Engine, as well as CPU, GPU and heterogeneous plugins to accelerate deep learning inferencing on Intel(R) CPUs and Intel(R) Processor Graphics. It supports pre-trained models from the [Open Model Zoo](https://github.com/opencv/open_model_zoo/) along with 100+ open source and public models in popular formats such as Caffe*, Tensorflow*, MXNet* and ONNX*. 

## Repository components:
* [Inference Engine](https://software.intel.com/en-us/articles/OpenVINO-InferEngine)
* [Model Optimizer](https://software.intel.com/en-us/articles/OpenVINO-ModelOptimizer)

## License
Deep Learning Deployment Toolkit is licensed under [Apache License Version 2.0](LICENSE).

## Documentation
* [OpenVINO™ Release Notes](https://software.intel.com/en-us/articles/OpenVINO-RelNotes)
* Inference Engine [build instructions](inference-engine/README.md)

## How to Contribute
We welcome community contributions to the Deep Learning Deployment Toolkit repository. If you have an idea how to improve the product, please share it with us doing the following steps:
* Make sure you can build the product and run all tests and samples with your patch
* In case of a larger feature, provide a relevant unit tests and sample
* Submit a pull request at https://github.com/opencv/dldt/pulls

We will review your contribution and, if any additional fixes or modifications are necessary, may give some feedback to guide you. When accepted, your pull request will be merged into GitHub* repositories.

Deep Learning Deployment Toolkit is licensed under Apache License, Version 2.0. By contributing to the project, you agree to the license and copyright terms therein and release your contribution under these terms.

## Support
Please report questions, issues and suggestions using:
* [\#dldt](https://stackoverflow.com/search?q=%23dldt) tag on StackOverflow*
* [GitHub* Issues](https://github.com/opencv/dldt/issues) 
* [Forum](https://software.intel.com/en-us/forums/computer-vision)

---
\* Other names and brands may be claimed as the property of others.