"""
 Copyright (c) 2018 Intel Corporation

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
"""

import numpy as np

from mo.front.common.partial_infer.flatten import flatten_infer


def flatten_ext(attrs):
    node_attrs = {
        'type': 'Flatten',
        'axis': 1,
        'num_axes': 0,
        'dim': np.array([0], dtype=np.int64),
        'infer': flatten_infer
    }
    return node_attrs
