/*
// Copyright (c) 2018 Intel Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
*/

#include "auto_tuner.h"
#include "auto_tuner_offline.h"
namespace kernel_selector 
{
    std::shared_ptr<auto_tuner_offline> auto_tuner_offline::instance = 0;
    std::mutex auto_tuner_offline::mutex;

    auto_tuner_offline::auto_tuner_offline(const std::string& hw_id)
    {
        std::string temp_hw_id = hw_id;
        // TODO: this is temporary solution of cases where user has non-tuned configuration. needs to implement better logic
        // i.e. create table with number of eu's configuration that will point to common cache.
        if (sku_cache_fillers.count(hw_id) == 0)
            temp_hw_id = "0x1912";
        sku_cache_fillers.at(temp_hw_id)(t_data);
    }

    std::shared_ptr<auto_tuner_offline> auto_tuner_offline::get_instance(const std::string& hw_id)
    {
        std::lock_guard<std::mutex> lock(mutex);
        if (instance == nullptr)
        {
            instance = std::make_shared<auto_tuner_offline>(auto_tuner_offline(hw_id));
        }
        return instance;
    }

    // SKL GT4e
    void tuning_cache_193B(tuning_data& td)
    {
        td.td.insert({
            { "4583484812233029888", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7560832358324865221", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7382044526960590018", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12372261924257291610", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 167) },
            { "1547771611689525848", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "3134973665622945888", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "18260030211719729324", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "7416143717989012766", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "12028963907131702705", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "2464531851392092325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "8181308759455478086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "546062289721803579", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "4889405384318695802", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "12841232643395100314", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "14108361259911144680", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "2726453304845436156", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "2607416795507802412", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "2175404966338020579", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "14666883719480623074", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "3752993663604843837", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "5274735654559844733", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "8174421295799601683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "1967655354607438665", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "15762542971370422224", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "8183203099539372914", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "4075343423548891274", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 63) },
            { "13264497096898621015", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "679058537775669048", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "3375634256357960999", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "2844616672368585285", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "14235558866846276172", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "18066867692765966577", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "9861424412782371874", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "607078314875528651", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "6234885984223387670", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 63) },
            { "7223570329858821704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "17234843749633035510", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "11516168882438876247", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "11312664612825940140", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "14846039494240217143", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "3390376200501119384", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "1113077760071340574", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "4614875083188849196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "10859023312681572942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "5588692131556725717", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "7653946972043115920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "9773458066743315157", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "10491513939202460216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8140122945471321201", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "15079423575410353790", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "12844146569641472927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "13443914015380511668", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "13404457916017756196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "6402415801415013013", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2040762223425679479", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "8595156989254845134", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "14493123117003003092", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7391309333582046386", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "9935182178960843140", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "15422142509105297183", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 111) },
            { "14849987788569183527", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "14923132847727661051", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "13271555597925466454", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "6865593216823998846", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "12385437755245281331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "4530047829451377456", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "127643210248119703", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "2599051617462913767", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "3024020696533545102", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "16205377892664082400", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "15135655146332608939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "10848724554175904486", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "15558120704022404428", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "14120354125904513152", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "8475075092501403968", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "15892943371777404347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "15078418657871922661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "3502053626453342387", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "1230316443026403527", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "12846418701225147646", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "17386994561779281406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "7367684259946371231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "5451072983028714092", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "11758623888547009364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "15958650715061024845", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "13899144453581769028", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "10884229860266073967", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "6629431845229592220", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "13199442294147992119", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "5032929712205664246", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "14871333176552512036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "17890435688048047959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "11353661571093800805", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "3101908018947919238", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "7495240482209084478", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "6964506613327100469", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "3670645005971806718", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "69949758775887534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "13654393413005772278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "11101512074369779300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "2273811004985590823", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7457154125218067377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7709677514862642399", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8010619564572573208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16479793487852125428", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3147355028342035061", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12672939642957531547", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12627961914394914920", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16210688853876861607", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1899485873740458557", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "669151029135558505", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 286) },
            { "8912067280071688393", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 286) },
            { "7714589858275971005", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 292) },
            { "9794413496918699979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "18350040136091421971", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "16931304566154830346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "12816950084297042217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "2359632276970855181", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "16592641501972654496", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "7754054384598160936", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 292) },
            { "18195884921517044108", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "16256130331524359070", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 292) },
            { "13497279823712860029", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "6095972148204769193", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "4149964766407000732", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "10262104071809780712", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "10707129891337660055", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "3585075254981736756", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 292) },
            { "3181067565488724209", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "8636008354706344794", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "4966150965920189853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "5569253153294942795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "11521347729886549503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "12399471154320580621", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "14851218369956754103", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "14859848826604327499", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "14783159891899899660", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "2369671961317151564", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "1691004331056506231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "4465288557833228023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "13538111995551348621", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "1886751914747841929", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "8445964247944285746", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "803205084059316676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "12654698468722759675", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "13484605287576302088", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "2469399061693302590", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "14782181149367028912", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "1448238652280623323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "2076478920663115306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "7369834759425644726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "11702633755046828968", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "2944972038827287015", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "8261441437673092886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "16694312773479519523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "5486494868955566721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "8246009573416434030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "9457894602447879547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4598302923247277427", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "3116224788980631217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "17103527368951412486", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "10150428063205056209", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16984028253790680977", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "17857105233471273424", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "2715609009808401074", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "232807837985324954", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "13933912937625580405", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11254635684957519432", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "6729077823331194042", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "15961933828477762733", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "827225131390571924", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "10429613013253088132", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14629385997654952321", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7546586420552408243", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "11897687507601277182", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "13975409361394567866", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "6458124573210430792", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "2385616965635993249", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14462438074931673266", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9338654554616107568", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "15476402794704488137", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "13654816209891478730", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "1680424228660495363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12929981792125924963", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "4698507050987130777", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "1094144958579794349", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12358908585763044267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "9793373151408615612", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "90849151510482266", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17277787450259342076", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "2367877811435050998", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "433942345363552443", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14575816691130255191", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3675622521877371819", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "7601637686045360430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "9818496628902493298", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "377651990943545344", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "16357661916741979192", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "5417669424921804056", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "854020380490533945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "11984602132438314210", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "13100228219613095795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "9808704199834907703", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13071373212254908241", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "18392748682101174561", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11928475964162658765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "11937547211842355800", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "4637568849323640167", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16812695025037565299", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "10487883723723512839", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "15315014737515653325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "1579905786032546689", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "4243996335899627971", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "2545885699369058867", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "16926950874716567095", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "6355395905401306995", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2096779676054335057", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4217179485243909459", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17101789600628162503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "6139574161497189424", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "16559140502701231107", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "11459784003592366395", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "7869916853707978306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            //{ "3889519976910355277", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "12081835728078383819", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "14923692894655929923", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "1841901358010744236", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10888203577545955226", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9799890897264103013", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1827296932806936575", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "13010820430079828498", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "6245781545617904772", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "8714031312599034571", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12922099252166105096", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "3042887030242700493", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1419879016567682338", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "12870587285162108523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "6103433181190121715", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "3469599265931338557", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14812617666668076833", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14854734265631496499", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "7637441820772916248", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "14695781272831602408", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "15696910741835640150", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17790593820165047954", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1433224983833208570", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "16185194021453870096", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "10310918050196558188", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "14885938077915823034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "14442357887993453368", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "4719130523147011420", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "8870222084473246330", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "9350596936816632825", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "6183248276225219542", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 173) },
            { "3757195189216622027", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "8318857994507665384", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "12864512857659000129", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "6615646900347529347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "5208923086986567490", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "9390793435913144215", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "11997629302296435180", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "4858270366437120918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "15975176007724247667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "16837473534895641370", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "16214153687871223428", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "8858112708913743577", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "8844677471730173649", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "9043742986995534354", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "15621341038256548867", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "18268980125375728709", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "9757167087033785227", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6513982093384445397", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "9273893819042428704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "8270840662337272430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "15021512490648380369", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 123) },
            { "6578908625437515675", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "13762042713029963144", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "668798769117277023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "10917498758625273194", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "14335423820860953927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "13978750151855895830", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "8965747921518186477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "4428101657497677982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "8151272056391095510", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17656341100957270390", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 4) },
            { "10295330953350618042", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "15901675909820977223", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "6026876733674266377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "381149736509958403", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "7962991673727743706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "10064251191248475177", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16663239694378513014", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "4690831975451405214", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "16132498413588349821", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "10609644803793651808", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "16520784657717262379", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "2271187702055786721", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1872921634399989626", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "12535576637355537200", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7771729980527620398", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14849108908297747749", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14043770215999952932", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15277856047844308598", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8048617952947915835", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11446745541571732900", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17422822627612865758", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "13954144830230671601", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "11198908896401597838", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "5582896843095691256", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 109) },
            { "8133587696326295326", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 109) },
            { "2007192658799516915", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "9492402787848610840", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "10515519878978734341", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "1375156980278317418", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13455881643467418059", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12788968383428254917", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "12304975739476881266", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "3390014193205017427", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "13587202155230938291", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "14462744723628661203", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "16109721499545711936", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 155) },
            { "10090923790949378407", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16672038432561840773", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2973773544904290726", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17193614571243427089", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2862029728492027826", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11066930104187448422", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2755147389712995637", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10662798624911535617", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "2172121470071868949", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3579916582911190192", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5495063314176654751", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3771003491521695667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "15514370342945522276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "17285639145064557279", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "12642574441854544900", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "5471430682416582179", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "8561154029325525444", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 340) },
            { "8939900194037985459", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2129726780118554358", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "15463465056816958579", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "9268536904925062469", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "45977313646881991", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "7092246390386193774", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 340) },
            { "14801984300948838261", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2797723586312707948", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "8451212914744825089", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5131348852069018593", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "13619081494170885939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 357) },
            { "8818679285688095197", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "4608292692528881356", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9729987752669765456", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 286) },
            { "1782966703272153440", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "15641674846325113216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 287) },
            { "18140951659547259039", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "3416294810798281053", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "12066560812164094695", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "9332596500956923556", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "15067550526427941795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "15428062440621131394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 286) },
            { "8873614802459592665", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "3367130693014583254", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "14135594471530769414", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "14971707650115908544", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3036512701943687724", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "5334291640387922287", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "16245760498096322525", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "9928406318940388716", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "3369894612786523432", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "590505356692040012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 191) },
            { "13240472672791632740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "7128145024365641089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "11497327844388026594", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "7301757962797024939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "18121689595247452649", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "875296362957469305", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 355) },
            { "14912119584313592912", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 355) },
            { "12494969618927201911", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "4640611487944119712", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "1692411934657235774", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "1673006919995519093", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "10601835610089648700", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "13262672660175739705", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "7639015398436550592", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13867172651521406104", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "14587150810299279663", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17271409929705935575", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16744813357455687598", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17215047912921813592", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "4093195092417588676", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17895953872149392740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "5918874715861160937", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "14498368518428801865", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "13857947326347149693", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "4965619590663772423", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "17153828952517174005", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "9864812885638557249", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8410695282651246173", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "3011957000022205132", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 296) },
            { "18202466898415347292", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "11433166800587133728", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "4499160027703324879", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "10225878843410985743", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "10961131057009777878", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "17123897723015586893", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "3938875063592179645", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "7589320923145169660", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "13907115679251591389", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "5262155845067632954", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "12323619994816664201", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "13711624246076632711", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "13879644216615040961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "13418213186769741623", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "9850414237385072276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "13762987373425432087", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "15387492794262813616", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "9455446170928387706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "7799083605029182328", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "6416346888102436677", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13401162817870652306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "4574862993950020539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "3956303186129893250", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "14928794187754412027", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "9892597035419316966", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "10290107543739998181", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "5275016494706355806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "10947686124973711385", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 55) },
            { "3997597867012981671", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "4003433148846544263", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "4361250474585164062", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "10523363119855336043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "1718324808394833635", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "8430284238380067998", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 292) },
            { "3950448771871155887", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "9033877528655370244", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 287) },
            { "8878071105867359307", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "7511984934520363336", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 287) },
            { "860443413504997114", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "4957638663977636791", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14793503588688729262", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "9303039486341715392", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "8923406201866512905", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 305) },
            { "14629889085799380442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "4811310048537439646", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "8622985922687454592", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "8611046137980763541", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 173) },
            { "1879796404388368873", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "6928835003016610382", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "8603207107304593583", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "6477198553362516437", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "6377441002585730862", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15761554874575656075", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "118354408955419547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "13601202334102031245", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "11716196499333250570", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "16984923535088627888", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "364996668506826202", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "6412527114952548517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "4892959859293355837", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "16127331840410137228", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "13335944978055152562", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10715829903767495958", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "6065404265303390338", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "3897655522585667381", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1860663592951633878", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "5698748062275134041", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "15945452307780131237", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "6764685582382238740", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4737109912659941670", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "9371952894576491521", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "12696412964119109465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "17825874529822806486", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "8220763890959777277", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "17731591992960147987", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "8950668477702067729", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "14991602704357959545", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "16383540667048742064", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16820082917500285799", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6820284286806022849", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17285815901490707654", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "994182747184593564", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "6642767323474835034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "3215659303601163167", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "54975980454651672", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "11529876081402974396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "3644282167178264526", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "360872770877634346", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16720108310653948550", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14353390922580547467", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9868561386826862471", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17465517455679097501", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "5570311824197099845", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7524311370696987092", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "14070988879848388270", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "8296551195150971668", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14352796912241296357", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9840495023131952174", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4720851194954041037", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "17009318615658405230", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
        });
        td.td.insert({
            { "9421643783312790618", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "10693348571961406417", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 191) },
            { "2940027113687311893", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6090625728451718945", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "5643908654122573882", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 190) },
            { "8852322966320229583", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "11185156002426041243", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "14670068483447729857", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4623542918584461522", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "3126708271410621754", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "1434535531617424039", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "17025268985366223779", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15398976608777968810", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "6149673627320838019", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "7413341807736193935", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6071597471486669736", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 287) },
            { "1127095963814993729", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8611856835854445891", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11115935318793891293", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "5393081375805921525", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "17589256877540537468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "4135814997524960840", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15180348902159643465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "2818524781020760666", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "4942080349816430490", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "9263314249867362", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "14377032179148581309", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "15245529372955421912", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "13595283050046771323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "15667549927492357263", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "13827442968070281886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "12076060884099762835", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "16532386511585070092", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 132) },
            { "4910582540370962997", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12335148041391647118", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10689880083512104726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 167) },
            { "8870164706606458004", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "9269498023794081940", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "6779832349039897240", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "13942354789498444722", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "14294764660016835141", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "12323510278692809329", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "5728070995112243570", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "5381496395266530071", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "9712640406795417230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "15036737419347383878", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "11552594222313787816", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 151) },
            { "9399255910184037480", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "10594581016504135920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "15640487942881889055", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "14165417928501578590", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "12251989236991754721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "6675363512560434713", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "9831713940431605743", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 122) },
            { "6531349504807709133", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "2726501303929773572", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "10439704858943788014", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "18137994263450376706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "5711991739289045727", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "15255831401757117660", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "3906658058160172747", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "15823433297099049221", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "7829483638597533960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "14092273913846393837", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "3746578485711843646", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "12228183555926126959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "8776893332387904786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 63) },
            { "16672299044236704672", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "13309889945947393850", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 122) },
            { "15966815420067673043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7415938485228396256", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "9655590024687998403", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "14798289196964890724", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "9794684437872784678", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "16729204245488754836", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "15185983488152870534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "13821372148587948765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "4727004015814244856", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "1738348894912205653", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "559491455289877068", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "17312172687490475177", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "3470176432841342662", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "8950283515337670839", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "3995072673238444396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "1238913228370790536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "928677976151553489", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "4059887681292863495", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "10493952422143348278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "5610465912655751128", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "759163065093339795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "11300938516591867859", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "12843263740221725967", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "888316366026890514", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "8088645310090149658", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "15891058658954073255", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "3456538031339928220", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "14187063304165334647", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "11593893535334124231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "9218293603091125898", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "3614865264081581688", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "8860682105104682547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "3775781894241463386", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "8857354069987696352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "5611508857136313396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "10872828113308792940", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "3726594456692340607", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "7541331569935741737", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "5639394073086652531", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "11158391063762007051", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "6319861294308997034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "6893801771793379570", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "9015970699147699643", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "9252735579930779632", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "16237353798629485972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "10916127635689513485", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "14631094106016920364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "5050075828787158563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "2277573429750402800", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7462044209068160751", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "8879836520351993142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "560198731460537880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "6414187394150266523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "15317838148382459105", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "11219109605495282242", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "10404790565578782014", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "4657890394631454901", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "4256171754976506222", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "12658039760507507230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "9883901352719605734", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "5115148310176289236", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "4892280615322354003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "15491567059821267605", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "4716932801711295063", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "15559962129967760292", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "7866546777503165080", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12994023006726461909", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1869893771689012539", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5635187738652974532", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12849693339574251399", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "13233683642200681957", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "4310121962651039089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 280) },
            { "7620758476872568593", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "10344702612951473525", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "1668590302432600271", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 138) },
            { "8750610033922701675", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "6913992575736424382", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "17945230226911262869", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "7356559449640788577", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "18349175655630268884", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "16817085704588915904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "9503107262691437536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "15595806193584438610", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "14283867094396458105", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "14215445060938730397", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "12720976113342879024", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "14766625154638709852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "11757187678986741715", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "13038212285326297688", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 138) },
            { "13919423909034348565", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "12925256096286953030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "6275163484075546689", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "239651884801599911", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "9500211224156027451", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 173) },
            { "10902538092301362853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "8454943813981348115", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "11722951613064434115", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "13547342611064538960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "15171119202712914112", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "5451487099025245427", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "1814940262511664251", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "16341609351317463829", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "14343280871046671393", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "15586404971308258630", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "15891211707425019144", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "15351688973597240327", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "1844016761754156672", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "17925606428283439978", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "15050158761219834868", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "17448180555072943363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "11422222075976800614", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "14284377769814732906", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "667777413731244716", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "11624071786842686451", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "3874974512053082278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "5471037497181745651", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "6371386660654628561", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "5331835606773958814", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "16163821504542698475", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "5697543838890997891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "6217438921274668801", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "2633095809604510774", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "11218297661079136641", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "3374196543196230185", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "17797320202829145544", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "17198778757516749818", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "6440981718484677922", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "1616603916015535857", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "7643715911083095268", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 132) },
            { "137903092932521503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 167) },
            { "13203019690952060789", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 93) },
            { "3918152537861570517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "8782903242853500098", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "18312668164562040079", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15160703466234996170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 63) },
            { "2751241748685218213", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 122) },
            { "12622728760401804660", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 63) },
            { "1290624457831957354", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 122) },
            { "10924946887162830574", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "10789202693606479024", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 122) },
            { "3718558874911694616", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "12835389389575311182", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "17406431092101974143", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 83) },
            { "1400409391266374603", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 44) },
            { "12154660333025778322", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "4800587664660105589", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "16474284418841532356", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18117355153710110681", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "8449591498895477846", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "2962899568083589487", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "3491333679577961640", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "13945298510228460890", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "4282198629458668761", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "779525528509830615", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15002237905129290671", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "16833026567865627676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "16991060247581867302", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "6902644989079870993", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "15088285782819494786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "3379661203936923589", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "10049571207493913006", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "15691689005236690951", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "11275109735493317886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "12220860296984467101", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "44210723233569665", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 143) },
            { "14014987361364503383", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "18189351665719757712", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "16159032667792855758", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3374037004378790060", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "6765409971512438438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "10098892297878373639", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "981877665302032867", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7472350511000146655", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "15513971895394346930", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 102) },
            { "6169721205327431190", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "4519054607159036572", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "12750124851833311828", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "4333851142313192116", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6041620003527819661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "15091361629922645798", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "9348121965341418899", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "393951904144235223", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3220084080191614421", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "11610588256244825741", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2802357220980817497", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "8972812517118478580", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "4207115359813621211", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 79) },
            { "16582237002610438015", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 99) },
            { "772342953072606219", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8546247990965609013", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7971830510840138313", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "3570484486449791727", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11461079340079820563", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "12663860560275361463", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "8132521728369930959", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16108573960501496757", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11086699387784339943", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 119) },
            { "4013707396889204359", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "11850332373794932468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 101) },
            { "14763982961176216679", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 93) },
            { "8207349115037232863", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "3273748387141431306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            //{ "580936360000782237", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "10682918518101379579", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "13178480813522103091", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "14472322679644532468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 111) },
            { "8378137527264154204", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10180255575636684134", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "18242121098885244699", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "6178572652675599622", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "6558074021146321216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "11038938372264857379", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "17137800360536507200", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 138) },
            { "14016185289182597841", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "8970519484272874266", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3289746379259038515", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "18389174979070260315", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "17666483005735191253", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "10845781902676865789", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "13646634862315619979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5072154928583891344", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "7757331094141318304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "16779678846332091086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12223166874490429642", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "13316017702896072758", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "10390896207372295988", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "8386498395042623384", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "17923632501885139982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "13398326377839777956", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "13520557646924372128", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "5996787039089786722", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "2626376166907387273", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "6147643392694904814", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "4311921348668650791", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "8046109476498335792", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "14190077682825257613", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "5032302126047788183", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "15256375572125522238", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "5083173538217738703", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "17269467004855120308", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "2901056469731554922", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "9747637051217505111", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "7175860674618956918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "9530922411870814200", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "11015319643831560673", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "5182740559503076121", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "7567277014404457462", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "15973842639221447367", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "15951492056203075273", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 169) },
            { "5283253936050062275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "17650690912303447913", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "9614936270604202220", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "13998661469619523378", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "10584034255622783869", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 120) },
            { "2973436171295280783", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 41) },
            { "1908809004094565452", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "1623383628456201603", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "5766507688771440170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 22) },
            { "16626226341188424071", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "14619055893081624406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "17222005830854879661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "14224121742920800990", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "5859124386313585730", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9596156698919548146", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "10482582307328548806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "407189201971322683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "16626507949474235269", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 6) },
            { "879005904827468163", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "8460847842045253466", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "2729099061601852493", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8233922303282945338", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 238) },
            { "7402006230339617617", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8420763628389536977", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8325767678959979628", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7673672840505587739", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14166169053627992481", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "120923426036313670", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "7348084298010357768", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "14653065651448352526", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "11008522061447263744", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "305505245310584136", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "6472139251351862598", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "10586018593856542117", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "16706121580364790904", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5495776091407365966", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16430562172386510259", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5673972310424776040", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8797843396807284399", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "1698321314111848001", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "5762290464889692462", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "3218248162832023196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "12988961529988078346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "4232250144427804891", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "11683680166617045816", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "6252429564537528709", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11717348577195224554", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9275303306340702111", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "12245096462203481681", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "18439435691655740074", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "15272426400992401555", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "9136831791301215059", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "18238669114790278675", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "15376246520426368532", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "16469788155263456039", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9360494451263553093", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7897877428349481398", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9354818521586974021", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5853553261686771766", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6351572488552853754", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11372638316835753193", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6170074103544756465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "4544242784357021697", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14225108809796795520", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "178353385245384751", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "2002574142025049539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "11630971824787392820", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "11542493210215136239", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 217) },
            { "9595803435783166868", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17610828776103321939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "18312069177632970412", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 237) },
            { "7577483892218843723", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "4355933224673863178", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15124932296735391043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "16888042302987189589", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "1584639932403433303", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "15516194807992507442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 237) },
            { "6614374536332038989", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "5097818987523855112", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6623182990939010641", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17001023283013862129", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7935150275452094595", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "2326323992207208685", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "5072735784865711772", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "4683841893192741312", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "10341773151035665956", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "14109534738984061372", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "16706244336960642883", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "1967030672241059921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "1482100699000420627", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "13632911653636980024", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "6198830126915940359", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "12125006289181390694", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "14152716242882609401", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16732621354152092286", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 361) },
            { "17921489101554455214", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "7384108582424003436", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13139625572508441980", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "16491532291908469567", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 355) },
            { "17788367809717898285", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "1509728225855233852", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3816705689596666600", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "14157505468412850916", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "17366807170224886960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "14548509699664316785", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "10404702662303016402", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "16436357970364549479", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "4858167644379876157", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "4381329435655511217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "13972357557211413688", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 355) },
            { "6580334406272192111", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "194072522984726408", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "4490223883171428014", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "17194603517181970633", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "6995235840871804844", std::make_tuple("fully_connected_gpu_yxfb_ref", -1) },
            { "1671208365782918441", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "11718418772370938734", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "989564341557094953", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 55) },
            { "8133676065307881979", std::make_tuple("fully_connected_gpu_bs_f_bsv16_b1", -1) },
            { "14555883089089918919", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "14026570177552137240", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11686670048744589243", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6678796313875454849", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "641417817126876622", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 191) },
            { "9622546530872848323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9194788897910888066", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "522181557896569275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "3332334993503432420", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "16131448347558322280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "13852065717057446998", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4342360467977736802", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16336482874764861478", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6075691042233712335", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7570346182940928159", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12971822824884826169", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3033264172690274208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "17301887391757619741", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "15790005937034794347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "15464327246951632247", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "5659168916726488798", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "8079376692609682448", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "15160738482264643601", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13953639482255428227", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12293786134765875615", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "18214412375127043522", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10670103699537731664", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "10147266284710177932", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11443268857010762276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "4659943649635556150", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11726298758004767743", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "13896680298436380632", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3797957937905580811", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "16294962940703055933", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8526484907799590618", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "13723543003759101485", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9873647901670251106", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "13268525255152984893", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "13008742408950833847", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "8616686489737649890", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "11423865221956815041", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "14990645740260870030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "15204453579641378742", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "10892456883214928095", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "17856816245251319111", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "1799430190598598671", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "3106591708459602370", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "4111904926378218826", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "7678457226823073886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "8786249783185140623", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "5389189982064081933", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "15175088047384943892", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "15331103261044247142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "3627273785739110683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "12478309735214802531", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "7212944937255713716", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "11873734271080160669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 93) },
            { "18421820525219154881", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "9553032671453999824", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "3860603464276263676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "14115313335378184289", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "9519623751582710696", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "10288726118862235940", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
        });
        td.td.insert({
            { "2231648183489019418", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "6316097202867006365", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "16208488491972128275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "17978026144659698965", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "2566302789609970663", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "2714742023091949586", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "3087801652564627458", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "8602155166799218249", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "14230385851791760020", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "10828719108804915700", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "13973179950424276578", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "3668927000317872012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "7947870656736319919", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "14767888121198814523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "10401632438377178271", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "8762901342272872498", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "10783981060353445280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "12608289345175485333", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "7875272450497189442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "1599725688135122629", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "11932770338770247767", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "11184047387366978375", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "11716771904412649891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "12576157843776905380", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "8402692278765063674", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "6781076363516398481", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "3255465741612432300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "9767950219863105043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7134654288295280046", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "5821853991835395449", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "3480732841490521799", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "6973260260946088987", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "15649927926091502215", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "7910468668367486698", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "156456996459945842", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "1994927850993519406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "16431165572426232677", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "2864254144951744544", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "5390559917122707732", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "8378839908604146288", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "17163158934005653629", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "1185280691070355160", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "1999979442136861875", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "2527189070714658176", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "16032797290430373799", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "16783619135298589974", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "12785335515281046438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "9216608098626790565", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "18257496796879980386", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "2452226948562393335", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "11072545690050335239", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "12668149981216388765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "714898562476771473", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "11115684531624462986", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "8710684853144029787", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "3752171257634205726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 41) },
            { "5243587439683016777", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "16881283637687482989", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "6042976104660344109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "7351733901977025859", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "9341400376014914418", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "13713406612642090169", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "683350872280694452", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "10436819182310112786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 41) },
            { "10269788826827249402", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "12558716383635737426", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 41) },
            { "7181186153851700294", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "8107447526839063293", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "1016414921656805365", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "4871907623235871050", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "15539976365475470623", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "3880189981766119529", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "10154958553575016770", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "4561874206785244358", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "12358640399843058144", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "12956726277674279950", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "7177837234452118325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 2) },
            { "3160080179644173650", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "9832551412183684637", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6347790007333387897", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "13219313818719819982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "17780553554354185249", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13315473376247698298", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "11815135771923538945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "12465309202808173810", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "7171436879576678563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "9407046952012845638", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "8805267762044816983", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "14381377343079009210", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 102) },
            { "13248818835662551847", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "9300668734746602663", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "7706778813807762766", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "16991433003318725315", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "4584399194832832140", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "8558026087297588736", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10198351802037434471", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13257958112171706655", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 139) },
            { "14722464361594874490", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "1544616395544118800", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "5955569479109539856", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "17738708576252096108", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 141) },
            { "10276056345160651377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "13515249925520423329", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "10055593174764596789", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 364) },
            { "8707130584661395715", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "11161176476048297041", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 138) },
            { "6959258479021077609", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 302) },
            { "6365109451272429541", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "8191978674781978488", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "11604224659996035116", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "1759873215866222608", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "4559874433048442047", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "6937259685509040959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "8242732346001884230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "16156727721974657541", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "13786314015179226945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "4202371435873473624", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "10933135228023712253", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "14467312749536832362", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "10557843071473489529", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "14967016402348718219", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "7594056145185406157", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 83) },
            { "12051754199123379659", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "2634827464202220192", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "10211888372266149335", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "4548339182509526896", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "828946941343000506", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "13008375263617223352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "5638301531544801477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "10213021343800816450", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "12000084249129063723", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "18040104088851490930", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "16394608147869554267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "15229178454191871174", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "5927467766675317093", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "4877661058006573128", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7515937801840512449", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4747017546101861376", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "8833751655076849826", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "16256124470203598218", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2706523860113152678", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14946999257618007034", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13699343107940933196", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2887515984302814699", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4906737644615337997", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4725303208352054390", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14955652052550053223", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "862470330257326268", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10381668587006680936", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2593337359555305520", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10774393239130591748", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "16247780189312707876", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "4487284881658782961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "2811240876735166934", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "2447678508469638445", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "7454164784767168407", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "18275848121133385773", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "13759457214873634937", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "4855959048455906948", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "7160112985819045832", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "6880424067049089394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "748023061136366353", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 347) },
            { "15793120434966402276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "1932618420321708351", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "3336444565837087463", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "15067224168014815918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "4431271266410883917", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "14115818307364071162", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "15250928896997938213", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "13013685738525906988", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "17607598031220186942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "10278583197921433748", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "5300123851331202735", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "10751381988703627540", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "9905160045246767203", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "2927340528757005274", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "16243861301305882872", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "15004681374954252324", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4496537089364942280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "13357951046545317387", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "12878719705192625362", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "4785466104509327241", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "2416244034719176938", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "17785504548342377669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12811319921474895164", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "10760000973615798613", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "6300105753728135778", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "5791707725846814784", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "13246629627758485603", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "9400558994532871122", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "17865276008842107020", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9981156409872807880", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4626770940790542333", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1094262369519841857", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 266) },
            { "5523297987528243797", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1789389636704094004", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13544237579827433636", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17696244668222870549", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8926171136732424790", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16179159307898475953", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2692291137583386471", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1095433004701276122", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16277739324697771064", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 147) },
            { "15945243427420522827", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "12296021067910843036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "10673589588224406026", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "3585431879296991112", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "3119002388778552316", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "5322582996019286781", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "13225749488949717853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "13207215182979880133", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "17730578026124357983", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 372) },
            { "9725306578495355500", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "5277508201756602822", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "12806959657459851511", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "15232478805009654818", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "17712227426604098630", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "2530975976273876727", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 340) },
            { "6232318392696042532", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 340) },
            { "13657818175298160631", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "4088603773237062922", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "11177710514557128293", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "17515272254985846970", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "312130674630486188", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "18247095696433793115", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "6341728273786101457", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "10401462893795799864", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "3032101782888447048", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 109) },
            { "15078331029547630371", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "18043541805861795852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "7608435380564752000", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "7129337563584588644", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "12204270722180734542", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "13588405581356678469", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "4986281570682617547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "2214420531345686129", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "15030725973433075086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "15384520760315696372", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1915712383376159541", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "6176816506826300479", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "15331830720555178784", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17558578036713688769", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "2388815483287403961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "15948716167523201661", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6787190800192250525", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3378135802544446861", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 149) },
            { "13053802967262518173", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "5503306970973862635", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "9417884304413500664", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "7866083951140251349", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "10084810175406860705", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "10342347371769114236", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "4063042455950354352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 149) },
            { "10055531955039754920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "13173341667656398216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "9356247214800869277", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "8630592326601832361", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "5041676938441886628", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "15379755045295790608", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "13410979599123644577", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "13504573816477550406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "4459291258089899503", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13992993617743773278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "13395962624719382401", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "1535675815795592775", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9849036672784280133", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10780684483689207763", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "4060515618437959603", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9203467651096078409", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "9698108593334526558", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3252398754887381352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "3120759967333088019", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "2024996599975373573", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14876099702827489987", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "8653894569484019347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "4004518396368398824", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12801342874692090364", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9387557098916352467", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11689587446775003898", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13973363990921590224", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "6278030053136901802", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 187) },
            { "12122586525659611649", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17711197779492504718", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12489342380264260364", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12148845150031891038", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 187) },
            { "5080727465135503101", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 109) },
            { "16818862727193981112", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1827977959922344361", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6291003899324240633", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "3002862967523058894", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "7222921168135747513", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "8696847224485998117", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "7453625482178960081", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "1472822945750487574", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "2032419134020329477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "805104869568121149", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "17215312565214990348", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1737128374457513820", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "16263489451695566992", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "1608378717397996752", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "14346703182362139650", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9744493065276230785", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8331721527098298378", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12097373631649932423", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17442035600389810700", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15953351443307161934", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "8740196547852036537", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13809436837912218131", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9722172495422643735", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "2662628817605495834", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "6163765140843670080", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "15662207751131195569", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "16494358566119044242", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "12641727819019838301", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "4917595053453614536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "14577496472237742721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "4356806313729405658", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "14282717676967464809", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 285) },
            { "7275701540104992761", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6459003512612780875", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "12791541622557283904", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11882713776717158678", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10982479758700194728", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "8714769962126708854", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "7639744043430667021", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6804493132858449665", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5204696395552974337", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "8893913418784905112", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13496918758899426996", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4707842387180272918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "425930963222944558", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3844246198992827038", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14280128364139551919", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "6774493262072228712", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "5670860641930464485", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10055923266096584825", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13508499324621059445", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "17431631935986646683", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5568431877348597159", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "356320499267651746", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "10632294140185068783", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12339584174527699309", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "8556999353039153661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15381427144405510339", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "8855986581847188591", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "13704396706685353016", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "17128550517647168353", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "8625183189646433895", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "7921388663815287395", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4213330047036138895", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17034122796081495259", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13076343553185159307", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5854267518455107328", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13675314612031135613", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "12825029449351875037", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "9397711809671506538", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 101) },
            { "12965800692507042874", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "2647922515901529845", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "10961049607808752432", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "13988022841867948024", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4612862531793961340", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10950469938532358632", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "2228733394430438519", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12015814430456201522", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12344008430499496640", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "9863615330219779441", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3560058786734628608", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16047381404034145819", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "9714811479610938662", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "7306541374689856571", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "5689486642279577539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "15545653867155770893", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14910368344505819159", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "3220771309796407003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "12786796142417489350", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "13947140171097868740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "1168311873250200110", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "3495786143085325748", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2164537487697642190", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "10623345643437043886", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15240415102190323330", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10321975076426598984", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "6467563111927343808", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "4280198021826662216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "9464830880142854424", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 187) },
            { "12113781253211924677", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5410693492803892704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 190) },
            { "4844529595057806427", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10848097581672953022", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 190) },
            { "7947428837044782745", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "11705938507822117867", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "8334753494554256932", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4995468555341975721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6282308289220311358", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "18275232300842488846", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15754022314306112499", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "15193841338943103284", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "956475051281637098", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 186) },
            { "1117811515417136925", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 186) },
            { "760383787039304033", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 187) },
            { "5351526116347538406", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15923292837937693143", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "2954421933443715181", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14945079011377285773", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9573520179708447727", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "11432977101529429562", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "8918387046558682780", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "16699295198130950587", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "17358462939783262207", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17406383217119217230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "14003645277231336821", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "6638761803107874904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "1630585964216121575", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "10745248353587672572", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "13395074742046717601", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "12659539044474018256", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "6598024975967050290", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 141) },
            { "2006890470582854116", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11369389082421346630", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "4986977887030495943", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9681320098885387731", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "8730097760819044515", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "11882021989615795558", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "8202324251716703125", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2932157519158822224", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8431962471592709199", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "16116546888494787089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "2954606701225038770", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "6757752550680050481", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "5893257440341358427", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "1327911294059513894", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "7771820069600757360", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "4618159169098049590", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "12268432630136256720", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "2373658589834410892", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "8440300225468667909", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "14495382595913294626", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "4974435385259831818", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4455497237293642238", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "682912708716537431", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2585176064846114298", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "16033144151193421543", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12141880589558027223", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "10098661517988566506", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "16192971634546462244", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "14793709237400480942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "1646362346584649954", std::make_tuple("fully_connected_gpu_yxfb_ref", -1) },
            { "4874397454627474644", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "6171331678772388712", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "7496699438957793920", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16767657090925788431", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1006721963560645335", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "14753245713079865819", std::make_tuple("fully_connected_gpu_yxfb_ref", -1) },
            { "1779870708816318465", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "17157919258161230886", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "12398103047184982980", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "2961249862769657168", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12131460825751874564", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "12365814254940023343", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "17218545462549916519", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11877919824125633092", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "10679711602282897680", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "17801375178828079914", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "15446821602347034830", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 198) },
            { "16041087076800110589", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "14102351022029437177", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "5786978465690715325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "10140124683113804219", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "14022671143475909407", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "7468500876165989695", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 302) },
            { "4628560194573173205", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "3963065974337687046", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 305) },
            { "13439359175348786664", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5342116782332968020", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9198777289928370963", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18276472227494448327", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15774430281717785574", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "3887883367078892827", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1004081473410027655", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "5460182945235134126", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "7932494263344450271", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5596359111431962318", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "1116176429672030385", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14642276070370158123", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1709508499926680213", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 109) },
            { "15466995361950304551", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "12936512845587590244", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 218) },
            { "4464844599426088921", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12966090642798680442", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "128970554088066862", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "7183620142123364052", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "3793885399790365373", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "4932548298968525464", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "8248099164876900927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 226) },
            { "249355510483373796", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2837134119351786115", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "141687758281942172", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 219) },
            { "15718782218800307385", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "3191047205441946466", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1564774057733793087", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
        });
        td.td.insert({
            { "11134833419828370568", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "1556966764088589197", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "6087676883600048234", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15052286556809931759", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3377724880784871475", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 149) },
            { "3452246087500006120", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "6840268976700446867", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "4278180549747978226", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "17856997406888930289", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "16556093306187145310", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2581594444558181374", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3377472614945731801", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10622082408513122112", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11452807035432891156", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "13529174180301001127", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 305) },
            { "17184405948599119534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "5921658305530976502", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "6802655190570100236", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17877430344093804543", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "153771221207255459", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 187) },
            { "15596913527233792996", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1016967125909374575", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "6829653688530177613", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "6094638411430816112", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7559615879839693931", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11270266455366424659", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7100226796198950149", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 218) },
            { "210793817522061488", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "11152357292626304216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "5771335481927877060", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "14619753612256300695", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "2839767407547705101", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4981552552200657366", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9626028243479089234", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3164513064874019611", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2363414141971004557", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8962502004422485576", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3154903035376733831", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16134637021630473012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5553176511624221429", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "4890932609897686394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "15334769670416409064", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "5513667102916409932", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5351705572686943348", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8200094670006738584", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8100051552977329013", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9004823715680825977", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16179959997108523051", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15148625184033310404", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6577754887650563753", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "13182965457868586949", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "13839590781642269381", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "12711366212612147422", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "7963529808900784906", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "12184558469694708819", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "3285180770267559354", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6613282637922219205", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17093159649157277089", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14660081992091188026", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16228026045292341333", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "269829518575229806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "13023942860659386957", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "13291308922240014334", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "1187622888238643867", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16229324496308453344", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "14019704891647234793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6141637854990273316", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13524128602135083081", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "531020979837645217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 111) },
            { "8416686771626338600", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "2916077416184925232", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "16862531110856250955", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11352536854890889084", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1683347645109643149", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4374049085310743239", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16159971034327080937", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "15779210035964863067", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15153285262450947102", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7049603973253724866", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9389671301472986523", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13891598020647124806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "9315279998737090956", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "18261342465838720356", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3632541114724731809", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "17088320301520334100", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "4352363968456148009", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1827842275223841485", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7548767746018027960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "17750850961096057029", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "7606282654661282476", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6201358671959761215", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4829111442270007186", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "7267651931396380072", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "1279682391530947146", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2655979063469551930", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14425547983540742516", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "981419593633555198", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12324657364444167791", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3246153532847702583", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4202705710324555180", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12272318018055307535", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "396815044270978782", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15633173680908856082", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16635731992372618666", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "10418466892824851134", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "3244777852750357718", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "2443758478383854939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "13503934436248311972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "2594310972560076285", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "2424349375092546581", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "7104985983444651979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "13518747015059826801", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "11675809062974151496", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "4725349695436675084", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "17351243519367619322", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "17026338651868178077", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "8730407034445893642", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "144434691308306757", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "4114184149613179671", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "2558882920723584206", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "16481414687792927331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "17756651805686889890", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "2228533392085335649", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "9038567144062573854", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "1345293381483212104", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "729683192738752814", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "458997435535883643", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "16955907389221472146", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "17927673764274384911", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "6418222853479731432", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "7539191242110313918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "18014188548165359278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "16640379332042800496", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 218) },
            { "14856197725306980283", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 285) },
            { "9279474331309267880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 218) },
            { "5717588912072437191", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 219) },
            { "1143426643765799488", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "1049385516019456025", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10766144770072425534", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6442062011017461761", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6063490496423709036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "3892512749863226006", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 221) },
            { "4970240836537468609", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "14668725050395069435", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "7939047354407928586", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "365747554145156596", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18207060402110970301", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11049175652352131465", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2982080608393779951", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17216477578093693014", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14116923400742300182", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7029133126202354787", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17420660823086709040", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17300489799784213303", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15549100047322521213", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8342403220432961494", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4600322689355365368", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "6432444239720173669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "5944283189654634640", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 372) },
            { "8682613468075783516", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "5788340143385910170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "14166708932229380784", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "9262263820759430835", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "10661619519548036109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 340) },
            { "11254313793397682889", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "8941570659228294791", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "3711589321155572550", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "13440603011986281192", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "10072782544067079397", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "855625721312733540", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "8643403818712296708", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "3482316012102041163", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "15966346359387758212", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "6179768494274723997", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "110891946535801188", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 372) },
            { "13300595681637438535", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "16686223109098592740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "4196950243745604808", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "15357494333788579519", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "5791271012599760917", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "3502203881558439278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "6615043890071705766", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "16602880550249876273", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8163937071550477896", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 218) },
            { "4788158788847752998", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11048286378242522780", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "15669268280202512868", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 218) },
            { "11708180973354877349", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "7429872600277069485", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "18404744652577257121", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "15145594907273468650", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "17189550036105947900", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7167054889777381093", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "3278181836788028231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "6040360226338233118", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6877955452402826287", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "10864271596740164097", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "14322983802576638073", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9469688466553577331", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13052522487775745493", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "10990480508394584613", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "11406807220585770939", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17014949219411078284", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "2128641903680430067", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "8751004549226570175", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12508733516106581272", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1535119834165965208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "6537771397615897748", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16911666678187393426", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "18163247824658143109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "3169531413538986325", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1861963470217658786", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17175653712131007582", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12148428445687813823", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15239273648189016892", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "17290692657168386471", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14119365735362663804", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4225327120021140533", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "673126354575235249", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17628454700752918711", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3529846607992358207", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "342387360760418341", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16353520814579109491", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "3134099148543397372", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3042628567386436226", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "868736197323541759", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "3241775197578183463", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7851643406001230159", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "8502552745012743053", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "10353443026537243362", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3104552371734307984", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12807894319350246437", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11258614397356100246", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12946314097679886518", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "12909725304008017600", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "6153017925473103663", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12188122150443559128", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11983651079897753600", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12988924268115973386", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "4891686540869580517", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15196732464112076502", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "459391085160518545", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7760457628691335753", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4865678723441158246", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15589245661365969249", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "9661616000023492219", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14777607874956018667", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14113322810933328214", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16281761113420371943", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "16988191641007425377", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13194254226778628574", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12531936952559145430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "16379080233376322220", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2613462626256090659", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "15844881725957151580", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8059328623525062913", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3662747857062156477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "15121448034928438384", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14122213471825630433", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14985236276429954162", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14321283775111180227", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "98795127409553442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "14805540705424073865", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3788462090984291082", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "11823068760218786389", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "5963105523596432544", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "10308431308942416781", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "8712136292276123857", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "11314582467969020320", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "17147293671640396193", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "4465701487417893814", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6144958783262207773", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "10467232566885547072", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17262854991782705821", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4635570915184713874", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8706634286501695698", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3863816884636503247", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9252629750817485029", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13168267319035362901", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "16567638487719493784", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "13449466515297095146", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "10808909442136736629", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "15172865163331822352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "16260483557979578317", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "7469127846325904854", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "8783239368699382065", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "3477539135137665170", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "605638562926557381", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12626994817506009929", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12417557233566012737", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "14056483847542666300", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "446997309263592434", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16589191615146805668", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "17226649394712507758", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13566885629976429699", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "9931266845625995359", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2522707948254032777", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "6486250531858548438", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8174273876544952794", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15049304780567617964", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "1321553039928725678", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5105893636044171966", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1661430504764145711", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "10041204026657386200", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "15969909663367854367", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "10956917223944472347", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6060390128414591327", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "10987291891349907631", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16452573613171944531", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6370356607952251648", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "11547588640573840103", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6882259829255167273", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "4184283661465100793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1799277562177870093", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16276490504942526329", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "13939380644892198347", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "14257398784378656791", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "14444423571297570985", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "9708741882115135691", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9374845449632011709", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11907741510409644649", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11833466191385766041", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3276797683943990958", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8494679093555050767", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "16807117250109985357", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "13642010365337780940", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 111) },
            { "5622078553841657218", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "3973953743850093759", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "3210709940026980348", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "15122428380000835284", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4492743859922847514", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3555469834146426564", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "13140141354298916151", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "7110352624440078898", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "9527046928040225586", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7797523746053138659", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1478169078874265704", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1264966373832011567", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13715010490012086430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "1470778934882087497", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "12725817227797568697", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "10024777334075819235", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "364471436103661689", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4052362583575987109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "10657660173790920140", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "6557428245898292304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "9440117898128288296", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15929262283669093154", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6352520536724420824", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "1921667815983542102", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 189) },
            { "6088184848087986042", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16602667769746047266", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "15953651221917495492", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "34011924689025090", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "674384870483198184", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3555798556624172621", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13793032417416585006", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9019684110208109757", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "647849627466319112", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11242435114747058327", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17302407573266205607", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "13606281481050014632", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2466805217694531959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5511298016141559884", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5483150635926637198", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6265211373810873425", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "7643647841451578008", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13254760530618979318", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16709502837180561673", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15693956942112465267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17891347169069018262", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10521453583707218193", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14303192614979408043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "16609351383660437793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11118586558529856637", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "10939847328508611170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "5114254088513267110", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "10163486148946687267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "13296242326766100583", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 143) },
            { "12068797674575015662", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "10978693262040522687", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "10037086825900566930", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 143) },
            { "17216583849049249733", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "341552075482632478", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 139) },
            { "738850098651678143", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "7139714914586273766", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 141) },
            { "18209157436315328292", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "7370360743945187446", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "7953255701516490034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "6195916781434462809", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "2400014444553855563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 6) },
            { "4622514167765722873", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "14680730265621679042", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "3302557590307975559", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7648248878470053116", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "4917917708431763965", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "12978593897559876761", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "18064160378597803888", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "7689593699365225521", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "15819149710195058441", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "18274109287723887410", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 347) },
            { "10269238332775024706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "9167138376243583750", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "5713105609160120586", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "150812658537571916", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "4485289322925780000", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "17268201530818712998", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "8747430148550634190", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16986358655784856534", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6109013751635776331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9585113116232600562", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "3503893875515897267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "13144385730409574259", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "743941460026466526", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "4492332228252010118", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "1920042803083729276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "16436006771518788093", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "17567504672169904482", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "1989849521691057108", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "8203171222962341018", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9795194069954915563", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13369603621524676979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "2930658435447859986", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "10721885719016335538", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "17663718302088575615", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "10749263296616139689", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "18356235677223229518", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2657828809338947050", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "15743750994087974449", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "754596461956525575", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17690103717758388022", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "1581136092002053880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "184306359395609972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "4891076250667414900", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 198) },
            { "10946917656449245131", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "13963558035989415263", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "13239946614209250451", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "1076938718721677141", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "5851532147278358697", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "5746129902873132635", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "11592511763160794565", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "8244393417024602494", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "10340341966852782124", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10014822679257636832", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3975219156915176189", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13536863026622428609", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11408010379683511978", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15458285682224384803", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3407965587245145003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "10514330767826407566", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "4251496064392381805", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2384682907808363130", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15705923658253281113", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6610298174133949061", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6801247431347692935", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7702208423015808353", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "625378771032655972", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6542436061498779527", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10220143644047641696", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5009829190055738132", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "9863034269936216346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "16547699848349226093", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "13369144100905854138", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "9490927482615234033", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3544673182881983084", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3575537018273879487", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "12649957341095701480", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2321767794934000238", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "14973431782875808802", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11948858355027908365", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "473983206819135409", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "6586872365879203192", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "18412999191021390737", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5274456170971167904", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9275398105290923887", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11340683391412454009", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8100282867486124965", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "6361758198448370863", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16431503579923509596", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10280282710562383672", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9138345765585313427", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11117326838088757686", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "18222598708685323020", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5198859831430501652", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16644329894881952739", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "9367630847798077790", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "4906856539144714227", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "14958085423402252319", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9835535945548454398", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "187589970359123667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "678657374277098506", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8434335101659807351", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15928128327390664485", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "16504425380504793738", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "6480587375918509253", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "9751235588096143414", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "16866525370343398909", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 292) },
            { "10160678465371702528", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17188750289444625186", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14811603003184578943", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
        });
        td.td.insert({
            { "4363379197393466424", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16403435599807360704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "9367985410929563457", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "10716232679616746794", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "622299920975636640", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10798283054583509534", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14179140464588572277", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "351304363117543419", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "3499106702307464480", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "259619428712608645", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3296098567244638489", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13593304587712966846", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "7572277082530361815", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6379337678256717737", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4513178474272034213", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3390430905253038550", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "925607706467451476", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5627536079808515754", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16464493408368412759", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "13839116996827687373", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "307874768879227632", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10308113903347312964", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6712698149192186833", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14930789530046665855", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2204178900998688268", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17174919737114915467", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15154700439767512396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "14916625550370402883", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "7650375560336513366", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "9999553425206328238", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "17515064188391421150", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10437367877444543776", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "4362304842016958728", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "383721620126444793", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "138379779469699309", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3759515057574218101", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2856601829807186494", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3286330985102373533", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "8159303545761286685", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "4056979460327024961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "17823133607491820214", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "7969441643457570812", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "970768445746568749", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "13678741578702922441", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17310844417517474522", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7287895452784411060", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6513788469599330141", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1432487477100132607", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2463151488506537801", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4054850047596998735", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9747825473942435842", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "250084243188516935", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "672634960435241508", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "748301576795035305", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14255457787105784042", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2750476114907782459", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10028244201873254140", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6469067021323571170", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10601714587235375373", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2483181247706575298", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1732853511466309905", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12113297049460198476", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11557224109907477240", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18084899872055349937", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2890305478244125142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "16659638340060273536", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7297768924198851782", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13104971224879807298", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5507252417827285564", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8511924860787648884", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8339235544283885013", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5654030701873405891", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1436723751951975466", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8325439593817651819", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17618112803233960227", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12327651080801123538", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13617891575616631067", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6020885536659393981", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1940159900852645250", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "753809225159529269", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8790166817024820739", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10677449690354999149", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10593983805743674128", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8217088979257009010", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5687085271369421207", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15279061373346657582", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7096501191029978469", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10094312347267495565", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3510084874150710192", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9391986481292718799", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5259220060268012597", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8117066211911522905", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10716559814452841971", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3949211089098986928", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14752151264004665491", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9195500778955925293", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13023666909692825369", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10961696014697611547", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "408602315578383859", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "582954161360487990", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2482190331248449465", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4075769657981876449", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14367142998060454343", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8114910678593187231", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4495451816890445327", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17102726573636919392", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10845009858831745215", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3112081942557253948", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1635689655354995548", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10250301712194120144", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4855747489298888657", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14238766089951260596", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7017830157652362654", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5619751660204221930", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18093663410921658106", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7869191330107002954", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7245974724868795129", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11019243479903456358", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12568255992252373147", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12413024322120393790", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17328716013187434957", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14899206494260920951", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9983462569671477588", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2383983224188083583", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1759538680129620900", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17194386925266836084", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1518413386955573037", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4104380387301024172", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6500468942462159659", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14136370464716049139", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4056919990977544228", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17351367314312762125", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17586380391909451000", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3561558658922596877", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3296755748686779746", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "534789472217562338", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10470060457279511896", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4917360877294344854", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3020953254086476464", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12307245536623707478", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17039711449439313953", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2734182509541824864", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14521225825422360447", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5857101685300045443", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1547471890307888038", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11159429929932958728", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1382911856313970571", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1854612313463195535", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13051406650237455505", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15438530452161762045", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7446661399223808792", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17861183465344343443", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2026622899016787854", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16127482065413259805", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12961109385388101976", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16855828799826043472", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15658859674277700656", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4833749391314748606", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3326691585067800328", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10718764522366711114", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13643973579671217152", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11155444222714959508", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "11544626480076777556", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14277552178674323256", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7792811600696842064", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10622803531832712558", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3079343528005019570", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3521119014097924580", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13643421651252474051", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6947390018658290847", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11697545935437523887", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2179704411405073702", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6886280732774854778", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15841879134365332862", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1489646217778958363", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8996027646503556955", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17569170625753249614", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16686854568163084344", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11187304651899164445", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14540721800838487177", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1979841019103384445", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13241679793873365192", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7013169017932712804", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17389114672554594444", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "4157112143322859333", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15217255896294251282", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7606241825090144098", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8254388198068394779", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "755942233998922490", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14018816117251124336", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "12054714986067446052", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "1138657035758391650", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "3767246406609050779", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8536612779196342267", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18269766292810651342", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9646020463213439644", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5654817010240784792", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17277846909615605376", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "102220157823566379", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18213629255325554583", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8809496195168645264", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8506262325379391391", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "555647031314007743", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11133391567691287018", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4531238775069637542", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1050921927000835075", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3929145534169458063", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17125607183887169558", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3771153805567862915", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "5658567026478236676", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14520461267731870642", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15949156027942399242", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14569379143051211142", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5083162050523454050", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13951906075577108679", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9004122893718097099", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4336765005970913285", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1037896951032802088", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12090010131585526347", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9035445496715584647", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5455756262684457251", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7013197348316253486", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "143894893069959052", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13984124581247009793", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17964690428632248307", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5850736343172747247", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12379881923680871705", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11864459706509310150", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15222102499748205072", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1198491147477454704", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11400303472547811086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "11660798111579160734", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12081136231782604198", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14508437224082799436", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2396983035676921683", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11489881652545443112", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5651551840851524311", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11753049051286720239", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "479427514681077218", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10277290426401380976", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4919635200134986619", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8180846581099717076", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6411489040870738143", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4195122768220068448", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "52150349468142798", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4439371893496638788", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4039813343849078927", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16533127286587475454", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10264270523529136771", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9915620237695279980", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7090467930115498252", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15407802086492754450", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4007960934134542892", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2002110062193477745", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10154803388813032920", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1939527596007045209", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18436843102627176620", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "277852397173940175", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6822978927370753017", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10859939917723763131", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9248235209454206632", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2665169698359670120", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18266967379169677646", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5047972486012090625", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "8183383667948205424", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14478151143114959230", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11396985422513105543", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12114476173765693172", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17041468169694105561", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16498300259966485293", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1173136780324694038", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15786764202107923723", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8913526950888110377", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15988378956341507229", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10993107955805947401", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6214677989814002369", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10884202393733523875", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4424960026145600447", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9763754389347695094", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "105055722864217258", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9775648000771985077", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15967893151722576439", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5774841809066688068", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "13402919586406297042", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11335142595937152387", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2689568881580764024", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6571325912136856822", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18122652705874970766", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2000008755333069005", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10361998183258703575", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12348644068948200883", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "736422312606696687", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16240864447025932692", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8589562027950762944", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9162564861963233717", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3167738956362101592", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7260746128189749064", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15308960063718398523", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10129304668926912275", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4853130422682926168", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14453982453535955244", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16608982023596566351", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2470663389603706356", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4240407752719875080", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4846563120992975368", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "3706088306568590662", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14866563628584464675", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14721943524627076027", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9323941828298277387", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14109366965145192619", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4923997413838231159", std::make_tuple("fully_connected_gpu_fb_io_block_fp16", -1) },
            { "181017193671999192", std::make_tuple("fully_connected_gpu_fb_io_block_fp16", -1) },
            { "10757412618207229106", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "6395263375773555188", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5979046470758784946", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3927359449523162508", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "18232387132890063687", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6709212639543074230", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10086813986911195558", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3109992766790372487", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "794530296606789816", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1249133049911188319", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2006024870459798086", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11914297820344167381", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "13079795735173763117", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "6241224766048532539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16524474021378494125", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4407550747921719377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "7259905085241841240", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "6666210546769702280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "7814543122045448412", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13554702187867408038", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2547880010597993852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "9061076702890952738", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "15460429275475874158", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7724185199575851246", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8533091468352267196", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15025120359649460106", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2613575328969629284", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7463954007838579697", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9151324495773628566", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "651020886445062493", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8237821273547216740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2875927974837744359", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3674322065648064195", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "137871170540938640", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3066826388383295007", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17483221428915982776", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3403906310423395442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3888283018836731569", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13928684419408478520", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11520548550630007970", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4922714504620931501", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15683804450763499599", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12686604223669447758", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10746289671948325353", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2487976264999747775", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "6163010595188500945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10404333823880552577", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16662409111036688294", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "5400706842524705774", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "17423097433955762667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "18131954418490925431", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "16549854027697846882", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "10340073416712988987", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "4633923265089466898", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "6808980404170272597", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "10592783998150232858", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "1594829714229111215", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "17361714725103230834", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "15732140959902969012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 141) },
            { "5796974850751105634", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 99) },
            { "10588059104387338398", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11738780323979052397", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 141) },
            { "16342972196376030503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "10406201782146034797", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "17342758321852264926", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "15951978466742016539", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14100026884590707572", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "8368507377481570353", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "2230145893895952661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "6320236287540885300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "3152975593520548377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "11756338894156892549", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "9310466098863912618", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "18376135355406021646", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "2024521518658822242", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "9692442768327912638", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "8031184163763974840", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "13429621587271813054", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "17938009873557420461", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "16780457022162749898", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17140702790441856730", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2578325663193624576", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8784358107340738205", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2955459120402821540", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2840794055129352139", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7104266560248570112", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11113125355390956764", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9127827617126714860", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "2268275392299271167", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "10615831454139478379", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "8205640825965213946", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14337168375989245254", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11664399629496237233", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15750539817895707253", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "921209976738626097", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8590416145336196354", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10463632805036507382", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13637537549252005181", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7581949584623524395", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9814647153117279415", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3444250649099578792", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4039483032571506874", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "14309249337788077160", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6254493271976962295", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "12387660887222981357", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7723131901316908741", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "13963554827358438190", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "5001552360784483833", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14201142257504107783", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1066668660701816536", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4664196755018349672", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1103228955716492167", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "8618835732380720921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8391292909068775212", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "9488974186647231896", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "9069334144391048686", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "12493863403516600413", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "13375084585444085517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "18040173797801558071", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 132) },
            { "15329174116169594863", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "14910223536998380801", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "18277685132620834972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "13090887980792573261", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "3067806959725855130", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 141) },
            { "17791773192152464021", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 63) },
            { "13603318842632052764", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "12072881177966014126", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14413047954443174304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "9118663018352672834", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "3558391988878894288", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "10047727261970275928", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "11527382293059267033", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "8445575388700666150", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "4560479630843098090", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5737652209336034549", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "1159910924058542880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "7203172595229334691", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "8153567933591966877", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "6069305481947437228", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "2216113049194620088", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "10395837712676962495", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "5041111302824362529", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 164) },
            { "12542825714985999760", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4599539412023802059", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "4570119951370893062", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "16897917745917378359", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "6947523163603267191", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "2322126126611987721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 141) },
            { "6518845972912144959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "9741774854327055438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "7079854103926842364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "5035895518536085765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "4307157272240924516", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "142486914279119363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "1532263118203058517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13529694429433303321", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "2820916926593580316", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "11140657515428786448", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "9028970753877215614", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "2324120381399737261", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "14311837335039030749", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "6105963806494867023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "14746731245428677019", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "9213886570531053949", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 41) },
            { "385046297070779752", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "15882699446713091149", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "475043738497218394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "6351347283201596793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "16290626406346691996", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 14) },
            { "14038308632095412386", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15928183143089896780", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "14071202918199194502", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "12383676694875725364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "1830378766184274696", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "13133105923394042921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "12458275468325297142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "1819720745131968914", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5140267554909755437", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "6021498606197929608", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "5832188635321350875", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "1411786954276574458", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 280) },
            { "18193548056717743576", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "7989522965312833517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
        });
    }

    //KBLGT2
    void tuning_cache_5912(tuning_data& td)
    {
        td.td.insert({
            { "4583484812233029888", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7560832358324865221", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7382044526960590018", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "12372261924257291610", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "1547771611689525848", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3134973665622945888", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18260030211719729324", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "7416143717989012766", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "12028963907131702705", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "2464531851392092325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "8181308759455478086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "546062289721803579", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4889405384318695802", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "12841232643395100314", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "14108361259911144680", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "2726453304845436156", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "2607416795507802412", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "2175404966338020579", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "14666883719480623074", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3752993663604843837", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "5274735654559844733", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8174421295799601683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "1967655354607438665", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "15762542971370422224", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "8183203099539372914", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "4075343423548891274", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "13264497096898621015", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "679058537775669048", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "3375634256357960999", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "2844616672368585285", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "14235558866846276172", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "18066867692765966577", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "9861424412782371874", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "607078314875528651", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "6234885984223387670", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 133) },
            { "7223570329858821704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "17234843749633035510", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "11516168882438876247", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "11312664612825940140", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "14846039494240217143", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "3390376200501119384", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "1113077760071340574", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "4614875083188849196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "10859023312681572942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "5588692131556725717", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "7653946972043115920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "9773458066743315157", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10491513939202460216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8140122945471321201", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "15079423575410353790", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "12844146569641472927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "13443914015380511668", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "13404457916017756196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6402415801415013013", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2040762223425679479", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "8595156989254845134", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "14493123117003003092", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7391309333582046386", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "9935182178960843140", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "15422142509105297183", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "14849987788569183527", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "14923132847727661051", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "13271555597925466454", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "6865593216823998846", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "12385437755245281331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "4530047829451377456", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "127643210248119703", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "2599051617462913767", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "3024020696533545102", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "16205377892664082400", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "15135655146332608939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "10848724554175904486", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "15558120704022404428", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "14120354125904513152", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "8475075092501403968", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "15892943371777404347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "15078418657871922661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "3502053626453342387", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "1230316443026403527", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "12846418701225147646", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "17386994561779281406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "7367684259946371231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "5451072983028714092", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "11758623888547009364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "15958650715061024845", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "13899144453581769028", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "10884229860266073967", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "6629431845229592220", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "13199442294147992119", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "5032929712205664246", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "14871333176552512036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "17890435688048047959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "11353661571093800805", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "3101908018947919238", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "7495240482209084478", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "6964506613327100469", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 101) },
            { "3670645005971806718", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "69949758775887534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "13654393413005772278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "11101512074369779300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "2273811004985590823", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7457154125218067377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7709677514862642399", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8010619564572573208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16479793487852125428", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3147355028342035061", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12672939642957531547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "12627961914394914920", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16210688853876861607", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "1899485873740458557", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "669151029135558505", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "8912067280071688393", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7714589858275971005", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 196) },
            { "9794413496918699979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 305) },
            { "18350040136091421971", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 287) },
            { "16931304566154830346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 305) },
            { "12816950084297042217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "2359632276970855181", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "16592641501972654496", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "7754054384598160936", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 196) },
            { "18195884921517044108", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "16256130331524359070", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 305) },
            { "13497279823712860029", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "6095972148204769193", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "4149964766407000732", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 302) },
            { "10262104071809780712", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "10707129891337660055", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "3585075254981736756", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 306) },
            { "3181067565488724209", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 172) },
            { "8636008354706344794", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "4966150965920189853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "5569253153294942795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "11521347729886549503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "12399471154320580621", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "14851218369956754103", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "14859848826604327499", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "14783159891899899660", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "2369671961317151564", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "1691004331056506231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "4465288557833228023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "13538111995551348621", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "1886751914747841929", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "8445964247944285746", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "803205084059316676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "12654698468722759675", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "13484605287576302088", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "2469399061693302590", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "14782181149367028912", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "1448238652280623323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "2076478920663115306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "7369834759425644726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "11702633755046828968", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "2944972038827287015", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "8261441437673092886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "16694312773479519523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "5486494868955566721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "8246009573416434030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "9457894602447879547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "4598302923247277427", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "3116224788980631217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "17103527368951412486", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "10150428063205056209", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "16984028253790680977", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "17857105233471273424", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "2715609009808401074", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "232807837985324954", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "13933912937625580405", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11254635684957519432", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "6729077823331194042", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "15961933828477762733", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "827225131390571924", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10429613013253088132", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14629385997654952321", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7546586420552408243", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "11897687507601277182", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "13975409361394567866", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "6458124573210430792", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "2385616965635993249", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14462438074931673266", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9338654554616107568", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "15476402794704488137", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "13654816209891478730", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "1680424228660495363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 109) },
            { "12929981792125924963", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "4698507050987130777", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "1094144958579794349", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12358908585763044267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 287) },
            { "9793373151408615612", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "90849151510482266", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17277787450259342076", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "2367877811435050998", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "433942345363552443", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14575816691130255191", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3675622521877371819", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "7601637686045360430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "9818496628902493298", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "377651990943545344", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "16357661916741979192", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "5417669424921804056", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "854020380490533945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "11984602132438314210", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "13100228219613095795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 268) },
            { "9808704199834907703", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13071373212254908241", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "18392748682101174561", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "11928475964162658765", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11937547211842355800", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 372) },
            { "4637568849323640167", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16812695025037565299", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "10487883723723512839", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "15315014737515653325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1579905786032546689", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4243996335899627971", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "2545885699369058867", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "16926950874716567095", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "6355395905401306995", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2096779676054335057", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4217179485243909459", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17101789600628162503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "6139574161497189424", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "16559140502701231107", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "11459784003592366395", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "7869916853707978306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            //{ "3889519976910355277", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "12081835728078383819", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "14923692894655929923", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "1841901358010744236", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10888203577545955226", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9799890897264103013", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1827296932806936575", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "13010820430079828498", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "6245781545617904772", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "8714031312599034571", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12922099252166105096", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 268) },
            { "3042887030242700493", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "1419879016567682338", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "12870587285162108523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "6103433181190121715", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "3469599265931338557", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14812617666668076833", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "14854734265631496499", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "7637441820772916248", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "14695781272831602408", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "15696910741835640150", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "17790593820165047954", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1433224983833208570", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "16185194021453870096", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 172) },
            { "10310918050196558188", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "14885938077915823034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "14442357887993453368", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "4719130523147011420", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "8870222084473246330", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9350596936816632825", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "6183248276225219542", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3757195189216622027", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "8318857994507665384", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12864512857659000129", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "6615646900347529347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "5208923086986567490", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "9390793435913144215", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "11997629302296435180", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "4858270366437120918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "15975176007724247667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "16837473534895641370", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "16214153687871223428", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "8858112708913743577", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "8844677471730173649", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "9043742986995534354", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "15621341038256548867", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "18268980125375728709", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9757167087033785227", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 269) },
            { "6513982093384445397", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "9273893819042428704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "8270840662337272430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "15021512490648380369", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "6578908625437515675", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "13762042713029963144", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "668798769117277023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "10917498758625273194", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "14335423820860953927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "13978750151855895830", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 120) },
            { "8965747921518186477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 43) },
            { "4428101657497677982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "8151272056391095510", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 63) },
            { "17656341100957270390", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "10295330953350618042", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "15901675909820977223", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "6026876733674266377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "381149736509958403", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "7962991673727743706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "10064251191248475177", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16663239694378513014", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "4690831975451405214", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "16132498413588349821", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "10609644803793651808", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "16520784657717262379", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "2271187702055786721", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1872921634399989626", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "12535576637355537200", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7771729980527620398", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14849108908297747749", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14043770215999952932", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15277856047844308598", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8048617952947915835", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11446745541571732900", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17422822627612865758", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "13954144830230671601", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 340) },
            { "11198908896401597838", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "5582896843095691256", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "8133587696326295326", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "2007192658799516915", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "9492402787848610840", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "10515519878978734341", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "1375156980278317418", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13455881643467418059", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12788968383428254917", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "12304975739476881266", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "3390014193205017427", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "13587202155230938291", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "14462744723628661203", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "16109721499545711936", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "10090923790949378407", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16672038432561840773", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2973773544904290726", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "17193614571243427089", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2862029728492027826", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11066930104187448422", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2755147389712995637", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10662798624911535617", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "2172121470071868949", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3579916582911190192", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5495063314176654751", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3771003491521695667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "15514370342945522276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 221) },
            { "17285639145064557279", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "12642574441854544900", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5471430682416582179", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 234) },
            { "8561154029325525444", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8939900194037985459", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 234) },
            { "2129726780118554358", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "15463465056816958579", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "9268536904925062469", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "45977313646881991", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 361) },
            { "7092246390386193774", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14801984300948838261", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 233) },
            { "2797723586312707948", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "8451212914744825089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "5131348852069018593", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "13619081494170885939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "8818679285688095197", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "4608292692528881356", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "9729987752669765456", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 357) },
            { "1782966703272153440", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15641674846325113216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "18140951659547259039", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "3416294810798281053", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "12066560812164094695", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "9332596500956923556", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "15067550526427941795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15428062440621131394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "8873614802459592665", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "3367130693014583254", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "14135594471530769414", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "14971707650115908544", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3036512701943687724", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "5334291640387922287", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "16245760498096322525", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "9928406318940388716", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "3369894612786523432", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "590505356692040012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "13240472672791632740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "7128145024365641089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "11497327844388026594", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "7301757962797024939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "18121689595247452649", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "875296362957469305", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "14912119584313592912", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "12494969618927201911", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "4640611487944119712", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "1692411934657235774", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "1673006919995519093", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "10601835610089648700", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "13262672660175739705", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "7639015398436550592", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13867172651521406104", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "14587150810299279663", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 355) },
            { "17271409929705935575", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16744813357455687598", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "17215047912921813592", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 370) },
            { "4093195092417588676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 306) },
            { "17895953872149392740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "5918874715861160937", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "14498368518428801865", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "13857947326347149693", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "4965619590663772423", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 305) },
            { "17153828952517174005", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 306) },
            { "9864812885638557249", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "8410695282651246173", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 172) },
            { "3011957000022205132", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "18202466898415347292", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "11433166800587133728", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "4499160027703324879", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "10225878843410985743", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "10961131057009777878", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "17123897723015586893", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "3938875063592179645", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "7589320923145169660", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "13907115679251591389", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "5262155845067632954", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12323619994816664201", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "13711624246076632711", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "13879644216615040961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "13418213186769741623", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "9850414237385072276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 101) },
            { "13762987373425432087", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "15387492794262813616", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "9455446170928387706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "7799083605029182328", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "6416346888102436677", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "13401162817870652306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "4574862993950020539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "3956303186129893250", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "14928794187754412027", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "9892597035419316966", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "10290107543739998181", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "5275016494706355806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "10947686124973711385", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 55) },
            { "3997597867012981671", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "4003433148846544263", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "4361250474585164062", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "10523363119855336043", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1718324808394833635", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "8430284238380067998", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 306) },
            { "3950448771871155887", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 289) },
            { "9033877528655370244", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 289) },
            { "8878071105867359307", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 292) },
            { "7511984934520363336", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "860443413504997114", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "4957638663977636791", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14793503588688729262", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 286) },
            { "9303039486341715392", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "8923406201866512905", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "14629889085799380442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 172) },
            { "4811310048537439646", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "8622985922687454592", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "8611046137980763541", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "1879796404388368873", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "6928835003016610382", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "8603207107304593583", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6477198553362516437", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6377441002585730862", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15761554874575656075", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 93) },
            { "118354408955419547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 108) },
            { "13601202334102031245", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 101) },
            { "11716196499333250570", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "16984923535088627888", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "364996668506826202", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "6412527114952548517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "4892959859293355837", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16127331840410137228", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "13335944978055152562", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10715829903767495958", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "6065404265303390338", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "3897655522585667381", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1860663592951633878", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "5698748062275134041", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "15945452307780131237", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "6764685582382238740", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4737109912659941670", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "9371952894576491521", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "12696412964119109465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "17825874529822806486", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "8220763890959777277", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 348) },
            { "17731591992960147987", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "8950668477702067729", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14991602704357959545", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "16383540667048742064", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16820082917500285799", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6820284286806022849", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17285815901490707654", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "994182747184593564", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "6642767323474835034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "3215659303601163167", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "54975980454651672", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11529876081402974396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3644282167178264526", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "360872770877634346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "16720108310653948550", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14353390922580547467", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9868561386826862471", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17465517455679097501", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "5570311824197099845", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7524311370696987092", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "14070988879848388270", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "8296551195150971668", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14352796912241296357", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9840495023131952174", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4720851194954041037", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17009318615658405230", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
        });
        td.td.insert({
            { "9421643783312790618", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "10693348571961406417", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2940027113687311893", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6090625728451718945", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "5643908654122573882", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "8852322966320229583", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "11185156002426041243", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "14670068483447729857", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4623542918584461522", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "3126708271410621754", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 107) },
            { "1434535531617424039", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "17025268985366223779", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 109) },
            { "15398976608777968810", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "6149673627320838019", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "7413341807736193935", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6071597471486669736", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 285) },
            { "1127095963814993729", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8611856835854445891", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11115935318793891293", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "5393081375805921525", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "17589256877540537468", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4135814997524960840", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15180348902159643465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "2818524781020760666", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "4942080349816430490", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "9263314249867362", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "14377032179148581309", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "15245529372955421912", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "13595283050046771323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "15667549927492357263", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "13827442968070281886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "12076060884099762835", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "16532386511585070092", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4910582540370962997", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12335148041391647118", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10689880083512104726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "8870164706606458004", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "9269498023794081940", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "6779832349039897240", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "13942354789498444722", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14294764660016835141", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "12323510278692809329", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "5728070995112243570", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5381496395266530071", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9712640406795417230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "15036737419347383878", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "11552594222313787816", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9399255910184037480", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "10594581016504135920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "15640487942881889055", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "14165417928501578590", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "12251989236991754721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "6675363512560434713", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9831713940431605743", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 123) },
            { "6531349504807709133", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "2726501303929773572", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "10439704858943788014", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "18137994263450376706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "5711991739289045727", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "15255831401757117660", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "3906658058160172747", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "15823433297099049221", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "7829483638597533960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 123) },
            { "14092273913846393837", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "3746578485711843646", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "12228183555926126959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "8776893332387904786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "16672299044236704672", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "13309889945947393850", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "15966815420067673043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "7415938485228396256", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "9655590024687998403", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "14798289196964890724", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "9794684437872784678", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "16729204245488754836", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "15185983488152870534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "13821372148587948765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "4727004015814244856", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "1738348894912205653", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "559491455289877068", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17312172687490475177", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "3470176432841342662", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "8950283515337670839", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "3995072673238444396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "1238913228370790536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "928677976151553489", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4059887681292863495", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "10493952422143348278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "5610465912655751128", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "759163065093339795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "11300938516591867859", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "12843263740221725967", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "888316366026890514", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "8088645310090149658", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "15891058658954073255", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "3456538031339928220", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "14187063304165334647", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "11593893535334124231", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9218293603091125898", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3614865264081581688", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "8860682105104682547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "3775781894241463386", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "8857354069987696352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "5611508857136313396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "10872828113308792940", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "3726594456692340607", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "7541331569935741737", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "5639394073086652531", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "11158391063762007051", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "6319861294308997034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "6893801771793379570", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "9015970699147699643", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "9252735579930779632", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "16237353798629485972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "10916127635689513485", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "14631094106016920364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "5050075828787158563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "2277573429750402800", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7462044209068160751", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "8879836520351993142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "560198731460537880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "6414187394150266523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "15317838148382459105", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "11219109605495282242", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "10404790565578782014", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "4657890394631454901", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "4256171754976506222", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "12658039760507507230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "9883901352719605734", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "5115148310176289236", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "4892280615322354003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15491567059821267605", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4716932801711295063", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15559962129967760292", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7866546777503165080", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12994023006726461909", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1869893771689012539", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5635187738652974532", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12849693339574251399", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13233683642200681957", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 291) },
            { "4310121962651039089", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7620758476872568593", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10344702612951473525", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 194) },
            { "1668590302432600271", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "8750610033922701675", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 292) },
            { "6913992575736424382", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "17945230226911262869", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 289) },
            { "7356559449640788577", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 296) },
            { "18349175655630268884", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 296) },
            { "16817085704588915904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 194) },
            { "9503107262691437536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 296) },
            { "15595806193584438610", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "14283867094396458105", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 291) },
            { "14215445060938730397", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 296) },
            { "12720976113342879024", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 296) },
            { "14766625154638709852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 296) },
            { "11757187678986741715", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "13038212285326297688", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "13919423909034348565", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "12925256096286953030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "6275163484075546689", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "239651884801599911", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "9500211224156027451", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "10902538092301362853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "8454943813981348115", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "11722951613064434115", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 193) },
            { "13547342611064538960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "15171119202712914112", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "5451487099025245427", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "1814940262511664251", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "16341609351317463829", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 195) },
            { "14343280871046671393", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 193) },
            { "15586404971308258630", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 172) },
            { "15891211707425019144", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "15351688973597240327", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "1844016761754156672", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "17925606428283439978", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 193) },
            { "15050158761219834868", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 173) },
            { "17448180555072943363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "11422222075976800614", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "14284377769814732906", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "667777413731244716", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 173) },
            { "11624071786842686451", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "3874974512053082278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "5471037497181745651", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "6371386660654628561", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "5331835606773958814", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "16163821504542698475", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "5697543838890997891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "6217438921274668801", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "2633095809604510774", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "11218297661079136641", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "3374196543196230185", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "17797320202829145544", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "17198778757516749818", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "6440981718484677922", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "1616603916015535857", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "7643715911083095268", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "137903092932521503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "13203019690952060789", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "3918152537861570517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "8782903242853500098", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "18312668164562040079", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15160703466234996170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "2751241748685218213", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 123) },
            { "12622728760401804660", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "1290624457831957354", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 123) },
            { "10924946887162830574", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "10789202693606479024", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "3718558874911694616", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "12835389389575311182", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "17406431092101974143", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "1400409391266374603", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "12154660333025778322", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "4800587664660105589", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "16474284418841532356", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18117355153710110681", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8449591498895477846", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2962899568083589487", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3491333679577961640", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13945298510228460890", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "4282198629458668761", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "779525528509830615", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15002237905129290671", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "16833026567865627676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "16991060247581867302", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6902644989079870993", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "15088285782819494786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "3379661203936923589", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "10049571207493913006", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "15691689005236690951", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "11275109735493317886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "12220860296984467101", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "44210723233569665", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "14014987361364503383", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "18189351665719757712", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16159032667792855758", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3374037004378790060", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "6765409971512438438", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10098892297878373639", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "981877665302032867", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7472350511000146655", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "15513971895394346930", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "6169721205327431190", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4519054607159036572", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "12750124851833311828", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4333851142313192116", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6041620003527819661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "15091361629922645798", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "9348121965341418899", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 102) },
            { "393951904144235223", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3220084080191614421", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "11610588256244825741", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "2802357220980817497", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8972812517118478580", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "4207115359813621211", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 79) },
            { "16582237002610438015", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "772342953072606219", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8546247990965609013", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7971830510840138313", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3570484486449791727", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11461079340079820563", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "12663860560275361463", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "8132521728369930959", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16108573960501496757", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11086699387784339943", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4013707396889204359", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "11850332373794932468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "14763982961176216679", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 102) },
            { "8207349115037232863", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "3273748387141431306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            //{ "580936360000782237", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "10682918518101379579", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "13178480813522103091", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "14472322679644532468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "8378137527264154204", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10180255575636684134", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "18242121098885244699", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "6178572652675599622", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 336) },
            { "6558074021146321216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "11038938372264857379", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17137800360536507200", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 270) },
            { "14016185289182597841", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8970519484272874266", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "3289746379259038515", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "18389174979070260315", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "17666483005735191253", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "10845781902676865789", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13646634862315619979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 336) },
            { "5072154928583891344", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7757331094141318304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "16779678846332091086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "12223166874490429642", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13316017702896072758", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "10390896207372295988", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "8386498395042623384", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 166) },
            { "17923632501885139982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "13398326377839777956", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "13520557646924372128", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "5996787039089786722", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2626376166907387273", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 171) },
            { "6147643392694904814", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4311921348668650791", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "8046109476498335792", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14190077682825257613", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "5032302126047788183", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "15256375572125522238", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "5083173538217738703", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 195) },
            { "17269467004855120308", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 195) },
            { "2901056469731554922", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 196) },
            { "9747637051217505111", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "7175860674618956918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 291) },
            { "9530922411870814200", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "11015319643831560673", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 171) },
            { "5182740559503076121", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "7567277014404457462", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "15973842639221447367", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "15951492056203075273", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5283253936050062275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 178) },
            { "17650690912303447913", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "9614936270604202220", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "13998661469619523378", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 140) },
            { "10584034255622783869", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "2973436171295280783", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "1908809004094565452", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "1623383628456201603", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "5766507688771440170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "16626226341188424071", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "14619055893081624406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "17222005830854879661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 41) },
            { "14224121742920800990", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 167) },
            { "5859124386313585730", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "9596156698919548146", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "10482582307328548806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 1) },
            { "407189201971322683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "16626507949474235269", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "879005904827468163", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "8460847842045253466", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "2729099061601852493", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8233922303282945338", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 238) },
            { "7402006230339617617", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8420763628389536977", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "8325767678959979628", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7673672840505587739", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14166169053627992481", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "120923426036313670", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "7348084298010357768", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "14653065651448352526", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "11008522061447263744", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 342) },
            { "305505245310584136", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 342) },
            { "6472139251351862598", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "10586018593856542117", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "16706121580364790904", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5495776091407365966", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16430562172386510259", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5673972310424776040", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8797843396807284399", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "1698321314111848001", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 342) },
            { "5762290464889692462", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "3218248162832023196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "12988961529988078346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "4232250144427804891", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11683680166617045816", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "6252429564537528709", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11717348577195224554", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9275303306340702111", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12245096462203481681", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "18439435691655740074", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "15272426400992401555", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "9136831791301215059", std::make_tuple("fully_connected_gpu_bs_f_bsv16_b1", -1) },
            { "18238669114790278675", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "15376246520426368532", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 148) },
            { "16469788155263456039", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9360494451263553093", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7897877428349481398", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9354818521586974021", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5853553261686771766", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6351572488552853754", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11372638316835753193", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6170074103544756465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "4544242784357021697", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14225108809796795520", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "178353385245384751", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2002574142025049539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 364) },
            { "11630971824787392820", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "11542493210215136239", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 363) },
            { "9595803435783166868", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17610828776103321939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 238) },
            { "18312069177632970412", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7577483892218843723", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 237) },
            { "4355933224673863178", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15124932296735391043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "16888042302987189589", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1584639932403433303", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15516194807992507442", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6614374536332038989", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 237) },
            { "5097818987523855112", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6623182990939010641", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17001023283013862129", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7935150275452094595", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "2326323992207208685", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "5072735784865711772", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "4683841893192741312", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "10341773151035665956", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "14109534738984061372", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "16706244336960642883", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1967030672241059921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "1482100699000420627", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "13632911653636980024", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "6198830126915940359", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "12125006289181390694", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "14152716242882609401", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16732621354152092286", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17921489101554455214", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7384108582424003436", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13139625572508441980", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "16491532291908469567", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "17788367809717898285", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "1509728225855233852", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3816705689596666600", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14157505468412850916", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 189) },
            { "17366807170224886960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "14548509699664316785", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "10404702662303016402", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "16436357970364549479", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "4858167644379876157", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "4381329435655511217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "13972357557211413688", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "6580334406272192111", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "194072522984726408", std::make_tuple("fully_connected_gpu_yxfb_ref", -1) },
            { "4490223883171428014", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "17194603517181970633", std::make_tuple("fully_connected_gpu_yxfb_ref", -1) },
            { "6995235840871804844", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "1671208365782918441", std::make_tuple("fully_connected_gpu_yxfb_ref", -1) },
            { "11718418772370938734", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 88) },
            { "989564341557094953", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 54) },
            { "8133676065307881979", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14555883089089918919", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "14026570177552137240", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11686670048744589243", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6678796313875454849", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "641417817126876622", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9622546530872848323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "9194788897910888066", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 342) },
            { "522181557896569275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3332334993503432420", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16131448347558322280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "13852065717057446998", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4342360467977736802", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16336482874764861478", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6075691042233712335", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7570346182940928159", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12971822824884826169", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3033264172690274208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17301887391757619741", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15790005937034794347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "15464327246951632247", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5659168916726488798", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "8079376692609682448", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15160738482264643601", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13953639482255428227", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12293786134765875615", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 236) },
            { "18214412375127043522", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10670103699537731664", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 237) },
            { "10147266284710177932", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11443268857010762276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 237) },
            { "4659943649635556150", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11726298758004767743", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 237) },
            { "13896680298436380632", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3797957937905580811", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 237) },
            { "16294962940703055933", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8526484907799590618", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 237) },
            { "13723543003759101485", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9873647901670251106", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13268525255152984893", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "13008742408950833847", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8616686489737649890", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "11423865221956815041", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14990645740260870030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "15204453579641378742", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10892456883214928095", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "17856816245251319111", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "1799430190598598671", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3106591708459602370", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "4111904926378218826", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7678457226823073886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "8786249783185140623", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5389189982064081933", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "15175088047384943892", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15331103261044247142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "3627273785739110683", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12478309735214802531", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "7212944937255713716", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11873734271080160669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "18421820525219154881", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9553032671453999824", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "3860603464276263676", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14115313335378184289", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "9519623751582710696", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "10288726118862235940", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
        });
        td.td.insert({
            { "2231648183489019418", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "6316097202867006365", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "16208488491972128275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "17978026144659698965", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "2566302789609970663", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "2714742023091949586", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "3087801652564627458", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "8602155166799218249", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "14230385851791760020", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "10828719108804915700", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "13973179950424276578", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "3668927000317872012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "7947870656736319919", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "14767888121198814523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "10401632438377178271", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "8762901342272872498", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "10783981060353445280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "12608289345175485333", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "7875272450497189442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "1599725688135122629", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "11932770338770247767", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "11184047387366978375", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "11716771904412649891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "12576157843776905380", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "8402692278765063674", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "6781076363516398481", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "3255465741612432300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "9767950219863105043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "7134654288295280046", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "5821853991835395449", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "3480732841490521799", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "6973260260946088987", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "15649927926091502215", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "7910468668367486698", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "156456996459945842", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "1994927850993519406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "16431165572426232677", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "2864254144951744544", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "5390559917122707732", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "8378839908604146288", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "17163158934005653629", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "1185280691070355160", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "1999979442136861875", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "2527189070714658176", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "16032797290430373799", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "16783619135298589974", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "12785335515281046438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "9216608098626790565", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "18257496796879980386", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "2452226948562393335", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "11072545690050335239", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "12668149981216388765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "714898562476771473", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "11115684531624462986", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "8710684853144029787", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "3752171257634205726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "5243587439683016777", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "16881283637687482989", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "6042976104660344109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7351733901977025859", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "9341400376014914418", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "13713406612642090169", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "683350872280694452", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "10436819182310112786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "10269788826827249402", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "12558716383635737426", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "7181186153851700294", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "8107447526839063293", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "1016414921656805365", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "4871907623235871050", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "15539976365475470623", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "3880189981766119529", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "10154958553575016770", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "4561874206785244358", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "12358640399843058144", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "12956726277674279950", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "7177837234452118325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 9) },
            { "3160080179644173650", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9832551412183684637", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6347790007333387897", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13219313818719819982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 148) },
            { "17780553554354185249", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13315473376247698298", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 151) },
            { "11815135771923538945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "12465309202808173810", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "7171436879576678563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "9407046952012845638", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8805267762044816983", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "14381377343079009210", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 111) },
            { "13248818835662551847", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "9300668734746602663", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "7706778813807762766", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "16991433003318725315", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "4584399194832832140", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8558026087297588736", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10198351802037434471", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13257958112171706655", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14722464361594874490", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1544616395544118800", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5955569479109539856", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17738708576252096108", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 141) },
            { "10276056345160651377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 296) },
            { "13515249925520423329", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 292) },
            { "10055593174764596789", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 292) },
            { "8707130584661395715", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 304) },
            { "11161176476048297041", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "6959258479021077609", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6365109451272429541", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "8191978674781978488", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "11604224659996035116", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 166) },
            { "1759873215866222608", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "4559874433048442047", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "6937259685509040959", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8242732346001884230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "16156727721974657541", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "13786314015179226945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "4202371435873473624", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 193) },
            { "10933135228023712253", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 163) },
            { "14467312749536832362", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10557843071473489529", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "14967016402348718219", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 162) },
            { "7594056145185406157", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "12051754199123379659", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "2634827464202220192", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "10211888372266149335", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "4548339182509526896", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "828946941343000506", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "13008375263617223352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "5638301531544801477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "10213021343800816450", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "12000084249129063723", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "18040104088851490930", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "16394608147869554267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "15229178454191871174", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "5927467766675317093", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "4877661058006573128", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7515937801840512449", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4747017546101861376", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8833751655076849826", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "16256124470203598218", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2706523860113152678", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14946999257618007034", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13699343107940933196", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2887515984302814699", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "4906737644615337997", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4725303208352054390", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14955652052550053223", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "862470330257326268", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10381668587006680936", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "2593337359555305520", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "10774393239130591748", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "16247780189312707876", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "4487284881658782961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "2811240876735166934", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "2447678508469638445", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "7454164784767168407", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "18275848121133385773", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "13759457214873634937", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "4855959048455906948", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "7160112985819045832", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "6880424067049089394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "748023061136366353", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "15793120434966402276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "1932618420321708351", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "3336444565837087463", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "15067224168014815918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "4431271266410883917", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "14115818307364071162", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "15250928896997938213", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "13013685738525906988", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "17607598031220186942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "10278583197921433748", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "5300123851331202735", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "10751381988703627540", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "9905160045246767203", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "2927340528757005274", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "16243861301305882872", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "15004681374954252324", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4496537089364942280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "13357951046545317387", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12878719705192625362", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "4785466104509327241", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2416244034719176938", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "17785504548342377669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12811319921474895164", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "10760000973615798613", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "6300105753728135778", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "5791707725846814784", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13246629627758485603", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9400558994532871122", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "17865276008842107020", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9981156409872807880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "4626770940790542333", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1094262369519841857", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "5523297987528243797", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1789389636704094004", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13544237579827433636", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17696244668222870549", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8926171136732424790", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "16179159307898475953", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2692291137583386471", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1095433004701276122", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "16277739324697771064", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 347) },
            { "15945243427420522827", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "12296021067910843036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "10673589588224406026", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "3585431879296991112", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3119002388778552316", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "5322582996019286781", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "13225749488949717853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "13207215182979880133", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "17730578026124357983", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "9725306578495355500", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "5277508201756602822", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "12806959657459851511", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "15232478805009654818", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "17712227426604098630", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "2530975976273876727", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "6232318392696042532", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 347) },
            { "13657818175298160631", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "4088603773237062922", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "11177710514557128293", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "17515272254985846970", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "312130674630486188", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "18247095696433793115", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "6341728273786101457", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "10401462893795799864", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 340) },
            { "3032101782888447048", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15078331029547630371", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18043541805861795852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "7608435380564752000", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "7129337563584588644", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "12204270722180734542", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "13588405581356678469", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4986281570682617547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "2214420531345686129", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 221) },
            { "15030725973433075086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "15384520760315696372", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1915712383376159541", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "6176816506826300479", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "15331830720555178784", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17558578036713688769", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "2388815483287403961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "15948716167523201661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6787190800192250525", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "3378135802544446861", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "13053802967262518173", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "5503306970973862635", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9417884304413500664", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "7866083951140251349", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "10084810175406860705", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "10342347371769114236", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 302) },
            { "4063042455950354352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "10055531955039754920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "13173341667656398216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "9356247214800869277", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "8630592326601832361", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "5041676938441886628", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 302) },
            { "15379755045295790608", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "13410979599123644577", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "13504573816477550406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "4459291258089899503", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13992993617743773278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "13395962624719382401", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "1535675815795592775", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "9849036672784280133", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10780684483689207763", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "4060515618437959603", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "9203467651096078409", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "9698108593334526558", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3252398754887381352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "3120759967333088019", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "2024996599975373573", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14876099702827489987", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "8653894569484019347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "4004518396368398824", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12801342874692090364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "9387557098916352467", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "11689587446775003898", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13973363990921590224", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "6278030053136901802", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "12122586525659611649", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17711197779492504718", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "12489342380264260364", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12148845150031891038", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "5080727465135503101", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16818862727193981112", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "1827977959922344361", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6291003899324240633", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3002862967523058894", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7222921168135747513", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "8696847224485998117", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7453625482178960081", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "1472822945750487574", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2032419134020329477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "805104869568121149", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "17215312565214990348", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1737128374457513820", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16263489451695566992", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "1608378717397996752", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "14346703182362139650", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9744493065276230785", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8331721527098298378", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12097373631649932423", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17442035600389810700", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15953351443307161934", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "8740196547852036537", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13809436837912218131", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9722172495422643735", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "2662628817605495834", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "6163765140843670080", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "15662207751131195569", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "16494358566119044242", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "12641727819019838301", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "4917595053453614536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "14577496472237742721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "4356806313729405658", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "14282717676967464809", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "7275701540104992761", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6459003512612780875", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "12791541622557283904", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11882713776717158678", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10982479758700194728", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "8714769962126708854", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "7639744043430667021", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "6804493132858449665", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5204696395552974337", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "8893913418784905112", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13496918758899426996", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4707842387180272918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "425930963222944558", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "3844246198992827038", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14280128364139551919", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "6774493262072228712", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "5670860641930464485", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "10055923266096584825", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13508499324621059445", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17431631935986646683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5568431877348597159", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "356320499267651746", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10632294140185068783", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12339584174527699309", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "8556999353039153661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "15381427144405510339", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "8855986581847188591", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13704396706685353016", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "17128550517647168353", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "8625183189646433895", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "7921388663815287395", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4213330047036138895", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17034122796081495259", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13076343553185159307", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "5854267518455107328", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13675314612031135613", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12825029449351875037", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9397711809671506538", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "12965800692507042874", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "2647922515901529845", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "10961049607808752432", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "13988022841867948024", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4612862531793961340", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10950469938532358632", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "2228733394430438519", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "12015814430456201522", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "12344008430499496640", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "9863615330219779441", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3560058786734628608", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16047381404034145819", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "9714811479610938662", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "7306541374689856571", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "5689486642279577539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "15545653867155770893", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14910368344505819159", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3220771309796407003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "12786796142417489350", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13947140171097868740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1168311873250200110", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "3495786143085325748", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2164537487697642190", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "10623345643437043886", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15240415102190323330", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10321975076426598984", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6467563111927343808", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "4280198021826662216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "9464830880142854424", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12113781253211924677", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "5410693492803892704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4844529595057806427", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "10848097581672953022", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7947428837044782745", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "11705938507822117867", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "8334753494554256932", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4995468555341975721", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "6282308289220311358", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "18275232300842488846", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15754022314306112499", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "15193841338943103284", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "956475051281637098", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "1117811515417136925", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "760383787039304033", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "5351526116347538406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "15923292837937693143", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "2954421933443715181", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "14945079011377285773", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9573520179708447727", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "11432977101529429562", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "8918387046558682780", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "16699295198130950587", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "17358462939783262207", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17406383217119217230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 275) },
            { "14003645277231336821", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "6638761803107874904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1630585964216121575", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "10745248353587672572", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "13395074742046717601", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "12659539044474018256", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "6598024975967050290", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 102) },
            { "2006890470582854116", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 139) },
            { "11369389082421346630", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "4986977887030495943", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "9681320098885387731", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 6) },
            { "8730097760819044515", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "11882021989615795558", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "8202324251716703125", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2932157519158822224", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8431962471592709199", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "16116546888494787089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "2954606701225038770", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "6757752550680050481", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "5893257440341358427", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "1327911294059513894", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "7771820069600757360", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "4618159169098049590", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 348) },
            { "12268432630136256720", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "2373658589834410892", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8440300225468667909", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "14495382595913294626", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "4974435385259831818", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4455497237293642238", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "682912708716537431", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "2585176064846114298", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "16033144151193421543", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "12141880589558027223", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "10098661517988566506", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "16192971634546462244", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "14793709237400480942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "1646362346584649954", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "4874397454627474644", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "6171331678772388712", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "7496699438957793920", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16767657090925788431", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1006721963560645335", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "14753245713079865819", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "1779870708816318465", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "17157919258161230886", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "12398103047184982980", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "2961249862769657168", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12131460825751874564", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "12365814254940023343", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "17218545462549916519", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11877919824125633092", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "10679711602282897680", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "17801375178828079914", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "15446821602347034830", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 198) },
            { "16041087076800110589", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "14102351022029437177", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "5786978465690715325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "10140124683113804219", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "14022671143475909407", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "7468500876165989695", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "4628560194573173205", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "3963065974337687046", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "13439359175348786664", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5342116782332968020", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "9198777289928370963", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "18276472227494448327", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "15774430281717785574", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "3887883367078892827", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1004081473410027655", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "5460182945235134126", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "7932494263344450271", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5596359111431962318", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "1116176429672030385", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "14642276070370158123", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1709508499926680213", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15466995361950304551", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "12936512845587590244", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4464844599426088921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "12966090642798680442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "128970554088066862", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7183620142123364052", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3793885399790365373", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 219) },
            { "4932548298968525464", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "8248099164876900927", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "249355510483373796", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2837134119351786115", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "141687758281942172", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15718782218800307385", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "3191047205441946466", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1564774057733793087", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
        });
        td.td.insert({
            { "11134833419828370568", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "1556966764088589197", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "6087676883600048234", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "15052286556809931759", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 283) },
            { "3377724880784871475", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "3452246087500006120", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "6840268976700446867", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "4278180549747978226", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "17856997406888930289", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "16556093306187145310", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2581594444558181374", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3377472614945731801", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10622082408513122112", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "11452807035432891156", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "13529174180301001127", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "17184405948599119534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "5921658305530976502", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "6802655190570100236", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "17877430344093804543", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "153771221207255459", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "15596913527233792996", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "1016967125909374575", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "6829653688530177613", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "6094638411430816112", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7559615879839693931", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11270266455366424659", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7100226796198950149", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "210793817522061488", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "11152357292626304216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "5771335481927877060", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14619753612256300695", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "2839767407547705101", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4981552552200657366", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "9626028243479089234", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3164513064874019611", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2363414141971004557", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8962502004422485576", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3154903035376733831", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16134637021630473012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5553176511624221429", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "4890932609897686394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "15334769670416409064", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5513667102916409932", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5351705572686943348", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "8200094670006738584", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8100051552977329013", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9004823715680825977", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16179959997108523051", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15148625184033310404", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6577754887650563753", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13182965457868586949", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "13839590781642269381", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "12711366212612147422", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7963529808900784906", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "12184558469694708819", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "3285180770267559354", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "6613282637922219205", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17093159649157277089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "14660081992091188026", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16228026045292341333", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "269829518575229806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "13023942860659386957", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "13291308922240014334", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "1187622888238643867", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16229324496308453344", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "14019704891647234793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "6141637854990273316", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13524128602135083081", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "531020979837645217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "8416686771626338600", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "2916077416184925232", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "16862531110856250955", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11352536854890889084", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "1683347645109643149", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4374049085310743239", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16159971034327080937", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "15779210035964863067", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15153285262450947102", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7049603973253724866", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9389671301472986523", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13891598020647124806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "9315279998737090956", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "18261342465838720356", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3632541114724731809", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "17088320301520334100", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "4352363968456148009", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "1827842275223841485", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7548767746018027960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "17750850961096057029", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "7606282654661282476", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6201358671959761215", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4829111442270007186", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "7267651931396380072", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "1279682391530947146", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2655979063469551930", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14425547983540742516", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "981419593633555198", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12324657364444167791", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "3246153532847702583", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4202705710324555180", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12272318018055307535", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "396815044270978782", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15633173680908856082", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "16635731992372618666", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "10418466892824851134", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "3244777852750357718", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "2443758478383854939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "13503934436248311972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "2594310972560076285", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "2424349375092546581", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "7104985983444651979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "13518747015059826801", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "11675809062974151496", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "4725349695436675084", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "17351243519367619322", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "17026338651868178077", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8730407034445893642", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "144434691308306757", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "4114184149613179671", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "2558882920723584206", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "16481414687792927331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "17756651805686889890", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "2228533392085335649", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "9038567144062573854", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 340) },
            { "1345293381483212104", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "729683192738752814", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "458997435535883643", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "16955907389221472146", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "17927673764274384911", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "6418222853479731432", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "7539191242110313918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "18014188548165359278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "16640379332042800496", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "14856197725306980283", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9279474331309267880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5717588912072437191", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1143426643765799488", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "1049385516019456025", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "10766144770072425534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "6442062011017461761", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "6063490496423709036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3892512749863226006", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4970240836537468609", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "14668725050395069435", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "7939047354407928586", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "365747554145156596", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "18207060402110970301", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "11049175652352131465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "2982080608393779951", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17216477578093693014", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14116923400742300182", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7029133126202354787", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "17420660823086709040", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "17300489799784213303", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15549100047322521213", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8342403220432961494", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "4600322689355365368", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "6432444239720173669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "5944283189654634640", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "8682613468075783516", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "5788340143385910170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "14166708932229380784", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "9262263820759430835", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "10661619519548036109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "11254313793397682889", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "8941570659228294791", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3711589321155572550", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "13440603011986281192", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "10072782544067079397", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "855625721312733540", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "8643403818712296708", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "3482316012102041163", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "15966346359387758212", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "6179768494274723997", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "110891946535801188", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "13300595681637438535", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "16686223109098592740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "4196950243745604808", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "15357494333788579519", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "5791271012599760917", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3502203881558439278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "6615043890071705766", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16602880550249876273", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8163937071550477896", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "4788158788847752998", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "11048286378242522780", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "15669268280202512868", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11708180973354877349", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "7429872600277069485", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "18404744652577257121", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "15145594907273468650", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "17189550036105947900", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7167054889777381093", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "3278181836788028231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "6040360226338233118", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6877955452402826287", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "10864271596740164097", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "14322983802576638073", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "9469688466553577331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 302) },
            { "13052522487775745493", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "10990480508394584613", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "11406807220585770939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 283) },
            { "17014949219411078284", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "2128641903680430067", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "8751004549226570175", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "12508733516106581272", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "1535119834165965208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "6537771397615897748", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "16911666678187393426", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "18163247824658143109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "3169531413538986325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "1861963470217658786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "17175653712131007582", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "12148428445687813823", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "15239273648189016892", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "17290692657168386471", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14119365735362663804", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "4225327120021140533", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "673126354575235249", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "17628454700752918711", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3529846607992358207", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "342387360760418341", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "16353520814579109491", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "3134099148543397372", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3042628567386436226", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "868736197323541759", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "3241775197578183463", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7851643406001230159", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "8502552745012743053", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "10353443026537243362", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3104552371734307984", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "12807894319350246437", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "11258614397356100246", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12946314097679886518", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "12909725304008017600", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "6153017925473103663", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12188122150443559128", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "11983651079897753600", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12988924268115973386", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "4891686540869580517", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15196732464112076502", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "459391085160518545", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7760457628691335753", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4865678723441158246", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15589245661365969249", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 219) },
            { "9661616000023492219", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14777607874956018667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "14113322810933328214", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16281761113420371943", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 219) },
            { "16988191641007425377", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13194254226778628574", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12531936952559145430", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16379080233376322220", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "2613462626256090659", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "15844881725957151580", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8059328623525062913", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3662747857062156477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "15121448034928438384", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14122213471825630433", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14985236276429954162", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "14321283775111180227", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "98795127409553442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "14805540705424073865", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3788462090984291082", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "11823068760218786389", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "5963105523596432544", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "10308431308942416781", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "8712136292276123857", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "11314582467969020320", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "17147293671640396193", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "4465701487417893814", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6144958783262207773", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "10467232566885547072", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17262854991782705821", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4635570915184713874", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8706634286501695698", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "3863816884636503247", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9252629750817485029", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13168267319035362901", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 221) },
            { "16567638487719493784", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "13449466515297095146", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "10808909442136736629", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "15172865163331822352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "16260483557979578317", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "7469127846325904854", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "8783239368699382065", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "3477539135137665170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "605638562926557381", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "12626994817506009929", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12417557233566012737", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "14056483847542666300", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "446997309263592434", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16589191615146805668", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "17226649394712507758", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "13566885629976429699", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "9931266845625995359", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2522707948254032777", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "6486250531858548438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "8174273876544952794", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15049304780567617964", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "1321553039928725678", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "5105893636044171966", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1661430504764145711", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "10041204026657386200", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "15969909663367854367", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "10956917223944472347", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6060390128414591327", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10987291891349907631", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16452573613171944531", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6370356607952251648", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11547588640573840103", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6882259829255167273", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 340) },
            { "4184283661465100793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "1799277562177870093", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "16276490504942526329", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13939380644892198347", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "14257398784378656791", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "14444423571297570985", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "9708741882115135691", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9374845449632011709", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11907741510409644649", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11833466191385766041", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "3276797683943990958", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "8494679093555050767", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16807117250109985357", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13642010365337780940", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5622078553841657218", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "3973953743850093759", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "3210709940026980348", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "15122428380000835284", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4492743859922847514", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3555469834146426564", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "13140141354298916151", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "7110352624440078898", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "9527046928040225586", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "7797523746053138659", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1478169078874265704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1264966373832011567", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13715010490012086430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "1470778934882087497", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "12725817227797568697", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "10024777334075819235", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "364471436103661689", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4052362583575987109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10657660173790920140", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6557428245898292304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "9440117898128288296", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15929262283669093154", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6352520536724420824", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "1921667815983542102", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6088184848087986042", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "16602667769746047266", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "15953651221917495492", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "34011924689025090", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "674384870483198184", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3555798556624172621", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "13793032417416585006", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9019684110208109757", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "647849627466319112", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11242435114747058327", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "17302407573266205607", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "13606281481050014632", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "2466805217694531959", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "5511298016141559884", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "5483150635926637198", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6265211373810873425", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "7643647841451578008", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "13254760530618979318", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16709502837180561673", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "15693956942112465267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17891347169069018262", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "10521453583707218193", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "14303192614979408043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "16609351383660437793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11118586558529856637", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "10939847328508611170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "5114254088513267110", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "10163486148946687267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "13296242326766100583", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "12068797674575015662", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "10978693262040522687", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 153) },
            { "10037086825900566930", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "17216583849049249733", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "341552075482632478", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "738850098651678143", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "7139714914586273766", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "18209157436315328292", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 102) },
            { "7370360743945187446", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 99) },
            { "7953255701516490034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6195916781434462809", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "2400014444553855563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4622514167765722873", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "14680730265621679042", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "3302557590307975559", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7648248878470053116", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "4917917708431763965", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "12978593897559876761", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "18064160378597803888", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "7689593699365225521", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "15819149710195058441", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "18274109287723887410", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "10269238332775024706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "9167138376243583750", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "5713105609160120586", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "150812658537571916", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "4485289322925780000", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "17268201530818712998", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "8747430148550634190", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16986358655784856534", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6109013751635776331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "9585113116232600562", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "3503893875515897267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "13144385730409574259", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "743941460026466526", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "4492332228252010118", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "1920042803083729276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "16436006771518788093", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "17567504672169904482", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "1989849521691057108", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "8203171222962341018", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9795194069954915563", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13369603621524676979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "2930658435447859986", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "10721885719016335538", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "17663718302088575615", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "10749263296616139689", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "18356235677223229518", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2657828809338947050", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "15743750994087974449", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "754596461956525575", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17690103717758388022", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "1581136092002053880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "184306359395609972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "4891076250667414900", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 198) },
            { "10946917656449245131", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "13963558035989415263", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "13239946614209250451", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "1076938718721677141", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "5851532147278358697", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "5746129902873132635", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "11592511763160794565", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "8244393417024602494", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "10340341966852782124", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10014822679257636832", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "3975219156915176189", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "13536863026622428609", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "11408010379683511978", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "15458285682224384803", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3407965587245145003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "10514330767826407566", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "4251496064392381805", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2384682907808363130", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "15705923658253281113", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "6610298174133949061", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6801247431347692935", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7702208423015808353", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "625378771032655972", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6542436061498779527", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10220143644047641696", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5009829190055738132", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "9863034269936216346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "16547699848349226093", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "13369144100905854138", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 219) },
            { "9490927482615234033", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3544673182881983084", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3575537018273879487", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "12649957341095701480", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2321767794934000238", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "14973431782875808802", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11948858355027908365", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "473983206819135409", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "6586872365879203192", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "18412999191021390737", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5274456170971167904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "9275398105290923887", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11340683391412454009", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8100282867486124965", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "6361758198448370863", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16431503579923509596", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "10280282710562383672", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9138345765585313427", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11117326838088757686", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "18222598708685323020", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "5198859831430501652", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16644329894881952739", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "9367630847798077790", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "4906856539144714227", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "14958085423402252319", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9835535945548454398", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "187589970359123667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "678657374277098506", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "8434335101659807351", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "15928128327390664485", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "16504425380504793738", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 315) },
            { "6480587375918509253", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "9751235588096143414", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16866525370343398909", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 292) },
            { "10160678465371702528", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17188750289444625186", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "14811603003184578943", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
        });
        td.td.insert({
            { "4363379197393466424", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "16403435599807360704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "9367985410929563457", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "10716232679616746794", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "622299920975636640", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "10798283054583509534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "14179140464588572277", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "351304363117543419", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "3499106702307464480", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "259619428712608645", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "3296098567244638489", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "13593304587712966846", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7572277082530361815", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6379337678256717737", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4513178474272034213", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3390430905253038550", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "925607706467451476", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "5627536079808515754", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16464493408368412759", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "13839116996827687373", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "307874768879227632", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "10308113903347312964", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6712698149192186833", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14930789530046665855", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2204178900998688268", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17174919737114915467", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15154700439767512396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "14916625550370402883", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "7650375560336513366", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "9999553425206328238", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "17515064188391421150", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10437367877444543776", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "4362304842016958728", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "383721620126444793", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "138379779469699309", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3759515057574218101", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2856601829807186494", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3286330985102373533", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8159303545761286685", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "4056979460327024961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "17823133607491820214", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7969441643457570812", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "970768445746568749", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "13678741578702922441", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17310844417517474522", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7287895452784411060", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6513788469599330141", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1432487477100132607", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2463151488506537801", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4054850047596998735", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9747825473942435842", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "250084243188516935", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "672634960435241508", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "748301576795035305", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14255457787105784042", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2750476114907782459", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10028244201873254140", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6469067021323571170", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10601714587235375373", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2483181247706575298", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1732853511466309905", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12113297049460198476", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11557224109907477240", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18084899872055349937", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2890305478244125142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "16659638340060273536", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7297768924198851782", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13104971224879807298", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5507252417827285564", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8511924860787648884", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8339235544283885013", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5654030701873405891", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1436723751951975466", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8325439593817651819", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17618112803233960227", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12327651080801123538", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13617891575616631067", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6020885536659393981", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1940159900852645250", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "753809225159529269", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8790166817024820739", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10677449690354999149", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10593983805743674128", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8217088979257009010", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5687085271369421207", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15279061373346657582", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7096501191029978469", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10094312347267495565", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3510084874150710192", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9391986481292718799", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5259220060268012597", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8117066211911522905", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10716559814452841971", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3949211089098986928", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14752151264004665491", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9195500778955925293", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13023666909692825369", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10961696014697611547", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "408602315578383859", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "582954161360487990", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2482190331248449465", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4075769657981876449", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14367142998060454343", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8114910678593187231", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4495451816890445327", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17102726573636919392", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10845009858831745215", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3112081942557253948", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1635689655354995548", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10250301712194120144", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4855747489298888657", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14238766089951260596", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7017830157652362654", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5619751660204221930", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18093663410921658106", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7869191330107002954", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7245974724868795129", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11019243479903456358", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12568255992252373147", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12413024322120393790", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17328716013187434957", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14899206494260920951", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9983462569671477588", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2383983224188083583", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1759538680129620900", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17194386925266836084", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1518413386955573037", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4104380387301024172", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6500468942462159659", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14136370464716049139", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4056919990977544228", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17351367314312762125", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17586380391909451000", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3561558658922596877", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3296755748686779746", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "534789472217562338", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10470060457279511896", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4917360877294344854", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3020953254086476464", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12307245536623707478", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17039711449439313953", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2734182509541824864", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14521225825422360447", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5857101685300045443", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1547471890307888038", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11159429929932958728", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1382911856313970571", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1854612313463195535", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13051406650237455505", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15438530452161762045", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7446661399223808792", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17861183465344343443", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2026622899016787854", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16127482065413259805", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12961109385388101976", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16855828799826043472", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15658859674277700656", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4833749391314748606", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3326691585067800328", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10718764522366711114", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13643973579671217152", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11155444222714959508", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "11544626480076777556", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14277552178674323256", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7792811600696842064", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10622803531832712558", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3079343528005019570", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3521119014097924580", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13643421651252474051", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6947390018658290847", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11697545935437523887", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2179704411405073702", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6886280732774854778", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15841879134365332862", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1489646217778958363", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8996027646503556955", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17569170625753249614", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16686854568163084344", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11187304651899164445", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14540721800838487177", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1979841019103384445", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13241679793873365192", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7013169017932712804", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17389114672554594444", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4157112143322859333", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15217255896294251282", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7606241825090144098", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8254388198068394779", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "755942233998922490", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14018816117251124336", std::make_tuple("fully_connected_gpu_fb_io_block_fp16", -1) },
            { "12054714986067446052", std::make_tuple("fully_connected_gpu_fb_io_block_fp16", -1) },
            { "1138657035758391650", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "3767246406609050779", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8536612779196342267", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18269766292810651342", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9646020463213439644", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5654817010240784792", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17277846909615605376", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "102220157823566379", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18213629255325554583", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8809496195168645264", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8506262325379391391", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "555647031314007743", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11133391567691287018", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4531238775069637542", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1050921927000835075", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3929145534169458063", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17125607183887169558", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3771153805567862915", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "5658567026478236676", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14520461267731870642", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15949156027942399242", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14569379143051211142", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5083162050523454050", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13951906075577108679", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9004122893718097099", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4336765005970913285", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1037896951032802088", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12090010131585526347", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9035445496715584647", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5455756262684457251", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7013197348316253486", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "143894893069959052", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13984124581247009793", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17964690428632248307", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5850736343172747247", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12379881923680871705", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11864459706509310150", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15222102499748205072", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1198491147477454704", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11400303472547811086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "11660798111579160734", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12081136231782604198", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14508437224082799436", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2396983035676921683", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11489881652545443112", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5651551840851524311", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11753049051286720239", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "479427514681077218", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10277290426401380976", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4919635200134986619", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8180846581099717076", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6411489040870738143", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4195122768220068448", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "52150349468142798", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4439371893496638788", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4039813343849078927", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16533127286587475454", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10264270523529136771", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9915620237695279980", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7090467930115498252", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15407802086492754450", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4007960934134542892", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2002110062193477745", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10154803388813032920", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1939527596007045209", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18436843102627176620", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "277852397173940175", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6822978927370753017", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10859939917723763131", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9248235209454206632", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2665169698359670120", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18266967379169677646", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5047972486012090625", std::make_tuple("fully_connected_gpu_fb_io_block_fp16", -1) },
            { "8183383667948205424", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14478151143114959230", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11396985422513105543", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12114476173765693172", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17041468169694105561", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16498300259966485293", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1173136780324694038", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15786764202107923723", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8913526950888110377", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15988378956341507229", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10993107955805947401", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6214677989814002369", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10884202393733523875", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4424960026145600447", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9763754389347695094", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "105055722864217258", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9775648000771985077", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15967893151722576439", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5774841809066688068", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "13402919586406297042", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11335142595937152387", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2689568881580764024", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6571325912136856822", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18122652705874970766", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2000008755333069005", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10361998183258703575", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12348644068948200883", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "736422312606696687", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16240864447025932692", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8589562027950762944", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9162564861963233717", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3167738956362101592", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7260746128189749064", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15308960063718398523", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10129304668926912275", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4853130422682926168", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14453982453535955244", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16608982023596566351", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2470663389603706356", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4240407752719875080", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4846563120992975368", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3706088306568590662", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14866563628584464675", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14721943524627076027", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9323941828298277387", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14109366965145192619", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4923997413838231159", std::make_tuple("fully_connected_gpu_fb_io_block_fp16", -1) },
            { "181017193671999192", std::make_tuple("fully_connected_gpu_fb_io_block_fp16", -1) },
            { "10757412618207229106", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "6395263375773555188", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5979046470758784946", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3927359449523162508", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "18232387132890063687", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "6709212639543074230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "10086813986911195558", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "3109992766790372487", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "794530296606789816", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1249133049911188319", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2006024870459798086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "11914297820344167381", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "13079795735173763117", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6241224766048532539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16524474021378494125", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4407550747921719377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7259905085241841240", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "6666210546769702280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7814543122045448412", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13554702187867408038", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2547880010597993852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "9061076702890952738", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "15460429275475874158", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "7724185199575851246", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "8533091468352267196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "15025120359649460106", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "2613575328969629284", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7463954007838579697", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "9151324495773628566", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "651020886445062493", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "8237821273547216740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2875927974837744359", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "3674322065648064195", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "137871170540938640", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "3066826388383295007", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "17483221428915982776", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "3403906310423395442", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "3888283018836731569", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "13928684419408478520", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "11520548550630007970", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4922714504620931501", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "15683804450763499599", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12686604223669447758", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "10746289671948325353", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "2487976264999747775", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "6163010595188500945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10404333823880552577", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "16662409111036688294", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "5400706842524705774", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "17423097433955762667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "18131954418490925431", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 274) },
            { "16549854027697846882", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "10340073416712988987", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 155) },
            { "4633923265089466898", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "6808980404170272597", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "10592783998150232858", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "1594829714229111215", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "17361714725103230834", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "15732140959902969012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 102) },
            { "5796974850751105634", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 98) },
            { "10588059104387338398", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 63) },
            { "11738780323979052397", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "16342972196376030503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 5) },
            { "10406201782146034797", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "17342758321852264926", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "15951978466742016539", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14100026884590707572", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8368507377481570353", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "2230145893895952661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "6320236287540885300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "3152975593520548377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "11756338894156892549", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "9310466098863912618", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "18376135355406021646", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "16780457022162749898", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17140702790441856730", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2578325663193624576", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8784358107340738205", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2955459120402821540", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2840794055129352139", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7104266560248570112", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11113125355390956764", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9127827617126714860", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "2268275392299271167", std::make_tuple("fully_connected_gpu_fb_io_block_fp16", -1) },
            { "10615831454139478379", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "8205640825965213946", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14337168375989245254", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11664399629496237233", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15750539817895707253", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "921209976738626097", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8590416145336196354", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10463632805036507382", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13637537549252005181", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7581949584623524395", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9814647153117279415", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3444250649099578792", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4039483032571506874", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "14309249337788077160", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6254493271976962295", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "12387660887222981357", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7723131901316908741", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "13963554827358438190", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "5001552360784483833", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14201142257504107783", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1066668660701816536", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4664196755018349672", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1103228955716492167", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "8618835732380720921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8391292909068775212", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "9488974186647231896", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "9069334144391048686", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "12493863403516600413", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "13375084585444085517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "18040173797801558071", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "15329174116169594863", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "14910223536998380801", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "18277685132620834972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 275) },
            { "13090887980792573261", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "3067806959725855130", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "17791773192152464021", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 141) },
            { "13603318842632052764", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "12072881177966014126", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14413047954443174304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "9118663018352672834", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "3558391988878894288", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "10047727261970275928", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "11527382293059267033", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "8445575388700666150", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "4560479630843098090", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5737652209336034549", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "1159910924058542880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "7203172595229334691", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "8153567933591966877", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "6069305481947437228", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "2216113049194620088", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "10395837712676962495", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "5041111302824362529", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "12542825714985999760", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4599539412023802059", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "4570119951370893062", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "16897917745917378359", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 197) },
            { "6947523163603267191", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "2322126126611987721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "6518845972912144959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "9741774854327055438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7079854103926842364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5035895518536085765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4307157272240924516", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "142486914279119363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "1532263118203058517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13529694429433303321", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "2820916926593580316", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 116) },
            { "11140657515428786448", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9028970753877215614", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 102) },
            { "2324120381399737261", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "14311837335039030749", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 264) },
            { "6105963806494867023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "14746731245428677019", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "9213886570531053949", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 167) },
            { "385046297070779752", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 155) },
            { "15882699446713091149", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "475043738497218394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "6351347283201596793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "16290626406346691996", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 32) },
            { "14038308632095412386", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15928183143089896780", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 343) },
            { "14071202918199194502", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "12383676694875725364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 342) },
            { "1830378766184274696", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 239) },
            { "13133105923394042921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 238) },
            { "12458275468325297142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 239) },
            { "1819720745131968914", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5140267554909755437", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "6021498606197929608", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "5832188635321350875", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "1411786954276574458", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "18193548056717743576", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7989522965312833517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2024521518658822242", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "9692442768327912638", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "8031184163763974840", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "13429621587271813054", std::make_tuple("fully_connected_gpu_fb_io_block_fp16", -1) },
            { "17938009873557420461", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "14123865825367908500", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
        });
    }

    //SKL GT2
    void tuning_cache_1912(tuning_data& td)
    {
        td.td.insert({
            { "4583484812233029888", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7560832358324865221", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7382044526960590018", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "12372261924257291610", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "1547771611689525848", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3134973665622945888", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18260030211719729324", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "7416143717989012766", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "12028963907131702705", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "2464531851392092325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "8181308759455478086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "546062289721803579", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4889405384318695802", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "12841232643395100314", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "14108361259911144680", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 347) },
            { "2726453304845436156", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "2607416795507802412", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "2175404966338020579", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "14666883719480623074", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3752993663604843837", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "5274735654559844733", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8174421295799601683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "1967655354607438665", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "15762542971370422224", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "8183203099539372914", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "4075343423548891274", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "13264497096898621015", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "679058537775669048", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "3375634256357960999", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "2844616672368585285", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "14235558866846276172", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "18066867692765966577", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "9861424412782371874", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "607078314875528651", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "6234885984223387670", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 133) },
            { "7223570329858821704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "17234843749633035510", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "11516168882438876247", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "11312664612825940140", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "14846039494240217143", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3390376200501119384", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "1113077760071340574", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "4614875083188849196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "10859023312681572942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "5588692131556725717", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "7653946972043115920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "9773458066743315157", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10491513939202460216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8140122945471321201", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "15079423575410353790", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "12844146569641472927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "13443914015380511668", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "13404457916017756196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6402415801415013013", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2040762223425679479", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "8595156989254845134", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "14493123117003003092", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7391309333582046386", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9935182178960843140", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "15422142509105297183", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "14849987788569183527", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "14923132847727661051", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "13271555597925466454", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "6865593216823998846", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "12385437755245281331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "4530047829451377456", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "127643210248119703", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "2599051617462913767", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "3024020696533545102", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "16205377892664082400", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "15135655146332608939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "10848724554175904486", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "15558120704022404428", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "14120354125904513152", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "8475075092501403968", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "15892943371777404347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "15078418657871922661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "3502053626453342387", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "1230316443026403527", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "12846418701225147646", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "17386994561779281406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "7367684259946371231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "5451072983028714092", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "11758623888547009364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "15958650715061024845", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "13899144453581769028", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "10884229860266073967", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "6629431845229592220", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "13199442294147992119", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "5032929712205664246", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "14871333176552512036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "17890435688048047959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "11353661571093800805", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "3101908018947919238", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "7495240482209084478", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "6964506613327100469", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 101) },
            { "3670645005971806718", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "69949758775887534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "13654393413005772278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "11101512074369779300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "2273811004985590823", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7457154125218067377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7709677514862642399", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8010619564572573208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16479793487852125428", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3147355028342035061", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12672939642957531547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "12627961914394914920", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16210688853876861607", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "1899485873740458557", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "669151029135558505", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "8912067280071688393", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7714589858275971005", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "9794413496918699979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 305) },
            { "18350040136091421971", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 285) },
            { "16931304566154830346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 306) },
            { "12816950084297042217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 281) },
            { "2359632276970855181", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 302) },
            { "16592641501972654496", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "7754054384598160936", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "18195884921517044108", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "16256130331524359070", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 305) },
            { "13497279823712860029", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "6095972148204769193", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 302) },
            { "4149964766407000732", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 302) },
            { "10262104071809780712", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "10707129891337660055", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 172) },
            { "3585075254981736756", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 305) },
            { "3181067565488724209", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 172) },
            { "8636008354706344794", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "4966150965920189853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "5569253153294942795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "11521347729886549503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "12399471154320580621", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "14851218369956754103", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "14859848826604327499", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "14783159891899899660", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "2369671961317151564", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "1691004331056506231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "4465288557833228023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "13538111995551348621", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "1886751914747841929", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "8445964247944285746", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "803205084059316676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "12654698468722759675", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "13484605287576302088", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "2469399061693302590", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "14782181149367028912", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "1448238652280623323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "2076478920663115306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "7369834759425644726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 111) },
            { "11702633755046828968", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "2944972038827287015", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "8261441437673092886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "16694312773479519523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "5486494868955566721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "8246009573416434030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "9457894602447879547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "4598302923247277427", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "3116224788980631217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "17103527368951412486", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "10150428063205056209", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "16984028253790680977", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "17857105233471273424", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "2715609009808401074", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "232807837985324954", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "13933912937625580405", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11254635684957519432", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "6729077823331194042", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "15961933828477762733", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "827225131390571924", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10429613013253088132", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14629385997654952321", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7546586420552408243", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "11897687507601277182", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "13975409361394567866", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 221) },
            { "6458124573210430792", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "2385616965635993249", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14462438074931673266", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9338654554616107568", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "15476402794704488137", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "13654816209891478730", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "1680424228660495363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "12929981792125924963", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "4698507050987130777", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "1094144958579794349", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12358908585763044267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "9793373151408615612", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "90849151510482266", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17277787450259342076", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "2367877811435050998", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "433942345363552443", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14575816691130255191", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3675622521877371819", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "7601637686045360430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "9818496628902493298", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "377651990943545344", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "16357661916741979192", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "5417669424921804056", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "854020380490533945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "11984602132438314210", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "13100228219613095795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "9808704199834907703", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13071373212254908241", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "18392748682101174561", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "11928475964162658765", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11937547211842355800", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "4637568849323640167", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16812695025037565299", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 340) },
            { "10487883723723512839", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "15315014737515653325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1579905786032546689", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4243996335899627971", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "2545885699369058867", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "16926950874716567095", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "6355395905401306995", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2096779676054335057", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4217179485243909459", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17101789600628162503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "6139574161497189424", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "16559140502701231107", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "11459784003592366395", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "7869916853707978306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            //{ "3889519976910355277", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "12081835728078383819", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "14923692894655929923", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "1841901358010744236", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10888203577545955226", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9799890897264103013", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1827296932806936575", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "13010820430079828498", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "6245781545617904772", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "8714031312599034571", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12922099252166105096", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 266) },
            { "3042887030242700493", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "1419879016567682338", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "12870587285162108523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "6103433181190121715", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "3469599265931338557", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14812617666668076833", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "14854734265631496499", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "7637441820772916248", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "14695781272831602408", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "15696910741835640150", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "17790593820165047954", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1433224983833208570", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "16185194021453870096", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "10310918050196558188", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "14885938077915823034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "14442357887993453368", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "4719130523147011420", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "8870222084473246330", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9350596936816632825", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "6183248276225219542", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3757195189216622027", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "8318857994507665384", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12864512857659000129", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "6615646900347529347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "5208923086986567490", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "9390793435913144215", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "11997629302296435180", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "4858270366437120918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "15975176007724247667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "16837473534895641370", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "16214153687871223428", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "8858112708913743577", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "8844677471730173649", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "9043742986995534354", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "15621341038256548867", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "18268980125375728709", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9757167087033785227", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6513982093384445397", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "9273893819042428704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "8270840662337272430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "15021512490648380369", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "6578908625437515675", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "13762042713029963144", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "668798769117277023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "10917498758625273194", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "14335423820860953927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "13978750151855895830", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 121) },
            { "8965747921518186477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 43) },
            { "4428101657497677982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "8151272056391095510", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 63) },
            { "17656341100957270390", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "10295330953350618042", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "15901675909820977223", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6026876733674266377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "381149736509958403", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "7962991673727743706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "10064251191248475177", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16663239694378513014", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "4690831975451405214", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "16132498413588349821", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "10609644803793651808", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "16520784657717262379", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "2271187702055786721", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1872921634399989626", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "12535576637355537200", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7771729980527620398", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14849108908297747749", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14043770215999952932", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15277856047844308598", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8048617952947915835", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11446745541571732900", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17422822627612865758", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "13954144830230671601", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "11198908896401597838", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "5582896843095691256", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "8133587696326295326", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "2007192658799516915", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "9492402787848610840", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "10515519878978734341", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "1375156980278317418", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13455881643467418059", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12788968383428254917", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "12304975739476881266", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "3390014193205017427", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "13587202155230938291", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "14462744723628661203", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "16109721499545711936", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "10090923790949378407", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16672038432561840773", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2973773544904290726", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "17193614571243427089", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2862029728492027826", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11066930104187448422", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2755147389712995637", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10662798624911535617", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "2172121470071868949", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3579916582911190192", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5495063314176654751", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3771003491521695667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "15514370342945522276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 221) },
            { "17285639145064557279", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "12642574441854544900", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5471430682416582179", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 234) },
            { "8561154029325525444", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8939900194037985459", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 234) },
            { "2129726780118554358", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "15463465056816958579", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "9268536904925062469", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "45977313646881991", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 361) },
            { "7092246390386193774", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14801984300948838261", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 234) },
            { "2797723586312707948", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "8451212914744825089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 357) },
            { "5131348852069018593", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "13619081494170885939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 221) },
            { "8818679285688095197", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 357) },
            { "4608292692528881356", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "9729987752669765456", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "1782966703272153440", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15641674846325113216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "18140951659547259039", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "3416294810798281053", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "12066560812164094695", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "9332596500956923556", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15067550526427941795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15428062440621131394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "8873614802459592665", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "3367130693014583254", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "14135594471530769414", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "14971707650115908544", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3036512701943687724", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "5334291640387922287", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "16245760498096322525", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "9928406318940388716", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3369894612786523432", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "590505356692040012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "13240472672791632740", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "7128145024365641089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "11497327844388026594", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "7301757962797024939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "18121689595247452649", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "875296362957469305", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "14912119584313592912", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "12494969618927201911", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "4640611487944119712", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "1692411934657235774", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "1673006919995519093", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "10601835610089648700", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "13262672660175739705", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "7639015398436550592", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13867172651521406104", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "14587150810299279663", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17271409929705935575", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16744813357455687598", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 306) },
            { "17215047912921813592", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "4093195092417588676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 305) },
            { "17895953872149392740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "5918874715861160937", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 302) },
            { "14498368518428801865", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "13857947326347149693", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "4965619590663772423", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 306) },
            { "17153828952517174005", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 305) },
            { "9864812885638557249", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "8410695282651246173", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "3011957000022205132", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "18202466898415347292", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "11433166800587133728", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "4499160027703324879", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "10225878843410985743", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "10961131057009777878", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "17123897723015586893", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "3938875063592179645", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "7589320923145169660", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "13907115679251591389", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "5262155845067632954", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12323619994816664201", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "13711624246076632711", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 267) },
            { "13879644216615040961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "13418213186769741623", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "9850414237385072276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 101) },
            { "13762987373425432087", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "15387492794262813616", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "9455446170928387706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "7799083605029182328", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "6416346888102436677", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "13401162817870652306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "4574862993950020539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "3956303186129893250", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "14928794187754412027", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "9892597035419316966", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "10290107543739998181", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "5275016494706355806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "10947686124973711385", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 55) },
            { "3997597867012981671", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "4003433148846544263", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "4361250474585164062", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "10523363119855336043", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1718324808394833635", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 196) },
            { "8430284238380067998", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 306) },
            { "3950448771871155887", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 289) },
            { "9033877528655370244", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 289) },
            { "8878071105867359307", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 292) },
            { "7511984934520363336", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "860443413504997114", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "4957638663977636791", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14793503588688729262", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 280) },
            { "9303039486341715392", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 172) },
            { "8923406201866512905", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "14629889085799380442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "4811310048537439646", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "8622985922687454592", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "8611046137980763541", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "1879796404388368873", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "6928835003016610382", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "8603207107304593583", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6477198553362516437", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6377441002585730862", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15761554874575656075", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 93) },
            { "118354408955419547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 108) },
            { "13601202334102031245", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 101) },
            { "11716196499333250570", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "16984923535088627888", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "364996668506826202", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "6412527114952548517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "4892959859293355837", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16127331840410137228", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "13335944978055152562", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10715829903767495958", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "6065404265303390338", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "3897655522585667381", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1860663592951633878", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "5698748062275134041", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "15945452307780131237", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "6764685582382238740", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4737109912659941670", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "9371952894576491521", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "12696412964119109465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "17825874529822806486", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "8220763890959777277", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "17731591992960147987", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "8950668477702067729", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14991602704357959545", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "16383540667048742064", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16820082917500285799", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6820284286806022849", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17285815901490707654", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "994182747184593564", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "6642767323474835034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "3215659303601163167", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "54975980454651672", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11529876081402974396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3644282167178264526", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "360872770877634346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "16720108310653948550", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14353390922580547467", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9868561386826862471", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17465517455679097501", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "5570311824197099845", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7524311370696987092", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "14070988879848388270", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "8296551195150971668", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14352796912241296357", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9840495023131952174", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4720851194954041037", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17009318615658405230", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
        });
        td.td.insert({
            { "9421643783312790618", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "10693348571961406417", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2940027113687311893", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6090625728451718945", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "5643908654122573882", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "8852322966320229583", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "11185156002426041243", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "14670068483447729857", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4623542918584461522", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "3126708271410621754", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 108) },
            { "1434535531617424039", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "17025268985366223779", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "15398976608777968810", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "6149673627320838019", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "7413341807736193935", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6071597471486669736", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "1127095963814993729", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8611856835854445891", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11115935318793891293", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "5393081375805921525", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "17589256877540537468", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4135814997524960840", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15180348902159643465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "2818524781020760666", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "4942080349816430490", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "9263314249867362", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "14377032179148581309", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "15245529372955421912", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "13595283050046771323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "15667549927492357263", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "13827442968070281886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "12076060884099762835", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "16532386511585070092", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4910582540370962997", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12335148041391647118", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10689880083512104726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "8870164706606458004", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "9269498023794081940", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "6779832349039897240", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "13942354789498444722", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 99) },
            { "14294764660016835141", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "12323510278692809329", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "5728070995112243570", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5381496395266530071", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9712640406795417230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "15036737419347383878", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "11552594222313787816", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "9399255910184037480", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 121) },
            { "10594581016504135920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "15640487942881889055", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "14165417928501578590", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "12251989236991754721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "6675363512560434713", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "9831713940431605743", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "6531349504807709133", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "2726501303929773572", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "10439704858943788014", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "18137994263450376706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "5711991739289045727", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "15255831401757117660", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "3906658058160172747", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "15823433297099049221", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "7829483638597533960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "14092273913846393837", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "3746578485711843646", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "12228183555926126959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "8776893332387904786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "16672299044236704672", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "13309889945947393850", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "15966815420067673043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "7415938485228396256", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "9655590024687998403", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "14798289196964890724", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "9794684437872784678", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "16729204245488754836", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15185983488152870534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "13821372148587948765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "4727004015814244856", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "1738348894912205653", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "559491455289877068", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17312172687490475177", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "3470176432841342662", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "8950283515337670839", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "3995072673238444396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "1238913228370790536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "928677976151553489", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4059887681292863495", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "10493952422143348278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "5610465912655751128", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "759163065093339795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "11300938516591867859", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "12843263740221725967", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "888316366026890514", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "8088645310090149658", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "15891058658954073255", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "3456538031339928220", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "14187063304165334647", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "11593893535334124231", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9218293603091125898", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3614865264081581688", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "8860682105104682547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "3775781894241463386", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "8857354069987696352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "5611508857136313396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "10872828113308792940", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "3726594456692340607", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "7541331569935741737", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "5639394073086652531", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "11158391063762007051", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "6319861294308997034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "6893801771793379570", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "9015970699147699643", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "9252735579930779632", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "16237353798629485972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "10916127635689513485", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "14631094106016920364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "5050075828787158563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "2277573429750402800", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7462044209068160751", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "8879836520351993142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "560198731460537880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "6414187394150266523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "15317838148382459105", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "11219109605495282242", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "10404790565578782014", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "4657890394631454901", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "4256171754976506222", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "12658039760507507230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "9883901352719605734", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "5115148310176289236", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "4892280615322354003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15491567059821267605", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4716932801711295063", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15559962129967760292", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7866546777503165080", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12994023006726461909", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1869893771689012539", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5635187738652974532", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12849693339574251399", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13233683642200681957", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 291) },
            { "4310121962651039089", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7620758476872568593", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10344702612951473525", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 193) },
            { "1668590302432600271", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "8750610033922701675", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "6913992575736424382", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "17945230226911262869", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 291) },
            { "7356559449640788577", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 296) },
            { "18349175655630268884", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 296) },
            { "16817085704588915904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 193) },
            { "9503107262691437536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 296) },
            { "15595806193584438610", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "14283867094396458105", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 291) },
            { "14215445060938730397", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 296) },
            { "12720976113342879024", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 296) },
            { "14766625154638709852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "11757187678986741715", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "13038212285326297688", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 304) },
            { "13919423909034348565", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "12925256096286953030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "6275163484075546689", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "239651884801599911", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "9500211224156027451", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "10902538092301362853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "8454943813981348115", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "11722951613064434115", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "13547342611064538960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "15171119202712914112", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "5451487099025245427", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "1814940262511664251", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 198) },
            { "16341609351317463829", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 193) },
            { "14343280871046671393", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 193) },
            { "15586404971308258630", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "15891211707425019144", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "15351688973597240327", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "1844016761754156672", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "17925606428283439978", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 193) },
            { "15050158761219834868", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "17448180555072943363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "11422222075976800614", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "14284377769814732906", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "667777413731244716", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 173) },
            { "11624071786842686451", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "3874974512053082278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "5471037497181745651", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "6371386660654628561", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "5331835606773958814", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "16163821504542698475", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "5697543838890997891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "6217438921274668801", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "2633095809604510774", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "11218297661079136641", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "3374196543196230185", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "17797320202829145544", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "17198778757516749818", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "6440981718484677922", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "1616603916015535857", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "7643715911083095268", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "137903092932521503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "13203019690952060789", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "3918152537861570517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "8782903242853500098", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "18312668164562040079", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 121) },
            { "15160703466234996170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "2751241748685218213", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "12622728760401804660", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "1290624457831957354", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "10924946887162830574", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "10789202693606479024", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "3718558874911694616", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "12835389389575311182", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "17406431092101974143", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "1400409391266374603", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "12154660333025778322", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "4800587664660105589", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "16474284418841532356", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18117355153710110681", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8449591498895477846", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2962899568083589487", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3491333679577961640", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13945298510228460890", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "4282198629458668761", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "779525528509830615", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15002237905129290671", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "16833026567865627676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "16991060247581867302", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6902644989079870993", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15088285782819494786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "3379661203936923589", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "10049571207493913006", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "15691689005236690951", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "11275109735493317886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "12220860296984467101", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "44210723233569665", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "14014987361364503383", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "18189351665719757712", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16159032667792855758", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3374037004378790060", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "6765409971512438438", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10098892297878373639", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "981877665302032867", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7472350511000146655", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "15513971895394346930", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "6169721205327431190", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4519054607159036572", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "12750124851833311828", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4333851142313192116", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6041620003527819661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15091361629922645798", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "9348121965341418899", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 102) },
            { "393951904144235223", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3220084080191614421", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "11610588256244825741", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "2802357220980817497", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8972812517118478580", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "4207115359813621211", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 79) },
            { "16582237002610438015", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "772342953072606219", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8546247990965609013", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7971830510840138313", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3570484486449791727", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11461079340079820563", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "12663860560275361463", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "8132521728369930959", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16108573960501496757", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11086699387784339943", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4013707396889204359", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "11850332373794932468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "14763982961176216679", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 101) },
            { "8207349115037232863", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "3273748387141431306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            //{ "580936360000782237", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "10682918518101379579", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "13178480813522103091", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "14472322679644532468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 118) },
            { "8378137527264154204", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10180255575636684134", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18242121098885244699", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6178572652675599622", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 336) },
            { "6558074021146321216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "11038938372264857379", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17137800360536507200", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "14016185289182597841", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8970519484272874266", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "3289746379259038515", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "18389174979070260315", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "17666483005735191253", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10845781902676865789", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13646634862315619979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 336) },
            { "5072154928583891344", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7757331094141318304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "16779678846332091086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "12223166874490429642", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13316017702896072758", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "10390896207372295988", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "8386498395042623384", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 167) },
            { "17923632501885139982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "13398326377839777956", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "13520557646924372128", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "5996787039089786722", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2626376166907387273", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 171) },
            { "6147643392694904814", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4311921348668650791", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "8046109476498335792", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14190077682825257613", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "5032302126047788183", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "15256375572125522238", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "5083173538217738703", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 195) },
            { "17269467004855120308", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 195) },
            { "2901056469731554922", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "9747637051217505111", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "7175860674618956918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 291) },
            { "9530922411870814200", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "11015319643831560673", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "5182740559503076121", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "7567277014404457462", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "15973842639221447367", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "15951492056203075273", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5283253936050062275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 178) },
            { "17650690912303447913", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "9614936270604202220", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "13998661469619523378", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 141) },
            { "10584034255622783869", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "2973436171295280783", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "1908809004094565452", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "1623383628456201603", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "5766507688771440170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "16626226341188424071", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "14619055893081624406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 121) },
            { "17222005830854879661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 41) },
            { "14224121742920800990", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 167) },
            { "5859124386313585730", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "9596156698919548146", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "10482582307328548806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 1) },
            { "407189201971322683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 22) },
            { "16626507949474235269", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "879005904827468163", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "8460847842045253466", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "2729099061601852493", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8233922303282945338", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 238) },
            { "7402006230339617617", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "8420763628389536977", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "8325767678959979628", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7673672840505587739", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14166169053627992481", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "120923426036313670", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "7348084298010357768", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "14653065651448352526", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "11008522061447263744", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 343) },
            { "305505245310584136", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 343) },
            { "6472139251351862598", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "10586018593856542117", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "16706121580364790904", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5495776091407365966", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16430562172386510259", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5673972310424776040", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8797843396807284399", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "1698321314111848001", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 342) },
            { "5762290464889692462", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3218248162832023196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "12988961529988078346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4232250144427804891", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11683680166617045816", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "6252429564537528709", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11717348577195224554", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9275303306340702111", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12245096462203481681", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "18439435691655740074", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "15272426400992401555", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "9136831791301215059", std::make_tuple("fully_connected_gpu_bs_f_bsv16_b1", -1) },
            { "18238669114790278675", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "15376246520426368532", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 149) },
            { "16469788155263456039", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9360494451263553093", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7897877428349481398", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9354818521586974021", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5853553261686771766", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6351572488552853754", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11372638316835753193", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6170074103544756465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "4544242784357021697", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14225108809796795520", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "178353385245384751", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2002574142025049539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 364) },
            { "11630971824787392820", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 219) },
            { "11542493210215136239", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9595803435783166868", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17610828776103321939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 238) },
            { "18312069177632970412", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7577483892218843723", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 238) },
            { "4355933224673863178", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15124932296735391043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "16888042302987189589", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1584639932403433303", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15516194807992507442", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6614374536332038989", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 238) },
            { "5097818987523855112", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6623182990939010641", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17001023283013862129", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7935150275452094595", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "2326323992207208685", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "5072735784865711772", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "4683841893192741312", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "10341773151035665956", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "14109534738984061372", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "16706244336960642883", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1967030672241059921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "1482100699000420627", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "13632911653636980024", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "6198830126915940359", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "12125006289181390694", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "14152716242882609401", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16732621354152092286", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17921489101554455214", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7384108582424003436", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13139625572508441980", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "16491532291908469567", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "17788367809717898285", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1509728225855233852", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3816705689596666600", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "14157505468412850916", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 189) },
            { "17366807170224886960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "14548509699664316785", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "10404702662303016402", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "16436357970364549479", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "4858167644379876157", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "4381329435655511217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "13972357557211413688", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 355) },
            { "6580334406272192111", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "194072522984726408", std::make_tuple("fully_connected_gpu_yxfb_ref", -1) },
            { "4490223883171428014", std::make_tuple("fully_connected_gpu_yxfb_ref", -1) },
            { "17194603517181970633", std::make_tuple("fully_connected_gpu_yxfb_ref", -1) },
            { "6995235840871804844", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "1671208365782918441", std::make_tuple("fully_connected_gpu_yxfb_ref", -1) },
            { "11718418772370938734", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "989564341557094953", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 54) },
            { "8133676065307881979", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14555883089089918919", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "14026570177552137240", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11686670048744589243", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6678796313875454849", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "641417817126876622", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9622546530872848323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "9194788897910888066", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 342) },
            { "522181557896569275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3332334993503432420", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16131448347558322280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "13852065717057446998", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4342360467977736802", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16336482874764861478", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6075691042233712335", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7570346182940928159", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12971822824884826169", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3033264172690274208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17301887391757619741", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15790005937034794347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "15464327246951632247", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5659168916726488798", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "8079376692609682448", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15160738482264643601", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13953639482255428227", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12293786134765875615", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 237) },
            { "18214412375127043522", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10670103699537731664", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 237) },
            { "10147266284710177932", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11443268857010762276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 237) },
            { "4659943649635556150", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11726298758004767743", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 237) },
            { "13896680298436380632", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3797957937905580811", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 237) },
            { "16294962940703055933", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8526484907799590618", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 237) },
            { "13723543003759101485", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9873647901670251106", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13268525255152984893", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "13008742408950833847", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8616686489737649890", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "11423865221956815041", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14990645740260870030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "15204453579641378742", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10892456883214928095", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "17856816245251319111", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "1799430190598598671", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3106591708459602370", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "4111904926378218826", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7678457226823073886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "8786249783185140623", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5389189982064081933", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "15175088047384943892", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15331103261044247142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "3627273785739110683", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12478309735214802531", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "7212944937255713716", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11873734271080160669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "18421820525219154881", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9553032671453999824", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "3860603464276263676", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14115313335378184289", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "9519623751582710696", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "10288726118862235940", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
        });
        td.td.insert({
            { "2231648183489019418", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "6316097202867006365", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "16208488491972128275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "17978026144659698965", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "2566302789609970663", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "2714742023091949586", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "3087801652564627458", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "8602155166799218249", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "14230385851791760020", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "10828719108804915700", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "13973179950424276578", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "3668927000317872012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "7947870656736319919", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "14767888121198814523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "10401632438377178271", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "8762901342272872498", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "10783981060353445280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "12608289345175485333", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "7875272450497189442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "1599725688135122629", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "11932770338770247767", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "11184047387366978375", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "11716771904412649891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "12576157843776905380", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "8402692278765063674", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "6781076363516398481", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "3255465741612432300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "9767950219863105043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "7134654288295280046", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "5821853991835395449", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "3480732841490521799", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "6973260260946088987", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "15649927926091502215", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "7910468668367486698", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "156456996459945842", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "1994927850993519406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "16431165572426232677", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "2864254144951744544", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "5390559917122707732", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "8378839908604146288", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "17163158934005653629", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "1185280691070355160", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "1999979442136861875", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "2527189070714658176", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "16032797290430373799", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "16783619135298589974", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "12785335515281046438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "9216608098626790565", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "18257496796879980386", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "2452226948562393335", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "11072545690050335239", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "12668149981216388765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "714898562476771473", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "11115684531624462986", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "8710684853144029787", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "3752171257634205726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "5243587439683016777", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "16881283637687482989", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "6042976104660344109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7351733901977025859", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "9341400376014914418", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "13713406612642090169", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "683350872280694452", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "10436819182310112786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "10269788826827249402", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "12558716383635737426", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "7181186153851700294", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "8107447526839063293", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "1016414921656805365", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "4871907623235871050", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "15539976365475470623", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "3880189981766119529", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "10154958553575016770", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "4561874206785244358", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "12358640399843058144", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "12956726277674279950", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "7177837234452118325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 1) },
            { "3160080179644173650", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9832551412183684637", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6347790007333387897", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13219313818719819982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 148) },
            { "17780553554354185249", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13315473376247698298", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 151) },
            { "11815135771923538945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "12465309202808173810", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "7171436879576678563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "9407046952012845638", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8805267762044816983", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "14381377343079009210", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 111) },
            { "13248818835662551847", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "9300668734746602663", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "7706778813807762766", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "16991433003318725315", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "4584399194832832140", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8558026087297588736", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10198351802037434471", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13257958112171706655", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14722464361594874490", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1544616395544118800", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5955569479109539856", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17738708576252096108", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 141) },
            { "10276056345160651377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "13515249925520423329", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 292) },
            { "10055593174764596789", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 292) },
            { "8707130584661395715", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "11161176476048297041", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "6959258479021077609", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6365109451272429541", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "8191978674781978488", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "11604224659996035116", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 166) },
            { "1759873215866222608", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "4559874433048442047", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "6937259685509040959", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8242732346001884230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "16156727721974657541", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "13786314015179226945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "4202371435873473624", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 193) },
            { "10933135228023712253", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 166) },
            { "14467312749536832362", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10557843071473489529", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "14967016402348718219", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 163) },
            { "7594056145185406157", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "12051754199123379659", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "2634827464202220192", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "10211888372266149335", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "4548339182509526896", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "828946941343000506", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "13008375263617223352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "5638301531544801477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "10213021343800816450", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "12000084249129063723", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "18040104088851490930", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "16394608147869554267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "15229178454191871174", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "5927467766675317093", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "4877661058006573128", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7515937801840512449", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4747017546101861376", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "8833751655076849826", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "16256124470203598218", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2706523860113152678", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14946999257618007034", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13699343107940933196", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2887515984302814699", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "4906737644615337997", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4725303208352054390", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14955652052550053223", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "862470330257326268", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10381668587006680936", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "2593337359555305520", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "10774393239130591748", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "16247780189312707876", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "4487284881658782961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "2811240876735166934", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "2447678508469638445", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "7454164784767168407", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "18275848121133385773", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "13759457214873634937", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "4855959048455906948", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "7160112985819045832", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "6880424067049089394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "748023061136366353", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "15793120434966402276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "1932618420321708351", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "3336444565837087463", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "15067224168014815918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "4431271266410883917", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "14115818307364071162", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "15250928896997938213", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "13013685738525906988", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 340) },
            { "17607598031220186942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "10278583197921433748", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "5300123851331202735", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "10751381988703627540", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "9905160045246767203", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "2927340528757005274", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "16243861301305882872", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "15004681374954252324", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4496537089364942280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "13357951046545317387", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12878719705192625362", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "4785466104509327241", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2416244034719176938", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "17785504548342377669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12811319921474895164", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "10760000973615798613", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "6300105753728135778", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "5791707725846814784", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13246629627758485603", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9400558994532871122", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "17865276008842107020", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9981156409872807880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "4626770940790542333", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1094262369519841857", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "5523297987528243797", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1789389636704094004", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13544237579827433636", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17696244668222870549", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "8926171136732424790", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 347) },
            { "16179159307898475953", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2692291137583386471", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1095433004701276122", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "16277739324697771064", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 347) },
            { "15945243427420522827", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "12296021067910843036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "10673589588224406026", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3585431879296991112", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3119002388778552316", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "5322582996019286781", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "13225749488949717853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "13207215182979880133", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "17730578026124357983", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "9725306578495355500", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "5277508201756602822", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "12806959657459851511", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "15232478805009654818", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "17712227426604098630", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "2530975976273876727", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "6232318392696042532", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "13657818175298160631", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "4088603773237062922", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "11177710514557128293", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "17515272254985846970", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "312130674630486188", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "18247095696433793115", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "6341728273786101457", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "10401462893795799864", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "3032101782888447048", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15078331029547630371", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18043541805861795852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "7608435380564752000", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "7129337563584588644", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12204270722180734542", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "13588405581356678469", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4986281570682617547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "2214420531345686129", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "15030725973433075086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15384520760315696372", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1915712383376159541", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "6176816506826300479", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "15331830720555178784", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17558578036713688769", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "2388815483287403961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "15948716167523201661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "6787190800192250525", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 283) },
            { "3378135802544446861", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "13053802967262518173", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "5503306970973862635", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "9417884304413500664", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "7866083951140251349", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "10084810175406860705", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 281) },
            { "10342347371769114236", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "4063042455950354352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "10055531955039754920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "13173341667656398216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "9356247214800869277", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "8630592326601832361", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "5041676938441886628", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 302) },
            { "15379755045295790608", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "13410979599123644577", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "13504573816477550406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "4459291258089899503", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13992993617743773278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "13395962624719382401", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "1535675815795592775", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "9849036672784280133", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10780684483689207763", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "4060515618437959603", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "9203467651096078409", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "9698108593334526558", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3252398754887381352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "3120759967333088019", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "2024996599975373573", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14876099702827489987", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "8653894569484019347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "4004518396368398824", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12801342874692090364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "9387557098916352467", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "11689587446775003898", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13973363990921590224", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "6278030053136901802", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "12122586525659611649", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17711197779492504718", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "12489342380264260364", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12148845150031891038", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "5080727465135503101", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16818862727193981112", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "1827977959922344361", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6291003899324240633", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3002862967523058894", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7222921168135747513", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "8696847224485998117", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7453625482178960081", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "1472822945750487574", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2032419134020329477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "805104869568121149", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "17215312565214990348", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1737128374457513820", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16263489451695566992", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "1608378717397996752", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "14346703182362139650", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9744493065276230785", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8331721527098298378", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12097373631649932423", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17442035600389810700", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15953351443307161934", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8740196547852036537", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13809436837912218131", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9722172495422643735", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "2662628817605495834", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "6163765140843670080", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "15662207751131195569", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "16494358566119044242", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "12641727819019838301", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "4917595053453614536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "14577496472237742721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "4356806313729405658", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "14282717676967464809", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "7275701540104992761", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6459003512612780875", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "12791541622557283904", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11882713776717158678", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10982479758700194728", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "8714769962126708854", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "7639744043430667021", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "6804493132858449665", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5204696395552974337", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "8893913418784905112", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13496918758899426996", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4707842387180272918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "425930963222944558", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "3844246198992827038", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14280128364139551919", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "6774493262072228712", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "5670860641930464485", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "10055923266096584825", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13508499324621059445", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17431631935986646683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5568431877348597159", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "356320499267651746", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10632294140185068783", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12339584174527699309", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 340) },
            { "8556999353039153661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "15381427144405510339", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "8855986581847188591", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13704396706685353016", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "17128550517647168353", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "8625183189646433895", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "7921388663815287395", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4213330047036138895", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17034122796081495259", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13076343553185159307", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "5854267518455107328", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13675314612031135613", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12825029449351875037", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9397711809671506538", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "12965800692507042874", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "2647922515901529845", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "10961049607808752432", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "13988022841867948024", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4612862531793961340", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10950469938532358632", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "2228733394430438519", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "12015814430456201522", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "12344008430499496640", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "9863615330219779441", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3560058786734628608", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16047381404034145819", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9714811479610938662", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "7306541374689856571", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "5689486642279577539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "15545653867155770893", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14910368344505819159", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3220771309796407003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "12786796142417489350", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13947140171097868740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 270) },
            { "1168311873250200110", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "3495786143085325748", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2164537487697642190", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10623345643437043886", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15240415102190323330", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10321975076426598984", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6467563111927343808", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "4280198021826662216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "9464830880142854424", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12113781253211924677", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "5410693492803892704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4844529595057806427", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "10848097581672953022", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7947428837044782745", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "11705938507822117867", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "8334753494554256932", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4995468555341975721", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "6282308289220311358", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "18275232300842488846", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15754022314306112499", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "15193841338943103284", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "956475051281637098", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "1117811515417136925", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "760383787039304033", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "5351526116347538406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "15923292837937693143", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "2954421933443715181", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "14945079011377285773", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9573520179708447727", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "11432977101529429562", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "8918387046558682780", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 140) },
            { "16699295198130950587", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "17358462939783262207", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17406383217119217230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 275) },
            { "14003645277231336821", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "6638761803107874904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1630585964216121575", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "10745248353587672572", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "13395074742046717601", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "12659539044474018256", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "6598024975967050290", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 102) },
            { "2006890470582854116", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 139) },
            { "11369389082421346630", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "4986977887030495943", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "9681320098885387731", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 6) },
            { "8730097760819044515", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "11882021989615795558", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "8202324251716703125", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2932157519158822224", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8431962471592709199", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "16116546888494787089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "2954606701225038770", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "6757752550680050481", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "5893257440341358427", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "1327911294059513894", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "7771820069600757360", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 348) },
            { "4618159169098049590", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "12268432630136256720", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "2373658589834410892", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8440300225468667909", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "14495382595913294626", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "4974435385259831818", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4455497237293642238", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "682912708716537431", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "2585176064846114298", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "16033144151193421543", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "12141880589558027223", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "10098661517988566506", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "16192971634546462244", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "14793709237400480942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "1646362346584649954", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "4874397454627474644", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "6171331678772388712", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "7496699438957793920", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16767657090925788431", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "1006721963560645335", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "14753245713079865819", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "1779870708816318465", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "17157919258161230886", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "12398103047184982980", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "2961249862769657168", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12131460825751874564", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "12365814254940023343", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17218545462549916519", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11877919824125633092", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "10679711602282897680", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "17801375178828079914", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "15446821602347034830", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 198) },
            { "16041087076800110589", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "14102351022029437177", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "5786978465690715325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "10140124683113804219", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "14022671143475909407", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "7468500876165989695", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "4628560194573173205", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "3963065974337687046", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "13439359175348786664", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5342116782332968020", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "9198777289928370963", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "18276472227494448327", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "15774430281717785574", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "3887883367078892827", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1004081473410027655", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "5460182945235134126", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "7932494263344450271", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5596359111431962318", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "1116176429672030385", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "14642276070370158123", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1709508499926680213", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15466995361950304551", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "12936512845587590244", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4464844599426088921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "12966090642798680442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "128970554088066862", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7183620142123364052", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3793885399790365373", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 219) },
            { "4932548298968525464", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 209) },
            { "8248099164876900927", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "249355510483373796", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2837134119351786115", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "141687758281942172", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15718782218800307385", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "3191047205441946466", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1564774057733793087", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
        });
        td.td.insert({
            { "11134833419828370568", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "1556966764088589197", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "6087676883600048234", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15052286556809931759", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "3377724880784871475", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "3452246087500006120", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "6840268976700446867", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "4278180549747978226", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "17856997406888930289", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "16556093306187145310", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2581594444558181374", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "3377472614945731801", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10622082408513122112", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "11452807035432891156", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "13529174180301001127", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "17184405948599119534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "5921658305530976502", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "6802655190570100236", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "17877430344093804543", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "153771221207255459", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "15596913527233792996", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "1016967125909374575", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "6829653688530177613", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "6094638411430816112", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7559615879839693931", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11270266455366424659", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7100226796198950149", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "210793817522061488", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "11152357292626304216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "5771335481927877060", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14619753612256300695", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "2839767407547705101", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4981552552200657366", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "9626028243479089234", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3164513064874019611", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2363414141971004557", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8962502004422485576", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3154903035376733831", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16134637021630473012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5553176511624221429", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "4890932609897686394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "15334769670416409064", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5513667102916409932", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5351705572686943348", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "8200094670006738584", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8100051552977329013", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9004823715680825977", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16179959997108523051", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15148625184033310404", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6577754887650563753", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13182965457868586949", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "13839590781642269381", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "12711366212612147422", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7963529808900784906", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "12184558469694708819", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "3285180770267559354", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "6613282637922219205", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17093159649157277089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "14660081992091188026", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16228026045292341333", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "269829518575229806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "13023942860659386957", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "13291308922240014334", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "1187622888238643867", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16229324496308453344", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "14019704891647234793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "6141637854990273316", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13524128602135083081", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "531020979837645217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "8416686771626338600", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "2916077416184925232", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "16862531110856250955", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11352536854890889084", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "1683347645109643149", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4374049085310743239", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16159971034327080937", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "15779210035964863067", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15153285262450947102", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7049603973253724866", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9389671301472986523", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13891598020647124806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "9315279998737090956", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "18261342465838720356", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3632541114724731809", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "17088320301520334100", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "4352363968456148009", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "1827842275223841485", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7548767746018027960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "17750850961096057029", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "7606282654661282476", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6201358671959761215", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4829111442270007186", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "7267651931396380072", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "1279682391530947146", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2655979063469551930", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14425547983540742516", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "981419593633555198", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12324657364444167791", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "3246153532847702583", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4202705710324555180", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12272318018055307535", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "396815044270978782", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15633173680908856082", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "16635731992372618666", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "10418466892824851134", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "3244777852750357718", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "2443758478383854939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "13503934436248311972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "2594310972560076285", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "2424349375092546581", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "7104985983444651979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "13518747015059826801", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "11675809062974151496", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "4725349695436675084", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "17351243519367619322", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "17026338651868178077", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8730407034445893642", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "144434691308306757", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "4114184149613179671", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "2558882920723584206", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "16481414687792927331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "17756651805686889890", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "2228533392085335649", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "9038567144062573854", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "1345293381483212104", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "729683192738752814", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "458997435535883643", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "16955907389221472146", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "17927673764274384911", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "6418222853479731432", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "7539191242110313918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "18014188548165359278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "16640379332042800496", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "14856197725306980283", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9279474331309267880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5717588912072437191", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1143426643765799488", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "1049385516019456025", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "10766144770072425534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "6442062011017461761", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "6063490496423709036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3892512749863226006", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4970240836537468609", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "14668725050395069435", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "7939047354407928586", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "365747554145156596", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "18207060402110970301", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "11049175652352131465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "2982080608393779951", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17216477578093693014", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14116923400742300182", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7029133126202354787", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "17420660823086709040", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "17300489799784213303", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15549100047322521213", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8342403220432961494", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "4600322689355365368", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "6432444239720173669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "5944283189654634640", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "8682613468075783516", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "5788340143385910170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "14166708932229380784", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "9262263820759430835", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 342) },
            { "10661619519548036109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "11254313793397682889", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "8941570659228294791", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3711589321155572550", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "13440603011986281192", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "10072782544067079397", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "855625721312733540", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "8643403818712296708", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "3482316012102041163", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "15966346359387758212", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "6179768494274723997", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "110891946535801188", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "13300595681637438535", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "16686223109098592740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "4196950243745604808", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "15357494333788579519", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "5791271012599760917", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3502203881558439278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "6615043890071705766", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16602880550249876273", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8163937071550477896", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "4788158788847752998", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "11048286378242522780", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "15669268280202512868", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11708180973354877349", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "7429872600277069485", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "18404744652577257121", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "15145594907273468650", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "17189550036105947900", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7167054889777381093", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "3278181836788028231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "6040360226338233118", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6877955452402826287", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "10864271596740164097", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "14322983802576638073", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "9469688466553577331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "13052522487775745493", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "10990480508394584613", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "11406807220585770939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "17014949219411078284", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "2128641903680430067", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "8751004549226570175", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "12508733516106581272", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "1535119834165965208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "6537771397615897748", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "16911666678187393426", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "18163247824658143109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "3169531413538986325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "1861963470217658786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "17175653712131007582", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "12148428445687813823", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15239273648189016892", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "17290692657168386471", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14119365735362663804", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "4225327120021140533", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "673126354575235249", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "17628454700752918711", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3529846607992358207", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "342387360760418341", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "16353520814579109491", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "3134099148543397372", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3042628567386436226", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "868736197323541759", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "3241775197578183463", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7851643406001230159", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "8502552745012743053", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "10353443026537243362", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3104552371734307984", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "12807894319350246437", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "11258614397356100246", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12946314097679886518", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "12909725304008017600", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "6153017925473103663", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12188122150443559128", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "11983651079897753600", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12988924268115973386", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "4891686540869580517", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15196732464112076502", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "459391085160518545", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7760457628691335753", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4865678723441158246", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15589245661365969249", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "9661616000023492219", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14777607874956018667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "14113322810933328214", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16281761113420371943", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "16988191641007425377", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13194254226778628574", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12531936952559145430", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16379080233376322220", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "2613462626256090659", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "15844881725957151580", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "8059328623525062913", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3662747857062156477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "15121448034928438384", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14122213471825630433", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14985236276429954162", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "14321283775111180227", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "98795127409553442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "14805540705424073865", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3788462090984291082", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "11823068760218786389", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "5963105523596432544", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "10308431308942416781", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "8712136292276123857", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "11314582467969020320", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "17147293671640396193", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "4465701487417893814", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6144958783262207773", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "10467232566885547072", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17262854991782705821", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4635570915184713874", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8706634286501695698", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "3863816884636503247", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9252629750817485029", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13168267319035362901", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "16567638487719493784", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "13449466515297095146", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "10808909442136736629", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "15172865163331822352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "16260483557979578317", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "7469127846325904854", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "8783239368699382065", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "3477539135137665170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "605638562926557381", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "12626994817506009929", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12417557233566012737", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "14056483847542666300", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "446997309263592434", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16589191615146805668", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "17226649394712507758", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "13566885629976429699", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "9931266845625995359", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2522707948254032777", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "6486250531858548438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8174273876544952794", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15049304780567617964", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "1321553039928725678", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "5105893636044171966", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1661430504764145711", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "10041204026657386200", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "15969909663367854367", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "10956917223944472347", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6060390128414591327", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10987291891349907631", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16452573613171944531", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6370356607952251648", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11547588640573840103", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6882259829255167273", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "4184283661465100793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "1799277562177870093", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "16276490504942526329", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13939380644892198347", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "14257398784378656791", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "14444423571297570985", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "9708741882115135691", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9374845449632011709", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11907741510409644649", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11833466191385766041", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "3276797683943990958", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "8494679093555050767", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16807117250109985357", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13642010365337780940", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5622078553841657218", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "3973953743850093759", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "3210709940026980348", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "15122428380000835284", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4492743859922847514", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3555469834146426564", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "13140141354298916151", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "7110352624440078898", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "9527046928040225586", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "7797523746053138659", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1478169078874265704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1264966373832011567", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13715010490012086430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "1470778934882087497", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "12725817227797568697", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10024777334075819235", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "364471436103661689", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4052362583575987109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10657660173790920140", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6557428245898292304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "9440117898128288296", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15929262283669093154", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6352520536724420824", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "1921667815983542102", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6088184848087986042", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "16602667769746047266", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "15953651221917495492", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "34011924689025090", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "674384870483198184", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3555798556624172621", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "13793032417416585006", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9019684110208109757", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "647849627466319112", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11242435114747058327", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "17302407573266205607", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "13606281481050014632", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "2466805217694531959", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "5511298016141559884", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "5483150635926637198", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "6265211373810873425", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "7643647841451578008", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "13254760530618979318", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16709502837180561673", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "15693956942112465267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17891347169069018262", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "10521453583707218193", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "14303192614979408043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "16609351383660437793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11118586558529856637", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "10939847328508611170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "5114254088513267110", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "10163486148946687267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "13296242326766100583", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "12068797674575015662", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "10978693262040522687", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "10037086825900566930", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "17216583849049249733", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "341552075482632478", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "738850098651678143", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "7139714914586273766", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "18209157436315328292", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 102) },
            { "7370360743945187446", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 99) },
            { "7953255701516490034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6195916781434462809", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "2400014444553855563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 3) },
            { "4622514167765722873", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "14680730265621679042", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 6) },
            { "3302557590307975559", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7648248878470053116", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "4917917708431763965", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "12978593897559876761", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "18064160378597803888", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "7689593699365225521", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "15819149710195058441", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "18274109287723887410", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "10269238332775024706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "9167138376243583750", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "5713105609160120586", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "150812658537571916", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "4485289322925780000", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "17268201530818712998", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "8747430148550634190", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16986358655784856534", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6109013751635776331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "9585113116232600562", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "3503893875515897267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "13144385730409574259", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "743941460026466526", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "4492332228252010118", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "1920042803083729276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "16436006771518788093", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "17567504672169904482", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "1989849521691057108", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "8203171222962341018", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9795194069954915563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "13369603621524676979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "2930658435447859986", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "10721885719016335538", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "17663718302088575615", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "10749263296616139689", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "18356235677223229518", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2657828809338947050", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15743750994087974449", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "754596461956525575", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17690103717758388022", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "1581136092002053880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "184306359395609972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "4891076250667414900", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 198) },
            { "10946917656449245131", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 302) },
            { "13963558035989415263", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "13239946614209250451", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "1076938718721677141", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "5851532147278358697", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "5746129902873132635", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "11592511763160794565", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "8244393417024602494", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "10340341966852782124", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10014822679257636832", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "3975219156915176189", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "13536863026622428609", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "11408010379683511978", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "15458285682224384803", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3407965587245145003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "10514330767826407566", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "4251496064392381805", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2384682907808363130", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "15705923658253281113", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "6610298174133949061", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6801247431347692935", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7702208423015808353", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "625378771032655972", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6542436061498779527", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10220143644047641696", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5009829190055738132", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "9863034269936216346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "16547699848349226093", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "13369144100905854138", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "9490927482615234033", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3544673182881983084", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3575537018273879487", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "12649957341095701480", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2321767794934000238", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "14973431782875808802", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11948858355027908365", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "473983206819135409", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "6586872365879203192", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "18412999191021390737", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5274456170971167904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "9275398105290923887", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11340683391412454009", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8100282867486124965", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "6361758198448370863", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16431503579923509596", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "10280282710562383672", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9138345765585313427", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11117326838088757686", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "18222598708685323020", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "5198859831430501652", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16644329894881952739", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "9367630847798077790", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "4906856539144714227", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "14958085423402252319", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9835535945548454398", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "187589970359123667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "678657374277098506", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8434335101659807351", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "15928128327390664485", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "16504425380504793738", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "6480587375918509253", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "9751235588096143414", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 283) },
            { "16866525370343398909", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "10160678465371702528", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17188750289444625186", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "14811603003184578943", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
        });
        td.td.insert({
            { "4363379197393466424", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "16403435599807360704", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9367985410929563457", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "10716232679616746794", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "622299920975636640", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "10798283054583509534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "14179140464588572277", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "351304363117543419", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "3499106702307464480", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "259619428712608645", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "3296098567244638489", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "13593304587712966846", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7572277082530361815", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6379337678256717737", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4513178474272034213", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3390430905253038550", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "925607706467451476", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "5627536079808515754", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16464493408368412759", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13839116996827687373", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "307874768879227632", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "10308113903347312964", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6712698149192186833", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14930789530046665855", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2204178900998688268", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17174919737114915467", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15154700439767512396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14916625550370402883", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "7650375560336513366", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "9999553425206328238", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "17515064188391421150", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10437367877444543776", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "4362304842016958728", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "383721620126444793", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "138379779469699309", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3759515057574218101", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2856601829807186494", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3286330985102373533", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8159303545761286685", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "4056979460327024961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "17823133607491820214", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7969441643457570812", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "970768445746568749", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "13678741578702922441", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17310844417517474522", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7287895452784411060", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6513788469599330141", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1432487477100132607", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2463151488506537801", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4054850047596998735", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9747825473942435842", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "250084243188516935", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "672634960435241508", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "748301576795035305", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14255457787105784042", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2750476114907782459", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10028244201873254140", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6469067021323571170", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10601714587235375373", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2483181247706575298", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1732853511466309905", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12113297049460198476", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11557224109907477240", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18084899872055349937", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2890305478244125142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "16659638340060273536", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7297768924198851782", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13104971224879807298", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5507252417827285564", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8511924860787648884", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8339235544283885013", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5654030701873405891", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1436723751951975466", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8325439593817651819", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17618112803233960227", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12327651080801123538", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13617891575616631067", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6020885536659393981", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1940159900852645250", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "753809225159529269", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8790166817024820739", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10677449690354999149", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10593983805743674128", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8217088979257009010", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5687085271369421207", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15279061373346657582", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7096501191029978469", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10094312347267495565", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3510084874150710192", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9391986481292718799", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5259220060268012597", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8117066211911522905", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10716559814452841971", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3949211089098986928", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14752151264004665491", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9195500778955925293", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13023666909692825369", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10961696014697611547", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "408602315578383859", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "582954161360487990", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2482190331248449465", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4075769657981876449", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14367142998060454343", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8114910678593187231", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4495451816890445327", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17102726573636919392", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10845009858831745215", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3112081942557253948", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1635689655354995548", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10250301712194120144", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4855747489298888657", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14238766089951260596", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7017830157652362654", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5619751660204221930", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18093663410921658106", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7869191330107002954", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7245974724868795129", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11019243479903456358", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12568255992252373147", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12413024322120393790", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17328716013187434957", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14899206494260920951", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9983462569671477588", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2383983224188083583", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1759538680129620900", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17194386925266836084", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1518413386955573037", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4104380387301024172", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6500468942462159659", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14136370464716049139", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4056919990977544228", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17351367314312762125", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17586380391909451000", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3561558658922596877", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3296755748686779746", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "534789472217562338", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10470060457279511896", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4917360877294344854", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3020953254086476464", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12307245536623707478", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17039711449439313953", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2734182509541824864", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14521225825422360447", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5857101685300045443", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1547471890307888038", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11159429929932958728", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1382911856313970571", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1854612313463195535", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13051406650237455505", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15438530452161762045", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7446661399223808792", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17861183465344343443", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2026622899016787854", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16127482065413259805", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12961109385388101976", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16855828799826043472", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15658859674277700656", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4833749391314748606", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3326691585067800328", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10718764522366711114", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13643973579671217152", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11155444222714959508", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "11544626480076777556", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14277552178674323256", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7792811600696842064", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10622803531832712558", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3079343528005019570", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3521119014097924580", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13643421651252474051", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6947390018658290847", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11697545935437523887", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2179704411405073702", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6886280732774854778", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15841879134365332862", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1489646217778958363", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8996027646503556955", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17569170625753249614", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16686854568163084344", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11187304651899164445", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14540721800838487177", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1979841019103384445", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13241679793873365192", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7013169017932712804", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17389114672554594444", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4157112143322859333", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15217255896294251282", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7606241825090144098", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8254388198068394779", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "755942233998922490", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14018816117251124336", std::make_tuple("fully_connected_gpu_fb_io_block_fp16", -1) },
            { "12054714986067446052", std::make_tuple("fully_connected_gpu_fb_io_block_fp16", -1) },
            { "1138657035758391650", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "3767246406609050779", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8536612779196342267", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18269766292810651342", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9646020463213439644", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5654817010240784792", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17277846909615605376", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "102220157823566379", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18213629255325554583", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8809496195168645264", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8506262325379391391", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "555647031314007743", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11133391567691287018", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4531238775069637542", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1050921927000835075", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3929145534169458063", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17125607183887169558", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3771153805567862915", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "5658567026478236676", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14520461267731870642", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15949156027942399242", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14569379143051211142", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5083162050523454050", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13951906075577108679", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9004122893718097099", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4336765005970913285", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1037896951032802088", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12090010131585526347", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9035445496715584647", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5455756262684457251", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7013197348316253486", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "143894893069959052", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13984124581247009793", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17964690428632248307", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5850736343172747247", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12379881923680871705", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11864459706509310150", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15222102499748205072", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1198491147477454704", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11400303472547811086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "11660798111579160734", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12081136231782604198", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14508437224082799436", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2396983035676921683", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11489881652545443112", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5651551840851524311", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11753049051286720239", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "479427514681077218", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10277290426401380976", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4919635200134986619", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8180846581099717076", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6411489040870738143", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4195122768220068448", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "52150349468142798", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4439371893496638788", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4039813343849078927", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16533127286587475454", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10264270523529136771", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9915620237695279980", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7090467930115498252", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15407802086492754450", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4007960934134542892", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2002110062193477745", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10154803388813032920", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1939527596007045209", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18436843102627176620", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "277852397173940175", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6822978927370753017", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10859939917723763131", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9248235209454206632", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2665169698359670120", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18266967379169677646", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5047972486012090625", std::make_tuple("fully_connected_gpu_fb_io_block_fp16", -1) },
            { "8183383667948205424", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14478151143114959230", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11396985422513105543", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12114476173765693172", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17041468169694105561", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16498300259966485293", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1173136780324694038", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15786764202107923723", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8913526950888110377", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15988378956341507229", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10993107955805947401", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6214677989814002369", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10884202393733523875", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4424960026145600447", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9763754389347695094", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "105055722864217258", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9775648000771985077", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15967893151722576439", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5774841809066688068", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "13402919586406297042", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11335142595937152387", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2689568881580764024", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6571325912136856822", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18122652705874970766", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2000008755333069005", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10361998183258703575", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12348644068948200883", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "736422312606696687", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16240864447025932692", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8589562027950762944", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9162564861963233717", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3167738956362101592", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7260746128189749064", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15308960063718398523", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10129304668926912275", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4853130422682926168", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14453982453535955244", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16608982023596566351", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2470663389603706356", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4240407752719875080", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4846563120992975368", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3706088306568590662", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14866563628584464675", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14721943524627076027", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9323941828298277387", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14109366965145192619", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4923997413838231159", std::make_tuple("fully_connected_gpu_fb_io_block_fp16", -1) },
            { "181017193671999192", std::make_tuple("fully_connected_gpu_fb_io_block_fp16", -1) },
            { "10757412618207229106", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "6395263375773555188", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5979046470758784946", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3927359449523162508", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "18232387132890063687", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6709212639543074230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "10086813986911195558", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "3109992766790372487", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "794530296606789816", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1249133049911188319", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2006024870459798086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11914297820344167381", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13079795735173763117", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6241224766048532539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16524474021378494125", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4407550747921719377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7259905085241841240", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "6666210546769702280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7814543122045448412", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13554702187867408038", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2547880010597993852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "9061076702890952738", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "15460429275475874158", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "7724185199575851246", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8533091468352267196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "15025120359649460106", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "2613575328969629284", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7463954007838579697", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "9151324495773628566", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "651020886445062493", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "8237821273547216740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2875927974837744359", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "3674322065648064195", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "137871170540938640", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "3066826388383295007", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "17483221428915982776", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "3403906310423395442", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "3888283018836731569", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "13928684419408478520", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "11520548550630007970", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4922714504620931501", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "15683804450763499599", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12686604223669447758", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "10746289671948325353", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "2487976264999747775", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "6163010595188500945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10404333823880552577", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "16662409111036688294", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "5400706842524705774", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "17423097433955762667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "18131954418490925431", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 275) },
            { "16549854027697846882", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "10340073416712988987", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "4633923265089466898", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "6808980404170272597", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "10592783998150232858", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "1594829714229111215", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "17361714725103230834", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 157) },
            { "15732140959902969012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 102) },
            { "5796974850751105634", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 97) },
            { "10588059104387338398", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 63) },
            { "11738780323979052397", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "16342972196376030503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 4) },
            { "10406201782146034797", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "17342758321852264926", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "15951978466742016539", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14100026884590707572", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8368507377481570353", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "2230145893895952661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "6320236287540885300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "3152975593520548377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "11756338894156892549", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "9310466098863912618", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "16780457022162749898", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17140702790441856730", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2578325663193624576", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8784358107340738205", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2955459120402821540", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2840794055129352139", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7104266560248570112", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11113125355390956764", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9127827617126714860", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "2268275392299271167", std::make_tuple("fully_connected_gpu_fb_io_block_fp16", -1) },
            { "10615831454139478379", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "8205640825965213946", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14337168375989245254", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11664399629496237233", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15750539817895707253", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "921209976738626097", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8590416145336196354", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10463632805036507382", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13637537549252005181", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7581949584623524395", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9814647153117279415", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3444250649099578792", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4039483032571506874", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "14309249337788077160", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6254493271976962295", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "12387660887222981357", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7723131901316908741", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "13963554827358438190", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "5001552360784483833", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14201142257504107783", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1066668660701816536", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4664196755018349672", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1103228955716492167", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "8618835732380720921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8391292909068775212", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "9488974186647231896", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "9069334144391048686", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "12493863403516600413", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "13375084585444085517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "18040173797801558071", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "15329174116169594863", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "14910223536998380801", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "18277685132620834972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 275) },
            { "13090887980792573261", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "3067806959725855130", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "17791773192152464021", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 141) },
            { "13603318842632052764", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 46) },
            { "12072881177966014126", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14413047954443174304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "9118663018352672834", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "3558391988878894288", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "10047727261970275928", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "11527382293059267033", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "8445575388700666150", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "4560479630843098090", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5737652209336034549", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "1159910924058542880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "7203172595229334691", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "8153567933591966877", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "6069305481947437228", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "2216113049194620088", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "10395837712676962495", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "5041111302824362529", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "12542825714985999760", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4599539412023802059", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "4570119951370893062", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "16897917745917378359", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 198) },
            { "6947523163603267191", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "2322126126611987721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "6518845972912144959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "9741774854327055438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7079854103926842364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5035895518536085765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4307157272240924516", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "142486914279119363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "1532263118203058517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13529694429433303321", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "2820916926593580316", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 116) },
            { "11140657515428786448", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9028970753877215614", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 102) },
            { "2324120381399737261", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "14311837335039030749", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 264) },
            { "6105963806494867023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "14746731245428677019", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "9213886570531053949", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 167) },
            { "385046297070779752", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "15882699446713091149", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "475043738497218394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "6351347283201596793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "16290626406346691996", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 32) },
            { "14038308632095412386", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15928183143089896780", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 343) },
            { "14071202918199194502", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "12383676694875725364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 342) },
            { "1830378766184274696", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 239) },
            { "13133105923394042921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 238) },
            { "12458275468325297142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 239) },
            { "1819720745131968914", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5140267554909755437", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "6021498606197929608", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "5832188635321350875", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "1411786954276574458", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 366) },
            { "18193548056717743576", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7989522965312833517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
        });
    }

    //KBL GT3e
    void tuning_cache_5927(tuning_data& td)
    {
        td.td.insert({
            { "4583484812233029888", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7560832358324865221", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7382044526960590018", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12372261924257291610", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "1547771611689525848", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "3134973665622945888", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "18260030211719729324", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "7416143717989012766", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "12028963907131702705", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "2464531851392092325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "8181308759455478086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "546062289721803579", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "4889405384318695802", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "12841232643395100314", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 107) },
            { "14108361259911144680", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "2726453304845436156", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "2607416795507802412", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "2175404966338020579", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "14666883719480623074", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "3752993663604843837", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 63) },
            { "5274735654559844733", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "8174421295799601683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "1967655354607438665", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "15762542971370422224", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "8183203099539372914", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "4075343423548891274", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "13264497096898621015", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "679058537775669048", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "3375634256357960999", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "2844616672368585285", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "14235558866846276172", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "18066867692765966577", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "9861424412782371874", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "607078314875528651", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "6234885984223387670", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "7223570329858821704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "17234843749633035510", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "11516168882438876247", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "11312664612825940140", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "14846039494240217143", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "3390376200501119384", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "1113077760071340574", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "4614875083188849196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 40) },
            { "10859023312681572942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "5588692131556725717", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "7653946972043115920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "9773458066743315157", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "10491513939202460216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8140122945471321201", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "15079423575410353790", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "12844146569641472927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "13443914015380511668", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "13404457916017756196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "6402415801415013013", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 111) },
            { "2040762223425679479", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "8595156989254845134", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "14493123117003003092", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7391309333582046386", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "9935182178960843140", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "15422142509105297183", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "14849987788569183527", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "14923132847727661051", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "13271555597925466454", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "6865593216823998846", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "12385437755245281331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "4530047829451377456", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "127643210248119703", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "2599051617462913767", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "3024020696533545102", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "16205377892664082400", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "15135655146332608939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "10848724554175904486", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "15558120704022404428", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "14120354125904513152", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "8475075092501403968", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "15892943371777404347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "15078418657871922661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "3502053626453342387", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "1230316443026403527", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "12846418701225147646", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "17386994561779281406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "7367684259946371231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "5451072983028714092", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "11758623888547009364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "15958650715061024845", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "13899144453581769028", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "10884229860266073967", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "6629431845229592220", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "13199442294147992119", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "5032929712205664246", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "14871333176552512036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "17890435688048047959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "11353661571093800805", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "3101908018947919238", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "7495240482209084478", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "6964506613327100469", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "3670645005971806718", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "69949758775887534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "13654393413005772278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "11101512074369779300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 80) },
            { "2273811004985590823", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7457154125218067377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7709677514862642399", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8010619564572573208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16479793487852125428", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3147355028342035061", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12672939642957531547", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12627961914394914920", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16210688853876861607", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 305) },
            { "1899485873740458557", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 287) },
            { "669151029135558505", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "8912067280071688393", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "7714589858275971005", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 143) },
            { "9794413496918699979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "18350040136091421971", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "16931304566154830346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "12816950084297042217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 287) },
            { "2359632276970855181", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "16592641501972654496", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "7754054384598160936", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "18195884921517044108", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 289) },
            { "16256130331524359070", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 291) },
            { "13497279823712860029", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "6095972148204769193", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "4149964766407000732", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "10262104071809780712", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "10707129891337660055", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 198) },
            { "3585075254981736756", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "3181067565488724209", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "8636008354706344794", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "4966150965920189853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "5569253153294942795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "11521347729886549503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "12399471154320580621", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "14851218369956754103", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "14859848826604327499", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "14783159891899899660", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "2369671961317151564", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "1691004331056506231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "4465288557833228023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "13538111995551348621", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "1886751914747841929", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "8445964247944285746", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "803205084059316676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "12654698468722759675", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "13484605287576302088", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "2469399061693302590", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "14782181149367028912", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "1448238652280623323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "2076478920663115306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "7369834759425644726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "11702633755046828968", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "2944972038827287015", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "8261441437673092886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "16694312773479519523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "5486494868955566721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "8246009573416434030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "9457894602447879547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4598302923247277427", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "3116224788980631217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "17103527368951412486", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "10150428063205056209", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "16984028253790680977", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "17857105233471273424", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "2715609009808401074", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "232807837985324954", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "13933912937625580405", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11254635684957519432", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "6729077823331194042", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "15961933828477762733", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "827225131390571924", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10429613013253088132", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14629385997654952321", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7546586420552408243", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "11897687507601277182", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "13975409361394567866", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "6458124573210430792", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "2385616965635993249", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14462438074931673266", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9338654554616107568", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "15476402794704488137", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "13654816209891478730", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "1680424228660495363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12929981792125924963", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "4698507050987130777", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "1094144958579794349", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12358908585763044267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "9793373151408615612", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "90849151510482266", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17277787450259342076", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "2367877811435050998", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "433942345363552443", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14575816691130255191", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3675622521877371819", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "7601637686045360430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "9818496628902493298", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "377651990943545344", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "16357661916741979192", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "5417669424921804056", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "854020380490533945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "11984602132438314210", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "13100228219613095795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "9808704199834907703", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13071373212254908241", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "18392748682101174561", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11928475964162658765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "11937547211842355800", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "4637568849323640167", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16812695025037565299", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "10487883723723512839", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15315014737515653325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "1579905786032546689", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4243996335899627971", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "2545885699369058867", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "16926950874716567095", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "6355395905401306995", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2096779676054335057", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4217179485243909459", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 195) },
            { "17101789600628162503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "6139574161497189424", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "16559140502701231107", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "11459784003592366395", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "7869916853707978306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            //{ "3889519976910355277", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "12081835728078383819", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "14923692894655929923", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "1841901358010744236", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10888203577545955226", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9799890897264103013", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1827296932806936575", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "13010820430079828498", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "6245781545617904772", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "8714031312599034571", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "12922099252166105096", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3042887030242700493", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "1419879016567682338", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "12870587285162108523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "6103433181190121715", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "3469599265931338557", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "14812617666668076833", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "14854734265631496499", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "7637441820772916248", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "14695781272831602408", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "15696910741835640150", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "17790593820165047954", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "1433224983833208570", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "16185194021453870096", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 173) },
            { "10310918050196558188", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "14885938077915823034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "14442357887993453368", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "4719130523147011420", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "8870222084473246330", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "9350596936816632825", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 173) },
            { "6183248276225219542", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "3757195189216622027", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "8318857994507665384", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "12864512857659000129", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "6615646900347529347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "5208923086986567490", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "9390793435913144215", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "11997629302296435180", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "4858270366437120918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15975176007724247667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "16837473534895641370", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "16214153687871223428", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8858112708913743577", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "8844677471730173649", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9043742986995534354", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "15621341038256548867", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 244) },
            { "18268980125375728709", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "9757167087033785227", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6513982093384445397", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "9273893819042428704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "8270840662337272430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "15021512490648380369", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "6578908625437515675", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 47) },
            { "13762042713029963144", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "668798769117277023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "10917498758625273194", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "14335423820860953927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13978750151855895830", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 120) },
            { "8965747921518186477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "4428101657497677982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "8151272056391095510", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17656341100957270390", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "10295330953350618042", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "15901675909820977223", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "6026876733674266377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "381149736509958403", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "7962991673727743706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "10064251191248475177", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16663239694378513014", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4690831975451405214", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "16132498413588349821", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "10609644803793651808", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "16520784657717262379", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "2271187702055786721", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1872921634399989626", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "12535576637355537200", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7771729980527620398", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14849108908297747749", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14043770215999952932", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15277856047844308598", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8048617952947915835", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11446745541571732900", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17422822627612865758", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "13954144830230671601", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11198908896401597838", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 111) },
            { "5582896843095691256", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "8133587696326295326", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "2007192658799516915", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "9492402787848610840", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "10515519878978734341", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "1375156980278317418", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13455881643467418059", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12788968383428254917", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12304975739476881266", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "3390014193205017427", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "13587202155230938291", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "14462744723628661203", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "16109721499545711936", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 150) },
            { "10090923790949378407", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16672038432561840773", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2973773544904290726", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17193614571243427089", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2862029728492027826", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11066930104187448422", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2755147389712995637", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10662798624911535617", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "2172121470071868949", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3579916582911190192", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5495063314176654751", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3771003491521695667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "15514370342945522276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "17285639145064557279", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "12642574441854544900", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5471430682416582179", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8561154029325525444", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8939900194037985459", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2129726780118554358", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 363) },
            { "15463465056816958579", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "9268536904925062469", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "45977313646881991", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "7092246390386193774", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14801984300948838261", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2797723586312707948", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "8451212914744825089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "5131348852069018593", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "13619081494170885939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "8818679285688095197", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "4608292692528881356", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "9729987752669765456", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 358) },
            { "1782966703272153440", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "15641674846325113216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "18140951659547259039", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "3416294810798281053", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "12066560812164094695", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "9332596500956923556", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 355) },
            { "15067550526427941795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "15428062440621131394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 359) },
            { "8873614802459592665", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "3367130693014583254", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "14135594471530769414", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "14971707650115908544", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3036512701943687724", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "5334291640387922287", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "16245760498096322525", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "9928406318940388716", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "3369894612786523432", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "590505356692040012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "13240472672791632740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "7128145024365641089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "11497327844388026594", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "7301757962797024939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 219) },
            { "18121689595247452649", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "875296362957469305", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "14912119584313592912", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "12494969618927201911", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "4640611487944119712", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "1692411934657235774", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "1673006919995519093", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "10601835610089648700", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "13262672660175739705", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "7639015398436550592", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13867172651521406104", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14587150810299279663", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17271409929705935575", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16744813357455687598", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 305) },
            { "17215047912921813592", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "4093195092417588676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 305) },
            { "17895953872149392740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 191) },
            { "5918874715861160937", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "14498368518428801865", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "13857947326347149693", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "4965619590663772423", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "17153828952517174005", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "9864812885638557249", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "8410695282651246173", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 198) },
            { "3011957000022205132", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "18202466898415347292", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "11433166800587133728", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "4499160027703324879", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "10225878843410985743", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "10961131057009777878", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "17123897723015586893", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "3938875063592179645", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "7589320923145169660", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "13907115679251591389", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "5262155845067632954", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "12323619994816664201", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "13711624246076632711", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "13879644216615040961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "13418213186769741623", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "9850414237385072276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "13762987373425432087", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "15387492794262813616", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "9455446170928387706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "7799083605029182328", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "6416346888102436677", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13401162817870652306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "4574862993950020539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "3956303186129893250", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14928794187754412027", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "9892597035419316966", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "10290107543739998181", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "5275016494706355806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "10947686124973711385", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 55) },
            { "3997597867012981671", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "4003433148846544263", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "4361250474585164062", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "10523363119855336043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "1718324808394833635", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "8430284238380067998", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "3950448771871155887", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 282) },
            { "9033877528655370244", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 281) },
            { "8878071105867359307", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "7511984934520363336", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 111) },
            { "860443413504997114", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "4957638663977636791", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14793503588688729262", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "9303039486341715392", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 197) },
            { "8923406201866512905", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 315) },
            { "14629889085799380442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "4811310048537439646", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "8622985922687454592", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "8611046137980763541", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "1879796404388368873", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "6928835003016610382", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 250) },
            { "8603207107304593583", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "6477198553362516437", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "6377441002585730862", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "15761554874575656075", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "118354408955419547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 101) },
            { "13601202334102031245", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 101) },
            { "11716196499333250570", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "16984923535088627888", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "364996668506826202", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "6412527114952548517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "4892959859293355837", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16127331840410137228", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "13335944978055152562", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10715829903767495958", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "6065404265303390338", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "3897655522585667381", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1860663592951633878", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "5698748062275134041", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "15945452307780131237", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "6764685582382238740", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4737109912659941670", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "9371952894576491521", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "12696412964119109465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "17825874529822806486", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 268) },
            { "8220763890959777277", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 265) },
            { "17731591992960147987", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 265) },
            { "8950668477702067729", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14991602704357959545", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "16383540667048742064", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16820082917500285799", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6820284286806022849", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17285815901490707654", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "994182747184593564", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "6642767323474835034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "3215659303601163167", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "54975980454651672", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "11529876081402974396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3644282167178264526", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "360872770877634346", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16720108310653948550", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14353390922580547467", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9868561386826862471", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "17465517455679097501", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "5570311824197099845", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7524311370696987092", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "14070988879848388270", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "8296551195150971668", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14352796912241296357", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9840495023131952174", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4720851194954041037", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "17009318615658405230", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
        });
        td.td.insert({
            { "9421643783312790618", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "10693348571961406417", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "2940027113687311893", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6090625728451718945", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "5643908654122573882", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8852322966320229583", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "11185156002426041243", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "14670068483447729857", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4623542918584461522", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "3126708271410621754", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 109) },
            { "1434535531617424039", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "17025268985366223779", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15398976608777968810", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "6149673627320838019", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "7413341807736193935", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6071597471486669736", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1127095963814993729", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8611856835854445891", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11115935318793891293", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "5393081375805921525", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "17589256877540537468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "4135814997524960840", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15180348902159643465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "2818524781020760666", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "4942080349816430490", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "9263314249867362", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "14377032179148581309", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "15245529372955421912", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "13595283050046771323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "15667549927492357263", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "13827442968070281886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "12076060884099762835", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 323) },
            { "16532386511585070092", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4910582540370962997", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12335148041391647118", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10689880083512104726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 167) },
            { "8870164706606458004", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "9269498023794081940", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "6779832349039897240", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "13942354789498444722", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 102) },
            { "14294764660016835141", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "12323510278692809329", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "5728070995112243570", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "5381496395266530071", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "9712640406795417230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "15036737419347383878", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 110) },
            { "11552594222313787816", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "9399255910184037480", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "10594581016504135920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "15640487942881889055", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "14165417928501578590", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "12251989236991754721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "6675363512560434713", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "9831713940431605743", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 122) },
            { "6531349504807709133", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "2726501303929773572", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "10439704858943788014", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "18137994263450376706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 63) },
            { "5711991739289045727", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "15255831401757117660", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "3906658058160172747", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "15823433297099049221", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "7829483638597533960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "14092273913846393837", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "3746578485711843646", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "12228183555926126959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "8776893332387904786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 63) },
            { "16672299044236704672", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "13309889945947393850", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "15966815420067673043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7415938485228396256", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "9655590024687998403", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "14798289196964890724", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 63) },
            { "9794684437872784678", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "16729204245488754836", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "15185983488152870534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "13821372148587948765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "4727004015814244856", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "1738348894912205653", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 63) },
            { "559491455289877068", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "17312172687490475177", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "3470176432841342662", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "8950283515337670839", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "3995072673238444396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "1238913228370790536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "928677976151553489", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "4059887681292863495", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "10493952422143348278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "5610465912655751128", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "759163065093339795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "11300938516591867859", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "12843263740221725967", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "888316366026890514", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "8088645310090149658", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "15891058658954073255", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "3456538031339928220", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "14187063304165334647", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "11593893535334124231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "9218293603091125898", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "3614865264081581688", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "8860682105104682547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "3775781894241463386", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "8857354069987696352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "5611508857136313396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "10872828113308792940", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "3726594456692340607", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "7541331569935741737", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "5639394073086652531", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "11158391063762007051", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "6319861294308997034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "6893801771793379570", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "9015970699147699643", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "9252735579930779632", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "16237353798629485972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "10916127635689513485", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "14631094106016920364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "5050075828787158563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "2277573429750402800", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7462044209068160751", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "8879836520351993142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "560198731460537880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "6414187394150266523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "15317838148382459105", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "11219109605495282242", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "10404790565578782014", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "4657890394631454901", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "4256171754976506222", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "12658039760507507230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "9883901352719605734", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "5115148310176289236", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "4892280615322354003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "15491567059821267605", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "4716932801711295063", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "15559962129967760292", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "7866546777503165080", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12994023006726461909", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1869893771689012539", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5635187738652974532", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12849693339574251399", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13233683642200681957", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "4310121962651039089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "7620758476872568593", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "10344702612951473525", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 138) },
            { "1668590302432600271", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "8750610033922701675", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 281) },
            { "6913992575736424382", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "17945230226911262869", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "7356559449640788577", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "18349175655630268884", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "16817085704588915904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 138) },
            { "9503107262691437536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "15595806193584438610", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "14283867094396458105", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 280) },
            { "14215445060938730397", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "12720976113342879024", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "14766625154638709852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "11757187678986741715", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "13038212285326297688", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "13919423909034348565", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 166) },
            { "12925256096286953030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "6275163484075546689", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "239651884801599911", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "9500211224156027451", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "10902538092301362853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "8454943813981348115", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "11722951613064434115", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "13547342611064538960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "15171119202712914112", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 169) },
            { "5451487099025245427", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 169) },
            { "1814940262511664251", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "16341609351317463829", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "14343280871046671393", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "15586404971308258630", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "15891211707425019144", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "15351688973597240327", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "1844016761754156672", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "17925606428283439978", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "15050158761219834868", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "17448180555072943363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 171) },
            { "11422222075976800614", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "14284377769814732906", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "667777413731244716", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "11624071786842686451", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "3874974512053082278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "5471037497181745651", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "6371386660654628561", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "5331835606773958814", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "16163821504542698475", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "5697543838890997891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "6217438921274668801", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "2633095809604510774", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "11218297661079136641", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "3374196543196230185", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "17797320202829145544", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 200) },
            { "17198778757516749818", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "6440981718484677922", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "1616603916015535857", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "7643715911083095268", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "137903092932521503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 167) },
            { "13203019690952060789", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            { "3918152537861570517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "8782903242853500098", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "18312668164562040079", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "15160703466234996170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "2751241748685218213", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 123) },
            { "12622728760401804660", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "1290624457831957354", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "10924946887162830574", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 63) },
            { "10789202693606479024", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "3718558874911694616", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "12835389389575311182", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 41) },
            { "17406431092101974143", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "1400409391266374603", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "12154660333025778322", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "4800587664660105589", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "16474284418841532356", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18117355153710110681", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 343) },
            { "8449591498895477846", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2962899568083589487", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 218) },
            { "3491333679577961640", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 226) },
            { "13945298510228460890", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "4282198629458668761", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "779525528509830615", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "15002237905129290671", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "16833026567865627676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "16991060247581867302", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "6902644989079870993", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "15088285782819494786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "3379661203936923589", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "10049571207493913006", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "15691689005236690951", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "11275109735493317886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "12220860296984467101", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "44210723233569665", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14014987361364503383", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "18189351665719757712", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16159032667792855758", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3374037004378790060", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "6765409971512438438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "10098892297878373639", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "981877665302032867", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7472350511000146655", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "15513971895394346930", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "6169721205327431190", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4519054607159036572", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "12750124851833311828", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "4333851142313192116", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6041620003527819661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "15091361629922645798", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "9348121965341418899", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 342) },
            { "393951904144235223", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3220084080191614421", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "11610588256244825741", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2802357220980817497", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "8972812517118478580", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "4207115359813621211", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "16582237002610438015", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "772342953072606219", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8546247990965609013", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7971830510840138313", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3570484486449791727", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11461079340079820563", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "12663860560275361463", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "8132521728369930959", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16108573960501496757", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11086699387784339943", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "4013707396889204359", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "11850332373794932468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "14763982961176216679", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "8207349115037232863", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "3273748387141431306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            //{ "580936360000782237", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "10682918518101379579", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "13178480813522103091", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "14472322679644532468", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8378137527264154204", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10180255575636684134", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18242121098885244699", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "6178572652675599622", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "6558074021146321216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "11038938372264857379", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "17137800360536507200", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "14016185289182597841", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "8970519484272874266", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 364) },
            { "3289746379259038515", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 364) },
            { "18389174979070260315", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 364) },
            { "17666483005735191253", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "10845781902676865789", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "13646634862315619979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "5072154928583891344", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7757331094141318304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "16779678846332091086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 236) },
            { "12223166874490429642", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "13316017702896072758", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "10390896207372295988", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 166) },
            { "8386498395042623384", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "17923632501885139982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 163) },
            { "13398326377839777956", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 291) },
            { "13520557646924372128", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "5996787039089786722", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "2626376166907387273", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "6147643392694904814", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "4311921348668650791", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 291) },
            { "8046109476498335792", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "14190077682825257613", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "5032302126047788183", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 169) },
            { "15256375572125522238", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "5083173538217738703", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "17269467004855120308", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 171) },
            { "2901056469731554922", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "9747637051217505111", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 169) },
            { "7175860674618956918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "9530922411870814200", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "11015319643831560673", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 171) },
            { "5182740559503076121", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "7567277014404457462", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "15973842639221447367", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "15951492056203075273", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "5283253936050062275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "17650690912303447913", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 135) },
            { "9614936270604202220", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "13998661469619523378", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "10584034255622783869", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "2973436171295280783", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 41) },
            { "1908809004094565452", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "1623383628456201603", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "5766507688771440170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 167) },
            { "16626226341188424071", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "14619055893081624406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "17222005830854879661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "14224121742920800990", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 167) },
            { "5859124386313585730", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9596156698919548146", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 44) },
            { "10482582307328548806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "407189201971322683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "16626507949474235269", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "879005904827468163", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "8460847842045253466", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "2729099061601852493", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 302) },
            { "8233922303282945338", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7402006230339617617", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8420763628389536977", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8325767678959979628", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 238) },
            { "7673672840505587739", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "14166169053627992481", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "120923426036313670", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "7348084298010357768", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 270) },
            { "14653065651448352526", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11008522061447263744", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "305505245310584136", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6472139251351862598", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "10586018593856542117", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "16706121580364790904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5495776091407365966", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16430562172386510259", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5673972310424776040", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8797843396807284399", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "1698321314111848001", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5762290464889692462", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 226) },
            { "3218248162832023196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "12988961529988078346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 226) },
            { "4232250144427804891", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11683680166617045816", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "6252429564537528709", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11717348577195224554", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9275303306340702111", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12245096462203481681", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 138) },
            { "18439435691655740074", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "15272426400992401555", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "9136831791301215059", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "18238669114790278675", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "15376246520426368532", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16469788155263456039", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "9360494451263553093", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "7897877428349481398", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9354818521586974021", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5853553261686771766", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6351572488552853754", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11372638316835753193", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6170074103544756465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "4544242784357021697", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14225108809796795520", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "178353385245384751", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "2002574142025049539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "11630971824787392820", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "11542493210215136239", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 361) },
            { "9595803435783166868", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17610828776103321939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "18312069177632970412", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7577483892218843723", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4355933224673863178", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15124932296735391043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16888042302987189589", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 365) },
            { "1584639932403433303", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "15516194807992507442", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6614374536332038989", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5097818987523855112", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6623182990939010641", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 216) },
            { "17001023283013862129", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7935150275452094595", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "2326323992207208685", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "5072735784865711772", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "4683841893192741312", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "10341773151035665956", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14109534738984061372", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "16706244336960642883", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1967030672241059921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "1482100699000420627", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 284) },
            { "13632911653636980024", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "6198830126915940359", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "12125006289181390694", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "14152716242882609401", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16732621354152092286", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17921489101554455214", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7384108582424003436", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13139625572508441980", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "16491532291908469567", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 355) },
            { "17788367809717898285", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "1509728225855233852", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3816705689596666600", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "14157505468412850916", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 146) },
            { "17366807170224886960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "14548509699664316785", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 238) },
            { "10404702662303016402", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16436357970364549479", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4858167644379876157", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "4381329435655511217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 354) },
            { "13972357557211413688", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "6580334406272192111", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "194072522984726408", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "4490223883171428014", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "17194603517181970633", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "6995235840871804844", std::make_tuple("fully_connected_gpu_yxfb_ref", -1) },
            { "1671208365782918441", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "11718418772370938734", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 82) },
            { "989564341557094953", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 55) },
            { "8133676065307881979", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "14555883089089918919", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "14026570177552137240", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11686670048744589243", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6678796313875454849", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "641417817126876622", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9622546530872848323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 343) },
            { "9194788897910888066", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "522181557896569275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 342) },
            { "3332334993503432420", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16131448347558322280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "13852065717057446998", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4342360467977736802", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16336482874764861478", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6075691042233712335", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7570346182940928159", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12971822824884826169", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3033264172690274208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17301887391757619741", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "15790005937034794347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "15464327246951632247", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "5659168916726488798", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "8079376692609682448", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15160738482264643601", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13953639482255428227", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12293786134765875615", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "18214412375127043522", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10670103699537731664", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "10147266284710177932", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11443268857010762276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "4659943649635556150", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11726298758004767743", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "13896680298436380632", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3797957937905580811", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "16294962940703055933", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8526484907799590618", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "13723543003759101485", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9873647901670251106", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13268525255152984893", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "13008742408950833847", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8616686489737649890", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "11423865221956815041", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "14990645740260870030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "15204453579641378742", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "10892456883214928095", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "17856816245251319111", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "1799430190598598671", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "3106591708459602370", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "4111904926378218826", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "7678457226823073886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "8786249783185140623", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "5389189982064081933", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "15175088047384943892", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "15331103261044247142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "3627273785739110683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "12478309735214802531", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "7212944937255713716", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "11873734271080160669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "18421820525219154881", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "9553032671453999824", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "3860603464276263676", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14115313335378184289", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "9519623751582710696", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "10288726118862235940", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
        });
        td.td.insert({
            { "2231648183489019418", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "6316097202867006365", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "16208488491972128275", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "17978026144659698965", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "2566302789609970663", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "2714742023091949586", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "3087801652564627458", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "8602155166799218249", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "14230385851791760020", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "10828719108804915700", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "13973179950424276578", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "3668927000317872012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 204) },
            { "7947870656736319919", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "14767888121198814523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "10401632438377178271", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "8762901342272872498", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "10783981060353445280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "12608289345175485333", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "7875272450497189442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "1599725688135122629", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "11932770338770247767", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "11184047387366978375", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "11716771904412649891", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "12576157843776905380", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "8402692278765063674", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "6781076363516398481", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "3255465741612432300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "9767950219863105043", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "7134654288295280046", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "5821853991835395449", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "3480732841490521799", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "6973260260946088987", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "15649927926091502215", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "7910468668367486698", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "156456996459945842", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "1994927850993519406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "16431165572426232677", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "2864254144951744544", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "5390559917122707732", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "8378839908604146288", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "17163158934005653629", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "1185280691070355160", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 202) },
            { "1999979442136861875", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 125) },
            { "2527189070714658176", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "16032797290430373799", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "16783619135298589974", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "12785335515281046438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "9216608098626790565", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 41) },
            { "18257496796879980386", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "2452226948562393335", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "11072545690050335239", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "12668149981216388765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "714898562476771473", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 83) },
            { "11115684531624462986", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "8710684853144029787", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "3752171257634205726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 41) },
            { "5243587439683016777", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 85) },
            { "16881283637687482989", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "6042976104660344109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 83) },
            { "7351733901977025859", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "9341400376014914418", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "13713406612642090169", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "683350872280694452", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "10436819182310112786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 41) },
            { "10269788826827249402", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "12558716383635737426", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 41) },
            { "7181186153851700294", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "8107447526839063293", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "1016414921656805365", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "4871907623235871050", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "15539976365475470623", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "3880189981766119529", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "10154958553575016770", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "4561874206785244358", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "12358640399843058144", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 81) },
            { "12956726277674279950", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "7177837234452118325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 44) },
            { "3160080179644173650", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 343) },
            { "9832551412183684637", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6347790007333387897", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "13219313818719819982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 149) },
            { "17780553554354185249", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13315473376247698298", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 151) },
            { "11815135771923538945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "12465309202808173810", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "7171436879576678563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 324) },
            { "9407046952012845638", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "8805267762044816983", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "14381377343079009210", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "13248818835662551847", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "9300668734746602663", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "7706778813807762766", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "16991433003318725315", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "4584399194832832140", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8558026087297588736", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10198351802037434471", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13257958112171706655", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14722464361594874490", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1544616395544118800", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5955569479109539856", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17738708576252096108", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "10276056345160651377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "13515249925520423329", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 302) },
            { "10055593174764596789", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 302) },
            { "8707130584661395715", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "11161176476048297041", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "6959258479021077609", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "6365109451272429541", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "8191978674781978488", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "11604224659996035116", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "1759873215866222608", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "4559874433048442047", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "6937259685509040959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "8242732346001884230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 243) },
            { "16156727721974657541", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "13786314015179226945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 181) },
            { "4202371435873473624", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "10933135228023712253", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "14467312749536832362", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "10557843071473489529", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 254) },
            { "14967016402348718219", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "7594056145185406157", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 95) },
            { "12051754199123379659", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 193) },
            { "2634827464202220192", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "10211888372266149335", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "4548339182509526896", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "828946941343000506", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "13008375263617223352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "5638301531544801477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "10213021343800816450", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "12000084249129063723", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "18040104088851490930", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "16394608147869554267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "15229178454191871174", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "5927467766675317093", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "4877661058006573128", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7515937801840512449", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4747017546101861376", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8833751655076849826", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "16256124470203598218", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2706523860113152678", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14946999257618007034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "13699343107940933196", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2887515984302814699", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "4906737644615337997", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "4725303208352054390", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14955652052550053223", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "862470330257326268", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10381668587006680936", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "2593337359555305520", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 347) },
            { "10774393239130591748", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "16247780189312707876", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "4487284881658782961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "2811240876735166934", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "2447678508469638445", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "7454164784767168407", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "18275848121133385773", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "13759457214873634937", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "4855959048455906948", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "7160112985819045832", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "6880424067049089394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "748023061136366353", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 342) },
            { "15793120434966402276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "1932618420321708351", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "3336444565837087463", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "15067224168014815918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "4431271266410883917", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "14115818307364071162", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "15250928896997938213", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "13013685738525906988", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "17607598031220186942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10278583197921433748", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "5300123851331202735", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "10751381988703627540", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "9905160045246767203", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "2927340528757005274", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "16243861301305882872", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "15004681374954252324", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4496537089364942280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "13357951046545317387", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "12878719705192625362", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "4785466104509327241", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 108) },
            { "2416244034719176938", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 226) },
            { "17785504548342377669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12811319921474895164", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 281) },
            { "10760000973615798613", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 240) },
            { "6300105753728135778", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "5791707725846814784", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 221) },
            { "13246629627758485603", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "9400558994532871122", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "17865276008842107020", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9981156409872807880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "4626770940790542333", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1094262369519841857", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "5523297987528243797", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1789389636704094004", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13544237579827433636", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17696244668222870549", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "8926171136732424790", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "16179159307898475953", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2692291137583386471", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1095433004701276122", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "16277739324697771064", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 347) },
            { "15945243427420522827", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "12296021067910843036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "10673589588224406026", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "3585431879296991112", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3119002388778552316", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 372) },
            { "5322582996019286781", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 340) },
            { "13225749488949717853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "13207215182979880133", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 340) },
            { "17730578026124357983", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "9725306578495355500", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "5277508201756602822", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "12806959657459851511", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "15232478805009654818", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "17712227426604098630", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "2530975976273876727", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 351) },
            { "6232318392696042532", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 349) },
            { "13657818175298160631", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "4088603773237062922", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "11177710514557128293", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17515272254985846970", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "312130674630486188", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "18247095696433793115", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "6341728273786101457", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "10401462893795799864", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "3032101782888447048", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 218) },
            { "15078331029547630371", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "18043541805861795852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "7608435380564752000", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 281) },
            { "7129337563584588644", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12204270722180734542", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "13588405581356678469", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "4986281570682617547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 225) },
            { "2214420531345686129", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "15030725973433075086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "15384520760315696372", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1915712383376159541", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6176816506826300479", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "15331830720555178784", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17558578036713688769", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "2388815483287403961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "15948716167523201661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "6787190800192250525", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3378135802544446861", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "13053802967262518173", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "5503306970973862635", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9417884304413500664", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "7866083951140251349", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "10084810175406860705", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "10342347371769114236", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "4063042455950354352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "10055531955039754920", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13173341667656398216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "9356247214800869277", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "8630592326601832361", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "5041676938441886628", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15379755045295790608", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "13410979599123644577", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13504573816477550406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "4459291258089899503", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13992993617743773278", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13395962624719382401", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1535675815795592775", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9849036672784280133", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10780684483689207763", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "4060515618437959603", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9203467651096078409", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "9698108593334526558", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3252398754887381352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "3120759967333088019", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "2024996599975373573", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14876099702827489987", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "8653894569484019347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "4004518396368398824", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12801342874692090364", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9387557098916352467", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11689587446775003898", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13973363990921590224", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "6278030053136901802", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "12122586525659611649", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17711197779492504718", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12489342380264260364", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12148845150031891038", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "5080727465135503101", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16818862727193981112", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "1827977959922344361", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "6291003899324240633", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3002862967523058894", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7222921168135747513", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 219) },
            { "8696847224485998117", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 218) },
            { "7453625482178960081", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "1472822945750487574", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2032419134020329477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 219) },
            { "805104869568121149", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "17215312565214990348", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "1737128374457513820", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16263489451695566992", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "1608378717397996752", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "14346703182362139650", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9744493065276230785", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8331721527098298378", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12097373631649932423", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17442035600389810700", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15953351443307161934", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "8740196547852036537", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13809436837912218131", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9722172495422643735", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "2662628817605495834", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "6163765140843670080", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 340) },
            { "15662207751131195569", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "16494358566119044242", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "12641727819019838301", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "4917595053453614536", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "14577496472237742721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "4356806313729405658", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "14282717676967464809", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "7275701540104992761", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6459003512612780875", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "12791541622557283904", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11882713776717158678", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10982479758700194728", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "8714769962126708854", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "7639744043430667021", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6804493132858449665", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5204696395552974337", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "8893913418784905112", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13496918758899426996", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4707842387180272918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "425930963222944558", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3844246198992827038", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14280128364139551919", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "6774493262072228712", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "5670860641930464485", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10055923266096584825", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13508499324621059445", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "17431631935986646683", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5568431877348597159", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "356320499267651746", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "10632294140185068783", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12339584174527699309", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 350) },
            { "8556999353039153661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "15381427144405510339", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "8855986581847188591", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "13704396706685353016", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "17128550517647168353", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "8625183189646433895", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "7921388663815287395", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4213330047036138895", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17034122796081495259", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13076343553185159307", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5854267518455107328", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13675314612031135613", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "12825029449351875037", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "9397711809671506538", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 111) },
            { "12965800692507042874", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "2647922515901529845", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "10961049607808752432", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "13988022841867948024", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4612862531793961340", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10950469938532358632", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2228733394430438519", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "12015814430456201522", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "12344008430499496640", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 321) },
            { "9863615330219779441", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3560058786734628608", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16047381404034145819", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9714811479610938662", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "7306541374689856571", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "5689486642279577539", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "15545653867155770893", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14910368344505819159", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3220771309796407003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "12786796142417489350", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "13947140171097868740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 266) },
            { "1168311873250200110", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3495786143085325748", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2164537487697642190", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10623345643437043886", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15240415102190323330", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 250) },
            { "10321975076426598984", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6467563111927343808", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "4280198021826662216", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9464830880142854424", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12113781253211924677", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5410693492803892704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4844529595057806427", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10848097581672953022", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7947428837044782745", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11705938507822117867", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "8334753494554256932", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "4995468555341975721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "6282308289220311358", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "18275232300842488846", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "15754022314306112499", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "15193841338943103284", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "956475051281637098", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1117811515417136925", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "760383787039304033", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5351526116347538406", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15923292837937693143", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2954421933443715181", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14945079011377285773", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9573520179708447727", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "11432977101529429562", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8918387046558682780", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 250) },
            { "16699295198130950587", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "17358462939783262207", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "17406383217119217230", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "14003645277231336821", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "6638761803107874904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "1630585964216121575", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "10745248353587672572", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "13395074742046717601", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 124) },
            { "12659539044474018256", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 141) },
            { "6598024975967050290", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 141) },
            { "2006890470582854116", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11369389082421346630", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "4986977887030495943", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 63) },
            { "9681320098885387731", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "8730097760819044515", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "11882021989615795558", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "8202324251716703125", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2932157519158822224", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "8431962471592709199", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16116546888494787089", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "2954606701225038770", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "6757752550680050481", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "5893257440341358427", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "1327911294059513894", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "7771820069600757360", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "4618159169098049590", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "12268432630136256720", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "2373658589834410892", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "8440300225468667909", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "14495382595913294626", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "4974435385259831818", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4455497237293642238", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "682912708716537431", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2585176064846114298", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16033144151193421543", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 348) },
            { "12141880589558027223", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 343) },
            { "10098661517988566506", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "16192971634546462244", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "14793709237400480942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "1646362346584649954", std::make_tuple("fully_connected_gpu_yxfb_ref", -1) },
            { "4874397454627474644", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "6171331678772388712", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "7496699438957793920", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16767657090925788431", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1006721963560645335", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "14753245713079865819", std::make_tuple("fully_connected_gpu_yxfb_ref", -1) },
            { "1779870708816318465", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "17157919258161230886", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "12398103047184982980", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "2961249862769657168", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12131460825751874564", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "12365814254940023343", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17218545462549916519", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11877919824125633092", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10679711602282897680", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 195) },
            { "17801375178828079914", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15446821602347034830", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 198) },
            { "16041087076800110589", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "14102351022029437177", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "5786978465690715325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "10140124683113804219", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "14022671143475909407", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "7468500876165989695", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 297) },
            { "4628560194573173205", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 197) },
            { "3963065974337687046", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "13439359175348786664", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5342116782332968020", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9198777289928370963", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18276472227494448327", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "15774430281717785574", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3887883367078892827", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1004081473410027655", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "5460182945235134126", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "7932494263344450271", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5596359111431962318", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1116176429672030385", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14642276070370158123", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1709508499926680213", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15466995361950304551", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "12936512845587590244", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4464844599426088921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "12966090642798680442", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "128970554088066862", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "7183620142123364052", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "3793885399790365373", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "4932548298968525464", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 225) },
            { "8248099164876900927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "249355510483373796", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2837134119351786115", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "141687758281942172", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 226) },
            { "15718782218800307385", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "3191047205441946466", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1564774057733793087", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
        });
        td.td.insert({
            { "11134833419828370568", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "1556966764088589197", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "6087676883600048234", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "15052286556809931759", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 280) },
            { "3377724880784871475", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 315) },
            { "3452246087500006120", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "6840268976700446867", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4278180549747978226", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17856997406888930289", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 195) },
            { "16556093306187145310", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2581594444558181374", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3377472614945731801", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10622082408513122112", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "11452807035432891156", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13529174180301001127", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 315) },
            { "17184405948599119534", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5921658305530976502", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6802655190570100236", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17877430344093804543", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "153771221207255459", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "15596913527233792996", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "1016967125909374575", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6829653688530177613", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6094638411430816112", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7559615879839693931", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11270266455366424659", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7100226796198950149", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "210793817522061488", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "11152357292626304216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "5771335481927877060", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "14619753612256300695", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "2839767407547705101", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4981552552200657366", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9626028243479089234", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3164513064874019611", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2363414141971004557", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8962502004422485576", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3154903035376733831", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16134637021630473012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "5553176511624221429", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "4890932609897686394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "15334769670416409064", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "5513667102916409932", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5351705572686943348", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8200094670006738584", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 194) },
            { "8100051552977329013", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9004823715680825977", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "16179959997108523051", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15148625184033310404", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6577754887650563753", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "13182965457868586949", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "13839590781642269381", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "12711366212612147422", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "7963529808900784906", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "12184558469694708819", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "3285180770267559354", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6613282637922219205", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17093159649157277089", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14660081992091188026", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16228026045292341333", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "269829518575229806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "13023942860659386957", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "13291308922240014334", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "1187622888238643867", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16229324496308453344", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "14019704891647234793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 342) },
            { "6141637854990273316", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13524128602135083081", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "531020979837645217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "8416686771626338600", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "2916077416184925232", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "16862531110856250955", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11352536854890889084", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1683347645109643149", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4374049085310743239", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16159971034327080937", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "15779210035964863067", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15153285262450947102", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7049603973253724866", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9389671301472986523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "13891598020647124806", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "9315279998737090956", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "18261342465838720356", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3632541114724731809", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "17088320301520334100", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "4352363968456148009", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "1827842275223841485", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7548767746018027960", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "17750850961096057029", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "7606282654661282476", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6201358671959761215", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4829111442270007186", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7267651931396380072", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "1279682391530947146", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2655979063469551930", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14425547983540742516", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "981419593633555198", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12324657364444167791", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3246153532847702583", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4202705710324555180", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12272318018055307535", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "396815044270978782", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15633173680908856082", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "16635731992372618666", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "10418466892824851134", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "3244777852750357718", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "2443758478383854939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 322) },
            { "13503934436248311972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "2594310972560076285", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "2424349375092546581", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7104985983444651979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "13518747015059826801", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "11675809062974151496", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4725349695436675084", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "17351243519367619322", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "17026338651868178077", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "8730407034445893642", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "144434691308306757", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "4114184149613179671", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "2558882920723584206", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "16481414687792927331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "17756651805686889890", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "2228533392085335649", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "9038567144062573854", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "1345293381483212104", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "729683192738752814", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 329) },
            { "458997435535883643", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "16955907389221472146", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "17927673764274384911", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 372) },
            { "6418222853479731432", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "7539191242110313918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "18014188548165359278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16640379332042800496", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14856197725306980283", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9279474331309267880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "5717588912072437191", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "1143426643765799488", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "1049385516019456025", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10766144770072425534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "6442062011017461761", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "6063490496423709036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "3892512749863226006", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "4970240836537468609", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14668725050395069435", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "7939047354407928586", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "365747554145156596", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18207060402110970301", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11049175652352131465", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "2982080608393779951", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17216477578093693014", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14116923400742300182", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7029133126202354787", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17420660823086709040", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 347) },
            { "17300489799784213303", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15549100047322521213", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8342403220432961494", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4600322689355365368", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 347) },
            { "6432444239720173669", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "5944283189654634640", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "8682613468075783516", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "5788340143385910170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "14166708932229380784", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "9262263820759430835", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 339) },
            { "10661619519548036109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "11254313793397682889", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "8941570659228294791", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "3711589321155572550", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 342) },
            { "13440603011986281192", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "10072782544067079397", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "855625721312733540", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "8643403818712296708", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "3482316012102041163", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "15966346359387758212", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "6179768494274723997", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "110891946535801188", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "13300595681637438535", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "16686223109098592740", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4196950243745604808", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "15357494333788579519", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "5791271012599760917", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "3502203881558439278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 340) },
            { "6615043890071705766", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16602880550249876273", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8163937071550477896", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4788158788847752998", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "11048286378242522780", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15669268280202512868", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "11708180973354877349", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 221) },
            { "7429872600277069485", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "18404744652577257121", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 220) },
            { "15145594907273468650", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 222) },
            { "17189550036105947900", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7167054889777381093", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "3278181836788028231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6040360226338233118", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6877955452402826287", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 311) },
            { "10864271596740164097", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "14322983802576638073", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9469688466553577331", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13052522487775745493", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "10990480508394584613", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11406807220585770939", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17014949219411078284", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "2128641903680430067", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "8751004549226570175", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "12508733516106581272", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "1535119834165965208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "6537771397615897748", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "16911666678187393426", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "18163247824658143109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "3169531413538986325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "1861963470217658786", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "17175653712131007582", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "12148428445687813823", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15239273648189016892", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "17290692657168386471", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14119365735362663804", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4225327120021140533", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "673126354575235249", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17628454700752918711", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3529846607992358207", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "342387360760418341", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16353520814579109491", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "3134099148543397372", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3042628567386436226", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "868736197323541759", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3241775197578183463", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7851643406001230159", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "8502552745012743053", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "10353443026537243362", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3104552371734307984", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12807894319350246437", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11258614397356100246", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12946314097679886518", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "12909725304008017600", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "6153017925473103663", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12188122150443559128", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11983651079897753600", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12988924268115973386", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "4891686540869580517", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15196732464112076502", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "459391085160518545", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7760457628691335753", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4865678723441158246", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15589245661365969249", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "9661616000023492219", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14777607874956018667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "14113322810933328214", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16281761113420371943", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "16988191641007425377", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13194254226778628574", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12531936952559145430", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16379080233376322220", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "2613462626256090659", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "15844881725957151580", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8059328623525062913", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3662747857062156477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15121448034928438384", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14122213471825630433", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14985236276429954162", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 348) },
            { "14321283775111180227", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 348) },
            { "98795127409553442", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14805540705424073865", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3788462090984291082", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 337) },
            { "11823068760218786389", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 343) },
            { "5963105523596432544", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10308431308942416781", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 228) },
            { "8712136292276123857", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "11314582467969020320", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "17147293671640396193", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "4465701487417893814", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6144958783262207773", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10467232566885547072", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17262854991782705821", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4635570915184713874", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8706634286501695698", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 348) },
            { "3863816884636503247", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9252629750817485029", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13168267319035362901", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "16567638487719493784", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "13449466515297095146", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 341) },
            { "10808909442136736629", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15172865163331822352", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "16260483557979578317", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "7469127846325904854", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "8783239368699382065", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "3477539135137665170", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "605638562926557381", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "12626994817506009929", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12417557233566012737", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "14056483847542666300", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "446997309263592434", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16589191615146805668", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "17226649394712507758", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "13566885629976429699", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9931266845625995359", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2522707948254032777", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "6486250531858548438", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8174273876544952794", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15049304780567617964", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "1321553039928725678", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "5105893636044171966", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1661430504764145711", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "10041204026657386200", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "15969909663367854367", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10956917223944472347", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6060390128414591327", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "10987291891349907631", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16452573613171944531", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6370356607952251648", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "11547588640573840103", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6882259829255167273", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 340) },
            { "4184283661465100793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "1799277562177870093", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "16276490504942526329", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 340) },
            { "13939380644892198347", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "14257398784378656791", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "14444423571297570985", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "9708741882115135691", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9374845449632011709", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11907741510409644649", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11833466191385766041", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3276797683943990958", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8494679093555050767", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16807117250109985357", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13642010365337780940", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 107) },
            { "5622078553841657218", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "3973953743850093759", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "3210709940026980348", std::make_tuple("fully_connected_gpu_fb_io_ref", -1) },
            { "15122428380000835284", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4492743859922847514", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3555469834146426564", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "13140141354298916151", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "7110352624440078898", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "9527046928040225586", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 352) },
            { "7797523746053138659", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1478169078874265704", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1264966373832011567", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13715010490012086430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "1470778934882087497", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "12725817227797568697", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10024777334075819235", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "364471436103661689", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4052362583575987109", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "10657660173790920140", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "6557428245898292304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 338) },
            { "9440117898128288296", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 350) },
            { "15929262283669093154", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6352520536724420824", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1921667815983542102", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6088184848087986042", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16602667769746047266", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15953651221917495492", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "34011924689025090", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "674384870483198184", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3555798556624172621", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13793032417416585006", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9019684110208109757", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "647849627466319112", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11242435114747058327", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17302407573266205607", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13606281481050014632", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2466805217694531959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "5511298016141559884", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5483150635926637198", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "6265211373810873425", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7643647841451578008", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13254760530618979318", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 258) },
            { "16709502837180561673", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "15693956942112465267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "17891347169069018262", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10521453583707218193", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14303192614979408043", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16609351383660437793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "11118586558529856637", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "10939847328508611170", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 261) },
            { "5114254088513267110", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10163486148946687267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 248) },
            { "13296242326766100583", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12068797674575015662", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "10978693262040522687", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "10037086825900566930", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 143) },
            { "17216583849049249733", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "341552075482632478", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "738850098651678143", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "7139714914586273766", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "18209157436315328292", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 102) },
            { "7370360743945187446", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "7953255701516490034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6195916781434462809", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 141) },
            { "2400014444553855563", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 6) },
            { "4622514167765722873", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "14680730265621679042", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "3302557590307975559", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7648248878470053116", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4917917708431763965", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12978593897559876761", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "18064160378597803888", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 346) },
            { "7689593699365225521", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "15819149710195058441", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "18274109287723887410", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 347) },
            { "10269238332775024706", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "9167138376243583750", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "5713105609160120586", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "150812658537571916", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4485289322925780000", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "17268201530818712998", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "8747430148550634190", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16986358655784856534", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6109013751635776331", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "9585113116232600562", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "3503893875515897267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "13144385730409574259", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "743941460026466526", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 229) },
            { "4492332228252010118", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "1920042803083729276", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "16436006771518788093", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "17567504672169904482", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "1989849521691057108", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "8203171222962341018", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9795194069954915563", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13369603621524676979", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 250) },
            { "2930658435447859986", std::make_tuple("fully_connected_gpu_bs_f_bsv16_af8_vload", -1) },
            { "10721885719016335538", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "17663718302088575615", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "10749263296616139689", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "18356235677223229518", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2657828809338947050", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "15743750994087974449", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "754596461956525575", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17690103717758388022", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "1581136092002053880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "184306359395609972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 223) },
            { "4891076250667414900", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 198) },
            { "10946917656449245131", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "13963558035989415263", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "13239946614209250451", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 295) },
            { "1076938718721677141", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "5851532147278358697", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "5746129902873132635", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "11592511763160794565", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 188) },
            { "8244393417024602494", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 314) },
            { "10340341966852782124", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10014822679257636832", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3975219156915176189", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13536863026622428609", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11408010379683511978", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15458285682224384803", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3407965587245145003", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "10514330767826407566", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "4251496064392381805", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2384682907808363130", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15705923658253281113", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6610298174133949061", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6801247431347692935", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7702208423015808353", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "625378771032655972", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6542436061498779527", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10220143644047641696", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5009829190055738132", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9863034269936216346", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16547699848349226093", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "13369144100905854138", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "9490927482615234033", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3544673182881983084", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3575537018273879487", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "12649957341095701480", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2321767794934000238", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "14973431782875808802", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11948858355027908365", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "473983206819135409", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "6586872365879203192", std::make_tuple("fully_connected_gpu_fb_oi_ref", -1) },
            { "18412999191021390737", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5274456170971167904", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "9275398105290923887", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11340683391412454009", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8100282867486124965", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "6361758198448370863", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16431503579923509596", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10280282710562383672", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9138345765585313427", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11117326838088757686", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "18222598708685323020", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "5198859831430501652", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16644329894881952739", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "9367630847798077790", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 320) },
            { "4906856539144714227", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "14958085423402252319", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9835535945548454398", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "187589970359123667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "678657374277098506", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8434335101659807351", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15928128327390664485", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "16504425380504793738", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "6480587375918509253", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9751235588096143414", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16866525370343398909", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 150) },
            { "10160678465371702528", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17188750289444625186", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14811603003184578943", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
        });
        td.td.insert({
            { "4363379197393466424", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "16403435599807360704", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9367985410929563457", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 313) },
            { "10716232679616746794", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "622299920975636640", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10798283054583509534", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14179140464588572277", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "351304363117543419", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "3499106702307464480", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "259619428712608645", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3296098567244638489", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13593304587712966846", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7572277082530361815", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6379337678256717737", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4513178474272034213", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3390430905253038550", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "925607706467451476", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5627536079808515754", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16464493408368412759", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13839116996827687373", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "307874768879227632", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10308113903347312964", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6712698149192186833", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14930789530046665855", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "2204178900998688268", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17174919737114915467", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15154700439767512396", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 334) },
            { "14916625550370402883", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "7650375560336513366", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "9999553425206328238", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "17515064188391421150", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10437367877444543776", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "4362304842016958728", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 259) },
            { "383721620126444793", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "138379779469699309", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3759515057574218101", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2856601829807186494", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3286330985102373533", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "8159303545761286685", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "4056979460327024961", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "17823133607491820214", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7969441643457570812", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "970768445746568749", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "13678741578702922441", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17310844417517474522", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7287895452784411060", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6513788469599330141", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1432487477100132607", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2463151488506537801", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4054850047596998735", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9747825473942435842", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "250084243188516935", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "672634960435241508", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "748301576795035305", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14255457787105784042", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2750476114907782459", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10028244201873254140", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6469067021323571170", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10601714587235375373", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2483181247706575298", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1732853511466309905", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12113297049460198476", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11557224109907477240", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18084899872055349937", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2890305478244125142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "16659638340060273536", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7297768924198851782", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13104971224879807298", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5507252417827285564", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8511924860787648884", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8339235544283885013", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5654030701873405891", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1436723751951975466", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8325439593817651819", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17618112803233960227", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12327651080801123538", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13617891575616631067", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6020885536659393981", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1940159900852645250", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "753809225159529269", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8790166817024820739", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10677449690354999149", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10593983805743674128", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8217088979257009010", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5687085271369421207", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15279061373346657582", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7096501191029978469", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10094312347267495565", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3510084874150710192", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9391986481292718799", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5259220060268012597", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8117066211911522905", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10716559814452841971", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3949211089098986928", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14752151264004665491", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9195500778955925293", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13023666909692825369", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10961696014697611547", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "408602315578383859", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "582954161360487990", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2482190331248449465", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4075769657981876449", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14367142998060454343", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8114910678593187231", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4495451816890445327", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17102726573636919392", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10845009858831745215", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3112081942557253948", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1635689655354995548", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10250301712194120144", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4855747489298888657", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14238766089951260596", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7017830157652362654", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5619751660204221930", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18093663410921658106", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7869191330107002954", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7245974724868795129", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11019243479903456358", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12568255992252373147", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12413024322120393790", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17328716013187434957", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14899206494260920951", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9983462569671477588", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2383983224188083583", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1759538680129620900", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17194386925266836084", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1518413386955573037", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4104380387301024172", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6500468942462159659", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14136370464716049139", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4056919990977544228", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17351367314312762125", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17586380391909451000", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3561558658922596877", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3296755748686779746", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "534789472217562338", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10470060457279511896", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4917360877294344854", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3020953254086476464", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12307245536623707478", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17039711449439313953", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2734182509541824864", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14521225825422360447", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5857101685300045443", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1547471890307888038", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11159429929932958728", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1382911856313970571", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1854612313463195535", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13051406650237455505", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15438530452161762045", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7446661399223808792", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17861183465344343443", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2026622899016787854", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16127482065413259805", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12961109385388101976", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16855828799826043472", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15658859674277700656", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4833749391314748606", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3326691585067800328", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10718764522366711114", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13643973579671217152", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11155444222714959508", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "11544626480076777556", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14277552178674323256", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7792811600696842064", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10622803531832712558", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3079343528005019570", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3521119014097924580", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13643421651252474051", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6947390018658290847", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11697545935437523887", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2179704411405073702", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6886280732774854778", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15841879134365332862", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1489646217778958363", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8996027646503556955", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17569170625753249614", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16686854568163084344", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11187304651899164445", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14540721800838487177", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1979841019103384445", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13241679793873365192", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7013169017932712804", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17389114672554594444", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 369) },
            { "4157112143322859333", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15217255896294251282", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7606241825090144098", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8254388198068394779", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "755942233998922490", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14018816117251124336", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "12054714986067446052", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "1138657035758391650", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "3767246406609050779", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8536612779196342267", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18269766292810651342", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9646020463213439644", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5654817010240784792", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17277846909615605376", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "102220157823566379", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18213629255325554583", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8809496195168645264", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8506262325379391391", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "555647031314007743", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11133391567691287018", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4531238775069637542", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1050921927000835075", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3929145534169458063", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17125607183887169558", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3771153805567862915", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "5658567026478236676", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14520461267731870642", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15949156027942399242", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14569379143051211142", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5083162050523454050", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13951906075577108679", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9004122893718097099", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4336765005970913285", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1037896951032802088", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12090010131585526347", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9035445496715584647", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5455756262684457251", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7013197348316253486", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "143894893069959052", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13984124581247009793", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17964690428632248307", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5850736343172747247", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12379881923680871705", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11864459706509310150", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15222102499748205072", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1198491147477454704", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11400303472547811086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 368) },
            { "11660798111579160734", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12081136231782604198", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14508437224082799436", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2396983035676921683", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11489881652545443112", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5651551840851524311", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11753049051286720239", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "479427514681077218", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10277290426401380976", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4919635200134986619", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8180846581099717076", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6411489040870738143", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4195122768220068448", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "52150349468142798", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4439371893496638788", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4039813343849078927", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16533127286587475454", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10264270523529136771", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9915620237695279980", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7090467930115498252", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15407802086492754450", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4007960934134542892", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2002110062193477745", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10154803388813032920", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1939527596007045209", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18436843102627176620", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "277852397173940175", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6822978927370753017", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10859939917723763131", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9248235209454206632", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2665169698359670120", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18266967379169677646", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5047972486012090625", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "8183383667948205424", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14478151143114959230", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11396985422513105543", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12114476173765693172", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "17041468169694105561", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16498300259966485293", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "1173136780324694038", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15786764202107923723", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8913526950888110377", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15988378956341507229", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10993107955805947401", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6214677989814002369", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10884202393733523875", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4424960026145600447", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9763754389347695094", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "105055722864217258", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9775648000771985077", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15967893151722576439", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "5774841809066688068", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "13402919586406297042", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11335142595937152387", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2689568881580764024", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "6571325912136856822", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "18122652705874970766", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2000008755333069005", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10361998183258703575", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "12348644068948200883", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "736422312606696687", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16240864447025932692", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8589562027950762944", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9162564861963233717", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3167738956362101592", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7260746128189749064", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15308960063718398523", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10129304668926912275", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4853130422682926168", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14453982453535955244", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "16608982023596566351", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2470663389603706356", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4240407752719875080", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4846563120992975368", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3706088306568590662", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14866563628584464675", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14721943524627076027", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9323941828298277387", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14109366965145192619", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4923997413838231159", std::make_tuple("fully_connected_gpu_fb_io_block_fp16", -1) },
            { "181017193671999192", std::make_tuple("fully_connected_gpu_fb_io_block_fp16", -1) },
            { "10757412618207229106", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "6395263375773555188", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5979046470758784946", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3927359449523162508", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 156) },
            { "18232387132890063687", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6709212639543074230", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10086813986911195558", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3109992766790372487", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "794530296606789816", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1249133049911188319", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2006024870459798086", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11914297820344167381", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13079795735173763117", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6241224766048532539", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16524474021378494125", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4407550747921719377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7259905085241841240", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 367) },
            { "6666210546769702280", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "7814543122045448412", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "13554702187867408038", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2547880010597993852", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 199) },
            { "9061076702890952738", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15460429275475874158", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7724185199575851246", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8533091468352267196", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15025120359649460106", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2613575328969629284", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7463954007838579697", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9151324495773628566", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "651020886445062493", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8237821273547216740", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2875927974837744359", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3674322065648064195", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "137871170540938640", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3066826388383295007", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17483221428915982776", std::make_tuple("convolution_gpu_bfyx_direct_10_12_16", -1) },
            { "3403906310423395442", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3888283018836731569", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13928684419408478520", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11520548550630007970", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 183) },
            { "4922714504620931501", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 194) },
            { "15683804450763499599", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12686604223669447758", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10746289671948325353", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2487976264999747775", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6163010595188500945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10404333823880552577", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16662409111036688294", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 263) },
            { "5400706842524705774", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "17423097433955762667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "18131954418490925431", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "16549854027697846882", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "10340073416712988987", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 155) },
            { "4633923265089466898", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 262) },
            { "6808980404170272597", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "10592783998150232858", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "1594829714229111215", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 143) },
            { "17361714725103230834", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "15732140959902969012", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 102) },
            { "5796974850751105634", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 99) },
            { "10588059104387338398", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11738780323979052397", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 142) },
            { "16342972196376030503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 3) },
            { "10406201782146034797", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "17342758321852264926", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 42) },
            { "15951978466742016539", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14100026884590707572", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "8368507377481570353", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2230145893895952661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "6320236287540885300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "3152975593520548377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "11756338894156892549", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "9310466098863912618", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "18376135355406021646", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "2024521518658822242", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "9692442768327912638", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "8031184163763974840", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 335) },
            { "13429621587271813054", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "17938009873557420461", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "16780457022162749898", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17140702790441856730", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2578325663193624576", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8784358107340738205", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2955459120402821540", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "2840794055129352139", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7104266560248570112", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11113125355390956764", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9127827617126714860", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "2268275392299271167", std::make_tuple("fully_connected_gpu_fb_io_block_fp16", -1) },
            { "10615831454139478379", std::make_tuple("fully_connected_gpu_bs_f_bsv8_af8_vload", -1) },
            { "8205640825965213946", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "14337168375989245254", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "11664399629496237233", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "15750539817895707253", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "921209976738626097", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "8590416145336196354", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "10463632805036507382", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "13637537549252005181", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "7581949584623524395", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "9814647153117279415", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "3444250649099578792", std::make_tuple("convolution_gpu_yxfb_yxio_b16", -1) },
            { "4039483032571506874", std::make_tuple("fully_connected_gpu_fb_io_b8_f8_vload", -1) },
            { "14309249337788077160", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6254493271976962295", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12387660887222981357", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7723131901316908741", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "13963554827358438190", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "5001552360784483833", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14201142257504107783", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1066668660701816536", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "4664196755018349672", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1103228955716492167", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "8618835732380720921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "8391292909068775212", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "9488974186647231896", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "9069334144391048686", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "12493863403516600413", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 278) },
            { "13375084585444085517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "18040173797801558071", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 252) },
            { "15329174116169594863", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 241) },
            { "14910223536998380801", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 84) },
            { "18277685132620834972", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 155) },
            { "13090887980792573261", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 126) },
            { "3067806959725855130", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 158) },
            { "17791773192152464021", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 172) },
            { "13603318842632052764", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "12072881177966014126", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14413047954443174304", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9118663018352672834", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "3558391988878894288", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "10047727261970275928", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "11527382293059267033", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "8445575388700666150", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 345) },
            { "4560479630843098090", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5737652209336034549", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 347) },
            { "1159910924058542880", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "7203172595229334691", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 273) },
            { "8153567933591966877", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 353) },
            { "6069305481947437228", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "2216113049194620088", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 227) },
            { "10395837712676962495", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 360) },
            { "5041111302824362529", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 201) },
            { "12542825714985999760", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4599539412023802059", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4570119951370893062", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16897917745917378359", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6947523163603267191", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "2322126126611987721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "6518845972912144959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "9741774854327055438", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7079854103926842364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "5035895518536085765", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "4307157272240924516", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "142486914279119363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "1532263118203058517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13529694429433303321", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 271) },
            { "2820916926593580316", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 250) },
            { "11140657515428786448", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 257) },
            { "9028970753877215614", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 206) },
            { "2324120381399737261", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14311837335039030749", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 288) },
            { "6105963806494867023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 134) },
            { "14746731245428677019", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 242) },
            { "9213886570531053949", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 54) },
            { "385046297070779752", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 154) },
            { "15882699446713091149", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 127) },
            { "475043738497218394", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 159) },
            { "6351347283201596793", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 93) },
            { "16290626406346691996", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "14038308632095412386", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15928183143089896780", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14071202918199194502", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12383676694875725364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1830378766184274696", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13133105923394042921", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "12458275468325297142", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1819720745131968914", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5140267554909755437", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 225) },
            { "6021498606197929608", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 238) },
            { "5832188635321350875", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 238) },
            { "1411786954276574458", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "18193548056717743576", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7989522965312833517", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14123865825367908500", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
        });
    }

    //APL 10W
    void tuning_cache_5A84(tuning_data& td)
    {
        td.td.insert({
            { "4583484812233029888", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7560832358324865221", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "7382044526960590018", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12372261924257291610", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 355) },
            { "1547771611689525848", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3134973665622945888", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18260030211719729324", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "7416143717989012766", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12028963907131702705", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2464531851392092325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "8181308759455478086", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "546062289721803579", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4889405384318695802", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12841232643395100314", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14108361259911144680", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2726453304845436156", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 203) },
            { "2607416795507802412", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "2175404966338020579", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "14666883719480623074", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "3752993663604843837", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 56) },
            { "5274735654559844733", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "8174421295799601683", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "1967655354607438665", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "15762542971370422224", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "8183203099539372914", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "4075343423548891274", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 132) },
            { "13264497096898621015", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "679058537775669048", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "3375634256357960999", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "2844616672368585285", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 336) },
            { "14235558866846276172", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "18066867692765966577", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "9861424412782371874", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "607078314875528651", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "6234885984223387670", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 132) },
            { "7223570329858821704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 336) },
            { "17234843749633035510", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 205) },
            { "11516168882438876247", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "11312664612825940140", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "14846039494240217143", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "3390376200501119384", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 115) },
            { "1113077760071340574", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 336) },
            { "4614875083188849196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 87) },
            { "10859023312681572942", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "5588692131556725717", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 287) },
            { "7653946972043115920", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "9773458066743315157", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "10491513939202460216", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "8140122945471321201", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 86) },
            { "15079423575410353790", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "12844146569641472927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 287) },
            { "13443914015380511668", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "13404457916017756196", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 69) },
            { "6402415801415013013", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "2040762223425679479", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "8595156989254845134", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "14493123117003003092", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7391309333582046386", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9935182178960843140", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "15422142509105297183", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14849987788569183527", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14923132847727661051", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13271555597925466454", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6865593216823998846", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12385437755245281331", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4530047829451377456", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "127643210248119703", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2599051617462913767", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3024020696533545102", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16205377892664082400", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 333) },
            { "15135655146332608939", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "10848724554175904486", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "15558120704022404428", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "14120354125904513152", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "8475075092501403968", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "15892943371777404347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "15078418657871922661", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 355) },
            { "3502053626453342387", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "1230316443026403527", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "12846418701225147646", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "17386994561779281406", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "7367684259946371231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "5451072983028714092", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "11758623888547009364", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15958650715061024845", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13899144453581769028", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "10884229860266073967", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 330) },
            { "6629431845229592220", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "13199442294147992119", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "5032929712205664246", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14871333176552512036", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 362) },
            { "17890435688048047959", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "11353661571093800805", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "3101908018947919238", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 336) },
            { "7495240482209084478", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 210) },
            { "6964506613327100469", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 103) },
            { "3670645005971806718", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "69949758775887534", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "13654393413005772278", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 287) },
            { "11101512074369779300", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "2273811004985590823", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "7457154125218067377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 208) },
            { "7709677514862642399", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 246) },
            { "8010619564572573208", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "16479793487852125428", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3147355028342035061", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12672939642957531547", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12627961914394914920", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16210688853876861607", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "1899485873740458557", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 302) },
            { "669151029135558505", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "8912067280071688393", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "7714589858275971005", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9794413496918699979", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18350040136091421971", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "16931304566154830346", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 290) },
            { "12816950084297042217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 302) },
            { "2359632276970855181", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "16592641501972654496", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "7754054384598160936", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "18195884921517044108", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "16256130331524359070", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 301) },
            { "13497279823712860029", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 302) },
            { "6095972148204769193", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "4149964766407000732", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "10262104071809780712", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "10707129891337660055", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 178) },
            { "3585075254981736756", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3181067565488724209", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 194) },
            { "8636008354706344794", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "4966150965920189853", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "5569253153294942795", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "11521347729886549503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "12399471154320580621", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "14851218369956754103", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "14859848826604327499", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "14783159891899899660", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "2369671961317151564", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "1691004331056506231", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "4465288557833228023", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13538111995551348621", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "1886751914747841929", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "8445964247944285746", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 175) },
            { "803205084059316676", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "12654698468722759675", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "13484605287576302088", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 253) },
            { "2469399061693302590", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "14782181149367028912", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "1448238652280623323", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 174) },
            { "2076478920663115306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "7369834759425644726", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "11702633755046828968", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 179) },
            { "2944972038827287015", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "8261441437673092886", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "16694312773479519523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 217) },
            { "5486494868955566721", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "8246009573416434030", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 215) },
            { "9457894602447879547", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 221) },
            { "4598302923247277427", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 217) },
            { "3116224788980631217", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "17103527368951412486", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 214) },
            { "10150428063205056209", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 255) },
            { "16984028253790680977", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 211) },
            { "17857105233471273424", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 217) },
            { "2715609009808401074", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "232807837985324954", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13933912937625580405", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "11254635684957519432", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "6729077823331194042", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "15961933828477762733", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "827225131390571924", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10429613013253088132", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14629385997654952321", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "7546586420552408243", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "11897687507601277182", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "13975409361394567866", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "6458124573210430792", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 332) },
            { "2385616965635993249", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "14462438074931673266", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9338654554616107568", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "15476402794704488137", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 217) },
            { "13654816209891478730", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 230) },
            { "1680424228660495363", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 225) },
            { "12929981792125924963", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "4698507050987130777", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 356) },
            { "1094144958579794349", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12358908585763044267", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "9793373151408615612", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "90849151510482266", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17277787450259342076", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 303) },
            { "2367877811435050998", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "433942345363552443", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14575816691130255191", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3675622521877371819", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "7601637686045360430", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9818496628902493298", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "377651990943545344", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "16357661916741979192", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "5417669424921804056", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "854020380490533945", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 328) },
            { "11984602132438314210", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 355) },
            { "13100228219613095795", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "9808704199834907703", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "13071373212254908241", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "18392748682101174561", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11928475964162658765", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11937547211842355800", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 231) },
            { "4637568849323640167", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16812695025037565299", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10487883723723512839", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "15315014737515653325", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 331) },
            { "1579905786032546689", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 327) },
            { "4243996335899627971", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "2545885699369058867", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "16926950874716567095", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            { "6355395905401306995", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "2096779676054335057", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4217179485243909459", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "17101789600628162503", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "6139574161497189424", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 224) },
            { "16559140502701231107", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 213) },
            { "11459784003592366395", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 212) },
            { "7869916853707978306", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 94) },
            //{ "3889519976910355277", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "12081835728078383819", std::make_tuple("fully_connected_gpu_bf_io_input_spatial", -1) },
            //{ "14923692894655929923", std::make_tuple("fully_connected_gpu_bf_io_gemm", -1) },
            { "1841901358010744236", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "10888203577545955226", std::make_tuple("convolution_gpu_bfyx_1x1_hgemm_buf_16x1", -1) },
            { "9799890897264103013", std::make_tuple("convolution_gpu_winograd_6x3_s1_fused", -1) },
            { "1827296932806936575", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "13010820430079828498", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "6245781545617904772", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "8714031312599034571", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "12922099252166105096", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "3042887030242700493", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1419879016567682338", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "12870587285162108523", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "6103433181190121715", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 251) },
            { "3469599265931338557", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14812617666668076833", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "14854734265631496499", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 364) },
            { "7637441820772916248", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 364) },
            { "14695781272831602408", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 217) },
            { "15696910741835640150", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "17790593820165047954", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "1433224983833208570", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "16185194021453870096", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 194) },
            { "10310918050196558188", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "14885938077915823034", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 294) },
            { "14442357887993453368", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "4719130523147011420", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "8870222084473246330", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 192) },
            { "9350596936816632825", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 182) },
            { "6183248276225219542", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "3757195189216622027", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "8318857994507665384", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 192) },
            { "12864512857659000129", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "6615646900347529347", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "5208923086986567490", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "9390793435913144215", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "11997629302296435180", std::make_tuple("convolution_gpu_bfyx_gemm_like", -1) },
            { "4858270366437120918", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 265) },
            { "15975176007724247667", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 249) },
            { "16837473534895641370", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 293) },
            { "16214153687871223428", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "8858112708913743577", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "8844677471730173649", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 180) },
            { "9043742986995534354", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 250) },
            { "15621341038256548867", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "18268980125375728709", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "9757167087033785227", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 256) },
            { "6513982093384445397", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 250) },
            { "9273893819042428704", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 260) },
            { "8270840662337272430", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 141) },
            { "15021512490648380369", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "6578908625437515675", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "13762042713029963144", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 325) },
            { "668798769117277023", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 172) },
            { "10917498758625273194", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", -1) },
            { "14335423820860953927", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 326) },
            { "13978750151855895830", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 247) },
            { "8965747921518186477", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "4428101657497677982", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 245) },
            { "8151272056391095510", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 62) },
            { "17656341100957270390", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 44) },
            { "10295330953350618042", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 7) },
            { "15901675909820977223", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 207) },
            { "6026876733674266377", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 6) },
            { "381149736509958403", std::make_tuple("convolution_gpu_bfyx_os_iyx_osv16", 4) },
            { "7962991673727743706", s