// Licensed to Cloudera, Inc. under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  Cloudera, Inc. licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

%options case-insensitive flex
%s between hive impala
%x hdfs doubleQuotedValue singleQuotedValue backtickedValue
%%

\s                                         { /* skip whitespace */ }
'--'.*                                     { /* skip comments */ }
[/][*][^*]*[*]+([^/*][^*]*[*]+)*[/]        { /* skip comments */ }

'\u2020'                                   { parser.yy.partialCursor = false; parser.yy.cursorFound = yylloc; return 'CURSOR'; }
'\u2021'                                   { parser.yy.partialCursor = true; parser.yy.cursorFound = yylloc; return 'PARTIAL_CURSOR'; }

// Reserved Keywords
<hive>'ALL'                                { return '<hive>ALL'; }
<hive>'ARRAY'                              { return '<hive>ARRAY'; }
<hive>'AS'                                 { return '<hive>AS'; }
<hive>'AUTHORIZATION'                      { return '<hive>AUTHORIZATION'; }
<hive>'BINARY'                             { return '<hive>BINARY'; }
<hive>'COLUMN'                             { return '<hive>COLUMN'; }
<hive>'CONF'                               { return '<hive>CONF'; }
<hive>'CREATE'                             { determineCase(yytext); return '<hive>CREATE'; }
<hive>'CROSS'                              { return '<hive>CROSS'; }
<hive>'CUBE'                               { return '<hive>CUBE'; }
<hive>'CURRENT'                            { return '<hive>CURRENT'; }
<hive>'DATE'                               { return '<hive>DATE'; }
<hive>'DELETE'                             { determineCase(yytext); return '<hive>DELETE'; }
<hive>'DESCRIBE'                           { determineCase(yytext); return '<hive>DESCRIBE'; }
<hive>'EXTENDED'                           { return '<hive>EXTENDED'; }
<hive>'EXTERNAL'                           { return '<hive>EXTERNAL'; }
<hive>'FOR'                                { return '<hive>FOR'; }
<hive>'FUNCTION'                           { return '<hive>FUNCTION'; }
<hive>'GRANT'                              { return '<hive>GRANT'; }
<hive>'GROUPING'                           { return '<hive>GROUPING'; }
<hive>'IMPORT'                             { determineCase(yytext); return '<hive>IMPORT'; }
<hive>'INSERT'                             { determineCase(yytext); return '<hive>INSERT'; }
<hive>'LATERAL'                            { return '<hive>LATERAL'; }
<hive>'LOCAL'                              { return '<hive>LOCAL'; }
<hive>'MACRO'                              { return '<hive>MACRO'; }
<hive>'MAP'                                { return '<hive>MAP'; }
<hive>'NONE'                               { return '<hive>NONE'; }
<hive>'OF'                                 { return '<hive>OF'; }
<hive>'OUT'                                { return '<hive>OUT'; }
<hive>'REVOKE'                             { return '<hive>REVOKE'; }
<hive>'ROLLUP'                             { return '<hive>ROLLUP'; }
<hive>'TABLE'                              { return '<hive>TABLE'; }
<hive>'USER'                               { return '<hive>USER'; }
<hive>'USING'                              { return '<hive>USING'; }

// Non-reserved Keywords
<hive>'ADD'                                { return '<hive>ADD'; }
<hive>'ADMIN'                              { return '<hive>ADMIN'; }
<hive>'AFTER'                              { return '<hive>AFTER'; }
<hive>'ANALYZE'                            { determineCase(yytext); return '<hive>ANALYZE'; }
<hive>'ARCHIVE'                            { return '<hive>ARCHIVE'; }
<hive>'ASC'                                { return '<hive>ASC'; }
<hive>'AVRO'                               { return '<hive>AVRO'; }
<hive>'BUCKET'                             { return '<hive>BUCKET'; }
<hive>'BUCKETS'                            { return '<hive>BUCKETS'; }
<hive>'CACHE'                              { return '<hive>CACHE'; }
<hive>'CASCADE'                            { return '<hive>CASCADE'; }
<hive>'CHANGE'                             { return '<hive>CHANGE'; }
<hive>'CLUSTER'                            { return '<hive>CLUSTER'; }
<hive>'CLUSTERED'                          { return '<hive>CLUSTERED'; }
<hive>'COLLECTION'                         { return '<hive>COLLECTION'; }
<hive>'COLUMNS'                            { return '<hive>COLUMNS'; }
<hive>'COMMENT'                            { return '<hive>COMMENT'; }
<hive>'COMPACT'                            { return '<hive>COMPACT'; }
<hive>'COMPACTIONS'                        { return '<hive>COMPACTIONS'; }
<hive>'COMPUTE'                            { return '<hive>COMPUTE'; }
<hive>'CONCATENATE'                        { return '<hive>CONCATENATE'; }
<hive>'DATA'                               { return '<hive>DATA'; }
<hive>'DATABASES'                          { return '<hive>DATABASES'; }
<hive>'DEFERRED'                           { return '<hive>DEFERRED'; }
<hive>'DEFINED'                            { return '<hive>DEFINED'; }
<hive>'DELIMITED'                          { return '<hive>DELIMITED'; }
<hive>'DEPENDENCY'                         { return '<hive>DEPENDENCY'; }
<hive>'DESC'                               { return '<hive>DESC'; }
<hive>'DIRECTORY'                          { this.begin('hdfs'); return '<hive>DIRECTORY'; }
<hive>'DISABLE'                            { return '<hive>DISABLE'; }
<hive>'DISTRIBUTE'                         { return '<hive>DISTRIBUTE'; }
<hive>'ESCAPED'                            { return '<hive>ESCAPED'; }
<hive>'ENABLE'                             { return '<hive>ENABLE'; }
<hive>'EXCHANGE'                           { return '<hive>EXCHANGE'; }
<hive>'EXPLAIN'                            { determineCase(yytext); return '<hive>EXPLAIN'; }
<hive>'EXPORT'                             { determineCase(yytext); return '<hive>EXPORT'; }
<hive>'FIELDS'                             { return '<hive>FIELDS'; }
<hive>'FILE'                               { return '<hive>FILE'; }
<hive>'FILEFORMAT'                         { return '<hive>FILEFORMAT'; }
<hive>'FIRST'                              { return '<hive>FIRST'; }
<hive>'FORMAT'                             { return '<hive>FORMAT'; }
<hive>'FORMATTED'                          { return '<hive>FORMATTED'; }
<hive>'FUNCTION'                           { return '<hive>FUNCTION'; }
<hive>'FUNCTIONS'                          { return '<hive>FUNCTIONS'; }
<hive>'IDXPROPERTIES'                      { return '<hive>IDXPROPERTIES'; }
<hive>'INDEX'                              { return '<hive>INDEX'; }
<hive>'INDEXES'                            { return '<hive>INDEXES'; }
<hive>'INPATH'                             { this.begin('hdfs'); return '<hive>INPATH'; }
<hive>'INPUTFORMAT'                        { return '<hive>INPUTFORMAT'; }
<hive>'ITEMS'                              { return '<hive>ITEMS'; }
<hive>'JAR'                                { return '<hive>JAR'; }
<hive>'KEYS'                               { return '<hive>KEYS'; }
<hive>'LINES'                              { return '<hive>LINES'; }
<hive>'LOAD'                               { determineCase(yytext); return '<hive>LOAD'; }
<hive>'LOCATION'                           { this.begin('hdfs'); return '<hive>LOCATION'; }
<hive>'LOCK'                               { return '<hive>LOCK'; }
<hive>'LOCKS'                              { return '<hive>LOCKS'; }
<hive>'METADATA'                           { return '<hive>METADATA'; }
<hive>'MSCK'                               { return '<hive>MSCK'; }
<hive>'NOSCAN'                             { return '<hive>NOSCAN'; }
<hive>'NO_DROP'                            { return '<hive>NO_DROP'; }
<hive>'OFFLINE'                            { return '<hive>OFFLINE'; }
<hive>'ORC'                                { return '<hive>ORC'; }
<hive>'OUTPUTFORMAT'                       { return '<hive>OUTPUTFORMAT'; }
<hive>'OVERWRITE'                          { return '<hive>OVERWRITE'; }
<hive>OVERWRITE\s+DIRECTORY                { this.begin('hdfs'); return '<hive>OVERWRITE_DIRECTORY'; }
<hive>'PARQUET'                            { return '<hive>PARQUET'; }
<hive>'PARTITIONED'                        { return '<hive>PARTITIONED'; }
<hive>'PARTITIONS'                         { return '<hive>PARTITIONS'; }
<hive>'PRIVILEGES'                         { return '<hive>PRIVILEGES'; }
<hive>'PURGE'                              { return '<hive>PURGE'; }
<hive>'RCFILE'                             { return '<hive>RCFILE'; }
<hive>'REBUILD'                            { return '<hive>REBUILD'; }
<hive>'RELOAD'                             { determineCase(yytext); return '<hive>RELOAD'; }
<hive>'REPAIR'                             { return '<hive>REPAIR'; }
<hive>'REPLICATION'                        { return '<hive>REPLICATION'; }
<hive>'RECOVER'                            { return '<hive>RECOVER'; }
<hive>'RENAME'                             { return '<hive>RENAME'; }
<hive>'REPLACE'                            { return '<hive>REPLACE'; }
<hive>'RESTRICT'                           { return '<hive>RESTRICT'; }
<hive>'ROLE'                               { return '<hive>ROLE'; }
<hive>'ROLES'                              { return '<hive>ROLES'; }
<hive>'SCHEMA'                             { return '<hive>SCHEMA'; }
<hive>'SCHEMAS'                            { return '<hive>SCHEMAS'; }
<hive>'SEQUENCEFILE'                       { return '<hive>SEQUENCEFILE'; }
<hive>'SERDE'                              { return '<hive>SERDE'; }
<hive>'SERDEPROPERTIES'                    { return '<hive>SERDEPROPERTIES'; }
<hive>'SETS'                               { return '<hive>SETS'; }
<hive>'SHOW'                               { determineCase(yytext); return '<hive>SHOW'; }
<hive>'SHOW_DATABASE'                      { return '<hive>SHOW_DATABASE'; }
<hive>'SKEWED'                             { return '<hive>SKEWED'; }
<hive>'SKEWED LOCATION'                    { return '<hive>SKEWED_LOCATION'; } // Hack to prevent hdfs lexer state
<hive>'SORT'                               { return '<hive>SORT'; }
<hive>'SORTED'                             { return '<hive>SORTED'; }
<hive>'STATISTICS'                         { return '<hive>STATISTICS'; }
<hive>'STORED'                             { return '<hive>STORED'; }
<hive>STORED\s+AS\s+DIRECTORIES            { return '<hive>STORED_AS_DIRECTORIES'; }
<hive>'STRING'                             { return '<hive>STRING'; }
<hive>'STRUCT'                             { return '<hive>STRUCT'; }
<hive>'TABLES'                             { return '<hive>TABLES'; }
<hive>'TABLESAMPLE'                        { return '<hive>TABLESAMPLE'; }
<hive>'TBLPROPERTIES'                      { return '<hive>TBLPROPERTIES'; }
<hive>'TEMPORARY'                          { return '<hive>TEMPORARY'; }
<hive>'TERMINATED'                         { return '<hive>TERMINATED'; }
<hive>'TEXTFILE'                           { return '<hive>TEXTFILE'; }
<hive>'TINYINT'                            { return '<hive>TINYINT'; }
<hive>'TOUCH'                              { return '<hive>TOUCH'; }
<hive>'TRANSACTIONS'                       { return '<hive>TRANSACTIONS'; }
<hive>'UNARCHIVE'                          { return '<hive>UNARCHIVE'; }
<hive>'UNIONTYPE'                          { return '<hive>UNIONTYPE'; }
<hive>'USE'                                { determineCase(yytext); return '<hive>USE'; }
<hive>'VIEW'                               { return '<hive>VIEW'; }
<hive>'WINDOW'                             { return '<hive>WINDOW'; }

<hive>'.'                                  { return '<hive>.'; }
<hive>'['                                  { return '<hive>['; }
<hive>']'                                  { return '<hive>]'; }

// Reserved Keywords
<impala>'ADD'                              { return '<impala>ADD'; }
<impala>'AGGREGATE'                        { return '<impala>AGGREGATE'; }
<impala>'AVRO'                             { return '<impala>AVRO'; }
<impala>'CACHED'                           { return '<impala>CACHED'; }
<impala>'CHANGE'                           { return '<impala>CHANGE'; }
<impala>'CLOSE_FN'                         { return '<impala>CLOSE_FN'; }
<impala>'COLUMN'                           { return '<impala>COLUMN'; }
<impala>'COLUMNS'                          { return '<impala>COLUMNS'; }
<impala>'COMMENT'                          { return '<impala>COMMENT'; }
<impala>'COMPUTE'                          { determineCase(yytext); return '<impala>COMPUTE'; }
<impala>'CREATE'                           { determineCase(yytext); return '<impala>CREATE'; }
<impala>'DATA'                             { return '<impala>DATA'; }
<impala>'DATABASES'                        { return '<impala>DATABASES'; }
<impala>'DELIMITED'                        { return '<impala>DELIMITED'; }
<impala>'DESCRIBE'                         { determineCase(yytext); return '<impala>DESCRIBE'; }
<impala>'ESCAPED'                          { return '<impala>ESCAPED'; }
<impala>'EXPLAIN'                          { determineCase(yytext); return '<impala>EXPLAIN'; }
<impala>'EXTERNAL'                         { return '<impala>EXTERNAL'; }
<impala>'EXTENDED'                         { return '<impala>EXTENDED'; }
<impala>'FIELDS'                           { return '<impala>FIELDS'; }
<impala>'FILEFORMAT'                       { return '<impala>FILEFORMAT'; }
<impala>'FINALIZE_FN'                      { return '<impala>FINALIZE_FN'; }
<impala>'FIRST'                            { return '<impala>FIRST'; }
<impala>'FORMAT'                           { return '<impala>FORMAT'; }
<impala>'FORMATTED'                        { return '<impala>FORMATTED'; }
<impala>'FUNCTION'                         { return '<impala>FUNCTION'; }
<impala>'FUNCTIONS'                        { return '<impala>FUNCTIONS'; }
<impala>'GROUP'                            { return '<impala>GROUP'; }
<impala>'HASH'                             { return '<impala>HASH'; }
<impala>'INCREMENTAL'                      { return '<impala>INCREMENTAL'; }
<impala>'INSERT'                           { determineCase(yytext); return '<impala>INSERT'; }
<impala>'INTERVAL'                         { return '<impala>INTERVAL'; }
<impala>'INIT_FN'                          { return '<impala>INIT_FN'; }
<impala>'INVALIDATE'                       { determineCase(yytext); return '<impala>INVALIDATE'; }
<impala>'INPATH'                           { this.begin('hdfs'); return '<impala>INPATH'; }
<impala>'KEY'                              { return '<impala>KEY'; }
<impala>'KUDU'                             { return '<impala>KUDU'; }
<impala>'LAST'                             { return '<impala>LAST'; }
<impala>LIKE\s+PARQUET                     { this.begin('hdfs'); return '<impala>LIKE_PARQUET'; }
<impala>'LIMIT'                            { return '<impala>LIMIT'; }
<impala>'LINES'                            { return '<impala>LINES'; }
<impala>'LOAD'                             { determineCase(yytext); return '<impala>LOAD'; }
<impala>'LOCATION'                         { this.begin('hdfs'); return '<impala>LOCATION'; }
<impala>'MERGE_FN'                         { return '<impala>MERGE_FN'; }
<impala>'METADATA'                         { return '<impala>METADATA'; }
<impala>'NULLS'                            { return '<impala>NULLS'; }
<impala>'OFFSET'                           { return '<impala>OFFSET'; }
<impala>'OVERWRITE'                        { return '<impala>OVERWRITE'; }
<impala>'PARQUET'                          { return '<impala>PARQUET'; }
<impala>'PARTITIONED'                      { return '<impala>PARTITIONED'; }
<impala>'PARTITIONS'                       { return '<impala>PARTITIONS'; }
<impala>'PREPARE_FN'                       { return '<impala>PREPARE_FN'; }
<impala>'PRIMARY'                          { return '<impala>PRIMARY'; }
<impala>'RCFILE'                           { return '<impala>RCFILE'; }
<impala>'REAL'                             { return '<impala>REAL'; }
<impala>'REFRESH'                          { determineCase(yytext); return '<impala>REFRESH'; }
<impala>'RENAME'                           { return '<impala>RENAME'; }
<impala>'REPLACE'                          { return '<impala>REPLACE'; }
<impala>'RETURNS'                          { return '<impala>RETURNS'; }
<impala>'REVOKE'                           { return '<impala>REVOKE'; }
<impala>'SEQUENCEFILE'                     { return '<impala>SEQUENCEFILE'; }
<impala>'SERDEPROPERTIES'                  { return '<impala>SERDEPROPERTIES'; }
<impala>'SCHEMAS'                          { return '<impala>SCHEMAS'; }
<impala>'SERIALIZE_FN'                     { return '<impala>SERIALIZE_FN'; }
<impala>'SERVER'                           { return '<impala>SERVER'; }
<impala>'STATS'                            { return '<impala>STATS'; }
<impala>'STORED'                           { return '<impala>STORED'; }
<impala>'STRAIGHT_JOIN'                    { return '<impala>STRAIGHT_JOIN'; }
<impala>'SYMBOL'                           { return '<impala>SYMBOL'; }
<impala>'TABLE'                            { return '<impala>TABLE'; }
<impala>'TABLES'                           { return '<impala>TABLES'; }
<impala>'TBLPROPERTIES'                    { return '<impala>TBLPROPERTIES'; }
<impala>'TERMINATED'                       { return '<impala>TERMINATED'; }
<impala>'TEXTFILE'                         { return '<impala>TEXTFILE'; }
<impala>'UNCACHED'                         { return '<impala>UNCACHED'; }
<impala>'UPDATE_FN'                        { return '<impala>UPDATE_FN'; }
<impala>'URI'                              { return '<impala>URI'; }
<impala>'USING'                            { return '<impala>USING'; }
<impala>PARTITION\s+VALUE\s                { return '<impala>PARTITION_VALUE'; }

// Non-reserved Keywords
<impala>'ANALYTIC'                         { return '<impala>ANALYTIC'; }
<impala>'ANTI'                             { return '<impala>ANTI'; }
<impala>'BLOCK_SIZE'                       { return '<impala>BLOCK_SIZE'; }
<impala>'COMPRESSION'                      { return '<impala>COMPRESSION'; }
<impala>'CURRENT'                          { return '<impala>CURRENT'; }
<impala>'DEFAULT'                          { return '<impala>DEFAULT'; }
<impala>'ENCODING'                         { return '<impala>ENCODING'; }
<impala>'GRANT'                            { return '<impala>GRANT'; }
<impala>'ROLE'                             { return '<impala>ROLE'; }
<impala>'ROLES'                            { return '<impala>ROLES'; }
<impala>\[BROADCAST\]                      { return '<impala>BROADCAST'; }
<impala>\[NOSHUFFLE\]                      { return '<impala>NOSHUFFLE'; }
<impala>\[SHUFFLE\]                        { return '<impala>SHUFFLE'; }

<impala>'...'                              { return '<impala>...'; }
<impala>'.'                                { return '<impala>.'; }
<impala>'['                                { return '<impala>['; }
<impala>']'                                { return '<impala>]'; }

<between>'AND'                             { this.popState(); return 'BETWEEN_AND'; }

// Reserved Keywords
'ALL'                                      { return 'ALL'; }
'ALTER'                                    { determineCase(yytext); return 'ALTER'; }
'AND'                                      { return 'AND'; }
'AS'                                       { return 'AS'; }
'ASC'                                      { return 'ASC'; }
'BETWEEN'                                  { this.begin('between'); return 'BETWEEN'; }
'BIGINT'                                   { return 'BIGINT'; }
'BOOLEAN'                                  { return 'BOOLEAN'; }
'BY'                                       { return 'BY'; }
'CASE'                                     { return 'CASE'; }
'CHAR'                                     { return 'CHAR'; }
'CREATE'                                   { determineCase(yytext); return 'CREATE'; }
'CURRENT'                                  { return 'CURRENT'; }
'DATABASE'                                 { return 'DATABASE'; }
'DECIMAL'                                  { return 'DECIMAL'; }
'DISTINCT'                                 { return 'DISTINCT'; }
'DOUBLE'                                   { return 'DOUBLE'; }
'DESC'                                     { return 'DESC'; }
'DROP'                                     { determineCase(yytext); return 'DROP'; }
'ELSE'                                     { return 'ELSE'; }
'END'                                      { return 'END'; }
'EXISTS'                                   { parser.yy.correlatedSubQuery = true; return 'EXISTS'; }
'FALSE'                                    { return 'FALSE'; }
'FLOAT'                                    { return 'FLOAT'; }
'FOLLOWING'                                { return 'FOLLOWING'; }
'FROM'                                     { determineCase(yytext); return 'FROM'; }
'FULL'                                     { return 'FULL'; }
'GROUP'                                    { return 'GROUP'; }
'HAVING'                                   { return 'HAVING'; }
'IF'                                       { return 'IF'; }
'IN'                                       { return 'IN'; }
'INNER'                                    { return 'INNER'; }
'INSERT'                                   { return 'INSERT'; }
'INT'                                      { return 'INT'; }
'INTO'                                     { return 'INTO'; }
'IS'                                       { return 'IS'; }
'JOIN'                                     { return 'JOIN'; }
'LEFT'                                     { return 'LEFT'; }
'LIKE'                                     { return 'LIKE'; }
'LIMIT'                                    { return 'LIMIT'; }
'NOT'                                      { return 'NOT'; }
'NULL'                                     { return 'NULL'; }
'ON'                                       { return 'ON'; }
'OPTION'                                   { return 'OPTION'; }
'OR'                                       { return 'OR'; }
'ORDER'                                    { return 'ORDER'; }
'OUTER'                                    { return 'OUTER'; }
'PARTITION'                                { return 'PARTITION'; }
'PRECEDING'                                { return 'PRECEDING'; }
'RANGE'                                    { return 'RANGE'; }
'REGEXP'                                   { return 'REGEXP'; }
'RIGHT'                                    { return 'RIGHT'; }
'RLIKE'                                    { return 'RLIKE'; }
'ROW'                                      { return 'ROW'; }
'ROWS'                                     { return 'ROWS'; }
'SCHEMA'                                   { return 'SCHEMA'; }
'SELECT'                                   { determineCase(yytext); return 'SELECT'; }
'SEMI'                                     { return 'SEMI'; }
'SET'                                      { determineCase(yytext); return 'SET'; }
'SHOW'                                     { determineCase(yytext); return 'SHOW'; }
'SMALLINT'                                 { return 'SMALLINT'; }
'STRING'                                   { return 'STRING'; }
'TABLE'                                    { return 'TABLE'; }
'THEN'                                     { return 'THEN'; }
'TIMESTAMP'                                { return 'TIMESTAMP'; }
'TINYINT'                                  { return 'TINYINT'; }
'TO'                                       { return 'TO'; }
'TRUE'                                     { return 'TRUE'; }
'TRUNCATE'                                 { determineCase(yytext); return 'TRUNCATE'; }
'UNBOUNDED'                                { return 'UNBOUNDED'; }
'UPDATE'                                   { determineCase(yytext); return 'UPDATE'; }
'USE'                                      { determineCase(yytext); return 'USE'; }
'UNION'                                    { return 'UNION'; }
'VIEW'                                     { return 'VIEW'; }
'VARCHAR'                                  { return 'VARCHAR'; } // Not in Impala
'VALUES'                                   { return 'VALUES'; }
'WHEN'                                     { return 'WHEN'; }
'WHERE'                                    { return 'WHERE'; }
'WITH'                                     { determineCase(yytext); return 'WITH'; }

// Non-reserved Keywords
'OVER'                                     { return 'OVER'; }
'ROLE'                                     { return 'ROLE'; }

// --- UDFs ---
'AVG'                                      { addFunctionLocation(yylloc, 'avg'); return 'AVG'; }
'CAST'                                     { addFunctionLocation(yylloc, 'cast'); return 'CAST'; }
'COUNT'                                    { addFunctionLocation(yylloc, 'count'); return 'COUNT'; }
'MAX'                                      { addFunctionLocation(yylloc, 'max'); return 'MAX'; }
'MIN'                                      { addFunctionLocation(yylloc, 'min'); return 'MIN'; }
'STDDEV_POP'                               { addFunctionLocation(yylloc, 'stddev_pop'); return 'STDDEV_POP'; }
'STDDEV_SAMP'                              { addFunctionLocation(yylloc, 'stddev_samp'); return 'STDDEV_SAMP'; }
'SUM'                                      { addFunctionLocation(yylloc, 'sum'); return 'SUM'; }
'VARIANCE'                                 { addFunctionLocation(yylloc, 'variance'); return 'VARIANCE'; }
'VAR_POP'                                  { addFunctionLocation(yylloc, 'var_pop'); return 'VAR_POP'; }
'VAR_SAMP'                                 { addFunctionLocation(yylloc, 'var_samp'); return 'VAR_SAMP'; }
<hive>'COLLECT_SET'                        { addFunctionLocation(yylloc, 'collect_set'); return '<hive>COLLECT_SET'; }
<hive>'COLLECT_LIST'                       { addFunctionLocation(yylloc, 'collect_list'); return '<hive>COLLECT_LIST'; }
<hive>'CORR'                               { addFunctionLocation(yylloc, 'corr'); return '<hive>CORR'; }
<hive>'COVAR_POP'                          { addFunctionLocation(yylloc, 'covar_pop'); return '<hive>COVAR_POP'; }
<hive>'COVAR_SAMP'                         { addFunctionLocation(yylloc, 'covar_samp'); return '<hive>COVAR_SAMP'; }
<hive>'HISTOGRAM_NUMERIC'                  { addFunctionLocation(yylloc, 'histogram_numeric'); return '<hive>HISTOGRAM_NUMERIC'; }
<hive>'NTILE'                              { addFunctionLocation(yylloc, 'ntile'); return '<hive>NTILE'; }
<hive>'PERCENTILE'                         { addFunctionLocation(yylloc, 'percentile'); return '<hive>PERCENTILE'; }
<hive>'PERCENTILE_APPROX'                  { addFunctionLocation(yylloc, 'percentile_approx'); return '<hive>PERCENTILE_APPROX'; }
<impala>'APPX_MEDIAN'                      { addFunctionLocation(yylloc, 'appx_median'); return '<impala>APPX_MEDIAN'; }
<impala>'EXTRACT'                          { addFunctionLocation(yylloc, 'extract'); return '<impala>EXTRACT'; }
<impala>'GROUP_CONCAT'                     { addFunctionLocation(yylloc, 'group_concat'); return '<impala>GROUP_CONCAT'; }
<impala>'STDDEV'                           { addFunctionLocation(yylloc, 'stddev'); return '<impala>STDDEV'; }
<impala>'VARIANCE_POP'                     { addFunctionLocation(yylloc, 'variance_pop'); return '<impala>VARIANCE_POP'; }
<impala>'VARIANCE_SAMP'                    { addFunctionLocation(yylloc, 'variance_samp'); return '<impala>VARIANCE_SAMP'; }

// Analytical functions
'DENSE_RANK'                               { addFunctionLocation(yylloc, 'dense_rank'); return 'ANALYTIC'; }
'FIRST_VALUE'                              { addFunctionLocation(yylloc, 'first_value'); return 'ANALYTIC'; }
'LAG'                                      { addFunctionLocation(yylloc, 'lag'); return 'ANALYTIC'; }
'LAST_VALUE'                               { addFunctionLocation(yylloc, 'last_value'); return 'ANALYTIC'; }
'LEAD'                                     { addFunctionLocation(yylloc, 'lead'); return 'ANALYTIC'; }
'RANK'                                     { addFunctionLocation(yylloc, 'rank'); return 'ANALYTIC'; }
'ROW_NUMBER'                               { addFunctionLocation(yylloc, 'row_number'); return 'ANALYTIC'; }
<hive>'CUME_DIST'                          { addFunctionLocation(yylloc, 'cume_dist'); return 'ANALYTIC'; }
<hive>'PERCENT_RANK'                       { addFunctionLocation(yylloc, 'percent_rank'); return 'ANALYTIC'; }

[0-9]+                                     { return 'UNSIGNED_INTEGER'; }
[0-9]+(?:[YSL]|BD)?                        { return 'UNSIGNED_INTEGER'; }
[0-9]+E                                    { return 'UNSIGNED_INTEGER_E'; }
[A-Za-z0-9_]+                              { return 'REGULAR_IDENTIFIER'; }

<hdfs>'\u2020'                             { parser.yy.cursorFound = true; return 'CURSOR'; }
<hdfs>'\u2021'                             { parser.yy.cursorFound = true; return 'PARTIAL_CURSOR'; }
<hdfs>\s+[']                               { return 'HDFS_START_QUOTE'; }
<hdfs>[^'\u2020\u2021]+                    { addHdfsLocation(yylloc, yytext); return 'HDFS_PATH'; }
<hdfs>[']                                  { this.popState(); return 'HDFS_END_QUOTE'; }
<hdfs><<EOF>>                              { return 'EOF'; }

'&&'                                       { return 'AND'; }
'||'                                       { return 'OR'; }

'='                                        { return '='; }
'<'                                        { return '<'; }
'>'                                        { return '>'; }
'!='                                       { return 'COMPARISON_OPERATOR'; }
'<='                                       { return 'COMPARISON_OPERATOR'; }
'>='                                       { return 'COMPARISON_OPERATOR'; }
'<>'                                       { return 'COMPARISON_OPERATOR'; }
'<=>'                                      { return 'COMPARISON_OPERATOR'; }

'-'                                        { return '-'; }
'*'                                        { return '*'; }
'+'                                        { return 'ARITHMETIC_OPERATOR'; }
'/'                                        { return 'ARITHMETIC_OPERATOR'; }
'%'                                        { return 'ARITHMETIC_OPERATOR'; }
'|'                                        { return 'ARITHMETIC_OPERATOR'; }
'^'                                        { return 'ARITHMETIC_OPERATOR'; }
'&'                                        { return 'ARITHMETIC_OPERATOR'; }

'-'                                        { return '-'; }
'*'                                        { return '*'; }
'+'                                        { return 'ARITHMETIC_OPERATOR'; }
'/'                                        { return 'ARITHMETIC_OPERATOR'; }
'%'                                        { return 'ARITHMETIC_OPERATOR'; }
'|'                                        { return 'ARITHMETIC_OPERATOR'; }
'^'                                        { return 'ARITHMETIC_OPERATOR'; }
'&'                                        { return 'ARITHMETIC_OPERATOR'; }

','                                        { return ','; }
'.'                                        { return '.'; }
':'                                        { return ':'; }
';'                                        { return ';'; }
'~'                                        { return '~'; }
'!'                                        { return '!'; }

'('                                        { return '('; }
')'                                        { return ')'; }
'['                                        { return '['; }
']'                                        { return ']'; }

\$\{[^}]*\}                                { return 'VARIABLE_REFERENCE'; }

\`                                         { this.begin('backtickedValue'); return 'BACKTICK'; }
<backtickedValue>[^`]+                     {
                                             if (parser.handleQuotedValueWithCursor(this, yytext, yylloc, '`')) {
                                               return 'PARTIAL_VALUE';
                                             }
                                             return 'VALUE';
                                           }
<backtickedValue>\`                        { this.popState(); return 'BACKTICK'; }

\'                                         { this.begin('singleQuotedValue'); return 'SINGLE_QUOTE'; }
<singleQuotedValue>(?:\\[']|[^'])+         {
                                             if (parser.handleQuotedValueWithCursor(this, yytext, yylloc, '\'')) {
                                               return 'PARTIAL_VALUE';
                                             }
                                             return 'VALUE';
                                           }
<singleQuotedValue>\'                      { this.popState(); return 'SINGLE_QUOTE'; }

\"                                         { this.begin('doubleQuotedValue'); return 'DOUBLE_QUOTE'; }
<doubleQuotedValue>(?:\\["]|[^"])+         {
                                             if (parser.handleQuotedValueWithCursor(this, yytext, yylloc, '"')) {
                                               return 'PARTIAL_VALUE';
                                             }
                                             return 'VALUE';
                                           }
<doubleQuotedValue>\"                      { this.popState(); return 'DOUBLE_QUOTE'; }

<<EOF>>                                    { return 'EOF'; }

.                                          { /* To prevent console logging of unknown chars */ }
