## -*- coding: utf-8 -*-
## Licensed to Cloudera, Inc. under one
## or more contributor license agreements.  See the NOTICE file
## distributed with this work for additional information
## regarding copyright ownership.  Cloudera, Inc. licenses this file
## to you under the Apache License, Version 2.0 (the
## "License"); you may not use this file except in compliance
## with the License.  You may obtain a copy of the License at
##
##     http://www.apache.org/licenses/LICENSE-2.0
##
## Unless required by applicable law or agreed to in writing, software
## distributed under the License is distributed on an "AS IS" BASIS,
## WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
## See the License for the specific language governing permissions and
## limitations under the License.
<%!
  from django.utils.translation import ugettext as _
%>


<%namespace name="workflow" file="../editor2/common_workflow.mako" />
<%namespace name="utils" file="../utils.inc.mako" />
<%namespace name="dashboard" file="/common_dashboard.mako" />

<link rel="stylesheet" href="${ static('oozie/css/common-editor.css') }">
<link rel="stylesheet" href="${ static('oozie/css/workflow-editor.css') }">
<link rel="stylesheet" href="${ static('desktop/ext/css/bootstrap-editable.css') }">

${ dashboard.import_layout() }

<script src="${ static('desktop/ext/js/bootstrap-editable.min.js') }"></script>
<script src="${ static('desktop/js/ko.editable.js') }"></script>
<script src="${ static('oozie/js/workflow-editor.ko.js') }" type="text/javascript" charset="utf-8"></script>
<script src="${ static('oozie/js/workflow-editor.utils.js') }" type="text/javascript" charset="utf-8"></script>
<script src="${ static('desktop/ext/js/jquery/plugins/jquery.curvedarrow.js') }" type="text/javascript" charset="utf-8"></script>

${ workflow.render() }

<div id="loaded${doc_uuid}graph">
  ${ workflow_graph | n,unicode }
</div>

<script type="text/javascript">

  ${ utils.slaGlobal() }

  % if layout_json != '':
  var viewModel = new WorkflowEditorViewModel(${ layout_json | n,unicode }, ${ workflow_json | n,unicode }, ${ credentials_json | n,unicode }, ${ workflow_properties_json | n,unicode }, ${ subworkflows_json | n,unicode }, ${ can_edit_json | n,unicode });
  ko.applyBindings(viewModel, $("#${graph_element_id}")[0]);
  viewModel.isViewer = ko.observable(true);
  viewModel.isEmbeddable = ko.observable(true);
  viewModel.init();
  fullLayout(viewModel);

  var globalFilechooserOptions = {
    skipInitialPathIfEmpty: true,
    showExtraHome: true,
    uploadFile: true,
    createFolder: true,
    extraHomeProperties: {
      label: '${ _('Workspace') }',
      icon: 'fa-folder-open',
      path: viewModel.workflow.properties.deployment_dir()
    },
    deploymentDir: viewModel.workflow.properties.deployment_dir()
  }

  function refreshView() {
      $.getJSON("${ oozie_workflow.get_absolute_url(format='json') }", function (data) {

        if (data.actions){
          % if layout_json != '':
          ko.utils.arrayForEach(data.actions, function(action) {
            var _w, actionId = action.id.substr(action.id.length - 4);
            if (actionId === '@End'){
              _w = viewModel.getWidgetById('33430f0f-ebfa-c3ec-f237-3e77efa03d0a');
            }
            else {
              _w = viewModel.getWidgetById($("[id^=wdg_" + actionId + "]").attr("id").substr(4));
            }
            if (_w != null) {
              if (['SUCCEEDED', 'OK', 'DONE'].indexOf(action.status) > -1) {
                _w.status("success");
                _w.progress(100);
              }
              else if (['RUNNING', 'READY', 'PREP', 'WAITING', 'SUSPENDED', 'PREPSUSPENDED', 'PREPPAUSED', 'PAUSED', 'SUBMITTED', 'SUSPENDEDWITHERROR', 'PAUSEDWITHERROR'].indexOf(action.status) > -1) {
                _w.status("running");
                _w.progress(50);
              }
              else {
                _w.status("failed");
                _w.progress(100);
              }
              _w.actionURL(action.url);
              _w.logsURL(action.log);
              _w.externalIdUrl(action.externalIdUrl);
              _w.externalId(action.id);
            }
          });
          %endif
        }
        if (data.status != "RUNNING" && data.status != "PREP"){
          return;
        }
        window.setTimeout(refreshView, 1000);
      });
    }

  %endif

  $(document).ready(function() {
    % if layout_json != '':
    drawArrows();
    refreshView();
    %endif
  });
</script>
