/*
 * SPDX-FileCopyrightText: 2022 The HedgeDoc developers (see AUTHORS file)
 *
 * SPDX-License-Identifier: AGPL-3.0-only
 */
import { allAppExtensions } from '../../../../extensions/all-app-extensions'
import type { ReactElement } from 'react'
import React, { Fragment, useMemo } from 'react'

/**
 * Generator react elements for components that are generated by the used {@link AppExtension app extensions}.
 */
export const useComponentsFromAppExtensions = (): ReactElement => {
  return useMemo(() => {
    return (
      <Fragment key={'app-extensions'}>
        {allAppExtensions.map((extension, index) =>
          React.createElement(extension.buildEditorExtensionComponent(), { key: index })
        )}
      </Fragment>
    )
  }, [])
}
