/*
 * SPDX-FileCopyrightText: 2023 The HedgeDoc developers (see AUTHORS file)
 *
 * SPDX-License-Identifier: AGPL-3.0-only
 */
import { concatCssClasses } from '../../../utils/concat-css-classes'
import { LogoSize } from './logo-size'
import styles from './styles.module.scss'
import React from 'react'

interface HedgeDocLogoVerticalProps {
  autoTextColor?: boolean
  size?: LogoSize | number
}

export const HedgeDocLogoVertical: React.FC<HedgeDocLogoVerticalProps> = ({
  autoTextColor,
  size = LogoSize.MEDIUM
}) => {
  return (
    <svg
      clipRule='evenodd'
      fillRule='evenodd'
      height={`${size}px`}
      strokeLinejoin='round'
      strokeMiterlimit='2'
      viewBox='0 0 1510 1000'
      width='auto'
      xmlns='http://www.w3.org/2000/svg'>
      <linearGradient
        id='a'
        gradientTransform='matrix(200 -420 420 200 660 1340)'
        gradientUnits='userSpaceOnUse'
        x1='0'
        x2='1'
        y1='0'
        y2='0'>
        <stop offset='0' stopColor='#fdd49a' />
        <stop offset='1' stopColor='#dca055' />
      </linearGradient>
      <g fillRule='nonzero'>
        <path
          className={concatCssClasses({
            [styles['auto-text']]: autoTextColor
          })}
          d='m526.55078 695.48438v94.20312c-6.66549-7.06493-14.67792-12.58654-24.03125-16.56836-9.35749-3.98182-19.51014-5.97461-30.45703-5.97461-14.43358 0-27.34789 3.35659-38.74414 10.07617-11.39625 6.71959-20.35539 15.92332-26.87109 27.61914-6.51987 11.69583-9.77735 25.00684-9.77735 39.93555 0 14.93287 3.25748 28.24389 9.77735 39.93555 6.5157 11.69582 15.47484 20.90346 26.87109 27.62304 11.39625 6.71543 24.31056 10.07227 38.74414 10.07227 11.24646 0 21.64813-2.11449 31.20117-6.3418 9.55305-4.23146 17.66212-10.02587 24.33594-17.39453l1.34375 20.75391h22.24414v-223.93945zm-526.55078.00195v223.93945h26.128906v-98.53125h127.642574v98.53125h26.1211v-223.93945h-26.1211v101.52148h-127.642574v-101.52148zm970.24609.29687v223.93946h60.91011c43.9915 0 77.78-9.80258 101.3672-29.41211 23.5872-19.60538 35.3828-47.2249 35.3828-82.85743 0-35.5285-11.7956-63.02267-35.3828-82.48242-23.5872-19.45559-57.3757-29.1875-101.3672-29.1875zm26.125 23.88672h34.78511c35.4287 0 62.6012 7.63976 81.5118 22.91797 18.9063 15.27821 28.3652 36.90095 28.3652 64.86523 0 28.06831-9.4589 49.8164-28.3652 65.24024-18.9106 15.428-46.0831 23.14258-81.5118 23.14258h-34.78511zm-702.11718 47.47656c-14.73316 0-27.91466 3.33256-39.56055 9.99805-11.64589 6.67382-20.80521 15.80664-27.4707 27.39844-6.66966 11.59596-10.00586 24.75512-10.00586 39.48828 0 15.12843 3.56092 28.61363 10.67578 40.45508 7.11485 11.84977 16.94808 21.12416 29.48437 27.84375 12.54045 6.71958 26.87325 10.07812 42.9961 10.07812 10.05233 0 20.47608-1.69349 31.27734-5.07617 10.7971-3.38268 21.62172-9.60419 32.46875-18.66211l-14.47852-18.50976c-7.36865 6.96506-15.52852 12.01515-24.48242 15.15234-8.95806 3.13303-17.46554 4.70117-25.5332 4.70117-14.52928 0-26.94633-4.25497-37.24414-12.76367-10.30198-8.5087-16.69548-19.3858-19.18359-32.62109h126.59765v-10.00196c0-15.02857-3.23709-28.36803-9.70703-40.00976-6.46578-11.6459-15.37438-20.79884-26.7207-27.47266-11.34632-6.66549-24.38013-9.99805-39.11328-9.99805zm369.64843 0c-14.43358 0-27.34789 3.35685-38.74414 10.07227-11.39625 6.71958-20.35538 15.92723-26.87109 27.62305-6.51987 11.69582-9.77734 25.00293-9.77734 39.93164 0 14.93287 3.25747 28.24779 9.77734 39.93945 6.51571 11.69582 15.47484 20.8976 26.87109 27.61719 11.39625 6.71958 24.31056 10.07812 38.74414 10.07812 10.94273 0 21.09955-1.99304 30.45704-5.9707 9.34916-3.98182 17.36575-9.50318 24.03124-16.57227v7.76368c0 20.30021-5.10087 36.54903-15.29882 48.74414-10.20628 12.18679-25.90458 18.28515-47.10352 18.28515-8.35891 0-16.12233-1.3677-23.28711-4.10547-7.16478-2.73776-13.53985-6.54575-19.11523-11.41796l-12.23633 20.59961c7.36034 5.47552 15.62347 9.72828 24.78125 12.76562 9.15361 3.03734 18.96035 4.55273 29.41211 4.55273 19.00623 0 35.00407-3.85826 47.99805-11.57226 12.98564-7.70984 22.81276-18.48613 29.48242-32.31641 6.66549-13.8386 10.0039-29.96154 10.0039-48.37695v-134.6582h-22.24414l-1.34765 20.7539c-6.66966-7.36866-14.77899-13.16086-24.33203-17.39648-9.55305-4.22731-19.95887-6.33985-31.20118-6.33985zm193.48047 0c-14.72899 0-27.91465 3.33256-39.56054 9.99805-11.6459 6.67382-20.80326 15.80664-27.46875 27.39844-6.66966 11.59596-10.00586 24.75512-10.00586 39.48828 0 15.12843 3.56092 28.61363 10.67578 40.45508 7.11485 11.84977 16.94587 21.12416 29.48633 27.84375 12.54045 6.71958 26.87129 10.07812 42.99414 10.07812 10.05649 0 20.47803-1.69349 31.27929-5.07617 10.79295-3.38268 21.61977-9.60419 32.4668-18.66211l-14.47852-18.50976c-7.36865 6.96506-15.52436 12.01515-24.48242 15.15234-8.95806 3.13303-17.46775 4.70117-25.53125 4.70117-14.52928 0-26.94412-4.25497-37.24609-12.76367-10.30198-8.5087-16.69743-19.3858-19.18555-32.62109h126.59961v-10.00196c0-15.02857-3.23709-28.36803-9.70703-40.00976-6.46578-11.6459-15.37438-20.79884-26.7207-27.47266-11.34632-6.66549-24.38208-9.99805-39.11524-9.99805zm413.53909 0c-14.9329 0-28.2437 3.35659-39.9395 10.07618-11.6958 6.71958-20.8995 15.92332-27.6191 27.61914-6.7154 11.69582-10.0781 25.00683-10.0781 39.93554 0 14.93288 3.3627 28.24194 10.0781 39.9336 6.7196 11.69582 15.9233 20.90346 27.6191 27.62304 11.6958 6.71959 25.0066 10.07813 39.9395 10.07813 14.9287 0 28.238-3.35854 39.9297-10.07813 11.6958-6.71958 20.9034-15.92722 27.623-27.62304 6.7196-11.69166 10.0781-25.00072 10.0781-39.9336 0-14.92871-3.3585-28.23972-10.0781-39.93554s-15.9272-20.89956-27.623-27.61914c-11.6917-6.71959-25.001-10.07618-39.9297-10.07618zm182.1347.002c-14.9328 0-28.2438 3.35854-39.9355 10.07812-11.6958 6.71959-20.9035 15.92332-27.6231 27.61914-6.7154 11.69582-10.0761 25.00489-10.0761 39.9336s3.3607 28.24388 10.0761 39.93554c6.7196 11.69583 15.9273 20.89956 27.6231 27.61914 11.6917 6.71959 25.0027 10.07813 39.9355 10.07813 11.2465 0 21.5935-1.9403 31.0508-5.82227 9.4532-3.88196 17.6678-9.30641 24.6328-16.27148l-17.1679-17.02148c-4.6809 5.18011-10.3016 9.25698-16.8672 12.24023-6.574 2.98741-13.7888 4.48047-21.6485 4.48047-10.0565 0-19.0153-2.38754-26.875-7.16406-7.8637-4.78069-14.059-11.34591-18.5859-19.70899-4.531-8.35891-6.793-17.81777-6.793-28.36523 0-10.64732 2.262-20.12852 6.793-28.4375 4.5269-8.30899 10.7222-14.85409 18.5859-19.63477 7.8597-4.77652 16.8185-7.16406 26.875-7.16406 7.8597 0 15.0745 1.46903 21.6485 4.40234 6.5656 2.93748 12.1863 7.04255 16.8672 12.31836l17.1679-17.16992c-6.965-6.86521-15.1796-12.24108-24.6328-16.12305-9.4573-3.88196-19.8043-5.82226-31.0508-5.82226zm-978.75582 22.38867c10.05233 0 19.00952 2.38924 26.86914 7.16992 7.86379 4.77652 14.06076 11.31992 18.5918 19.62891 4.52688 8.30898 6.78906 17.79213 6.78906 28.43945 0 10.55162-2.26218 20.00437-6.78906 28.36328-4.53104 8.36308-10.72801 14.9283-18.5918 19.70899-7.85962 4.77652-16.81681 7.16601-26.86914 7.16601s-19.00951-2.38949-26.86914-7.16601c-7.86795-4.78069-14.06322-11.34591-18.58594-19.70899-4.5352-8.35891-6.79882-17.81166-6.79882-28.36328 0-10.64732 2.26362-20.13047 6.79882-28.43945 4.52272-8.30899 10.71799-14.85239 18.58594-19.62891 7.85963-4.78068 16.81681-7.16992 26.86914-7.16992zm-180.19336.002c13.03558 0 24.08271 4.10312 33.14063 12.31641 9.05375 8.21329 14.67864 18.83551 16.86718 31.87109h-101.21875c2.18855-12.83586 7.96478-23.41367 17.32227-31.72265 9.35333-8.30899 20.64922-12.46485 33.88867-12.46485zm372.0332 0c10.05234 0 19.00952 2.3895 26.86915 7.16602 7.86378 4.78068 14.06075 11.32408 18.59179 19.6289 4.52688 8.31315 6.78906 17.7963 6.78906 28.43946 0 10.55162-2.26218 20.00827-6.78906 28.36718-4.53104 8.35892-10.72801 14.92856-18.59179 19.70508-7.85963 4.78069-16.81681 7.16992-26.86915 7.16992-10.05233 0-19.01121-2.38923-26.875-7.16992-7.86378-4.77652-14.05931-11.34616-18.58203-19.70508-4.5352-8.35891-6.79687-17.81556-6.79687-28.36718 0-10.64316 2.26167-20.12631 6.79687-28.43946 4.52272-8.30482 10.71825-14.84822 18.58203-19.6289 7.86379-4.77652 16.82267-7.16602 26.875-7.16602zm191.09766 0c13.03558 0 24.08076 4.10312 33.13867 12.31641 9.05376 8.21329 14.6806 18.83551 16.86914 31.87109h-101.21875c2.18855-12.83586 7.96283-23.41367 17.32032-31.72265 9.35333-8.30899 20.65117-12.46485 33.89062-12.46485zm413.68362 0c10.0481 0 19.0095 2.38729 26.8691 7.16797 7.8638 4.77652 14.0591 11.32188 18.586 19.63086 4.531 8.30899 6.7949 17.79214 6.7949 28.43945 0 10.55162-2.2639 20.00412-6.7949 28.36719-4.5269 8.35891-10.7222 14.9244-18.586 19.70508-7.8596 4.78068-16.821 7.16601-26.8691 7.16601-10.0565 0-19.0154-2.38533-26.875-7.16601-7.8638-4.78068-14.0591-11.34617-18.586-19.70508-4.531-8.36307-6.7949-17.81557-6.7949-28.36719 0-10.64731 2.2639-20.13046 6.7949-28.43945 4.5269-8.30898 10.7222-14.85434 18.586-19.63086 7.8596-4.78068 16.8185-7.16797 26.875-7.16797z'
          fill='#fff'
          strokeWidth='4.16073'
        />
        <g transform='matrix(.41332019 0 0 .41332019 390.39426 -59.003113)'>
          <path
            d='m1553.66 961.083 75.25-75.258-75.25-75.246 56.61-90.096-90.1-56.616 35.15-100.446-100.44-35.142 11.91-105.746-105.74-11.912-11.92-105.75-105.74 11.912-35.15-100.445-100.43 35.145-56.63-90.1-90.107 56.617-75.242-75.246-75.242 75.25-90.104-56.612-56.612 90.096-100.442-35.15-35.142 100.441-105.75-11.916-11.912 105.741-105.742 11.913 11.917 105.741-100.454 35.15 35.145 100.438-90.1 56.612 56.621 90.117-75.258 75.25 75.25 75.258-56.613 90.107 90.1 56.61-35.145 100.44 100.45 35.15-11.913 105.73 105.742 11.92 11.912 105.74 105.75-11.91 35.142 100.43 100.437-35.13 56.617 90.1 90.096-56.62 75.25 74.55 75.25-74.53 90.099 56.61 56.61-90.11 100.45 35.15 35.14-100.44 105.75 11.91 11.91-105.75 105.75-11.91-11.92-105.74 100.45-35.15-35.15-100.45 90.1-56.61z'
            fill='#b51f08'
          />
          <path
            d='m1401.3 1004.78c0-145.437-117.9-263.341-263.34-263.341-72.24 0-137.68 29.112-185.252 76.225l-.033-.034-67.096 67.1-54.862-54.862c-48.267-55.067-119.071-89.879-198.042-89.879-145.442 0-263.342 117.904-263.342 263.341 0 76 32.23 144.43 83.721 192.49l432.779 432.55 423.217-423.49c52.88-49.77 92.25-120 92.25-200.1'
            fill='#fdd49a'
          />
          <path
            d='m885.579 884.73-54.862-54.862c-48.267-55.067-119.071-89.879-198.042-89.879-145.442 0-263.342 117.904-263.342 263.341 0 76 32.23 144.43 83.721 192.49l432.779 432.55'
            fill='url(#a)'
          />
        </g>
      </g>
      <g transform='matrix(.41332019 0 0 .41332019 390.394261 -59.003113)'>
        <path d='m885.833 1628.37-.254-743.64' fill='none' />
        <g fillRule='nonzero'>
          <path
            d='m961.011 1553.59c-19.279-19.35-45.917-31.31-75.325-31.31-29.417 0-56.046 11.96-75.329 31.31.308 41.34 33.908 74.76 75.325 74.76 41.416 0 75.02-33.43 75.329-74.76'
            fill='#010007'
          />
          <path
            d='m797.707 1098.22c0 31.8-25.767 57.57-57.571 57.57-31.787 0-57.558-25.77-57.558-57.57s25.771-57.57 57.558-57.57c31.804 0 57.571 25.77 57.571 57.57'
            fill='#010007'
          />
          <path
            d='m777.962 1089.59c0 8.82-7.146 15.94-15.95 15.94-8.808 0-15.958-7.12-15.958-15.94 0-8.81 7.15-15.96 15.958-15.96 8.804 0 15.95 7.15 15.95 15.96'
            fill='#fffffa'
          />
          <path
            d='m1089.65 1098.22c0 31.8-25.77 57.57-57.57 57.57-31.79 0-57.567-25.77-57.567-57.57s25.777-57.57 57.567-57.57c31.8 0 57.57 25.77 57.57 57.57'
            fill='#010007'
          />
          <path
            d='m1069.9 1089.59c0 8.82-7.15 15.94-15.95 15.94-8.81 0-15.96-7.12-15.96-15.94 0-8.81 7.15-15.96 15.96-15.96 8.8 0 15.95 7.15 15.95 15.96'
            fill='#fffffa'
          />
        </g>
      </g>
    </svg>
  )
}
