# S3-compatible

You can use [Amazon S3][s3] or any other S3-compatible storage (like [MinIO][minIO]
or [Ceph Object Gateway][ceph]) to handle your image uploads in HedgeDoc.

Your S3 bucket must be configured to be writeable.

You just add the following lines to your configuration:  
(with the appropriate substitution for `<ACCESS_KEY>`, `<SECRET_KEY>`,
`<BUCKET>`, and `<ENDPOINT>` of course)

```dotenv
HD_MEDIA_BACKEND="s3"
HD_MEDIA_BACKEND_S3_ACCESS_KEY="<ACCESS_KEY>"
HD_MEDIA_BACKEND_S3_SECRET_KEY="<SECRET_KEY>"
HD_MEDIA_BACKEND_S3_BUCKET="<BUCKET>"
HD_MEDIA_BACKEND_S3_ENDPOINT="<ENDPOINT>"
```

`<ENDPOINT>` should be an URL and contain the protocol, the domain and if necessary the port.
For example: `https://s3.example.org` or `http://s3.example.org:9000`

If you use Amazon S3, `<ENDPOINT>` should contain your [Amazon Region][amazon-region].
For example: If your Amazon Region is `us-east-2`,your endpoint `<ENDPOINT>`
should be `https://s3.us-east-2.amazonaws.com`.

[s3]: https://aws.amazon.com/s3/
[minIO]: https://min.io
[ceph]: https://docs.ceph.com/en/latest/radosgw/
[amazon-region]: https://docs.aws.amazon.com/general/latest/gr/s3.html
