# Welcome to the HedgeDoc 2 Documentation

<!-- markdownlint-disable no-inline-html line-length -->
<img alt="HedgeDoc Logo" title="HedgeDoc Logo" width="398" height="100" class="light-mode-only" src="images/hedgedoc_logo_black.svg">
<img alt="HedgeDoc Logo" title="HedgeDoc Logo" width="398" height="100" class="dark-mode-only" src="images/hedgedoc_logo_white.svg">
<!-- markdownlint-enable  no-inline-html line-length -->

!!! danger "🚧⚠️🚧 **HedgeDoc 2.0 is still in development!**"
    You are probably looking for the 1.x docs.  
    <!-- markdownlint-disable proper-names -->
    Find them in the `master` branch and on [docs.hedgedoc.org](https://docs.hedgedoc.org).
    <!-- markdownlint-enable proper-names -->

Welcome to the documentation for HedgeDoc, a collaborative online markdown editor,
that you can host yourself.

## Quick start

<!-- markdownlint-disable proper-names -->
<!-- TODO: HedgeDoc Tour Video https://github.com/hedgedoc/hedgedoc/issues/4828 -->
<!-- markdownlint-enable proper-names -->
- 🦔 New to HedgeDoc? Take the [HedgeDoc tour][hedgedoc-tour]
- 🚀 Want your own instance? [Install HedgeDoc yourself][install-guide]
- 🛠️ Want to change something about HedgeDoc? Read the [Configuration reference][config-reference]

## Getting help

Having trouble? We’d like to help!

- ❓ Take a look into the [FAQ][faq] – there are answers to many common questions.
- 🌐 Still any questions? Ask them at our [community forum][community-forum].
- 💬 Talk to us on our [matrix chat][chat].
- 🐛 Report bugs in our [issue tracker][issue-tracker].

## How the documentation is organized

To make it easy for you to find the relevant documentation articles, we organized our docs by the
following categories:

- **[Tutorials][tutorials]** are detailed step-by-step instructions. Start here if you're new to
  HedgeDoc, want to create your first presentation or want to build a simple API application.
- **[How-to guides][how-to]** target the more advanced users and guide them through a variety of
  topics, addressing non-trivial use-cases. They are more advanced than tutorials and assume some
  knowledge of HedgeDoc.
- **[Core concepts][core-concepts]** explain the internal structure of HedgeDoc by providing
  background information and explanations. They are especially useful for contributing to HedgeDoc.
- **[References][references]** are details to lookup in a non-guided way. These include for example
  configuration options or API methods.

## Participate in the HedgeDoc project

There are different ways how you can participate in the HedgeDoc project:

- Help others or share your experiences and tips in the [community forum][community-forum].
- Improve the translation HegdeDoc of HedgeDoc into your language at our [weblate][weblate].
- Report bugs, feature requests or enhancement ideas in our [issue tracker][issue-tracker].
- Read the [getting started how-to for developers][how-to-dev] to start implementing
  your own features.

[![Deployed using netlify](https://www.netlify.com/img/global/badges/netlify-color-accent.svg)
](https://www.netlify.com)

[hedgedoc-tour]: https://tour.hedgedoc.org
[install-guide]: tutorials/setup.md
[config-reference]: references/config/index.md

[faq]: faq/index.md
[community-forum]: https://community.hedgedoc.org/
[chat]: https://chat.hedgedoc.org
[issue-tracker]: https://github.com/hedgedoc/hedgedoc/issues/new/choose

[tutorials]: tutorials/index.md
[how-to]: how-to/index.md
[core-concepts]: concepts/index.md
[references]: references/index.md

[weblate]: https://translate.hedgedoc.org
[how-to-dev]: how-to/develop/setup.md
