<!--
SPDX-FileCopyrightText: 2021 The HedgeDoc developers (see AUTHORS file)

SPDX-License-Identifier: CC-BY-SA-4.0
-->

# Security Policy

## Supported Versions

Only the latest release of HedgeDoc is supported. We don't have the
ressources to maintain multiple versions.

## Reporting a Vulnerability

Please go to ["Issues" > "New" > "Report a security vulnerability"][report]. This
allows you to get in direct, but private contact with us. There is some more detailed
documentation [available by GitHub][github_report_docs].

> **Tip**: In this form, only the title and description are mandatory [so don't
> worry if you can't fill everything]. […] However, we recommend security
> researchers provide as much information as possible on the form so that [we]
> can make an informed decision about the submitted report.  You can adopt the
> template used by [GitHub's] security researchers from the GitHub Security
> Lab, which is available on the [github/securitylab
> repository][best_practice]."

We'll get back to you as soon as possible. You can expect an answer within
3 days, in rare cases within a month. If you don't get a reply within a month,
please reach out for other contact addresses in the [community chat][community_chat].

When your findings are accepted as a security issue, we'll work on a fix or
at least a workaround for the next release. With the release that contained
the fix, we want to encourage you to publish your findings as you like.

We'll also credit you in the release notes.

When your findings are not accepted as a security issue, feel free to write
a fix yourself and contribute it to HedgeDoc, as well as publish them as you
like and allow people to make an informed decision about using HedgeDoc.

If you have any further questions, feel free to reach out to the
[community chat][community_chat] or the mentioned contacts above.

[repo]: https://github.com/hedgedoc/hedgedoc
[report]: https://github.com/hedgedoc/hedgedoc/security/advisories/new
[github_report_docs]: https://docs.github.com/en/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability#privately-reporting-a-security-vulnerability
[community_chat]: https://chat.hedgedoc.org
[best_practice]: https://github.com/github/securitylab/blob/main/docs/report-template.md
