#![doc = include_str!("../README.md")]
#![warn(missing_docs, rustdoc::broken_intra_doc_links)]
#![cfg_attr(not(test), no_std)]
#![cfg_attr(docsrs, feature(doc_cfg, doc_auto_cfg, doc_cfg_hide))]
#![cfg_attr(docsrs, doc(cfg_hide(docsrs)))]
#![cfg_attr(trace_macros, feature(trace_macros))]

pub mod pack;
pub use self::pack::*;
mod bitfield;
mod from_bits;
pub use self::from_bits::FromBits;

/// An example of the code generated by the [`bitfield!`] macro.
///
/// > **Warning**: This module is included for DEMONSTRATION PURPOSES ONLY.
/// > This module is *not* part of the public API of this crate; it is provided
/// > as documentation only, and may change in non-breaking releases.
///
/// The [`ExampleBitfield`] type in this module was generated by the
/// following [`bitfield!`] invocation:
///
/// ```ignore
#[doc = include_str!("example/example_bitfield.rs")]
/// ```
///
/// This module also contains two example types implementing the
/// [`FromBits`] trait, as a demonstration of how typed enums can
/// be used with the [`bitfield!`] macro.
///
///
/// [`ExampleBitfield`]: example::ExampleBitfield
#[cfg(any(test, docsrs, trace_macros))]
#[allow(missing_docs)]
pub mod example;
