# Server engineering documentation

This page documents the structure and the internal architecture of the [GraphQL
Engine Server](https://github.com/hasura/graphql-engine/tree/master/server). To
get started, you can read the [overview](overview.md). We also maintain a
[glossary](glossary.md) of all the terms we use throughout the code and the
documentation.

You can also get started with a list of [tips and tricks](tips.md).

## Haddock documentation

You can [browse the engine's haddock documentation](haddock) for the [stable](haddock/stable) branch, [main](haddock/main) branch, and every previous version release since `v2.2.0`.

## Architecture deep-dive

* how to understand our [GraphQL schema](deep-dives/schema.md)
* how to perform [database migrations](deep-dives/migration-guidelines.md)
* how the [execution of remote joins](deep-dives/remote-joins-execution.md) works
* how we [manage resources](deep-dives/managed.md)


## Backend-specific documentation

* [BigQuery](data-sources/bigquery.md)

## Notes

In our Haskell codebase, we use [GHC-style
notes](https://www.stackbuilders.com/news/the-notes-of-ghc) for long-form
comments detailing a specific aspect of the codebase. We gather all of them, as
of the `main` branch, in the [notes subfolder](notes/).

## Updating this documentation

All markdown files in this folder are either copied *verbatim* from
[`server/documentation`](https://github.com/hasura/graphql-engine/tree/master/server/documentation)
or generated as part of our CI; do not open a PR to modify files in
the `gh-pages` branch, and instead modify their source directly. Notes
are extracted using the `scripts/extract-nodes` bash script. The
haddock documentation is generated by running `cabal haddock
--haddock-internal --haddock-options="--ignore-all-exports"`.
