import {
  FILTER_TYPE_DROPDOWN_DEFAULT,
  FILTER_TYPE_INPUT,
  FILTER_TYPE_DROPDOWN,
  FILTER_TYPE_CHECKBOX,
  TIME_RANGE_SYMBOL,
  OPERATION_NAME_SYMBOL,
  OPERATION_TYPE_SYMBOL,
  OPERATION_ID_SYMBOL,
  OPERATION_GROUP_NAME,
  REQUEST_ID_SYMBOL,
  SHOW_ONLY_ERRORS_SYMBOL,
  CLIENT_NAME_SYMBOL,
  REQUEST_ID_DISPLAY,
  SHOW_ONLY_ERROR_DISPLAY,
  ROLE_SYMBOL,
  ERROR_CODE_SYMBOL,
  TIME_RANGE_BY_HOUR,
  TIME_RANGE_BY_6_HOURS,
  TIME_RANGE_BY_12_HOURS,
  TIME_RANGE_BY_DAY,
  OPERATION_GROUP_NAME_DISPLAY,
  TRANSPORT_SYMBOL,
  WEBSOCKET_ID_SYMBOL,
  WEBSOCKET_NAME_DISPLAY,
  WEBSOCKET_OP_ID_SYMBOL,
  WEBSOCKET_OP_NAME_DISPLAY,
  SUBSCRIPTION_STATUS_SYMBOL,
  SUBSCRIPTION_STATUS_NAME_DISPLAY,
  HIDE_INTROPSECTION_QUERY_DISPLAY,
  HIDE_INTROPSECTION_QUERY_SYMBOL,
} from '../constants';

import { TITLE_MAP, NO_TITLE_MAP } from '../constants';

export const headerTitleLabel = {
  execution_time: 'ms',
  response_size: 'kB',
  request_size: 'kB',
};

export const excludeRenderingColumns = ['id', 'operation'];

export const aliasedNames = {
  role: 'user_role',
  success: 'is_error',
};

export const OPERATIONS_FILTER_MAP = {
  [TIME_RANGE_SYMBOL]: FILTER_TYPE_DROPDOWN_DEFAULT,
  [OPERATION_ID_SYMBOL]: FILTER_TYPE_INPUT,
  [OPERATION_NAME_SYMBOL]: FILTER_TYPE_INPUT,
  [REQUEST_ID_SYMBOL]: FILTER_TYPE_INPUT,
  [SHOW_ONLY_ERRORS_SYMBOL]: FILTER_TYPE_CHECKBOX,
  [OPERATION_TYPE_SYMBOL]: FILTER_TYPE_DROPDOWN,
  [ROLE_SYMBOL]: FILTER_TYPE_DROPDOWN,
  [ERROR_CODE_SYMBOL]: FILTER_TYPE_DROPDOWN,
  [CLIENT_NAME_SYMBOL]: FILTER_TYPE_DROPDOWN,
  [TRANSPORT_SYMBOL]: FILTER_TYPE_DROPDOWN,
  [WEBSOCKET_ID_SYMBOL]: FILTER_TYPE_INPUT,
  [WEBSOCKET_OP_ID_SYMBOL]: FILTER_TYPE_INPUT,
  [SUBSCRIPTION_STATUS_SYMBOL]: FILTER_TYPE_DROPDOWN,
  [HIDE_INTROPSECTION_QUERY_SYMBOL]: FILTER_TYPE_CHECKBOX,
  // [OPERATION_GROUP_NAME]: FILTER_TYPE_DROPDOWN,
};

export const OPERATIONS_TITLE_MAP = {
  ...TITLE_MAP,
  [SHOW_ONLY_ERRORS_SYMBOL]: SHOW_ONLY_ERROR_DISPLAY,
  [REQUEST_ID_SYMBOL]: REQUEST_ID_DISPLAY,
  [OPERATION_GROUP_NAME]: OPERATION_GROUP_NAME_DISPLAY,
  [WEBSOCKET_ID_SYMBOL]: WEBSOCKET_NAME_DISPLAY,
  [WEBSOCKET_OP_ID_SYMBOL]: WEBSOCKET_OP_NAME_DISPLAY,
  [SUBSCRIPTION_STATUS_SYMBOL]: SUBSCRIPTION_STATUS_NAME_DISPLAY,
  [HIDE_INTROPSECTION_QUERY_SYMBOL]: HIDE_INTROPSECTION_QUERY_DISPLAY,
};

export const OPERATIONS_NO_TITLE_MAP = {
  ...NO_TITLE_MAP,
};

export const timeRangeFilters = [
  TIME_RANGE_BY_HOUR,
  TIME_RANGE_BY_6_HOURS,
  TIME_RANGE_BY_12_HOURS,
  TIME_RANGE_BY_DAY,
];

export const toggleFilters = [SHOW_ONLY_ERRORS_SYMBOL];
export const singleSelectFilters = [TIME_RANGE_SYMBOL];
