export const sourceDataTypes = {
  mssql: {
    int: 'int',
    bigint: 'int',
    smallint: 'int',
    tinyint: 'int',
    bit: 'boolean',
    decimal: 'int',
    numeric: 'int',
    float: 'int',
    real: 'int',
    date: 'string',
    datetime: 'string',
    smalldatetime: 'string',
    datetime2: 'string',
    time: 'string',
    char: 'string',
    varchar: 'string',
    text: 'string',
    nchar: 'string',
    nvarchar: 'string',
    ntext: 'string',
    binary: 'string',
    varbinary: 'string',
    image: 'string',
    uniqueidentifier: 'string',
  },
  postgres: {
    integer: 'int',
    bigint: 'int',
    smallint: 'int',
    serial: 'int',
    bigserial: 'int',
    smallserial: 'int',
    numeric: 'int',
    decimal: 'int',
    real: 'int',
    boolean: 'boolean',
    char: 'string',
    varchar: 'string',
    'character varying': 'string',
    text: 'string',
    date: 'string',
    timestamp: 'string',
    timestamptz: 'string',
    time: 'string',
    timetz: 'string',
    interval: 'string',
    uuid: 'string',
    bytea: 'string',
    bit: 'string',
    json: 'object',
    jsonb: 'object',
    array: 'array',
    hstore: 'object',
    enum: 'string',
    tsvector: 'string',
    tsquery: 'string',
    inet: 'string',
    cidr: 'string',
    macaddr: 'string',
    macaddr8: 'string',
    point: 'object',
    line: 'object',
    lseg: 'object',
    box: 'object',
    path: 'object',
    polygon: 'object',
    circle: 'object',
  },
  mysql: {
    tinyint: 'integer',
    smallint: 'integer',
    mediumint: 'integer',
    int: 'integer',
    bigint: 'integer',
    bit: 'boolean',
    float: 'integer',
    double: 'integer',
    decimal: 'integer',
    numeric: 'integer',
    date: 'string',
    datetime: 'string',
    timestamp: 'string',
    time: 'string',
    year: 'integer',
    char: 'string',
    varchar: 'string',
    tinytext: 'string',
    text: 'string',
    mediumtext: 'string',
    longtext: 'string',
    binary: 'string',
    varbinary: 'string',
    tinyblob: 'string',
    blob: 'string',
    mediumblob: 'string',
    longblob: 'string',
    enum: 'string',
    set: 'string',
    json: 'object',
    geometry: 'object',
    point: 'object',
    linestring: 'object',
    polygon: 'object',
    multipoint: 'object',
    multilinestring: 'object',
    multipolygon: 'object',
    geometrycollection: 'object',
  },
  citus: {
    integer: 'integer',
    bigint: 'integer',
    smallint: 'integer',
    serial: 'integer',
    bigserial: 'integer',
    smallserial: 'integer',
    numeric: 'integer',
    decimal: 'integer',
    real: 'integer',
    'double precision': 'integer',
    boolean: 'boolean',
    char: 'string',
    varchar: 'string',
    text: 'string',
    date: 'string',
    timestamp: 'string',
    timestamptz: 'string',
    time: 'string',
    timetz: 'string',
    interval: 'string',
    uuid: 'string',
    bytea: 'string',
    bit: 'string',
    'bit varying': 'string',
    json: 'object',
    jsonb: 'object',
    array: 'array',
    hstore: 'object',
    enum: 'string',
    tsvector: 'string',
    tsquery: 'string',
    inet: 'string',
    cidr: 'string',
    macaddr: 'string',
    macaddr8: 'string',
    point: 'object',
    line: 'object',
    lseg: 'object',
    box: 'object',
    path: 'object',
    polygon: 'object',
    circle: 'object',
  },
  alloy: {
    integer: 'integer',
    bigint: 'integer',
    smallint: 'integer',
    serial: 'integer',
    bigserial: 'integer',
    smallserial: 'integer',
    numeric: 'integer',
    decimal: 'integer',
    real: 'integer',
    boolean: 'boolean',
    char: 'string',
    varchar: 'string',
    text: 'string',
    date: 'string',
    timestamp: 'string',
    timestamptz: 'string',
    time: 'string',
    timetz: 'string',
    interval: 'string',
    uuid: 'string',
    bytea: 'string',
    bit: 'string',
    json: 'object',
    jsonb: 'object',
    array: 'array',
    hstore: 'object',
    enum: 'string',
    tsvector: 'string',
    tsquery: 'string',
    inet: 'string',
    cidr: 'string',
    macaddr: 'string',
    macaddr8: 'string',
    point: 'object',
    line: 'object',
    lseg: 'object',
    box: 'object',
    path: 'object',
    polygon: 'object',
    circle: 'object',
  },
  bigquery: {
    INT64: 'integer',
    FLOAT64: 'integer',
    NUMERIC: 'integer',
    BIGNUMERIC: 'integer',
    BOOL: 'boolean',
    STRING: 'string',
    BYTES: 'string',
    DATE: 'string',
    DATETIME: 'string',
    TIME: 'string',
    TIMESTAMP: 'string',
    GEOGRAPHY: 'string',
  },
  cockroach: {
    INT: 'integer',
    INTEGER: 'integer',
    SMALLINT: 'integer',
    BIGINT: 'integer',
    SERIAL: 'integer',
    SMALLSERIAL: 'integer',
    BIGSERIAL: 'integer',
    FLOAT: 'integer',
    REAL: 'integer',
    'DOUBLE PRECISION': 'integer',
    DECIMAL: 'integer',
    NUMERIC: 'integer',
    BOOL: 'boolean',
    BOOLEAN: 'boolean',
    CHAR: 'string',
    VARCHAR: 'string',
    STRING: 'string',
    TEXT: 'string',
    BYTES: 'string',
    DATE: 'string',
    TIME: 'string',
    TIMESTAMP: 'string',
    INTERVAL: 'string',
    UUID: 'string',
    INET: 'string',
    JSON: 'object',
    JSONB: 'object',
    ENUM: 'string',
  },
};

export type MsSQLTypes = keyof (typeof sourceDataTypes)['mssql'];
export type PostgresTypes = keyof (typeof sourceDataTypes)['postgres'];
export type MySQLTypes = keyof (typeof sourceDataTypes)['mysql'];
export type CitusTypes = keyof (typeof sourceDataTypes)['citus'];
export type AlloyTypes = keyof (typeof sourceDataTypes)['alloy'];
export type CockroachTypes = keyof (typeof sourceDataTypes)['cockroach'];
export type BigQueryTypes = keyof (typeof sourceDataTypes)['bigquery'];

export type SourceDataTypes = MsSQLTypes &
  PostgresTypes &
  MySQLTypes &
  CitusTypes &
  AlloyTypes &
  CockroachTypes &
  BigQueryTypes;
