import React from 'react';

type Props = {
  className?: string;
};

export function MultipleAdminSecretsSvg(props: Props) {
  const { className } = props;
  return (
    <svg
      className={className}
      width="690"
      height="271"
      viewBox="0 0 690 271"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <rect x="1" y="1" width="671" height="270" rx="2" fill="#E2E8F0" />
      <g filter="url(#filter0_dd_571_46831)">
        <rect
          x="312.482"
          y="109"
          width="54.0691"
          height="54"
          rx="27"
          fill="white"
          shapeRendering="crispEdges"
        />
        <g clipPath="url(#clip0_571_46831)">
          <path
            d="M351.137 132.172C351.849 130.021 351.421 125.725 350.04 124.139C349.86 123.932 349.52 123.962 349.371 124.19L347.668 126.779C347.247 127.298 346.489 127.416 345.92 127.055C344.074 125.885 341.868 125.203 339.497 125.203C337.125 125.203 334.919 125.885 333.073 127.055C332.504 127.416 331.746 127.295 331.325 126.779L329.622 124.19C329.473 123.962 329.134 123.932 328.953 124.139C327.572 125.725 327.144 130.021 327.856 132.172C328.091 132.886 328.159 133.642 328.018 134.379C327.881 135.108 327.74 135.991 327.74 136.602C327.74 142.895 333.006 148 339.497 148C345.991 148 351.253 142.898 351.253 136.602C351.253 135.988 351.116 135.108 350.975 134.379C350.834 133.642 350.902 132.886 351.137 132.172ZM339.497 145.452C334.479 145.452 330.396 141.493 330.396 136.628C330.396 136.468 330.402 136.311 330.408 136.154C330.591 132.839 332.666 130.003 335.606 128.652C336.786 128.107 338.106 127.805 339.497 127.805C340.887 127.805 342.207 128.11 343.39 128.655C346.33 130.006 348.405 132.842 348.588 136.154C348.597 136.311 348.6 136.468 348.6 136.628C348.597 141.493 344.514 145.452 339.497 145.452Z"
            fill="black"
          />
          <path
            d="M343.439 140.024L341.113 136.116L339.118 132.856C339.072 132.779 338.986 132.732 338.892 132.732H336.985C336.89 132.732 336.804 132.782 336.758 132.859C336.713 132.939 336.713 133.037 336.762 133.114L338.668 136.225L336.108 140.012C336.056 140.089 336.049 140.19 336.095 140.273C336.141 140.356 336.23 140.406 336.325 140.406H338.244C338.332 140.406 338.415 140.361 338.464 140.29L339.848 138.193L341.089 140.279C341.135 140.359 341.223 140.406 341.315 140.406H343.207C343.301 140.406 343.387 140.359 343.433 140.279C343.488 140.199 343.488 140.104 343.439 140.024Z"
            fill="black"
          />
        </g>
      </g>
      <g filter="url(#filter1_dd_571_46831)">
        <rect
          x="357.54"
          y="123"
          width="26.0332"
          height="26"
          rx="13"
          fill="white"
          shapeRendering="crispEdges"
        />
        <path
          d="M368.607 136C369.121 136 369.624 135.848 370.051 135.562C370.479 135.276 370.812 134.87 371.009 134.395C371.206 133.92 371.257 133.397 371.157 132.893C371.056 132.388 370.809 131.925 370.445 131.562C370.082 131.198 369.618 130.95 369.114 130.85C368.61 130.75 368.087 130.801 367.612 130.998C367.137 131.195 366.731 131.528 366.445 131.956C366.159 132.383 366.007 132.886 366.007 133.4C366.007 134.09 366.281 134.751 366.768 135.238C367.256 135.726 367.917 136 368.607 136ZM370.557 137.3C370.558 137.083 370.615 136.87 370.721 136.68C370.624 136.67 370.528 136.65 370.427 136.65H370.087C369.623 136.864 369.118 136.975 368.607 136.975C368.095 136.975 367.59 136.864 367.126 136.65H366.787C366.063 136.65 365.368 136.938 364.856 137.45C364.344 137.962 364.057 138.656 364.057 139.38V140.225C364.057 140.484 364.159 140.732 364.342 140.914C364.525 141.097 364.773 141.2 365.032 141.2H370.737C370.621 141.003 370.558 140.779 370.557 140.55V137.3ZM376.407 136.65H375.757V135.025C375.757 134.594 375.585 134.181 375.281 133.876C374.976 133.571 374.563 133.4 374.132 133.4C373.701 133.4 373.287 133.571 372.983 133.876C372.678 134.181 372.507 134.594 372.507 135.025V136.65H371.857C371.684 136.65 371.519 136.718 371.397 136.84C371.275 136.962 371.207 137.128 371.207 137.3V140.55C371.207 140.722 371.275 140.888 371.397 141.01C371.519 141.132 371.684 141.2 371.857 141.2H376.407C376.579 141.2 376.744 141.132 376.866 141.01C376.988 140.888 377.057 140.722 377.057 140.55V137.3C377.057 137.128 376.988 136.962 376.866 136.84C376.744 136.718 376.579 136.65 376.407 136.65ZM374.132 139.575C374.003 139.575 373.877 139.537 373.771 139.465C373.664 139.394 373.58 139.293 373.531 139.174C373.482 139.055 373.469 138.924 373.494 138.798C373.519 138.672 373.581 138.556 373.672 138.465C373.763 138.374 373.879 138.313 374.005 138.287C374.131 138.262 374.262 138.275 374.38 138.324C374.499 138.374 374.601 138.457 374.672 138.564C374.744 138.671 374.782 138.796 374.782 138.925C374.782 139.097 374.713 139.263 374.591 139.385C374.469 139.507 374.304 139.575 374.132 139.575ZM374.782 136.65H373.482V135.025C373.482 134.853 373.55 134.687 373.672 134.565C373.794 134.443 373.959 134.375 374.132 134.375C374.304 134.375 374.469 134.443 374.591 134.565C374.713 134.687 374.782 134.853 374.782 135.025V136.65Z"
          fill="#64748B"
        />
      </g>
      <path
        d="M43.5393 47.0312H41.1727L42.0463 44.3693C42.1283 44.0576 41.8925 43.75 41.5705 43.75H38.6174C38.3713 43.75 38.1621 43.9325 38.1293 44.1766L37.4731 49.0984C37.4341 49.3937 37.6638 49.6562 37.9612 49.6562H40.3954L39.45 53.645C39.3762 53.9567 39.6141 54.25 39.9279 54.25C40.1001 54.25 40.2642 54.1598 40.3544 54.0039L43.9638 47.7695C44.1545 47.4435 43.9187 47.0312 43.5393 47.0312Z"
        fill="#94A3B8"
      />
      <path
        d="M53.986 49.352H53.842V52.988H52.102V44.588H54.766C55.67 44.588 56.346 44.788 56.794 45.188C57.242 45.58 57.466 46.144 57.466 46.88C57.466 47.328 57.31 47.74 56.998 48.116C56.686 48.484 56.306 48.696 55.858 48.752C56.178 48.84 56.426 48.988 56.602 49.196C56.778 49.396 56.962 49.724 57.154 50.18L58.342 52.988H56.554L55.39 50.3C55.222 49.916 55.042 49.664 54.85 49.544C54.666 49.416 54.378 49.352 53.986 49.352ZM54.718 45.956H53.842V47.984H54.598C54.918 47.984 55.166 47.88 55.342 47.672C55.526 47.464 55.618 47.208 55.618 46.904C55.618 46.272 55.318 45.956 54.718 45.956ZM64.3365 53H59.3325V44.6H64.3365V45.98H61.0725V47.744H64.0365V49.148H61.0725V51.62H64.3365V53ZM70.5404 44.9L70.2524 46.304L69.5084 46.1C68.9804 45.98 68.5204 45.92 68.1284 45.92C67.5844 45.92 67.3124 46.18 67.3124 46.7C67.3124 46.9 67.4044 47.084 67.5884 47.252C67.7804 47.412 68.0204 47.548 68.3084 47.66C68.5964 47.764 68.9044 47.896 69.2324 48.056C69.5604 48.216 69.8684 48.388 70.1564 48.572C70.4444 48.756 70.6804 49.008 70.8644 49.328C71.0564 49.648 71.1524 50.016 71.1524 50.432C71.1524 51.256 70.8844 51.904 70.3484 52.376C69.8204 52.84 69.0724 53.072 68.1044 53.072C67.6084 53.072 67.1124 53.008 66.6164 52.88C66.1284 52.744 65.7244 52.588 65.4044 52.412L65.9204 51.128C66.6564 51.464 67.3844 51.632 68.1044 51.632C68.5124 51.632 68.8324 51.54 69.0644 51.356C69.2964 51.164 69.4124 50.92 69.4124 50.624C69.4124 50.328 69.2804 50.084 69.0164 49.892C68.7524 49.692 68.4324 49.516 68.0564 49.364C67.6804 49.204 67.3044 49.028 66.9284 48.836C66.5524 48.636 66.2324 48.36 65.9684 48.008C65.7044 47.648 65.5724 47.224 65.5724 46.736C65.5724 46.008 65.8004 45.452 66.2564 45.068C66.7124 44.676 67.3244 44.48 68.0924 44.48C68.8684 44.48 69.6844 44.62 70.5404 44.9ZM73.7658 53V46.004H71.8338V44.6H77.4018V46.004H75.4938V53H73.7658ZM86.4966 53H81.4926V44.6H86.4966V45.98H83.2326V47.744H86.1966V49.148H83.2326V51.62H86.4966V53ZM93.2045 53H91.6205V49.412C91.6205 49.084 91.5565 48.82 91.4285 48.62C91.3005 48.412 91.0885 48.308 90.7925 48.308C90.4965 48.308 90.1285 48.492 89.6885 48.86V53H88.1165V47H89.4365L89.6885 47.54C90.0325 47.284 90.3285 47.112 90.5765 47.024C90.8325 46.928 91.1285 46.88 91.4645 46.88C92.0005 46.88 92.4245 47.06 92.7365 47.42C93.0485 47.772 93.2045 48.296 93.2045 48.992V53ZM99.6958 53H98.5198L98.2798 52.316C97.6078 52.82 96.9958 53.072 96.4438 53.072C95.8998 53.072 95.4478 52.816 95.0878 52.304C94.7358 51.784 94.5598 51.02 94.5598 50.012C94.5598 48.996 94.7598 48.22 95.1598 47.684C95.5678 47.148 96.0998 46.88 96.7558 46.88C97.1878 46.88 97.6518 47.08 98.1478 47.48V44.6H99.6958V53ZM98.1358 51.152V48.764C97.7118 48.412 97.3558 48.236 97.0678 48.236C96.7798 48.236 96.5478 48.384 96.3718 48.68C96.2038 48.976 96.1198 49.416 96.1198 50C96.1198 51.12 96.4238 51.68 97.0318 51.68C97.3438 51.68 97.7118 51.504 98.1358 51.152ZM103.212 55.844H101.652V47H102.84L103.128 47.636C103.424 47.388 103.692 47.2 103.932 47.072C104.18 46.944 104.456 46.88 104.76 46.88C105.424 46.88 105.928 47.156 106.272 47.708C106.624 48.26 106.8 49.032 106.8 50.024C106.8 51.016 106.576 51.776 106.128 52.304C105.68 52.824 105.152 53.084 104.544 53.084C104.104 53.084 103.66 52.892 103.212 52.508V55.844ZM103.212 48.848V51.044C103.468 51.46 103.784 51.668 104.16 51.668C104.544 51.668 104.808 51.532 104.952 51.26C105.104 50.988 105.18 50.572 105.18 50.012C105.18 49.452 105.1 49.02 104.94 48.716C104.78 48.412 104.58 48.26 104.34 48.26C103.996 48.26 103.62 48.456 103.212 48.848ZM113.158 50.012C113.158 50.972 112.914 51.724 112.426 52.268C111.938 52.812 111.246 53.084 110.35 53.084C109.454 53.084 108.774 52.812 108.31 52.268C107.846 51.724 107.614 50.968 107.614 50C107.614 49.032 107.846 48.272 108.31 47.72C108.774 47.16 109.442 46.88 110.314 46.88C111.186 46.88 111.878 47.164 112.39 47.732C112.902 48.292 113.158 49.052 113.158 50.012ZM111.562 49.988C111.562 48.764 111.17 48.152 110.386 48.152C109.586 48.152 109.186 48.76 109.186 49.976C109.186 51.192 109.59 51.8 110.398 51.8C110.83 51.8 111.13 51.648 111.298 51.344C111.474 51.032 111.562 50.58 111.562 49.988ZM116.043 46.1H114.483V44.6H116.043V46.1ZM116.043 53H114.483V47H116.043V53ZM123.029 53H121.445V49.412C121.445 49.084 121.381 48.82 121.253 48.62C121.125 48.412 120.913 48.308 120.617 48.308C120.321 48.308 119.953 48.492 119.513 48.86V53H117.941V47H119.261L119.513 47.54C119.857 47.284 120.153 47.112 120.401 47.024C120.657 46.928 120.953 46.88 121.289 46.88C121.825 46.88 122.249 47.06 122.561 47.42C122.873 47.772 123.029 48.296 123.029 48.992V53ZM124.912 51.704V48.32H124.3V47H124.924V45.284H126.472V47H127.732V48.32H126.46V50.936C126.46 51.472 126.624 51.74 126.952 51.74C127.136 51.74 127.332 51.716 127.54 51.668L127.792 52.916C127.424 53.02 127.032 53.072 126.616 53.072C126.208 53.072 125.82 52.968 125.452 52.76C125.092 52.544 124.912 52.192 124.912 51.704ZM129.012 51.404C129.548 51.676 130.096 51.812 130.656 51.812C131.224 51.812 131.508 51.604 131.508 51.188C131.508 50.804 131.188 50.52 130.548 50.336C130.276 50.264 130.004 50.18 129.732 50.084C129.468 49.98 129.24 49.816 129.048 49.592C128.864 49.36 128.772 49.064 128.772 48.704C128.772 48.12 128.952 47.672 129.312 47.36C129.672 47.04 130.172 46.88 130.812 46.88C131.46 46.88 132.072 46.992 132.648 47.216L132.396 48.464C131.868 48.248 131.352 48.14 130.848 48.14C130.496 48.14 130.32 48.26 130.32 48.5C130.32 48.748 130.556 48.936 131.028 49.064C131.524 49.192 131.964 49.376 132.348 49.616C132.548 49.736 132.716 49.916 132.852 50.156C132.988 50.396 133.056 50.684 133.056 51.02C133.056 51.652 132.844 52.152 132.42 52.52C131.996 52.888 131.412 53.072 130.668 53.072C129.924 53.072 129.26 52.9 128.676 52.556L129.012 51.404Z"
        fill="#94A3B8"
      />
      <rect
        x="25.5"
        y="25.5"
        width="167.215"
        height="47"
        rx="3"
        stroke="#94A3B8"
      />
      <path
        d="M43.375 218.406C43.375 218.232 43.3059 218.065 43.1828 217.942C43.0597 217.819 42.8928 217.75 42.7188 217.75C42.5447 217.75 42.3778 217.819 42.2547 217.942C42.1316 218.065 42.0625 218.232 42.0625 218.406V220.375H43.375V218.406ZM44.3594 221.031H37.1406C37.0536 221.031 36.9701 221.066 36.9086 221.127C36.8471 221.189 36.8125 221.272 36.8125 221.359V222.016C36.8125 222.103 36.8471 222.186 36.9086 222.248C36.9701 222.309 37.0536 222.344 37.1406 222.344H37.4688V223C37.4689 223.756 37.7302 224.489 38.2085 225.075C38.6868 225.661 39.3527 226.064 40.0938 226.216V228.25H41.4062V226.216C42.1473 226.064 42.8132 225.661 43.2915 225.075C43.7698 224.489 44.0311 223.756 44.0312 223V222.344H44.3594C44.4464 222.344 44.5299 222.309 44.5914 222.248C44.6529 222.186 44.6875 222.103 44.6875 222.016V221.359C44.6875 221.272 44.6529 221.189 44.5914 221.127C44.5299 221.066 44.4464 221.031 44.3594 221.031ZM39.4375 218.406C39.4375 218.232 39.3684 218.065 39.2453 217.942C39.1222 217.819 38.9553 217.75 38.7812 217.75C38.6072 217.75 38.4403 217.819 38.3172 217.942C38.1941 218.065 38.125 218.232 38.125 218.406V220.375H39.4375V218.406Z"
        fill="#94A3B8"
      />
      <path
        d="M55.594 227.072C54.362 227.072 53.382 226.68 52.654 225.896C51.926 225.112 51.562 224.068 51.562 222.764C51.562 221.452 51.906 220.412 52.594 219.644C53.29 218.868 54.254 218.48 55.486 218.48C56.302 218.48 57.13 218.624 57.97 218.912L57.754 220.256C57.45 220.144 57.054 220.052 56.566 219.98C56.078 219.9 55.698 219.86 55.426 219.86C54.762 219.86 54.242 220.116 53.866 220.628C53.49 221.132 53.302 221.816 53.302 222.68C53.302 223.544 53.502 224.264 53.902 224.84C54.31 225.408 54.83 225.692 55.462 225.692C55.83 225.692 56.166 225.612 56.47 225.452V223.82H55.078V222.44H58.21V226.424C57.37 226.856 56.498 227.072 55.594 227.072ZM61.5518 223.016V227H59.9798V221H61.2278L61.3718 221.588C61.6918 221.332 61.9598 221.152 62.1758 221.048C62.3918 220.936 62.5798 220.88 62.7398 220.88C62.9078 220.88 63.0198 220.884 63.0758 220.892C63.1318 220.892 63.1798 220.896 63.2198 220.904C63.2598 220.912 63.3278 220.928 63.4238 220.952L63.2798 222.38C63.1358 222.332 62.9398 222.308 62.6918 222.308C62.3558 222.308 61.9758 222.544 61.5518 223.016ZM67.8473 227L67.6073 226.4C67.3273 226.656 67.0793 226.836 66.8633 226.94C66.6473 227.036 66.3873 227.084 66.0833 227.084C65.5713 227.084 65.1233 226.908 64.7393 226.556C64.3633 226.196 64.1753 225.72 64.1753 225.128C64.1753 224.536 64.4073 224.072 64.8713 223.736C65.3353 223.392 66.0353 223.22 66.9713 223.22H67.4633C67.4633 222.876 67.3793 222.6 67.2113 222.392C67.0513 222.184 66.8033 222.08 66.4673 222.08C65.8833 222.08 65.2913 222.16 64.6913 222.32L64.4273 221.264C65.2193 221.008 66.0153 220.88 66.8153 220.88C68.2713 220.88 68.9993 221.56 68.9993 222.92V227H67.8473ZM67.4393 224.372H66.9233C66.4753 224.372 66.1713 224.432 66.0113 224.552C65.8513 224.672 65.7713 224.848 65.7713 225.08C65.7713 225.304 65.8313 225.488 65.9513 225.632C66.0713 225.776 66.2273 225.848 66.4193 225.848C66.6913 225.848 67.0313 225.632 67.4393 225.2V224.372ZM72.2625 229.844H70.7025V221H71.8905L72.1785 221.636C72.4745 221.388 72.7425 221.2 72.9825 221.072C73.2305 220.944 73.5065 220.88 73.8105 220.88C74.4745 220.88 74.9785 221.156 75.3225 221.708C75.6745 222.26 75.8505 223.032 75.8505 224.024C75.8505 225.016 75.6265 225.776 75.1785 226.304C74.7305 226.824 74.2025 227.084 73.5945 227.084C73.1545 227.084 72.7105 226.892 72.2625 226.508V229.844ZM72.2625 222.848V225.044C72.5185 225.46 72.8345 225.668 73.2105 225.668C73.5945 225.668 73.8585 225.532 74.0025 225.26C74.1545 224.988 74.2305 224.572 74.2305 224.012C74.2305 223.452 74.1505 223.02 73.9905 222.716C73.8305 222.412 73.6305 222.26 73.3905 222.26C73.0465 222.26 72.6705 222.456 72.2625 222.848ZM82.3293 227H80.7693V223.412C80.7693 223.084 80.7053 222.82 80.5773 222.62C80.4493 222.412 80.2333 222.308 79.9293 222.308C79.6253 222.308 79.2533 222.492 78.8133 222.86V227H77.2533V218.6H78.8133V221.54C79.1573 221.284 79.4533 221.112 79.7013 221.024C79.9573 220.928 80.2533 220.88 80.5893 220.88C81.1253 220.88 81.5493 221.06 81.8613 221.42C82.1733 221.772 82.3293 222.296 82.3293 222.992V227ZM89.9968 225.668L91.1128 226.82L90.1648 227.768L89.0248 226.556C88.5368 226.908 87.9088 227.084 87.1408 227.084C86.3728 227.084 85.7168 226.88 85.1728 226.472C84.1328 225.712 83.6128 224.468 83.6128 222.74C83.6128 221.484 83.9128 220.46 84.5128 219.668C85.1208 218.876 86.0088 218.48 87.1768 218.48C88.3528 218.48 89.2448 218.876 89.8528 219.668C90.4608 220.46 90.7648 221.472 90.7648 222.704C90.7648 223.928 90.5088 224.916 89.9968 225.668ZM88.3288 223.904L88.7128 224.372C88.9208 223.964 89.0248 223.392 89.0248 222.656C89.0248 221.912 88.8608 221.26 88.5328 220.7C88.2128 220.132 87.7528 219.848 87.1528 219.848C86.5528 219.848 86.1048 220.128 85.8088 220.688C85.5128 221.248 85.3648 221.94 85.3648 222.764C85.3648 223.588 85.5208 224.284 85.8328 224.852C86.1448 225.412 86.5968 225.692 87.1888 225.692C87.5008 225.692 87.7528 225.62 87.9448 225.476L87.3688 224.852L88.3288 223.904ZM96.9492 227H91.9692V218.6H93.7092V225.62H96.9492V227ZM105.345 218.9L105.057 220.304L104.313 220.1C103.785 219.98 103.325 219.92 102.933 219.92C102.389 219.92 102.117 220.18 102.117 220.7C102.117 220.9 102.209 221.084 102.393 221.252C102.585 221.412 102.825 221.548 103.113 221.66C103.401 221.764 103.709 221.896 104.037 222.056C104.365 222.216 104.673 222.388 104.961 222.572C105.249 222.756 105.485 223.008 105.669 223.328C105.861 223.648 105.957 224.016 105.957 224.432C105.957 225.256 105.689 225.904 105.153 226.376C104.625 226.84 103.877 227.072 102.909 227.072C102.413 227.072 101.917 227.008 101.421 226.88C100.933 226.744 100.529 226.588 100.209 226.412L100.725 225.128C101.461 225.464 102.189 225.632 102.909 225.632C103.317 225.632 103.637 225.54 103.869 225.356C104.101 225.164 104.217 224.92 104.217 224.624C104.217 224.328 104.085 224.084 103.821 223.892C103.557 223.692 103.237 223.516 102.861 223.364C102.485 223.204 102.109 223.028 101.733 222.836C101.357 222.636 101.037 222.36 100.773 222.008C100.509 221.648 100.377 221.224 100.377 220.736C100.377 220.008 100.605 219.452 101.061 219.068C101.517 218.676 102.129 218.48 102.897 218.48C103.673 218.48 104.489 218.62 105.345 218.9ZM111.738 226.628C110.978 226.924 110.274 227.072 109.626 227.072C107.746 227.072 106.806 226.056 106.806 224.024C106.806 222.992 107.034 222.212 107.49 221.684C107.946 221.148 108.61 220.88 109.482 220.88C110.202 220.88 110.778 221.104 111.21 221.552C111.642 222 111.858 222.664 111.858 223.544C111.858 223.896 111.842 224.204 111.81 224.468H108.342C108.342 224.94 108.47 225.288 108.726 225.512C108.982 225.736 109.326 225.848 109.758 225.848C110.19 225.848 110.762 225.752 111.474 225.56L111.738 226.628ZM110.358 223.364V223.28C110.358 222.912 110.278 222.616 110.118 222.392C109.958 222.168 109.706 222.056 109.362 222.056C109.018 222.056 108.762 222.18 108.594 222.428C108.426 222.676 108.338 222.988 108.33 223.364H110.358ZM114.884 223.016V227H113.312V221H114.56L114.704 221.588C115.024 221.332 115.292 221.152 115.508 221.048C115.724 220.936 115.912 220.88 116.072 220.88C116.24 220.88 116.352 220.884 116.408 220.892C116.464 220.892 116.512 220.896 116.552 220.904C116.592 220.912 116.66 220.928 116.756 220.952L116.612 222.38C116.468 222.332 116.272 222.308 116.024 222.308C115.688 222.308 115.308 222.544 114.884 223.016ZM122.595 221L120.687 227H118.935L117.039 221H118.659L119.823 225.44L120.999 221H122.595ZM125.089 220.1H123.529V218.6H125.089V220.1ZM125.089 227H123.529V221H125.089V227ZM130.708 225.692L130.9 226.772C130.204 226.972 129.652 227.072 129.244 227.072C128.252 227.072 127.536 226.812 127.096 226.292C126.656 225.772 126.436 225.016 126.436 224.024C126.436 223.024 126.664 222.252 127.12 221.708C127.576 221.156 128.24 220.88 129.112 220.88C129.624 220.88 130.208 220.976 130.864 221.168L130.3 222.26C129.86 222.124 129.496 222.056 129.208 222.056C128.92 222.056 128.692 222.112 128.524 222.224C128.364 222.336 128.248 222.496 128.176 222.704C128.056 223.048 127.996 223.52 127.996 224.12C127.996 224.712 128.12 225.148 128.368 225.428C128.616 225.708 128.976 225.848 129.448 225.848C129.92 225.848 130.34 225.796 130.708 225.692ZM136.512 226.628C135.752 226.924 135.048 227.072 134.4 227.072C132.52 227.072 131.58 226.056 131.58 224.024C131.58 222.992 131.808 222.212 132.264 221.684C132.72 221.148 133.384 220.88 134.256 220.88C134.976 220.88 135.552 221.104 135.984 221.552C136.416 222 136.632 222.664 136.632 223.544C136.632 223.896 136.616 224.204 136.584 224.468H133.116C133.116 224.94 133.244 225.288 133.5 225.512C133.756 225.736 134.1 225.848 134.532 225.848C134.964 225.848 135.536 225.752 136.248 225.56L136.512 226.628ZM135.132 223.364V223.28C135.132 222.912 135.052 222.616 134.892 222.392C134.732 222.168 134.48 222.056 134.136 222.056C133.792 222.056 133.536 222.18 133.368 222.428C133.2 222.676 133.112 222.988 133.104 223.364H135.132ZM137.977 225.404C138.513 225.676 139.061 225.812 139.621 225.812C140.189 225.812 140.473 225.604 140.473 225.188C140.473 224.804 140.153 224.52 139.513 224.336C139.241 224.264 138.969 224.18 138.697 224.084C138.433 223.98 138.205 223.816 138.013 223.592C137.829 223.36 137.737 223.064 137.737 222.704C137.737 222.12 137.917 221.672 138.277 221.36C138.637 221.04 139.137 220.88 139.777 220.88C140.425 220.88 141.037 220.992 141.613 221.216L141.361 222.464C140.833 222.248 140.317 222.14 139.813 222.14C139.461 222.14 139.285 222.26 139.285 222.5C139.285 222.748 139.521 222.936 139.993 223.064C140.489 223.192 140.929 223.376 141.313 223.616C141.513 223.736 141.681 223.916 141.817 224.156C141.953 224.396 142.021 224.684 142.021 225.02C142.021 225.652 141.809 226.152 141.385 226.52C140.961 226.888 140.377 227.072 139.633 227.072C138.889 227.072 138.225 226.9 137.641 226.556L137.977 225.404Z"
        fill="#94A3B8"
      />
      <rect
        x="25.5"
        y="199.5"
        width="167.215"
        height="47"
        rx="3"
        stroke="#94A3B8"
      />
      <path
        d="M45.3438 132.25V133.187C45.3438 134.014 43.2861 134.688 40.75 134.688C38.2139 134.688 36.1562 134.014 36.1562 133.187V132.25C36.1562 131.424 38.2139 130.75 40.75 130.75C43.2861 130.75 45.3438 131.424 45.3438 132.25ZM45.3438 134.359V136.469C45.3438 137.295 43.2861 137.969 40.75 137.969C38.2139 137.969 36.1562 137.295 36.1562 136.469V134.359C37.1432 135.039 38.9496 135.355 40.75 135.355C42.5504 135.355 44.3568 135.039 45.3438 134.359ZM45.3438 137.641V139.75C45.3438 140.576 43.2861 141.25 40.75 141.25C38.2139 141.25 36.1562 140.576 36.1562 139.75V137.641C37.1432 138.32 38.9496 138.637 40.75 138.637C42.5504 138.637 44.3568 138.32 45.3438 137.641Z"
        fill="#94A3B8"
      />
      <path
        d="M58.654 135.5C58.654 136.852 58.262 137.94 57.478 138.764C56.694 139.588 55.646 140 54.334 140H52.102V131.6H54.706C55.898 131.6 56.854 131.964 57.574 132.692C58.294 133.42 58.654 134.356 58.654 135.5ZM56.842 135.404C56.842 134.652 56.638 134.06 56.23 133.628C55.822 133.196 55.33 132.98 54.754 132.98H53.794V138.62H54.442C55.114 138.62 55.682 138.336 56.146 137.768C56.61 137.192 56.842 136.404 56.842 135.404ZM63.1715 140L62.9315 139.4C62.6515 139.656 62.4035 139.836 62.1875 139.94C61.9715 140.036 61.7115 140.084 61.4075 140.084C60.8955 140.084 60.4475 139.908 60.0635 139.556C59.6875 139.196 59.4995 138.72 59.4995 138.128C59.4995 137.536 59.7315 137.072 60.1955 136.736C60.6595 136.392 61.3595 136.22 62.2955 136.22H62.7875C62.7875 135.876 62.7035 135.6 62.5355 135.392C62.3755 135.184 62.1275 135.08 61.7915 135.08C61.2075 135.08 60.6155 135.16 60.0155 135.32L59.7515 134.264C60.5435 134.008 61.3395 133.88 62.1395 133.88C63.5955 133.88 64.3235 134.56 64.3235 135.92V140H63.1715ZM62.7635 137.372H62.2475C61.7995 137.372 61.4955 137.432 61.3355 137.552C61.1755 137.672 61.0955 137.848 61.0955 138.08C61.0955 138.304 61.1555 138.488 61.2755 138.632C61.3955 138.776 61.5515 138.848 61.7435 138.848C62.0155 138.848 62.3555 138.632 62.7635 138.2V137.372ZM65.9667 138.704V135.32H65.3547V134H65.9787V132.284H67.5267V134H68.7867V135.32H67.5147V137.936C67.5147 138.472 67.6787 138.74 68.0067 138.74C68.1907 138.74 68.3867 138.716 68.5947 138.668L68.8467 139.916C68.4787 140.02 68.0867 140.072 67.6707 140.072C67.2627 140.072 66.8747 139.968 66.5067 139.76C66.1467 139.544 65.9667 139.192 65.9667 138.704ZM73.3551 140L73.1151 139.4C72.8351 139.656 72.5871 139.836 72.3711 139.94C72.1551 140.036 71.8951 140.084 71.5911 140.084C71.0791 140.084 70.6311 139.908 70.2471 139.556C69.8711 139.196 69.6831 138.72 69.6831 138.128C69.6831 137.536 69.9151 137.072 70.3791 136.736C70.8431 136.392 71.5431 136.22 72.4791 136.22H72.9711C72.9711 135.876 72.8871 135.6 72.7191 135.392C72.5591 135.184 72.3111 135.08 71.9751 135.08C71.3911 135.08 70.7991 135.16 70.1991 135.32L69.9351 134.264C70.7271 134.008 71.5231 133.88 72.3231 133.88C73.7791 133.88 74.5071 134.56 74.5071 135.92V140H73.3551ZM72.9471 137.372H72.4311C71.9831 137.372 71.6791 137.432 71.5191 137.552C71.3591 137.672 71.2791 137.848 71.2791 138.08C71.2791 138.304 71.3391 138.488 71.4591 138.632C71.5791 138.776 71.7351 138.848 71.9271 138.848C72.1991 138.848 72.5391 138.632 72.9471 138.2V137.372ZM79.3663 133.88C79.9823 133.88 80.4743 134.144 80.8423 134.672C81.2183 135.192 81.4063 135.948 81.4063 136.94C81.4063 137.924 81.1943 138.68 80.7703 139.208C80.3463 139.736 79.8023 140 79.1383 140C78.6263 140 78.1223 139.776 77.6263 139.328L77.3983 140H76.2103V131.6H77.7703V134.552C78.3863 134.104 78.9183 133.88 79.3663 133.88ZM79.8703 136.94C79.8703 135.828 79.5343 135.272 78.8623 135.272C78.5583 135.272 78.1943 135.452 77.7703 135.812V138.128C78.1943 138.488 78.5543 138.668 78.8503 138.668C79.1543 138.668 79.3983 138.524 79.5823 138.236C79.7743 137.948 79.8703 137.516 79.8703 136.94ZM85.8708 140L85.6308 139.4C85.3508 139.656 85.1028 139.836 84.8867 139.94C84.6708 140.036 84.4108 140.084 84.1068 140.084C83.5948 140.084 83.1468 139.908 82.7628 139.556C82.3868 139.196 82.1988 138.72 82.1988 138.128C82.1988 137.536 82.4308 137.072 82.8948 136.736C83.3588 136.392 84.0588 136.22 84.9948 136.22H85.4868C85.4868 135.876 85.4028 135.6 85.2348 135.392C85.0748 135.184 84.8268 135.08 84.4908 135.08C83.9068 135.08 83.3148 135.16 82.7148 135.32L82.4508 134.264C83.2428 134.008 84.0388 133.88 84.8388 133.88C86.2948 133.88 87.0228 134.56 87.0228 135.92V140H85.8708ZM85.4628 137.372H84.9468C84.4988 137.372 84.1948 137.432 84.0348 137.552C83.8748 137.672 83.7948 137.848 83.7948 138.08C83.7948 138.304 83.8548 138.488 83.9748 138.632C84.0948 138.776 84.2508 138.848 84.4428 138.848C84.7148 138.848 85.0548 138.632 85.4628 138.2V137.372ZM88.6179 138.404C89.1539 138.676 89.7019 138.812 90.2619 138.812C90.8299 138.812 91.1139 138.604 91.1139 138.188C91.1139 137.804 90.7939 137.52 90.1539 137.336C89.8819 137.264 89.6099 137.18 89.3379 137.084C89.0739 136.98 88.8459 136.816 88.6539 136.592C88.4699 136.36 88.3779 136.064 88.3779 135.704C88.3779 135.12 88.5579 134.672 88.9179 134.36C89.2779 134.04 89.7779 133.88 90.4179 133.88C91.0659 133.88 91.6779 133.992 92.2539 134.216L92.0019 135.464C91.4739 135.248 90.9579 135.14 90.4539 135.14C90.1019 135.14 89.9259 135.26 89.9259 135.5C89.9259 135.748 90.1619 135.936 90.6339 136.064C91.1299 136.192 91.5699 136.376 91.9539 136.616C92.1539 136.736 92.3219 136.916 92.4579 137.156C92.5939 137.396 92.6619 137.684 92.6619 138.02C92.6619 138.652 92.4499 139.152 92.0259 139.52C91.6019 139.888 91.0179 140.072 90.2739 140.072C89.5299 140.072 88.8659 139.9 88.2819 139.556L88.6179 138.404ZM98.4259 139.628C97.6659 139.924 96.9619 140.072 96.3139 140.072C94.4339 140.072 93.4939 139.056 93.4939 137.024C93.4939 135.992 93.7219 135.212 94.1779 134.684C94.6339 134.148 95.2979 133.88 96.1699 133.88C96.8899 133.88 97.4659 134.104 97.8979 134.552C98.3299 135 98.5459 135.664 98.5459 136.544C98.5459 136.896 98.5299 137.204 98.4979 137.468H95.0299C95.0299 137.94 95.1579 138.288 95.4139 138.512C95.6699 138.736 96.0139 138.848 96.4459 138.848C96.8779 138.848 97.4499 138.752 98.1619 138.56L98.4259 139.628ZM97.0459 136.364V136.28C97.0459 135.912 96.9659 135.616 96.8059 135.392C96.6459 135.168 96.3939 135.056 96.0499 135.056C95.7059 135.056 95.4499 135.18 95.2819 135.428C95.1139 135.676 95.0259 135.988 95.0179 136.364H97.0459ZM99.8913 138.404C100.427 138.676 100.975 138.812 101.535 138.812C102.103 138.812 102.387 138.604 102.387 138.188C102.387 137.804 102.067 137.52 101.427 137.336C101.155 137.264 100.883 137.18 100.611 137.084C100.347 136.98 100.119 136.816 99.9273 136.592C99.7433 136.36 99.6513 136.064 99.6513 135.704C99.6513 135.12 99.8313 134.672 100.191 134.36C100.551 134.04 101.051 133.88 101.691 133.88C102.339 133.88 102.951 133.992 103.527 134.216L103.275 135.464C102.747 135.248 102.231 135.14 101.727 135.14C101.375 135.14 101.199 135.26 101.199 135.5C101.199 135.748 101.435 135.936 101.907 136.064C102.403 136.192 102.843 136.376 103.227 136.616C103.427 136.736 103.595 136.916 103.731 137.156C103.867 137.396 103.935 137.684 103.935 138.02C103.935 138.652 103.723 139.152 103.299 139.52C102.875 139.888 102.291 140.072 101.547 140.072C100.803 140.072 100.139 139.9 99.5553 139.556L99.8913 138.404Z"
        fill="#94A3B8"
      />
      <rect
        x="25.5"
        y="112.5"
        width="167.215"
        height="47"
        rx="3"
        stroke="#94A3B8"
      />
      <path
        d="M197.215 49H228.849C242.103 49 252.849 59.7452 252.849 73V112C252.849 125.255 263.594 136 276.849 136H308.482"
        stroke="#CBD5E1"
        strokeWidth="2"
        strokeMiterlimit="0"
        strokeLinecap="round"
        strokeLinejoin="bevel"
      />
      <path
        d="M387.573 136H394.001C407.255 136 418.001 125.255 418.001 112V73C418.001 59.7452 428.746 49 442.001 49H655.785"
        stroke="#94A3B8"
        strokeWidth="2"
        strokeMiterlimit="0"
        strokeLinecap="round"
        strokeLinejoin="bevel"
      />
      <path
        d="M387.573 136H655.785"
        stroke="#94A3B8"
        strokeWidth="2"
        strokeMiterlimit="0"
        strokeLinecap="round"
        strokeLinejoin="bevel"
      />
      <path
        d="M387.573 136H394.001C407.255 136 418.001 146.745 418.001 160V199C418.001 212.255 428.746 223 442.001 223H655.785"
        stroke="#94A3B8"
        strokeWidth="2"
        strokeMiterlimit="0"
        strokeLinecap="round"
        strokeLinejoin="bevel"
      />
      <path
        d="M197.215 223H228.849C242.103 223 252.849 212.255 252.849 199V160C252.849 146.745 263.594 136 276.849 136H308.482"
        stroke="#CBD5E1"
        strokeWidth="2"
        strokeMiterlimit="0"
        strokeLinecap="round"
        strokeLinejoin="bevel"
      />
      <path
        d="M197.215 136H308.482"
        stroke="#CBD5E1"
        strokeWidth="2"
        strokeMiterlimit="0"
        strokeLinecap="round"
      />
      <g filter="url(#filter2_dd_571_46831)">
        <ellipse cx="395.622" cy="136" rx="4.00512" ry="4" fill="#F59E0B" />
        <path
          d="M399.127 136C399.127 137.932 397.559 139.5 395.622 139.5C393.686 139.5 392.117 137.932 392.117 136C392.117 134.068 393.686 132.5 395.622 132.5C397.559 132.5 399.127 134.068 399.127 136Z"
          stroke="#F59E0B"
        />
      </g>
      <g filter="url(#filter3_dd_571_46831)">
        <ellipse cx="464.751" cy="136" rx="4.00512" ry="4" fill="#F59E0B" />
        <path
          d="M468.256 136C468.256 137.932 466.688 139.5 464.751 139.5C462.815 139.5 461.246 137.932 461.246 136C461.246 134.068 462.815 132.5 464.751 132.5C466.688 132.5 468.256 134.068 468.256 136Z"
          stroke="#F59E0B"
        />
      </g>
      <g filter="url(#filter4_dd_571_46831)">
        <ellipse cx="418.679" cy="86" rx="4.00512" ry="4" fill="#F59E0B" />
        <path
          d="M422.184 86C422.184 87.9324 420.615 89.5 418.679 89.5C416.743 89.5 415.174 87.9324 415.174 86C415.174 84.0676 416.743 82.5 418.679 82.5C420.615 82.5 422.184 84.0676 422.184 86Z"
          stroke="#F59E0B"
        />
      </g>
      <g filter="url(#filter5_dd_571_46831)">
        <ellipse cx="449.044" cy="50" rx="4.00512" ry="4" fill="#F59E0B" />
        <path
          d="M452.549 50C452.549 51.9324 450.981 53.5 449.044 53.5C447.108 53.5 445.539 51.9324 445.539 50C445.539 48.0676 447.108 46.5 449.044 46.5C450.981 46.5 452.549 48.0676 452.549 50Z"
          stroke="#F59E0B"
        />
      </g>
      <g filter="url(#filter6_dd_571_46831)">
        <ellipse cx="455.005" cy="223" rx="4.00512" ry="4" fill="#F59E0B" />
        <path
          d="M458.51 223C458.51 224.932 456.942 226.5 455.005 226.5C453.069 226.5 451.5 224.932 451.5 223C451.5 221.068 453.069 219.5 455.005 219.5C456.942 219.5 458.51 221.068 458.51 223Z"
          stroke="#F59E0B"
        />
      </g>
      <g filter="url(#filter7_dd_571_46831)">
        <ellipse cx="418.679" cy="188" rx="4.00512" ry="4" fill="#F59E0B" />
        <path
          d="M422.184 188C422.184 189.932 420.615 191.5 418.679 191.5C416.743 191.5 415.174 189.932 415.174 188C415.174 186.068 416.743 184.5 418.679 184.5C420.615 184.5 422.184 186.068 422.184 188Z"
          stroke="#F59E0B"
        />
      </g>
      <rect
        x="656"
        y="36"
        width="211"
        height="212"
        transform="rotate(90 656 36)"
        fill="url(#paint0_linear_571_46831)"
      />
      <rect x="1" y="1" width="671" height="270" rx="2" stroke="#CBD5E1" />
      <defs>
        <filter
          id="filter0_dd_571_46831"
          x="309.482"
          y="107"
          width="60.0693"
          height="60"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_571_46831"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_571_46831"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_571_46831"
            result="effect2_dropShadow_571_46831"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_571_46831"
            result="shape"
          />
        </filter>
        <filter
          id="filter1_dd_571_46831"
          x="354.54"
          y="121"
          width="32.0332"
          height="32"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_571_46831"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_571_46831"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_571_46831"
            result="effect2_dropShadow_571_46831"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_571_46831"
            result="shape"
          />
        </filter>
        <filter
          id="filter2_dd_571_46831"
          x="388.617"
          y="130"
          width="14.0098"
          height="14"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_571_46831"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_571_46831"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_571_46831"
            result="effect2_dropShadow_571_46831"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_571_46831"
            result="shape"
          />
        </filter>
        <filter
          id="filter3_dd_571_46831"
          x="457.746"
          y="130"
          width="14.0098"
          height="14"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_571_46831"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_571_46831"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_571_46831"
            result="effect2_dropShadow_571_46831"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_571_46831"
            result="shape"
          />
        </filter>
        <filter
          id="filter4_dd_571_46831"
          x="411.674"
          y="80"
          width="14.0098"
          height="14"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_571_46831"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_571_46831"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_571_46831"
            result="effect2_dropShadow_571_46831"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_571_46831"
            result="shape"
          />
        </filter>
        <filter
          id="filter5_dd_571_46831"
          x="442.039"
          y="44"
          width="14.0098"
          height="14"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_571_46831"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_571_46831"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_571_46831"
            result="effect2_dropShadow_571_46831"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_571_46831"
            result="shape"
          />
        </filter>
        <filter
          id="filter6_dd_571_46831"
          x="448"
          y="217"
          width="14.0098"
          height="14"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_571_46831"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_571_46831"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_571_46831"
            result="effect2_dropShadow_571_46831"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_571_46831"
            result="shape"
          />
        </filter>
        <filter
          id="filter7_dd_571_46831"
          x="411.674"
          y="182"
          width="14.0098"
          height="14"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feMorphology
            radius="1"
            operator="erode"
            in="SourceAlpha"
            result="effect1_dropShadow_571_46831"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.980392 0 0 0 0 0.811765 0 0 0 0 0.411765 0 0 0 0.1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_571_46831"
          />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1.5" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.976471 0 0 0 0 0.772549 0 0 0 0 0.282353 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="effect1_dropShadow_571_46831"
            result="effect2_dropShadow_571_46831"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect2_dropShadow_571_46831"
            result="shape"
          />
        </filter>
        <linearGradient
          id="paint0_linear_571_46831"
          x1="761.5"
          y1="36"
          x2="761.5"
          y2="248"
          gradientUnits="userSpaceOnUse"
        >
          <stop stop-color="#E2E8F0" />
          <stop offset="0.739583" stop-color="#E2E8F0" stop-opacity="0.75" />
          <stop offset="1" stop-color="#E2E8F0" stop-opacity="0" />
        </linearGradient>
        <clipPath id="clip0_571_46831">
          <rect
            width="24"
            height="24"
            fill="white"
            transform="translate(327.517 124)"
          />
        </clipPath>
      </defs>
    </svg>
  );
}
