import React from 'react';

type Props = {
  className?: string;
};

export function ApiSecuritySvg(props: Props) {
  const { className } = props;
  return (
    <svg
      className={className}
      width="690"
      height="271"
      viewBox="0 0 690 271"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <rect x="1" y="0.5" width="671" height="270" rx="2" fill="#E2E8F0" />
      <g filter="url(#filter0_d_768_38002)">
        <rect
          x="312.482"
          y="108.5"
          width="54.0691"
          height="54"
          rx="3.5"
          fill="white"
          shapeRendering="crispEdges"
        />
        <g clipPath="url(#clip0_768_38002)">
          <path
            d="M351.137 131.672C351.849 129.521 351.421 125.225 350.04 123.639C349.86 123.432 349.52 123.462 349.371 123.69L347.668 126.279C347.247 126.798 346.489 126.916 345.92 126.555C344.074 125.385 341.868 124.703 339.497 124.703C337.125 124.703 334.919 125.385 333.073 126.555C332.504 126.916 331.746 126.795 331.325 126.279L329.622 123.69C329.473 123.462 329.134 123.432 328.953 123.639C327.572 125.225 327.144 129.521 327.856 131.672C328.091 132.386 328.159 133.142 328.018 133.879C327.881 134.608 327.74 135.491 327.74 136.102C327.74 142.395 333.006 147.5 339.497 147.5C345.991 147.5 351.253 142.398 351.253 136.102C351.253 135.488 351.116 134.608 350.975 133.879C350.834 133.142 350.902 132.386 351.137 131.672ZM339.497 144.952C334.479 144.952 330.396 140.993 330.396 136.128C330.396 135.968 330.402 135.811 330.408 135.654C330.591 132.339 332.666 129.503 335.606 128.152C336.786 127.607 338.106 127.305 339.497 127.305C340.887 127.305 342.207 127.61 343.39 128.155C346.33 129.506 348.405 132.342 348.588 135.654C348.597 135.811 348.6 135.968 348.6 136.128C348.597 140.993 344.514 144.952 339.497 144.952Z"
            fill="black"
          />
          <path
            d="M343.439 139.524L341.113 135.616L339.118 132.356C339.072 132.279 338.986 132.232 338.892 132.232H336.985C336.89 132.232 336.804 132.282 336.758 132.359C336.713 132.439 336.713 132.537 336.762 132.614L338.668 135.725L336.108 139.512C336.056 139.589 336.049 139.69 336.095 139.773C336.141 139.856 336.23 139.906 336.325 139.906H338.244C338.332 139.906 338.415 139.862 338.464 139.79L339.848 137.693L341.089 139.779C341.135 139.859 341.223 139.906 341.315 139.906H343.207C343.301 139.906 343.387 139.859 343.433 139.779C343.488 139.699 343.488 139.604 343.439 139.524Z"
            fill="black"
          />
        </g>
      </g>
      <rect x="359" y="123" width="24" height="24" rx="12" fill="white" />
      <path
        d="M375.111 131.635L371.361 130.072C371.247 130.025 371.125 130 371.001 130C370.877 130 370.755 130.025 370.641 130.072L366.891 131.635C366.541 131.779 366.312 132.121 366.312 132.5C366.312 136.377 368.549 139.057 370.639 139.928C370.869 140.023 371.129 140.023 371.359 139.928C373.033 139.23 375.688 136.822 375.688 132.5C375.688 132.121 375.459 131.779 375.111 131.635ZM371.002 138.717L371 131.275L374.436 132.707C374.371 135.664 372.832 137.807 371.002 138.717V138.717Z"
        fill="#64748B"
      />
      <rect
        x="359"
        y="123"
        width="24"
        height="24"
        rx="12"
        stroke="#E2E8F0"
        strokeWidth="2"
      />
      <g filter="url(#filter1_d_768_38002)">
        <rect
          x="25"
          y="24.5"
          width="168.215"
          height="48"
          rx="3.5"
          fill="white"
          shapeRendering="crispEdges"
        />
        <path
          d="M43.5393 46.5312H41.1727L42.0463 43.8693C42.1283 43.5576 41.8925 43.25 41.5705 43.25H38.6174C38.3713 43.25 38.1621 43.4325 38.1293 43.6766L37.4731 48.5984C37.4341 48.8937 37.6638 49.1562 37.9612 49.1562H40.3954L39.45 53.145C39.3762 53.4567 39.6141 53.75 39.9279 53.75C40.1001 53.75 40.2642 53.6598 40.3544 53.5039L43.9638 47.2695C44.1545 46.9435 43.9187 46.5312 43.5393 46.5312Z"
          fill="#0F172A"
        />
        <path
          d="M53.986 48.852H53.842V52.488H52.102V44.088H54.766C55.67 44.088 56.346 44.288 56.794 44.688C57.242 45.08 57.466 45.644 57.466 46.38C57.466 46.828 57.31 47.24 56.998 47.616C56.686 47.984 56.306 48.196 55.858 48.252C56.178 48.34 56.426 48.488 56.602 48.696C56.778 48.896 56.962 49.224 57.154 49.68L58.342 52.488H56.554L55.39 49.8C55.222 49.416 55.042 49.164 54.85 49.044C54.666 48.916 54.378 48.852 53.986 48.852ZM54.718 45.456H53.842V47.484H54.598C54.918 47.484 55.166 47.38 55.342 47.172C55.526 46.964 55.618 46.708 55.618 46.404C55.618 45.772 55.318 45.456 54.718 45.456ZM64.3365 52.5H59.3325V44.1H64.3365V45.48H61.0725V47.244H64.0365V48.648H61.0725V51.12H64.3365V52.5ZM70.5404 44.4L70.2524 45.804L69.5084 45.6C68.9804 45.48 68.5204 45.42 68.1284 45.42C67.5844 45.42 67.3124 45.68 67.3124 46.2C67.3124 46.4 67.4044 46.584 67.5884 46.752C67.7804 46.912 68.0204 47.048 68.3084 47.16C68.5964 47.264 68.9044 47.396 69.2324 47.556C69.5604 47.716 69.8684 47.888 70.1564 48.072C70.4444 48.256 70.6804 48.508 70.8644 48.828C71.0564 49.148 71.1524 49.516 71.1524 49.932C71.1524 50.756 70.8844 51.404 70.3484 51.876C69.8204 52.34 69.0724 52.572 68.1044 52.572C67.6084 52.572 67.1124 52.508 66.6164 52.38C66.1284 52.244 65.7244 52.088 65.4044 51.912L65.9204 50.628C66.6564 50.964 67.3844 51.132 68.1044 51.132C68.5124 51.132 68.8324 51.04 69.0644 50.856C69.2964 50.664 69.4124 50.42 69.4124 50.124C69.4124 49.828 69.2804 49.584 69.0164 49.392C68.7524 49.192 68.4324 49.016 68.0564 48.864C67.6804 48.704 67.3044 48.528 66.9284 48.336C66.5524 48.136 66.2324 47.86 65.9684 47.508C65.7044 47.148 65.5724 46.724 65.5724 46.236C65.5724 45.508 65.8004 44.952 66.2564 44.568C66.7124 44.176 67.3244 43.98 68.0924 43.98C68.8684 43.98 69.6844 44.12 70.5404 44.4ZM73.7658 52.5V45.504H71.8338V44.1H77.4018V45.504H75.4938V52.5H73.7658ZM86.4966 52.5H81.4926V44.1H86.4966V45.48H83.2326V47.244H86.1966V48.648H83.2326V51.12H86.4966V52.5ZM93.2045 52.5H91.6205V48.912C91.6205 48.584 91.5565 48.32 91.4285 48.12C91.3005 47.912 91.0885 47.808 90.7925 47.808C90.4965 47.808 90.1285 47.992 89.6885 48.36V52.5H88.1165V46.5H89.4365L89.6885 47.04C90.0325 46.784 90.3285 46.612 90.5765 46.524C90.8325 46.428 91.1285 46.38 91.4645 46.38C92.0005 46.38 92.4245 46.56 92.7365 46.92C93.0485 47.272 93.2045 47.796 93.2045 48.492V52.5ZM99.6958 52.5H98.5198L98.2798 51.816C97.6078 52.32 96.9958 52.572 96.4438 52.572C95.8998 52.572 95.4478 52.316 95.0878 51.804C94.7358 51.284 94.5598 50.52 94.5598 49.512C94.5598 48.496 94.7598 47.72 95.1598 47.184C95.5678 46.648 96.0998 46.38 96.7558 46.38C97.1878 46.38 97.6518 46.58 98.1478 46.98V44.1H99.6958V52.5ZM98.1358 50.652V48.264C97.7118 47.912 97.3558 47.736 97.0678 47.736C96.7798 47.736 96.5478 47.884 96.3718 48.18C96.2038 48.476 96.1198 48.916 96.1198 49.5C96.1198 50.62 96.4238 51.18 97.0318 51.18C97.3438 51.18 97.7118 51.004 98.1358 50.652ZM103.212 55.344H101.652V46.5H102.84L103.128 47.136C103.424 46.888 103.692 46.7 103.932 46.572C104.18 46.444 104.456 46.38 104.76 46.38C105.424 46.38 105.928 46.656 106.272 47.208C106.624 47.76 106.8 48.532 106.8 49.524C106.8 50.516 106.576 51.276 106.128 51.804C105.68 52.324 105.152 52.584 104.544 52.584C104.104 52.584 103.66 52.392 103.212 52.008V55.344ZM103.212 48.348V50.544C103.468 50.96 103.784 51.168 104.16 51.168C104.544 51.168 104.808 51.032 104.952 50.76C105.104 50.488 105.18 50.072 105.18 49.512C105.18 48.952 105.1 48.52 104.94 48.216C104.78 47.912 104.58 47.76 104.34 47.76C103.996 47.76 103.62 47.956 103.212 48.348ZM113.158 49.512C113.158 50.472 112.914 51.224 112.426 51.768C111.938 52.312 111.246 52.584 110.35 52.584C109.454 52.584 108.774 52.312 108.31 51.768C107.846 51.224 107.614 50.468 107.614 49.5C107.614 48.532 107.846 47.772 108.31 47.22C108.774 46.66 109.442 46.38 110.314 46.38C111.186 46.38 111.878 46.664 112.39 47.232C112.902 47.792 113.158 48.552 113.158 49.512ZM111.562 49.488C111.562 48.264 111.17 47.652 110.386 47.652C109.586 47.652 109.186 48.26 109.186 49.476C109.186 50.692 109.59 51.3 110.398 51.3C110.83 51.3 111.13 51.148 111.298 50.844C111.474 50.532 111.562 50.08 111.562 49.488ZM116.043 45.6H114.483V44.1H116.043V45.6ZM116.043 52.5H114.483V46.5H116.043V52.5ZM123.029 52.5H121.445V48.912C121.445 48.584 121.381 48.32 121.253 48.12C121.125 47.912 120.913 47.808 120.617 47.808C120.321 47.808 119.953 47.992 119.513 48.36V52.5H117.941V46.5H119.261L119.513 47.04C119.857 46.784 120.153 46.612 120.401 46.524C120.657 46.428 120.953 46.38 121.289 46.38C121.825 46.38 122.249 46.56 122.561 46.92C122.873 47.272 123.029 47.796 123.029 48.492V52.5ZM124.912 51.204V47.82H124.3V46.5H124.924V44.784H126.472V46.5H127.732V47.82H126.46V50.436C126.46 50.972 126.624 51.24 126.952 51.24C127.136 51.24 127.332 51.216 127.54 51.168L127.792 52.416C127.424 52.52 127.032 52.572 126.616 52.572C126.208 52.572 125.82 52.468 125.452 52.26C125.092 52.044 124.912 51.692 124.912 51.204ZM129.012 50.904C129.548 51.176 130.096 51.312 130.656 51.312C131.224 51.312 131.508 51.104 131.508 50.688C131.508 50.304 131.188 50.02 130.548 49.836C130.276 49.764 130.004 49.68 129.732 49.584C129.468 49.48 129.24 49.316 129.048 49.092C128.864 48.86 128.772 48.564 128.772 48.204C128.772 47.62 128.952 47.172 129.312 46.86C129.672 46.54 130.172 46.38 130.812 46.38C131.46 46.38 132.072 46.492 132.648 46.716L132.396 47.964C131.868 47.748 131.352 47.64 130.848 47.64C130.496 47.64 130.32 47.76 130.32 48C130.32 48.248 130.556 48.436 131.028 48.564C131.524 48.692 131.964 48.876 132.348 49.116C132.548 49.236 132.716 49.416 132.852 49.656C132.988 49.896 133.056 50.184 133.056 50.52C133.056 51.152 132.844 51.652 132.42 52.02C131.996 52.388 131.412 52.572 130.668 52.572C129.924 52.572 129.26 52.4 128.676 52.056L129.012 50.904Z"
          fill="#0F172A"
        />
      </g>
      <g filter="url(#filter2_d_768_38002)">
        <rect
          x="25"
          y="198.5"
          width="168.215"
          height="48"
          rx="3.5"
          fill="white"
          shapeRendering="crispEdges"
        />
        <path
          d="M43.375 217.906C43.375 217.732 43.3059 217.565 43.1828 217.442C43.0597 217.319 42.8928 217.25 42.7188 217.25C42.5447 217.25 42.3778 217.319 42.2547 217.442C42.1316 217.565 42.0625 217.732 42.0625 217.906V219.875H43.375V217.906ZM44.3594 220.531H37.1406C37.0536 220.531 36.9701 220.566 36.9086 220.627C36.8471 220.689 36.8125 220.772 36.8125 220.859V221.516C36.8125 221.603 36.8471 221.686 36.9086 221.748C36.9701 221.809 37.0536 221.844 37.1406 221.844H37.4688V222.5C37.4689 223.256 37.7302 223.989 38.2085 224.575C38.6868 225.161 39.3527 225.564 40.0938 225.716V227.75H41.4062V225.716C42.1473 225.564 42.8132 225.161 43.2915 224.575C43.7698 223.989 44.0311 223.256 44.0312 222.5V221.844H44.3594C44.4464 221.844 44.5299 221.809 44.5914 221.748C44.6529 221.686 44.6875 221.603 44.6875 221.516V220.859C44.6875 220.772 44.6529 220.689 44.5914 220.627C44.5299 220.566 44.4464 220.531 44.3594 220.531ZM39.4375 217.906C39.4375 217.732 39.3684 217.565 39.2453 217.442C39.1222 217.319 38.9553 217.25 38.7812 217.25C38.6072 217.25 38.4403 217.319 38.3172 217.442C38.1941 217.565 38.125 217.732 38.125 217.906V219.875H39.4375V217.906Z"
          fill="#0F172A"
        />
        <path
          d="M55.594 226.572C54.362 226.572 53.382 226.18 52.654 225.396C51.926 224.612 51.562 223.568 51.562 222.264C51.562 220.952 51.906 219.912 52.594 219.144C53.29 218.368 54.254 217.98 55.486 217.98C56.302 217.98 57.13 218.124 57.97 218.412L57.754 219.756C57.45 219.644 57.054 219.552 56.566 219.48C56.078 219.4 55.698 219.36 55.426 219.36C54.762 219.36 54.242 219.616 53.866 220.128C53.49 220.632 53.302 221.316 53.302 222.18C53.302 223.044 53.502 223.764 53.902 224.34C54.31 224.908 54.83 225.192 55.462 225.192C55.83 225.192 56.166 225.112 56.47 224.952V223.32H55.078V221.94H58.21V225.924C57.37 226.356 56.498 226.572 55.594 226.572ZM61.5518 222.516V226.5H59.9798V220.5H61.2278L61.3718 221.088C61.6918 220.832 61.9598 220.652 62.1758 220.548C62.3918 220.436 62.5798 220.38 62.7398 220.38C62.9078 220.38 63.0198 220.384 63.0758 220.392C63.1318 220.392 63.1798 220.396 63.2198 220.404C63.2598 220.412 63.3278 220.428 63.4238 220.452L63.2798 221.88C63.1358 221.832 62.9398 221.808 62.6918 221.808C62.3558 221.808 61.9758 222.044 61.5518 222.516ZM67.8473 226.5L67.6073 225.9C67.3273 226.156 67.0793 226.336 66.8633 226.44C66.6473 226.536 66.3873 226.584 66.0833 226.584C65.5713 226.584 65.1233 226.408 64.7393 226.056C64.3633 225.696 64.1753 225.22 64.1753 224.628C64.1753 224.036 64.4073 223.572 64.8713 223.236C65.3353 222.892 66.0353 222.72 66.9713 222.72H67.4633C67.4633 222.376 67.3793 222.1 67.2113 221.892C67.0513 221.684 66.8033 221.58 66.4673 221.58C65.8833 221.58 65.2913 221.66 64.6913 221.82L64.4273 220.764C65.2193 220.508 66.0153 220.38 66.8153 220.38C68.2713 220.38 68.9993 221.06 68.9993 222.42V226.5H67.8473ZM67.4393 223.872H66.9233C66.4753 223.872 66.1713 223.932 66.0113 224.052C65.8513 224.172 65.7713 224.348 65.7713 224.58C65.7713 224.804 65.8313 224.988 65.9513 225.132C66.0713 225.276 66.2273 225.348 66.4193 225.348C66.6913 225.348 67.0313 225.132 67.4393 224.7V223.872ZM72.2625 229.344H70.7025V220.5H71.8905L72.1785 221.136C72.4745 220.888 72.7425 220.7 72.9825 220.572C73.2305 220.444 73.5065 220.38 73.8105 220.38C74.4745 220.38 74.9785 220.656 75.3225 221.208C75.6745 221.76 75.8505 222.532 75.8505 223.524C75.8505 224.516 75.6265 225.276 75.1785 225.804C74.7305 226.324 74.2025 226.584 73.5945 226.584C73.1545 226.584 72.7105 226.392 72.2625 226.008V229.344ZM72.2625 222.348V224.544C72.5185 224.96 72.8345 225.168 73.2105 225.168C73.5945 225.168 73.8585 225.032 74.0025 224.76C74.1545 224.488 74.2305 224.072 74.2305 223.512C74.2305 222.952 74.1505 222.52 73.9905 222.216C73.8305 221.912 73.6305 221.76 73.3905 221.76C73.0465 221.76 72.6705 221.956 72.2625 222.348ZM82.3293 226.5H80.7693V222.912C80.7693 222.584 80.7053 222.32 80.5773 222.12C80.4493 221.912 80.2333 221.808 79.9293 221.808C79.6253 221.808 79.2533 221.992 78.8133 222.36V226.5H77.2533V218.1H78.8133V221.04C79.1573 220.784 79.4533 220.612 79.7013 220.524C79.9573 220.428 80.2533 220.38 80.5893 220.38C81.1253 220.38 81.5493 220.56 81.8613 220.92C82.1733 221.272 82.3293 221.796 82.3293 222.492V226.5ZM89.9968 225.168L91.1128 226.32L90.1648 227.268L89.0248 226.056C88.5368 226.408 87.9088 226.584 87.1408 226.584C86.3728 226.584 85.7168 226.38 85.1728 225.972C84.1328 225.212 83.6128 223.968 83.6128 222.24C83.6128 220.984 83.9128 219.96 84.5128 219.168C85.1208 218.376 86.0088 217.98 87.1768 217.98C88.3528 217.98 89.2448 218.376 89.8528 219.168C90.4608 219.96 90.7648 220.972 90.7648 222.204C90.7648 223.428 90.5088 224.416 89.9968 225.168ZM88.3288 223.404L88.7128 223.872C88.9208 223.464 89.0248 222.892 89.0248 222.156C89.0248 221.412 88.8608 220.76 88.5328 220.2C88.2128 219.632 87.7528 219.348 87.1528 219.348C86.5528 219.348 86.1048 219.628 85.8088 220.188C85.5128 220.748 85.3648 221.44 85.3648 222.264C85.3648 223.088 85.5208 223.784 85.8328 224.352C86.1448 224.912 86.5968 225.192 87.1888 225.192C87.5008 225.192 87.7528 225.12 87.9448 224.976L87.3688 224.352L88.3288 223.404ZM96.9492 226.5H91.9692V218.1H93.7092V225.12H96.9492V226.5ZM105.345 218.4L105.057 219.804L104.313 219.6C103.785 219.48 103.325 219.42 102.933 219.42C102.389 219.42 102.117 219.68 102.117 220.2C102.117 220.4 102.209 220.584 102.393 220.752C102.585 220.912 102.825 221.048 103.113 221.16C103.401 221.264 103.709 221.396 104.037 221.556C104.365 221.716 104.673 221.888 104.961 222.072C105.249 222.256 105.485 222.508 105.669 222.828C105.861 223.148 105.957 223.516 105.957 223.932C105.957 224.756 105.689 225.404 105.153 225.876C104.625 226.34 103.877 226.572 102.909 226.572C102.413 226.572 101.917 226.508 101.421 226.38C100.933 226.244 100.529 226.088 100.209 225.912L100.725 224.628C101.461 224.964 102.189 225.132 102.909 225.132C103.317 225.132 103.637 225.04 103.869 224.856C104.101 224.664 104.217 224.42 104.217 224.124C104.217 223.828 104.085 223.584 103.821 223.392C103.557 223.192 103.237 223.016 102.861 222.864C102.485 222.704 102.109 222.528 101.733 222.336C101.357 222.136 101.037 221.86 100.773 221.508C100.509 221.148 100.377 220.724 100.377 220.236C100.377 219.508 100.605 218.952 101.061 218.568C101.517 218.176 102.129 217.98 102.897 217.98C103.673 217.98 104.489 218.12 105.345 218.4ZM111.738 226.128C110.978 226.424 110.274 226.572 109.626 226.572C107.746 226.572 106.806 225.556 106.806 223.524C106.806 222.492 107.034 221.712 107.49 221.184C107.946 220.648 108.61 220.38 109.482 220.38C110.202 220.38 110.778 220.604 111.21 221.052C111.642 221.5 111.858 222.164 111.858 223.044C111.858 223.396 111.842 223.704 111.81 223.968H108.342C108.342 224.44 108.47 224.788 108.726 225.012C108.982 225.236 109.326 225.348 109.758 225.348C110.19 225.348 110.762 225.252 111.474 225.06L111.738 226.128ZM110.358 222.864V222.78C110.358 222.412 110.278 222.116 110.118 221.892C109.958 221.668 109.706 221.556 109.362 221.556C109.018 221.556 108.762 221.68 108.594 221.928C108.426 222.176 108.338 222.488 108.33 222.864H110.358ZM114.884 222.516V226.5H113.312V220.5H114.56L114.704 221.088C115.024 220.832 115.292 220.652 115.508 220.548C115.724 220.436 115.912 220.38 116.072 220.38C116.24 220.38 116.352 220.384 116.408 220.392C116.464 220.392 116.512 220.396 116.552 220.404C116.592 220.412 116.66 220.428 116.756 220.452L116.612 221.88C116.468 221.832 116.272 221.808 116.024 221.808C115.688 221.808 115.308 222.044 114.884 222.516ZM122.595 220.5L120.687 226.5H118.935L117.039 220.5H118.659L119.823 224.94L120.999 220.5H122.595ZM125.089 219.6H123.529V218.1H125.089V219.6ZM125.089 226.5H123.529V220.5H125.089V226.5ZM130.708 225.192L130.9 226.272C130.204 226.472 129.652 226.572 129.244 226.572C128.252 226.572 127.536 226.312 127.096 225.792C126.656 225.272 126.436 224.516 126.436 223.524C126.436 222.524 126.664 221.752 127.12 221.208C127.576 220.656 128.24 220.38 129.112 220.38C129.624 220.38 130.208 220.476 130.864 220.668L130.3 221.76C129.86 221.624 129.496 221.556 129.208 221.556C128.92 221.556 128.692 221.612 128.524 221.724C128.364 221.836 128.248 221.996 128.176 222.204C128.056 222.548 127.996 223.02 127.996 223.62C127.996 224.212 128.12 224.648 128.368 224.928C128.616 225.208 128.976 225.348 129.448 225.348C129.92 225.348 130.34 225.296 130.708 225.192ZM136.512 226.128C135.752 226.424 135.048 226.572 134.4 226.572C132.52 226.572 131.58 225.556 131.58 223.524C131.58 222.492 131.808 221.712 132.264 221.184C132.72 220.648 133.384 220.38 134.256 220.38C134.976 220.38 135.552 220.604 135.984 221.052C136.416 221.5 136.632 222.164 136.632 223.044C136.632 223.396 136.616 223.704 136.584 223.968H133.116C133.116 224.44 133.244 224.788 133.5 225.012C133.756 225.236 134.1 225.348 134.532 225.348C134.964 225.348 135.536 225.252 136.248 225.06L136.512 226.128ZM135.132 222.864V222.78C135.132 222.412 135.052 222.116 134.892 221.892C134.732 221.668 134.48 221.556 134.136 221.556C133.792 221.556 133.536 221.68 133.368 221.928C133.2 222.176 133.112 222.488 133.104 222.864H135.132ZM137.977 224.904C138.513 225.176 139.061 225.312 139.621 225.312C140.189 225.312 140.473 225.104 140.473 224.688C140.473 224.304 140.153 224.02 139.513 223.836C139.241 223.764 138.969 223.68 138.697 223.584C138.433 223.48 138.205 223.316 138.013 223.092C137.829 222.86 137.737 222.564 137.737 222.204C137.737 221.62 137.917 221.172 138.277 220.86C138.637 220.54 139.137 220.38 139.777 220.38C140.425 220.38 141.037 220.492 141.613 220.716L141.361 221.964C140.833 221.748 140.317 221.64 139.813 221.64C139.461 221.64 139.285 221.76 139.285 222C139.285 222.248 139.521 222.436 139.993 222.564C140.489 222.692 140.929 222.876 141.313 223.116C141.513 223.236 141.681 223.416 141.817 223.656C141.953 223.896 142.021 224.184 142.021 224.52C142.021 225.152 141.809 225.652 141.385 226.02C140.961 226.388 140.377 226.572 139.633 226.572C138.889 226.572 138.225 226.4 137.641 226.056L137.977 224.904Z"
          fill="#0F172A"
        />
      </g>
      <path
        d="M197.215 222.5H266C279.255 222.5 290 211.755 290 198.5V153.983C290 143.775 298.275 135.5 308.482 135.5V135.5"
        stroke="#F9C548"
        strokeOpacity="0.5"
        strokeWidth="6"
        strokeMiterlimit="0"
        strokeLinecap="round"
        strokeLinejoin="bevel"
      />
      <g filter="url(#filter3_d_768_38002)">
        <rect
          x="25"
          y="111.5"
          width="168.215"
          height="48"
          rx="3.5"
          fill="white"
          shapeRendering="crispEdges"
        />
        <path
          d="M45.3438 131.75V132.687C45.3438 133.514 43.2861 134.188 40.75 134.188C38.2139 134.188 36.1562 133.514 36.1562 132.687V131.75C36.1562 130.924 38.2139 130.25 40.75 130.25C43.2861 130.25 45.3438 130.924 45.3438 131.75ZM45.3438 133.859V135.969C45.3438 136.795 43.2861 137.469 40.75 137.469C38.2139 137.469 36.1562 136.795 36.1562 135.969V133.859C37.1432 134.539 38.9496 134.855 40.75 134.855C42.5504 134.855 44.3568 134.539 45.3438 133.859ZM45.3438 137.141V139.25C45.3438 140.076 43.2861 140.75 40.75 140.75C38.2139 140.75 36.1562 140.076 36.1562 139.25V137.141C37.1432 137.82 38.9496 138.137 40.75 138.137C42.5504 138.137 44.3568 137.82 45.3438 137.141Z"
          fill="#0F172A"
        />
        <path
          d="M58.654 135C58.654 136.352 58.262 137.44 57.478 138.264C56.694 139.088 55.646 139.5 54.334 139.5H52.102V131.1H54.706C55.898 131.1 56.854 131.464 57.574 132.192C58.294 132.92 58.654 133.856 58.654 135ZM56.842 134.904C56.842 134.152 56.638 133.56 56.23 133.128C55.822 132.696 55.33 132.48 54.754 132.48H53.794V138.12H54.442C55.114 138.12 55.682 137.836 56.146 137.268C56.61 136.692 56.842 135.904 56.842 134.904ZM63.1715 139.5L62.9315 138.9C62.6515 139.156 62.4035 139.336 62.1875 139.44C61.9715 139.536 61.7115 139.584 61.4075 139.584C60.8955 139.584 60.4475 139.408 60.0635 139.056C59.6875 138.696 59.4995 138.22 59.4995 137.628C59.4995 137.036 59.7315 136.572 60.1955 136.236C60.6595 135.892 61.3595 135.72 62.2955 135.72H62.7875C62.7875 135.376 62.7035 135.1 62.5355 134.892C62.3755 134.684 62.1275 134.58 61.7915 134.58C61.2075 134.58 60.6155 134.66 60.0155 134.82L59.7515 133.764C60.5435 133.508 61.3395 133.38 62.1395 133.38C63.5955 133.38 64.3235 134.06 64.3235 135.42V139.5H63.1715ZM62.7635 136.872H62.2475C61.7995 136.872 61.4955 136.932 61.3355 137.052C61.1755 137.172 61.0955 137.348 61.0955 137.58C61.0955 137.804 61.1555 137.988 61.2755 138.132C61.3955 138.276 61.5515 138.348 61.7435 138.348C62.0155 138.348 62.3555 138.132 62.7635 137.7V136.872ZM65.9667 138.204V134.82H65.3547V133.5H65.9787V131.784H67.5267V133.5H68.7867V134.82H67.5147V137.436C67.5147 137.972 67.6787 138.24 68.0067 138.24C68.1907 138.24 68.3867 138.216 68.5947 138.168L68.8467 139.416C68.4787 139.52 68.0867 139.572 67.6707 139.572C67.2627 139.572 66.8747 139.468 66.5067 139.26C66.1467 139.044 65.9667 138.692 65.9667 138.204ZM73.3551 139.5L73.1151 138.9C72.8351 139.156 72.5871 139.336 72.3711 139.44C72.1551 139.536 71.8951 139.584 71.5911 139.584C71.0791 139.584 70.6311 139.408 70.2471 139.056C69.8711 138.696 69.6831 138.22 69.6831 137.628C69.6831 137.036 69.9151 136.572 70.3791 136.236C70.8431 135.892 71.5431 135.72 72.4791 135.72H72.9711C72.9711 135.376 72.8871 135.1 72.7191 134.892C72.5591 134.684 72.3111 134.58 71.9751 134.58C71.3911 134.58 70.7991 134.66 70.1991 134.82L69.9351 133.764C70.7271 133.508 71.5231 133.38 72.3231 133.38C73.7791 133.38 74.5071 134.06 74.5071 135.42V139.5H73.3551ZM72.9471 136.872H72.4311C71.9831 136.872 71.6791 136.932 71.5191 137.052C71.3591 137.172 71.2791 137.348 71.2791 137.58C71.2791 137.804 71.3391 137.988 71.4591 138.132C71.5791 138.276 71.7351 138.348 71.9271 138.348C72.1991 138.348 72.5391 138.132 72.9471 137.7V136.872ZM79.3663 133.38C79.9823 133.38 80.4743 133.644 80.8423 134.172C81.2183 134.692 81.4063 135.448 81.4063 136.44C81.4063 137.424 81.1943 138.18 80.7703 138.708C80.3463 139.236 79.8023 139.5 79.1383 139.5C78.6263 139.5 78.1223 139.276 77.6263 138.828L77.3983 139.5H76.2103V131.1H77.7703V134.052C78.3863 133.604 78.9183 133.38 79.3663 133.38ZM79.8703 136.44C79.8703 135.328 79.5343 134.772 78.8623 134.772C78.5583 134.772 78.1943 134.952 77.7703 135.312V137.628C78.1943 137.988 78.5543 138.168 78.8503 138.168C79.1543 138.168 79.3983 138.024 79.5823 137.736C79.7743 137.448 79.8703 137.016 79.8703 136.44ZM85.8708 139.5L85.6308 138.9C85.3508 139.156 85.1028 139.336 84.8867 139.44C84.6708 139.536 84.4108 139.584 84.1068 139.584C83.5948 139.584 83.1468 139.408 82.7628 139.056C82.3868 138.696 82.1988 138.22 82.1988 137.628C82.1988 137.036 82.4308 136.572 82.8948 136.236C83.3588 135.892 84.0588 135.72 84.9948 135.72H85.4868C85.4868 135.376 85.4028 135.1 85.2348 134.892C85.0748 134.684 84.8268 134.58 84.4908 134.58C83.9068 134.58 83.3148 134.66 82.7148 134.82L82.4508 133.764C83.2428 133.508 84.0388 133.38 84.8388 133.38C86.2948 133.38 87.0228 134.06 87.0228 135.42V139.5H85.8708ZM85.4628 136.872H84.9468C84.4988 136.872 84.1948 136.932 84.0348 137.052C83.8748 137.172 83.7948 137.348 83.7948 137.58C83.7948 137.804 83.8548 137.988 83.9748 138.132C84.0948 138.276 84.2508 138.348 84.4428 138.348C84.7148 138.348 85.0548 138.132 85.4628 137.7V136.872ZM88.6179 137.904C89.1539 138.176 89.7019 138.312 90.2619 138.312C90.8299 138.312 91.1139 138.104 91.1139 137.688C91.1139 137.304 90.7939 137.02 90.1539 136.836C89.8819 136.764 89.6099 136.68 89.3379 136.584C89.0739 136.48 88.8459 136.316 88.6539 136.092C88.4699 135.86 88.3779 135.564 88.3779 135.204C88.3779 134.62 88.5579 134.172 88.9179 133.86C89.2779 133.54 89.7779 133.38 90.4179 133.38C91.0659 133.38 91.6779 133.492 92.2539 133.716L92.0019 134.964C91.4739 134.748 90.9579 134.64 90.4539 134.64C90.1019 134.64 89.9259 134.76 89.9259 135C89.9259 135.248 90.1619 135.436 90.6339 135.564C91.1299 135.692 91.5699 135.876 91.9539 136.116C92.1539 136.236 92.3219 136.416 92.4579 136.656C92.5939 136.896 92.6619 137.184 92.6619 137.52C92.6619 138.152 92.4499 138.652 92.0259 139.02C91.6019 139.388 91.0179 139.572 90.2739 139.572C89.5299 139.572 88.8659 139.4 88.2819 139.056L88.6179 137.904ZM98.4259 139.128C97.6659 139.424 96.9619 139.572 96.3139 139.572C94.4339 139.572 93.4939 138.556 93.4939 136.524C93.4939 135.492 93.7219 134.712 94.1779 134.184C94.6339 133.648 95.2979 133.38 96.1699 133.38C96.8899 133.38 97.4659 133.604 97.8979 134.052C98.3299 134.5 98.5459 135.164 98.5459 136.044C98.5459 136.396 98.5299 136.704 98.4979 136.968H95.0299C95.0299 137.44 95.1579 137.788 95.4139 138.012C95.6699 138.236 96.0139 138.348 96.4459 138.348C96.8779 138.348 97.4499 138.252 98.1619 138.06L98.4259 139.128ZM97.0459 135.864V135.78C97.0459 135.412 96.9659 135.116 96.8059 134.892C96.6459 134.668 96.3939 134.556 96.0499 134.556C95.7059 134.556 95.4499 134.68 95.2819 134.928C95.1139 135.176 95.0259 135.488 95.0179 135.864H97.0459ZM99.8913 137.904C100.427 138.176 100.975 138.312 101.535 138.312C102.103 138.312 102.387 138.104 102.387 137.688C102.387 137.304 102.067 137.02 101.427 136.836C101.155 136.764 100.883 136.68 100.611 136.584C100.347 136.48 100.119 136.316 99.9273 136.092C99.7433 135.86 99.6513 135.564 99.6513 135.204C99.6513 134.62 99.8313 134.172 100.191 133.86C100.551 133.54 101.051 133.38 101.691 133.38C102.339 133.38 102.951 133.492 103.527 133.716L103.275 134.964C102.747 134.748 102.231 134.64 101.727 134.64C101.375 134.64 101.199 134.76 101.199 135C101.199 135.248 101.435 135.436 101.907 135.564C102.403 135.692 102.843 135.876 103.227 136.116C103.427 136.236 103.595 136.416 103.731 136.656C103.867 136.896 103.935 137.184 103.935 137.52C103.935 138.152 103.723 138.652 103.299 139.02C102.875 139.388 102.291 139.572 101.547 139.572C100.803 139.572 100.139 139.4 99.5553 139.056L99.8913 137.904Z"
          fill="#0F172A"
        />
      </g>
      <g filter="url(#filter4_d_768_38002)">
        <rect
          x="485"
          y="111.5"
          width="168"
          height="48"
          rx="3.5"
          fill="white"
          shapeRendering="crispEdges"
        />
        <path
          d="M505.125 124.833H496.375C495.892 124.833 495.5 125.225 495.5 125.708V131.542C495.5 132.025 495.892 132.417 496.375 132.417H499.875L499.583 133.292H498.271C498.028 133.292 497.833 133.487 497.833 133.729C497.833 133.972 498.028 134.167 498.271 134.167H503.229C503.472 134.167 503.667 133.972 503.667 133.729C503.667 133.487 503.472 133.292 503.229 133.292H501.917L501.625 132.417H505.125C505.608 132.417 506 132.025 506 131.542V125.708C506 125.225 505.608 124.833 505.125 124.833ZM504.833 131.25H496.667V126H504.833V131.25Z"
          fill="#0F172A"
        />
        <path
          d="M515.402 134.072C514.178 134.072 513.238 133.688 512.582 132.92C511.934 132.144 511.61 131.096 511.61 129.776C511.61 128.456 511.954 127.412 512.642 126.644C513.338 125.876 514.302 125.492 515.534 125.492C516.206 125.492 516.874 125.608 517.538 125.84L517.202 127.184C516.714 126.976 516.138 126.872 515.474 126.872C514.81 126.872 514.29 127.124 513.914 127.628C513.538 128.132 513.35 128.828 513.35 129.716C513.35 130.604 513.526 131.324 513.878 131.876C514.23 132.42 514.726 132.692 515.366 132.692C515.846 132.692 516.53 132.536 517.418 132.224L517.778 133.448C517.05 133.864 516.258 134.072 515.402 134.072ZM520.79 134H519.23V125.6H520.79V134ZM524.363 127.1H522.803V125.6H524.363V127.1ZM524.363 134H522.803V128H524.363V134ZM530.629 133.628C529.869 133.924 529.165 134.072 528.517 134.072C526.637 134.072 525.697 133.056 525.697 131.024C525.697 129.992 525.925 129.212 526.381 128.684C526.837 128.148 527.501 127.88 528.373 127.88C529.093 127.88 529.669 128.104 530.101 128.552C530.533 129 530.749 129.664 530.749 130.544C530.749 130.896 530.733 131.204 530.701 131.468H527.233C527.233 131.94 527.361 132.288 527.617 132.512C527.873 132.736 528.217 132.848 528.649 132.848C529.081 132.848 529.653 132.752 530.365 132.56L530.629 133.628ZM529.249 130.364V130.28C529.249 129.912 529.169 129.616 529.009 129.392C528.849 129.168 528.597 129.056 528.253 129.056C527.909 129.056 527.653 129.18 527.485 129.428C527.317 129.676 527.229 129.988 527.221 130.364H529.249ZM537.29 134H535.706V130.412C535.706 130.084 535.642 129.82 535.514 129.62C535.386 129.412 535.174 129.308 534.878 129.308C534.582 129.308 534.214 129.492 533.774 129.86V134H532.202V128H533.522L533.774 128.54C534.118 128.284 534.414 128.112 534.662 128.024C534.918 127.928 535.214 127.88 535.55 127.88C536.086 127.88 536.51 128.06 536.822 128.42C537.134 128.772 537.29 129.296 537.29 129.992V134ZM539.174 132.704V129.32H538.562V128H539.186V126.284H540.734V128H541.994V129.32H540.722V131.936C540.722 132.472 540.886 132.74 541.214 132.74C541.398 132.74 541.594 132.716 541.802 132.668L542.054 133.916C541.686 134.02 541.294 134.072 540.878 134.072C540.47 134.072 540.082 133.968 539.714 133.76C539.354 133.544 539.174 133.192 539.174 132.704ZM543.274 132.404C543.81 132.676 544.358 132.812 544.918 132.812C545.486 132.812 545.77 132.604 545.77 132.188C545.77 131.804 545.45 131.52 544.81 131.336C544.538 131.264 544.266 131.18 543.994 131.084C543.73 130.98 543.502 130.816 543.31 130.592C543.126 130.36 543.034 130.064 543.034 129.704C543.034 129.12 543.214 128.672 543.574 128.36C543.934 128.04 544.434 127.88 545.074 127.88C545.722 127.88 546.334 127.992 546.91 128.216L546.658 129.464C546.13 129.248 545.614 129.14 545.11 129.14C544.758 129.14 544.582 129.26 544.582 129.5C544.582 129.748 544.818 129.936 545.29 130.064C545.786 130.192 546.226 130.376 546.61 130.616C546.81 130.736 546.978 130.916 547.114 131.156C547.25 131.396 547.318 131.684 547.318 132.02C547.318 132.652 547.106 133.152 546.682 133.52C546.258 133.888 545.674 134.072 544.93 134.072C544.186 134.072 543.522 133.9 542.938 133.556L543.274 132.404Z"
          fill="#0F172A"
        />
        <path
          d="M516.91 147H516.07L515.37 144.79H512.86L512.17 147H511.38L513.68 140H514.59L516.91 147ZM515.2 144.14L514.13 140.76L513.05 144.14H515.2ZM518.701 149.38H517.951V142.01H518.391L518.651 142.57C518.931 142.357 519.191 142.193 519.431 142.08C519.678 141.96 519.948 141.9 520.241 141.9C521.441 141.9 522.041 142.763 522.041 144.49C522.041 145.47 521.828 146.153 521.401 146.54C521.021 146.893 520.588 147.07 520.101 147.07C519.621 147.07 519.154 146.91 518.701 146.59V149.38ZM518.701 143.24V145.91C518.834 146.07 519.014 146.197 519.241 146.29C519.468 146.383 519.684 146.43 519.891 146.43C520.411 146.43 520.774 146.277 520.981 145.97C521.188 145.663 521.291 145.183 521.291 144.53C521.291 143.877 521.188 143.383 520.981 143.05C520.774 142.717 520.511 142.55 520.191 142.55C519.978 142.55 519.764 142.593 519.551 142.68C519.344 142.767 519.188 142.85 519.081 142.93C518.981 143.003 518.854 143.107 518.701 143.24ZM524.16 149.38H523.41V142.01H523.85L524.11 142.57C524.39 142.357 524.65 142.193 524.89 142.08C525.137 141.96 525.407 141.9 525.7 141.9C526.9 141.9 527.5 142.763 527.5 144.49C527.5 145.47 527.287 146.153 526.86 146.54C526.48 146.893 526.047 147.07 525.56 147.07C525.08 147.07 524.613 146.91 524.16 146.59V149.38ZM524.16 143.24V145.91C524.293 146.07 524.473 146.197 524.7 146.29C524.927 146.383 525.143 146.43 525.35 146.43C525.87 146.43 526.233 146.277 526.44 145.97C526.647 145.663 526.75 145.183 526.75 144.53C526.75 143.877 526.647 143.383 526.44 143.05C526.233 142.717 525.97 142.55 525.65 142.55C525.437 142.55 525.223 142.593 525.01 142.68C524.803 142.767 524.647 142.85 524.54 142.93C524.44 143.003 524.313 143.107 524.16 143.24ZM528.679 146.11C529.112 146.31 529.526 146.41 529.919 146.41C530.312 146.41 530.609 146.333 530.809 146.18C531.016 146.02 531.119 145.81 531.119 145.55C531.119 145.29 531.032 145.09 530.859 144.95C530.686 144.803 530.472 144.69 530.219 144.61C529.972 144.53 529.722 144.443 529.469 144.35C529.222 144.257 529.012 144.117 528.839 143.93C528.666 143.743 528.579 143.507 528.579 143.22C528.579 142.8 528.716 142.477 528.989 142.25C529.262 142.017 529.632 141.9 530.099 141.9C530.566 141.9 530.999 141.97 531.399 142.11L531.469 142.14L531.339 142.78C530.939 142.627 530.566 142.55 530.219 142.55C529.879 142.55 529.646 142.603 529.519 142.71C529.392 142.817 529.329 142.997 529.329 143.25C529.329 143.41 529.416 143.547 529.589 143.66C529.762 143.773 529.972 143.873 530.219 143.96C530.472 144.04 530.722 144.137 530.969 144.25C531.222 144.357 531.436 144.52 531.609 144.74C531.782 144.96 531.869 145.23 531.869 145.55C531.869 146.017 531.706 146.387 531.379 146.66C531.052 146.927 530.602 147.06 530.029 147.06C529.456 147.06 528.946 146.93 528.499 146.67L528.679 146.11ZM534.184 146.13L533.054 148.72L532.564 148.56L533.434 145.89L534.184 146.13ZM539.936 144.06H538.916V147H538.166V140H540.166C540.913 140 541.453 140.163 541.786 140.49C542.126 140.817 542.296 141.327 542.296 142.02C542.296 142.707 542.089 143.22 541.676 143.56C541.263 143.893 540.683 144.06 539.936 144.06ZM539.826 140.64H538.916V143.42H539.576C540.263 143.42 540.763 143.317 541.076 143.11C541.389 142.903 541.546 142.55 541.546 142.05C541.546 141.543 541.409 141.183 541.136 140.97C540.863 140.75 540.426 140.64 539.826 140.64ZM543.576 147V140H544.326V147H543.576ZM548.304 144.01H548.714C548.714 143.403 548.638 143.01 548.484 142.83C548.331 142.643 547.991 142.55 547.464 142.55C546.938 142.55 546.491 142.62 546.124 142.76L545.984 142.18C546.544 141.993 547.124 141.9 547.724 141.9C548.898 141.9 549.484 142.487 549.484 143.66V147H549.044L548.784 146.41C548.478 146.663 548.211 146.837 547.984 146.93C547.764 147.017 547.508 147.06 547.214 147.06C546.748 147.06 546.384 146.923 546.124 146.65C545.864 146.37 545.734 146.003 545.734 145.55C545.734 144.523 546.591 144.01 548.304 144.01ZM548.724 144.64H548.274C547.594 144.64 547.124 144.707 546.864 144.84C546.611 144.973 546.484 145.183 546.484 145.47C546.484 145.75 546.558 145.98 546.704 146.16C546.851 146.34 547.041 146.43 547.274 146.43C547.514 146.43 547.741 146.377 547.954 146.27C548.174 146.157 548.431 145.963 548.724 145.69V144.64ZM551.421 145.92V142.6H550.741V142H551.431V140.57H552.181V142H553.401V142.6H552.171V145.78C552.171 146.227 552.397 146.45 552.851 146.45C552.957 146.45 553.121 146.43 553.341 146.39L553.451 146.93C553.177 147.017 552.894 147.06 552.601 147.06C552.314 147.06 552.044 146.973 551.791 146.8C551.544 146.62 551.421 146.327 551.421 145.92ZM554.978 142V141.04C554.978 140.633 555.101 140.343 555.348 140.17C555.601 139.99 555.871 139.9 556.158 139.9C556.451 139.9 556.734 139.943 557.008 140.03L556.898 140.57C556.678 140.53 556.514 140.51 556.408 140.51C555.948 140.51 555.718 140.733 555.718 141.18V142H556.738V142.6H555.718V147H554.968V142.6H554.198V142H554.978ZM560.758 144.54C560.758 143.893 560.631 143.4 560.378 143.06C560.124 142.72 559.754 142.55 559.268 142.55C558.781 142.55 558.434 142.713 558.228 143.04C558.028 143.36 557.928 143.853 557.928 144.52C557.928 145.78 558.391 146.41 559.318 146.41C559.804 146.41 560.164 146.26 560.398 145.96C560.638 145.653 560.758 145.18 560.758 144.54ZM560.938 146.38C560.558 146.833 560.021 147.06 559.328 147.06C558.634 147.06 558.101 146.837 557.728 146.39C557.361 145.937 557.178 145.307 557.178 144.5C557.178 143.687 557.354 143.05 557.708 142.59C558.068 142.13 558.591 141.9 559.278 141.9C559.971 141.9 560.514 142.133 560.908 142.6C561.308 143.067 561.508 143.7 561.508 144.5C561.508 145.3 561.318 145.927 560.938 146.38ZM563.594 143.18V147H562.844V142H563.324L563.444 142.59C563.764 142.337 564.03 142.16 564.244 142.06C564.457 141.953 564.7 141.9 564.974 141.9C565.107 141.9 565.207 141.907 565.274 141.92L565.414 141.96L565.294 142.65C565.174 142.61 565.01 142.59 564.804 142.59C564.404 142.59 564 142.787 563.594 143.18ZM568.665 141.89C569.305 141.89 569.761 142.117 570.035 142.57C570.601 142.117 571.125 141.89 571.605 141.89C572.085 141.89 572.475 142.027 572.775 142.3C573.081 142.567 573.235 142.957 573.235 143.47V147H572.505V143.78C572.505 143.373 572.411 143.067 572.225 142.86C572.045 142.647 571.801 142.54 571.495 142.54C571.075 142.54 570.651 142.707 570.225 143.04C570.258 143.187 570.275 143.33 570.275 143.47V147H569.545V143.78C569.545 143.373 569.451 143.067 569.265 142.86C569.085 142.647 568.841 142.54 568.535 142.54C568.335 142.54 568.151 142.567 567.985 142.62C567.818 142.673 567.695 142.727 567.615 142.78C567.535 142.833 567.431 142.913 567.305 143.02V147H566.555V142H567.035L567.165 142.51C567.331 142.37 567.458 142.27 567.545 142.21C567.638 142.143 567.788 142.073 567.995 142C568.201 141.927 568.425 141.89 568.665 141.89ZM574.861 146.11C575.294 146.31 575.707 146.41 576.101 146.41C576.494 146.41 576.791 146.333 576.991 146.18C577.197 146.02 577.301 145.81 577.301 145.55C577.301 145.29 577.214 145.09 577.041 144.95C576.867 144.803 576.654 144.69 576.401 144.61C576.154 144.53 575.904 144.443 575.651 144.35C575.404 144.257 575.194 144.117 575.021 143.93C574.847 143.743 574.761 143.507 574.761 143.22C574.761 142.8 574.897 142.477 575.171 142.25C575.444 142.017 575.814 141.9 576.281 141.9C576.747 141.9 577.181 141.97 577.581 142.11L577.651 142.14L577.521 142.78C577.121 142.627 576.747 142.55 576.401 142.55C576.061 142.55 575.827 142.603 575.701 142.71C575.574 142.817 575.511 142.997 575.511 143.25C575.511 143.41 575.597 143.547 575.771 143.66C575.944 143.773 576.154 143.873 576.401 143.96C576.654 144.04 576.904 144.137 577.151 144.25C577.404 144.357 577.617 144.52 577.791 144.74C577.964 144.96 578.051 145.23 578.051 145.55C578.051 146.017 577.887 146.387 577.561 146.66C577.234 146.927 576.784 147.06 576.211 147.06C575.637 147.06 575.127 146.93 574.681 146.67L574.861 146.11ZM580.366 146.13L579.236 148.72L578.746 148.56L579.616 145.89L580.366 146.13ZM587.868 140.25L587.708 140.92L587.128 140.75C586.714 140.65 586.358 140.6 586.058 140.6C585.271 140.6 584.878 140.95 584.878 141.65C584.878 141.957 584.998 142.21 585.238 142.41C585.478 142.603 585.768 142.76 586.108 142.88C586.454 142.993 586.798 143.12 587.138 143.26C587.484 143.393 587.778 143.603 588.018 143.89C588.258 144.17 588.378 144.527 588.378 144.96C588.378 145.62 588.174 146.137 587.768 146.51C587.361 146.877 586.784 147.06 586.038 147.06C585.664 147.06 585.288 147.007 584.907 146.9C584.534 146.787 584.228 146.657 583.988 146.51L584.238 145.94C584.844 146.22 585.418 146.36 585.958 146.36C586.504 146.36 586.918 146.25 587.198 146.03C587.484 145.81 587.628 145.49 587.628 145.07C587.628 144.643 587.398 144.31 586.938 144.07C586.731 143.963 586.501 143.863 586.248 143.77C586.001 143.677 585.751 143.577 585.498 143.47C585.251 143.357 585.024 143.23 584.818 143.09C584.618 142.95 584.451 142.76 584.318 142.52C584.191 142.28 584.128 142 584.128 141.68C584.128 141.107 584.298 140.667 584.638 140.36C584.984 140.053 585.448 139.9 586.028 139.9C586.608 139.9 587.221 140.017 587.868 140.25ZM593.325 144.66H590.135C590.135 145.3 590.285 145.753 590.585 146.02C590.892 146.287 591.275 146.42 591.735 146.42C591.969 146.42 592.132 146.41 592.225 146.39C592.319 146.363 592.405 146.34 592.485 146.32C592.572 146.293 592.632 146.273 592.665 146.26C592.832 146.213 592.975 146.17 593.095 146.13L593.215 146.71C592.549 146.943 592.029 147.06 591.655 147.06C590.969 147.06 590.419 146.853 590.005 146.44C589.592 146.02 589.385 145.393 589.385 144.56C589.385 143.72 589.579 143.067 589.965 142.6C590.359 142.133 590.852 141.9 591.445 141.9C592.045 141.9 592.512 142.093 592.845 142.48C593.179 142.867 593.345 143.39 593.345 144.05C593.345 144.23 593.339 144.433 593.325 144.66ZM590.185 144.09H592.625C592.625 143.597 592.539 143.217 592.365 142.95C592.192 142.683 591.889 142.55 591.455 142.55C591.029 142.55 590.715 142.693 590.515 142.98C590.315 143.267 590.205 143.637 590.185 144.09ZM595.498 143.18V147H594.748V142H595.228L595.348 142.59C595.668 142.337 595.935 142.16 596.148 142.06C596.361 141.953 596.605 141.9 596.878 141.9C597.011 141.9 597.111 141.907 597.178 141.92L597.318 141.96L597.198 142.65C597.078 142.61 596.915 142.59 596.708 142.59C596.308 142.59 595.905 142.787 595.498 143.18ZM601.889 141.99L600.199 147H599.339L597.659 141.99H598.509L599.779 146.2L601.059 141.99H601.889ZM602.772 147V142H603.522V147H602.772ZM603.522 140V140.89H602.772V140H603.522ZM608.127 146.22L608.277 146.81C607.744 146.97 607.274 147.05 606.867 147.05C606.154 147.05 605.617 146.817 605.257 146.35C604.897 145.883 604.717 145.24 604.717 144.42C604.717 143.6 604.904 142.977 605.277 142.55C605.651 142.117 606.201 141.9 606.927 141.9C607.241 141.9 607.681 141.98 608.247 142.14L607.947 142.72C607.581 142.613 607.251 142.56 606.957 142.56C606.451 142.56 606.084 142.71 605.857 143.01C605.637 143.31 605.527 143.783 605.527 144.43C605.527 145.743 605.997 146.4 606.937 146.4C607.311 146.4 607.707 146.34 608.127 146.22ZM612.984 144.66H609.794C609.794 145.3 609.944 145.753 610.244 146.02C610.55 146.287 610.934 146.42 611.394 146.42C611.627 146.42 611.79 146.41 611.884 146.39C611.977 146.363 612.064 146.34 612.144 146.32C612.23 146.293 612.29 146.273 612.324 146.26C612.49 146.213 612.634 146.17 612.754 146.13L612.874 146.71C612.207 146.943 611.687 147.06 611.314 147.06C610.627 147.06 610.077 146.853 609.664 146.44C609.25 146.02 609.044 145.393 609.044 144.56C609.044 143.72 609.237 143.067 609.624 142.6C610.017 142.133 610.51 141.9 611.104 141.9C611.704 141.9 612.17 142.093 612.504 142.48C612.837 142.867 613.004 143.39 613.004 144.05C613.004 144.23 612.997 144.433 612.984 144.66ZM609.844 144.09H612.284C612.284 143.597 612.197 143.217 612.024 142.95C611.85 142.683 611.547 142.55 611.114 142.55C610.687 142.55 610.374 142.693 610.174 142.98C609.974 143.267 609.864 143.637 609.844 144.09ZM614.216 146.11C614.649 146.31 615.063 146.41 615.456 146.41C615.849 146.41 616.146 146.333 616.346 146.18C616.553 146.02 616.656 145.81 616.656 145.55C616.656 145.29 616.569 145.09 616.396 144.95C616.223 144.803 616.009 144.69 615.756 144.61C615.509 144.53 615.259 144.443 615.006 144.35C614.759 144.257 614.549 144.117 614.376 143.93C614.203 143.743 614.116 143.507 614.116 143.22C614.116 142.8 614.253 142.477 614.526 142.25C614.799 142.017 615.169 141.9 615.636 141.9C616.103 141.9 616.536 141.97 616.936 142.11L617.006 142.14L616.876 142.78C616.476 142.627 616.103 142.55 615.756 142.55C615.416 142.55 615.183 142.603 615.056 142.71C614.929 142.817 614.866 142.997 614.866 143.25C614.866 143.41 614.953 143.547 615.126 143.66C615.299 143.773 615.509 143.873 615.756 143.96C616.009 144.04 616.259 144.137 616.506 144.25C616.759 144.357 616.973 144.52 617.146 144.74C617.319 144.96 617.406 145.23 617.406 145.55C617.406 146.017 617.243 146.387 616.916 146.66C616.589 146.927 616.139 147.06 615.566 147.06C614.993 147.06 614.483 146.93 614.036 146.67L614.216 146.11Z"
          fill="#0F172A"
        />
      </g>
      <path
        d="M197.215 48.5H266C279.255 48.5 290 59.2452 290 72.5V117.017C290 127.225 298.275 135.5 308.482 135.5V135.5"
        stroke="#F9C548"
        strokeOpacity="0.5"
        strokeWidth="6"
        strokeMiterlimit="0"
        strokeLinecap="round"
        strokeLinejoin="bevel"
      />
      <path
        d="M197.215 135.5H308.482"
        stroke="#F9C548"
        strokeOpacity="0.5"
        strokeWidth="6"
        strokeMiterlimit="0"
        strokeLinecap="round"
        strokeLinejoin="bevel"
      />
      <path
        d="M388 135.5H481"
        stroke="#F9C548"
        strokeOpacity="0.5"
        strokeWidth="6"
        strokeMiterlimit="0"
        strokeLinecap="round"
        strokeLinejoin="bevel"
      />
      <circle cx="389" cy="135.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="402" cy="135.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="415" cy="135.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="428" cy="135.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="441" cy="135.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="454" cy="135.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="467" cy="135.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="480" cy="135.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="199" cy="135.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="210" cy="135.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="221" cy="135.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="232" cy="135.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="243" cy="135.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="254" cy="135.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="265" cy="135.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="276" cy="135.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="287" cy="135.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="298" cy="135.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="199" cy="48.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="210" cy="48.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="221" cy="48.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="232" cy="48.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="243" cy="48.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="254" cy="48.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="265" cy="48.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="308" cy="135.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="199" cy="222.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="210" cy="222.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="221" cy="222.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="232" cy="222.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="243" cy="222.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="254" cy="222.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="265" cy="222.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="276" cy="220.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="284" cy="214.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="289" cy="205.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="290" cy="195.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="290" cy="184.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="290" cy="174.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="290" cy="164.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="290" cy="154.5" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle cx="293" cy="144" r="1.5" fill="#F59E0B" stroke="#F59E0B" />
      <circle
        cx="2"
        cy="2"
        r="1.5"
        transform="matrix(1 0 0 -1 274 52.5)"
        fill="#F59E0B"
        stroke="#F59E0B"
      />
      <circle
        cx="2"
        cy="2"
        r="1.5"
        transform="matrix(1 0 0 -1 282 58.5)"
        fill="#F59E0B"
        stroke="#F59E0B"
      />
      <circle
        cx="2"
        cy="2"
        r="1.5"
        transform="matrix(1 0 0 -1 287 67.5)"
        fill="#F59E0B"
        stroke="#F59E0B"
      />
      <circle
        cx="2"
        cy="2"
        r="1.5"
        transform="matrix(1 0 0 -1 288 77.5)"
        fill="#F59E0B"
        stroke="#F59E0B"
      />
      <circle
        cx="2"
        cy="2"
        r="1.5"
        transform="matrix(1 0 0 -1 288 88.5)"
        fill="#F59E0B"
        stroke="#F59E0B"
      />
      <circle
        cx="2"
        cy="2"
        r="1.5"
        transform="matrix(1 0 0 -1 288 98.5)"
        fill="#F59E0B"
        stroke="#F59E0B"
      />
      <circle
        cx="2"
        cy="2"
        r="1.5"
        transform="matrix(1 0 0 -1 288 108.5)"
        fill="#F59E0B"
        stroke="#F59E0B"
      />
      <circle
        cx="2"
        cy="2"
        r="1.5"
        transform="matrix(1 0 0 -1 288 118.5)"
        fill="#F59E0B"
        stroke="#F59E0B"
      />
      <circle
        cx="2"
        cy="2"
        r="1.5"
        transform="matrix(1 0 0 -1 291 129)"
        fill="#F59E0B"
        stroke="#F59E0B"
      />
      <g clipPath="url(#clip1_768_38002)">
        <path
          d="M455.896 207.582L452.646 204.332C452.451 204.137 452.451 203.82 452.646 203.625L453.354 202.918C453.549 202.723 453.865 202.723 454.061 202.918L456.25 205.107L460.939 200.418C461.135 200.223 461.451 200.223 461.646 200.418L462.354 201.125C462.549 201.32 462.549 201.637 462.354 201.832L456.604 207.582C456.408 207.777 456.092 207.777 455.896 207.582V207.582Z"
          fill="#64748B"
        />
        <path
          d="M471.142 208.053C470.183 208.053 469.458 207.699 468.968 206.992C468.478 206.278 468.233 205.371 468.233 204.272C468.233 203.173 468.478 202.277 468.968 201.584C469.465 200.891 470.19 200.545 471.142 200.545C472.101 200.545 472.829 200.891 473.326 201.584C473.823 202.277 474.071 203.173 474.071 204.272C474.071 205.777 473.644 206.862 472.79 207.527C472.335 207.877 471.786 208.053 471.142 208.053ZM471.163 201.227C470.449 201.227 469.913 201.525 469.556 202.12C469.206 202.715 469.031 203.443 469.031 204.304C469.031 205.165 469.21 205.889 469.567 206.477C469.931 207.065 470.463 207.359 471.163 207.359C471.863 207.359 472.391 207.062 472.748 206.467C473.105 205.872 473.284 205.123 473.284 204.22C473.284 203.086 472.965 202.239 472.328 201.679C471.999 201.378 471.611 201.227 471.163 201.227ZM476.302 210.499H475.514V202.76H475.976L476.249 203.348C476.543 203.124 476.816 202.953 477.068 202.834C477.327 202.708 477.611 202.645 477.919 202.645C479.179 202.645 479.809 203.551 479.809 205.364C479.809 206.393 479.585 207.111 479.137 207.517C478.738 207.888 478.283 208.074 477.772 208.074C477.268 208.074 476.778 207.905 476.302 207.569V210.499ZM476.302 204.052V206.855C476.442 207.023 476.631 207.156 476.869 207.254C477.107 207.352 477.334 207.401 477.551 207.401C478.097 207.401 478.479 207.24 478.696 206.918C478.913 206.596 479.021 206.092 479.021 205.406C479.021 204.72 478.913 204.202 478.696 203.852C478.479 203.502 478.202 203.327 477.866 203.327C477.642 203.327 477.418 203.373 477.194 203.464C476.977 203.555 476.813 203.642 476.701 203.726C476.596 203.803 476.463 203.912 476.302 204.052ZM484.89 205.543H481.54C481.54 206.215 481.698 206.691 482.013 206.971C482.335 207.251 482.737 207.391 483.22 207.391C483.465 207.391 483.637 207.38 483.735 207.359C483.833 207.331 483.924 207.307 484.008 207.286C484.099 207.258 484.162 207.237 484.197 207.223C484.372 207.174 484.522 207.128 484.648 207.086L484.774 207.695C484.074 207.94 483.528 208.063 483.136 208.063C482.415 208.063 481.838 207.846 481.404 207.412C480.97 206.971 480.753 206.313 480.753 205.438C480.753 204.556 480.956 203.87 481.362 203.38C481.775 202.89 482.293 202.645 482.916 202.645C483.546 202.645 484.036 202.848 484.386 203.254C484.736 203.66 484.911 204.209 484.911 204.902C484.911 205.091 484.904 205.305 484.89 205.543ZM481.593 204.944H484.155C484.155 204.426 484.064 204.027 483.882 203.747C483.7 203.467 483.381 203.327 482.926 203.327C482.478 203.327 482.149 203.478 481.939 203.779C481.729 204.08 481.614 204.468 481.593 204.944ZM487.171 203.989V208H486.383V202.75H486.887L487.013 203.369C487.349 203.103 487.629 202.918 487.853 202.813C488.077 202.701 488.333 202.645 488.62 202.645C488.76 202.645 488.865 202.652 488.935 202.666L489.082 202.708L488.956 203.432C488.83 203.39 488.658 203.369 488.441 203.369C488.021 203.369 487.598 203.576 487.171 203.989ZM492.548 204.86H492.978C492.978 204.223 492.898 203.81 492.737 203.621C492.576 203.425 492.219 203.327 491.666 203.327C491.113 203.327 490.644 203.401 490.259 203.548L490.112 202.939C490.7 202.743 491.309 202.645 491.939 202.645C493.171 202.645 493.787 203.261 493.787 204.493V208H493.325L493.052 207.38C492.73 207.646 492.45 207.828 492.212 207.926C491.981 208.017 491.711 208.063 491.403 208.063C490.913 208.063 490.532 207.919 490.259 207.632C489.986 207.338 489.849 206.953 489.849 206.477C489.849 205.399 490.749 204.86 492.548 204.86ZM492.989 205.522H492.516C491.802 205.522 491.309 205.592 491.036 205.732C490.77 205.872 490.637 206.092 490.637 206.393C490.637 206.687 490.714 206.929 490.868 207.118C491.022 207.307 491.221 207.401 491.466 207.401C491.718 207.401 491.956 207.345 492.18 207.233C492.411 207.114 492.681 206.911 492.989 206.624V205.522ZM495.82 206.866V203.38H495.106V202.75H495.83V201.248H496.618V202.75H497.899V203.38H496.607V206.719C496.607 207.188 496.845 207.422 497.321 207.422C497.433 207.422 497.605 207.401 497.836 207.359L497.951 207.926C497.664 208.017 497.367 208.063 497.059 208.063C496.758 208.063 496.474 207.972 496.208 207.79C495.949 207.601 495.82 207.293 495.82 206.866ZM499.177 208V202.75H499.964V208H499.177ZM499.964 200.65V201.584H499.177V200.65H499.964ZM504.957 205.417C504.957 204.738 504.824 204.22 504.558 203.863C504.292 203.506 503.904 203.327 503.393 203.327C502.882 203.327 502.518 203.499 502.301 203.842C502.091 204.178 501.986 204.696 501.986 205.396C501.986 206.719 502.472 207.38 503.445 207.38C503.956 207.38 504.334 207.223 504.579 206.908C504.831 206.586 504.957 206.089 504.957 205.417ZM505.146 207.349C504.747 207.825 504.184 208.063 503.456 208.063C502.728 208.063 502.168 207.828 501.776 207.359C501.391 206.883 501.198 206.222 501.198 205.375C501.198 204.521 501.384 203.852 501.755 203.369C502.133 202.886 502.682 202.645 503.403 202.645C504.131 202.645 504.702 202.89 505.115 203.38C505.535 203.87 505.745 204.535 505.745 205.375C505.745 206.215 505.545 206.873 505.146 207.349ZM507.935 203.831V208H507.147V202.75H507.651L507.777 203.264C507.938 203.138 508.068 203.04 508.166 202.97C508.271 202.9 508.435 202.83 508.659 202.76C508.883 202.683 509.121 202.645 509.373 202.645C509.856 202.645 510.255 202.795 510.57 203.096C510.892 203.39 511.053 203.81 511.053 204.356V208H510.266V204.587C510.266 203.74 509.912 203.317 509.205 203.317C508.701 203.317 508.278 203.488 507.935 203.831ZM516.899 208V201.353H514.841V200.65H519.713V201.353H517.676V208H516.899ZM520.73 208V202.75H521.518V208H520.73ZM521.518 200.65V201.584H520.73V200.65H521.518ZM525.482 202.634C526.154 202.634 526.634 202.872 526.921 203.348C527.516 202.872 528.065 202.634 528.569 202.634C529.073 202.634 529.483 202.778 529.798 203.065C530.12 203.345 530.281 203.754 530.281 204.293V208H529.514V204.619C529.514 204.192 529.416 203.87 529.22 203.653C529.031 203.429 528.776 203.317 528.454 203.317C528.013 203.317 527.568 203.492 527.12 203.842C527.155 203.996 527.173 204.146 527.173 204.293V208H526.406V204.619C526.406 204.192 526.308 203.87 526.112 203.653C525.923 203.429 525.668 203.317 525.346 203.317C525.136 203.317 524.943 203.345 524.768 203.401C524.593 203.457 524.464 203.513 524.38 203.569C524.296 203.625 524.187 203.709 524.054 203.821V208H523.267V202.75H523.771L523.907 203.285C524.082 203.138 524.215 203.033 524.306 202.97C524.404 202.9 524.562 202.827 524.779 202.75C524.996 202.673 525.23 202.634 525.482 202.634ZM535.831 205.543H532.481C532.481 206.215 532.639 206.691 532.954 206.971C533.276 207.251 533.678 207.391 534.161 207.391C534.406 207.391 534.578 207.38 534.676 207.359C534.774 207.331 534.865 207.307 534.949 207.286C535.04 207.258 535.103 207.237 535.138 207.223C535.313 207.174 535.463 207.128 535.589 207.086L535.715 207.695C535.015 207.94 534.469 208.063 534.077 208.063C533.356 208.063 532.779 207.846 532.345 207.412C531.911 206.971 531.694 206.313 531.694 205.438C531.694 204.556 531.897 203.87 532.303 203.38C532.716 202.89 533.234 202.645 533.857 202.645C534.487 202.645 534.977 202.848 535.327 203.254C535.677 203.66 535.852 204.209 535.852 204.902C535.852 205.091 535.845 205.305 535.831 205.543ZM532.534 204.944H535.096C535.096 204.426 535.005 204.027 534.823 203.747C534.641 203.467 534.322 203.327 533.867 203.327C533.419 203.327 533.09 203.478 532.88 203.779C532.67 204.08 532.555 204.468 532.534 204.944ZM540.569 205.417C540.569 204.738 540.436 204.22 540.17 203.863C539.904 203.506 539.516 203.327 539.005 203.327C538.494 203.327 538.13 203.499 537.913 203.842C537.703 204.178 537.598 204.696 537.598 205.396C537.598 206.719 538.084 207.38 539.057 207.38C539.568 207.38 539.946 207.223 540.191 206.908C540.443 206.586 540.569 206.089 540.569 205.417ZM540.758 207.349C540.359 207.825 539.796 208.063 539.068 208.063C538.34 208.063 537.78 207.828 537.388 207.359C537.003 206.883 536.81 206.222 536.81 205.375C536.81 204.521 536.996 203.852 537.367 203.369C537.745 202.886 538.294 202.645 539.015 202.645C539.743 202.645 540.314 202.89 540.727 203.38C541.147 203.87 541.357 204.535 541.357 205.375C541.357 206.215 541.157 206.873 540.758 207.349ZM545.762 206.666V202.75H546.56V208H546.098L545.836 207.38C545.276 207.835 544.74 208.063 544.229 208.063C543.718 208.063 543.326 207.916 543.053 207.622C542.787 207.321 542.654 206.897 542.654 206.351V202.75H543.442V206.225C543.442 206.638 543.501 206.936 543.62 207.118C543.746 207.3 543.949 207.391 544.229 207.391C544.516 207.391 544.807 207.314 545.101 207.16C545.395 207.006 545.615 206.841 545.762 206.666ZM548.597 206.866V203.38H547.883V202.75H548.607V201.248H549.395V202.75H550.676V203.38H549.384V206.719C549.384 207.188 549.622 207.422 550.098 207.422C550.21 207.422 550.382 207.401 550.613 207.359L550.728 207.926C550.441 208.017 550.144 208.063 549.836 208.063C549.535 208.063 549.251 207.972 548.985 207.79C548.726 207.601 548.597 207.293 548.597 206.866Z"
          fill="#64748B"
        />
      </g>
      <g clipPath="url(#clip2_768_38002)">
        <path
          d="M455.896 225.582L452.646 222.332C452.451 222.137 452.451 221.82 452.646 221.625L453.354 220.918C453.549 220.723 453.865 220.723 454.061 220.918L456.25 223.107L460.939 218.418C461.135 218.223 461.451 218.223 461.646 218.418L462.354 219.125C462.549 219.32 462.549 219.637 462.354 219.832L456.604 225.582C456.408 225.777 456.092 225.777 455.896 225.582V225.582Z"
          fill="#64748B"
        />
        <path
          d="M472.402 218.912L472.234 219.616L471.625 219.438C471.191 219.332 470.816 219.28 470.501 219.28C469.675 219.28 469.262 219.647 469.262 220.382C469.262 220.704 469.388 220.97 469.64 221.18C469.892 221.383 470.197 221.548 470.554 221.674C470.918 221.793 471.278 221.926 471.635 222.073C471.999 222.213 472.307 222.433 472.559 222.734C472.811 223.028 472.937 223.403 472.937 223.858C472.937 224.551 472.724 225.093 472.297 225.485C471.87 225.87 471.264 226.063 470.48 226.063C470.088 226.063 469.693 226.007 469.293 225.895C468.902 225.776 468.58 225.639 468.328 225.485L468.59 224.887C469.227 225.181 469.829 225.328 470.396 225.328C470.97 225.328 471.404 225.212 471.698 224.981C471.999 224.75 472.15 224.414 472.15 223.973C472.15 223.525 471.908 223.175 471.425 222.923C471.208 222.811 470.967 222.706 470.701 222.608C470.442 222.51 470.179 222.405 469.913 222.293C469.654 222.174 469.416 222.041 469.199 221.894C468.989 221.747 468.814 221.548 468.674 221.296C468.541 221.044 468.475 220.75 468.475 220.414C468.475 219.812 468.653 219.35 469.01 219.028C469.374 218.706 469.861 218.545 470.47 218.545C471.079 218.545 471.723 218.667 472.402 218.912ZM477.576 225.181L477.733 225.8C477.173 225.968 476.68 226.053 476.253 226.053C475.504 226.053 474.94 225.807 474.562 225.317C474.184 224.827 473.995 224.152 473.995 223.291C473.995 222.43 474.191 221.775 474.583 221.327C474.975 220.872 475.553 220.645 476.316 220.645C476.645 220.645 477.107 220.729 477.702 220.897L477.387 221.506C477.002 221.394 476.655 221.338 476.347 221.338C475.815 221.338 475.43 221.495 475.192 221.81C474.961 222.125 474.846 222.622 474.846 223.302C474.846 224.68 475.339 225.37 476.326 225.37C476.718 225.37 477.135 225.307 477.576 225.181ZM482.958 226H482.171V222.545C482.171 221.698 481.817 221.275 481.11 221.275C480.585 221.275 480.155 221.443 479.819 221.779V226H479.031V218.65H479.808V221.138C479.962 221.012 480.081 220.921 480.165 220.865C480.256 220.809 480.4 220.753 480.596 220.698C480.799 220.641 481.026 220.613 481.278 220.613C481.761 220.613 482.16 220.76 482.475 221.054C482.797 221.348 482.958 221.768 482.958 222.314V226ZM488.509 223.543H485.16C485.16 224.215 485.317 224.691 485.632 224.971C485.954 225.251 486.357 225.391 486.84 225.391C487.085 225.391 487.256 225.38 487.354 225.359C487.452 225.331 487.543 225.307 487.627 225.286C487.718 225.258 487.781 225.237 487.816 225.223C487.991 225.174 488.142 225.128 488.268 225.086L488.394 225.695C487.694 225.94 487.148 226.063 486.756 226.063C486.035 226.063 485.457 225.846 485.023 225.412C484.589 224.971 484.372 224.313 484.372 223.438C484.372 222.556 484.575 221.87 484.981 221.38C485.394 220.89 485.912 220.645 486.535 220.645C487.165 220.645 487.655 220.848 488.005 221.254C488.355 221.66 488.53 222.209 488.53 222.902C488.53 223.091 488.523 223.305 488.509 223.543ZM485.212 222.944H487.774C487.774 222.426 487.683 222.027 487.501 221.747C487.319 221.467 487.001 221.327 486.546 221.327C486.098 221.327 485.769 221.478 485.559 221.779C485.349 222.08 485.233 222.468 485.212 222.944ZM492.218 220.634C492.89 220.634 493.37 220.872 493.657 221.348C494.252 220.872 494.801 220.634 495.305 220.634C495.809 220.634 496.219 220.778 496.534 221.065C496.856 221.345 497.017 221.754 497.017 222.293V226H496.25V222.619C496.25 222.192 496.152 221.87 495.956 221.653C495.767 221.429 495.512 221.317 495.19 221.317C494.749 221.317 494.304 221.492 493.856 221.842C493.891 221.996 493.909 222.146 493.909 222.293V226H493.142V222.619C493.142 222.192 493.044 221.87 492.848 221.653C492.659 221.429 492.404 221.317 492.082 221.317C491.872 221.317 491.679 221.345 491.504 221.401C491.329 221.457 491.2 221.513 491.116 221.569C491.032 221.625 490.923 221.709 490.79 221.821V226H490.003V220.75H490.507L490.643 221.285C490.818 221.138 490.951 221.033 491.042 220.97C491.14 220.9 491.298 220.827 491.515 220.75C491.732 220.673 491.966 220.634 492.218 220.634ZM501.192 222.86H501.622C501.622 222.223 501.542 221.81 501.381 221.621C501.22 221.425 500.863 221.327 500.31 221.327C499.757 221.327 499.288 221.401 498.903 221.548L498.756 220.939C499.344 220.743 499.953 220.645 500.583 220.645C501.815 220.645 502.431 221.261 502.431 222.493V226H501.969L501.696 225.38C501.374 225.646 501.094 225.828 500.856 225.926C500.625 226.017 500.355 226.063 500.047 226.063C499.557 226.063 499.176 225.919 498.903 225.632C498.63 225.338 498.493 224.953 498.493 224.477C498.493 223.399 499.393 222.86 501.192 222.86ZM501.633 223.522H501.16C500.446 223.522 499.953 223.592 499.68 223.732C499.414 223.872 499.281 224.092 499.281 224.393C499.281 224.687 499.358 224.929 499.512 225.118C499.666 225.307 499.865 225.401 500.11 225.401C500.362 225.401 500.6 225.345 500.824 225.233C501.055 225.114 501.325 224.911 501.633 224.624V223.522ZM507.75 226H506.963V218.65H507.75V226ZM510.447 221.831V226H509.66V220.75H510.164L510.29 221.264C510.451 221.138 510.58 221.04 510.678 220.97C510.783 220.9 510.948 220.83 511.172 220.76C511.396 220.683 511.634 220.645 511.886 220.645C512.369 220.645 512.768 220.795 513.083 221.096C513.405 221.39 513.566 221.81 513.566 222.356V226H512.778V222.587C512.778 221.74 512.425 221.317 511.718 221.317C511.214 221.317 510.79 221.488 510.447 221.831ZM515.6 224.866V221.38H514.886V220.75H515.61V219.248H516.398V220.75H517.679V221.38H516.387V224.719C516.387 225.188 516.625 225.422 517.101 225.422C517.213 225.422 517.385 225.401 517.616 225.359L517.731 225.926C517.444 226.017 517.147 226.063 516.839 226.063C516.538 226.063 516.254 225.972 515.988 225.79C515.729 225.601 515.6 225.293 515.6 224.866ZM519.891 221.989V226H519.103V220.75H519.607L519.733 221.369C520.069 221.103 520.349 220.918 520.573 220.813C520.797 220.701 521.053 220.645 521.34 220.645C521.48 220.645 521.585 220.652 521.655 220.666L521.802 220.708L521.676 221.432C521.55 221.39 521.378 221.369 521.161 221.369C520.741 221.369 520.318 221.576 519.891 221.989ZM526.244 223.417C526.244 222.738 526.111 222.22 525.845 221.863C525.579 221.506 525.191 221.327 524.68 221.327C524.169 221.327 523.805 221.499 523.588 221.842C523.378 222.178 523.273 222.696 523.273 223.396C523.273 224.719 523.759 225.38 524.732 225.38C525.243 225.38 525.621 225.223 525.866 224.908C526.118 224.586 526.244 224.089 526.244 223.417ZM526.433 225.349C526.034 225.825 525.471 226.063 524.743 226.063C524.015 226.063 523.455 225.828 523.063 225.359C522.678 224.883 522.485 224.222 522.485 223.375C522.485 222.521 522.671 221.852 523.042 221.369C523.42 220.886 523.969 220.645 524.69 220.645C525.418 220.645 525.989 220.89 526.402 221.38C526.822 221.87 527.032 222.535 527.032 223.375C527.032 224.215 526.832 224.873 526.433 225.349ZM528.235 225.065C528.69 225.275 529.124 225.38 529.537 225.38C529.95 225.38 530.262 225.3 530.472 225.139C530.689 224.971 530.797 224.75 530.797 224.477C530.797 224.204 530.706 223.994 530.524 223.847C530.342 223.693 530.118 223.574 529.852 223.49C529.593 223.406 529.331 223.315 529.065 223.217C528.806 223.119 528.585 222.972 528.403 222.776C528.221 222.58 528.13 222.332 528.13 222.031C528.13 221.59 528.274 221.25 528.561 221.012C528.848 220.767 529.236 220.645 529.726 220.645C530.216 220.645 530.671 220.718 531.091 220.865L531.165 220.897L531.028 221.569C530.608 221.408 530.216 221.327 529.852 221.327C529.495 221.327 529.25 221.383 529.117 221.495C528.984 221.607 528.918 221.796 528.918 222.062C528.918 222.23 529.009 222.374 529.191 222.493C529.373 222.612 529.593 222.717 529.852 222.808C530.118 222.892 530.381 222.993 530.64 223.112C530.906 223.224 531.13 223.396 531.312 223.627C531.494 223.858 531.585 224.141 531.585 224.477C531.585 224.967 531.413 225.356 531.07 225.643C530.727 225.923 530.255 226.063 529.653 226.063C529.051 226.063 528.515 225.927 528.046 225.654L528.235 225.065ZM533.795 228.499H533.008V220.76H533.47L533.743 221.348C534.037 221.124 534.31 220.953 534.562 220.834C534.821 220.708 535.104 220.645 535.412 220.645C536.672 220.645 537.302 221.551 537.302 223.364C537.302 224.393 537.078 225.111 536.63 225.517C536.231 225.888 535.776 226.074 535.265 226.074C534.761 226.074 534.271 225.905 533.795 225.569V228.499ZM533.795 222.052V224.855C533.935 225.023 534.124 225.156 534.362 225.254C534.6 225.352 534.828 225.401 535.045 225.401C535.591 225.401 535.972 225.24 536.189 224.918C536.406 224.596 536.515 224.092 536.515 223.406C536.515 222.72 536.406 222.202 536.189 221.852C535.972 221.502 535.696 221.327 535.36 221.327C535.136 221.327 534.912 221.373 534.688 221.464C534.471 221.555 534.306 221.642 534.194 221.726C534.089 221.803 533.956 221.912 533.795 222.052ZM542.383 223.543H539.034C539.034 224.215 539.191 224.691 539.506 224.971C539.828 225.251 540.231 225.391 540.714 225.391C540.959 225.391 541.13 225.38 541.228 225.359C541.326 225.331 541.417 225.307 541.501 225.286C541.592 225.258 541.655 225.237 541.69 225.223C541.865 225.174 542.016 225.128 542.142 225.086L542.268 225.695C541.568 225.94 541.022 226.063 540.63 226.063C539.909 226.063 539.331 225.846 538.897 225.412C538.463 224.971 538.246 224.313 538.246 223.438C538.246 222.556 538.449 221.87 538.855 221.38C539.268 220.89 539.786 220.645 540.409 220.645C541.039 220.645 541.529 220.848 541.879 221.254C542.229 221.66 542.404 222.209 542.404 222.902C542.404 223.091 542.397 223.305 542.383 223.543ZM539.086 222.944H541.648C541.648 222.426 541.557 222.027 541.375 221.747C541.193 221.467 540.875 221.327 540.42 221.327C539.972 221.327 539.643 221.478 539.433 221.779C539.223 222.08 539.107 222.468 539.086 222.944ZM546.964 225.181L547.121 225.8C546.561 225.968 546.068 226.053 545.641 226.053C544.892 226.053 544.328 225.807 543.95 225.317C543.572 224.827 543.383 224.152 543.383 223.291C543.383 222.43 543.579 221.775 543.971 221.327C544.363 220.872 544.941 220.645 545.704 220.645C546.033 220.645 546.495 220.729 547.09 220.897L546.775 221.506C546.39 221.394 546.043 221.338 545.735 221.338C545.203 221.338 544.818 221.495 544.58 221.81C544.349 222.125 544.234 222.622 544.234 223.302C544.234 224.68 544.727 225.37 545.714 225.37C546.106 225.37 546.523 225.307 546.964 225.181ZM548.545 224.866V221.38H547.831V220.75H548.556V219.248H549.343V220.75H550.624V221.38H549.333V224.719C549.333 225.188 549.571 225.422 550.047 225.422C550.159 225.422 550.33 225.401 550.561 225.359L550.677 225.926C550.39 226.017 550.092 226.063 549.784 226.063C549.483 226.063 549.2 225.972 548.934 225.79C548.675 225.601 548.545 225.293 548.545 224.866ZM551.902 226V220.75H552.69V226H551.902ZM552.69 218.65V219.584H551.902V218.65H552.69ZM557.683 223.417C557.683 222.738 557.55 222.22 557.284 221.863C557.018 221.506 556.629 221.327 556.118 221.327C555.607 221.327 555.243 221.499 555.026 221.842C554.816 222.178 554.711 222.696 554.711 223.396C554.711 224.719 555.198 225.38 556.171 225.38C556.682 225.38 557.06 225.223 557.305 224.908C557.557 224.586 557.683 224.089 557.683 223.417ZM557.872 225.349C557.473 225.825 556.909 226.063 556.181 226.063C555.453 226.063 554.893 225.828 554.501 225.359C554.116 224.883 553.924 224.222 553.924 223.375C553.924 222.521 554.109 221.852 554.48 221.369C554.858 220.886 555.408 220.645 556.129 220.645C556.857 220.645 557.427 220.89 557.84 221.38C558.26 221.87 558.47 222.535 558.47 223.375C558.47 224.215 558.271 224.873 557.872 225.349ZM560.66 221.831V226H559.873V220.75H560.377L560.503 221.264C560.664 221.138 560.793 221.04 560.891 220.97C560.996 220.9 561.161 220.83 561.385 220.76C561.609 220.683 561.847 220.645 562.099 220.645C562.582 220.645 562.981 220.795 563.296 221.096C563.618 221.39 563.779 221.81 563.779 222.356V226H562.991V222.587C562.991 221.74 562.638 221.317 561.931 221.317C561.427 221.317 561.003 221.488 560.66 221.831Z"
          fill="#64748B"
        />
      </g>
      <g clipPath="url(#clip3_768_38002)">
        <path
          d="M321.611 182.635L317.861 181.072C317.747 181.025 317.625 181 317.501 181C317.377 181 317.255 181.025 317.141 181.072L313.391 182.635C313.041 182.779 312.812 183.121 312.812 183.5C312.812 187.377 315.049 190.057 317.139 190.928C317.369 191.023 317.629 191.023 317.859 190.928C319.533 190.23 322.188 187.822 322.188 183.5C322.188 183.121 321.959 182.779 321.611 182.635ZM317.502 189.717L317.5 182.275L320.936 183.707C320.871 186.664 319.332 188.807 317.502 189.717V189.717Z"
          fill="#64748B"
        />
        <path
          d="M333.903 190H332.391L331.866 188.204H329.651L329.136 190H327.676L329.882 182.65H331.677L333.903 190ZM331.583 186.997L330.774 183.973L329.955 186.997H331.583ZM338.661 190H337.632L337.422 189.401C336.834 189.842 336.298 190.063 335.815 190.063C335.339 190.063 334.944 189.839 334.629 189.391C334.321 188.936 334.167 188.267 334.167 187.385C334.167 186.496 334.342 185.817 334.692 185.348C335.049 184.879 335.514 184.645 336.088 184.645C336.466 184.645 336.872 184.82 337.306 185.17V182.65H338.661V190ZM337.296 188.383V186.293C336.925 185.985 336.613 185.831 336.361 185.831C336.109 185.831 335.906 185.961 335.752 186.22C335.605 186.479 335.532 186.864 335.532 187.375C335.532 188.355 335.798 188.845 336.33 188.845C336.603 188.845 336.925 188.691 337.296 188.383ZM344.351 190H343.322L343.112 189.401C342.524 189.842 341.989 190.063 341.506 190.063C341.03 190.063 340.634 189.839 340.319 189.391C340.011 188.936 339.857 188.267 339.857 187.385C339.857 186.496 340.032 185.817 340.382 185.348C340.739 184.879 341.205 184.645 341.779 184.645C342.157 184.645 342.563 184.82 342.997 185.17V182.65H344.351V190ZM342.986 188.383V186.293C342.615 185.985 342.304 185.831 342.052 185.831C341.8 185.831 341.597 185.961 341.443 186.22C341.296 186.479 341.222 186.864 341.222 187.375C341.222 188.355 341.488 188.845 342.02 188.845C342.293 188.845 342.615 188.691 342.986 188.383ZM347.386 183.962H346.021V182.65H347.386V183.962ZM347.386 190H346.021V184.75H347.386V190ZM348.994 188.866V185.905H348.459V184.75H349.005V183.248H350.359V184.75H351.462V185.905H350.349V188.194C350.349 188.663 350.492 188.897 350.779 188.897C350.94 188.897 351.112 188.876 351.294 188.834L351.514 189.926C351.192 190.017 350.849 190.063 350.485 190.063C350.128 190.063 349.789 189.972 349.467 189.79C349.152 189.601 348.994 189.293 348.994 188.866ZM354 183.962H352.635V182.65H354V183.962ZM354 190H352.635V184.75H354V190ZM359.997 187.385C359.997 188.225 359.784 188.883 359.357 189.359C358.93 189.835 358.324 190.074 357.54 190.074C356.756 190.074 356.161 189.835 355.755 189.359C355.349 188.883 355.146 188.222 355.146 187.375C355.146 186.528 355.349 185.863 355.755 185.38C356.161 184.89 356.746 184.645 357.509 184.645C358.272 184.645 358.877 184.893 359.325 185.39C359.773 185.88 359.997 186.545 359.997 187.385ZM358.601 187.364C358.601 186.293 358.258 185.758 357.572 185.758C356.872 185.758 356.522 186.29 356.522 187.354C356.522 188.418 356.875 188.95 357.582 188.95C357.96 188.95 358.223 188.817 358.37 188.551C358.524 188.278 358.601 187.882 358.601 187.364ZM365.65 190H364.264V186.86C364.264 186.573 364.208 186.342 364.096 186.167C363.984 185.985 363.798 185.894 363.539 185.894C363.28 185.894 362.958 186.055 362.573 186.377V190H361.198V184.75H362.353L362.573 185.222C362.874 184.998 363.133 184.848 363.35 184.771C363.574 184.687 363.833 184.645 364.127 184.645C364.596 184.645 364.967 184.802 365.24 185.117C365.513 185.425 365.65 185.884 365.65 186.493V190ZM370.133 190L369.923 189.475C369.678 189.699 369.461 189.856 369.272 189.947C369.083 190.032 368.855 190.074 368.589 190.074C368.141 190.074 367.749 189.919 367.413 189.611C367.084 189.296 366.92 188.88 366.92 188.362C366.92 187.844 367.123 187.438 367.529 187.144C367.935 186.843 368.547 186.692 369.366 186.692H369.797C369.797 186.391 369.723 186.15 369.576 185.968C369.436 185.786 369.219 185.695 368.925 185.695C368.414 185.695 367.896 185.765 367.371 185.905L367.14 184.981C367.833 184.757 368.53 184.645 369.23 184.645C370.504 184.645 371.141 185.24 371.141 186.43V190H370.133ZM369.776 187.7H369.324C368.932 187.7 368.666 187.753 368.526 187.858C368.386 187.963 368.316 188.117 368.316 188.32C368.316 188.516 368.369 188.677 368.474 188.803C368.579 188.929 368.715 188.992 368.883 188.992C369.121 188.992 369.419 188.803 369.776 188.425V187.7ZM373.996 190H372.631V182.65H373.996V190ZM382.435 182.912L382.183 184.141L381.532 183.962C381.07 183.857 380.668 183.805 380.325 183.805C379.849 183.805 379.611 184.032 379.611 184.487C379.611 184.662 379.691 184.823 379.852 184.97C380.02 185.11 380.23 185.229 380.482 185.327C380.734 185.418 381.004 185.534 381.291 185.674C381.578 185.814 381.847 185.964 382.099 186.125C382.351 186.286 382.558 186.507 382.719 186.787C382.887 187.067 382.971 187.389 382.971 187.753C382.971 188.474 382.736 189.041 382.267 189.454C381.805 189.86 381.151 190.063 380.304 190.063C379.87 190.063 379.436 190.007 379.002 189.895C378.575 189.776 378.221 189.639 377.941 189.485L378.393 188.362C379.037 188.656 379.674 188.803 380.304 188.803C380.661 188.803 380.941 188.722 381.144 188.561C381.347 188.393 381.448 188.18 381.448 187.921C381.448 187.662 381.333 187.448 381.102 187.28C380.871 187.105 380.591 186.951 380.262 186.818C379.933 186.678 379.604 186.524 379.275 186.356C378.946 186.181 378.666 185.94 378.435 185.632C378.204 185.317 378.088 184.946 378.088 184.519C378.088 183.882 378.288 183.395 378.687 183.059C379.086 182.716 379.621 182.545 380.293 182.545C380.972 182.545 381.686 182.667 382.435 182.912ZM388.029 189.674C387.364 189.933 386.748 190.063 386.181 190.063C384.536 190.063 383.714 189.174 383.714 187.396C383.714 186.493 383.913 185.81 384.312 185.348C384.711 184.879 385.292 184.645 386.055 184.645C386.685 184.645 387.189 184.841 387.567 185.233C387.945 185.625 388.134 186.206 388.134 186.976C388.134 187.284 388.12 187.553 388.092 187.784H385.058C385.058 188.197 385.17 188.502 385.394 188.698C385.618 188.894 385.919 188.992 386.297 188.992C386.675 188.992 387.175 188.908 387.798 188.74L388.029 189.674ZM386.822 186.818V186.745C386.822 186.423 386.752 186.164 386.612 185.968C386.472 185.772 386.251 185.674 385.95 185.674C385.649 185.674 385.425 185.782 385.278 185.999C385.131 186.216 385.054 186.489 385.047 186.818H386.822ZM392.661 188.855L392.829 189.8C392.22 189.975 391.737 190.063 391.38 190.063C390.512 190.063 389.886 189.835 389.501 189.38C389.116 188.925 388.923 188.264 388.923 187.396C388.923 186.521 389.123 185.845 389.522 185.369C389.921 184.886 390.502 184.645 391.265 184.645C391.713 184.645 392.224 184.729 392.798 184.897L392.304 185.852C391.919 185.733 391.601 185.674 391.349 185.674C391.097 185.674 390.897 185.723 390.75 185.821C390.61 185.919 390.509 186.059 390.446 186.241C390.341 186.542 390.288 186.955 390.288 187.48C390.288 187.998 390.397 188.379 390.614 188.624C390.831 188.869 391.146 188.992 391.559 188.992C391.972 188.992 392.339 188.946 392.661 188.855ZM393.813 184.75H395.199V187.963C395.199 188.25 395.255 188.484 395.367 188.666C395.479 188.841 395.664 188.929 395.923 188.929C396.182 188.929 396.504 188.768 396.889 188.446V184.75H398.265V190H397.11L396.889 189.496C396.588 189.72 396.326 189.87 396.102 189.947C395.885 190.024 395.629 190.063 395.335 190.063C394.866 190.063 394.495 189.909 394.222 189.601C393.949 189.293 393.813 188.834 393.813 188.225V184.75ZM401.343 186.514V190H399.968V184.75H401.06L401.186 185.264C401.466 185.04 401.7 184.883 401.889 184.792C402.078 184.694 402.243 184.645 402.383 184.645C402.53 184.645 402.628 184.648 402.677 184.655C402.726 184.655 402.768 184.659 402.803 184.666C402.838 184.673 402.897 184.687 402.981 184.708L402.855 185.957C402.729 185.915 402.558 185.894 402.341 185.894C402.047 185.894 401.714 186.101 401.343 186.514ZM405.392 183.962H404.027V182.65H405.392V183.962ZM405.392 190H404.027V184.75H405.392V190ZM407.001 188.866V185.905H406.465V184.75H407.011V183.248H408.366V184.75H409.468V185.905H408.355V188.194C408.355 188.663 408.499 188.897 408.786 188.897C408.947 188.897 409.118 188.876 409.3 188.834L409.521 189.926C409.199 190.017 408.856 190.063 408.492 190.063C408.135 190.063 407.795 189.972 407.473 189.79C407.158 189.601 407.001 189.293 407.001 188.866ZM411.565 190.105L409.843 184.75H411.208L412.227 188.372L413.256 184.75H414.6L412.846 190C412.629 190.644 412.356 191.159 412.027 191.543C411.698 191.929 411.285 192.24 410.788 192.478L410.284 191.512C410.564 191.393 410.827 191.211 411.072 190.966C411.317 190.728 411.481 190.441 411.565 190.105ZM420.627 190.053C419.598 190.053 418.821 189.699 418.296 188.992C417.771 188.278 417.509 187.371 417.509 186.272C417.509 185.173 417.771 184.277 418.296 183.584C418.828 182.891 419.605 182.545 420.627 182.545C421.656 182.545 422.437 182.891 422.969 183.584C423.501 184.277 423.767 185.173 423.767 186.272C423.767 187.777 423.308 188.862 422.391 189.527C421.908 189.877 421.32 190.053 420.627 190.053ZM420.648 183.752C420.277 183.752 419.966 183.882 419.714 184.141C419.266 184.589 419.042 185.299 419.042 186.272C419.042 187.007 419.178 187.62 419.451 188.11C419.724 188.593 420.123 188.834 420.648 188.834C421.18 188.834 421.579 188.589 421.845 188.099C422.111 187.602 422.244 187 422.244 186.293C422.244 185.579 422.101 184.977 421.814 184.487C421.534 183.997 421.145 183.752 420.648 183.752ZM426.26 192.489H424.895V184.75H425.934L426.186 185.306C426.445 185.089 426.68 184.925 426.89 184.813C427.107 184.701 427.348 184.645 427.614 184.645C428.195 184.645 428.636 184.886 428.937 185.369C429.245 185.852 429.399 186.528 429.399 187.396C429.399 188.264 429.203 188.929 428.811 189.391C428.419 189.846 427.957 190.074 427.425 190.074C427.04 190.074 426.652 189.905 426.26 189.569V192.489ZM426.26 186.367V188.288C426.484 188.652 426.76 188.834 427.089 188.834C427.425 188.834 427.656 188.715 427.782 188.477C427.915 188.239 427.982 187.875 427.982 187.385C427.982 186.895 427.912 186.517 427.772 186.251C427.632 185.985 427.457 185.852 427.247 185.852C426.946 185.852 426.617 186.024 426.26 186.367ZM430.574 188.866V185.905H430.039V184.75H430.585V183.248H431.939V184.75H433.042V185.905H431.929V188.194C431.929 188.663 432.072 188.897 432.359 188.897C432.52 188.897 432.692 188.876 432.874 188.834L433.094 189.926C432.772 190.017 432.429 190.063 432.065 190.063C431.708 190.063 431.369 189.972 431.047 189.79C430.732 189.601 430.574 189.293 430.574 188.866ZM435.58 183.962H434.215V182.65H435.58V183.962ZM435.58 190H434.215V184.75H435.58V190ZM441.577 187.385C441.577 188.225 441.364 188.883 440.937 189.359C440.51 189.835 439.904 190.074 439.12 190.074C438.336 190.074 437.741 189.835 437.335 189.359C436.929 188.883 436.726 188.222 436.726 187.375C436.726 186.528 436.929 185.863 437.335 185.38C437.741 184.89 438.326 184.645 439.089 184.645C439.852 184.645 440.457 184.893 440.905 185.39C441.353 185.88 441.577 186.545 441.577 187.385ZM440.181 187.364C440.181 186.293 439.838 185.758 439.152 185.758C438.452 185.758 438.102 186.29 438.102 187.354C438.102 188.418 438.455 188.95 439.162 188.95C439.54 188.95 439.803 188.817 439.95 188.551C440.104 188.278 440.181 187.882 440.181 187.364ZM447.23 190H445.844V186.86C445.844 186.573 445.788 186.342 445.676 186.167C445.564 185.985 445.378 185.894 445.119 185.894C444.86 185.894 444.538 186.055 444.153 186.377V190H442.778V184.75H443.933L444.153 185.222C444.454 184.998 444.713 184.848 444.93 184.771C445.154 184.687 445.413 184.645 445.707 184.645C446.176 184.645 446.547 184.802 446.82 185.117C447.093 185.425 447.23 185.884 447.23 186.493V190ZM448.836 188.603C449.305 188.841 449.784 188.96 450.274 188.96C450.771 188.96 451.02 188.778 451.02 188.414C451.02 188.078 450.74 187.83 450.18 187.669C449.942 187.606 449.704 187.532 449.466 187.448C449.235 187.357 449.035 187.214 448.867 187.018C448.706 186.815 448.626 186.556 448.626 186.241C448.626 185.73 448.783 185.338 449.098 185.065C449.413 184.785 449.851 184.645 450.411 184.645C450.978 184.645 451.513 184.743 452.017 184.939L451.797 186.031C451.335 185.842 450.883 185.747 450.442 185.747C450.134 185.747 449.98 185.852 449.98 186.062C449.98 186.279 450.187 186.444 450.6 186.556C451.034 186.668 451.419 186.829 451.755 187.039C451.93 187.144 452.077 187.301 452.196 187.511C452.315 187.721 452.374 187.973 452.374 188.267C452.374 188.82 452.189 189.258 451.818 189.58C451.447 189.902 450.936 190.063 450.285 190.063C449.634 190.063 449.053 189.912 448.542 189.611L448.836 188.603Z"
          fill="#64748B"
        />
      </g>
      <g clipPath="url(#clip4_768_38002)">
        <path
          d="M315.896 207.582L312.646 204.332C312.451 204.137 312.451 203.82 312.646 203.625L313.354 202.918C313.549 202.723 313.865 202.723 314.061 202.918L316.25 205.107L320.939 200.418C321.135 200.223 321.451 200.223 321.646 200.418L322.354 201.125C322.549 201.32 322.549 201.637 322.354 201.832L316.604 207.582C316.408 207.777 316.092 207.777 315.896 207.582V207.582Z"
          fill="#64748B"
        />
        <path
          d="M334.019 204.062C334.019 205.245 333.676 206.197 332.99 206.918C332.304 207.639 331.387 208 330.239 208H328.706V200.65H330.564C331.607 200.65 332.444 200.968 333.074 201.605C333.704 202.242 334.019 203.061 334.019 204.062ZM333.168 203.978C333.168 203.152 332.916 202.505 332.412 202.036C331.908 201.567 331.306 201.332 330.606 201.332H329.556V207.317H330.333C331.124 207.317 331.793 207.02 332.339 206.425C332.892 205.83 333.168 205.014 333.168 203.978ZM339.147 205.543H335.798C335.798 206.215 335.955 206.691 336.27 206.971C336.592 207.251 336.995 207.391 337.478 207.391C337.723 207.391 337.894 207.38 337.992 207.359C338.09 207.331 338.181 207.307 338.265 207.286C338.356 207.258 338.419 207.237 338.454 207.223C338.629 207.174 338.78 207.128 338.906 207.086L339.032 207.695C338.332 207.94 337.786 208.063 337.394 208.063C336.673 208.063 336.095 207.846 335.661 207.412C335.227 206.971 335.01 206.313 335.01 205.438C335.01 204.556 335.213 203.87 335.619 203.38C336.032 202.89 336.55 202.645 337.173 202.645C337.803 202.645 338.293 202.848 338.643 203.254C338.993 203.66 339.168 204.209 339.168 204.902C339.168 205.091 339.161 205.305 339.147 205.543ZM335.85 204.944H338.412C338.412 204.426 338.321 204.027 338.139 203.747C337.957 203.467 337.639 203.327 337.184 203.327C336.736 203.327 336.407 203.478 336.197 203.779C335.987 204.08 335.871 204.468 335.85 204.944ZM341.429 210.499H340.641V202.76H341.103L341.376 203.348C341.67 203.124 341.943 202.953 342.195 202.834C342.454 202.708 342.738 202.645 343.046 202.645C344.306 202.645 344.936 203.551 344.936 205.364C344.936 206.393 344.712 207.111 344.264 207.517C343.865 207.888 343.41 208.074 342.899 208.074C342.395 208.074 341.905 207.905 341.429 207.569V210.499ZM341.429 204.052V206.855C341.569 207.023 341.758 207.156 341.996 207.254C342.234 207.352 342.461 207.401 342.678 207.401C343.224 207.401 343.606 207.24 343.823 206.918C344.04 206.596 344.148 206.092 344.148 205.406C344.148 204.72 344.04 204.202 343.823 203.852C343.606 203.502 343.329 203.327 342.993 203.327C342.769 203.327 342.545 203.373 342.321 203.464C342.104 203.555 341.94 203.642 341.828 203.726C341.723 203.803 341.59 203.912 341.429 204.052ZM346.499 206.866V203.38H345.785V202.75H346.509V201.248H347.297V202.75H348.578V203.38H347.286V206.719C347.286 207.188 347.524 207.422 348 207.422C348.112 207.422 348.284 207.401 348.515 207.359L348.63 207.926C348.343 208.017 348.046 208.063 347.738 208.063C347.437 208.063 347.153 207.972 346.887 207.79C346.628 207.601 346.499 207.293 346.499 206.866ZM353.93 208H353.142V204.545C353.142 203.698 352.789 203.275 352.082 203.275C351.557 203.275 351.126 203.443 350.79 203.779V208H350.003V200.65H350.78V203.138C350.934 203.012 351.053 202.921 351.137 202.865C351.228 202.809 351.371 202.753 351.567 202.698C351.77 202.641 351.998 202.613 352.25 202.613C352.733 202.613 353.132 202.76 353.447 203.054C353.769 203.348 353.93 203.768 353.93 204.314V208ZM363.04 204.209H363.796C363.747 205 363.653 205.581 363.513 205.952C363.471 206.078 363.401 206.246 363.303 206.457L364.804 207.989H363.754L362.893 207.055C362.655 207.342 362.323 207.583 361.896 207.779C361.469 207.975 361.035 208.074 360.594 208.074C359.796 208.074 359.183 207.884 358.756 207.506C358.336 207.128 358.126 206.617 358.126 205.973C358.126 205.511 358.252 205.147 358.504 204.881C358.756 204.615 359.162 204.346 359.722 204.073C359.309 203.702 359.005 203.387 358.809 203.128C358.613 202.869 358.515 202.606 358.515 202.34C358.515 201.815 358.704 201.385 359.082 201.049C359.46 200.713 359.946 200.545 360.541 200.545C361.136 200.545 361.609 200.702 361.959 201.017C362.316 201.325 362.494 201.703 362.494 202.151C362.494 202.599 362.368 202.974 362.116 203.275C361.871 203.576 361.476 203.873 360.93 204.167L362.704 205.889C362.928 205.427 363.04 204.867 363.04 204.209ZM362.4 206.551L360.247 204.493C359.358 204.899 358.914 205.413 358.914 206.036C358.914 206.442 359.064 206.771 359.365 207.023C359.673 207.268 360.044 207.391 360.478 207.391C360.919 207.391 361.308 207.307 361.644 207.139C361.987 206.964 362.239 206.768 362.4 206.551ZM359.302 202.13C359.302 202.389 359.365 202.596 359.491 202.75C359.617 202.904 359.712 203.016 359.775 203.086C359.922 203.247 360.135 203.453 360.415 203.705C361.297 203.264 361.738 202.753 361.738 202.172C361.738 201.857 361.619 201.623 361.381 201.469C361.143 201.308 360.849 201.227 360.499 201.227C360.149 201.227 359.862 201.311 359.638 201.479C359.414 201.647 359.302 201.864 359.302 202.13ZM374.242 208.011H373.381L369.843 202.12V208H369.024V200.65H369.843L373.455 206.761V200.65H374.242V208.011ZM379.395 205.417C379.395 204.738 379.262 204.22 378.996 203.863C378.73 203.506 378.341 203.327 377.83 203.327C377.319 203.327 376.955 203.499 376.738 203.842C376.528 204.178 376.423 204.696 376.423 205.396C376.423 206.719 376.91 207.38 377.883 207.38C378.394 207.38 378.772 207.223 379.017 206.908C379.269 206.586 379.395 206.089 379.395 205.417ZM379.584 207.349C379.185 207.825 378.621 208.063 377.893 208.063C377.165 208.063 376.605 207.828 376.213 207.359C375.828 206.883 375.636 206.222 375.636 205.375C375.636 204.521 375.821 203.852 376.192 203.369C376.57 202.886 377.12 202.645 377.841 202.645C378.569 202.645 379.139 202.89 379.552 203.38C379.972 203.87 380.182 204.535 380.182 205.375C380.182 206.215 379.983 206.873 379.584 207.349ZM384.577 200.65H385.365V208H384.903L384.64 207.401C383.996 207.856 383.436 208.084 382.96 208.084C381.7 208.084 381.07 207.177 381.07 205.364C381.07 204.335 381.294 203.618 381.742 203.212C382.141 202.841 382.593 202.655 383.097 202.655C383.601 202.655 384.094 202.827 384.577 203.17V200.65ZM384.577 206.698V203.968C384.43 203.793 384.234 203.642 383.989 203.516C383.751 203.39 383.531 203.327 383.328 203.327C382.782 203.327 382.4 203.488 382.183 203.81C381.966 204.132 381.858 204.636 381.858 205.322C381.858 206.008 381.966 206.526 382.183 206.876C382.4 207.226 382.677 207.401 383.013 207.401C383.517 207.401 384.038 207.167 384.577 206.698ZM390.919 205.543H387.57C387.57 206.215 387.727 206.691 388.042 206.971C388.364 207.251 388.767 207.391 389.25 207.391C389.495 207.391 389.666 207.38 389.764 207.359C389.862 207.331 389.953 207.307 390.037 207.286C390.128 207.258 390.191 207.237 390.226 207.223C390.401 207.174 390.552 207.128 390.678 207.086L390.804 207.695C390.104 207.94 389.558 208.063 389.166 208.063C388.445 208.063 387.867 207.846 387.433 207.412C386.999 206.971 386.782 206.313 386.782 205.438C386.782 204.556 386.985 203.87 387.391 203.38C387.804 202.89 388.322 202.645 388.945 202.645C389.575 202.645 390.065 202.848 390.415 203.254C390.765 203.66 390.94 204.209 390.94 204.902C390.94 205.091 390.933 205.305 390.919 205.543ZM387.622 204.944H390.184C390.184 204.426 390.093 204.027 389.911 203.747C389.729 203.467 389.411 203.327 388.956 203.327C388.508 203.327 388.179 203.478 387.969 203.779C387.759 204.08 387.643 204.468 387.622 204.944ZM398.976 208H395.038V200.65H395.826V207.317H398.976V208ZM399.854 208V202.75H400.641V208H399.854ZM400.641 200.65V201.584H399.854V200.65H400.641ZM404.606 202.634C405.278 202.634 405.757 202.872 406.044 203.348C406.639 202.872 407.189 202.634 407.693 202.634C408.197 202.634 408.606 202.778 408.921 203.065C409.243 203.345 409.404 203.754 409.404 204.293V208H408.638V204.619C408.638 204.192 408.54 203.87 408.344 203.653C408.155 203.429 407.899 203.317 407.577 203.317C407.136 203.317 406.692 203.492 406.244 203.842C406.279 203.996 406.296 204.146 406.296 204.293V208H405.53V204.619C405.53 204.192 405.432 203.87 405.236 203.653C405.047 203.429 404.791 203.317 404.469 203.317C404.259 203.317 404.067 203.345 403.892 203.401C403.717 203.457 403.587 203.513 403.503 203.569C403.419 203.625 403.311 203.709 403.178 203.821V208H402.39V202.75H402.894L403.031 203.285C403.206 203.138 403.339 203.033 403.43 202.97C403.528 202.9 403.685 202.827 403.902 202.75C404.119 202.673 404.354 202.634 404.606 202.634ZM411.164 208V202.75H411.951V208H411.164ZM411.951 200.65V201.584H411.164V200.65H411.951ZM413.826 206.866V203.38H413.112V202.75H413.837V201.248H414.624V202.75H415.905V203.38H414.614V206.719C414.614 207.188 414.852 207.422 415.328 207.422C415.44 207.422 415.611 207.401 415.842 207.359L415.958 207.926C415.671 208.017 415.373 208.063 415.065 208.063C414.764 208.063 414.481 207.972 414.215 207.79C413.956 207.601 413.826 207.293 413.826 206.866ZM417.131 207.065C417.586 207.275 418.02 207.38 418.433 207.38C418.846 207.38 419.157 207.3 419.367 207.139C419.584 206.971 419.693 206.75 419.693 206.477C419.693 206.204 419.602 205.994 419.42 205.847C419.238 205.693 419.014 205.574 418.748 205.49C418.489 205.406 418.226 205.315 417.96 205.217C417.701 205.119 417.481 204.972 417.299 204.776C417.117 204.58 417.026 204.332 417.026 204.031C417.026 203.59 417.169 203.25 417.456 203.012C417.743 202.767 418.132 202.645 418.622 202.645C419.112 202.645 419.567 202.718 419.987 202.865L420.06 202.897L419.924 203.569C419.504 203.408 419.112 203.327 418.748 203.327C418.391 203.327 418.146 203.383 418.013 203.495C417.88 203.607 417.813 203.796 417.813 204.062C417.813 204.23 417.904 204.374 418.086 204.493C418.268 204.612 418.489 204.717 418.748 204.808C419.014 204.892 419.276 204.993 419.535 205.112C419.801 205.224 420.025 205.396 420.207 205.627C420.389 205.858 420.48 206.141 420.48 206.477C420.48 206.967 420.309 207.356 419.966 207.643C419.623 207.923 419.15 208.063 418.548 208.063C417.946 208.063 417.411 207.927 416.942 207.654L417.131 207.065Z"
          fill="#64748B"
        />
      </g>
      <g clipPath="url(#clip5_768_38002)">
        <path
          d="M315.896 225.582L312.646 222.332C312.451 222.137 312.451 221.82 312.646 221.625L313.354 220.918C313.549 220.723 313.865 220.723 314.061 220.918L316.25 223.107L320.939 218.418C321.135 218.223 321.451 218.223 321.646 218.418L322.354 219.125C322.549 219.32 322.549 219.637 322.354 219.832L316.604 225.582C316.408 225.777 316.092 225.777 315.896 225.582V225.582Z"
          fill="#64748B"
        />
        <path
          d="M330.144 222.545H329.493V225.989H328.706V218.639H330.827C331.541 218.639 332.076 218.804 332.433 219.133C332.797 219.455 332.979 219.917 332.979 220.519C332.979 220.939 332.832 221.324 332.538 221.674C332.251 222.024 331.894 222.227 331.467 222.283C331.81 222.36 332.052 222.472 332.192 222.619C332.339 222.759 332.51 223.063 332.706 223.532L333.746 225.989H332.916L331.898 223.637C331.709 223.196 331.495 222.906 331.257 222.766C331.026 222.619 330.655 222.545 330.144 222.545ZM330.785 219.311H329.493V221.873H330.68C331.114 221.873 331.457 221.747 331.709 221.495C331.968 221.236 332.097 220.911 332.097 220.519C332.097 220.127 331.982 219.829 331.751 219.626C331.52 219.416 331.198 219.311 330.785 219.311ZM337.3 222.86H337.731C337.731 222.223 337.65 221.81 337.489 221.621C337.328 221.425 336.971 221.327 336.418 221.327C335.865 221.327 335.396 221.401 335.011 221.548L334.864 220.939C335.452 220.743 336.061 220.645 336.691 220.645C337.923 220.645 338.539 221.261 338.539 222.493V226H338.077L337.804 225.38C337.482 225.646 337.202 225.828 336.964 225.926C336.733 226.017 336.464 226.063 336.156 226.063C335.666 226.063 335.284 225.919 335.011 225.632C334.738 225.338 334.602 224.953 334.602 224.477C334.602 223.399 335.501 222.86 337.3 222.86ZM337.741 223.522H337.269C336.555 223.522 336.061 223.592 335.788 223.732C335.522 223.872 335.389 224.092 335.389 224.393C335.389 224.687 335.466 224.929 335.62 225.118C335.774 225.307 335.974 225.401 336.219 225.401C336.471 225.401 336.709 225.345 336.933 225.233C337.164 225.114 337.433 224.911 337.741 224.624V223.522ZM340.572 224.866V221.38H339.858V220.75H340.583V219.248H341.37V220.75H342.651V221.38H341.36V224.719C341.36 225.188 341.598 225.422 342.074 225.422C342.186 225.422 342.357 225.401 342.588 225.359L342.704 225.926C342.417 226.017 342.119 226.063 341.811 226.063C341.51 226.063 341.227 225.972 340.961 225.79C340.702 225.601 340.572 225.293 340.572 224.866ZM347.72 223.543H344.37C344.37 224.215 344.528 224.691 344.843 224.971C345.165 225.251 345.567 225.391 346.05 225.391C346.295 225.391 346.467 225.38 346.565 225.359C346.663 225.331 346.754 225.307 346.838 225.286C346.929 225.258 346.992 225.237 347.027 225.223C347.202 225.174 347.352 225.128 347.478 225.086L347.604 225.695C346.904 225.94 346.358 226.063 345.966 226.063C345.245 226.063 344.668 225.846 344.234 225.412C343.8 224.971 343.583 224.313 343.583 223.438C343.583 222.556 343.786 221.87 344.192 221.38C344.605 220.89 345.123 220.645 345.746 220.645C346.376 220.645 346.866 220.848 347.216 221.254C347.566 221.66 347.741 222.209 347.741 222.902C347.741 223.091 347.734 223.305 347.72 223.543ZM344.423 222.944H346.985C346.985 222.426 346.894 222.027 346.712 221.747C346.53 221.467 346.211 221.327 345.756 221.327C345.308 221.327 344.979 221.478 344.769 221.779C344.559 222.08 344.444 222.468 344.423 222.944ZM355.776 226H351.838V218.65H352.626V225.317H355.776V226ZM356.654 226V220.75H357.442V226H356.654ZM357.442 218.65V219.584H356.654V218.65H357.442ZM361.406 220.634C362.078 220.634 362.557 220.872 362.844 221.348C363.439 220.872 363.989 220.634 364.493 220.634C364.997 220.634 365.406 220.778 365.721 221.065C366.043 221.345 366.204 221.754 366.204 222.293V226H365.438V222.619C365.438 222.192 365.34 221.87 365.144 221.653C364.955 221.429 364.699 221.317 364.377 221.317C363.936 221.317 363.492 221.492 363.044 221.842C363.079 221.996 363.096 222.146 363.096 222.293V226H362.33V222.619C362.33 222.192 362.232 221.87 362.036 221.653C361.847 221.429 361.591 221.317 361.269 221.317C361.059 221.317 360.867 221.345 360.692 221.401C360.517 221.457 360.387 221.513 360.303 221.569C360.219 221.625 360.111 221.709 359.978 221.821V226H359.19V220.75H359.694L359.831 221.285C360.006 221.138 360.139 221.033 360.23 220.97C360.328 220.9 360.485 220.827 360.702 220.75C360.919 220.673 361.154 220.634 361.406 220.634ZM367.964 226V220.75H368.752V226H367.964ZM368.752 218.65V219.584H367.964V218.65H368.752ZM370.626 224.866V221.38H369.912V220.75H370.637V219.248H371.424V220.75H372.705V221.38H371.414V224.719C371.414 225.188 371.652 225.422 372.128 225.422C372.24 225.422 372.411 225.401 372.642 225.359L372.758 225.926C372.471 226.017 372.173 226.063 371.865 226.063C371.564 226.063 371.281 225.972 371.015 225.79C370.756 225.601 370.626 225.293 370.626 224.866ZM373.983 226V220.75H374.771V226H373.983ZM374.771 218.65V219.584H373.983V218.65H374.771ZM377.307 221.831V226H376.519V220.75H377.023L377.149 221.264C377.31 221.138 377.44 221.04 377.538 220.97C377.643 220.9 377.807 220.83 378.031 220.76C378.255 220.683 378.493 220.645 378.745 220.645C379.228 220.645 379.627 220.795 379.942 221.096C380.264 221.39 380.425 221.81 380.425 222.356V226H379.638V222.587C379.638 221.74 379.284 221.317 378.577 221.317C378.073 221.317 377.65 221.488 377.307 221.831ZM385.315 225.443C384.727 225.863 384.192 226.074 383.709 226.074C382.449 226.074 381.819 225.167 381.819 223.354C381.819 222.325 382.043 221.604 382.491 221.191C382.89 220.827 383.373 220.645 383.94 220.645C384.514 220.645 384.993 220.904 385.378 221.422L385.651 220.739H386.113V226.263C386.113 227.026 385.924 227.593 385.546 227.964C385.168 228.335 384.657 228.52 384.013 228.52C383.684 228.52 383.39 228.478 383.131 228.394C382.872 228.31 382.603 228.216 382.323 228.111L382.47 227.554C383.058 227.743 383.548 227.838 383.94 227.838C384.339 227.838 384.668 227.715 384.927 227.47C385.186 227.225 385.315 226.854 385.315 226.357V225.443ZM385.315 224.688V222.724C385.315 222.311 385.179 221.975 384.906 221.716C384.633 221.457 384.353 221.327 384.066 221.327C383.52 221.327 383.138 221.488 382.921 221.81C382.704 222.125 382.596 222.633 382.596 223.333C382.596 224.705 382.981 225.391 383.751 225.391C384.255 225.391 384.776 225.156 385.315 224.688ZM391.752 227.365C390.926 225.923 390.513 224.362 390.513 222.682C390.513 220.995 390.943 219.427 391.804 217.978L392.497 218.114C391.699 219.591 391.3 221.114 391.3 222.682C391.3 224.243 391.692 225.762 392.476 227.239L391.752 227.365ZM395.051 222.545H394.4V225.989H393.613V218.639H395.734C396.448 218.639 396.983 218.804 397.34 219.133C397.704 219.455 397.886 219.917 397.886 220.519C397.886 220.939 397.739 221.324 397.445 221.674C397.158 222.024 396.801 222.227 396.374 222.283C396.717 222.36 396.959 222.472 397.099 222.619C397.246 222.759 397.417 223.063 397.613 223.532L398.653 225.989H397.823L396.805 223.637C396.616 223.196 396.402 222.906 396.164 222.766C395.933 222.619 395.562 222.545 395.051 222.545ZM395.692 219.311H394.4V221.873H395.587C396.021 221.873 396.364 221.747 396.616 221.495C396.875 221.236 397.004 220.911 397.004 220.519C397.004 220.127 396.889 219.829 396.658 219.626C396.427 219.416 396.105 219.311 395.692 219.311ZM401.798 222.913H400.727V226H399.939V218.65H402.039C402.823 218.65 403.39 218.821 403.74 219.164C404.097 219.507 404.276 220.043 404.276 220.771C404.276 221.492 404.059 222.031 403.625 222.388C403.191 222.738 402.582 222.913 401.798 222.913ZM401.682 219.322H400.727V222.241H401.42C402.141 222.241 402.666 222.132 402.995 221.915C403.324 221.698 403.488 221.327 403.488 220.802C403.488 220.27 403.345 219.892 403.058 219.668C402.771 219.437 402.312 219.322 401.682 219.322ZM411.815 226H411.028V219.973L408.665 224.068L408.392 224.057L406.03 219.983V226H405.253V218.65H406.135L408.539 222.692L411.028 218.65H411.815V226ZM413.33 217.978C414.191 219.427 414.622 220.995 414.622 222.682C414.622 224.362 414.209 225.923 413.383 227.365L412.658 227.239C413.442 225.762 413.834 224.243 413.834 222.682C413.834 221.114 413.435 219.591 412.637 218.114L413.33 217.978Z"
          fill="#64748B"
        />
      </g>
      <g clipPath="url(#clip6_768_38002)">
        <path
          d="M315.896 243.582L312.646 240.332C312.451 240.137 312.451 239.82 312.646 239.625L313.354 238.918C313.549 238.723 313.865 238.723 314.061 238.918L316.25 241.107L320.939 236.418C321.135 236.223 321.451 236.223 321.646 236.418L322.354 237.125C322.549 237.32 322.549 237.637 322.354 237.832L316.604 243.582C316.408 243.777 316.092 243.777 315.896 243.582V243.582Z"
          fill="#64748B"
        />
        <path
          d="M328.706 244V236.65H330.806C331.555 236.65 332.115 236.814 332.486 237.143C332.857 237.465 333.042 237.927 333.042 238.529C333.042 238.935 332.909 239.271 332.643 239.537C332.377 239.803 332.017 239.964 331.562 240.02C332.122 240.104 332.556 240.304 332.864 240.619C333.179 240.934 333.336 241.326 333.336 241.795C333.336 242.46 333.105 242.995 332.643 243.401C332.188 243.8 331.551 244 330.732 244H328.706ZM329.525 243.317H330.984C331.446 243.317 331.817 243.177 332.097 242.897C332.377 242.617 332.517 242.267 332.517 241.847C332.517 241.427 332.367 241.081 332.066 240.808C331.772 240.535 331.338 240.398 330.764 240.398H329.525V243.317ZM330.858 237.332H329.525V239.726H330.753C331.138 239.726 331.478 239.621 331.772 239.411C332.073 239.194 332.223 238.897 332.223 238.519C332.223 237.756 331.768 237.36 330.858 237.332ZM337.136 240.86H337.567C337.567 240.223 337.486 239.81 337.325 239.621C337.164 239.425 336.807 239.327 336.254 239.327C335.701 239.327 335.232 239.401 334.847 239.548L334.7 238.939C335.288 238.743 335.897 238.645 336.527 238.645C337.759 238.645 338.375 239.261 338.375 240.493V244H337.913L337.64 243.38C337.318 243.646 337.038 243.828 336.8 243.926C336.569 244.017 336.3 244.063 335.992 244.063C335.502 244.063 335.12 243.919 334.847 243.632C334.574 243.338 334.438 242.953 334.438 242.477C334.438 241.399 335.337 240.86 337.136 240.86ZM337.577 241.522H337.105C336.391 241.522 335.897 241.592 335.624 241.732C335.358 241.872 335.225 242.092 335.225 242.393C335.225 242.687 335.302 242.929 335.456 243.118C335.61 243.307 335.81 243.401 336.055 243.401C336.307 243.401 336.545 243.345 336.769 243.233C337 243.114 337.269 242.911 337.577 242.624V241.522ZM340.408 242.866V239.38H339.694V238.75H340.419V237.248H341.206V238.75H342.487V239.38H341.196V242.719C341.196 243.188 341.434 243.422 341.91 243.422C342.022 243.422 342.193 243.401 342.424 243.359L342.54 243.926C342.253 244.017 341.955 244.063 341.647 244.063C341.346 244.063 341.063 243.972 340.797 243.79C340.538 243.601 340.408 243.293 340.408 242.866ZM346.999 243.181L347.157 243.8C346.597 243.968 346.103 244.053 345.676 244.053C344.927 244.053 344.364 243.807 343.986 243.317C343.608 242.827 343.419 242.152 343.419 241.291C343.419 240.43 343.615 239.775 344.007 239.327C344.399 238.872 344.976 238.645 345.739 238.645C346.068 238.645 346.53 238.729 347.125 238.897L346.81 239.506C346.425 239.394 346.079 239.338 345.771 239.338C345.239 239.338 344.854 239.495 344.616 239.81C344.385 240.125 344.269 240.622 344.269 241.302C344.269 242.68 344.763 243.37 345.75 243.37C346.142 243.37 346.558 243.307 346.999 243.181ZM352.382 244H351.594V240.545C351.594 239.698 351.241 239.275 350.534 239.275C350.009 239.275 349.578 239.443 349.242 239.779V244H348.455V236.65H349.232V239.138C349.386 239.012 349.505 238.921 349.589 238.865C349.68 238.809 349.823 238.753 350.019 238.698C350.222 238.641 350.45 238.613 350.702 238.613C351.185 238.613 351.584 238.76 351.899 239.054C352.221 239.348 352.382 239.768 352.382 240.314V244ZM358.352 240.545H357.701V243.989H356.914V236.639H359.035C359.749 236.639 360.284 236.804 360.641 237.133C361.005 237.455 361.187 237.917 361.187 238.519C361.187 238.939 361.04 239.324 360.746 239.674C360.459 240.024 360.102 240.227 359.675 240.283C360.018 240.36 360.26 240.472 360.4 240.619C360.547 240.759 360.718 241.063 360.914 241.532L361.954 243.989H361.124L360.106 241.637C359.917 241.196 359.703 240.906 359.465 240.766C359.234 240.619 358.863 240.545 358.352 240.545ZM358.993 237.311H357.701V239.873H358.888C359.322 239.873 359.665 239.747 359.917 239.495C360.176 239.236 360.305 238.911 360.305 238.519C360.305 238.127 360.19 237.829 359.959 237.626C359.728 237.416 359.406 237.311 358.993 237.311ZM366.884 241.543H363.535C363.535 242.215 363.692 242.691 364.007 242.971C364.329 243.251 364.732 243.391 365.215 243.391C365.46 243.391 365.631 243.38 365.729 243.359C365.827 243.331 365.918 243.307 366.002 243.286C366.093 243.258 366.156 243.237 366.191 243.223C366.366 243.174 366.517 243.128 366.643 243.086L366.769 243.695C366.069 243.94 365.523 244.063 365.131 244.063C364.41 244.063 363.832 243.846 363.398 243.412C362.964 242.971 362.747 242.313 362.747 241.438C362.747 240.556 362.95 239.87 363.356 239.38C363.769 238.89 364.287 238.645 364.91 238.645C365.54 238.645 366.03 238.848 366.38 239.254C366.73 239.66 366.905 240.209 366.905 240.902C366.905 241.091 366.898 241.305 366.884 241.543ZM363.587 240.944H366.149C366.149 240.426 366.058 240.027 365.876 239.747C365.694 239.467 365.376 239.327 364.921 239.327C364.473 239.327 364.144 239.478 363.934 239.779C363.724 240.08 363.608 240.468 363.587 240.944ZM371.37 242.551V240.125C371.23 239.908 371.006 239.723 370.698 239.569C370.39 239.408 370.107 239.327 369.848 239.327C369.435 239.327 369.13 239.485 368.934 239.8C368.745 240.115 368.651 240.622 368.651 241.322C368.651 242.701 369.106 243.391 370.016 243.391C370.289 243.391 370.548 243.314 370.793 243.16C371.045 243.006 371.237 242.803 371.37 242.551ZM372.158 246.52H371.37V243.412L371.202 243.58C371.09 243.685 370.996 243.765 370.919 243.821C370.842 243.87 370.709 243.926 370.52 243.989C370.338 244.046 370.135 244.074 369.911 244.074C369.33 244.074 368.843 243.867 368.451 243.454C368.059 243.041 367.863 242.397 367.863 241.522C367.863 240.647 368.024 239.95 368.346 239.432C368.668 238.907 369.183 238.645 369.89 238.645C370.387 238.645 370.898 238.879 371.423 239.348L371.696 238.75H372.158V246.52ZM377.072 242.666V238.75H377.87V244H377.408L377.145 243.38C376.585 243.835 376.05 244.063 375.539 244.063C375.028 244.063 374.636 243.916 374.363 243.622C374.097 243.321 373.964 242.897 373.964 242.351V238.75H374.751V242.225C374.751 242.638 374.811 242.936 374.93 243.118C375.056 243.3 375.259 243.391 375.539 243.391C375.826 243.391 376.116 243.314 376.41 243.16C376.704 243.006 376.925 242.841 377.072 242.666ZM383.424 241.543H380.074C380.074 242.215 380.232 242.691 380.547 242.971C380.869 243.251 381.271 243.391 381.754 243.391C381.999 243.391 382.171 243.38 382.269 243.359C382.367 243.331 382.458 243.307 382.542 243.286C382.633 243.258 382.696 243.237 382.731 243.223C382.906 243.174 383.056 243.128 383.182 243.086L383.308 243.695C382.608 243.94 382.062 244.063 381.67 244.063C380.949 244.063 380.372 243.846 379.938 243.412C379.504 242.971 379.287 242.313 379.287 241.438C379.287 240.556 379.49 239.87 379.896 239.38C380.309 238.89 380.827 238.645 381.45 238.645C382.08 238.645 382.57 238.848 382.92 239.254C383.27 239.66 383.445 240.209 383.445 240.902C383.445 241.091 383.438 241.305 383.424 241.543ZM380.127 240.944H382.689C382.689 240.426 382.598 240.027 382.416 239.747C382.234 239.467 381.915 239.327 381.46 239.327C381.012 239.327 380.683 239.478 380.473 239.779C380.263 240.08 380.148 240.468 380.127 240.944ZM384.718 243.065C385.173 243.275 385.607 243.38 386.02 243.38C386.433 243.38 386.744 243.3 386.954 243.139C387.171 242.971 387.28 242.75 387.28 242.477C387.28 242.204 387.189 241.994 387.007 241.847C386.825 241.693 386.601 241.574 386.335 241.49C386.076 241.406 385.813 241.315 385.547 241.217C385.288 241.119 385.068 240.972 384.886 240.776C384.704 240.58 384.613 240.332 384.613 240.031C384.613 239.59 384.756 239.25 385.043 239.012C385.33 238.767 385.719 238.645 386.209 238.645C386.699 238.645 387.154 238.718 387.574 238.865L387.647 238.897L387.511 239.569C387.091 239.408 386.699 239.327 386.335 239.327C385.978 239.327 385.733 239.383 385.6 239.495C385.467 239.607 385.4 239.796 385.4 240.062C385.4 240.23 385.491 240.374 385.673 240.493C385.855 240.612 386.076 240.717 386.335 240.808C386.601 240.892 386.863 240.993 387.122 241.112C387.388 241.224 387.612 241.396 387.794 241.627C387.976 241.858 388.067 242.141 388.067 242.477C388.067 242.967 387.896 243.356 387.553 243.643C387.21 243.923 386.737 244.063 386.135 244.063C385.533 244.063 384.998 243.927 384.529 243.654L384.718 243.065ZM389.617 242.866V239.38H388.903V238.75H389.627V237.248H390.415V238.75H391.696V239.38H390.404V242.719C390.404 243.188 390.642 243.422 391.118 243.422C391.23 243.422 391.402 243.401 391.633 243.359L391.748 243.926C391.461 244.017 391.164 244.063 390.856 244.063C390.555 244.063 390.271 243.972 390.005 243.79C389.746 243.601 389.617 243.293 389.617 242.866ZM399.683 244H395.746V236.65H396.533V243.317H399.683V244ZM400.561 244V238.75H401.349V244H400.561ZM401.349 236.65V237.584H400.561V236.65H401.349ZM405.313 238.634C405.985 238.634 406.465 238.872 406.752 239.348C407.347 238.872 407.896 238.634 408.4 238.634C408.904 238.634 409.314 238.778 409.629 239.065C409.951 239.345 410.112 239.754 410.112 240.293V244H409.345V240.619C409.345 240.192 409.247 239.87 409.051 239.653C408.862 239.429 408.607 239.317 408.285 239.317C407.844 239.317 407.399 239.492 406.951 239.842C406.986 239.996 407.004 240.146 407.004 240.293V244H406.237V240.619C406.237 240.192 406.139 239.87 405.943 239.653C405.754 239.429 405.499 239.317 405.177 239.317C404.967 239.317 404.774 239.345 404.599 239.401C404.424 239.457 404.295 239.513 404.211 239.569C404.127 239.625 404.018 239.709 403.885 239.821V244H403.098V238.75H403.602L403.738 239.285C403.913 239.138 404.046 239.033 404.137 238.97C404.235 238.9 404.393 238.827 404.61 238.75C404.827 238.673 405.061 238.634 405.313 238.634ZM411.871 244V238.75H412.659V244H411.871ZM412.659 236.65V237.584H411.871V236.65H412.659ZM414.534 242.866V239.38H413.82V238.75H414.544V237.248H415.332V238.75H416.613V239.38H415.321V242.719C415.321 243.188 415.559 243.422 416.035 243.422C416.147 243.422 416.319 243.401 416.55 243.359L416.665 243.926C416.378 244.017 416.081 244.063 415.773 244.063C415.472 244.063 415.188 243.972 414.922 243.79C414.663 243.601 414.534 243.293 414.534 242.866ZM417.838 243.065C418.293 243.275 418.727 243.38 419.14 243.38C419.553 243.38 419.865 243.3 420.075 243.139C420.292 242.971 420.4 242.75 420.4 242.477C420.4 242.204 420.309 241.994 420.127 241.847C419.945 241.693 419.721 241.574 419.455 241.49C419.196 241.406 418.934 241.315 418.668 241.217C418.409 241.119 418.188 240.972 418.006 240.776C417.824 240.58 417.733 240.332 417.733 240.031C417.733 239.59 417.877 239.25 418.164 239.012C418.451 238.767 418.839 238.645 419.329 238.645C419.819 238.645 420.274 238.718 420.694 238.865L420.768 238.897L420.631 239.569C420.211 239.408 419.819 239.327 419.455 239.327C419.098 239.327 418.853 239.383 418.72 239.495C418.587 239.607 418.521 239.796 418.521 240.062C418.521 240.23 418.612 240.374 418.794 240.493C418.976 240.612 419.196 240.717 419.455 240.808C419.721 240.892 419.984 240.993 420.243 241.112C420.509 241.224 420.733 241.396 420.915 241.627C421.097 241.858 421.188 242.141 421.188 242.477C421.188 242.967 421.016 243.356 420.673 243.643C420.33 243.923 419.858 244.063 419.256 244.063C418.654 244.063 418.118 243.927 417.649 243.654L417.838 243.065Z"
          fill="#64748B"
        />
      </g>
      <rect x="1" y="0.5" width="671" height="270" rx="2" stroke="#CBD5E1" />
      <defs>
        <filter
          id="filter0_d_768_38002"
          x="310.482"
          y="107.5"
          width="58.0693"
          height="58"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_768_38002"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect1_dropShadow_768_38002"
            result="shape"
          />
        </filter>
        <filter
          id="filter1_d_768_38002"
          x="23"
          y="23.5"
          width="172.215"
          height="52"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_768_38002"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect1_dropShadow_768_38002"
            result="shape"
          />
        </filter>
        <filter
          id="filter2_d_768_38002"
          x="23"
          y="197.5"
          width="172.215"
          height="52"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_768_38002"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect1_dropShadow_768_38002"
            result="shape"
          />
        </filter>
        <filter
          id="filter3_d_768_38002"
          x="23"
          y="110.5"
          width="172.215"
          height="52"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_768_38002"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect1_dropShadow_768_38002"
            result="shape"
          />
        </filter>
        <filter
          id="filter4_d_768_38002"
          x="483"
          y="110.5"
          width="172"
          height="52"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_768_38002"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect1_dropShadow_768_38002"
            result="shape"
          />
        </filter>
        <clipPath id="clip0_768_38002">
          <rect
            width="24"
            height="24"
            fill="white"
            transform="translate(327.517 123.5)"
          />
        </clipPath>
        <clipPath id="clip1_768_38002">
          <rect
            width="121"
            height="14"
            fill="white"
            transform="translate(452.5 197)"
          />
        </clipPath>
        <clipPath id="clip2_768_38002">
          <rect
            width="121"
            height="14"
            fill="white"
            transform="translate(452.5 215)"
          />
        </clipPath>
        <clipPath id="clip3_768_38002">
          <rect
            width="252"
            height="14"
            fill="white"
            transform="translate(312.5 179)"
          />
        </clipPath>
        <clipPath id="clip4_768_38002">
          <rect
            width="252"
            height="14"
            fill="white"
            transform="translate(312.5 197)"
          />
        </clipPath>
        <clipPath id="clip5_768_38002">
          <rect
            width="252"
            height="14"
            fill="white"
            transform="translate(312.5 215)"
          />
        </clipPath>
        <clipPath id="clip6_768_38002">
          <rect
            width="252"
            height="14"
            fill="white"
            transform="translate(312.5 233)"
          />
        </clipPath>
      </defs>
    </svg>
  );
}
