## Reporting Vulnerabilities

We’re extremely grateful for security researchers and users that report vulnerabilities to the Hasura Community. All reports are thoroughly investigated by a set of community volunteers and the Hasura team.

To report a security issue, please email us at [security@hasura.io](mailto:security@hasura.io) with all the details, attaching all necessary information.

### When Should I Report a Vulnerability?

- You think you have discovered a potential security vulnerability in the Hasura GraphQL Engine or related components.
- You are unsure how a vulnerability affects the Hasura GraphQL Engine.
- You think you discovered a vulnerability in another project that Hasura GraphQL Engine depends on (e.g. Heroku, Docker, etc).
- You want to report any other security risk that could potentially harm Hasura GraphQL Engine users.

### When Should I NOT Report a Vulnerability?

- You need help tuning Hasura GraphQL Engine components for security.
- You need help applying security related updates.
- Your issue is not security related.

## Security Vulnerability Response

Each report is acknowledged and analyzed by the project's maintainers and the security team within 3 working days. 

The reporter will be kept updated at every stage of the issue's analysis and resolution (triage -> fix -> release).

## Public Disclosure Timing

A public disclosure date is negotiated by the Hasura product security team and the bug submitter. We prefer to fully disclose the bug as soon as possible once a user mitigation is available. It is reasonable to delay disclosure when the bug or the fix is not yet fully understood, the solution is not well-tested, or for vendor coordination. The timeframe for disclosure is from immediate (especially if it's already publicly known) to a few weeks. We expect the time-frame between a report to a public disclosure to typically be in the order of 7 days. The Hasura GraphQL Engine maintainers and the security team will take the final call on setting a disclosure date.


(Some sections have been inspired and adapted from [https://github.com/kubernetes/website/blob/master/content/en/docs/reference/issues-security/security.md](https://github.com/kubernetes/website/blob/master/content/en/docs/reference/issues-security/security.md)).

## Translations

This document is available in the following translations:

- [French :fr:](translations/SECURITY.french.md)
- [Hindi :india:](translations/SECURITY.hindi.md)
- [Malayalam :india:](translations/SECURITY.malayalam.md)
