import React from 'react';

type Props = {
  className?: string;
};

export function QueryResponseCachingSvg(props: Props) {
  const { className } = props;
  return (
    <svg
      className={className}
      width="690"
      height="272"
      viewBox="0 0 690 272"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <rect x="1" y="1" width="671" height="270" rx="2" fill="#E2E8F0" />
      <g filter="url(#filter0_d_736_35256)">
        <rect
          x="312.482"
          y="109"
          width="54.0691"
          height="54"
          rx="3.5"
          fill="white"
        />
        <g clipPath="url(#clip0_736_35256)">
          <path
            d="M351.137 132.172C351.849 130.021 351.421 125.725 350.04 124.139C349.859 123.932 349.52 123.962 349.37 124.19L347.668 126.779C347.246 127.298 346.488 127.416 345.92 127.055C344.074 125.885 341.868 125.203 339.496 125.203C337.125 125.203 334.918 125.885 333.073 127.055C332.504 127.416 331.746 127.295 331.324 126.779L329.622 124.19C329.473 123.962 329.133 123.932 328.953 124.139C327.572 125.725 327.144 130.021 327.856 132.172C328.091 132.886 328.158 133.642 328.018 134.379C327.88 135.108 327.74 135.991 327.74 136.602C327.74 142.895 333.005 148 339.496 148C345.99 148 351.253 142.898 351.253 136.602C351.253 135.988 351.115 135.108 350.975 134.379C350.834 133.642 350.901 132.886 351.137 132.172ZM339.496 145.452C334.478 145.452 330.395 141.493 330.395 136.628C330.395 136.468 330.402 136.311 330.408 136.154C330.591 132.839 332.666 130.003 335.606 128.652C336.786 128.107 338.106 127.805 339.496 127.805C340.887 127.805 342.207 128.11 343.39 128.655C346.33 130.006 348.405 132.842 348.588 136.154C348.597 136.311 348.6 136.468 348.6 136.628C348.597 141.493 344.514 145.452 339.496 145.452Z"
            fill="black"
          />
          <path
            d="M343.438 140.024L341.113 136.116L339.117 132.856C339.071 132.779 338.986 132.732 338.891 132.732H336.984C336.889 132.732 336.804 132.782 336.758 132.859C336.712 132.939 336.712 133.037 336.761 133.114L338.668 136.225L336.107 140.012C336.055 140.089 336.049 140.19 336.095 140.273C336.141 140.356 336.229 140.406 336.324 140.406H338.243C338.332 140.406 338.414 140.362 338.463 140.29L339.848 138.193L341.088 140.279C341.134 140.359 341.223 140.406 341.315 140.406H343.206C343.301 140.406 343.387 140.359 343.432 140.279C343.487 140.199 343.487 140.104 343.438 140.024Z"
            fill="black"
          />
        </g>
      </g>
      <rect x="354.5" y="101" width="24" height="24" rx="12" fill="white" />
      <g clipPath="url(#clip1_736_35256)">
        <path
          d="M361.008 116.096L361.511 116.369L367.116 107.267L366.613 106.995L361.008 116.096Z"
          fill="#E535AB"
        />
        <path
          d="M372.103 115.369H360.893V115.914H372.103V115.369Z"
          fill="#E535AB"
        />
        <path
          d="M361.115 115.675L366.722 118.71L367.012 118.239L361.405 115.203L361.115 115.675Z"
          fill="#E535AB"
        />
        <path
          d="M365.986 107.765L371.593 110.8L371.884 110.328L366.276 107.293L365.986 107.765Z"
          fill="#E535AB"
        />
        <path
          d="M361.116 110.326L361.407 110.798L367.014 107.763L366.724 107.291L361.116 110.326Z"
          fill="#E535AB"
        />
        <path
          d="M365.884 107.267L371.49 116.369L371.993 116.096L366.387 106.995L365.884 107.267Z"
          fill="#E535AB"
        />
        <path
          d="M361.918 109.965H361.337V116.035H361.918V109.965Z"
          fill="#E535AB"
        />
        <path
          d="M371.662 109.965H371.081V116.035H371.662V109.965Z"
          fill="#E535AB"
        />
        <path
          d="M366.369 118.068L366.623 118.48L371.5 115.84L371.246 115.428L366.369 118.068Z"
          fill="#E535AB"
        />
        <path
          d="M372.432 116.212C372.096 116.76 371.347 116.947 370.763 116.632C370.178 116.317 369.979 115.615 370.315 115.067C370.651 114.519 371.4 114.332 371.984 114.647C372.572 114.965 372.772 115.664 372.432 116.212Z"
          fill="#E535AB"
        />
        <path
          d="M362.681 110.933C362.345 111.481 361.596 111.668 361.012 111.353C360.427 111.038 360.228 110.336 360.564 109.788C360.9 109.24 361.649 109.053 362.233 109.368C362.818 109.686 363.017 110.385 362.681 110.933Z"
          fill="#E535AB"
        />
        <path
          d="M360.567 116.212C360.231 115.664 360.431 114.965 361.015 114.647C361.6 114.332 362.345 114.519 362.685 115.067C363.021 115.615 362.821 116.314 362.237 116.632C361.649 116.947 360.903 116.76 360.567 116.212Z"
          fill="#E535AB"
        />
        <path
          d="M370.318 110.933C369.982 110.385 370.182 109.686 370.766 109.368C371.351 109.053 372.096 109.24 372.436 109.788C372.772 110.336 372.572 111.035 371.988 111.353C371.403 111.668 370.654 111.481 370.318 110.933Z"
          fill="#E535AB"
        />
        <path
          d="M366.5 119.425C365.824 119.425 365.278 118.913 365.278 118.28C365.278 117.646 365.824 117.134 366.5 117.134C367.175 117.134 367.721 117.646 367.721 118.28C367.721 118.91 367.175 119.425 366.5 119.425Z"
          fill="#E535AB"
        />
        <path
          d="M366.5 108.866C365.824 108.866 365.278 108.354 365.278 107.72C365.278 107.087 365.824 106.575 366.5 106.575C367.175 106.575 367.721 107.087 367.721 107.72C367.721 108.354 367.175 108.866 366.5 108.866Z"
          fill="#E535AB"
        />
      </g>
      <rect
        x="354.5"
        y="101"
        width="24"
        height="24"
        rx="12"
        stroke="#E2E8F0"
        strokeWidth="2"
      />
      <rect x="25" y="25" width="168.215" height="48" rx="3.5" fill="#CBD5E1" />
      <path
        d="M43.539 47.0312H41.1724L42.0461 44.3693C42.1281 44.0576 41.8923 43.75 41.5703 43.75H38.6172C38.3711 43.75 38.1619 43.9325 38.1291 44.1766L37.4728 49.0984C37.4339 49.3937 37.6635 49.6562 37.9609 49.6562H40.3952L39.4498 53.645C39.3759 53.9567 39.6138 54.25 39.9276 54.25C40.0999 54.25 40.2639 54.1598 40.3542 54.0039L43.9635 47.7695C44.1543 47.4435 43.9184 47.0312 43.539 47.0312Z"
        fill="#94A3B8"
      />
      <path
        d="M53.986 49.352H53.842V52.988H52.102V44.588H54.766C55.67 44.588 56.346 44.788 56.794 45.188C57.242 45.58 57.466 46.144 57.466 46.88C57.466 47.328 57.31 47.74 56.998 48.116C56.686 48.484 56.306 48.696 55.858 48.752C56.178 48.84 56.426 48.988 56.602 49.196C56.778 49.396 56.962 49.724 57.154 50.18L58.342 52.988H56.554L55.39 50.3C55.222 49.916 55.042 49.664 54.85 49.544C54.666 49.416 54.378 49.352 53.986 49.352ZM54.718 45.956H53.842V47.984H54.598C54.918 47.984 55.166 47.88 55.342 47.672C55.526 47.464 55.618 47.208 55.618 46.904C55.618 46.272 55.318 45.956 54.718 45.956ZM64.3365 53H59.3325V44.6H64.3365V45.98H61.0725V47.744H64.0365V49.148H61.0725V51.62H64.3365V53ZM70.5404 44.9L70.2524 46.304L69.5084 46.1C68.9804 45.98 68.5204 45.92 68.1284 45.92C67.5844 45.92 67.3124 46.18 67.3124 46.7C67.3124 46.9 67.4044 47.084 67.5884 47.252C67.7804 47.412 68.0204 47.548 68.3084 47.66C68.5964 47.764 68.9044 47.896 69.2324 48.056C69.5604 48.216 69.8684 48.388 70.1564 48.572C70.4444 48.756 70.6804 49.008 70.8644 49.328C71.0564 49.648 71.1524 50.016 71.1524 50.432C71.1524 51.256 70.8844 51.904 70.3484 52.376C69.8204 52.84 69.0724 53.072 68.1044 53.072C67.6084 53.072 67.1124 53.008 66.6164 52.88C66.1284 52.744 65.7244 52.588 65.4044 52.412L65.9204 51.128C66.6564 51.464 67.3844 51.632 68.1044 51.632C68.5124 51.632 68.8324 51.54 69.0644 51.356C69.2964 51.164 69.4124 50.92 69.4124 50.624C69.4124 50.328 69.2804 50.084 69.0164 49.892C68.7524 49.692 68.4324 49.516 68.0564 49.364C67.6804 49.204 67.3044 49.028 66.9284 48.836C66.5524 48.636 66.2324 48.36 65.9684 48.008C65.7044 47.648 65.5724 47.224 65.5724 46.736C65.5724 46.008 65.8004 45.452 66.2564 45.068C66.7124 44.676 67.3244 44.48 68.0924 44.48C68.8684 44.48 69.6844 44.62 70.5404 44.9ZM73.7658 53V46.004H71.8338V44.6H77.4018V46.004H75.4938V53H73.7658ZM86.4966 53H81.4926V44.6H86.4966V45.98H83.2326V47.744H86.1966V49.148H83.2326V51.62H86.4966V53ZM93.2045 53H91.6205V49.412C91.6205 49.084 91.5565 48.82 91.4285 48.62C91.3005 48.412 91.0885 48.308 90.7925 48.308C90.4965 48.308 90.1285 48.492 89.6885 48.86V53H88.1165V47H89.4365L89.6885 47.54C90.0325 47.284 90.3285 47.112 90.5765 47.024C90.8325 46.928 91.1285 46.88 91.4645 46.88C92.0005 46.88 92.4245 47.06 92.7365 47.42C93.0485 47.772 93.2045 48.296 93.2045 48.992V53ZM99.6958 53H98.5198L98.2798 52.316C97.6078 52.82 96.9958 53.072 96.4438 53.072C95.8998 53.072 95.4478 52.816 95.0878 52.304C94.7358 51.784 94.5598 51.02 94.5598 50.012C94.5598 48.996 94.7598 48.22 95.1598 47.684C95.5678 47.148 96.0998 46.88 96.7558 46.88C97.1878 46.88 97.6518 47.08 98.1478 47.48V44.6H99.6958V53ZM98.1358 51.152V48.764C97.7118 48.412 97.3558 48.236 97.0678 48.236C96.7798 48.236 96.5478 48.384 96.3718 48.68C96.2038 48.976 96.1198 49.416 96.1198 50C96.1198 51.12 96.4238 51.68 97.0318 51.68C97.3438 51.68 97.7118 51.504 98.1358 51.152ZM103.212 55.844H101.652V47H102.84L103.128 47.636C103.424 47.388 103.692 47.2 103.932 47.072C104.18 46.944 104.456 46.88 104.76 46.88C105.424 46.88 105.928 47.156 106.272 47.708C106.624 48.26 106.8 49.032 106.8 50.024C106.8 51.016 106.576 51.776 106.128 52.304C105.68 52.824 105.152 53.084 104.544 53.084C104.104 53.084 103.66 52.892 103.212 52.508V55.844ZM103.212 48.848V51.044C103.468 51.46 103.784 51.668 104.16 51.668C104.544 51.668 104.808 51.532 104.952 51.26C105.104 50.988 105.18 50.572 105.18 50.012C105.18 49.452 105.1 49.02 104.94 48.716C104.78 48.412 104.58 48.26 104.34 48.26C103.996 48.26 103.62 48.456 103.212 48.848ZM113.158 50.012C113.158 50.972 112.914 51.724 112.426 52.268C111.938 52.812 111.246 53.084 110.35 53.084C109.454 53.084 108.774 52.812 108.31 52.268C107.846 51.724 107.614 50.968 107.614 50C107.614 49.032 107.846 48.272 108.31 47.72C108.774 47.16 109.442 46.88 110.314 46.88C111.186 46.88 111.878 47.164 112.39 47.732C112.902 48.292 113.158 49.052 113.158 50.012ZM111.562 49.988C111.562 48.764 111.17 48.152 110.386 48.152C109.586 48.152 109.186 48.76 109.186 49.976C109.186 51.192 109.59 51.8 110.398 51.8C110.83 51.8 111.13 51.648 111.298 51.344C111.474 51.032 111.562 50.58 111.562 49.988ZM116.043 46.1H114.483V44.6H116.043V46.1ZM116.043 53H114.483V47H116.043V53ZM123.029 53H121.445V49.412C121.445 49.084 121.381 48.82 121.253 48.62C121.125 48.412 120.913 48.308 120.617 48.308C120.321 48.308 119.953 48.492 119.513 48.86V53H117.941V47H119.261L119.513 47.54C119.857 47.284 120.153 47.112 120.401 47.024C120.657 46.928 120.953 46.88 121.289 46.88C121.825 46.88 122.249 47.06 122.561 47.42C122.873 47.772 123.029 48.296 123.029 48.992V53ZM124.912 51.704V48.32H124.3V47H124.924V45.284H126.472V47H127.732V48.32H126.46V50.936C126.46 51.472 126.624 51.74 126.952 51.74C127.136 51.74 127.332 51.716 127.54 51.668L127.792 52.916C127.424 53.02 127.032 53.072 126.616 53.072C126.208 53.072 125.82 52.968 125.452 52.76C125.092 52.544 124.912 52.192 124.912 51.704ZM129.012 51.404C129.548 51.676 130.096 51.812 130.656 51.812C131.224 51.812 131.508 51.604 131.508 51.188C131.508 50.804 131.188 50.52 130.548 50.336C130.276 50.264 130.004 50.18 129.732 50.084C129.468 49.98 129.24 49.816 129.048 49.592C128.864 49.36 128.772 49.064 128.772 48.704C128.772 48.12 128.952 47.672 129.312 47.36C129.672 47.04 130.172 46.88 130.812 46.88C131.46 46.88 132.072 46.992 132.648 47.216L132.396 48.464C131.868 48.248 131.352 48.14 130.848 48.14C130.496 48.14 130.32 48.26 130.32 48.5C130.32 48.748 130.556 48.936 131.028 49.064C131.524 49.192 131.964 49.376 132.348 49.616C132.548 49.736 132.716 49.916 132.852 50.156C132.988 50.396 133.056 50.684 133.056 51.02C133.056 51.652 132.844 52.152 132.42 52.52C131.996 52.888 131.412 53.072 130.668 53.072C129.924 53.072 129.26 52.9 128.676 52.556L129.012 51.404Z"
        fill="#94A3B8"
      />
      <rect
        x="25"
        y="199"
        width="168.215"
        height="48"
        rx="3.5"
        fill="#CBD5E1"
      />
      <path
        d="M43.375 218.406C43.375 218.232 43.3059 218.065 43.1828 217.942C43.0597 217.819 42.8928 217.75 42.7188 217.75C42.5447 217.75 42.3778 217.819 42.2547 217.942C42.1316 218.065 42.0625 218.232 42.0625 218.406V220.375H43.375V218.406ZM44.3594 221.031H37.1406C37.0536 221.031 36.9701 221.066 36.9086 221.127C36.8471 221.189 36.8125 221.272 36.8125 221.359V222.016C36.8125 222.103 36.8471 222.186 36.9086 222.248C36.9701 222.309 37.0536 222.344 37.1406 222.344H37.4688V223C37.4689 223.756 37.7302 224.489 38.2085 225.075C38.6868 225.661 39.3527 226.064 40.0938 226.216V228.25H41.4062V226.216C42.1473 226.064 42.8132 225.661 43.2915 225.075C43.7698 224.489 44.0311 223.756 44.0312 223V222.344H44.3594C44.4464 222.344 44.5299 222.309 44.5914 222.248C44.6529 222.186 44.6875 222.103 44.6875 222.016V221.359C44.6875 221.272 44.6529 221.189 44.5914 221.127C44.5299 221.066 44.4464 221.031 44.3594 221.031ZM39.4375 218.406C39.4375 218.232 39.3684 218.065 39.2453 217.942C39.1222 217.819 38.9553 217.75 38.7812 217.75C38.6072 217.75 38.4403 217.819 38.3172 217.942C38.1941 218.065 38.125 218.232 38.125 218.406V220.375H39.4375V218.406Z"
        fill="#94A3B8"
      />
      <path
        d="M55.594 227.072C54.362 227.072 53.382 226.68 52.654 225.896C51.926 225.112 51.562 224.068 51.562 222.764C51.562 221.452 51.906 220.412 52.594 219.644C53.29 218.868 54.254 218.48 55.486 218.48C56.302 218.48 57.13 218.624 57.97 218.912L57.754 220.256C57.45 220.144 57.054 220.052 56.566 219.98C56.078 219.9 55.698 219.86 55.426 219.86C54.762 219.86 54.242 220.116 53.866 220.628C53.49 221.132 53.302 221.816 53.302 222.68C53.302 223.544 53.502 224.264 53.902 224.84C54.31 225.408 54.83 225.692 55.462 225.692C55.83 225.692 56.166 225.612 56.47 225.452V223.82H55.078V222.44H58.21V226.424C57.37 226.856 56.498 227.072 55.594 227.072ZM61.5518 223.016V227H59.9798V221H61.2278L61.3718 221.588C61.6918 221.332 61.9598 221.152 62.1758 221.048C62.3918 220.936 62.5798 220.88 62.7398 220.88C62.9078 220.88 63.0198 220.884 63.0758 220.892C63.1318 220.892 63.1798 220.896 63.2198 220.904C63.2598 220.912 63.3278 220.928 63.4238 220.952L63.2798 222.38C63.1358 222.332 62.9398 222.308 62.6918 222.308C62.3558 222.308 61.9758 222.544 61.5518 223.016ZM67.8473 227L67.6073 226.4C67.3273 226.656 67.0793 226.836 66.8633 226.94C66.6473 227.036 66.3873 227.084 66.0833 227.084C65.5713 227.084 65.1233 226.908 64.7393 226.556C64.3633 226.196 64.1753 225.72 64.1753 225.128C64.1753 224.536 64.4073 224.072 64.8713 223.736C65.3353 223.392 66.0353 223.22 66.9713 223.22H67.4633C67.4633 222.876 67.3793 222.6 67.2113 222.392C67.0513 222.184 66.8033 222.08 66.4673 222.08C65.8833 222.08 65.2913 222.16 64.6913 222.32L64.4273 221.264C65.2193 221.008 66.0153 220.88 66.8153 220.88C68.2713 220.88 68.9993 221.56 68.9993 222.92V227H67.8473ZM67.4393 224.372H66.9233C66.4753 224.372 66.1713 224.432 66.0113 224.552C65.8513 224.672 65.7713 224.848 65.7713 225.08C65.7713 225.304 65.8313 225.488 65.9513 225.632C66.0713 225.776 66.2273 225.848 66.4193 225.848C66.6913 225.848 67.0313 225.632 67.4393 225.2V224.372ZM72.2625 229.844H70.7025V221H71.8905L72.1785 221.636C72.4745 221.388 72.7425 221.2 72.9825 221.072C73.2305 220.944 73.5065 220.88 73.8105 220.88C74.4745 220.88 74.9785 221.156 75.3225 221.708C75.6745 222.26 75.8505 223.032 75.8505 224.024C75.8505 225.016 75.6265 225.776 75.1785 226.304C74.7305 226.824 74.2025 227.084 73.5945 227.084C73.1545 227.084 72.7105 226.892 72.2625 226.508V229.844ZM72.2625 222.848V225.044C72.5185 225.46 72.8345 225.668 73.2105 225.668C73.5945 225.668 73.8585 225.532 74.0025 225.26C74.1545 224.988 74.2305 224.572 74.2305 224.012C74.2305 223.452 74.1505 223.02 73.9905 222.716C73.8305 222.412 73.6305 222.26 73.3905 222.26C73.0465 222.26 72.6705 222.456 72.2625 222.848ZM82.3293 227H80.7693V223.412C80.7693 223.084 80.7053 222.82 80.5773 222.62C80.4493 222.412 80.2333 222.308 79.9293 222.308C79.6253 222.308 79.2533 222.492 78.8133 222.86V227H77.2533V218.6H78.8133V221.54C79.1573 221.284 79.4533 221.112 79.7013 221.024C79.9573 220.928 80.2533 220.88 80.5893 220.88C81.1253 220.88 81.5493 221.06 81.8613 221.42C82.1733 221.772 82.3293 222.296 82.3293 222.992V227ZM89.9968 225.668L91.1128 226.82L90.1648 227.768L89.0248 226.556C88.5368 226.908 87.9088 227.084 87.1408 227.084C86.3728 227.084 85.7168 226.88 85.1728 226.472C84.1328 225.712 83.6128 224.468 83.6128 222.74C83.6128 221.484 83.9128 220.46 84.5128 219.668C85.1208 218.876 86.0088 218.48 87.1768 218.48C88.3528 218.48 89.2448 218.876 89.8528 219.668C90.4608 220.46 90.7648 221.472 90.7648 222.704C90.7648 223.928 90.5088 224.916 89.9968 225.668ZM88.3288 223.904L88.7128 224.372C88.9208 223.964 89.0248 223.392 89.0248 222.656C89.0248 221.912 88.8608 221.26 88.5328 220.7C88.2128 220.132 87.7528 219.848 87.1528 219.848C86.5528 219.848 86.1048 220.128 85.8088 220.688C85.5128 221.248 85.3648 221.94 85.3648 222.764C85.3648 223.588 85.5208 224.284 85.8328 224.852C86.1448 225.412 86.5968 225.692 87.1888 225.692C87.5008 225.692 87.7528 225.62 87.9448 225.476L87.3688 224.852L88.3288 223.904ZM96.9492 227H91.9692V218.6H93.7092V225.62H96.9492V227ZM105.345 218.9L105.057 220.304L104.313 220.1C103.785 219.98 103.325 219.92 102.933 219.92C102.389 219.92 102.117 220.18 102.117 220.7C102.117 220.9 102.209 221.084 102.393 221.252C102.585 221.412 102.825 221.548 103.113 221.66C103.401 221.764 103.709 221.896 104.037 222.056C104.365 222.216 104.673 222.388 104.961 222.572C105.249 222.756 105.485 223.008 105.669 223.328C105.861 223.648 105.957 224.016 105.957 224.432C105.957 225.256 105.689 225.904 105.153 226.376C104.625 226.84 103.877 227.072 102.909 227.072C102.413 227.072 101.917 227.008 101.421 226.88C100.933 226.744 100.529 226.588 100.209 226.412L100.725 225.128C101.461 225.464 102.189 225.632 102.909 225.632C103.317 225.632 103.637 225.54 103.869 225.356C104.101 225.164 104.217 224.92 104.217 224.624C104.217 224.328 104.085 224.084 103.821 223.892C103.557 223.692 103.237 223.516 102.861 223.364C102.485 223.204 102.109 223.028 101.733 222.836C101.357 222.636 101.037 222.36 100.773 222.008C100.509 221.648 100.377 221.224 100.377 220.736C100.377 220.008 100.605 219.452 101.061 219.068C101.517 218.676 102.129 218.48 102.897 218.48C103.673 218.48 104.489 218.62 105.345 218.9ZM111.738 226.628C110.978 226.924 110.274 227.072 109.626 227.072C107.746 227.072 106.806 226.056 106.806 224.024C106.806 222.992 107.034 222.212 107.49 221.684C107.946 221.148 108.61 220.88 109.482 220.88C110.202 220.88 110.778 221.104 111.21 221.552C111.642 222 111.858 222.664 111.858 223.544C111.858 223.896 111.842 224.204 111.81 224.468H108.342C108.342 224.94 108.47 225.288 108.726 225.512C108.982 225.736 109.326 225.848 109.758 225.848C110.19 225.848 110.762 225.752 111.474 225.56L111.738 226.628ZM110.358 223.364V223.28C110.358 222.912 110.278 222.616 110.118 222.392C109.958 222.168 109.706 222.056 109.362 222.056C109.018 222.056 108.762 222.18 108.594 222.428C108.426 222.676 108.338 222.988 108.33 223.364H110.358ZM114.884 223.016V227H113.312V221H114.56L114.704 221.588C115.024 221.332 115.292 221.152 115.508 221.048C115.724 220.936 115.912 220.88 116.072 220.88C116.24 220.88 116.352 220.884 116.408 220.892C116.464 220.892 116.512 220.896 116.552 220.904C116.592 220.912 116.66 220.928 116.756 220.952L116.612 222.38C116.468 222.332 116.272 222.308 116.024 222.308C115.688 222.308 115.308 222.544 114.884 223.016ZM122.595 221L120.687 227H118.935L117.039 221H118.659L119.823 225.44L120.999 221H122.595ZM125.089 220.1H123.529V218.6H125.089V220.1ZM125.089 227H123.529V221H125.089V227ZM130.708 225.692L130.9 226.772C130.204 226.972 129.652 227.072 129.244 227.072C128.252 227.072 127.536 226.812 127.096 226.292C126.656 225.772 126.436 225.016 126.436 224.024C126.436 223.024 126.664 222.252 127.12 221.708C127.576 221.156 128.24 220.88 129.112 220.88C129.624 220.88 130.208 220.976 130.864 221.168L130.3 222.26C129.86 222.124 129.496 222.056 129.208 222.056C128.92 222.056 128.692 222.112 128.524 222.224C128.364 222.336 128.248 222.496 128.176 222.704C128.056 223.048 127.996 223.52 127.996 224.12C127.996 224.712 128.12 225.148 128.368 225.428C128.616 225.708 128.976 225.848 129.448 225.848C129.92 225.848 130.34 225.796 130.708 225.692ZM136.512 226.628C135.752 226.924 135.048 227.072 134.4 227.072C132.52 227.072 131.58 226.056 131.58 224.024C131.58 222.992 131.808 222.212 132.264 221.684C132.72 221.148 133.384 220.88 134.256 220.88C134.976 220.88 135.552 221.104 135.984 221.552C136.416 222 136.632 222.664 136.632 223.544C136.632 223.896 136.616 224.204 136.584 224.468H133.116C133.116 224.94 133.244 225.288 133.5 225.512C133.756 225.736 134.1 225.848 134.532 225.848C134.964 225.848 135.536 225.752 136.248 225.56L136.512 226.628ZM135.132 223.364V223.28C135.132 222.912 135.052 222.616 134.892 222.392C134.732 222.168 134.48 222.056 134.136 222.056C133.792 222.056 133.536 222.18 133.368 222.428C133.2 222.676 133.112 222.988 133.104 223.364H135.132ZM137.977 225.404C138.513 225.676 139.061 225.812 139.621 225.812C140.189 225.812 140.473 225.604 140.473 225.188C140.473 224.804 140.153 224.52 139.513 224.336C139.241 224.264 138.969 224.18 138.697 224.084C138.433 223.98 138.205 223.816 138.013 223.592C137.829 223.36 137.737 223.064 137.737 222.704C137.737 222.12 137.917 221.672 138.277 221.36C138.637 221.04 139.137 220.88 139.777 220.88C140.425 220.88 141.037 220.992 141.613 221.216L141.361 222.464C140.833 222.248 140.317 222.14 139.813 222.14C139.461 222.14 139.285 222.26 139.285 222.5C139.285 222.748 139.521 222.936 139.993 223.064C140.489 223.192 140.929 223.376 141.313 223.616C141.513 223.736 141.681 223.916 141.817 224.156C141.953 224.396 142.021 224.684 142.021 225.02C142.021 225.652 141.809 226.152 141.385 226.52C140.961 226.888 140.377 227.072 139.633 227.072C138.889 227.072 138.225 226.9 137.641 226.556L137.977 225.404Z"
        fill="#94A3B8"
      />
      <rect
        x="25"
        y="112"
        width="168.215"
        height="48"
        rx="3.5"
        fill="#CBD5E1"
      />
      <path
        d="M45.3438 132.25V133.187C45.3438 134.014 43.2861 134.688 40.75 134.688C38.2139 134.688 36.1562 134.014 36.1562 133.187V132.25C36.1562 131.424 38.2139 130.75 40.75 130.75C43.2861 130.75 45.3438 131.424 45.3438 132.25ZM45.3438 134.359V136.469C45.3438 137.295 43.2861 137.969 40.75 137.969C38.2139 137.969 36.1562 137.295 36.1562 136.469V134.359C37.1432 135.039 38.9496 135.355 40.75 135.355C42.5504 135.355 44.3568 135.039 45.3438 134.359ZM45.3438 137.641V139.75C45.3438 140.576 43.2861 141.25 40.75 141.25C38.2139 141.25 36.1562 140.576 36.1562 139.75V137.641C37.1432 138.32 38.9496 138.637 40.75 138.637C42.5504 138.637 44.3568 138.32 45.3438 137.641Z"
        fill="#94A3B8"
      />
      <path
        d="M58.654 135.5C58.654 136.852 58.262 137.94 57.478 138.764C56.694 139.588 55.646 140 54.334 140H52.102V131.6H54.706C55.898 131.6 56.854 131.964 57.574 132.692C58.294 133.42 58.654 134.356 58.654 135.5ZM56.842 135.404C56.842 134.652 56.638 134.06 56.23 133.628C55.822 133.196 55.33 132.98 54.754 132.98H53.794V138.62H54.442C55.114 138.62 55.682 138.336 56.146 137.768C56.61 137.192 56.842 136.404 56.842 135.404ZM63.1715 140L62.9315 139.4C62.6515 139.656 62.4035 139.836 62.1875 139.94C61.9715 140.036 61.7115 140.084 61.4075 140.084C60.8955 140.084 60.4475 139.908 60.0635 139.556C59.6875 139.196 59.4995 138.72 59.4995 138.128C59.4995 137.536 59.7315 137.072 60.1955 136.736C60.6595 136.392 61.3595 136.22 62.2955 136.22H62.7875C62.7875 135.876 62.7035 135.6 62.5355 135.392C62.3755 135.184 62.1275 135.08 61.7915 135.08C61.2075 135.08 60.6155 135.16 60.0155 135.32L59.7515 134.264C60.5435 134.008 61.3395 133.88 62.1395 133.88C63.5955 133.88 64.3235 134.56 64.3235 135.92V140H63.1715ZM62.7635 137.372H62.2475C61.7995 137.372 61.4955 137.432 61.3355 137.552C61.1755 137.672 61.0955 137.848 61.0955 138.08C61.0955 138.304 61.1555 138.488 61.2755 138.632C61.3955 138.776 61.5515 138.848 61.7435 138.848C62.0155 138.848 62.3555 138.632 62.7635 138.2V137.372ZM65.9667 138.704V135.32H65.3547V134H65.9787V132.284H67.5267V134H68.7867V135.32H67.5147V137.936C67.5147 138.472 67.6787 138.74 68.0067 138.74C68.1907 138.74 68.3867 138.716 68.5947 138.668L68.8467 139.916C68.4787 140.02 68.0867 140.072 67.6707 140.072C67.2627 140.072 66.8747 139.968 66.5067 139.76C66.1467 139.544 65.9667 139.192 65.9667 138.704ZM73.3551 140L73.1151 139.4C72.8351 139.656 72.5871 139.836 72.3711 139.94C72.1551 140.036 71.8951 140.084 71.5911 140.084C71.0791 140.084 70.6311 139.908 70.2471 139.556C69.8711 139.196 69.6831 138.72 69.6831 138.128C69.6831 137.536 69.9151 137.072 70.3791 136.736C70.8431 136.392 71.5431 136.22 72.4791 136.22H72.9711C72.9711 135.876 72.8871 135.6 72.7191 135.392C72.5591 135.184 72.3111 135.08 71.9751 135.08C71.3911 135.08 70.7991 135.16 70.1991 135.32L69.9351 134.264C70.7271 134.008 71.5231 133.88 72.3231 133.88C73.7791 133.88 74.5071 134.56 74.5071 135.92V140H73.3551ZM72.9471 137.372H72.4311C71.9831 137.372 71.6791 137.432 71.5191 137.552C71.3591 137.672 71.2791 137.848 71.2791 138.08C71.2791 138.304 71.3391 138.488 71.4591 138.632C71.5791 138.776 71.7351 138.848 71.9271 138.848C72.1991 138.848 72.5391 138.632 72.9471 138.2V137.372ZM79.3663 133.88C79.9823 133.88 80.4743 134.144 80.8423 134.672C81.2183 135.192 81.4063 135.948 81.4063 136.94C81.4063 137.924 81.1943 138.68 80.7703 139.208C80.3463 139.736 79.8023 140 79.1383 140C78.6263 140 78.1223 139.776 77.6263 139.328L77.3983 140H76.2103V131.6H77.7703V134.552C78.3863 134.104 78.9183 133.88 79.3663 133.88ZM79.8703 136.94C79.8703 135.828 79.5343 135.272 78.8623 135.272C78.5583 135.272 78.1943 135.452 77.7703 135.812V138.128C78.1943 138.488 78.5543 138.668 78.8503 138.668C79.1543 138.668 79.3983 138.524 79.5823 138.236C79.7743 137.948 79.8703 137.516 79.8703 136.94ZM85.8708 140L85.6308 139.4C85.3508 139.656 85.1028 139.836 84.8867 139.94C84.6708 140.036 84.4108 140.084 84.1068 140.084C83.5948 140.084 83.1468 139.908 82.7628 139.556C82.3868 139.196 82.1988 138.72 82.1988 138.128C82.1988 137.536 82.4308 137.072 82.8948 136.736C83.3588 136.392 84.0588 136.22 84.9948 136.22H85.4868C85.4868 135.876 85.4028 135.6 85.2348 135.392C85.0748 135.184 84.8268 135.08 84.4908 135.08C83.9068 135.08 83.3148 135.16 82.7148 135.32L82.4508 134.264C83.2428 134.008 84.0388 133.88 84.8388 133.88C86.2948 133.88 87.0228 134.56 87.0228 135.92V140H85.8708ZM85.4628 137.372H84.9468C84.4988 137.372 84.1948 137.432 84.0348 137.552C83.8748 137.672 83.7948 137.848 83.7948 138.08C83.7948 138.304 83.8548 138.488 83.9748 138.632C84.0948 138.776 84.2508 138.848 84.4428 138.848C84.7148 138.848 85.0548 138.632 85.4628 138.2V137.372ZM88.6179 138.404C89.1539 138.676 89.7019 138.812 90.2619 138.812C90.8299 138.812 91.1139 138.604 91.1139 138.188C91.1139 137.804 90.7939 137.52 90.1539 137.336C89.8819 137.264 89.6099 137.18 89.3379 137.084C89.0739 136.98 88.8459 136.816 88.6539 136.592C88.4699 136.36 88.3779 136.064 88.3779 135.704C88.3779 135.12 88.5579 134.672 88.9179 134.36C89.2779 134.04 89.7779 133.88 90.4179 133.88C91.0659 133.88 91.6779 133.992 92.2539 134.216L92.0019 135.464C91.4739 135.248 90.9579 135.14 90.4539 135.14C90.1019 135.14 89.9259 135.26 89.9259 135.5C89.9259 135.748 90.1619 135.936 90.6339 136.064C91.1299 136.192 91.5699 136.376 91.9539 136.616C92.1539 136.736 92.3219 136.916 92.4579 137.156C92.5939 137.396 92.6619 137.684 92.6619 138.02C92.6619 138.652 92.4499 139.152 92.0259 139.52C91.6019 139.888 91.0179 140.072 90.2739 140.072C89.5299 140.072 88.8659 139.9 88.2819 139.556L88.6179 138.404ZM98.4259 139.628C97.6659 139.924 96.9619 140.072 96.3139 140.072C94.4339 140.072 93.4939 139.056 93.4939 137.024C93.4939 135.992 93.7219 135.212 94.1779 134.684C94.6339 134.148 95.2979 133.88 96.1699 133.88C96.8899 133.88 97.4659 134.104 97.8979 134.552C98.3299 135 98.5459 135.664 98.5459 136.544C98.5459 136.896 98.5299 137.204 98.4979 137.468H95.0299C95.0299 137.94 95.1579 138.288 95.4139 138.512C95.6699 138.736 96.0139 138.848 96.4459 138.848C96.8779 138.848 97.4499 138.752 98.1619 138.56L98.4259 139.628ZM97.0459 136.364V136.28C97.0459 135.912 96.9659 135.616 96.8059 135.392C96.6459 135.168 96.3939 135.056 96.0499 135.056C95.7059 135.056 95.4499 135.18 95.2819 135.428C95.1139 135.676 95.0259 135.988 95.0179 136.364H97.0459ZM99.8913 138.404C100.427 138.676 100.975 138.812 101.535 138.812C102.103 138.812 102.387 138.604 102.387 138.188C102.387 137.804 102.067 137.52 101.427 137.336C101.155 137.264 100.883 137.18 100.611 137.084C100.347 136.98 100.119 136.816 99.9273 136.592C99.7433 136.36 99.6513 136.064 99.6513 135.704C99.6513 135.12 99.8313 134.672 100.191 134.36C100.551 134.04 101.051 133.88 101.691 133.88C102.339 133.88 102.951 133.992 103.527 134.216L103.275 135.464C102.747 135.248 102.231 135.14 101.727 135.14C101.375 135.14 101.199 135.26 101.199 135.5C101.199 135.748 101.435 135.936 101.907 136.064C102.403 136.192 102.843 136.376 103.227 136.616C103.427 136.736 103.595 136.916 103.731 137.156C103.867 137.396 103.935 137.684 103.935 138.02C103.935 138.652 103.723 139.152 103.299 139.52C102.875 139.888 102.291 140.072 101.547 140.072C100.803 140.072 100.139 139.9 99.5553 139.556L99.8913 138.404Z"
        fill="#94A3B8"
      />
      <g filter="url(#filter1_d_736_35256)">
        <rect
          x="485"
          y="112"
          width="168"
          height="48"
          rx="3.5"
          fill="white"
          shapeRendering="crispEdges"
        />
        <path
          d="M505.125 125.333H496.375C495.892 125.333 495.5 125.725 495.5 126.208V132.042C495.5 132.525 495.892 132.917 496.375 132.917H499.875L499.583 133.792H498.271C498.028 133.792 497.833 133.987 497.833 134.229C497.833 134.472 498.028 134.667 498.271 134.667H503.229C503.472 134.667 503.667 134.472 503.667 134.229C503.667 133.987 503.472 133.792 503.229 133.792H501.917L501.625 132.917H505.125C505.608 132.917 506 132.525 506 132.042V126.208C506 125.725 505.608 125.333 505.125 125.333ZM504.833 131.75H496.667V126.5H504.833V131.75Z"
          fill="#0F172A"
        />
        <path
          d="M515.402 134.572C514.178 134.572 513.238 134.188 512.582 133.42C511.934 132.644 511.61 131.596 511.61 130.276C511.61 128.956 511.954 127.912 512.642 127.144C513.338 126.376 514.302 125.992 515.534 125.992C516.206 125.992 516.874 126.108 517.538 126.34L517.202 127.684C516.714 127.476 516.138 127.372 515.474 127.372C514.81 127.372 514.29 127.624 513.914 128.128C513.538 128.632 513.35 129.328 513.35 130.216C513.35 131.104 513.526 131.824 513.878 132.376C514.23 132.92 514.726 133.192 515.366 133.192C515.846 133.192 516.53 133.036 517.418 132.724L517.778 133.948C517.05 134.364 516.258 134.572 515.402 134.572ZM520.79 134.5H519.23V126.1H520.79V134.5ZM524.363 127.6H522.803V126.1H524.363V127.6ZM524.363 134.5H522.803V128.5H524.363V134.5ZM530.629 134.128C529.869 134.424 529.165 134.572 528.517 134.572C526.637 134.572 525.697 133.556 525.697 131.524C525.697 130.492 525.925 129.712 526.381 129.184C526.837 128.648 527.501 128.38 528.373 128.38C529.093 128.38 529.669 128.604 530.101 129.052C530.533 129.5 530.749 130.164 530.749 131.044C530.749 131.396 530.733 131.704 530.701 131.968H527.233C527.233 132.44 527.361 132.788 527.617 133.012C527.873 133.236 528.217 133.348 528.649 133.348C529.081 133.348 529.653 133.252 530.365 133.06L530.629 134.128ZM529.249 130.864V130.78C529.249 130.412 529.169 130.116 529.009 129.892C528.849 129.668 528.597 129.556 528.253 129.556C527.909 129.556 527.653 129.68 527.485 129.928C527.317 130.176 527.229 130.488 527.221 130.864H529.249ZM537.29 134.5H535.706V130.912C535.706 130.584 535.642 130.32 535.514 130.12C535.386 129.912 535.174 129.808 534.878 129.808C534.582 129.808 534.214 129.992 533.774 130.36V134.5H532.202V128.5H533.522L533.774 129.04C534.118 128.784 534.414 128.612 534.662 128.524C534.918 128.428 535.214 128.38 535.55 128.38C536.086 128.38 536.51 128.56 536.822 128.92C537.134 129.272 537.29 129.796 537.29 130.492V134.5ZM539.174 133.204V129.82H538.562V128.5H539.186V126.784H540.734V128.5H541.994V129.82H540.722V132.436C540.722 132.972 540.886 133.24 541.214 133.24C541.398 133.24 541.594 133.216 541.802 133.168L542.054 134.416C541.686 134.52 541.294 134.572 540.878 134.572C540.47 134.572 540.082 134.468 539.714 134.26C539.354 134.044 539.174 133.692 539.174 133.204ZM543.274 132.904C543.81 133.176 544.358 133.312 544.918 133.312C545.486 133.312 545.77 133.104 545.77 132.688C545.77 132.304 545.45 132.02 544.81 131.836C544.538 131.764 544.266 131.68 543.994 131.584C543.73 131.48 543.502 131.316 543.31 131.092C543.126 130.86 543.034 130.564 543.034 130.204C543.034 129.62 543.214 129.172 543.574 128.86C543.934 128.54 544.434 128.38 545.074 128.38C545.722 128.38 546.334 128.492 546.91 128.716L546.658 129.964C546.13 129.748 545.614 129.64 545.11 129.64C544.758 129.64 544.582 129.76 544.582 130C544.582 130.248 544.818 130.436 545.29 130.564C545.786 130.692 546.226 130.876 546.61 131.116C546.81 131.236 546.978 131.416 547.114 131.656C547.25 131.896 547.318 132.184 547.318 132.52C547.318 133.152 547.106 133.652 546.682 134.02C546.258 134.388 545.674 134.572 544.93 134.572C544.186 134.572 543.522 134.4 542.938 134.056L543.274 132.904Z"
          fill="#0F172A"
        />
        <path
          d="M516.91 147.5H516.07L515.37 145.29H512.86L512.17 147.5H511.38L513.68 140.5H514.59L516.91 147.5ZM515.2 144.64L514.13 141.26L513.05 144.64H515.2ZM518.701 149.88H517.951V142.51H518.391L518.651 143.07C518.931 142.857 519.191 142.693 519.431 142.58C519.678 142.46 519.948 142.4 520.241 142.4C521.441 142.4 522.041 143.263 522.041 144.99C522.041 145.97 521.828 146.653 521.401 147.04C521.021 147.393 520.588 147.57 520.101 147.57C519.621 147.57 519.154 147.41 518.701 147.09V149.88ZM518.701 143.74V146.41C518.834 146.57 519.014 146.697 519.241 146.79C519.468 146.883 519.684 146.93 519.891 146.93C520.411 146.93 520.774 146.777 520.981 146.47C521.188 146.163 521.291 145.683 521.291 145.03C521.291 144.377 521.188 143.883 520.981 143.55C520.774 143.217 520.511 143.05 520.191 143.05C519.978 143.05 519.764 143.093 519.551 143.18C519.344 143.267 519.188 143.35 519.081 143.43C518.981 143.503 518.854 143.607 518.701 143.74ZM524.16 149.88H523.41V142.51H523.85L524.11 143.07C524.39 142.857 524.65 142.693 524.89 142.58C525.137 142.46 525.407 142.4 525.7 142.4C526.9 142.4 527.5 143.263 527.5 144.99C527.5 145.97 527.287 146.653 526.86 147.04C526.48 147.393 526.047 147.57 525.56 147.57C525.08 147.57 524.613 147.41 524.16 147.09V149.88ZM524.16 143.74V146.41C524.293 146.57 524.473 146.697 524.7 146.79C524.927 146.883 525.143 146.93 525.35 146.93C525.87 146.93 526.233 146.777 526.44 146.47C526.647 146.163 526.75 145.683 526.75 145.03C526.75 144.377 526.647 143.883 526.44 143.55C526.233 143.217 525.97 143.05 525.65 143.05C525.437 143.05 525.223 143.093 525.01 143.18C524.803 143.267 524.647 143.35 524.54 143.43C524.44 143.503 524.313 143.607 524.16 143.74ZM528.679 146.61C529.112 146.81 529.526 146.91 529.919 146.91C530.312 146.91 530.609 146.833 530.809 146.68C531.016 146.52 531.119 146.31 531.119 146.05C531.119 145.79 531.032 145.59 530.859 145.45C530.686 145.303 530.472 145.19 530.219 145.11C529.972 145.03 529.722 144.943 529.469 144.85C529.222 144.757 529.012 144.617 528.839 144.43C528.666 144.243 528.579 144.007 528.579 143.72C528.579 143.3 528.716 142.977 528.989 142.75C529.262 142.517 529.632 142.4 530.099 142.4C530.566 142.4 530.999 142.47 531.399 142.61L531.469 142.64L531.339 143.28C530.939 143.127 530.566 143.05 530.219 143.05C529.879 143.05 529.646 143.103 529.519 143.21C529.392 143.317 529.329 143.497 529.329 143.75C529.329 143.91 529.416 144.047 529.589 144.16C529.762 144.273 529.972 144.373 530.219 144.46C530.472 144.54 530.722 144.637 530.969 144.75C531.222 144.857 531.436 145.02 531.609 145.24C531.782 145.46 531.869 145.73 531.869 146.05C531.869 146.517 531.706 146.887 531.379 147.16C531.052 147.427 530.602 147.56 530.029 147.56C529.456 147.56 528.946 147.43 528.499 147.17L528.679 146.61ZM534.184 146.63L533.054 149.22L532.564 149.06L533.434 146.39L534.184 146.63ZM539.936 144.56H538.916V147.5H538.166V140.5H540.166C540.913 140.5 541.453 140.663 541.786 140.99C542.126 141.317 542.296 141.827 542.296 142.52C542.296 143.207 542.089 143.72 541.676 144.06C541.263 144.393 540.683 144.56 539.936 144.56ZM539.826 141.14H538.916V143.92H539.576C540.263 143.92 540.763 143.817 541.076 143.61C541.389 143.403 541.546 143.05 541.546 142.55C541.546 142.043 541.409 141.683 541.136 141.47C540.863 141.25 540.426 141.14 539.826 141.14ZM543.576 147.5V140.5H544.326V147.5H543.576ZM548.304 144.51H548.714C548.714 143.903 548.638 143.51 548.484 143.33C548.331 143.143 547.991 143.05 547.464 143.05C546.938 143.05 546.491 143.12 546.124 143.26L545.984 142.68C546.544 142.493 547.124 142.4 547.724 142.4C548.898 142.4 549.484 142.987 549.484 144.16V147.5H549.044L548.784 146.91C548.478 147.163 548.211 147.337 547.984 147.43C547.764 147.517 547.508 147.56 547.214 147.56C546.748 147.56 546.384 147.423 546.124 147.15C545.864 146.87 545.734 146.503 545.734 146.05C545.734 145.023 546.591 144.51 548.304 144.51ZM548.724 145.14H548.274C547.594 145.14 547.124 145.207 546.864 145.34C546.611 145.473 546.484 145.683 546.484 145.97C546.484 146.25 546.558 146.48 546.704 146.66C546.851 146.84 547.041 146.93 547.274 146.93C547.514 146.93 547.741 146.877 547.954 146.77C548.174 146.657 548.431 146.463 548.724 146.19V145.14ZM551.421 146.42V143.1H550.741V142.5H551.431V141.07H552.181V142.5H553.401V143.1H552.171V146.28C552.171 146.727 552.397 146.95 552.851 146.95C552.957 146.95 553.121 146.93 553.341 146.89L553.451 147.43C553.177 147.517 552.894 147.56 552.601 147.56C552.314 147.56 552.044 147.473 551.791 147.3C551.544 147.12 551.421 146.827 551.421 146.42ZM554.978 142.5V141.54C554.978 141.133 555.101 140.843 555.348 140.67C555.601 140.49 555.871 140.4 556.158 140.4C556.451 140.4 556.734 140.443 557.008 140.53L556.898 141.07C556.678 141.03 556.514 141.01 556.408 141.01C555.948 141.01 555.718 141.233 555.718 141.68V142.5H556.738V143.1H555.718V147.5H554.968V143.1H554.198V142.5H554.978ZM560.758 145.04C560.758 144.393 560.631 143.9 560.378 143.56C560.124 143.22 559.754 143.05 559.268 143.05C558.781 143.05 558.434 143.213 558.228 143.54C558.028 143.86 557.928 144.353 557.928 145.02C557.928 146.28 558.391 146.91 559.318 146.91C559.804 146.91 560.164 146.76 560.398 146.46C560.638 146.153 560.758 145.68 560.758 145.04ZM560.938 146.88C560.558 147.333 560.021 147.56 559.328 147.56C558.634 147.56 558.101 147.337 557.728 146.89C557.361 146.437 557.178 145.807 557.178 145C557.178 144.187 557.354 143.55 557.708 143.09C558.068 142.63 558.591 142.4 559.278 142.4C559.971 142.4 560.514 142.633 560.908 143.1C561.308 143.567 561.508 144.2 561.508 145C561.508 145.8 561.318 146.427 560.938 146.88ZM563.594 143.68V147.5H562.844V142.5H563.324L563.444 143.09C563.764 142.837 564.03 142.66 564.244 142.56C564.457 142.453 564.7 142.4 564.974 142.4C565.107 142.4 565.207 142.407 565.274 142.42L565.414 142.46L565.294 143.15C565.174 143.11 565.01 143.09 564.804 143.09C564.404 143.09 564 143.287 563.594 143.68ZM568.665 142.39C569.305 142.39 569.761 142.617 570.035 143.07C570.601 142.617 571.125 142.39 571.605 142.39C572.085 142.39 572.475 142.527 572.775 142.8C573.081 143.067 573.235 143.457 573.235 143.97V147.5H572.505V144.28C572.505 143.873 572.411 143.567 572.225 143.36C572.045 143.147 571.801 143.04 571.495 143.04C571.075 143.04 570.651 143.207 570.225 143.54C570.258 143.687 570.275 143.83 570.275 143.97V147.5H569.545V144.28C569.545 143.873 569.451 143.567 569.265 143.36C569.085 143.147 568.841 143.04 568.535 143.04C568.335 143.04 568.151 143.067 567.985 143.12C567.818 143.173 567.695 143.227 567.615 143.28C567.535 143.333 567.431 143.413 567.305 143.52V147.5H566.555V142.5H567.035L567.165 143.01C567.331 142.87 567.458 142.77 567.545 142.71C567.638 142.643 567.788 142.573 567.995 142.5C568.201 142.427 568.425 142.39 568.665 142.39ZM574.861 146.61C575.294 146.81 575.707 146.91 576.101 146.91C576.494 146.91 576.791 146.833 576.991 146.68C577.197 146.52 577.301 146.31 577.301 146.05C577.301 145.79 577.214 145.59 577.041 145.45C576.867 145.303 576.654 145.19 576.401 145.11C576.154 145.03 575.904 144.943 575.651 144.85C575.404 144.757 575.194 144.617 575.021 144.43C574.847 144.243 574.761 144.007 574.761 143.72C574.761 143.3 574.897 142.977 575.171 142.75C575.444 142.517 575.814 142.4 576.281 142.4C576.747 142.4 577.181 142.47 577.581 142.61L577.651 142.64L577.521 143.28C577.121 143.127 576.747 143.05 576.401 143.05C576.061 143.05 575.827 143.103 575.701 143.21C575.574 143.317 575.511 143.497 575.511 143.75C575.511 143.91 575.597 144.047 575.771 144.16C575.944 144.273 576.154 144.373 576.401 144.46C576.654 144.54 576.904 144.637 577.151 144.75C577.404 144.857 577.617 145.02 577.791 145.24C577.964 145.46 578.051 145.73 578.051 146.05C578.051 146.517 577.887 146.887 577.561 147.16C577.234 147.427 576.784 147.56 576.211 147.56C575.637 147.56 575.127 147.43 574.681 147.17L574.861 146.61ZM580.366 146.63L579.236 149.22L578.746 149.06L579.616 146.39L580.366 146.63ZM587.868 140.75L587.708 141.42L587.128 141.25C586.714 141.15 586.358 141.1 586.058 141.1C585.271 141.1 584.878 141.45 584.878 142.15C584.878 142.457 584.998 142.71 585.238 142.91C585.478 143.103 585.768 143.26 586.108 143.38C586.454 143.493 586.798 143.62 587.138 143.76C587.484 143.893 587.778 144.103 588.018 144.39C588.258 144.67 588.378 145.027 588.378 145.46C588.378 146.12 588.174 146.637 587.768 147.01C587.361 147.377 586.784 147.56 586.038 147.56C585.664 147.56 585.288 147.507 584.907 147.4C584.534 147.287 584.228 147.157 583.988 147.01L584.238 146.44C584.844 146.72 585.418 146.86 585.958 146.86C586.504 146.86 586.918 146.75 587.198 146.53C587.484 146.31 587.628 145.99 587.628 145.57C587.628 145.143 587.398 144.81 586.938 144.57C586.731 144.463 586.501 144.363 586.248 144.27C586.001 144.177 585.751 144.077 585.498 143.97C585.251 143.857 585.024 143.73 584.818 143.59C584.618 143.45 584.451 143.26 584.318 143.02C584.191 142.78 584.128 142.5 584.128 142.18C584.128 141.607 584.298 141.167 584.638 140.86C584.984 140.553 585.448 140.4 586.028 140.4C586.608 140.4 587.221 140.517 587.868 140.75ZM593.325 145.16H590.135C590.135 145.8 590.285 146.253 590.585 146.52C590.892 146.787 591.275 146.92 591.735 146.92C591.969 146.92 592.132 146.91 592.225 146.89C592.319 146.863 592.405 146.84 592.485 146.82C592.572 146.793 592.632 146.773 592.665 146.76C592.832 146.713 592.975 146.67 593.095 146.63L593.215 147.21C592.549 147.443 592.029 147.56 591.655 147.56C590.969 147.56 590.419 147.353 590.005 146.94C589.592 146.52 589.385 145.893 589.385 145.06C589.385 144.22 589.579 143.567 589.965 143.1C590.359 142.633 590.852 142.4 591.445 142.4C592.045 142.4 592.512 142.593 592.845 142.98C593.179 143.367 593.345 143.89 593.345 144.55C593.345 144.73 593.339 144.933 593.325 145.16ZM590.185 144.59H592.625C592.625 144.097 592.539 143.717 592.365 143.45C592.192 143.183 591.889 143.05 591.455 143.05C591.029 143.05 590.715 143.193 590.515 143.48C590.315 143.767 590.205 144.137 590.185 144.59ZM595.498 143.68V147.5H594.748V142.5H595.228L595.348 143.09C595.668 142.837 595.935 142.66 596.148 142.56C596.361 142.453 596.605 142.4 596.878 142.4C597.011 142.4 597.111 142.407 597.178 142.42L597.318 142.46L597.198 143.15C597.078 143.11 596.915 143.09 596.708 143.09C596.308 143.09 595.905 143.287 595.498 143.68ZM601.889 142.49L600.199 147.5H599.339L597.659 142.49H598.509L599.779 146.7L601.059 142.49H601.889ZM602.772 147.5V142.5H603.522V147.5H602.772ZM603.522 140.5V141.39H602.772V140.5H603.522ZM608.127 146.72L608.277 147.31C607.744 147.47 607.274 147.55 606.867 147.55C606.154 147.55 605.617 147.317 605.257 146.85C604.897 146.383 604.717 145.74 604.717 144.92C604.717 144.1 604.904 143.477 605.277 143.05C605.651 142.617 606.201 142.4 606.927 142.4C607.241 142.4 607.681 142.48 608.247 142.64L607.947 143.22C607.581 143.113 607.251 143.06 606.957 143.06C606.451 143.06 606.084 143.21 605.857 143.51C605.637 143.81 605.527 144.283 605.527 144.93C605.527 146.243 605.997 146.9 606.937 146.9C607.311 146.9 607.707 146.84 608.127 146.72ZM612.984 145.16H609.794C609.794 145.8 609.944 146.253 610.244 146.52C610.55 146.787 610.934 146.92 611.394 146.92C611.627 146.92 611.79 146.91 611.884 146.89C611.977 146.863 612.064 146.84 612.144 146.82C612.23 146.793 612.29 146.773 612.324 146.76C612.49 146.713 612.634 146.67 612.754 146.63L612.874 147.21C612.207 147.443 611.687 147.56 611.314 147.56C610.627 147.56 610.077 147.353 609.664 146.94C609.25 146.52 609.044 145.893 609.044 145.06C609.044 144.22 609.237 143.567 609.624 143.1C610.017 142.633 610.51 142.4 611.104 142.4C611.704 142.4 612.17 142.593 612.504 142.98C612.837 143.367 613.004 143.89 613.004 144.55C613.004 144.73 612.997 144.933 612.984 145.16ZM609.844 144.59H612.284C612.284 144.097 612.197 143.717 612.024 143.45C611.85 143.183 611.547 143.05 611.114 143.05C610.687 143.05 610.374 143.193 610.174 143.48C609.974 143.767 609.864 144.137 609.844 144.59ZM614.216 146.61C614.649 146.81 615.063 146.91 615.456 146.91C615.849 146.91 616.146 146.833 616.346 146.68C616.553 146.52 616.656 146.31 616.656 146.05C616.656 145.79 616.569 145.59 616.396 145.45C616.223 145.303 616.009 145.19 615.756 145.11C615.509 145.03 615.259 144.943 615.006 144.85C614.759 144.757 614.549 144.617 614.376 144.43C614.203 144.243 614.116 144.007 614.116 143.72C614.116 143.3 614.253 142.977 614.526 142.75C614.799 142.517 615.169 142.4 615.636 142.4C616.103 142.4 616.536 142.47 616.936 142.61L617.006 142.64L616.876 143.28C616.476 143.127 616.103 143.05 615.756 143.05C615.416 143.05 615.183 143.103 615.056 143.21C614.929 143.317 614.866 143.497 614.866 143.75C614.866 143.91 614.953 144.047 615.126 144.16C615.299 144.273 615.509 144.373 615.756 144.46C616.009 144.54 616.259 144.637 616.506 144.75C616.759 144.857 616.973 145.02 617.146 145.24C617.319 145.46 617.406 145.73 617.406 146.05C617.406 146.517 617.243 146.887 616.916 147.16C616.589 147.427 616.139 147.56 615.566 147.56C614.993 147.56 614.483 147.43 614.036 147.17L614.216 146.61Z"
          fill="#0F172A"
        />
      </g>
      <g filter="url(#filter2_d_736_35256)">
        <rect
          x="233"
          y="109"
          width="54.0691"
          height="54"
          rx="3.5"
          fill="white"
          shapeRendering="crispEdges"
        />
        <g clipPath="url(#clip2_736_35256)">
          <path
            d="M271.089 141.525C269.809 142.192 263.175 144.92 261.763 145.656C260.351 146.392 259.566 146.385 258.451 145.852C257.335 145.319 250.276 142.467 249.004 141.859C248.369 141.556 248.034 141.299 248.034 141.057V138.632C248.034 138.632 257.225 136.631 258.708 136.099C260.192 135.566 260.707 135.547 261.969 136.009C263.232 136.472 270.782 137.834 272.03 138.291L272.029 140.682C272.029 140.922 271.741 141.185 271.089 141.525"
            fill="#912626"
          />
          <path
            d="M271.089 139.114C269.808 139.781 263.175 142.509 261.763 143.245C260.351 143.981 259.566 143.974 258.451 143.441C257.335 142.908 250.276 140.056 249.004 139.448C247.733 138.84 247.706 138.422 248.955 137.933C250.204 137.444 257.225 134.689 258.708 134.157C260.192 133.625 260.707 133.606 261.969 134.068C263.232 134.531 269.826 137.155 271.073 137.612C272.321 138.07 272.369 138.446 271.089 139.114"
            fill="#C6302B"
          />
          <path
            d="M271.089 137.6C269.809 138.268 263.175 140.995 261.763 141.732C260.351 142.468 259.566 142.461 258.451 141.927C257.335 141.394 250.276 138.543 249.004 137.935C248.369 137.631 248.034 137.375 248.034 137.133V134.707C248.034 134.707 257.225 132.706 258.708 132.174C260.192 131.642 260.707 131.623 261.969 132.085C263.232 132.548 270.782 133.91 272.03 134.367L272.029 136.758C272.029 136.998 271.741 137.261 271.089 137.6Z"
            fill="#912626"
          />
          <path
            d="M271.089 135.189C269.808 135.857 263.175 138.584 261.763 139.321C260.351 140.057 259.566 140.049 258.451 139.516C257.335 138.983 250.276 136.131 249.004 135.524C247.733 134.916 247.706 134.498 248.955 134.008C250.204 133.519 257.225 130.765 258.708 130.233C260.192 129.701 260.707 129.681 261.969 130.144C263.232 130.606 269.826 133.231 271.073 133.688C272.321 134.145 272.369 134.522 271.089 135.189"
            fill="#C6302B"
          />
          <path
            d="M271.089 133.53C269.809 134.198 263.175 136.925 261.763 137.662C260.351 138.398 259.566 138.391 258.451 137.858C257.335 137.324 250.276 134.473 249.004 133.865C248.369 133.561 248.034 133.305 248.034 133.063V130.637C248.034 130.637 257.225 128.637 258.708 128.104C260.192 127.572 260.707 127.553 261.969 128.015C263.232 128.478 270.782 129.84 272.03 130.297L272.029 132.688C272.029 132.928 271.741 133.191 271.089 133.53Z"
            fill="#912626"
          />
          <path
            d="M271.089 131.119C269.808 131.787 263.175 134.514 261.763 135.251C260.351 135.987 259.566 135.979 258.451 135.446C257.335 134.913 250.276 132.061 249.004 131.454C247.733 130.846 247.706 130.428 248.955 129.939C250.204 129.449 257.225 126.695 258.708 126.163C260.192 125.631 260.707 125.612 261.969 126.074C263.232 126.537 269.826 129.161 271.073 129.618C272.321 130.075 272.369 130.452 271.089 131.119"
            fill="#C6302B"
          />
          <path
            d="M262.964 128.76L260.901 128.974L260.439 130.085L259.694 128.845L257.311 128.631L259.089 127.99L258.556 127.006L260.22 127.657L261.789 127.144L261.365 128.161L262.964 128.76M260.316 134.151L256.466 132.554L261.983 131.707L260.316 134.151M254.978 129.378C256.607 129.378 257.927 129.889 257.927 130.521C257.927 131.152 256.607 131.664 254.978 131.664C253.35 131.664 252.03 131.152 252.03 130.521C252.03 129.889 253.35 129.378 254.978 129.378Z"
            fill="white"
          />
          <path
            d="M265.402 129.064L268.668 130.354L265.405 131.643L265.402 129.064"
            fill="#621B1C"
          />
          <path
            d="M261.79 130.493L265.402 129.064L265.405 131.643L265.051 131.782L261.79 130.493Z"
            fill="#9A2928"
          />
        </g>
      </g>
      <path
        d="M291.069 136H308.482"
        stroke="#F9C548"
        strokeOpacity="0.5"
        strokeWidth="6"
        strokeMiterlimit="0"
        strokeLinecap="round"
        strokeLinejoin="bevel"
      />
      <path
        d="M370.551 136H481"
        stroke="#F9C548"
        strokeOpacity="0.5"
        strokeWidth="6"
        strokeMiterlimit="0"
        strokeLinecap="round"
        strokeLinejoin="bevel"
      />
      <path
        d="M197.215 49V49C205.992 49 213.107 56.1154 213.107 64.8926V120.107C213.107 128.885 220.223 136 229 136V136"
        stroke="#64748B"
        strokeOpacity="0.15"
        strokeWidth="6"
        strokeMiterlimit="0"
        strokeLinecap="round"
        strokeLinejoin="bevel"
      />
      <path
        d="M197.215 136H229"
        stroke="#64748B"
        strokeOpacity="0.15"
        strokeWidth="6"
        strokeMiterlimit="0"
        strokeLinecap="round"
        strokeLinejoin="bevel"
      />
      <path
        d="M197.215 223V223C205.992 223 213.107 215.885 213.107 207.107V151.893C213.107 143.115 220.223 136 229 136V136"
        stroke="#64748B"
        strokeOpacity="0.15"
        strokeWidth="6"
        strokeMiterlimit="0"
        strokeLinecap="round"
        strokeLinejoin="bevel"
      />
      <circle cx="371" cy="136" r="2" fill="#F59E0B" />
      <circle cx="381" cy="136" r="2" fill="#F59E0B" />
      <circle cx="391" cy="136" r="2" fill="#F59E0B" />
      <circle cx="401" cy="136" r="2" fill="#F59E0B" />
      <circle cx="411" cy="136" r="2" fill="#F59E0B" />
      <circle cx="421" cy="136" r="2" fill="#F59E0B" />
      <circle cx="431" cy="136" r="2" fill="#F59E0B" />
      <circle cx="441" cy="136" r="2" fill="#F59E0B" />
      <circle cx="451" cy="136" r="2" fill="#F59E0B" />
      <circle cx="461" cy="136" r="2" fill="#F59E0B" />
      <circle cx="471" cy="136" r="2" fill="#F59E0B" />
      <circle cx="481" cy="136" r="2" fill="#F59E0B" />
      <circle cx="292" cy="136" r="2" fill="#F59E0B" />
      <circle cx="308" cy="136" r="2" fill="#F59E0B" />
      <circle cx="300" cy="136" r="2" fill="#F59E0B" />
      <rect x="1" y="1" width="671" height="270" rx="2" stroke="#CBD5E1" />
      <defs>
        <filter
          id="filter0_d_736_35256"
          x="310.482"
          y="108"
          width="58.0691"
          height="58"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_736_35256"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect1_dropShadow_736_35256"
            result="shape"
          />
        </filter>
        <filter
          id="filter1_d_736_35256"
          x="483"
          y="111"
          width="172"
          height="52"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_736_35256"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect1_dropShadow_736_35256"
            result="shape"
          />
        </filter>
        <filter
          id="filter2_d_736_35256"
          x="231"
          y="108"
          width="58.0691"
          height="58"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dy="1" />
          <feGaussianBlur stdDeviation="1" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_736_35256"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect1_dropShadow_736_35256"
            result="shape"
          />
        </filter>
        <clipPath id="clip0_736_35256">
          <rect
            width="24"
            height="24"
            fill="white"
            transform="translate(327.516 124)"
          />
        </clipPath>
        <clipPath id="clip1_736_35256">
          <rect
            width="14"
            height="13.125"
            fill="white"
            transform="translate(359.5 106.438)"
          />
        </clipPath>
        <clipPath id="clip2_736_35256">
          <rect
            width="24"
            height="20.6208"
            fill="white"
            transform="translate(248.034 125.69)"
          />
        </clipPath>
      </defs>
    </svg>
  );
}
