import { GetDataTypeOperatorsProps } from '../../utils/comparatorsFromSchema';

export const mssqlRealColumnTypeInput = {
  comparators: {
    Int_MSSQL: {
      operators: [
        {
          type: 'comparision',
          name: '_eq',
          operator: '_eq',
          graphqlType: 'Int',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gt',
          operator: '_gt',
          graphqlType: 'Int',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gte',
          operator: '_gte',
          graphqlType: 'Int',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_in',
          operator: '_in',
          graphqlType: '[Int!]',
          inputStructure: 'array',
        },
        {
          type: 'is_null',
          name: '_is_null',
          operator: '_is_null',
          graphqlType: 'Boolean',
          inputStructure: 'object',
          inputType: 'boolean',
        },
        {
          type: 'comparision',
          name: '_lt',
          operator: '_lt',
          graphqlType: 'Int',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_lte',
          operator: '_lte',
          graphqlType: 'Int',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_neq',
          operator: '_neq',
          graphqlType: 'Int',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_nin',
          operator: '_nin',
          graphqlType: '[Int!]',
          inputStructure: 'array',
        },
        { name: '_ceq', operator: '_ceq' },
        { name: '_cne', operator: '_cne' },
        { name: '_cgt', operator: '_cgt' },
        { name: '_clt', operator: '_clt' },
        { name: '_cgte', operator: '_cgte' },
        { name: '_clte', operator: '_clte' },
      ],
    },
    binary_MSSQL: {
      operators: [
        {
          type: 'comparision',
          name: '_eq',
          operator: '_eq',
          graphqlType: 'binary',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gt',
          operator: '_gt',
          graphqlType: 'binary',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gte',
          operator: '_gte',
          graphqlType: 'binary',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_in',
          operator: '_in',
          graphqlType: '[binary!]',
          inputStructure: 'array',
        },
        {
          type: 'is_null',
          name: '_is_null',
          operator: '_is_null',
          graphqlType: 'Boolean',
          inputStructure: 'object',
          inputType: 'boolean',
        },
        {
          type: 'comparision',
          name: '_lt',
          operator: '_lt',
          graphqlType: 'binary',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_lte',
          operator: '_lte',
          graphqlType: 'binary',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_neq',
          operator: '_neq',
          graphqlType: 'binary',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_nin',
          operator: '_nin',
          graphqlType: '[binary!]',
          inputStructure: 'array',
        },
        { name: '_ceq', operator: '_ceq' },
        { name: '_cne', operator: '_cne' },
        { name: '_cgt', operator: '_cgt' },
        { name: '_clt', operator: '_clt' },
        { name: '_cgte', operator: '_cgte' },
        { name: '_clte', operator: '_clte' },
      ],
    },
    Boolean_MSSQL: {
      operators: [
        {
          type: 'comparision',
          name: '_eq',
          operator: '_eq',
          graphqlType: 'Boolean',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gt',
          operator: '_gt',
          graphqlType: 'Boolean',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gte',
          operator: '_gte',
          graphqlType: 'Boolean',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_in',
          operator: '_in',
          graphqlType: '[Boolean!]',
          inputStructure: 'array',
        },
        {
          type: 'is_null',
          name: '_is_null',
          operator: '_is_null',
          graphqlType: 'Boolean',
          inputStructure: 'object',
          inputType: 'boolean',
        },
        {
          type: 'comparision',
          name: '_lt',
          operator: '_lt',
          graphqlType: 'Boolean',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_lte',
          operator: '_lte',
          graphqlType: 'Boolean',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_neq',
          operator: '_neq',
          graphqlType: 'Boolean',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_nin',
          operator: '_nin',
          graphqlType: '[Boolean!]',
          inputStructure: 'array',
        },
        { name: '_ceq', operator: '_ceq' },
        { name: '_cne', operator: '_cne' },
        { name: '_cgt', operator: '_cgt' },
        { name: '_clt', operator: '_clt' },
        { name: '_cgte', operator: '_cgte' },
        { name: '_clte', operator: '_clte' },
      ],
    },
    String_MSSQL: {
      operators: [
        {
          type: 'comparision',
          name: '_eq',
          operator: '_eq',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gt',
          operator: '_gt',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gte',
          operator: '_gte',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_in',
          operator: '_in',
          graphqlType: '[String!]',
          inputStructure: 'array',
        },
        {
          type: 'is_null',
          name: '_is_null',
          operator: '_is_null',
          graphqlType: 'Boolean',
          inputStructure: 'object',
          inputType: 'boolean',
        },
        {
          type: 'pattern_match',
          name: '_like',
          operator: '_like',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_lt',
          operator: '_lt',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_lte',
          operator: '_lte',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_neq',
          operator: '_neq',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_nin',
          operator: '_nin',
          graphqlType: '[String!]',
          inputStructure: 'array',
        },
        {
          type: 'pattern_match',
          name: '_nlike',
          operator: '_nlike',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        { name: '_ceq', operator: '_ceq' },
        { name: '_cne', operator: '_cne' },
        { name: '_cgt', operator: '_cgt' },
        { name: '_clt', operator: '_clt' },
        { name: '_cgte', operator: '_cgte' },
        { name: '_clte', operator: '_clte' },
      ],
    },
    date_MSSQL: {
      operators: [
        {
          type: 'comparision',
          name: '_eq',
          operator: '_eq',
          graphqlType: 'date',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gt',
          operator: '_gt',
          graphqlType: 'date',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gte',
          operator: '_gte',
          graphqlType: 'date',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_in',
          operator: '_in',
          graphqlType: '[date!]',
          inputStructure: 'array',
        },
        {
          type: 'is_null',
          name: '_is_null',
          operator: '_is_null',
          graphqlType: 'Boolean',
          inputStructure: 'object',
          inputType: 'boolean',
        },
        {
          type: 'comparision',
          name: '_lt',
          operator: '_lt',
          graphqlType: 'date',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_lte',
          operator: '_lte',
          graphqlType: 'date',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_neq',
          operator: '_neq',
          graphqlType: 'date',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_nin',
          operator: '_nin',
          graphqlType: '[date!]',
          inputStructure: 'array',
        },
        { name: '_ceq', operator: '_ceq' },
        { name: '_cne', operator: '_cne' },
        { name: '_cgt', operator: '_cgt' },
        { name: '_clt', operator: '_clt' },
        { name: '_cgte', operator: '_cgte' },
        { name: '_clte', operator: '_clte' },
      ],
    },
    datetime2_MSSQL: {
      operators: [
        {
          type: 'comparision',
          name: '_eq',
          operator: '_eq',
          graphqlType: 'datetime2',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gt',
          operator: '_gt',
          graphqlType: 'datetime2',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gte',
          operator: '_gte',
          graphqlType: 'datetime2',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_in',
          operator: '_in',
          graphqlType: '[datetime2!]',
          inputStructure: 'array',
        },
        {
          type: 'is_null',
          name: '_is_null',
          operator: '_is_null',
          graphqlType: 'Boolean',
          inputStructure: 'object',
          inputType: 'boolean',
        },
        {
          type: 'comparision',
          name: '_lt',
          operator: '_lt',
          graphqlType: 'datetime2',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_lte',
          operator: '_lte',
          graphqlType: 'datetime2',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_neq',
          operator: '_neq',
          graphqlType: 'datetime2',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_nin',
          operator: '_nin',
          graphqlType: '[datetime2!]',
          inputStructure: 'array',
        },
        { name: '_ceq', operator: '_ceq' },
        { name: '_cne', operator: '_cne' },
        { name: '_cgt', operator: '_cgt' },
        { name: '_clt', operator: '_clt' },
        { name: '_cgte', operator: '_cgte' },
        { name: '_clte', operator: '_clte' },
      ],
    },
    datetime_MSSQL: {
      operators: [
        {
          type: 'comparision',
          name: '_eq',
          operator: '_eq',
          graphqlType: 'datetime',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gt',
          operator: '_gt',
          graphqlType: 'datetime',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gte',
          operator: '_gte',
          graphqlType: 'datetime',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_in',
          operator: '_in',
          graphqlType: '[datetime!]',
          inputStructure: 'array',
        },
        {
          type: 'is_null',
          name: '_is_null',
          operator: '_is_null',
          graphqlType: 'Boolean',
          inputStructure: 'object',
          inputType: 'boolean',
        },
        {
          type: 'comparision',
          name: '_lt',
          operator: '_lt',
          graphqlType: 'datetime',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_lte',
          operator: '_lte',
          graphqlType: 'datetime',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_neq',
          operator: '_neq',
          graphqlType: 'datetime',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_nin',
          operator: '_nin',
          graphqlType: '[datetime!]',
          inputStructure: 'array',
        },
        { name: '_ceq', operator: '_ceq' },
        { name: '_cne', operator: '_cne' },
        { name: '_cgt', operator: '_cgt' },
        { name: '_clt', operator: '_clt' },
        { name: '_cgte', operator: '_cgte' },
        { name: '_clte', operator: '_clte' },
      ],
    },
    Float_MSSQL: {
      operators: [
        {
          type: 'comparision',
          name: '_eq',
          operator: '_eq',
          graphqlType: 'Float',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gt',
          operator: '_gt',
          graphqlType: 'Float',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gte',
          operator: '_gte',
          graphqlType: 'Float',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_in',
          operator: '_in',
          graphqlType: '[Float!]',
          inputStructure: 'array',
        },
        {
          type: 'is_null',
          name: '_is_null',
          operator: '_is_null',
          graphqlType: 'Boolean',
          inputStructure: 'object',
          inputType: 'boolean',
        },
        {
          type: 'comparision',
          name: '_lt',
          operator: '_lt',
          graphqlType: 'Float',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_lte',
          operator: '_lte',
          graphqlType: 'Float',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_neq',
          operator: '_neq',
          graphqlType: 'Float',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_nin',
          operator: '_nin',
          graphqlType: '[Float!]',
          inputStructure: 'array',
        },
        { name: '_ceq', operator: '_ceq' },
        { name: '_cne', operator: '_cne' },
        { name: '_cgt', operator: '_cgt' },
        { name: '_clt', operator: '_clt' },
        { name: '_cgte', operator: '_cgte' },
        { name: '_clte', operator: '_clte' },
      ],
    },
    image_MSSQL: {
      operators: [
        {
          type: 'comparision',
          name: '_eq',
          operator: '_eq',
          graphqlType: 'image',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gt',
          operator: '_gt',
          graphqlType: 'image',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gte',
          operator: '_gte',
          graphqlType: 'image',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_in',
          operator: '_in',
          graphqlType: '[image!]',
          inputStructure: 'array',
        },
        {
          type: 'is_null',
          name: '_is_null',
          operator: '_is_null',
          graphqlType: 'Boolean',
          inputStructure: 'object',
          inputType: 'boolean',
        },
        {
          type: 'comparision',
          name: '_lt',
          operator: '_lt',
          graphqlType: 'image',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_lte',
          operator: '_lte',
          graphqlType: 'image',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_neq',
          operator: '_neq',
          graphqlType: 'image',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_nin',
          operator: '_nin',
          graphqlType: '[image!]',
          inputStructure: 'array',
        },
        { name: '_ceq', operator: '_ceq' },
        { name: '_cne', operator: '_cne' },
        { name: '_cgt', operator: '_cgt' },
        { name: '_clt', operator: '_clt' },
        { name: '_cgte', operator: '_cgte' },
        { name: '_clte', operator: '_clte' },
      ],
    },
    smalldatetime_MSSQL: {
      operators: [
        {
          type: 'comparision',
          name: '_eq',
          operator: '_eq',
          graphqlType: 'smalldatetime',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gt',
          operator: '_gt',
          graphqlType: 'smalldatetime',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gte',
          operator: '_gte',
          graphqlType: 'smalldatetime',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_in',
          operator: '_in',
          graphqlType: '[smalldatetime!]',
          inputStructure: 'array',
        },
        {
          type: 'is_null',
          name: '_is_null',
          operator: '_is_null',
          graphqlType: 'Boolean',
          inputStructure: 'object',
          inputType: 'boolean',
        },
        {
          type: 'comparision',
          name: '_lt',
          operator: '_lt',
          graphqlType: 'smalldatetime',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_lte',
          operator: '_lte',
          graphqlType: 'smalldatetime',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_neq',
          operator: '_neq',
          graphqlType: 'smalldatetime',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_nin',
          operator: '_nin',
          graphqlType: '[smalldatetime!]',
          inputStructure: 'array',
        },
        { name: '_ceq', operator: '_ceq' },
        { name: '_cne', operator: '_cne' },
        { name: '_cgt', operator: '_cgt' },
        { name: '_clt', operator: '_clt' },
        { name: '_cgte', operator: '_cgte' },
        { name: '_clte', operator: '_clte' },
      ],
    },
    time_MSSQL: {
      operators: [
        {
          type: 'comparision',
          name: '_eq',
          operator: '_eq',
          graphqlType: 'time',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gt',
          operator: '_gt',
          graphqlType: 'time',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gte',
          operator: '_gte',
          graphqlType: 'time',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_in',
          operator: '_in',
          graphqlType: '[time!]',
          inputStructure: 'array',
        },
        {
          type: 'is_null',
          name: '_is_null',
          operator: '_is_null',
          graphqlType: 'Boolean',
          inputStructure: 'object',
          inputType: 'boolean',
        },
        {
          type: 'comparision',
          name: '_lt',
          operator: '_lt',
          graphqlType: 'time',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_lte',
          operator: '_lte',
          graphqlType: 'time',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_neq',
          operator: '_neq',
          graphqlType: 'time',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_nin',
          operator: '_nin',
          graphqlType: '[time!]',
          inputStructure: 'array',
        },
        { name: '_ceq', operator: '_ceq' },
        { name: '_cne', operator: '_cne' },
        { name: '_cgt', operator: '_cgt' },
        { name: '_clt', operator: '_clt' },
        { name: '_cgte', operator: '_cgte' },
        { name: '_clte', operator: '_clte' },
      ],
    },
    uniqueidentifier_MSSQL: {
      operators: [
        {
          type: 'comparision',
          name: '_eq',
          operator: '_eq',
          graphqlType: 'uniqueidentifier',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gt',
          operator: '_gt',
          graphqlType: 'uniqueidentifier',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gte',
          operator: '_gte',
          graphqlType: 'uniqueidentifier',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_in',
          operator: '_in',
          graphqlType: '[uniqueidentifier!]',
          inputStructure: 'array',
        },
        {
          type: 'is_null',
          name: '_is_null',
          operator: '_is_null',
          graphqlType: 'Boolean',
          inputStructure: 'object',
          inputType: 'boolean',
        },
        {
          type: 'comparision',
          name: '_lt',
          operator: '_lt',
          graphqlType: 'uniqueidentifier',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_lte',
          operator: '_lte',
          graphqlType: 'uniqueidentifier',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_neq',
          operator: '_neq',
          graphqlType: 'uniqueidentifier',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_nin',
          operator: '_nin',
          graphqlType: '[uniqueidentifier!]',
          inputStructure: 'array',
        },
        { name: '_ceq', operator: '_ceq' },
        { name: '_cne', operator: '_cne' },
        { name: '_cgt', operator: '_cgt' },
        { name: '_clt', operator: '_clt' },
        { name: '_cgte', operator: '_cgte' },
        { name: '_clte', operator: '_clte' },
      ],
    },
    varbinary_MSSQL: {
      operators: [
        {
          type: 'comparision',
          name: '_eq',
          operator: '_eq',
          graphqlType: 'varbinary',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gt',
          operator: '_gt',
          graphqlType: 'varbinary',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gte',
          operator: '_gte',
          graphqlType: 'varbinary',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_in',
          operator: '_in',
          graphqlType: '[varbinary!]',
          inputStructure: 'array',
        },
        {
          type: 'is_null',
          name: '_is_null',
          operator: '_is_null',
          graphqlType: 'Boolean',
          inputStructure: 'object',
          inputType: 'boolean',
        },
        {
          type: 'comparision',
          name: '_lt',
          operator: '_lt',
          graphqlType: 'varbinary',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_lte',
          operator: '_lte',
          graphqlType: 'varbinary',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_neq',
          operator: '_neq',
          graphqlType: 'varbinary',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_nin',
          operator: '_nin',
          graphqlType: '[varbinary!]',
          inputStructure: 'array',
        },
        { name: '_ceq', operator: '_ceq' },
        { name: '_cne', operator: '_cne' },
        { name: '_cgt', operator: '_cgt' },
        { name: '_clt', operator: '_clt' },
        { name: '_cgte', operator: '_cgte' },
        { name: '_clte', operator: '_clte' },
      ],
    },
    integer_mysql8: {
      operators: [
        {
          type: 'comparision',
          name: '_eq',
          operator: '_eq',
          graphqlType: 'integer',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gt',
          operator: '_gt',
          graphqlType: 'integer',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gte',
          operator: '_gte',
          graphqlType: 'integer',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_in',
          operator: '_in',
          graphqlType: '[integer!]',
          inputStructure: 'array',
        },
        {
          type: 'is_null',
          name: '_is_null',
          operator: '_is_null',
          graphqlType: 'Boolean',
          inputStructure: 'object',
          inputType: 'boolean',
        },
        {
          type: 'comparision',
          name: '_lt',
          operator: '_lt',
          graphqlType: 'integer',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_lte',
          operator: '_lte',
          graphqlType: 'integer',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_neq',
          operator: '_neq',
          graphqlType: 'integer',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_nin',
          operator: '_nin',
          graphqlType: '[integer!]',
          inputStructure: 'array',
        },
        { name: '_ceq', operator: '_ceq' },
        { name: '_cne', operator: '_cne' },
        { name: '_cgt', operator: '_cgt' },
        { name: '_clt', operator: '_clt' },
        { name: '_cgte', operator: '_cgte' },
        { name: '_clte', operator: '_clte' },
      ],
    },
    string_mysql8: {
      operators: [
        {
          type: 'comparision',
          name: '_eq',
          operator: '_eq',
          graphqlType: 'string',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gt',
          operator: '_gt',
          graphqlType: 'string',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gte',
          operator: '_gte',
          graphqlType: 'string',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_in',
          operator: '_in',
          graphqlType: '[string!]',
          inputStructure: 'array',
        },
        {
          type: 'is_null',
          name: '_is_null',
          operator: '_is_null',
          graphqlType: 'Boolean',
          inputStructure: 'object',
          inputType: 'boolean',
        },
        {
          type: 'comparision',
          name: '_lt',
          operator: '_lt',
          graphqlType: 'string',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_lte',
          operator: '_lte',
          graphqlType: 'string',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_neq',
          operator: '_neq',
          graphqlType: 'string',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_nin',
          operator: '_nin',
          graphqlType: '[string!]',
          inputStructure: 'array',
        },
        { name: '_ceq', operator: '_ceq' },
        { name: '_cne', operator: '_cne' },
        { name: '_cgt', operator: '_cgt' },
        { name: '_clt', operator: '_clt' },
        { name: '_cgte', operator: '_cgte' },
        { name: '_clte', operator: '_clte' },
      ],
    },
    Int: {
      operators: [
        {
          type: 'comparision',
          name: '_eq',
          operator: '_eq',
          graphqlType: 'Int',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gt',
          operator: '_gt',
          graphqlType: 'Int',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gte',
          operator: '_gte',
          graphqlType: 'Int',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_in',
          operator: '_in',
          graphqlType: '[Int!]',
          inputStructure: 'array',
        },
        {
          type: 'is_null',
          name: '_is_null',
          operator: '_is_null',
          graphqlType: 'Boolean',
          inputStructure: 'object',
          inputType: 'boolean',
        },
        {
          type: 'comparision',
          name: '_lt',
          operator: '_lt',
          graphqlType: 'Int',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_lte',
          operator: '_lte',
          graphqlType: 'Int',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_neq',
          operator: '_neq',
          graphqlType: 'Int',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_nin',
          operator: '_nin',
          graphqlType: '[Int!]',
          inputStructure: 'array',
        },
        { name: '_ceq', operator: '_ceq' },
        { name: '_cne', operator: '_cne' },
        { name: '_cgt', operator: '_cgt' },
        { name: '_clt', operator: '_clt' },
        { name: '_cgte', operator: '_cgte' },
        { name: '_clte', operator: '_clte' },
      ],
    },
    String: {
      operators: [
        {
          type: 'comparision',
          name: '_eq',
          operator: '_eq',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gt',
          operator: '_gt',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_gte',
          operator: '_gte',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'pattern_match',
          name: '_ilike',
          operator: '_ilike',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_in',
          operator: '_in',
          graphqlType: '[String!]',
          inputStructure: 'array',
        },
        {
          type: 'pattern_match',
          name: '_iregex',
          operator: '_iregex',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'is_null',
          name: '_is_null',
          operator: '_is_null',
          graphqlType: 'Boolean',
          inputStructure: 'object',
          inputType: 'boolean',
        },
        {
          type: 'pattern_match',
          name: '_like',
          operator: '_like',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_lt',
          operator: '_lt',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_lte',
          operator: '_lte',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_neq',
          operator: '_neq',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'pattern_match',
          name: '_nilike',
          operator: '_nilike',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'comparision',
          name: '_nin',
          operator: '_nin',
          graphqlType: '[String!]',
          inputStructure: 'array',
        },
        {
          type: 'pattern_match',
          name: '_niregex',
          operator: '_niregex',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'pattern_match',
          name: '_nlike',
          operator: '_nlike',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'pattern_match',
          name: '_nregex',
          operator: '_nregex',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'pattern_match',
          name: '_nsimilar',
          operator: '_nsimilar',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'pattern_match',
          name: '_regex',
          operator: '_regex',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        {
          type: 'pattern_match',
          name: '_similar',
          operator: '_similar',
          graphqlType: 'String',
          inputStructure: 'object',
        },
        { name: '_ceq', operator: '_ceq' },
        { name: '_cne', operator: '_cne' },
        { name: '_cgt', operator: '_cgt' },
        { name: '_clt', operator: '_clt' },
        { name: '_cgte', operator: '_cgte' },
        { name: '_clte', operator: '_clte' },
      ],
    },
  },
  path: ['real_col', '_eq'],
  columns: [
    {
      name: 'id',
      dataType: 'int',
      consoleDataType: 'number',
      nullable: true,
      isPrimaryKey: true,
      graphQLProperties: { name: 'id', scalarType: 'Int' },
    },
    {
      name: 'varchar_col',
      dataType: 'varchar',
      consoleDataType: 'string',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'varchar_col', scalarType: 'String' },
    },
    {
      name: 'nvarchar_col',
      dataType: 'nvarchar',
      consoleDataType: 'string',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'nvarchar_col', scalarType: 'String' },
    },
    {
      name: 'char_col',
      dataType: 'char',
      consoleDataType: 'string',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'char_col', scalarType: 'String' },
    },
    {
      name: 'nchar_col',
      dataType: 'nchar',
      consoleDataType: 'string',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'nchar_col', scalarType: 'String' },
    },
    {
      name: 'text_col',
      dataType: 'text',
      consoleDataType: 'string',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'text_col', scalarType: 'String' },
    },
    {
      name: 'ntext_col',
      dataType: 'ntext',
      consoleDataType: 'string',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'ntext_col', scalarType: 'String' },
    },
    {
      name: 'int_col',
      dataType: 'int',
      consoleDataType: 'number',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'int_col', scalarType: 'Int' },
    },
    {
      name: 'bigint_col',
      dataType: 'bigint',
      consoleDataType: 'number',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'bigint_col', scalarType: 'Int' },
    },
    {
      name: 'smallint_col',
      dataType: 'smallint',
      consoleDataType: 'number',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'smallint_col', scalarType: 'Int' },
    },
    {
      name: 'tinyint_col',
      dataType: 'tinyint',
      consoleDataType: 'string',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'tinyint_col', scalarType: 'Int' },
    },
    {
      name: 'bit_col',
      dataType: 'bit',
      consoleDataType: 'number',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'bit_col', scalarType: 'Boolean' },
    },
    {
      name: 'decimal_col',
      dataType: 'decimal',
      consoleDataType: 'number',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'decimal_col', scalarType: 'Float' },
    },
    {
      name: 'numeric_col',
      dataType: 'numeric',
      consoleDataType: 'number',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'numeric_col', scalarType: 'Float' },
    },
    {
      name: 'float_col',
      dataType: 'float',
      consoleDataType: 'number',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'float_col', scalarType: 'Float' },
    },
    {
      name: 'real_col',
      dataType: 'real',
      consoleDataType: 'number',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'real_col', scalarType: 'Float' },
    },
    {
      name: 'date_col',
      dataType: 'date',
      consoleDataType: 'string',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'date_col', scalarType: 'date' },
    },
    {
      name: 'datetime_col',
      dataType: 'datetime',
      consoleDataType: 'string',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'datetime_col', scalarType: 'datetime' },
    },
    {
      name: 'smalldatetime_col',
      dataType: 'smalldatetime',
      consoleDataType: 'string',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: {
        name: 'smalldatetime_col',
        scalarType: 'smalldatetime',
      },
    },
    {
      name: 'datetime2_col',
      dataType: 'datetime2',
      consoleDataType: 'string',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'datetime2_col', scalarType: 'datetime2' },
    },
    {
      name: 'time_col',
      dataType: 'time',
      consoleDataType: 'string',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'time_col', scalarType: 'time' },
    },
    {
      name: 'uniqueidentifier_col',
      dataType: 'uniqueidentifier',
      consoleDataType: 'string',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: {
        name: 'uniqueidentifier_col',
        scalarType: 'uniqueidentifier',
      },
    },
    {
      name: 'binary_col',
      dataType: 'binary',
      consoleDataType: 'string',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'binary_col', scalarType: 'binary' },
    },
    {
      name: 'varbinary_col',
      dataType: 'varbinary',
      consoleDataType: 'string',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'varbinary_col', scalarType: 'varbinary' },
    },
    {
      name: 'image_col',
      dataType: 'image',
      consoleDataType: 'string',
      nullable: true,
      isPrimaryKey: false,
      graphQLProperties: { name: 'image_col', scalarType: 'image' },
    },
  ],
  tables: [
    {
      table: { name: 'ExampleTable', schema: 'dbo' },
      dataSource: {
        name: 'mssql',
        kind: 'mssql',
        tables: [
          {
            table: { name: 'ExampleTable', schema: 'dbo' },
            insert_permissions: [
              {
                role: 'user',
                permission: {
                  check: { varchar_col: { _eq: 'X-Hasura-User-Id' } },
                  columns: [
                    'id',
                    'varchar_col',
                    'nvarchar_col',
                    'char_col',
                    'nchar_col',
                    'text_col',
                    'ntext_col',
                    'int_col',
                    'bigint_col',
                    'smallint_col',
                    'tinyint_col',
                    'bit_col',
                    'decimal_col',
                    'numeric_col',
                    'float_col',
                    'real_col',
                    'date_col',
                    'datetime_col',
                    'smalldatetime_col',
                    'datetime2_col',
                    'time_col',
                    'uniqueidentifier_col',
                    'binary_col',
                    'varbinary_col',
                    'image_col',
                  ],
                },
              },
            ],
            select_permissions: [
              {
                role: 'user',
                permission: {
                  columns: ['id', 'varchar_col'],
                  filter: { ntext_col: { _like: 'X-Hasura-User-Id' } },
                },
              },
            ],
          },
        ],
        configuration: {
          connection_info: {
            connection_string:
              'Driver={ODBC Driver 18 for SQL Server};Server=mssql,1433;Database=Chinook;UID=sa;PWD=Password!;Encrypt=yes;TrustServerCertificate=yes;ConnectionTimeout=30;',
            pool_settings: {
              idle_timeout: 5,
              max_connections: null,
              total_max_connections: null,
            },
          },
        },
      },
      relationships: [],
      columns: [
        {
          name: 'id',
          dataType: 'int',
          consoleDataType: 'number',
          nullable: true,
          isPrimaryKey: true,
          graphQLProperties: { name: 'id', scalarType: 'Int' },
        },
        {
          name: 'varchar_col',
          dataType: 'varchar',
          consoleDataType: 'string',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'varchar_col', scalarType: 'String' },
        },
        {
          name: 'nvarchar_col',
          dataType: 'nvarchar',
          consoleDataType: 'string',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'nvarchar_col', scalarType: 'String' },
        },
        {
          name: 'char_col',
          dataType: 'char',
          consoleDataType: 'string',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'char_col', scalarType: 'String' },
        },
        {
          name: 'nchar_col',
          dataType: 'nchar',
          consoleDataType: 'string',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'nchar_col', scalarType: 'String' },
        },
        {
          name: 'text_col',
          dataType: 'text',
          consoleDataType: 'string',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'text_col', scalarType: 'String' },
        },
        {
          name: 'ntext_col',
          dataType: 'ntext',
          consoleDataType: 'string',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'ntext_col', scalarType: 'String' },
        },
        {
          name: 'int_col',
          dataType: 'int',
          consoleDataType: 'number',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'int_col', scalarType: 'Int' },
        },
        {
          name: 'bigint_col',
          dataType: 'bigint',
          consoleDataType: 'number',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'bigint_col', scalarType: 'Int' },
        },
        {
          name: 'smallint_col',
          dataType: 'smallint',
          consoleDataType: 'number',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'smallint_col', scalarType: 'Int' },
        },
        {
          name: 'tinyint_col',
          dataType: 'tinyint',
          consoleDataType: 'string',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'tinyint_col', scalarType: 'Int' },
        },
        {
          name: 'bit_col',
          dataType: 'bit',
          consoleDataType: 'number',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'bit_col', scalarType: 'Boolean' },
        },
        {
          name: 'decimal_col',
          dataType: 'decimal',
          consoleDataType: 'number',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'decimal_col', scalarType: 'Float' },
        },
        {
          name: 'numeric_col',
          dataType: 'numeric',
          consoleDataType: 'number',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'numeric_col', scalarType: 'Float' },
        },
        {
          name: 'float_col',
          dataType: 'float',
          consoleDataType: 'number',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'float_col', scalarType: 'Float' },
        },
        {
          name: 'real_col',
          dataType: 'real',
          consoleDataType: 'number',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'real_col', scalarType: 'Float' },
        },
        {
          name: 'date_col',
          dataType: 'date',
          consoleDataType: 'string',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'date_col', scalarType: 'date' },
        },
        {
          name: 'datetime_col',
          dataType: 'datetime',
          consoleDataType: 'string',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'datetime_col', scalarType: 'datetime' },
        },
        {
          name: 'smalldatetime_col',
          dataType: 'smalldatetime',
          consoleDataType: 'string',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: {
            name: 'smalldatetime_col',
            scalarType: 'smalldatetime',
          },
        },
        {
          name: 'datetime2_col',
          dataType: 'datetime2',
          consoleDataType: 'string',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'datetime2_col', scalarType: 'datetime2' },
        },
        {
          name: 'time_col',
          dataType: 'time',
          consoleDataType: 'string',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'time_col', scalarType: 'time' },
        },
        {
          name: 'uniqueidentifier_col',
          dataType: 'uniqueidentifier',
          consoleDataType: 'string',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: {
            name: 'uniqueidentifier_col',
            scalarType: 'uniqueidentifier',
          },
        },
        {
          name: 'binary_col',
          dataType: 'binary',
          consoleDataType: 'string',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'binary_col', scalarType: 'binary' },
        },
        {
          name: 'varbinary_col',
          dataType: 'varbinary',
          consoleDataType: 'string',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'varbinary_col', scalarType: 'varbinary' },
        },
        {
          name: 'image_col',
          dataType: 'image',
          consoleDataType: 'string',
          nullable: true,
          isPrimaryKey: false,
          graphQLProperties: { name: 'image_col', scalarType: 'image' },
        },
      ],
    },
  ],
  table: { name: 'ExampleTable', schema: 'dbo' },
} as GetDataTypeOperatorsProps;
